--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Minimap";
module.lname = SC_MODULE_MINIMAP;
module.version = 1.113;
module.info = SC_MODULE_MINIMAP_INFO;

RegisterModule(module);


--======
--Locals
--======

local MinimapElements = { };
local Redraw = true;

-- All local functions
local DropHide,
      MinimapUpdate,
      Dragging,
      DropDown_Place,
      DropDown_Horde,
      DropDown_Alliance,
      CreateSecureSpellButton,
      CreatePortalButton,
      CreatePortalMenu,
      Create,
      CreateHearth,
      CreateRunes,
      UpdateRunes;

--===========
--The Minimap
--===========

DropHide = function()
  SC_Minimap_Drop:Hide();
end

MinimapUpdate = function()
  local button = SC_Minimap_Button;
  button:ClearAllPoints();
  button:SetPoint("CENTER", "Minimap", "CENTER",
      config.Minimap.button.position.radius * 
      math.cos(config.Minimap.button.position.degree),
      config.Minimap.button.position.radius *
      math.sin(config.Minimap.button.position.degree));
  button:SetUserPlaced(false);
  DropDown_Place();
end

Dragging = function()
  local Minimap, button, math = _G.Minimap, SC_Minimap_Button, math;
  local size, x, y = Minimap:GetHeight() / 2, GetCursorPosition();

  button:ClearAllPoints();

  x = -(-(x / UIParent:GetScale()) + Minimap:GetLeft() + size);
  y = y / UIParent:GetScale() - Minimap:GetBottom() - size;

  -- Snapping to Minimap
  config.Minimap.button.position.radius =
      math.pow((math.pow(x, 2) + math.pow(y, 2)), 0.5);

  if config.Minimap.button.position.radius < size + 15 and
     size - 15 < config.Minimap.button.position.radius then
    config.Minimap.button.position.radius = size + 10;
  end
  if config.Minimap.button.position.radius < size + 75 and
     size + 45 < config.Minimap.button.position.radius then
    config.Minimap.button.position.radius = size + 50;
  end

  config.Minimap.button.position.degree = math.atan2(y, x);-- In Radians

  MinimapUpdate();
end

DropDown_Place = function()
  local drop, button = SC_Minimap_Drop, SC_Minimap_Button;
  if not drop then return end
  local y, z = tonumber(button:GetBottom()), tonumber(drop:GetHeight());
  drop:ClearAllPoints();
  if y and z and y - z < 100 then --UIParent:GetBottom() + 50 then
    drop:SetPoint("BOTTOMRIGHT", button, -20, 20);
    SC_Minimap:SetPoint("CENTER", button, "CENTER", 0, 100);
  else
    drop:SetPoint("TOPRIGHT", button, -20, -20);
    SC_Minimap:SetPoint("CENTER", button, "CENTER", 0, -100);
  end
end

DropDown_Horde = function(level)
  local drop, fs = SC_Minimap_Drop;
  if level > 64 then
    CreatePortalButton("SC_Minimap_Drop_PortalFive",
      drop, 30, 30,
      SC_SPELL_PORTAL_SHATTRATH,
      "Interface\\Icons\\Spell_Arcane_PortalShattrath", "TOPRIGHT", -45, -365);
  end
  if level > 59 then
    fs = drop:CreateFontString("SC_Minimap_Drop_Note2", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -330);
    fs:SetText("|cFFAAAAFF"..SC_MINIMAP_GENERALPORT.."|r");

    fs = drop:CreateFontString("SC_Minimap_Drop_Shattrath", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -340);
    fs:SetText("|cFFFFFF00"..SC_CITY_SHATTRATH.."|r");

    CreatePortalButton("SC_Minimap_Drop_TeleportFive",
      drop, 30, 30,
      SC_SPELL_TELEPORT_SHATTRATH,
      "Interface\\Icons\\Spell_Arcane_TeleportShattrath", "TOPLEFT", 45, -365);
  else
    drop:SetHeight(330);
  end
  if level > 49 then
    CreatePortalButton("SC_Minimap_Drop_PortalFour",
      drop, 30, 30,
      SC_SPELL_PORTAL_THUNDER,
      "Interface\\Icons\\Spell_Arcane_PortalThunderBluff", "TOPRIGHT", -45,
      -250);
  end
  if level > 39 then
    CreatePortalButton("SC_Minimap_Drop_PortalOne",
      drop, 30, 30,
      SC_SPELL_PORTAL_ORGRIMMAR,
      "Interface\\Icons\\Spell_Arcane_PortalOrgrimmar", "TOPRIGHT", -45, -100);
    CreatePortalButton("SC_Minimap_Drop_PortalTwo",
      drop, 30, 30,
      SC_SPELL_PORTAL_UNDERCITY,
      "Interface\\Icons\\Spell_Arcane_PortalUndercity", "TOPRIGHT", -45, -150);
    CreatePortalButton("SC_Minimap_Drop_PortalThree",
      drop, 30, 30,
      SC_SPELL_PORTAL_SILVERMOON,
      "Interface\\Icons\\Spell_Arcane_PortalSilvermoon", "TOPRIGHT", -45, -200);
  end 
  
  if level > 34 then
    fs = drop:CreateFontString("SC_Minimap_Drop_City5", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -275);
    fs:SetText("|cFFFFFF00"..SC_CITY_HORDE_STONARD.."|r");
     CreatePortalButton("SC_Minimap_Drop_PortalSix",
      drop, 30, 30,
      SC_SPELL_PORTAL_STONARD,
      "Interface\\Icons\\Spell_Arcane_PortalStonard", "TOPRIGHT", -45, -300);
	  CreatePortalButton("SC_Minimap_Drop_TeleportSix",
      drop, 30, 30,
      SC_SPELL_TELEPORT_STONARD,
      "Interface\\Icons\\Spell_Arcane_TeleportStonard", "TOPLEFT", 45, -300);
  else
    drop:SetHeight(280);
  end
  
  if level > 29 then
    fs = drop:CreateFontString("SC_Minimap_Drop_City4", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -225);
    fs:SetText("|cFFFFFF00"..SC_CITY_HORDE_THUNDER.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportFour",
      drop, 30, 30,
      SC_SPELL_TELEPORT_THUNDER,
      "Interface\\Icons\\Spell_Arcane_TeleportThunderBluff", "TOPLEFT", 45,
        -250);
  else
    drop:SetHeight(230);
  end
  if level > 19 then
    fs = drop:CreateFontString("SC_Minimap_Drop_City1", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -75);
    fs:SetText("|cFFFFFF00"..SC_CITY_HORDE_ORGRIMMAR.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportOne",
      drop, 30, 30,
      SC_SPELL_TELEPORT_ORGRIMMAR,
      "Interface\\Icons\\Spell_Arcane_TeleportOrgrimmar", "TOPLEFT", 45, -100);
    fs = drop:CreateFontString("SC_Minimap_Drop_City2", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -125);
    fs:SetText("|cFFFFFF00"..SC_CITY_HORDE_UNDERCITY.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportTwo",
      drop, 30, 30,
      SC_SPELL_TELEPORT_UNDERCITY,
      "Interface\\Icons\\Spell_Arcane_TeleportUndercity", "TOPLEFT", 45, -150);
    fs = drop:CreateFontString("SC_Minimap_Drop_City3", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -175);
    fs:SetText("|cFFFFFF00"..SC_CITY_HORDE_SILVERMOON.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportThree",
      drop, 30, 30,
      SC_SPELL_TELEPORT_SILVERMOON,
      "Interface\\Icons\\Spell_Arcane_TeleportSilvermoon", "TOPLEFT", 45, -200);

    fs = drop:CreateFontString("SC_Minimap_Drop_Note", "ARTWORK",
        "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -65);
    SC_Minimap_Drop_Note:SetText("|cFFAAAAFF"..SC_MINIMAP_HORDEPORT.."|r");
  else
    drop:SetHeight(70);
  end
  DropDown_Alliance = nil
  DropDown_Horde = nil
end

DropDown_Alliance = function(level)
  local drop, fs = SC_Minimap_Drop;
  if level > 64 then
    CreatePortalButton("SC_Minimap_Drop_PortalFive",
      drop, 30, 30,
      SC_SPELL_PORTAL_SHATTRATH,
      "Interface\\Icons\\Spell_Arcane_PortalShattrath", "TOPRIGHT", -45, -365);
  end
  if level > 59 then
    fs = drop:CreateFontString("SC_Minimap_Drop_Note2", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -330);
    fs:SetText("|cFFAAAAFF"..SC_MINIMAP_GENERALPORT.."|r");

    fs = drop:CreateFontString("SC_Minimap_Drop_Shattrath", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -340);
    fs:SetText("|cFFFFFF00"..SC_CITY_SHATTRATH.."|r");

    CreatePortalButton("SC_Minimap_Drop_TeleportFive",
      drop, 30, 30,
      SC_SPELL_TELEPORT_SHATTRATH,
      "Interface\\Icons\\Spell_Arcane_TeleportShattrath", "TOPLEFT", 45, -365);
  else
    drop:SetHeight(330);
  end
  if level > 49 then
    CreatePortalButton("SC_Minimap_Drop_PortalFour",
      drop, 30, 30,
      SC_SPELL_PORTAL_DARNASSUS,
      "Interface\\Icons\\Spell_Arcane_PortalDarnassus", "TOPRIGHT", -45, -250);
  end
  if level > 39 then
    CreatePortalButton("SC_Minimap_Drop_PortalOne",
      drop, 30, 30,
      SC_SPELL_PORTAL_STORMWIND,
      "Interface\\Icons\\Spell_Arcane_PortalStormwind", "TOPRIGHT", -45, -100);
    CreatePortalButton("SC_Minimap_Drop_PortalTwo",
      drop, 30, 30,
      SC_SPELL_PORTAL_IRONFORGE,
      "Interface\\Icons\\Spell_Arcane_PortalIronforge", "TOPRIGHT", -45, -150);
    CreatePortalButton("SC_Minimap_Drop_PortalThree",
      drop, 30, 30,
      SC_SPELL_PORTAL_EXODAR,
      "Interface\\Icons\\Spell_Arcane_PortalExodar", "TOPRIGHT", -45, -200);
  end
  
  if level > 34 then
    fs = drop:CreateFontString("SC_Minimap_Drop_City5", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -275);
    fs:SetText("|cFFFFFF00"..SC_CITY_ALLIANCE_THERAMORE.."|r");
     CreatePortalButton("SC_Minimap_Drop_PortalSix",
      drop, 30, 30,
      SC_SPELL_PORTAL_THERAMORE,
      "Interface\\Icons\\Spell_Arcane_PortalTheramore", "TOPRIGHT", -45, -300);
	  CreatePortalButton("SC_Minimap_Drop_TeleportSix",
      drop, 30, 30,
      SC_SPELL_TELEPORT_THERAMORE,
      "Interface\\Icons\\Spell_Arcane_TeleportTheramore", "TOPLEFT", 45, -300);
  else
    drop:SetHeight(280);
  end
  
  if level > 29 then
    fs = drop:CreateFontString("SC_Minimap_Drop_City4", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -225);
    fs:SetText("|cFFFFFF00"..SC_CITY_ALLIANCE_DARNASSUS.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportFour",
      drop, 30, 30,
      SC_SPELL_TELEPORT_DARNASSUS,
      "Interface\\Icons\\Spell_Arcane_TeleportDarnassus", "TOPLEFT", 45, -250);
  else
    drop:SetHeight(230);
  end
  if level > 19 then
    fs = drop:CreateFontString("SC_Minimap_Drop_City1", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -75);
    fs:SetText("|cFFFFFF00"..SC_CITY_ALLIANCE_STORMWIND.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportOne",
      drop, 30, 30,
      SC_SPELL_TELEPORT_STORMWIND,
      "Interface\\Icons\\Spell_Arcane_TeleportStormwind", "TOPLEFT", 45, -100);
    fs = drop:CreateFontString("SC_Minimap_Drop_City2", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -125);
    fs:SetText("|cFFFFFF00"..SC_CITY_ALLIANCE_IRONFORGE.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportTwo",
      drop, 30, 30,
      SC_SPELL_TELEPORT_IRONFORGE,
      "Interface\\Icons\\Spell_Arcane_TeleportIronforge", "TOPLEFT", 45, -150);
    fs = drop:CreateFontString("SC_Minimap_Drop_City3", "ARTWORK",
      "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -175);
    fs:SetText("|cFFFFFF00"..SC_CITY_ALLIANCE_EXODAR.."|r");
    CreatePortalButton("SC_Minimap_Drop_TeleportThree",
      drop, 30, 30,
      SC_SPELL_TELEPORT_EXODAR,
      "Interface\\Icons\\Spell_Arcane_TeleportExodar", "TOPLEFT", 45, -200);

    fs = drop:CreateFontString("SC_Minimap_Drop_Note", "ARTWORK",
        "GameFontNormalSmall");
    fs:SetPoint("CENTER", drop, "TOP", 0, -65);
    SC_Minimap_Drop_Note:SetText("|cFFAAAAFF"..SC_MINIMAP_ALLIANCEPORT.."|r");
  else
    drop:SetHeight(70);
  end
  DropDown_Alliance = nil
  DropDown_Horde = nil
end

CreateRunes = function(level)
  local drop, fs = SC_Minimap_Drop;
  if level > 39 then
    fs = drop:CreateFontString("SC_Minimap_Drop_RunesPortal", "ARTWORK",
        "GameFontNormalSmall");
    fs:SetPoint("RIGHT", drop, "TOPRIGHT", -5, -25);
    fs:SetTextColor(1, 0, 0);
    fs:SetFont(fs:GetFont(), 10); -- Resizing to 10
    fs:SetText("Portals");

    fs = drop:CreateFontString("SC_Minimap_Drop_RunesPortalNum", "ARTWORK",
        "GameFontNormalLarge");
    fs:SetPoint("RIGHT", drop, "TOPRIGHT", -25, -45);
    fs:SetTextColor(.6, 0, 1);
  end
  if level > 19 then
    fs = drop:CreateFontString("SC_Minimap_Drop_RunesTeleport", "ARTWORK",
        "GameFontNormalSmall");
    fs:SetPoint("LEFT", drop, "TOPLEFT", 5, -25);
    fs:SetTextColor(1, 0, 0);
    fs:SetFont(fs:GetFont(), 10); -- Resizing to 10
    fs:SetText("Teleports");

    fs = drop:CreateFontString("SC_Minimap_Drop_RunesTeleportNum", "ARTWORK",
        "GameFontNormalLarge");
    fs:SetPoint("LEFT", drop, "TOPLEFT", 25, -45);
    fs:SetTextColor(.6, 0, 1);

    SC_RegEvent(module, "BAG_UPDATE");
    UpdateRunes();
  else
    UpdateRunes = nil;
  end
  CreateRunes = nil;
end

UpdateRunes = function()
  local teleport, portal, num, link = 0, 0;
  for bag = 0, 4 do
    for slot = 1, GetContainerNumSlots(bag) do
      link = GetContainerItemLink(bag, slot) or "";
      if string.find(link, SC_REAGENT_MAGE_TELE) then
        _, num = GetContainerItemInfo(bag, slot);
        teleport = teleport + num;
      elseif string.find(link, SC_REAGENT_MAGE_PORT) then
        _, num = GetContainerItemInfo(bag, slot);
        portal = portal + num;
      end  
    end
  end
  SC_Minimap_Drop_RunesTeleportNum:SetText(teleport);
  if SC_Minimap_Drop_RunesPortalNum then
    SC_Minimap_Drop_RunesPortalNum:SetText(portal);
  end
end

CreateSecureSpellButton = function(Name, Parent, SizeX, SizeY, Spell,
    Texture, Anchor, ax, ay)
  local x = CreateSecureButton(Name, Parent, SizeX, SizeY, Anchor, ax, ay);
  x:SetNormalTexture(Texture);
  x:SetAttribute("type", "spell");
  x:SetAttribute("spell1", Spell);
  return x;
end

CreatePortalButton = function(Name, Parent, SizeX, SizeY, Spell, Texture,
    Anchor, ax, ay, PostClick)
  local x = CreateSecureSpellButton(Name, Parent, SizeX, SizeY, Spell,
    Texture, Anchor, ax, ay);
  x:SetScript("PostClick", DropHide);
  x:SetHighlightTexture("Interface/Minimap/UI-Minimap-ZoomButton-Highlight");
  return x;
end

CreateHearth = function()
  local drop = SC_Minimap_Drop;
  local fs = drop:CreateFontString("SC_Minimap_Drop_HearthString", "ARTWORK",
      "GameFontNormalSmall");
  fs:SetPoint("CENTER", drop, "TOP", 0, -10);
  fs:SetTextColor(0, 1, 0);
  fs:SetText(SC_HEARTH);
  local hearth = CreateSecureButton("SC_Minimap_Drop_Hearth", drop, 30, 30,
      "TOP", 0, -40, "Interface/Icons/INV_Misc_Rune_01");
  hearth:SetFrameLevel(3);
  hearth:SetFrameStrata("MEDIUM");
  hearth:SetAttribute("type", "item");
  hearth:SetAttribute("item1", "item:6948");
  hearth:SetHighlightTexture(
      "Interface/Minimap/UI-Minimap-ZoomButton-Highlight");
  hearth:SetScript("OnEnter", function(self)
    local st, dur = GetItemCooldown("item:6948");
    local time = (dur - GetTime() + st) / 60;
    GameTooltip:SetOwner(self, "ANCHOR_LEFT");
    GameTooltip:SetText(string.format("%s\n %s %d %s",
        SC_TIME_REMAINING, SC_HEARTH, time > 0 and time or 0, MINUTES));
    GameTooltip:Show();
  end);
  hearth:SetScript("OnLeave", function() GameTooltip:Hide() end);
  hearth:SetScript("PostClick", DropHide);

  CreateHearth = nil;
end

CreatePortalMenu = function(level)
  -- Portal Drop Down Menu
  local drop = CreateFrame("Frame", "SC_Minimap_Drop", SC_Minimap,
    "SecureFrameTemplate");
  drop:SetWidth(150);
  drop:SetHeight(400);
  drop:SetFrameStrata("MEDIUM");
  drop:SetBackdrop({
    bgFile = "Interface/TutorialFrame/TutorialFrameBackground",
    edgeFile = "Interface/DialogFrame/UI-DialogBox-Border",
    tile = true,
    tileSize = 32,
    edgeSize = 16,
    insets = { left = 5, right = 5, top = 5, bottom = 5 }
  });
  drop:ClearAllPoints();
  drop:SetPoint("TOPRIGHT", SC_Minimap_Button, "BOTTOMLEFT", -5, -5);
  drop:Hide();

  drop:SetScript("OnShow", function(self)
    DropDown_Place();
  end);

  CreateHearth();

  -- Placing Spell Buttons
  if UnitFactionGroup("player") == "Alliance" then
    DropDown_Alliance(level);
  else
    DropDown_Horde(level);
  end

  CreateRunes(level);

  CreatePortalMenu = nil;
end

Create = function(level)
  local UIParent = UIParent;
  -- Top Level Frame
  local map = CreateFrame("Frame", "SC_Minimap", UIParent,
    "SecureFrameTemplate");
  SC_Minimap = SC_Minimap; -- Putting it in this environment
  map:SetWidth(350);
  map:SetHeight(550);
  map:SetFrameStrata("BACKGROUND");
  map:SetFrameLevel(1);

  -- Actual Button
  local button = CreateFrame("Button", "SC_Minimap_Button", SC_Minimap,
      "SecureActionButtonTemplate");
  SC_Minimap_Button = SC_Minimap_Button; -- Putting it in this environment
  button:SetFrameStrata("LOW");
  button:SetFrameLevel(3);
  button:RegisterForClicks("LeftButtonDown");
  button:RegisterForDrag("RightButton");
  button.drag = false;
  button:SetMovable(true);
  button:SetHeight(25);
  button:SetWidth(25);
  button:SetNormalTexture("Interface\\AddOns\\Spellcraft\\images\\SC.tga");
  button:SetHighlightTexture(
    "Interface/Minimap/UI-Minimap-ZoonButton-Highlight");

  map:SetPoint("CENTER", SC_Minimap_Button, "CENTER", 0, -100);

  --Hides all buttons on Enter
  frame = CreateFrame("Frame", "SC_Minimap_Frame", UIParent);
  SC_Minimap_Frame = SC_Minimap_Frame;
  frame:SetWidth(UIParent:GetWidth())
  frame:SetHeight(UIParent:GetHeight());
  frame:SetFrameStrata("BACKGROUND");
  frame:SetFrameLevel(1);
  frame:SetPoint("CENTER", UIParent, "CENTER");
  frame:SetScript("OnEnter", function()
    for _,v in pairs(MinimapElements) do
      UIFrameFadeOut(v, 100, 100, 0);
      v:Hide();
    end
    map:EnableMouse(0);
    frame:EnableMouse(0);
    if SC_Minimap_Drop then SC_Minimap_Drop:Hide(); end
    Redraw = true;
  end);

  local tex = button:CreateTexture("SC_Minimap_ButtonOverlay", "OVERLAY");
  tex:SetTexture("Interface/Minimap/MiniMap-TrackingBorder");
  tex:SetPoint("TOPLEFT", button, "TOPLEFT", -10, 8);
  tex:SetWidth(70);
  tex:SetHeight(70);

  CreatePortalMenu(level);

  button:SetScript("OnEnter", function(self)
    map:EnableMouse(1);
    frame:EnableMouse(1);
    for _,v in pairs(MinimapElements) do
      if Redraw then UIFrameFadeIn(v, 100, 0, 100); end
      v:Show();
    end
    Redraw = false;
    GameTooltip:SetOwner(self, "ANCHOR_LEFT");
    GameTooltip:SetText(SC_MINIMAP_TOOLTIP);
    GameTooltip:Show();
  end);
  button:SetScript("OnLeave", function(self)
    GameTooltip:Hide();
  end);
  button:SetScript("OnDragStart", function(self)
    self.drag = true;
  end);
  button:SetScript("OnDragStop", function(self)
    self.drag = false;
  end);
  button:SetScript("OnUpdate", function(self)
    if self.drag then
      Dragging();
    end
  end);
  button:SetScript("OnClick", function()
    if not SC_Minimap_Drop then return end
    if SC_Minimap_Drop:IsVisible() then
      SC_Minimap_Drop:Hide();
    else
      if InCombatLockdown() then
        error(SC_MSG_TELEPORT_ERROR);
        return;
      end
      SC_Minimap_Drop:Show();
    end
  end);

  MinimapUpdate();
  
  if button:GetRight() <= UIParent:GetLeft() or
      button:GetLeft() >= UIParent:GetRight() or
      button:GetBottom() >= UIParent:GetTop() or
      button:GetTop() <= UIParent:GetBottom() then
   button:ClearAllPoints();
   button:SetPoint("CENTER", UIParent, "CENTER"); 
  end

  Create = nil;
end


--=========
--Functions
--=========

function AddMinimapElement(object)
  table.insert(MinimapElements, object);
end


--================
--Module Functions
--================

function Load()
  SC_RegEvent(module, "PLAYER_ENTERING_WORLD");
end

function Defaults()
  config.Minimap = {load = true, hearth = true};
  config.Minimap.button = { };
  config.Minimap.button.position = { };
  config.Minimap.button.position.degree = -1.3678;--Defaults
  config.Minimap.button.position.radius = 119.9999;
end

  --==============
  --Event Handlers
  --==============

function PLAYER_ENTERING_WORLD()
  Player();
  if player.class ~= "Mage" then
    UnregisterModule(module);
    return;
  end
  if Create then
    Create(player.level);
  else
    MinimapUpdate();
  end
end

function BAG_UPDATE()
  UpdateRunes();
end
