--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Invisibility";
module.lname = SC_MODULE_INVISIBILITY;
module.version = 1.115;
module.info = SC_MODULE_INVISIBILITY_INFO;

RegisterModule(module);

--======
--Locals
--======

-- Private Variables go here.
local player = player;
local invisible = false;
local gear = { };

--=====================
--Invisibility Handling
--=====================

local function GetNaked()
  if InCombatLockdown() then 
    error(SC_MSG_NAKED_ERROR, 1.0, 0, 0, 1.0);
    return false;
  end
  print(SC_MSG_WIPE, 0, 0, 1.0, 1.0);
  local item = 1;
  for bag = 0, 4 do
    for slot = 1, GetContainerNumSlots(bag) do
      if not GetContainerItemLink(bag, slot) then
        ClearCursor();
        if GetInventoryItemLink("player",item) then
          PickupInventoryItem(item);
          PickupContainerItem(bag, slot);
          gear[item] = {bag, slot};
        end
        item = item + 1;
        while item == 2 or item == 4 or item == 11 or item == 12 or 
           item == 13 or item == 14 or item == 15 or item == 17 do
          item = item + 1;
        end
        ClearCursor();
        if item > 18 then
          return true;
        end
      end
    end
  end
  return true;
end

local function GearOn()
  if InCombatLockdown() then
    error(SC_MSG_EQUIP_ERROR, 1.0, 0, 0, 1.0);
    return false;
  end
  ClearCursor();
  if gear then
    for i in pairs(gear) do
      PickupContainerItem(gear[i][1], gear[i][2]);
      PickupInventoryItem(i);
      ClearCursor();
    end
  end
  return true;
end


--=====================
--UI Creation Functions
--=====================

-- These functions are recycled immediately after use.

local function MakeGearOn()
  local on = CreateFrame("Frame", "SC_GearOn", UIParent);
  on:SetHeight(75);
  on:SetWidth(230);
  on:SetPoint("TOP", UIParent, "TOP");
  on:SetBackdrop({
    bgFile = "Interface/TutorialFrame/TutorialFrameBackground",
    edgeFile = "Interface/DialogFrame/UI-DialogBox-Border",
    tile = true,
    tileSize = 32,
    edgeSize = 16,
    insets = { left = 5, right = 5, top = 5, bottom = 5 }
  });

  local fs = on:CreateFontString("EquipGearQuery1", "ARTWORK",
    "ChatFontNormal");
  fs:SetText(SC_INVIS_GEARON);
  fs:SetPoint("CENTER", on, "TOP", 0, -15);

  fs = on:CreateFontString("EquipGearQuery2", "ARTWORK", "ChatFontNormal");
  fs:SetText(SC_INVIS_GEARON2);
  fs:SetPoint("CENTER", on, "BOTTOM", 0, 15);

  local yes = CreateFrame("Button", "SC_GearOn_Yes", SC_GearOn,
    "OptionsButtonTemplate");
  yes:SetPoint("CENTER", SC_GearOn, "CENTER", -45, 0);
  yes:SetScript("OnClick", function()
    if GearOn() then
      SC_GearOn:Hide();
    end
  end);
  yes:SetText(YES);

  local hide = CreateFrame("Button", "SC_GearOn_Hide", SC_GearOn,
    "OptionsButtonTemplate");
  hide:SetPoint("CENTER", SC_GearOn, "Center", 45, 0);
  hide:SetScript("OnClick", function()
    SC_GearOn:Hide();
  end);
  hide:SetText(HIDE);

  local close = CreateFrame("Button", "SC_GearOn_Close", SC_GearOn,
    "UIPanelCloseButton");
  close:SetPoint("TOPRIGHT", SC_GearOn, "TOPRIGHT");
  close:SetScript("OnClick", function()
    SC_GearOn:Hide();
  end);

  on:Hide();
  MakeGearOn = nil;
end

local function MakeRemoveGear()
  local remove = CreateFrame("Frame", "SC_RemoveGear", UIParent);
  remove:SetHeight(125);
  remove:SetWidth(350);
  remove:SetPoint("CENTER", UIParent, "CENTER");
  remove:SetBackdrop({
    bgFile = "Interface/TutorialFrame/TutorialFrameBackground",
    edgeFile = "Interface/DialogFrame/UI-DialogBox-Border",
    tile = true,
    tileSize = 32,
    edgeSize = 16,
    insets = { left = 5, right = 5, top = 5, bottom = 5 }
  });
  
  local fs = remove:CreateFontString("RemoveGearQuery1", "ARTWORK",
    "ChatFontNormal");
  fs:SetText(SC_INVIS_GEAROFF);
  fs:SetPoint("TOP", remove, "TOP", 0, -10);
  fs:SetWidth(300);
  
  fs = remove:CreateFontString("RemoveGearQuery2", "ARTWORK", "ChatFontNormal");
  fs:SetText(SC_INVIS_GEAROFF2);
  fs:SetPoint("CENTER", remove, "TOP", 0, -50);


  local yes = CreateFrame("Button", "SC_RemoveGear_Yes", SC_RemoveGear,
    "OptionsButtonTemplate");
  yes:SetPoint("BOTTOM", SC_RemoveGear, "BOTTOM", -50, 20);
  yes:SetScript("OnClick", function()
    if GetNaked() then
      SC_RemoveGear:Hide();
    end
    if not SC_GearOn then
      MakeGearOn();
    end
    SC_GearOn:Show();
  end);
  yes:SetText(YES);

  local no = CreateFrame("Button", "SC_RemoveGear_No", SC_RemoveGear,
    "OptionsButtonTemplate");
  no:SetPoint("BOTTOM", SC_RemoveGear, "BOTTOM", 50, 20);
  no:SetScript("OnClick", function()
    SC_RemoveGear:Hide();
  end);
  no:SetText(NO);

  local close = CreateFrame("Button", "SC_RemoveGear_Close", SC_RemoveGear,
    "UIPanelCloseButton");
  close:SetPoint("TOPRIGHT", SC_RemoveGear, "TOPRIGHT");
  close:SetScript("OnClick", function()
    SC_RemoveGear:Hide();
  end);

  remove:Hide();
  MakeRemoveGear = nil;
end


--================
--Module Functions
--================

function Load()
  -- Events
  SC_RegEvent(module, "PLAYER_REGEN_ENABLED");
  SC_RegEvent(module, "COMBAT_LOG_EVENT_UNFILTERED");
  SC_RegEvent(module, "PLAYER_ENTERING_WORLD");

  -- Slash Commands
  _G.SLASH_GEARON1 = "/gearon";
  _G.SlashCmdList["GEARON"] = GearOn;
  _G.SLASH_NAKEED1 = "/gearoff";
  _G.SLASH_NAKEED2 = "/getnaked";
  _G.SlashCmdList["NAKEED"] = GetNaked;
end

function Defaults()
  config.Invisibility = {load = true};
end


  --==============
  --Event Handlers
  --==============

function PLAYER_REGEN_ENABLED()
if not isInBattleground() then
  if invisible and (GetNumRaidMembers() > 0 or GetNumPartyMembers() > 0) then
    if not SC_RemoveGear then
      MakeRemoveGear();
    end
    SC_RemoveGear:Show();
  end
 end
end

function COMBAT_LOG_EVENT_UNFILTERED(time,
                                     event,
                                     source_GUID,
                                     source_name,
                                     source_flags,
                                     dest_GUID,
                                     dest_name,
                                     dest_flags,
                                     param9)
  local invis = 32612; -- Actual invisiblity buff SpellID
  if event == "SPELL_AURA_APPLIED" and dest_GUID == player.GUID and 
      param9 == invis then
    invisible = true;
  elseif event == "SPELL_AURA_REMOVED" and dest_GUID == player.GUID and
         param9 == invis then
    invisible = false;
  end
end

function PLAYER_ENTERING_WORLD()
  Player();
  if player.class ~= "Mage" then
    _G.SLASH_GEARON1 = nil;
    _G.SlashCmdList["GEARON"] = nil;
    _G.SLASH_NAKEED1 = nil;
    _G.SLASH_NAKEED2 = nil;
    _G.SlashCmdList["NAKEED"] = nil;
    UnregisterModule(module);
  end
end
