--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Evocate";
module.lname = SC_MODULE_EVOCATE;
module.version = 1.114;
module.info = SC_MODULE_EVOCATE_INFO;
module.debug = false;

RegisterModule(module);

--======
--Locals
--======

-- Private Variables go here.
local IntellectWeapons = {
  ["two-hand"] = {nil, nil, 0},
  ["off-hand"] = {nil, nil, 0},
  ["one-hand"] = {nil, nil, 0},
  ["wand"] = {nil, nil, 0} };
local MainWeapons = {
  ["two-hand"] = {nil, nil, nil},
  ["off-hand"] = {nil, nil, nil},
  ["one-hand"] = {nil, nil, nil},
  ["wand"] = {nil, nil, nil} };
local Slots = {
  ["two-hand"] = "MainHandSlot",
  ["one-hand"] = "MainHandSlot",
  ["off-hand"] = "SecondaryHandSlot",
  ["wand"] = "RangedSlot" }
local mhslot = GetInventorySlotInfo("MainHandSlot");
local ohslot = GetInventorySlotInfo("SecondaryHandSlot");
local rslot = GetInventorySlotInfo("RangedSlot");
local string = string;
local coroutine = coroutine;
local GetInventoryItemLink = GetInventoryItemLink;
local GetInventorySlotInfo = GetInventorySlotInfo;
local GetContainerItemLink = GetContainerItemLink;
local PickupContainerItem = PickupContainerItem; -- Some local copies
local PickupInventoryItem = PickupInventoryItem;
local ClearCursor = ClearCursor;
local empty = {};
local switched = false; -- Are weapons switched?
local tooltip;
local oldwrapper = false; -- Did we just create a wrapper?
local update = false; -- Do we need to update weapons? (Bag update)
local updater; -- Updater function


--==================
--Evocation Handling
--==================

local function GetTooltipLines(itemLink)
  tooltip:SetOwner(this, "ANCHOR_NONE");
  tooltip:ClearLines();
  tooltip:SetHyperlink(itemLink);
  local Text, FontString = "";
  for i = 1, tooltip:NumLines() do
    FontString = _G["SC_ItemTooltipTextLeft"..i];
    if FontString then
      Text = Text..FontString:GetText();
    end
  end

--cause the word wand isnt in the freken tooltip
local sName, sLink, iRarity, iLevel, iMinLevel, sType, sSubType, iStackCount = GetItemInfo(itemLink);
Text = Text.." "..sSubType;


if debug then
print("Text: "..((Text) or "other!!"));
end

  return Text;
end

local function GetItemIntellect(itemLink)
  local Text = GetTooltipLines(itemLink);
  local intellect = 0;
  for num in string.gmatch(Text, "%+(%d+) "..SPELL_STAT4_NAME) do
    intellect = intellect + tonumber(num);
  end
  return intellect;
end

local function WeaponType(itemLink)
  local Text = GetTooltipLines(itemLink);
  if string.find(Text, SC_WEAPON_TH, 1, true) then
    return "two-hand";
  elseif string.find(Text, SC_WEAPON_ONEH, 1, true) or
         string.find(Text, SC_WEAPON_MH, 1, true) then
    return "one-hand";
  elseif string.find(Text, SC_WEAPON_OH, 1, true) then
    return "off-hand";
  elseif string.find(Text, SC_WEAPON_W, 1, true) then
    return "wand";
  else
    return nil;
  end
end

local function GetInventoryItemIntellect(eItem)
  return GetItemIntellect(GetInventoryItemLink("player",
        (GetInventorySlotInfo(eItem))));
end


local function GetIntellectWeaponsInBag(bag)

  for slot = 1, GetContainerNumSlots(bag) do
    local itemLink = GetContainerItemLink(bag, slot);  -- get link for slot

    if itemLink then --if the slot is not empty

     local itemType = WeaponType(itemLink);

     if itemType then
        local itemIntellect = GetItemIntellect(itemLink);

             if (IntellectWeapons[itemType][3] or 0) < itemIntellect then
               IntellectWeapons[itemType][1] = bag;
               IntellectWeapons[itemType][2] = slot;
               IntellectWeapons[itemType][3] = itemIntellect;
             end

        if debug then
        print("Item: "..(itemLink).." Type: "
              ..(itemType or "other").." Intellect: "..(itemIntellect or 0));
        end

      end

    elseif not empty[1] then
      empty[1] = bag;
      empty[2] = slot;
    end
  end
  return IntellectWeapons, empty;
end


local function ResetWeapons()
  for _,v in pairs(IntellectWeapons) do
    v[1] = nil;
    v[2] = nil;
    v[3] = 0;
  end
  for _,v in pairs(MainWeapons) do
    v[1] = nil;
    v[2] = nil;
    v[3] = 0;
  end
end

local function UpdateWeapons()
  ResetWeapons();
  empty[1], empty[2] = nil, nil;

  for bag = 0, 4 do
    GetIntellectWeaponsInBag(bag);
    coroutine.yield(false);
  end

  local main = GetInventoryItemLink("player", mhslot)
  local off = GetInventoryItemLink("player", ohslot)
  local ranged = GetInventoryItemLink("player", rslot);

  coroutine.yield(false); -- Necessary?

  if main then
    MainWeapons[WeaponType(main)][3] = GetInventoryItemIntellect("MainHandSlot");
    MainWeapons[WeaponType(main)][2] = "";-- This serves as a sentinel for its
                                          -- existence
    coroutine.yield(false); -- Necessary?
  end
  if off then
    MainWeapons["off-hand"][3] =
        GetInventoryItemIntellect("SecondaryHandSlot");
    MainWeapons["off-hand"][2] = "";-- This serves as a sentinel for its
                                    -- existence
    coroutine.yield(false); -- Necessary?
  end
  if ranged then
    MainWeapons["wand"][3] = GetInventoryItemIntellect("RangedSlot");
    MainWeapons["wand"][2] = "";-- This serves as a sentinel for its
                                -- existence
    coroutine.yield(false); -- Necessary?
  end

  update = false;
  return true;
end

local function NewUpdateWrap()
  local co = coroutine.create(UpdateWeapons);
  return function(n)
    oldwrapper = true;
    local dead, _ = coroutine.status(co) == "dead";
    if dead then
      return nil, "updating is finished";
    end
    -- if n is negative, then finish, else do n resumes
    for i = 1, (n < 0 and 100 or n) do
      if dead then break end
      _, dead = coroutine.resume(co);
    end
  end
end

local function Switching(mw, sw)
  MainWeapons[mw][1] = IntellectWeapons[sw][1];
  MainWeapons[mw][2] = IntellectWeapons[sw][2];
end

function ToIntellectWeapons()

  local MWTH, MWOH, MWOFFH, SWTH, SWOH, SWOFFH = MainWeapons["two-hand"][3],
      MainWeapons["one-hand"][3], MainWeapons["off-hand"][3],
      IntellectWeapons["two-hand"][3], IntellectWeapons["one-hand"][3],
      IntellectWeapons["off-hand"][3];

  ClearCursor();

  -- Switch Intellect Wands
  if IntellectWeapons["wand"][3] > (MainWeapons["wand"][3] or 0) then
    PickupContainerItem(IntellectWeapons["wand"][1], IntellectWeapons["wand"][2]);
    EquipCursorItem(rslot);
    Switching("wand", "wand");
    ClearCursor();
  end

  -- Switch Weapons (i.e. logic hell)
  -- First Case: 2-Hander to X
  if MainWeapons["two-hand"][2] then
    -- Two Hand Intellect Weapon?
    if  SWTH > MWTH and SWTH >= SWOH + SWOFFH then
      PickupContainerItem(IntellectWeapons["two-hand"][1],
          IntellectWeapons["two-hand"][2]);
      EquipCursorItem(mhslot);
      Switching("two-hand", "two-hand");
    -- Two Hand to One-Hand?
    elseif SWOH + SWOFFH > MWTH then
      -- Switch One-Hand
      if SWOH > 0 then
        PickupContainerItem(IntellectWeapons["one-hand"][1],
            IntellectWeapons["one-hand"][2]);
        EquipCursorItem(mhslot);
        Switching("two-hand", "one-hand");
      end
      -- Has Off Hand?
      if SWOFFH > 0 then
        PickupContainerItem(IntellectWeapons["off-hand"][1],
            IntellectWeapons["off-hand"][2]);
        EquipCursorItem(ohslot);
      end
    end
  -- Second Case: 1-Hand to X
  elseif MainWeapons["one-hand"][2] then
    -- They have a main hand... but do they have an offhand?
    -- MWOFFH = MWOFFH or 0;

    -- One Hand to Two Hand?
    if  ((MWOH > SWOH and MWOH or SWOH) + (MWOFFH > SWOFFH and MWOFFH or SWOFFH)
        < SWTH) then
      PickupContainerItem(IntellectWeapons["two-hand"][1],
          IntellectWeapons["two-hand"][2]);
      EquipCursorItem(mhslot);
      Switching("one-hand", "two-hand");
      -- zomg where is the offhand!?
      MainWeapons["off-hand"][1], MainWeapons["off-hand"][2] =
          empty[1], empty[2];
    else
      -- One Hand to One Hand?
      if MWOH < SWOH then
        PickupContainerItem(IntellectWeapons["one-hand"][1],
            IntellectWeapons["one-hand"][2]);
        EquipCursorItem(mhslot);
        Switching("one-hand", "one-hand");
      end
      -- Equip Intellect Off Hand?
      if MWOFFH < SWOFFH then
        PickupContainerItem(IntellectWeapons["off-hand"][1],
            IntellectWeapons["off-hand"][2]);
        EquipCursorItem(ohslot);
        Switching("off-hand", "off-hand");
      end
    end
  else
    -- They don't have a weapon equipped wtf!

    if  (SWOH + (MWOFFH > SWOFFH and MWOFFH or SWOFFH) < SWTH) then
      PickupContainerItem(IntellectWeapons["two-hand"][1],
          IntellectWeapons["two-hand"][2]);
      EquipCursorItem(mhslot);
      Switching("one-hand", "two-hand");
      -- zomg where is the offhand!?
      MainWeapons["off-hand"][1], MainWeapons["off-hand"][2] =
          empty[1], empty[2];
    else
      -- One Hand to One Hand?
      if SWOH > 0 then
        PickupContainerItem(IntellectWeapons["one-hand"][1],
            IntellectWeapons["one-hand"][2]);
        EquipCursorItem(mhslot);
        Switching("one-hand", "one-hand");
      end
      -- Equip Intellect Off Hand?
      if MWOFFH < SWOFFH then
        PickupContainerItem(IntellectWeapons["off-hand"][1],
            IntellectWeapons["off-hand"][2]);
        EquipCursorItem(ohslot);
        Switching("off-hand", "off-hand");
      end
    end
  end
  switched = true;
end

local function ToMainWeapons()
  ClearCursor();
  for i,v in pairs(MainWeapons) do
    if v[1] and i ~= "off-hand" then -- Always do offhand last!
      PickupContainerItem(v[1], v[2]);
      if GetInventoryItemLink("player", Slots[i]) then
        PickupInventoryItem(GetInventorySlotInfo(Slots[i]));
      else
        EquipCursorItem(GetInventorySlotInfo(Slots[i]));
      end
      ClearCursor();
    end
  end
  -- Handle Off-hand Last
  local v = MainWeapons["off-hand"];
  if v[1] then
    PickupContainerItem(v[1], v[2]);
    if GetInventoryItemLink("player", "SecondaryHandSlot") then
      PickupInventoryItem(GetInventorySlotInfo("SecondaryHandSlot"));
    else
      EquipCursorItem(GetInventorySlotInfo("SecondaryHandSlot"));
    end
  end

  ClearCursor();
  switched = false;
end

local function Evocate()
  inform(SC_MSG_EVOCATE);
  if update then
    updater(-1); -- Finish
  end
  return ToIntellectWeapons();
end

local function DeEvocate()
  if not HasFullControl() then
    SC_RegEvent(module, "PLAYER_CONTROL_GAINED");
    error(SC_MSG_EVOCATE_ERROR);
    return;
  end
  inform(SC_MSG_DEEVOCATE);
  return ToMainWeapons();
end


--================
--Module Functions
--================

function Load()
  -- Events
  SC_RegEvent(module, "UNIT_SPELLCAST_CHANNEL_START");
  SC_RegEvent(module, "UNIT_SPELLCAST_CHANNEL_STOP");
  SC_RegEvent(module, "PLAYER_ENTERING_WORLD");
  SC_RegEvent(module, "UNIT_SPELLCAST_START");-- Perform Part of Update
  SC_RegEvent(module, "BAG_UPDATE");-- Messing with his bags? New update...
end

function Defaults()
  config.Evocate = {load = true};
end


  --==============
  --Event Handlers
  --==============

function UNIT_SPELLCAST_CHANNEL_STOP(unit, spell)
  if unit == "player" and spell == SC_SPELL_EVOCATION then
    return DeEvocate();
  end
end

function UNIT_SPELLCAST_CHANNEL_START(unit, spell)
  if unit == "player" and spell == SC_SPELL_EVOCATION then
    return Evocate();
  end
end

function UNIT_SPELLCAST_START(unit)
  if update and unit == "player" then
    updater(1);
  end
end

function PLAYER_CONTROL_GAINED()
  SC_UnRegEvent(module, "PLAYER_CONTROL_GAINED");
  DeEvocate();
end

function PLAYER_ENTERING_WORLD()
  Player();
  if player.class ~= "Mage" then
    UnregisterModule(module);
    return;
  end
  if not tooltip then
    tooltip = CreateFrame("GameTooltip", "SC_ItemTooltip", UIParent,
        "GameTooltipTemplate");
  end
  updater = NewUpdateWrap();
  updater(-1);
end

function BAG_UPDATE()
  update = true;
  if oldwrapper then
    updater = NewUpdateWrap();
    oldwrapper = false;
  end
end
