--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Collect";
module.lname = SC_MODULE_COLLECT;
module.version = 1.111;
module.info = SC_MODULE_COLLECT_INFO;

RegisterModule(module);


--======
--Locals
--======

local LastCollect = 0;


--===============
--Local Functions
--===============

local function collect()
  local now = tonumber(date("%j%H%M%S"));
  if now > LastCollect + 300 then
    LastCollect = now;
    inform(SC_MSG_GARBAGE);
    return collectgarbage();
  end
end


--================
--Module Functions
--================

function Load()
  -- Events
  SC_RegEvent(module, "PLAYER_DEAD");
  SC_RegEvent(module, "PLAYER_UPDATE_RESTING");
end

function Defaults()
  config.Collect = {load = true};
end


  --==============
  --Event Handlers
  --==============

function PLAYER_DEAD()
  collect();
end

function PLAYER_UPDATE_RESTING()
  if IsResting() then
    collect();
  end
end
