--[[

Spellcraft: This is a World of Warcraft Mage Utility AddOn.
Copyright (C) 2007  Patrick J. Donnelly (batrick@unm.edu)

Permission is NOT granted to modify/redistribute this software.
Please seek permission from the author.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--]]


--=====================================
--Setting up the environment and module
--=====================================

local module = { };
local _G = getfenv(0);
setmetatable(module, {__index = _G.Spellcraft});
setfenv(1, module);

module.name = "Bandage";
module.lname = SC_MODULE_BANDAGE;
module.version = 1.115;
module.info = SC_MODULE_BANDAGE_INFO;

RegisterModule(module);

--======
--Locals
--======

-- Private Variables go here.
local bandaging = false;
local player = player;


--===============
--Local Functions
--===============

  --==================
  --Bandaging Handling
  --==================

local function Bandagem()
  local n, c;
  if GetNumRaidMembers() > 0 then
    c = "Raid";
    n = 40;
  elseif GetNumPartyMembers() > 0 then
    c="Party";
    n = 5;
  else return
  end
  for i = 1, n do
    if not UnitIsUnit(c..i, "player") and isHealer(c..i) and
       UnitIsUnit(c..i.."target", "player") then
        SendChatMessage(SC_WHISPER_BANDAGE, "WHISPER",
                        this.language, UnitName(c..i));
    end
  end
  --SendChatMessage(SC_PARTY_BANDAGE, "PARTY", this.language);
end

local function BandagemTarget(unitid)
  if bandaging and isHealer(unitid) then
    SendChatMessage(SC_WHISPER_BANDAGE, "WHISPER", this.language,
        UnitName(unitid));
  end
end


--================
--Module Functions
--================

function Load()
  -- Events
  SC_RegEvent(module, "UNIT_TARGET");
  SC_RegEvent(module, "COMBAT_LOG_EVENT_UNFILTERED");

  -- Slash Commands
  _G.SLASH_BANDAGEM1 = "/bandagem";
  _G.SlashCmdList["BANDAGEM"] = Bandagem;
end

function Defaults()
  config.Bandage = {load = true};
end


  --==============
  --Event Handlers
  --==============

function UNIT_TARGET(whom)
  if not (whom:find("party") or whom:find("raid")) then
    return;
  end
  local target = UnitName(whom.."target");
  if not target then return end
  if target == player.name then
    BandagemTarget(whom);
  end 
end

function COMBAT_LOG_EVENT_UNFILTERED(time,
                                     event,
                                     source_GUID,
                                     source_name,
                                     source_flags,
                                     dest_GUID,
                                     dest_name,
                                     dest_flags,
                                     param9,
                                     param10)
  if event == "SPELL_AURA_APPLIED" and dest_GUID == player.GUID and
      param10 == SC_DEBUFF_SELF_FA then
    bandaging = true;
    Bandagem();
  elseif event == "SPELL_AURA_REMOVED" and dest_GUID == player.GUID and
         param10 == SC_DEBUFF_SELF_FA then
    bandaging = false;
  end
end
