local L = AceLibrary("AceLocale-2.2"):new("SpellReminder")

local function getOption(key)
	return SpellReminder.db.profile[key]
end
local function setOption(key, value)
	SpellReminder.db.profile[key] = value
	SpellReminder:CreateAnchors()
	SpellReminder:RefreshAllBars()--true)
end

local defaultSpells = {
	type = "group",
	order = 1,
	name = L["Spell Setup"],
	desc = L["Setup spell reminders."],
	args = {
		inactive = {
			type = "group",
			order = 1,
			name = L["Inactive"],
			desc = L["Inactive Spells"],
			args = SpellReminder:new(),
			hidden = true,
		},
		inactiveSplit = { type = "header", order = 2, hidden = true, },
		notice = { type = "header", order = 3, name = L["Click a spell to stop tracking."]},

		spacer = { type = "header", order = 100 },
		--[[addNew = {
			type = "text",
			order = 101,
			name = "Add New Spell",
			desc = "Add a new spell to the watch list.",
			usage = "<name>",
			get = function () return "" end,
			set = function (v) SpellReminder:InstallWatch(v) SpellReminder:RefreshSpellOptions() end,
		},]]
		disableDetection = {
			type = "toggle",
			order = 103,
			name = L["Disable Detection"],
			desc = L["Disables the detection of new spells."],
			get = getOption,
			set = setOption,
			passValue = "disableDetection",
		},
		spacer2 = { type = "header", order = 105 },
		defaultcolor = {
			type = "color",
			order = 107,
			name = L["Default Bar Color"],
			desc = L["Set the default color of the reminder bars."],
			get = function () local c = getOption("defaultBarColor") return c.r,c.g,c.b,c.a end,
			set = function (r, g, b, a) setOption("defaultBarColor", {["r"]=r, ["g"]=g, ["b"]=b, ["a"]=1}) SpellReminder:RefreshSpellOptions() end,					
		},
		spacer2 = { type = "header", order = 108 },
		ClearAll = {
			type = "execute",
			order = 110,
			name = L["Clear All Spells"],
			desc = L["Will force SpellReminder to forget all options for ALL spells, including detected spells and pet spells."],
			confirm = true,
			func = function () SpellReminder:ClearSpells(true) end,
		},
--[[		ClearInactive = {
			type = "execute",
			order = 110,
			name = L["Clear Inactive Spells"],
			desc = L["Will force SpellReminder to forget all options for inactive spells."],
			confirm = true,
			func = function () SpellReminder:ClearSpells("inactive") end,
		},]]
--		addAll = {
--			type = "execute",
--			order = 115,
--			name = "Scan Spellbook",
--			desc = "Attempts to scan your spellbook and watch all spells.",
--			func = "InstallAllSpells",
--		},
	},
}

function SpellReminder:RefreshFilterPrioOptions()
	local tbl = self.options.args.barSetup.args.filterPrio.args
	for i,k in ipairs(tbl) do
		tbl[i] = nil
	end
	for idx, fltrName in ipairs(self.db.profile.filterPrio) do
		table.insert(tbl,{
			type = "execute",
			name = fltrName,
			desc = L["Increase the priority of this filter."],
			order = idx+5,
			disabled = idx == 1,
			func = function () self.db.profile.filterPrio[idx] = self.db.profile.filterPrio[idx-1]; self.db.profile.filterPrio[idx-1] = fltrName; self:RefreshFilterPrioOptions() end,
		})
	end
	table.insert(tbl,{
		type = "header",
		name = L["Highest Priority"],
		order = 1,
	})
	table.insert(tbl,{
		type = "header",
		name = L["Lowest Priority"],
		order = -1,
	})
	self:RefreshAllBars()
end

function SpellReminder:RefreshGroupOptions()
	self.options.args.barSetup.args.barGroups.args = { -- setup
			-- add/delete 
		addGroup = {
			type = "text",
			order = 1,
			name = L["Add New"],
			desc = L["Name of the new group."],
			usage = "<name>",
			get = function () return "" end,
			set = function (v) self:AddNewAnchor({name=v}) end
		},
		spacer = { type = "header", order = 2 },
	}
	for key,anchor in pairs(self.anchors) do
		self.options.args.barSetup.args.barGroups.args[key] = self:GetGroupOptions(key)
	end
	for key,fltr in pairs(self.options.args.barSetup.args.filters.args) do
		fltr.validate = SpellReminder.BarGroupList
	end
end

SpellReminder.BarGroupList = SpellReminder:new()
function SpellReminder:RefreshBarGroupList()
	for i,k in ipairs(SpellReminder.BarGroupList) do
		table.remove(SpellReminder.BarGroupList,i)
	end

	SpellReminder.BarGroupList["-1"] = L["None"]
	for k,n in pairs(self.anchors) do
		SpellReminder.BarGroupList[tostring(k)] = n.name
	end
	
--	SpellReminder.BarGroupList = list
--	for k,v in pairs(self.options.args.barSetup.args.filters.args) do
--		self.options.args.barSetup.args.filters.args[k].validate = list
--	end
--	self.options.args.barSetup.args.filters.args.self.validate = list
--	self.options.args.barSetup.args.filters.args.buffs.validate = list
--	self.options.args.barSetup.args.filters.args.debuffs.validate = list
end

function SpellReminder:GetGroupOptions(id)
	self:DebugPrint("Getting Group Options: "..id)
	local anchor = self.anchors[id]
	return {
			type = "group",
			name = " "..anchor.name,
			desc = L["Setup Group"],
			order = 50+id,
			args = {
				anchorName = {
					type = "text",
					order = 1,
					name = L["Group Name"],
					desc = L["Name of the Bar Group"],
					usage = "<name>",
					disabled = anchor.cantEdit,
					get = function () return self.db.profile.bargroups[id].name end,
					set = function (v) self.db.profile.bargroups[id].name = v self:CreateAnchors()  end,
				},
				scale = {				
					type = "range",
					order = 10,
					name = L["Bar Scale"],
					desc = L["Default Bar Scale."],
					min = 0.2,
					max = 3.0,
					step = 0.1,
					get = function () return self.db.profile.bargroups[id].scale or 1 end,
					set = function (v) self.db.profile.bargroups[id].scale = v SpellReminder:RefreshAllBars() end,
				},
				emphasise = {
					type = "toggle",
					order = 20,
					name = L["Emphasise"],
					desc = L["Bars from this group will emphasise."],
					get = function () return self.db.profile.bargroups[id].emphasise or false end,
					set = function (v) self.db.profile.bargroups[id].emphasise = v end,
				},
				growup = {
					type = "toggle",
					order = 30,
					name = L["Grow Upward"],
					desc = L["Bars stack ontop of each other instead of underneath each other."],
					get = function () return self.db.profile.bargroups[id].growup or false end,
					set = function (v) self.db.profile.bargroups[id].growup = v  self.anchors[id].LBframe:ReverseGrowth(v) end,
				},
				reversesort = {
					type = "toggle",
					order = 40,
					name = L["Reverse Sort"],
					desc = L["Sort timer bars in reverse."],
					get = function () return self.db.profile.bargroups[id].reversesort or false end,
					set = function (v) self.db.profile.bargroups[id].reversesort = v  self.anchors[id].LBframe:SortBars() end,
				},
				resetPosition = {
					type = "execute",
					name = L["Reset Position"],
					desc = L["Reset group position to center."],
					order = -2,
					confirm = true,
					func = function () self:ResetAnchor(id) end
				},
				deleteGroup = {
					type = "execute",
					name = L["Delete"],
					desc = L["Delete this group"],
					order = -1,
					disabled = anchor.cantEdit,
					confirm = true,
					func = function () self:DeleteBarGroup(id) end
				},
			},
		}
end

local function isSpellDisabled(t)	return SpellReminder.db.char.spellSetup[t[1]].active == false	end
local function getSpellProp(t)		return SpellReminder.db.char.spellSetup[t[1]][t[2]]				end
local function setSpellProp(t,v)
	SpellReminder.db.char.spellSetup[t[1]][t[2]] = v
	SpellReminder:RefreshAllBars(true)
end

function SpellReminder:RefreshSpellOptions()
	self:DebugPrint("Refreshing Spell Options")
	if self.spellOptions == nil then self.spellOptions = SpellReminder:new() end
	for spellName,info in pairs(self.db.char.spellSetup) do
		local realSpellName = spellName
		if string.find(realSpellName,":") then
			_,_,_,realSpellName = string.find(realSpellName,"(.*):(.*)")
		end
		if info == nil or info.d == nil or info.d == 0 then
			self.db.char.spellSetup[spellName] = SpellReminder:del(self.db.char.spellSetup[spellName]) -- remove invalid spells
			self.spellOptions[spellName] = SpellReminder:del(self.spellOptions[spellName])
		else
			if self.spellOptions[spellName] == nil then
	--			if self.db.char.spellSetup[spellName].showSelf == nil then self.db.char.spellSetup[spellName].showSelf = true end
	--			if self.db.char.spellSetup[spellName].showOther == nil then self.db.char.spellSetup[spellName].showOther = true end
				self.spellOptions[spellName] = {
					type = "group",
					order = 10,
					icon = info.icon,
					name = realSpellName,  -- |cAARRGGBB
					desc = L["Setup reminder for %s|nClick to %s"]:format(spellName,(self.db.char.spellSetup[spellName].active and L["deactivate"] or L["activate"])),
					onClick = function () self.db.char.spellSetup[spellName].active = not self.db.char.spellSetup[spellName].active SpellReminder:RefreshSpellOptions() SpellReminder:ProcessAuras("player") end,
			--		isChecked = true,
					args = {
	--				purge = {
	--					type = "execute",
	--					order = 1,
	--					name = "Purge",
	--					desc = "Remove this spell",
	--					func = function () self.db.char.spellSetup[spellName] = nil SpellReminder:RefreshSpellOptions() end,
	--				},
						showSelf = {
							type = "toggle",
							order = 1,
							name = L["Show Self"],
							desc = L["Show this spell if its cast on yourself."],
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].selfOnly end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].selfOnly = v end,
							passValue = {spellName,"showSelf"},
						},
						showOther = {
							type = "toggle",
							order = 2,
							name = L["Show Others"],
							desc = L["Show this spell when its cast on others"],
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].selfOnly end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].selfOnly = v end,
							passValue = {spellName,"showOther"},
						},
						singleTrack = {
							type = "toggle",
							order = 5,
							name = L["Single Tracking"],
							desc = L["This will only track one instance of this spell at any one time.  Useful for Soulstone."],
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
							passValue = {spellName,"singleTrack"},
						},
						displayName = {
							type = "text",
							order = 10,
							name = L["Display Name"],
							desc = L["Spell name text to display on the bar. For example an abbreviation."],
							usage = "<name>",
							disabled = isSpellDisabled,
							get = function (t) return self.db.char.spellSetup[spellName].displayName end,
							set = function (t,v) self.db.char.spellSetup[spellName].displayName = v SpellReminder:RefreshAllBars(true) end,
							passValue = {spellName,"displayName"},
						},
						reminder = {
							type = "range",
							order = 15,
							name = L["Reminder"],
							desc = L["Reminder occurs when the spell duration remaining reaches this value."],
							min = 0,
							max = info.d,
							step = 1,
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].r end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].r = v end,
							passValue = {spellName,"r"},
						},
						color = {
							type = "color",
							order = 20,
							name = L["Bar Color"],
							desc = L["Set the color of the reminder bar."],
							disabled = isSpellDisabled,
							get = function (t) local c = self.db.char.spellSetup[spellName].c or getOption("defaultBarColor") return c.r,c.g,c.b,c.a end,
							set = function (t, red, green, blue, alpha)
								self.db.char.spellSetup[spellName].c = {["r"]=red, ["g"]=green, ["b"]=blue, ["a"]=alpha}
								self:ScheduleEvent("SR_REFRESH_OPTIONS",function() self:RefreshSpellOptions() SpellReminder:RefreshAllBars(true) end,1,self)
							end,
							passValue = {spellName,"c"},
						},
						sep3 = { type = "header", order = 25 },
		--[[				persistent = {
							type = "toggle",
							order = 12,
							name = "Persistent",
							desc = "If selected, this bar will stay active regardless of death or dispel. Useful for Shadowfiend",
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].persistent == true end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].persistent = v end,
							passValue = {spellName,"persistent"},
						},]]
	--[[					fadeTime = {
							type = "range",
							order = 30,
							name = "Fade Time",
							desc = "Time until the bar disapears after it reaches zero. -1 to always show.",
							min = -1,
							max = 10,
							step = 1,
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].fade or 0 end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].fade = v end,
							passValue = {spellName,"fade"},
						},]]
						--sep = { type = "header", order = 35 },
						allowCustomSound = {
							type = "toggle",
							order = 40,
							name = L["Allow Custom Sound"],
							desc = L["Allow selection of a custom sound."],
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].selfOnly end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].selfOnly = v end,
							passValue = {spellName,"allowCustomSound"},
						},
						soundFile = {
							type = 'text',
							order = 41,
							name = L["Custom Sound"],
							desc = L["Play a sound when a spell is about to expire."],
							validate = SpellReminder.sm:List('sound'),
							disabled = function (t) return isSpellDisabled(t) or (not self.db.char.spellSetup[spellName].allowCustomSound) end,
							get = function(t) return self.db.char.spellSetup[spellName].customSound or "None" end,
							set = function(t,value) PlaySoundFile(SpellReminder.sm:Fetch('sound',value)) self.db.char.spellSetup[spellName].customSound = value end,
							passValue = {spellName,"customSound"},
						},
						sep2 = { type = "header", order = 45 },
						allowCustomGroup = {
							type = "toggle",
							order = 50,
							name = L["Allow Custom Group"],
							desc = L["Allow selection of a custom destination group."],
							disabled = isSpellDisabled,
							get = getSpellProp,--function () return self.db.char.spellSetup[spellName].selfOnly end,
							set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].selfOnly = v end,
							passValue = {spellName,"allowCustomGroup"},
						},
						customGroup = {
							type = "text",
							order = 51,
							name = L["Custom Group"],
							desc = L["Which group should this spell be sent to."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							disabled = function (t) return isSpellDisabled(t) or (not self.db.char.spellSetup[spellName].allowCustomGroup) end,
							get = function (t) return string.format("%d",self.db.char.spellSetup[spellName].customGroup or -1) end,
							set = function (t,v) self.db.char.spellSetup[spellName].customGroup = tonumber(v) SpellReminder:RefreshAllBars() end,
							passValue = {spellName,"customGroup"},
						},
						sep2 = { type = "header", order = 55 },
						announceGroup = {
							type = "group",
							order = 56,
							name = L["Announce"],
							desc = L["Setup announce options for %s"]:format(spellName),
							disabled = isSpellDisabled,
							passValue = {spellName,"announceGroup"},
							args = {
								announceSay = {
									type = "toggle",
									order = 1,
									name = L["Say"],
									desc = L["Announce to Say"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceSay"},
								},
								announceYell = {
									type = "toggle",
									order = 2,
									name = L["Yell"],
									desc = L["Announce to Yell"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceYell"},
								},
								announceParty = {
									type = "toggle",
									order = 3,
									name = L["Party"],
									desc = L["Announce to Party"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceParty"},
								},
								announceRaid = {
									type = "toggle",
									order = 4,
									name = L["Raid"],
									desc = L["Announce to Raid"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceRaid"},
								},
								sep = { type = "header", order = 10 },
								start = {
									type = "toggle",
									order = 20,
									name = L["Cast"],
									desc = L["Announce when Cast"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceCast"},
								},
								ending = {
									type = "toggle",
									order = 20,
									name = L["Ending"],
									desc = L["Announce when Ending"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceEnding"},
								},
								ended = {
									type = "toggle",
									order = 21,
									name = L["Ended"],
									desc = L["Announce when Ended"],
									get = getSpellProp,--function () return self.db.char.spellSetup[spellName].singleTrack end,
									set = setSpellProp,--function (v) self.db.char.spellSetup[spellName].singleTrack = v end,
									passValue = {spellName,"announceEnded"},
								},
							}
						}
					}
				}
			end
			-- update spell Max duration
				if self.spellOptions[spellName].args.reminder.max < info.d then
					self.spellOptions[spellName].args.reminder.max = info.d
				end
			-- end
			-- update spell colour
				if self.db.char.spellSetup[spellName].c == nil or type(self.db.char.spellSetup[spellName].c.r) ~= "number" then
					self.db.char.spellSetup[spellName].c = SpellReminder:del(self.db.char.spellSetup[spellName].c)
				end
				local c = self.db.char.spellSetup[spellName].c or getOption("defaultBarColor")
				local colorString = string.format("|cFF%.2x%.2x%.2x",c.r*255,c.g*255,c.b*255)
				self.spellOptions[spellName].name = colorString..realSpellName
			-- end
		end
	end
	
	self.options.args.spells = SpellReminder:del(self.options.args.spells)
	self.options.args.spells = SpellReminder:new()
	self:tcopy(defaultSpells,self.options.args.spells)
	for spellName,options in pairs(self.spellOptions) do
		-- get destination
		local destination = self.options.args.spells.args
		if not self.db.char.spellSetup[spellName].active then
			destination = self.options.args.spells.args.inactive.args
			if self.options.args.spells.args.inactive.hidden then
				self.options.args.spells.args.inactive.hidden = false
				self.options.args.spells.args.inactiveSplit.hidden = false
			end
		elseif self.db.char.spellSetup[spellName].category then
			local cat = self.db.char.spellSetup[spellName].category
			if not self.options.args.spells.args[cat] then
				self.options.args.spells.args[cat] = {
					type = "group",
					order = 5,
					name = cat,
					desc = "Options for "..cat,
					args = SpellReminder:new(),
				}
			end
			destination = self.options.args.spells.args[cat].args
		end
		destination[spellName] = options
	end
end

function SpellReminder:SetSpellCategory(spellName,cat)
	local info = self.db.char.spellSetup[spellName]
	if not info or info.category == cat then return end

	info.category = cat
	self:RefreshSpellOptions()
end

SpellReminder.options =
{
	type = "group",
	name = "SpellReminder",
	desc = L["Options for SpellReminder."],
	handler = SpellReminder,
	args = {
		--spells = defaultSpells,
		spacer2 = { type = "header", order = 2 },
		barSetup = {
			type = "group",
			order = 3,
			name = L["Timer Bars"],
			desc = L["Setup bar animation options and scaling."],
			args = {
			--[[	startScale = {				
					type = "range",
					order = 1,
					name = "Start Scale",
					desc = "Default Bar Scale.",
					min = 0.2,
					max = 2.0,
					step = 0.1,
					get = getOption,
					set = setOption,
					passValue = "startScale",
				},
				stopScale = {
					type = "range",
					order = 3,
					name = "Emphasize Scale",
					desc = "Emphasized Bar Scale.",
					disabled = function () return getOption("disableEmphasis") == true end,
					min = 0.2,
					max = 3.0,
					step = 0.1,
					get = getOption,
					set = setOption,
					passValue = "stopScale",
				},]]
		--[[		ttg = {
					type = "range",
					order = 4,
					name = "Tween Time",
					desc = "Total time of tween animation.",
					visible = false,
					disabled = function () return getOption("disableEmphasis") == true end,
					min = 0.1,
					max = 3.0,
					step = 0.1,
					get = getOption,
					set = setOption,
					passValue = "ttg",
				},
				disableEmphasis = {
					type = "toggle",
					order = 2,
					name = "Disable Emphasis",
					desc = "Disables the emphasise effect",
					get = getOption,
					set = setOption,
					passValue = "disableEmphasis",
				},
				spacer2 = { type = "header", order = 5 },]]
				barGroups = {
					type = "group",
					order = 1,
					name = L["Bar Groups"],
					desc = L["Setup Bar Groups"],
					args = SpellReminder:new(),
				},
				filters = {
					type = 'group',
					order = 5,
					name = L["Filters"],
					desc = L["Filter different spell types."],
					args = {
						self = {
							type = "text",
							order = 10,
							name = L["Self"],
							desc = L["Which group should self casts be sent."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							get = function () return string.format("%d",SpellReminder.db.profile.targetGroup_self or 1) end,
							set = function (v) SpellReminder.db.profile.targetGroup_self = tonumber(v) end,
						},
						buffs = {
							type = "text",
							order = 10,
							name = L["Buffs"],
							desc = L["Which group should buffs be sent."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							get = function () return string.format("%d",SpellReminder.db.profile.targetGroup_buff or 1) end,
							set = function (v) SpellReminder.db.profile.targetGroup_buff = tonumber(v) end,
						},
						debuffs = {
							type = "text",
							order = 10,
							name = L["Debuffs"],
							desc = L["Which group should debuffs be sent."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							get = function () return string.format("%d",SpellReminder.db.profile.targetGroup_debuff or 1) end,
							set = function (v) SpellReminder.db.profile.targetGroup_debuff = tonumber(v) end,
						},
						cooldowns = {
							type = "text",
							order = 10,
							name = L["Cooldowns"],
							desc = L["Which group should cooldowns be sent."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							get = function () return string.format("%d",SpellReminder.db.profile.targetGroup_cooldown or 1) end,
							set = function (v) SpellReminder.db.profile.targetGroup_cooldown = tonumber(v) end,
						},
						target = {
							type = "text",
							order = 10,
							name = L["Target"],
							desc = L["Which group should current target be sent."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							get = function () return string.format("%d",SpellReminder.db.profile.targetGroup_target or 1) end,
							set = function (v) SpellReminder.db.profile.targetGroup_target = tonumber(v) end,
						},
						focus = {
							type = "text",
							order = 10,
							name = L["Focus"],
							desc = L["Which group should focus be sent."],
							usage = "<select>",
							validate = SpellReminder.BarGroupList,
							get = function () return string.format("%d",SpellReminder.db.profile.targetGroup_focus or 1) end,
							set = function (v) SpellReminder.db.profile.targetGroup_focus = tonumber(v) end,
						},
					},
				},
				filterPrio = {
					type = 'group',
					order = 5,
					name = L["Filter Priorities"],
					desc = L["Set priorities for the filters."],
					args = {},
				},
				spacer1 = { type = "header", order = 10 },
				lockBars = {
					type = "toggle",
					order = 15,
					name = L["Lock timer bars"],
					desc = L["Lock the position of the timer bars."],
					get = function () return getOption("lockbars") end,
					set = function (v)
						setOption("lockbars",v)
						-- show/hide the anchors
						SpellReminder:ToggleAnchors()
					end
				},
				resetBars = {
					type = "execute",
					order = 20,
					name = L["Reset Bars"],
					desc = L["Reset the posion of the bars."],
					confirm = true,
					func = "ResetAnchors",
				},
				testBars = {
					type = "execute",
					order = 25,
					name = L["Test Bars"],
					desc = L["Create sample reminder bars to test your layout."],
					func = "CreateTestBars",
				},
				spacer10 = { type = "header", order = 30 },
				formattingSub = {
					type = 'group',
					order = 35,
					name = L["Bar Formatting"],
					desc = L["Various formating options for the bars."],
					args = {
						iconBorder = {
							type = "toggle",
							order = 15,
							name = L["Icon Border"],
							desc = L["Show a border on the icon."],
							get = getOption,
							set = setOption,
							passValue = 'iconBorder',
						},
						textFormat = {
							type = 'text',
							name = L["Display Text"],
							desc = L["Set the format of the text that appears on the bars.  Possible values are: %n (spell name) %r (spell rank) %t (target) %a (applications)"],
							usage = "<format>",
							order = 51,
							get = getOption,
							set = setOption,
							passValue = 'textFormat',
						},
						texture = {
							type = 'text',
							name = L["Texture"],
							desc = L["Set the Bar Texture"],
							validate = SpellReminder.sm:List('statusbar'),
							order = 52,
							get = getOption,
							set = setOption,
							passValue = 'texture',
						},
						spacer3 = { type = "header", order = 100 },
						barwidth = {
							type = 'range',
							name = L["Bar Width"],
							desc = L["Set the Bar Width"],
							order = 110,
							min = 50,
							max = 500,
							step = 10,
							get = getOption,
							set = setOption,
							passValue = 'barwidth',
						},
						barheight = {
							type = 'range',
							name = L["Bar Height"],
							desc = L["Set the Bar Height"],
							order = 115,
							min = 5,
							max = 40,
							step = 1,
							get = getOption,
							set = setOption,
							passValue = 'barheight',
						},
						spacer4 = { type = "header", order = 120 },
						barfont = {
							type = 'text',
							name = L["Font"],
							desc = L["Set the Bar Font"],
							validate = SpellReminder.sm:List('font'),
							order = 125,
							get = getOption,
							set = setOption,
							passValue = 'barfont',
						},
						barfontsize = {
							type = 'range',
							name = L["Font Size"],
							desc = L["Set the Cast Bar Font Size"],
							order = 130,
							min = 1,
							max = 30,
							step = 1,
							get = getOption,
							set = setOption,
							passValue = 'barfontsize',
						},
					},
				},
			},
		},
		debugmode = {
			type = "toggle",
			order = 5,
			name = L["Debug Mode"],
			desc = L["Show Debug Messages."],
			get = getOption,
			set = setOption,
			passValue = "debugmode"
		},
		docooldowns = {
			type = "toggle",
			order = 5,
			name = L["Process Cooldowns"],
			desc = L["Creates bars for spell cooldowns."],
			get = getOption,
			set = setOption,
			passValue = "docooldowns"
		},
		flashbars = {
			type = "toggle",
			order = 5,
			name = L["Flash Bars"],
			desc = L["Flash bars when they are expiring."],
			get = getOption,
			set = setOption,
			passValue = "flashbars"
		},
		spacer4 = { type = "header", order = 6 },
		textWarnings = {
			type = 'text',
			name = L["Text Warnings"],
			desc = L["Select which Text Warnings to display"],
			validate = { L["Both"] , L["Expiring Only"] , L["Expired Only"] },
			order = 7,
			get = getOption,
			set = setOption,
			passValue = 'textWarnings',
		},
		audioWarnings = {
			type = 'text',
			name = L["Audiable Warnings"],
			desc = L["Play a sound when a spell is about to expire."],
			validate = SpellReminder.sm:List('sound'),
			order = 8,
			get = getOption,
			set = function(_,value) PlaySoundFile(SpellReminder.sm:Fetch('sound',value)) setOption("audioWarnings",value) end,
			passValue = 'audioWarnings',
		},
		spacer5 = { type = "header", order = 10 },
	},
}