-- keep wowace alive, donate!
local L = AceLibrary("AceLocale-2.2"):new("SpellReminder")
local WotLK = select(4,GetBuildInfo()) >= 30000

SpellReminder = LibStub('AceAddon-2.0'):new("AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0", "FuBarPlugin-2.0")
--SpellReminder.candybar = LibStub("CandyBar-2.0")
SpellReminder.sm = LibStub("LibSharedMedia-3.0")


local tooltip = CreateFrame("GameTooltip","SpellReminderTooltipScanning")
tooltip:SetOwner( WorldFrame, "ANCHOR_NONE" );
tooltip.LL, tooltip.LR = {}, {}
do
	local i
	for i=1,30 do
		tooltip.LL[i],tooltip.LR[i] = tooltip:CreateFontString(),tooltip:CreateFontString()
		tooltip:AddFontStrings(tooltip.LL[i],tooltip.LR[i]);
	end
	function tooltip:FindTipText(match,noleft,noright)
		for i=1,self:NumLines() do
			local l,r = self.LL[i]:GetText() or "" , self.LR[i]:GetText() or ""
			start,fin,txt = string.find(l,match)
			if start then return start,fin,txt end
		end
	end
	function tooltip:GetFullTipText(noleft,noright)
		local fulltext = ""
		for i=1,self:NumLines() do
			local l,r = self.LL[i]:GetText() or "" , self.LR[i]:GetText() or ""
			if not noleft then fulltext = fulltext.." "..l end
			if not noright then fulltext = fulltext.." "..r end
		end
		return fulltext
	end
end


local tablerecyc = setmetatable({},{__mode='k'})
function SpellReminder:new()
	local t = next(tablerecyc)
	if t then
		tablerecyc[t] = nil
		return t
	else
		return {}
	end
end
function SpellReminder:del(t)
	if type(t) ~= "table" then return nil end
	for k in pairs(t) do
		t[k] = nil
	end
	tablerecyc[t] = true
	return nil
end

local function sortFunc(a, b)
	local toReturn
	
	if a.isTimer ~= b.isTimer then
		toReturn = a.isTimer
	elseif a.value == b.value then
		toReturn = a.name > b.name
	else
		toReturn = a.value > b.value
	end
	
	local eithergrp = a:GetGroup() or b:GetGroup() -- both bars are not always set.. for some reason.
	if eithergrp then
		for i,anchor in ipairs(SpellReminder.anchors) do
			if anchor.LBframe == eithergrp and SpellReminder.db.profile.bargroups[i].reversesort then
				return not toReturn
			end
		end
	end
	return toReturn
end
local function ClipNumber(number, minimum, maximum, trueMax)
	return min(max(min(number,maximum),minimum),trueMax)
end
-- Thanks EBB
local roman_to_arabic = setmetatable({I = 1, V = 5, X = 10, L = 50, C = 100, D = 500, M = 1000}, {__index=function(self, roman)
	local arabic = 0
	local maxval = 0
	for i = roman:len(), 1, -1 do
		local digitval = self[roman:sub(i,i)]
		if digitval < maxval then
			arabic = arabic - digitval
		else
			arabic = arabic + digitval
			maxval = digitval
		end
	end
	self[roman] = arabic
	return arabic
end})

local _G = _G
local pairs = _G.pairs
local ipairs = _G.ipairs
local select = _G.select
local GetTime = _G.GetTime
local UnitName = _G.UnitName
local UnitGUID = _G.UnitGUID
local UnitBuff = _G.UnitBuff
local UnitDebuff = _G.UnitDebuff
local UnitIsDead = _G.UnitIsDead
local UnitExists = _G.UnitExists

local SPELLTYPE_NORMAL = ""
local SPELLTYPE_COOLDOWN = "CD"

SpellReminder:RegisterDB("SpellReminderDB","SpellReminderDBPerChar")
SpellReminder:RegisterDefaults('profile', {
--	startScale	= 1,
--	stopScale	= 1.5,
--	splitSelf	= false,
	ttg			= 0.3,
	disableEmphasis = false,
	lockbars	= false,
	debugmode	= false,
	docooldowns = true,
	-- output
	textWarnings	= L["Both"],
	audioWarnings	= L["None"],
	-- formatting
	textFormat	= "%t (%a) - %n",
	texture		= "Blizzard",
	baroverride	= false,
	barfont		= nil,
	barfontsize	= 11,
	barwidth	= 200,
	barheight	= 16,
	flashbars	= true,
	iconBorder	= true,
	-- spellsetup
	disableDetection	= false,
	defaultBarColor		= {["r"] = 1, ["g"] = 0, ["b"] = 0, ["a"] = 1},
	-- groups
	bargroups = {},
	--filters
	filterPrio = {'self','target','focus','buff','debuff','cooldown'},
	targetGroup_self	= 1,
	targetGroup_buff	= 1,
	targetGroup_debuff	= 1,
	targetGroup_cooldown= 1,
	targetGroup_focus	= 1,
	targetGroup_target	= 1,
	-- sink
	sinkOptions = {},
})
SpellReminder:RegisterDefaults('char', {
	spellSetup	= {
		['*'] = {
			installed	= false,
			showSelf	= true,
			showOther	= true,
			singleTrack	= false,
			--fade		= 0,
		}
	},
})

SpellReminder.hideWithoutStandby = true
SpellReminder.hasNoColor = true
SpellReminder.hasIcon = "Interface\\Icons\\Ability_Warrior_BattleShout"
SpellReminder.independentProfile = true

--SpellReminder.RegisteredBarGroups = {}

local spellSuffixes = {"",L[" Totem"],L[" Weapon"]}
--SpellReminder.barTypes = {"buff","debuff","cooldown"}

SpellReminder.anchors = {}

local defaultBarGroup = { name="New Bar", growup = false, emphasise=true, position = {}, cantEdit = false, scale = 1, }
--local castFailBuffer = 1
--local barRefreshBuffer = 0.5

-- stores information PER SPELL[Target]
SpellReminder.track = {
	casting = {},
	active = {},
}
local spellTracker = SpellReminder.track

function SpellReminder:OnInitialize()
--	self:RegisterChatCommand({'/SpellReminder'}, self.options)
	LibStub("LibBars-1.0"):Embed(self)
	LibStub("LibSink-2.0"):Embed(self)
	self:SetSinkStorage(self.db.profile.sinkOptions)
	self.options.args.output = self:GetSinkAce2OptionsDataTable(self).output
	
	self.OnMenuRequest = self.options
	self:RegisterChatCommand('/SpellReminder', {
		type = 'execute',
		func = function()
			self:OpenMenu()
		end
	})
end

function SpellReminder:COMBAT_LOG_EVENT(...)
	local eventName = select(2,...)
	if self.combatlog_events[eventName] ~= nil then
		self.combatlog_events[eventName](self,self:ProcessCombatLogArgs(...))
	end
end

function SpellReminder:AutoTanks(post)
	local groupHP, maxHP, minHP, groupCount, inRaid = 0,0,0,0,UnitInRaid("player")
	if inRaid then
		for i = 1, 40, 1 do
			if UnitExists("raid"..i) then
				local unitHP = UnitHealthMax("raid"..i)
				groupHP = groupHP + unitHP
				maxHP = max(maxHP,unitHP)
				minHP = min(minHP,unitHP)
				groupCount = groupCount + 1
			end
		end
	else
		local unitHP = UnitHealthMax("player")
		groupHP = groupHP + unitHP
		maxHP = max(maxHP,unitHP)
		minHP = min(minHP,unitHP)
		groupCount = groupCount + 1
		for i = 1, 4, 1 do
			if UnitExists("party"..i) then
				local unitHP = UnitHealthMax("party"..i)
				groupHP = groupHP + unitHP
				maxHP = max(maxHP,unitHP)
				minHP = min(minHP,unitHP)
				groupCount = groupCount + 1
			end
		end
	end
	local averageHP = groupHP / groupCount
	local threshold = averageHP + ((maxHP-averageHP) / 3)
	
	if inRaid then
		for i = 1, 40, 1 do
			if UnitExists("raid"..i) then
				local unitHP = UnitHealthMax("raid"..i)
				if unitHP >= threshold then
					self:Print("AutoTank: "..UnitName("raid"..i))
				end
			end
		end
	else
		local unitHP = UnitHealthMax("player")
		if unitHP >= threshold then
			if post then
						
			else
				self:Print("AutoTank: "..UnitName("player").." "..unitHP.." >= "..threshold)
			end
		end	
		for i = 1, 4, 1 do
			if UnitExists("party"..i) then
				local unitHP = UnitHealthMax("party"..i)
				if unitHP >= threshold then
					self:Print("AutoTank: "..UnitName("party"..i).." "..unitHP.." >= "..threshold)
				end
			end
		end
	end
end

function SpellReminder:OnEnable()
	self:OnProfileEnable()
    -- Called when the addon is loaded
	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED","COMBAT_LOG_EVENT")
--	self:RegisterEvent("UNIT_SPELLCAST_SENT")
--	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
--	self:RegisterEvent("UNIT_SPELLCAST_STOP")
--	self:RegisterEvent("UNIT_SPELLMISS")
--	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP")
	self:RegisterEvent("PLAYER_DEAD")
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN","ProcessSpellCooldowns")
	self:RegisterEvent("PLAYER_ENTERING_WORLD",function() self:ProcessSpellCooldowns(true) end)
	
	self:RegisterEvent("UNIT_PET",function (unit)
		if unit ~= "player" then return end -- only process for players pet.
		for eventName,info in pairs(spellTracker.active) do -- first clear all CD timers, this will stop  multiple bars when zoning
			if info.tGUID == "PET" then
				self:CleanUp(eventName)--self:OnDurationEnded(eventName,true)
			end
		end
		self:ProcessAuras("pet")
	end)
	
--	self:RegisterParserEvent({eventType = "Death"},"COMBAT_DEATH")

--	self:RegisterEvent("CHARACTER_POINTS_CHANGED","InstallAllSpells")
--	self:RegisterEvent("LEARNED_SPELL_IN_TAB","InstallAllSpells")


--	self:RegisterCombatLogEvent('SPELL_AURA_BROKEN_SPELL',function(t,moo) self:PrintLiteral(moo) end)
--	self:RegisterCombatLogEvent('SPELL_INTERRUPT',function(t,moo) self:PrintLiteral(moo) end)
--	self:RegisterEvent("UNIT_SPELLCAST_DELAYED",function(unit) if unit == "player" then self:ProcessAuras(unit) end end)
--	self:RegisterEvent("PARTY_MEMBERS_CHANGED","AutoTanks")
	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP",function(unit,spell,rank)
		local info = self.db.char.spellSetup[spell]
		if unit == "player" and info.installed and info.persist ~= false then
			self:CleanUp(self:GetEventName(spell,UnitGUID("player")),true)
		end
	end)
	
	-- START
	self:RegisterCombatLogEvent('SPELL_CAST_SUCCESS')
--	self:RegisterCombatLogEvent('SPELL_MISSED') -- no longer required since majority of tracking is done with auras (if an aura is ever detected then the spellcast is ignored and we wait for the aura)
	self:RegisterCombatLogEvent('UNIT_DIED')
	self:RegisterCombatLogEvent('PARTY_KILL','UNIT_DIED')
	self:RegisterCombatLogEvent('UNIT_DESTROYED','UNIT_DIED')
	self:RegisterEvent('UNIT_INVENTORY_CHANGED',function(unit) if unit == "player" then self:ScheduleEvent(self.ProcessAuras,0.5,self,"player")  end end)
--	self:RegisterCombatLogEvent('ENCHANT_APPLIED',function() self:ScheduleEvent(self.ProcessAuras,1,self,"player") end)
--	self:RegisterCombatLogEvent('ENCHANT_REMOVED',function() self:ScheduleEvent(self.ProcessAuras,1,self,"player") end)
--	self:RegisterCombatLogEvent('SPELL_AURA_APPLIED')
--	self:RegisterCombatLogEvent('SPELL_AURA_REMOVED')
--	self:RegisterCombatLogEvent('SPELL_AURA_DISPELLED','SPELL_AURA_REMOVED')
--	self:RegisterCombatLogEvent('SPELL_AURA_STOLEN','SPELL_AURA_REMOVED')

	self:RegisterEvent("PLAYER_TARGET_CHANGED",function()
--[[		for i,v in pairs(spellTracker.active) do
			if v.tID == "target" then v.tID = nil end
			if v.tGUID == UnitGUID("target") then
				v.tID = self:GetTargetId("target",v.tID)
			elseif v.tGUID == UnitGUID("focus") then
				v.tID = self:GetTargetId("focus",v.tID)
			end
		end
		self:() ]]
		self:ProcessAuras("target")
	end)
	self:RegisterEvent("UPDATE_MOUSEOVER_UNIT",function() self:ProcessAuras("mouseover") end)

--	self:RegisterEvent("UNIT_AURA",function(unit) self:ProcessAuras(unit) end)
	self:RegisterBucketEvent("UNIT_AURA",0.25,function(units)
		for unit in pairs(units) do
			self:ProcessAuras(unit,true)
		end
		self:RefreshAllBars()
	end)
--	self:RegisterCombatLogEvent('SPELL_AURA_APPLIED',function(instance,moo) self:PrintLiteral(moo) end)
--	self:RegisterCombatLogEvent('SPELL_AURA_REFRESH',function(instance,moo) self:PrintLiteral(moo) end)
--	self:RegisterCombatLogEvent('SPELL_AURA_REMOVED',function(instance,moo) self:PrintLiteral(moo) end)
--	self:RegisterCombatLogEvent('SPELL_AURA_BROKEN_SPELL',function(instance,moo) self:PrintLiteral(moo) end)
	
	
	self:RegisterEvent("PLAYER_TOTEM_UPDATE", function() self:ProcessAuras("player") end)
	self:RegisterEvent("PLAYER_FOCUS_CHANGED",function()
	--[[	for i,v in pairs(spellTracker.active) do
			if v.tID == "focus" then v.tID = nil end
			if v.tGUID == UnitGUID("target") then
				v.tID = self:GetTargetId("target",v.tID)
			elseif v.tGUID == UnitGUID("focus") then
				v.tID = self:GetTargetId("focus",v.tID)
			end
		end]]
--		self:RefreshAllBars()
		self:ProcessAuras("focus")
	end)
	
--	self:ScheduleRepeatingEvent(self.RefreshAllBars, 0.5, self) -- refresh bars now happens every second instead of every single aura update, (bucketed aura updates instead)
	-- END
	
--	self:RegisterCombatLogEvent('SPELL_ENERGIZE')
--	self:RegisterCombatLogEvent('ENCHANT_APPLIED')
--	self:RegisterCombatLogEvent('ENCHANT_REMOVED')
	
	--self:RegisterEvent("UNIT_SPELLCAST_SENT")
--	self:RegisterEvent("SPELL_CAST_START")
	
--	self:RegisterEvent("SpecialEvents_UnitBuffLost","SE_AURA_LOST")
--	self:RegisterEvent("SpecialEvents_PlayerItemBuffLost","SE_ITEM_AURA_LOST")
	
--	self:RegisterEvent("UNIT_SPELLCAST_DELAYED",function(unit) if unit == "player" then self:ProcessAuras(unit) end end)

--	self:RegisterEvent("PLAYER_AURAS_CHANGED",function() self:ProcessAuras("player") end)
--	self:RegisterEvent("UNIT_PET",function(unit) self:DebugPrint("Pet changed, rescanning") if unit == "player" then self:InstallAllSpells() end end)
--CHAT_MSG_SPELL_SELF_DAMAGE
	
	self:CreateAnchors()
	
--	self:ClearSpells(false)
--	self:InstallAllSpells()
	self:RefreshSpellOptions()
end

function SpellReminder:OnProfileEnable()
	-- convert old info
	self.db.profile.barposition = self:del(self.db.profile.barposition)
	self.db.profile.splitSelf = self:del(self.db.profile.splitSelf)
	
	if self.db.char.bargroups ~= nil then -- move bars from char to profile
		if self.db.profile.bargroups == nil then self.db.profile.bargroups = self:new() end
		self:tcopy(SpellReminder.db.char.bargroups,SpellReminder.db.profile.bargroups)
		self.db.char.bargroups = self:del(self.db.char.bargroups)
	end
	-- end
	
	
	self:CreateAnchors()
	self:RefreshFilterPrioOptions()
end

function SpellReminder:GetEventName(spellName,targetName)
	if self.db.char.spellSetup[spellName].installed and self.db.char.spellSetup[spellName].singleTrack == true then targetName = "" end
	return "SpellReminder_TRACKING_"..spellName..";"..targetName
end

function SpellReminder:GetCastingObject(spellName,displayName,spellRank,targetName,targetGUID,timeStarted,duration,remainder,eventName,colour,bartype,icon,targetID)
	targetID = self:GetTargetId(targetID)
--	local info = self.db.char.spellSetup[spellName]
	
	castingInfo = self:new()
	castingInfo.n 			= spellName
	castingInfo.displayName	= displayName
	castingInfo.rank		= spellRank
	castingInfo.t			= targetName
	castingInfo.tID			= targetID
	castingInfo.tGUID		= targetGUID
	castingInfo.s			= timeStarted
	castingInfo.d			= duration
	castingInfo.r			= remainder
	castingInfo.eventName	= eventName
	castingInfo.c			= colour
	castingInfo.barType		= bartype
	castingInfo.icon		= icon
--	castingInfo.persist		= info and info.persist ~= false
	return castingInfo
end
SpellReminder.idPriority = {"target","focus"}
function SpellReminder:GetTargetId(newID,oldID)
--	self:Print(type(newID))
--	local proposedID = newID
--	if type(newID) == "number" then
		-- check flags
--	end
	
	-- prio :    focus -> target -> nil
	for i,v in ipairs(SpellReminder.idPriority) do
		if (oldID == nil and newID == v) or oldID == v or newID == v then return v end
	end
	return nil
end

function SpellReminder:GetSpellSetup(spellName,spellType)
	if spellType == SPELLTYPE_NORMAL then
		spellType = ''
	else
		spellType = spellType..';'
	end
	return self.db.char.spellSetup[spellType..spellName]
end

function SpellReminder:PLAYER_LOGIN()
--	self:CheckNonFade()
	self:ProcessAuras("player")
	self:ProcessAuras("pet")
	self:ProcessSpellCooldowns()
--	self:ScheduleEvent(self.ProcessAuras,0.5,self,"player")
--	self:ScheduleEvent(self.CheckNonFade,5,self)
end
--[[
function SpellReminder:CheckNonFade()
	for spellName,info in pairs(self.db.char.spellSetup) do
		if info.fade == -1 and not self:BarExists(spellName) then
			local duration, rank = info.d,info.rank
			local targetGUID = UnitGUID("player")
			local eventName = self:GetEventName(spellName,targetGUID)
			local castingInfo = self:GetCastingObject(spellName,info.displayName,rank,UnitName("player"),targetGUID,GetTime(),duration,info.r,eventName,info.c,"buff")
			castingInfo.icon = info.icon
			castingInfo.applications = 0
			self:TrackSpell(castingInfo)
			--self:CreateReminderBar(eventName, castingInfo, 0)
		end
	end
end]]
	
function SpellReminder:OnDisable()
--[[
    -- Called when the addon is disabled
	self:UnregisterEvent("PLAYER_LOGIN")
	self:UnregisterEvent("UNIT_SPELLCAST_SENT")
	self:UnregisterEvent("UNIT_SPELLCAST_STOP")
	self:UnregisterEvent("UNIT_SPELLMISS")
	self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:UnregisterEvent("PLAYER_DEAD")
	self:UnregisterParserEvent({eventType = "Death"},"COMBAT_DEATH")

	
	self:UnregisterEvent("SpecialEvents_UnitBuffLost","SE_AURA_LOST")
	self:UnregisterEvent("SpecialEvents_PlayerItemBuffLost","SE_ITEM_AURA_LOST")

	self:UnregisterEvent("PLAYER_AURAS_CHANGED",function() self:ProcessAuras("player") end)
	self:UnregisterEvent("PLAYER_TARGET_CHANGED",function() self:ProcessAuras("target") end)
	self:UnregisterEvent("UNIT_AURA",function(unit) self:ProcessAuras(unit) end)
	self:UnregisterEvent("UNIT_PET",function(unit) self:DebugPrint("Pet changed, rescanning") if unit == "player" then self:InstallAllSpells() end end)
	self:UnregisterEvent("CHARACTER_POINTS_CHANGED","InstallAllSpells")
	self:UnregisterEvent("LEARNED_SPELL_IN_TAB","InstallAllSpells")

	-- stop all spell watch events
--	table.foreach(self.db.char.spellSetup, function(k,v) self:CancelWatchSpell(k) end)
	candybar:UnregisterCandyBarGroup("SpellReminderNormal")
	candybar:UnregisterCandyBarGroup("SpellReminderEmphasis")
	]]
end

function SpellReminder:AddNewAnchor(overrideProperties,dontCreate)
	local newGroup = self:new(); self:tcopy(defaultBarGroup,newGroup)
	if overrideProperties == nil then return newGroup end
	-- need to override
	for k,v in pairs(overrideProperties) do newGroup[k] = v end
	
	table.insert(SpellReminder.db.profile.bargroups,newGroup)
	if not dontCreate then
		self:CreateAnchors()
	end
	
	return # SpellReminder.db.profile.bargroups
end

function SpellReminder:GetAnchorByIdent(val)
	for k,anchor in pairs(SpellReminder.db.profile.bargroups) do
		if anchor.ident == val then return k end
	end
	return nil
end

function SpellReminder:CreateAnchors()
	if self:GetAnchorByIdent("normal") == nil then
		self:AddNewAnchor({ ident="normal",		name=L["Normal"],		cantEdit=true, position=(self.db.profile.barposition and self.db.profile.barposition["normal"]) or self:new(), },true)
	end
	if self:GetAnchorByIdent("emphasis") == nil then
		self:AddNewAnchor({ ident="emphasis",	name=L["Emphasis"],	cantEdit=true, position=(self.db.profile.barposition and self.db.profile.barposition["emphasis"]) or self:new(), },true)
	end

	for i,groupinfo in pairs(SpellReminder.db.profile.bargroups) do
		if groupinfo == nil then
			self.db.profile.bargroups[i] = self:del(self.db.profile.bargroups[i])
		else
			if self.anchors[i] == nil then self.anchors[i] = self:new() end
			self:tcopy(groupinfo,self.anchors[i])
			-- new LibBars
			if self.anchors[i].LBframe == nil then
				self.anchors[i].LBframe = self:NewBarGroup(groupinfo.name, 1, self.db.profile.barwidth, self.db.profile.barheight, "ReminderFrame_"..i)
				self.anchors[i].LBframe.RegisterCallback(self,'AnchorMoved')
			end
			local LBframe = self.anchors[i].LBframe
			LBframe:SetWidth(self.db.profile.barwidth)
			LBframe.width = self.db.profile.barwidth
			LBframe:SetHeight(self.db.profile.barheight)
			LBframe.height = self.db.profile.barheight
			LBframe:SetSortFunction(sortFunc)
			LBframe:ClearAllPoints()
			if self.db.profile.bargroups[i] and self.db.profile.bargroups[i].position and self.db.profile.bargroups[i].position.x and self.db.profile.bargroups[i].position.y and self.db.profile.bargroups[i].position.point and self.db.profile.bargroups[i].position.anchor then
				LBframe:SetPoint(self.db.profile.bargroups[i].position.point, UIParent, self.db.profile.bargroups[i].position.anchor, self.db.profile.bargroups[i].position.x, self.db.profile.bargroups[i].position.y)
			else
				LBframe:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
			end
			LBframe:SetScale(groupinfo.scale or 1)
			LBframe:ReverseGrowth((self.db.profile.bargroups[i] and self.db.profile.bargroups[i].growup) or false)
			
			--[[ old Custom Anchors
			if self.anchors[i].frame ~= nil then
				self.anchors[i].frame.Text:SetText(self.anchors[i].name)
				if self.db.profile.bargroups[i] and self.db.profile.bargroups[i].position and self.db.profile.bargroups[i].position.x and self.db.profile.bargroups[i].position.y and self.db.profile.bargroups[i].position.point and self.db.profile.bargroups[i].position.anchor then
					self.anchors[i].frame:SetPoint(self.db.profile.bargroups[i].position.point, UIParent, self.db.profile.bargroups[i].position.anchor, self.db.profile.bargroups[i].position.x, self.db.profile.bargroups[i].position.y)
				end
			else
				self.anchors[i].frame = self:CreateAnchor(i,groupinfo.name,0.3,1,0.3)
				self.candybar:RegisterCandyBarGroup("ReminderCandy_"..i)
				self.RegisteredBarGroups["ReminderCandy_"..i] = true
				self.candybar:SetCandyBarGroupPoint("ReminderCandy_"..i, "TOP", self.anchors[i].frame, "BOTTOM", 0, 0)	
				self.candybar:SetCandyBarGroupGrowth("ReminderCandy_"..i, (self.db.profile.bargroups[i] and self.db.profile.bargroups[i].growup) or false)
			end]]
		end
	end
	self:RefreshBarGroupList()
	self:RefreshGroupOptions()
	self:RefreshSpellOptions()
--	self.normalAnchor = self:CreateAnchor("normal","Normal/Target Bars",0.3,1,0.3)
--	self.selfAnchor = self:CreateAnchor("self","Self cast Bars",0.3,1,0.3)
--	self.emphasisAnchor = self:CreateAnchor("emphasis","Emphasised Bars",0.3,1,0.3)

	-- setup candybar
--	candybar:RegisterCandyBarGroup("SpellReminderNormal")
--	candybar:SetCandyBarGroupPoint("SpellReminderNormal", "TOP", self.normalAnchor, "BOTTOM", 0, 0)	
--	candybar:SetCandyBarGroupGrowth("SpellReminderNormal", getOption("growup"))
	
--	candybar:RegisterCandyBarGroup("SpellReminderSelf")
--	candybar:SetCandyBarGroupPoint("SpellReminderSelf", "TOP", self.selfAnchor, "BOTTOM", 0, 0)	
--	candybar:SetCandyBarGroupGrowth("SpellReminderSelf", getOption("growup"))
	
--	candybar:RegisterCandyBarGroup("SpellReminderEmphasis")
--	candybar:SetCandyBarGroupPoint("SpellReminderEmphasis", "TOP", self.emphasisAnchor, "BOTTOM", 0, 0)	
--	candybar:SetCandyBarGroupGrowth("SpellReminderEmphasis", getOption("growup"))

	self:ToggleAnchors()
end

function SpellReminder:ResetAnchors()
--	self.db.profile.bargroups = self:new()
--	self:CreateAnchors()
	
	if not self.db.profile.lockbars then self:ToggleAnchors() end
	for idx,anchor in pairs(self.anchors) do
		self:ResetAnchor(idx)
	end
--	self.normalAnchor:ClearAllPoints()
--	self.normalAnchor:SetPoint("CENTER", 0, 50 /s)
--	self.selfAnchor:ClearAllPoints()
--	self.selfAnchor:SetPoint("CENTER", 0, 0)
--	self.emphasisAnchor:ClearAllPoints()
--	self.emphasisAnchor:SetPoint("CENTER", 0, 150 /s)
	self:SaveAnchorPositions()
end

function SpellReminder:ResetAnchor(id)
	local anchor = self.anchors[id]
	anchor.LBframe:ClearAllPoints()
	anchor.LBframe:SetPoint("CENTER", 0, 50 / anchor.LBframe:GetScale())
end

function SpellReminder:ToggleAnchors()
	if self.db.profile.lockbars then
		for _,anchor in ipairs(self.anchors) do
--			anchor.frame:Hide()
			anchor.LBframe:HideAnchor()
		end
--		self.normalAnchor:Hide()
--		self.selfAnchor:Hide()
--		self.emphasisAnchor:Hide()
	else
		for _,anchor in ipairs(self.anchors) do
--			anchor.frame:Show()
			anchor.LBframe:ShowAnchor()
		end
--		self.normalAnchor:Show()
--		self.selfAnchor:Show()
--		self.emphasisAnchor:Show()
	end
end

function SpellReminder:AnchorMoved(cbk, group, x, y)
	self:SaveAnchorPositions()
--[[
	for i, anchor in pairs(self.anchors) do
		if anchor.LBframe == group then
			local point, parent, anchor, x, y = group:GetPoint()
			self.db.profile.bargroups[i].position2 = self.db.profile.bargroups[i].position2 or self:new()
			self.db.profile.bargroups[i].position2.x = x
			self.db.profile.bargroups[i].position2.y = y
			self.db.profile.bargroups[i].position2.anchor = anchor
			self.db.profile.bargroups[i].position2.parent = parent
			self.db.profile.bargroups[i].position2.point = point
		end
	end]]
end

function SpellReminder:DeleteBarGroup(id)
	self.anchors[id].LBframe:Hide()
	self.anchors[id] = nil
	self.db.profile.bargroups[id] = nil
	
	local normalId = self:GetAnchorByIdent('normal')
	
	for spellName,info in pairs(self.db.char.spellSetup) do
		if info.allowCustomGroup == true and info.customGroup == id then
			info.allowCustomGroup = false
			info.customGroup = normalId
			self:Print(L["%s has had its custom group reset."]:format(spellName))
		end
	end
	
	if self.db.profile.targetGroup_self		== id then self.db.profile.targetGroup_self = normalId; 	self:Print(L["Filter for '%s' has been reset."]:format("Self")) end
	if self.db.profile.targetGroup_buff		== id then self.db.profile.targetGroup_buff = normalId; 	self:Print(L["Filter for '%s' has been reset."]:format("Buffs")) end
	if self.db.profile.targetGroup_debuff	== id then self.db.profile.targetGroup_debuff = normalId; 	self:Print(L["Filter for '%s' has been reset."]:format("Debuffs")) end
	if self.db.profile.targetGroup_cooldown	== id then self.db.profile.targetGroup_cooldown = normalId; self:Print(L["Filter for '%s' has been reset."]:format("Cooldowns")) end
	if self.db.profile.targetGroup_focus	== id then self.db.profile.targetGroup_focus = normalId; 	self:Print(L["Filter for '%s' has been reset."]:format("Focus")) end
	if self.db.profile.targetGroup_target	== id then self.db.profile.targetGroup_target = normalId;	self:Print(L["Filter for '%s' has been reset."]:format("Target")) end
	
	self:Print(L["You should reload your UI after deleting a bar group."])
	
	self:RefreshSpellOptions()
	self:CreateAnchors()
end

function SpellReminder:SaveAnchorPositions()
--	local s = this:GetEffectiveScale()
	for i, anchorFrame in pairs(self.anchors) do
		local point, _, anchor, x, y = anchorFrame.LBframe:GetPoint()
		self.db.profile.bargroups[i].position.x = x --* s
		self.db.profile.bargroups[i].position.y = y --* s
		self.db.profile.bargroups[i].position.anchor = anchor
		self.db.profile.bargroups[i].position.point = point
	end
	--[[
	local point, _, anchor, x, y = self.normalAnchor:GetPoint()
	self.db.profile.barposition["normal"].x = x * s
	self.db.profile.barposition["normal"].y = y * s
	self.db.profile.barposition["normal"].anchor = anchor
	self.db.profile.barposition["normal"].point = point
	
	local point, _, anchor, x, y = self.selfAnchor:GetPoint()
	self.db.profile.barposition["self"].x = x * s
	self.db.profile.barposition["self"].y = y * s
	self.db.profile.barposition["self"].anchor = anchor
	self.db.profile.barposition["self"].point = point
	
	local point, _, anchor, x, y = self.emphasisAnchor:GetPoint()
	self.db.profile.barposition["emphasis"].x = x * s
	self.db.profile.barposition["emphasis"].y = y * s
	self.db.profile.barposition["emphasis"].anchor = anchor
	self.db.profile.barposition["emphasis"].point = point
	]]
end

function SpellReminder:CreateAnchor(name, text, cRed, cGreen, cBlue)
	local f = CreateFrame("Button", "SpellReminder_"..name.."Anchor", UIParent)
	f:SetWidth(200)
	f:SetHeight(25)

	f.owner = self

--	local s = this:GetEffectiveScale()
	f:ClearAllPoints()
--	if (#self.db.profile.bargroups == 0) and self.db.char.bargroups ~= nil then
--		tcopy(self.db.char.bargroups,self.db.profile.bargroups)
--	end
	if self.db.profile.bargroups[name] and self.db.profile.bargroups[name].position and self.db.profile.bargroups[name].position.x and self.db.profile.bargroups[name].position.y and self.db.profile.bargroups[name].position.point and self.db.profile.bargroups[name].position.anchor then
		f:SetPoint(self.db.profile.bargroups[name].position.point, UIParent, self.db.profile.bargroups[name].position.anchor, self.db.profile.bargroups[name].position.x, self.db.profile.bargroups[name].position.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER", 0, 50)--/s)
	end

	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
		function()
			this:StopMovingOrSizing()
			self:SaveAnchorPositions()
        end)

	f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
                                            edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
                                            tile = false, tileSize = 16, edgeSize = 16,
                                            insets = { left = 5, right =5, top = 5, bottom = 5 }})
	f:SetBackdropColor(cRed,cGreen,cBlue,.6)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")

	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFontObject(GameFontNormalSmall)
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(1, 1, 1, 1)
	f.Text:SetWidth(200)
	f.Text:SetHeight(25)
	f.Text:SetPoint("TOPLEFT", f, "TOPLEFT")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	f.Text:SetText(text)

	f:Hide()

	return f
end

function SpellReminder:CreateTestBars()
	local i
	for i=1, 5 do
		local castingInfo
		if math.random()>0.5 then -- debuff
			castingInfo = self:GetCastingObject("Test "..i,nil,nil,"Enemy "..i,'NaN',GetTime(),i*5,i*2,"TEST_MANUAL_"..i,{r=math.random(),g=math.random(),b=math.random()},"debuff",'Interface\\Icons\\INV_Misc_QuestionMark')
		else
			local pseudoTarget = (math.random() > 0.5 and "Player "..i) or "Friendly "..i
			castingInfo = self:GetCastingObject("Test "..i,nil,nil,pseudoTarget,'NaN',GetTime(),i*5,i*2,"TEST_MANUAL_"..i,{r=math.random(),g=math.random(),b=math.random()},"buff",'Interface\\Icons\\INV_Misc_QuestionMark')
		end
--		castingInfo.persistant = true
		self:TrackSpell(castingInfo,true)--self:CreateReminderBar(castingInfo.eventName,castingInfo)
	end
	
	local castingInfo = self:GetCastingObject("Focus Test",nil,nil,"Focus",'NaN',GetTime(),25,10,"TEST_FOCUS",{r=math.random(),g=math.random(),b=math.random()},"buff",'Interface\\Icons\\INV_Misc_QuestionMark',"focus")
--	castingInfo.persistant = true
	self:TrackSpell(castingInfo,true)

	local castingInfo = self:GetCastingObject("Target Test",nil,nil,"Target",'NaN',GetTime(),25,10,"TEST_TARGET",{r=math.random(),g=math.random(),b=math.random()},"buff",'Interface\\Icons\\INV_Misc_QuestionMark',"target")
--	castingInfo.persistant = true
	self:TrackSpell(castingInfo,true)
	
	self:RefreshAllBars()
end

function SpellReminder:ClearSpells(clearAll)
	for spellName,info in pairs(self.db.char.spellSetup) do
		if (clearAll == true) or (clearAll == "inactive" and info.active == false) then
			self:ClearSpell(spellName,true)
		elseif (info.detected ~= true) then
			local found = false
			local i = 1
			while true do
				local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
				if (not spell) then	break end
				if spell == spellName then
					found = true
				end
				i = i + 1
			end
			
			if found == false then self:ClearSpell(spellName,true) end
		end
	end
	
	self:RefreshSpellOptions()
end

function SpellReminder:ClearSpell(spellName,dontRefresh)
	self.db.char.spellSetup[spellName] = self:del(self.db.char.spellSetup[spellName])
	self.spellOptions[spellName] = self:del(self.spellOptions[spellName])
	if not dontRefresh then self:RefreshSpellOptions() end
end

function SpellReminder:InstallWatch(spellName,rank,reminder,duration,icon)--,sharedName,reminder)
	if spellName == nil then return end
	if duration == nil then return end -- this can happen if the spell isnt available on this character

	local realSpellName = spellName
	if string.find(realSpellName,":") then
		_,_,_,realSpellName = string.find(realSpellName,"(.*):(.*)")
	end
		
	self:DebugPrint("Adding spell: "..realSpellName)
	self.db.char.spellSetup[spellName].installed = true
	if (self.db.char.spellSetup[spellName].active == nil) then
		self.db.char.spellSetup[spellName].active = true
	end
	--self.db.char.spellSetup[spellName].s		= self.db.char.spellSetup[spellName].s or sharedName or spellName
	self.db.char.spellSetup[spellName].displayName = self.db.char.spellSetup[spellName].displayName or realSpellName
	self.db.char.spellSetup[spellName].rank		= rank
	
	self.db.char.spellSetup[spellName].icon = icon or self:GetTexture(spellName)
	
	if self.db.char.spellSetup[spellName].d == nil or duration > self.db.char.spellSetup[spellName].d then
		self.db.char.spellSetup[spellName].d	= duration
		local defaultReminder = ClipNumber(math.ceil(duration*0.125),5,15,duration)--max(min(math.ceil(duration*0.125),15),5)
--		if defaultReminder < 5 and duration > 5 then defaultReminder = 5 end
--		if defaultReminder > 30 then defaultReminder = 30 end
		self.db.char.spellSetup[spellName].r	= self.db.char.spellSetup[spellName].r or reminder or defaultReminder
--[[		if durationDebuff ~= nil then
			local defaultReminder = math.ceil(durationDebuff*0.125)
			if defaultReminder < 5 and durationBuff > 5 then defaultReminder = 5 end
			if defaultReminder > 30 then defaultReminder = 30 end
			self.db.char.spellSetup[spellName].rd = self.db.char.spellSetup[spellName].rd or defaultReminder
			self.db.char.spellSetup[spellName].dd = durationDebuff
		end]]
	end
	if self.RefreshSpellOptions then
		self:RefreshSpellOptions()
	end
	return self.db.char.spellSetup[spellName]
end

function SpellReminder:InstallAllSpells()
	self.bsoTmp = self.RefreshSpellOptions
	self.RefreshSpellOptions = nil -- allows faster addition of spells without calling BSO on each add.
	
	local i = 1
	while true do
		local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
		if (not spell) then	break end
		self:InstallWatch(spell,rank)
		i = i + 1
	end
	--[[ still not found? try pets spellbook
	local i = 1
	while true do
		local spell, rank = GetSpellName(i, BOOKTYPE_PET)
		if (not spell) then	break end
		self:InstallWatch(spell,rank)
		i = i + 1
	end]]
	--[[ also talents???
	local numTabs = GetNumTalentTabs();
	for t=1, numTabs do
	    local numTalents = GetNumTalents(t);
	    for i=1, numTalents do
	        nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(t,i);
			self:InstallWatch(nameTalent,currRank)
	    end
	end]]
	self.RefreshSpellOptions = self.bsoTmp -- reinstate BSO
	self:RefreshSpellOptions()
end

function SpellReminder:FlagIsSet(flags,flag)
	return bit.band(flags,flag) == flag
end

--[[function SpellReminder:PLAYER_TOTEM_UPDATE(slot)
	local haveTotem, spellName, startTime, duration, icon = GetTotemInfo(slot)
	local eventName = self:GetEventName('TOTEM_'..slot,UnitGUID("player"))
	
	spellName = string.gsub(spellName," Totem.*"," Totem")
	local info = self.db.char.spellSetup[spellName]
	
	if spellName == "" then
		self:OnDurationEnded(eventName)
		return
	end

	if not info then
		info = self:InstallWatch(spellName,rank,nil,duration,icon)
	end	
	local castingInfo = self:TrackSpell(self:GetCastingObject(spellName,info.displayName,'',UnitName("player"),UnitGUID("player"),startTime,duration,info.r,eventName,info.c,"buff",icon))
--	spellTracker.active[eventName] = castingInfo
	
	castingInfo.persistent = info.persistent
	--self:CreateReminderBar(castingInfo.eventName,castingInfo)
--	self:RefreshAllBars()
end

--function SpellReminder:SPELL_ENERGIZE(t)
	if not self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_AFFILIATION_MINE) then return end
	--self:PrintLiteral(t)
	
end
--function SpellReminder:UNIT_SPELLCAST_SENT(caster,name,rank,target)
	if caster ~= "player" then return end -- potions dont trigger spellcast_sent
	self:DebugPrint(name)
end
--function SpellReminder:UNIT_SPELLCAST_SUCCEEDED(caster,name,rank)
	-- if 
end]]
function SpellReminder:SPELL_CAST_SUCCESS(t)
	--if caster ~= "player" then return end
	if not (self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_TYPE_PLAYER) and self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_AFFILIATION_MINE)) then return end
	if self:FlagIsSet(t.destFlags,COMBATLOG_OBJECT_NONE) then
		t.destGUID = t.sourceGUID
		t.destName = t.sourceName
		t.destFlags = t.sourceFlags
	end
--	if string.find(t.spellName," Totem$") ~= nil then return end
	
	self:DebugPrint(string.format("SPELL_CAST_SUCCESS: %s -> %s : %s (%s~%s)",t.sourceName or '',t.destName or '',t.spellName or '',t.spellId or '',t.spellSchool or 0))
--	self:PrintLiteral(t)
	local _,spellRank, icon = GetSpellInfo(t.spellId)
	
	if not self.db.char.spellSetup[t.spellName].installed and self.db.profile.disableDetection == false
		and (IsControlKeyDown() and IsShiftKeyDown()) then
		_,_,texture = GetSpellInfo(t.spellId)
		self:InstallWatch(t.spellName,"",nil,self:GetDuration(t.spellName),texture)
	end
	local info = self.db.char.spellSetup[t.spellName]
	info.spellId = t.spellId
	if not info.installed or not info.active or not info.d or info.persist == false then return end

	local duration = info.d
	
	if spellTracker.casting == nil then spellTracker.casting = self:new() end
	local bt = 'buff'
	if self:FlagIsSet(t.destFlags,COMBATLOG_OBJECT_REACTION_HOSTILE) then
		bt = 'debuff'
	end
	
	--local bt = ((destName == nil or self:FlagIsSet(destFlags,COMBATLOG_OBJECT_REACTION_HOSTILE)) and "buff") or "debuff" --bartype
	local eventName, castingEvent = self:GetEventName(t.spellName,t.destGUID)
	self:TrackSpell(self:GetCastingObject(t.spellName,info.displayName,spellRank,t.destName,t.destGUID,GetTime(),duration,info.r,eventName,info.c,bt,info.icon))
--	if spellTracker.casting[eventName] == nil then 
--		spellTracker.casting[eventName] = self:GetCastingObject(t.spellName,info.displayName,spellRank,t.destName,t.destGUID,GetTime(),duration,info.r,eventName,info.c,bt,info.icon)
--	end
	
--	self:ScheduleEvent(self.FinalCastSuccess,castFailBuffer,self,eventName)
end
function SpellReminder:SPELL_MISSED(t)
	if not (self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_TYPE_PLAYER) and self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_AFFILIATION_MINE)) then return end
	local _,spellRank = GetSpellInfo(t.spellId)
	local eventName = self:GetEventName(t.spellName,t.destGUID)
--	for eventName,spell in pairs(spellTracker.casting) do
	--	if spell.n == t.spellName and spell.rank == spellRank then
			spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
--		end
--	end
--	for eventName,spell in pairs(spellTracker.active) do
--		if spell.n == t.spellName and spell.rank == spellRank then
--			self:OnDurationEnded(eventName,true)
--		end
--	end
end
function SpellReminder:UNIT_DIED(t)
	self:DebugPrint(t.event..": "..t.destName)
	for eventName,info in pairs(spellTracker.casting) do
		if info.tGUID == t.destGUID then
			self:CleanUp(eventName)--spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
--			self:OnDurationEnded(eventName,true)
		end
	end
	for eventName,info in pairs(spellTracker.active) do
		if info.tGUID == t.destGUID then
			self:CleanUp(eventName)--spellTracker.active[eventName] = self:del(spellTracker.active[eventName])
--			self:OnDurationEnded(eventName,true)
		end
	end
	self:RefreshAllBars()
end
--[[function SpellReminder:SPELL_AURA_APPLIED(t)
	if self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_NONE) then
		t.sourceGUID = t.destGUID
		t.sourceName = t.destName
		t.sourceFlags = t.destFlags
	end
	if not self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_AFFILIATION_MINE) then return end
--	self:PrintLiteral(t)
	
	local info = self.db.char.spellSetup[t.spellName]
	if info == nil then return end
	if info.active ~= true then return end

	local buffDuration = info.d
	if buffDuration == nil then return end
	
	local eventName, castingEvent = self:GetEventName(t.spellName,t.destGUID)
	local castingInfo = self:TrackSpell(self:GetCastingObject(t.spellName,info.displayName,spellRank,t.destName,t.destGUID,GetTime(),buffDuration,info.r,eventName,info.c,string.lower(t.auraType)))
	--spellTracker.active[eventName] = castingInfo
	
	--castingInfo.canRemove = false -- changed to spellinfo.persistent
	castingInfo.persistent = self.db.char.spellSetup[castingInfo.n].persistent
	--self:CreateReminderBar(castingInfo.eventName,castingInfo)
	--self:RefreshAllBars()
end
--function SpellReminder:SPELL_AURA_REMOVED(t)
	if self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_NONE) then
		t.sourceGUID = t.destGUID
		t.sourceName = t.destName
		t.sourceFlags = t.destFlags
	end
	if not self:FlagIsSet(t.sourceFlags,COMBATLOG_OBJECT_AFFILIATION_MINE) then return end
	
	local eventName, castingEvent = self:GetEventName(t.spellName,t.destGUID)
	self:OnDurationEnded(eventName)
end]]

function SpellReminder:FinalCastSuccess(eventName)
	if spellTracker.casting[eventName] == nil then return end
--	if spellTracker.active[eventName] ~= nil then 
		-- spell is already active, either its been picked up by aura processing OR its re-applied....
--		spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
--		return
--	end
	
	for e,info in pairs(spellTracker.active) do -- check if pet also has this buff, if it does, cancel the spellcast
		if info.tGUID == "PET" then -- spells on pet are always given the guid PET, snce dismissing the pet always issues a new GUID
			self:CleanUp(eventName)
			--spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
			return
		end
	end

--	spellTracker.active[castingInfo.eventName] = tcopy(spellTracker.casting[castingInfo.eventName])
--	spellTracker.casting[castingInfo.eventName] = nil
	
	self:DebugPrint("finalcast: "..spellTracker.casting[eventName].n)
--	self:Print((self:IsEventRegistered("CASTING_"..castingInfo.n..";"..castingInfo.t) and "is registered") or "not registered")
--	if not self:IsEventRegistered("CASTING_"..castingInfo.n..";"..castingInfo.t) then return end

	-- will be picked up by the aura processor
	local playerGUID = UnitGUID("player")
--	if castingInfo.tGUID == playerGUID and self:GetPlayerBuffDuration(castingInfo.n) ~= nil then --[[self:ProcessAuras("player")]]  return end
	local buffDuration = spellTracker.casting[eventName].d
	if buffDuration == nil then return end

	--castingInfo.canRemove = false -- changed to spellinfo.persistent
--	spellTracker.casting[eventName].persistent = self.db.char.spellSetup[spellTracker.casting[eventName].n].persistent
	self:TrackSpell(spellTracker.casting[eventName])
	spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
--	self:ProcessAuras("player")
end

function SpellReminder:IsTracking(eventName)
	return spellTracker.active[eventName] ~= nil
end

function SpellReminder:TrackSpell(castingInfo,dontRefresh)
	if type(castingInfo) ~= "table" then error("TrackSpell failed.  Expected table, got nil") return end
	local eventName = castingInfo.eventName
	
	local setupInfo = self.db.char.spellSetup[castingInfo.n]
	if castingInfo.tGUID ~= "COOLDOWN" and setupInfo.installed then
		if (not setupInfo.showSelf and castingInfo.tGUID == UnitGUID("player")) or
		   (not setupInfo.showOther and castingInfo.tGUID ~= UnitGUID("player")) then
			spellTracker.active[eventName] = self:del(spellTracker.active[eventName])
			spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
			return
		end
	end -- this spell is flagged as Self Only, but its being cast on another target, ignore bar creation and free active and casting tables for this event.

	if (spellTracker.active[eventName] == nil) then
		spellTracker.active[eventName] = self:new()
		self:DebugPrint("Tracking: "..castingInfo.n)
		-- Announce
		if setupInfo.announceCast then
		local spellName, spellTarget = castingInfo.displayName, (castingInfo.t and castingInfo.t ~= UnitName("player") and " ("..castingInfo.t..")") or ""
		local message = L["%s Has been cast.  Will expire in %d seconds!"]:format(spellName..spellTarget,math.floor(castingInfo.d))
			if setupInfo.announceSay then SendChatMessage(message, "SAY") end
			if setupInfo.announceYell then SendChatMessage(message, "YELL") end
			if setupInfo.announceParty then SendChatMessage(message, "PARTY") end
			if setupInfo.announceRaid then SendChatMessage(message, "RAID") end
		end
	end
		
	self:tcopy(castingInfo,spellTracker.active[eventName])
	castingInfo = self:del(castingInfo)
	if not dontRefresh then
		self:RefreshAllBars()
	end
	return spellTracker.active[eventName]
end

function SpellReminder:RefreshAllBars()--forceRefresh)	
	-- add new bars
	for e,castingInfo in pairs(spellTracker.active) do
		local setupInfo = self.db.char.spellSetup[castingInfo.n]
		local timeLeft = castingInfo.d - (GetTime() - castingInfo.s)
	--	local alreadyExists, needsRefresh = self.candybar:IsCandyBarRegistered(e), false
--		if alreadyExists then
--			local _,totTime,elapsed = self.candybar:CandyBarStatus(e)
--			local barTimeLeft = totTime - (elapsed or 9999)
--			needsRefresh = (barTimeLeft <= timeLeft-barRefreshBuffer) or (barTimeLeft >= timeLeft+barRefreshBuffer) or (castingInfo.applications ~= nil) -- time left is > 1sec out of sync (must be 1second, since time() does not return ms precision)
--		end
		-- persistant ??????
		if (timeLeft <= 0) or (not setupInfo.active) then
			self:OnDurationEnded(e)
		else--if castingInfo.bar == nil or castingInfo.bar.SRstartTime ~= castingInfo.s then-- (castingInfo.bar and castingInfo.bar.startTime ~= castingInfo.s) or forceRefresh then--if --[[(not alreadyExists) or ]]needsRefresh or (castingInfo.targetGroupId ~= targetGroup) or forceRefresh then
--			local resort = false
	--		if castingInfo.bar == nil or castingInfo.bar.SRstartTime ~= castingInfo.s then
	--			resort = true
	--		end
			if setupInfo.installed and setupInfo.c and setupInfo.c ~= castingInfo.c then castingInfo.c = self:new(); self:tcopy(setupInfo.c,castingInfo.c) end-- copy to prevent setup color from being recycled by reference
			self:CreateReminderBar(e,castingInfo,timeLeft)
			if timeLeft - castingInfo.r > 0 then
				self:ScheduleEvent(e, self.OnDurationEnding, timeLeft - (castingInfo.r), self, e)
			end
			self:ScheduleEvent("END_"..e,self.RefreshAllBars, timeLeft, self) -- refresh all instead of call ODE (ode calls Refresh anyway)
--			if resort and castingInfo.bar then
--				castingInfo.bar:GetGroup():SortBars()
--			end
		end
	end
	
	-- any which are still existing as bars, but are no longer active?
	for i, anchor in pairs(self.anchors) do
		local bars = anchor.LBframe:GetBars()
		if bars then for e,bar in pairs(bars) do
			if spellTracker.active[e] == nil then --and not bar.fading then
--				self:PrintLiteral(spellTracker)
--				self:Print('force fade 2: '..e)
				bar:Fade()
--				anchor.LBframe:SortBars()
			end
		end end
	--	local activeBar = spellTracker.active[eventName].bar
	--	if activeBar then activeBar:GetGroup():RemoveBar(activeBar) end
	end
end

function SpellReminder:FindTargetGroup(castingInfo)
	local targetGroupId = nil
	local setupInfo = self.db.char.spellSetup[castingInfo.n]
	
	if setupInfo.installed and setupInfo.allowCustomGroup and setupInfo.customGroup and castingInfo.barType ~= "cooldown" then
		return setupInfo.customGroup
	end
		
	for _,fltrName in ipairs(self.db.profile.filterPrio) do
		if (castingInfo.barType == fltrName) or castingInfo.tGUID == UnitGUID((fltrName == "self" and "player") or fltrName) then
			return self.db.profile['targetGroup_'..fltrName]
		end
	end
	return self:GetAnchorByIdent('normal')
end
--[[	
	if castingInfo.barType == "cooldown" then
		targetGroupId = self.db.profile.targetGroup_cooldown
		
	elseif setupInfo.installed and setupInfo.allowCustomGroup and setupInfo.customGroup then
		targetGroupId = setupInfo.customGroup
		
	elseif castingInfo.tID ~= nil and self.db.profile['targetGroup_'..castingInfo.tID] then  -- obsolete ?
		targetGroupId = self.db.profile['targetGroup_'..castingInfo.tID]
		
	elseif castingInfo.tGUID == UnitGUID("target") then  -- target
		targetGroupId = self.db.profile['targetGroup_target']
		
	elseif castingInfo.tGUID == UnitGUID("focus") then   -- focus
		targetGroupId = self.db.profile['targetGroup_focus']
		
	elseif castingInfo.tGUID == UnitGUID("player") then  -- player
		targetGroupId = self.db.profile.targetGroup_self
		
	elseif castingInfo.barType == "buff" then
		targetGroupId = self.db.profile.targetGroup_buff
		
	elseif castingInfo.barType == "debuff" then
		targetGroupId = self.db.profile.targetGroup_debuff
	end
	
	if targetGroupId == nil then
		targetGroupId = self:GetAnchorByIdent('normal')
	end
	
	return targetGroupId
end]]


function SpellReminder:CreateReminderBar(e, castingInfo, timeLeft, targetGroupId)
	local color = castingInfo.c or self.db.profile.defaultBarColor
	local duration = castingInfo.d
	local reminder = castingInfo.r
	local target = castingInfo.t or UnitName("player")

	if targetGroupId == nil then
		targetGroupId = self:FindTargetGroup(castingInfo)
		if timeLeft <= reminder and (self.db.profile.bargroups[targetGroupId] and self.db.profile.bargroups[targetGroupId].emphasise) then
			targetGroupId = self:GetAnchorByIdent("emphasis")
		end
	end
	if targetGroupId < 1 then
		if castingInfo.bar then
			castingInfo.bar:Fade()
			castingInfo.bar = nil
		end
		return
	end
	
	castingInfo.targetGroupId = targetGroupId
	local targetLibBarGroup = self.anchors[targetGroupId].LBframe
--	targetLibBarGroup:SortBars()
	
	-- build name
	local text = castingInfo.customFormat or self.db.profile.textFormat
	text = string.gsub(text,"%%n",castingInfo.displayName or castingInfo.n)
	text = string.gsub(text,"%%r",castingInfo.rank or "")
	text = string.gsub(text,"%%t",target)
	if castingInfo.applications == 0 then castingInfo.applications = nil end
	text = string.gsub(text,"%%a",castingInfo.applications or "")
	text = string.gsub(text, "[(][)]", "") -- trim empty parenthesis
	text = string.gsub(text, "^%s*(.-)%s*$", "%1") -- trim whitespaces
	
	if castingInfo.bar and castingInfo.bar:GetGroup() and not targetLibBarGroup:GetBar(e) then
		local oldGroup = castingInfo.bar:GetGroup()
		oldGroup:MoveBarToGroup(castingInfo.bar,targetLibBarGroup)--RemoveBar(castingInfo.bar)
		oldGroup:SortBars()
		targetLibBarGroup:SortBars()
	end
	if (not castingInfo.bar) or (castingInfo.bar.SRstartTime ~= castingInfo.s) or (math.floor(castingInfo.bar:GetWidth() + 0.5) ~= self.db.profile.barwidth) or (math.floor(castingInfo.bar:GetHeight() + 0.5) ~= self.db.profile.barheight) then
		targetLibBarGroup:SetTexture(self.sm:Fetch("statusbar", self.db.profile.texture))
		local bar, isNew = targetLibBarGroup:NewTimerBar(e, text, timeLeft, duration, castingInfo.icon, (self.db.profile.flashbars and reminder) or 0)
		if isNew then
			self:DebugPrint("Created Bar: "..castingInfo.n..": duration="..(duration or "no duration")..": reminder="..(reminder or "no reminder")..": timeleft="..(timeLeft or "none"))
		end
		if self.db.profile.barfont ~= nil then
			local font = SpellReminder.sm:Fetch('font', self.db.profile.barfont)
			bar:SetFont(font,self.db.profile.barfontsize)
		end
		bar.SRstartTime = castingInfo.s
		bar.updateDelay = 0 -- update on every frame .  Jerky bars = bad
		castingInfo.bar = bar
		targetLibBarGroup:SortBars()
	end
	castingInfo.bar:SetText(text)
	castingInfo.bar:SetIcon(castingInfo.icon)
	castingInfo.bar:UnsetAllColors()
	castingInfo.bar:SetColorAt(0,color.r,color.g,color.b,1)
	if self.db.profile.iconBorder then
		castingInfo.bar.icon:SetTexCoord(0, 1, 0, 1)
	else -- crop off the border
		castingInfo.bar.icon:SetTexCoord(0.07, 0.93, 0.07, 0.93)
	end
	--these lines can be removed when a fix is introduced to the library
--	castingInfo.bar:SetWidth(self.db.profile.barwidth)
--	castingInfo.bar:SetHeight(self.db.profile.barheight)
--	local ih = min(self.db.profile.barwidth, self.db.profile.barheight)
--	castingInfo.bar.icon:SetHeight(ih)
--	castingInfo.bar.icon:SetWidth(ih)
	--
--	end
	--bar:SetTimer(timeLeft,duration)
--		castingInfo.bar:GetGroup():SortBars()
--		targetLibBarGroup:SortBars()
--		if not targetLibBarGroup:GetBar(e) then --target group doesnt have the bar
--			self:Print('moving to '..self.anchors[targetGroupId].ident..' : '..e)
--			if targetGroupId == self:GetAnchorByIdent("emphasis") then
--				castingInfo.bar:AnimateToGroup(targetLibBarGroup)
--			else
--				oldGroup:MoveBarToGroup(castingInfo.bar,targetLibBarGroup)
--			end
--		end
	--castingInfo.bar:SetScale((self.db.profile.bargroups[targetGroupId] and self.db.profile.bargroups[targetGroupId].scale) or 1)
--	targetLibBarGroup:SortBars()

	--	local alreadyExists, needsRefresh = self.candybar:IsCandyBarRegistered(e), false
--	if alreadyExists then
--		local _,totTime,elapsed = self.candybar:CandyBarStatus(e)
--		local barTimeLeft = totTime - (elapsed or 9999)
--		needsRefresh = (timeLeft == nil) or (barTimeLeft <= timeLeft-0.5) or (barTimeLeft >= timeLeft+0.5) or (barTimeLeft < reminder and timeLeft > reminder)-- or spellTracker.active[e].initialGroup ~= castingInfo.initialGroup) -- time left is > 1sec out of sync
--	end 
--	if (alreadyExists and (timeLeft == nil or (timeLeft ~= nil and timeLeft > reminder+getOption("ttg")))) or alreadyExists == false then -- either bar doesnt exist, or its been refreshed then act as new // +1 on reminder is for padding, so we dont refresh the bar if its mid growth
--	if (alreadyExists and needsRefresh) or (not alreadyExists) then -- either bar doesnt exist, or its been refreshed then act as new
--[[		self:CancelScheduledEvent("GrowBar_"..e)
		self.candybar:RegisterCandyBar(e, duration, text)	
		self.candybar:SetCandyBarScale(e,(self.db.profile.bargroups[targetGroupId] and self.db.profile.bargroups[targetGroupId].scale) or 1)
		if setupInfo and setupInfo.fade ~= nil then
			self.candybar:SetCandyBarFade(e,setupInfo.fade)
		end
	--	if (not alreadyExists) then
			self.candybar:SetCandyBarTimeFormat(e, self.cbTF, e)
			self.candybar:SetCandyBarIcon(e,castingInfo.icon or (setupInfo and setupInfo.icon))
	--	end
		--self.candybar:StartCandyBar(e,true)

--		if (getOption("baroverride") == true) then
		self.candybar:SetCandyBarWidth(e,self.db.profile.barwidth)
		self.candybar:SetCandyBarHeight(e,self.db.profile.barheight)
				
		local adjust = 0
		if timeLeft ~= nil then
			adjust = duration-timeLeft
			self.candybar:SetCandyBarTimeLeft(e,timeLeft)
		end
--	elseif timeLeft ~= nil then  -- this bar already exists, but its time left is less than its reminder
--		candybar:SetCandyBarTimeLeft(e,timeLeft)
--	end
	
	-- update the group if we're not currently emphasised
	if self:GetRegisteredGroup(e) ~= self:GetAnchorByIdent("emphasis") then
		self.candybar:RegisterCandyBarWithGroup(e,"ReminderCandy_"..targetGroupId)
	end
	
	-- update trivial properties
	self.candybar:SetCandyBarText(e,text)
	self.candybar:SetCandyBarColor(e,color.r,color.g,color.b,1)
	self.candybar:SetCandyBarBackgroundColor(e,color.r,color.g,color.b,0.5)
	self.candybar:SetCandyBarTexture(e,SpellReminder.sm:Fetch('statusbar', self.db.profile.texture))
	
	if self.candybar.handlers[e].running ~= true then self.candybar:StartCandyBar(e,true) end
	
	for i,anchor in pairs(self.anchors) do
		self.candybar:UpdateCandyBarGroup("ReminderCandy_"..i)
	end
	
	
	if self.db.profile.barfont ~= nil then
		local font = SpellReminder.sm:Fetch('font', self.db.profile.barfont)
		local timertextwidth = self.db.profile.barfontsize * 2.5
		
		self.candybar.handlers[e].frame.timertext:SetWidth(timertextwidth)
		self.candybar.handlers[e].frame.text:SetWidth((self.db.profile.barwidth - timertextwidth) * .9)
		
		self.candybar.handlers[e].frame.text:SetFont(font,self.db.profile.barfontsize)
		self.candybar.handlers[e].frame.timertext:SetFont(font,self.db.profile.barfontsize)
	end
	
	self.candybar:Update(e)]]
end

--[[function SpellReminder:cbTF(e)
	local _,totaltime,elapsed = SpellReminder.candybar:CandyBarStatus(e)
	local timeLeft = totaltime-elapsed
	if timeLeft > 3600 then
		return string.format("%ih", math.ceil(timeLeft / 3600))
	elseif timeLeft > 60 then
		return string.format("%im", math.ceil(timeLeft / 60))
	elseif timeLeft > 0.1 then
		return string.format("%is", math.ceil(timeLeft))
	else
		return "--"
	end
end]]

function SpellReminder:PLAYER_DEAD()
	for eventName,info in pairs(spellTracker.casting) do
		if info ~= nil then
			self:CleanUp(eventName)
			--self:OnDurationEnded(eventName,true)
		end
	end
	for eventName,info in pairs(spellTracker.active) do
		if info ~= nil then
			self:CleanUp(eventName)--self:OnDurationEnded(eventName,true)
		end
	end
end

function SpellReminder:OnDurationEnding(eventName,quiet)	
--	local reg, t, e, r = self.candybar:CandyBarStatus(eventName)
	--if not reg then self:RefreshAllBars() return end
--	self:RefreshAllBars()

	local castingInfo = spellTracker.active[eventName]
	if not castingInfo then self:CleanUp(eventName) return end
	--if castingInfo.barType == "cooldown" then return end
	local spellID, spellName, spellTarget = castingInfo.n, castingInfo.displayName, (castingInfo.t and castingInfo.t ~= UnitName("player") and " ("..castingInfo.t..")") or ""
	local setupInfo = self.db.char.spellSetup[spellID]
		
	if not quiet then
		local soundfile = self.db.profile.audioWarnings
		if setupInfo.installed and setupInfo.allowCustomSound and setupInfo.customSound then soundfile = setupInfo.customSound end
		PlaySoundFile(SpellReminder.sm:Fetch('sound', soundfile))
		
		local timeLeft = castingInfo.d - (GetTime() - castingInfo.s)
		local message = L["%s over in %d seconds!"]:format(spellName..spellTarget,math.floor(timeLeft))
	
		-- UI Text Warning
		if (self.db.profile.textWarnings == "Both" or self.db.profile.textWarnings == "Expiring Only") then
			self:Pour(message,1,1,1,nil,nil,nil,true)
		end

		-- Announce
		if setupInfo.announceEnding then
			if setupInfo.announceSay then SendChatMessage(message, "SAY") end
			if setupInfo.announceYell then SendChatMessage(message, "YELL") end
			if setupInfo.announceParty then SendChatMessage(message, "PARTY") end
			if setupInfo.announceRaid then SendChatMessage(message, "RAID") end
		end
	end
	self:RefreshAllBars() -- required to push bars to the right place
end

function SpellReminder:OnDurationEnded(eventName,quiet)
	self:DebugPrint("OnDurationEnded: "..eventName)
	
	local castingInfo = spellTracker.active[eventName]
--	if not castingInfo or castingInfo.barType == "cooldown" then self:CleanUp(eventName) return end
	local spellID, spellName, spellTarget = castingInfo.n, castingInfo.displayName, (castingInfo.t and castingInfo.t ~= UnitName("player") and " ("..castingInfo.t..")") or ""
	local setupInfo = self.db.char.spellSetup[spellID]

	if not quiet then
		local soundfile = self.db.profile.audioWarnings
		if setupInfo.installed and setupInfo.allowCustomSound and setupInfo.customSound then soundfile = setupInfo.customSound end
		PlaySoundFile(SpellReminder.sm:Fetch('sound', soundfile))
		
		local message = L["%s has EXPIRED!"]:format(spellName..spellTarget)
		
		-- UI Text Warning
		if (self.db.profile.textWarnings == "Both" or self.db.profile.textWarnings == "Expired Only") then
			self:Pour(message,1,1,1,nil,nil,nil,true)
		end
		
		-- Announce
		if setupInfo.announceEnded then
			if setupInfo.announceSay then SendChatMessage(message, "SAY") end
			if setupInfo.announceYell then SendChatMessage(message, "YELL") end
			if setupInfo.announceParty then SendChatMessage(message, "PARTY") end
			if setupInfo.announceRaid then SendChatMessage(message, "RAID") end
		end
	end
	
	self:CleanUp(eventName)
end

function SpellReminder:CleanUp(eventName,refresh)
	if eventName == nil then return end
	
	spellTracker.casting[eventName] = self:del(spellTracker.casting[eventName])
	spellTracker.active[eventName] = self:del(spellTracker.active[eventName])
	self:CancelScheduledEvent(eventName)
	self:CancelScheduledEvent("END_"..eventName)
	if refresh then
		self:RefreshAllBars() -- remove this bar
	end
end

--[[function SpellReminder:GetRegisteredGroup(eventName)
	local regdGroup = nil
	for k,v in pairs(self.anchors) do
		if self.candybar:IsCandyBarRegisteredWithGroup(eventName,"ReminderCandy_"..k) then
			regdGroup = k
			break
		end
	end
	return regdGroup
end]]

function SpellReminder:GetTexture(name)
	local i = 1
	while true do
		local nm = GetSpellName(i, BOOKTYPE_SPELL)
		if not nm then break
		elseif nm == name then
			return GetSpellTexture(i, BOOKTYPE_SPELL)
		end
		i = i + 1
	end
	-- still not found? try pets spellbook
	local i = 1
	while true do
		local nm = GetSpellName(i, BOOKTYPE_PET)
		if not nm then break
		elseif nm == name then
			return GetSpellTexture(i, BOOKTYPE_PET)
		end
		i = i + 1
	end
	
	if true then return "Interface\\Icons\\INV_Misc_QuestionMark" end -- we dont know the texture, use questionmark
	
	-- finally, do the talents
	local numTabs = GetNumTalentTabs();
	local t
	for t=1, numTabs do
	    local numTalents = GetNumTalents(t);
	    for i=1, numTalents do
	        local nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(t,i);
			if nameTalent == spellName and currRank > 0 then
				local buff, debuff = self:FindDurationInText(tiptext)
				return buff, debuff, currRank
			end
	    end
	end
end

--[[function SpellReminder:GrowCandy(id)
--	self:DebugPrint("Grow Candy "..id)
	--self:ScheduleEvent("GrowBar_"..id,self.GrowBar,0,self,id,GetTime()+self.db.profile.ttg)
	self.candybar:SetCandyBarScale(id,self.db.profile.bargroups[self:GetAnchorByIdent("emphasis")].scale)
	self.candybar:RegisterCandyBarWithGroup(id,"ReminderCandy_"..self:GetAnchorByIdent("emphasis"))
end]]
--[[ function SpellReminder:GrowBar(id, stopTime)
	if not self.candybar:IsCandyBarRegistered(id) then return end
	if GetTime() > stopTime then
		self.candybar:SetCandyBarScale(id,self.db.char.bargroups[self:GetAnchorByIdent("emphasis")].scale)
		self.candybar:RegisterCandyBarWithGroup(id,"ReminderCandy_"..self:GetAnchorByIdent("emphasis"))
		return
	end
	local now = GetTime()
	local cbscale = self.candybar:GetCandyBarEffectiveScale(id)
	local scale = (self.db.char.bargroups["emphasis"].scale - cbscale) * (1 - ((stopTime - now) / self.db.profile.ttg))

	self.candybar:SetCandyBarScale(id,cbscale + scale)
	local centerX, centerY = self.candybar:GetCandyBarCenter(id)
	local effscale = UIParent:GetEffectiveScale()
	
	local posX = ((self.db.char.bargroups["emphasis"].position.x) - (centerX)) * (1-((stopTime - now) / self.db.profile.ttg)) 
	local posY = ((self.db.char.bargroups["emphasis"].position.y) - (centerY)) * (1-((stopTime - now) / self.db.profile.ttg))

	local point, rframe, rpoint = self.candybar:GetCandyBarPoint(id)
	self.candybar:SetCandyBarPoint(id, point, rframe, rpoint, posX, posY)
--	candybar:SetCandyBarPoint(id, point, rframe, rpoint, posX/effscale, posY/effscale)
	
	self:ScheduleEvent("GrowBar_"..id,self.GrowBar,0,self,id,stopTime)
end
]]
function SpellReminder:BarExists(spellName)
	for e, info in pairs(spellTracker.active) do
		if info.n == spellName then
			return true
		end
	end
	return false
end
--[[function SpellReminder:GrowBar(id, stopTime)
	if not candybar:IsCandyBarRegistered(id) then return end
	if GetTime() > stopTime then
		candybar:SetCandyBarScale(id,getOption("stopScale"))
		candybar:RegisterCandyBarWithGroup(id,"SpellReminderEmphasis")
		return
	end
	local now = GetTime()
	local scale = (getOption("stopScale") - getOption("startScale")) * (1 - ((stopTime - now) / getOption("ttg")))

	candybar:SetCandyBarScale(id,getOption("startScale") + scale)
	local effscale = UIParent:GetEffectiveScale()
	
	local posX = ((self.db.profile.barposition["emphasis"].x) - (self.db.profile.barposition["normal"].x)) * (1-((stopTime - now) / getOption("ttg"))) 
	local posY = ((self.db.profile.barposition["emphasis"].y) - (self.db.profile.barposition["normal"].y)) * (1-((stopTime - now) / getOption("ttg")))
	self:Print(posX.." : "..posY)
	local point, parent, anchor, x, y = self.normalAnchor:GetPoint()
	candybar:SetCandyBarPoint(id, point, parent, anchor, posX*effscale, (posY * -1)*effscale)
	
	self:ScheduleEvent("GrowBar_"..id,self.GrowBar,0,self,id,stopTime)
end]]

function SpellReminder:GetPlayerBuffDuration(spellName)
	local i = 1
	while (UnitBuff("player",i) ~= nil) do
		local name, rank, iconTexture, count, duration, timeLeft =  UnitBuff("player", i)
		if name == spellName and duration ~= nil then return duration end
		i = i + 1
	end
	local i = 1
	while (UnitBuff("pet",i) ~= nil) do
		local name, rank, iconTexture, count, duration, timeLeft =  UnitBuff("pet", i)
		if name == spellName and duration ~= nil then return duration end
		i = i + 1
	end
end

--local tt = AceLibrary("Gratuity-2.0")   
function SpellReminder:IsInSpellbook(spellName)
--[[	table.foreach(staticTimes , function(spell,info)
		if spellName == spell and toreturn == nil then
			toreturn = { info.durationBuff, info.durationDebuff, info.rank }
		end
	end)
	if toreturn ~= nil then return toreturn[1], toreturn[2], toreturn[3], toreturn[4] end
]]

	for _,suffix in ipairs(spellSuffixes) do
		local i = 1
		while true do
			local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
			if (not spell) then	break end
			if spell == spellName..suffix then
				return true
			end
			i = i + 1
		end
	end
	--[[ still not found? try pets spellbook
	local i = 1
	while true do
		local spell, rank = GetSpellName(i, BOOKTYPE_PET)
		if (not spell) then	break end
		if spell == spellName then
			if (chkRank == nil and (lastRank == nil or rank > lastRank)) or (rank == chkRank) then
				lastRank = rank
				tt:SetSpell(i,BOOKTYPE_PET)
				local tiptext = self:GetFullTipText(tt)
				local buff, debuff = self:FindDurationInTip(tiptext)
				toreturn = { buff, debuff, rank }
			end
		end
		i = i + 1
	end
	if toreturn ~= nil then return toreturn[1], toreturn[2], toreturn[3], true end
	]]
	--[[ finally, do the talents
	local numTabs = GetNumTalentTabs();
	for t=1, numTabs do
	    local numTalents = GetNumTalents(t);
	    for i=1, numTalents do
	        nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(t,i);
			if nameTalent == spellName and currRank > 0 then
				tt:SetTalent(t,i)
				local tiptext = self:GetFullTipText(tt)
				local buff, debuff = self:FindDurationInTip(tiptext)
				return buff, debuff, currRank
			end
	    end
	end]]

	return false
end

function SpellReminder:GetTempBuffName(id)
	--if not tooltip then
		--if WotLK then return end
		--LibStub("LibGratuity-3.0")
	--end
	local rank
	tooltip:SetInventoryItem("player", id)
	local _, _, buffname = tooltip:FindTipText("^(.+) %(%d+ [^%)]+%)$")
	if buffname then
		buffname = string.gsub(buffname, " %(%d+ [^%)]+%)", "") -- remove 2nd brackets for buffs with charges
		local tname, trank = string.match(buffname, "(.*) (%d*)$")
		if tname then
			buffname = tname
			rank = trank
		else
			local tname, trank = string.match(buffname, "(.*) ([CDILMVX]*)$")
			if tname then
				buffname = tname
				rank = roman_to_arabic[trank]
			end
		end
		return buffname, rank
	end
	local itemlink = GetInventoryItemLink("player", id)
	if itemlink then
		local name = GetItemInfo(itemlink)
		return name or "Weapon "..id
	end
	return "Weapon "..id
end

function SpellReminder:GetDuration(spellName, chkRank)
	--if not tooltip then
		--if WotLK then return end
--		local tooltip = LibStub("LibGratuity-3.0")
	--end
--[[	table.foreach(staticTimes , function(spell,info)
		if spellName == spell and toreturn == nil then
			toreturn = { info.durationBuff, info.durationDebuff, info.rank }
		end
	end)
	if toreturn ~= nil then return toreturn[1], toreturn[2], toreturn[3], toreturn[4] end
]]

	for _,suffix in pairs(spellSuffixes) do
		local toreturn = nil
		local lastRank = nil
		local i = 1
		while true do
			local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
			if (not spell) then	break end
			if spell == spellName..suffix then
				if (chkRank == nil and (lastRank == nil or rank > lastRank)) or (rank == chkRank) then
					lastRank = rank
					tooltip:SetSpell(i,BOOKTYPE_SPELL)
					local tiptext = tooltip:GetFullTipText()
					local buff = self:FindDurationInText(tiptext)
					toreturn = { buff, rank }
				end
			end
			i = i + 1
		end
		if toreturn ~= nil then return toreturn[1], toreturn[2] end
	end
	--[[ still not found? try pets spellbook
	local i = 1
	while true do
		local spell, rank = GetSpellName(i, BOOKTYPE_PET)
		if (not spell) then	break end
		if spell == spellName then
			if (chkRank == nil and (lastRank == nil or rank > lastRank)) or (rank == chkRank) then
				lastRank = rank
				tt:SetSpell(i,BOOKTYPE_PET)
				local tiptext = self:GetFullTipText(tt)
				local buff, debuff = self:FindDurationInTip(tiptext)
				toreturn = { buff, debuff, rank }
			end
		end
		i = i + 1
	end
	if toreturn ~= nil then return toreturn[1], toreturn[2], toreturn[3], true end
	]]
	--[[ finally, do the talents
	local numTabs = GetNumTalentTabs();
	for t=1, numTabs do
	    local numTalents = GetNumTalents(t);
	    for i=1, numTalents do
	        nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(t,i);
			if nameTalent == spellName and currRank > 0 then
				tt:SetTalent(t,i)
				local tiptext = self:GetFullTipText(tt)
				local buff, debuff = self:FindDurationInTip(tiptext)
				return buff, debuff, currRank
			end
	    end
	end]]

	return nil
end

function SpellReminder:FindDurationInText(tiptext)
	local pre = {"for","over","lasts","up to"}
	local post = {"sec","min","hour"}
	local durationBuff = nil
	local durationDebuff = nil
	for _,preVal in ipairs(pre) do -- loop through prefixes
		preVal = string.lower(preVal)
		for _,postVal in ipairs(post) do  -- loop through suffixes
			postVal = string.lower(postVal)
			for newDur in string.gmatch(string.lower(tiptext),preVal.." (%d+) "..postVal) do
				newDur = tonumber(newDur)
				if newDur ~= nil then
					if postVal == "min" then
						newDur = newDur * 60
					elseif postVal == "hour" then
						newDur = newDur * 60 * 60
					end
					if (durationBuff == nil) then
						durationBuff = newDur
					elseif (newDur > durationBuff) then
						durationDebuff = durationBuff
						durationBuff = newDur
					end
				end
			end
		end
	end
	
	return tonumber(durationBuff), tonumber(durationDebuff)
end

function SpellReminder:DebugPrint(text)
	if not self.db.profile.debugmode then return end
	self:Print(text)
end

function SpellReminder:tcopy(from,to)   -- "to" must be a table (possibly empty)
	assert(type(from)=="table","Error copying table contents, source is not a table.")
	assert(type(to)  =="table","Error copying table contents, destination is not a table.")
	for k,v in pairs(from) do
		if(type(v)=="table") then
			to[k] = self:new()
			self:tcopy(v,to[k])
		else
			to[k] = v
		end
	end
end
