local L = AceLibrary("AceLocale-2.2"):new("SpellReminder")
local spellTracker = SpellReminder.track

local function ClipNumber(number, minimum, maximum, trueMax)
	return min(max(min(number,maximum),minimum),trueMax)
end

function SpellReminder:ProcessSpellCooldowns(clearAll)
	if not self.db.profile.docooldowns then return end
	self:DebugPrint("ProcessCooldowns")
	
--	if clearAll then -- first clear all CD timers, this will stop  multiple bars when zoning
		for eventName,info in pairs(spellTracker.active) do 
			if info.tGUID == "COOLDOWN" then
				self:CleanUp(eventName)
			end
		end
--[[	else -- clear all where the spell is no longer on CD (for spells that remove cooldowns (cold snap))
		for eventName,info in pairs(spellTracker.active) do 
			if info.tGUID == "COOLDOWN" then
				self:CleanUp(eventName)
			end
		end]]
--	end
	
	local i = 1
	local cooldowns,done = self:new(),self:new()
	local rangedSpeed = UnitRangedDamage("player");
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if (not spellName) then	break end
		local start, duration, enabled = GetSpellCooldown(i,BOOKTYPE_SPELL);
		if (not done[spellName]) and enabled == 1 and duration > 1.5 and duration > rangedSpeed then
			done[spellName] = true
			local tabName, tabTexture
			local useTexture = GetSpellTexture(i,BOOKTYPE_SPELL)
			for t = 1, MAX_SKILLLINE_TABS do -- find the spell tree
				local name, texture, offset, numSpells = GetSpellTabInfo(t)
				if not name then break end
				if (i > offset) and (i < offset + numSpells + 1) then
					tabName = name
					tabTexture = texture
					break
				end
			end
			local index = floor(start*duration)..(tabName or "")
			local eventName = self:GetEventName(index,"COOLDOWN")
			cooldowns[index] = (cooldowns[index] or 0) + 1  --- multiple spells with the same name ????  PW:Shield
			if cooldowns[index] > 1 then
				if not tabName then self:Print("no tab for "..spellName) end
				spellName = (tabName or "").. " Tree"
				useTexture = tabTexture
--				spellName = "Multiple Spells"
			end
			
			local remaining = start + duration - GetTime()
			local setupID = 'cd:'..spellName
			if not self.db.char.spellSetup[setupID].installed then
				self:Print("Detected new cooldown! ("..spellName..")")
				self.db.char.spellSetup[setupID] = self:InstallWatch(setupID,spellRank,nil,duration,useTexture)
			end
			local setupInfo = self.db.char.spellSetup[setupID]
			self:SetSpellCategory(setupID,' Cooldowns')-- ('..tabName..')')
			if setupInfo.installed and setupInfo.active then
				local color = (setupInfo.installed and setupInfo.c) or nil
				local ci = self:GetCastingObject(setupID,setupInfo.displayName,spellRank,"Cooldown","COOLDOWN",start,duration,ClipNumber(duration*0.125,5,15,duration),eventName,color,"cooldown",setupInfo.icon)
				if cooldowns[index] > 1 then ci.applications = cooldowns[index] end
				ci.customFormat = "(CD%a) %n"
				self:TrackSpell(ci,true)
			end
		else
			-- clear bar
			self:CleanUp(eventName)
		end
		i = i + 1
	end
	done = self:del(done)
	cooldowns = self:del(cooldowns)
	
	self:RefreshAllBars()
--	local index = floor(start*duration);
--	if not cooldowns[index] then
--		cooldowns[index] = self:new();
--		cooldowns[index].name = k;
--		cooldowns[index].spell = v;
--		cooldowns[index].duration = duration;
--	end
end