-- CombatLog parser
-- processArgs receives all args from any combat log event (...) and returns a table with named indices according to wowwiki prefix/suffix arg names:  http://www.wowwiki.com/API_COMBAT_LOG_EVENT
--  Developed by Oridan of Kazzak-EU
-- please leave credit if you use this.

-- process order to createtables with named properties of combat log event args.
SpellReminder.combatlog_event_args = {
	{'',						{'timestamp','event','sourceGUID','sourceName','sourceFlags','destGUID','destName','destFlags'}},
	-- special
	{'DAMAGE_SHIELD_MISSED',	{'missType'}},
	{'DAMAGE_SHIELD',			{'spellId','spellName','spellSchool','amount','school','resisted','blocked','absorbed','critical','glancing','crushing'}},
	{'DAMAGE_SPLIT',			{'spellId','spellName','spellSchool','amount','school','resisted','blocked','absorbed','critical','glancing','crushing'}},
	{'ENCHANT_APPLIED',			{'spellName','itemID','itemName'}},
	{'ENCHANT_REMOVED',			{'spellName','itemID','itemName'}},
	{'PARTY_KILL',				},
	{'UNIT_DIED',				},
	{'UNIT_DESTROYED',			},
	-- prefixes
	{'SWING',					},
	{'SPELL_PERIODIC',			{'spellId','spellName','spellSchool'}},
	{'SPELL',					{'spellId','spellName','spellSchool'}},
	{'RANGE',					{'spellId','spellName','spellSchool'}},
	{'ENVIRONMENTAL',			{'environmentalType'}},
	-- suffixes
	{'_DAMAGE',					{'amount','school','resisted','blocked','absorbed','critical','glancing','crushing'}},
	{'_MISSED',					{'missType'}},
	{'_HEAL',					{'amount','critical'}},
	{'_ENERGIZE',				{'amount','powerType'}},
	{'_DRAIN',					{'amount','powerType','extraAmount'}},
	{'_LEECH',					{'amount','powerType','extraAmount'}},
	{'_INTERRUPT',				{'extraSpellID','extraSpellName','extraSpellSchool'}},
	{'_DISPEL_FAILED',			{'extraSpellID','extraSpellName','extraSpellSchool'}},
	{'_EXTRA_ATTACKS',			{'amount'}},
	{'_AURA_APPLIED_DOSE',		{'auraType','amount'}},
	{'_AURA_APPLIED',			{'auraType'}},
	{'_AURA_REMOVED_DOSE',		{'auraType','amount'}},
	{'_AURA_REMOVED',			{'auraType'}},
	{'_DISPEL',					{'extraSpellID','extraSpellName','extraSpellSchool','auraType'}},
	{'_STOLEN',					{'extraSpellID','extraSpellName','extraSpellSchool'}},
	{'_AURA_REFRESH',			{'one','two','three','four','five'}},
	{'_AURA_BROKEN_SPELL',		{'extraSpellID','extraSpellName','extraSpellSchool','auraType'}},
	{'_CAST_START',				},
	{'_CAST_SUCCESS',			},
	{'_CAST_FAILED',			{'failedType'}},
	{'_INSTAKILL',				},
	{'_DURABILITY_DAMAGE_ALL',	},
	{'_DURABILITY_DAMAGE',		},
	{'_CREATE',					},
	{'_SUMMON',					},
}

SpellReminder.combatlog_events = {} -- register events
function SpellReminder:RegisterCombatLogEvent(eventName,func)
	if self.combatlog_events[eventName] ~= nil then
--		self:Print(eventName.." is already assigned")
		return
	end
	if func == nil then func = eventName end
	
	if type(func) == "string" then
		if type(self[func]) ~= "function" then
			self:Print("Function ("..func..") does not exist")
			return
		end
		func = self[func]
	end
	
	self.combatlog_events[eventName] = func
end

function SpellReminder:ProcessCombatLogArgs(...)
	return self:ProcessArgs(SpellReminder.combatlog_event_args,...)
end

function SpellReminder:ProcessArgs(argsTable,...)
	local eventName = select(2,...)
	local eventNameProcess = eventName
	
	local eventArgs = {}
	local argsProcessedCount = 0;
	
	for _,set in ipairs(argsTable) do
		if eventNameProcess == "" or eventNameProcess == nil then return eventArgs end -- fully processed, return args
		local sectionName, paramNames, matches = set[1], set[2], 0
		eventNameProcess, matches = string.gsub(eventNameProcess,'^'..sectionName,'')
		if type(paramNames) == "table" and (matches > 0 or type(key) == "number") then
			for _,val in ipairs(paramNames) do
				eventArgs[val] = select(argsProcessedCount+1,...)
				argsProcessedCount = argsProcessedCount+1
			end
		end
	end
	
	if eventNameProcess ~= "" then
		SpellReminder:Print("Event not fully processed: "..eventName.."|n Remaining: "..eventNameProcess)
	end
	
	return eventArgs
end
