local L = AceLibrary("AceLocale-2.2"):new("SpellReminder")
local WotLK = select(4,GetBuildInfo()) >= 30000
local spellTracker = SpellReminder.track

function SpellReminder:ProcessAuras(unit,dontRefresh)
	if not UnitExists(unit) then self:RefreshAllBars() return end--unit == "player" end
	self:DebugPrint("ProcessAuras "..unit)
	local targetName,targetRealm = UnitName(unit)
	local unitGUID, playerGUID, petGUID = UnitGUID(unit), UnitGUID("player"), UnitGUID("pet")
	if targetName == nil or targetName == "Unknown" then return end
	if UnitIsDead(unit) then return end
	if targetRealm ~= nil then targetName = string.gsub(targetName,'-'..targetRealm,'') end
	if unitGUID == petGUID then unitGUID = "PET" end
	local hasAura = self:new()
	
	do	-- BUFFS
		local i = 1
		while UnitExists(unit) do
			local name, rank, iconTexture, applications, spellType, duration, timeEnd, timeLeft, isMine
			if WotLK then
				name, rank, iconTexture, applications, spellType, duration, timeEnd, isMine = UnitBuff(unit, i)
				timeLeft = (timeEnd and (timeEnd - GetTime())) or nil
			else
				name, rank, iconTexture, applications, duration, timeLeft = UnitBuff(unit, i)
				timeEnd = (timeLeft and (GetTime() + timeLeft)) or nil
				isMine = (timeEnd ~= nil)
			end
			if (name == nil) then break end
			
			local eventName = self:GetEventName(name,unitGUID)
			while hasAura[eventName] do local i = (i or 0)+1; eventName = self:GetEventName(name..i,unitGUID) end -- this line allows multiple buffs of the same spell based on aura, useful for dual mongoose proc
			if duration ~= nil and duration >0 and timeLeft ~= nil and timeLeft > 0 and isMine then
				if (spellTracker.active[eventName]) then duration = spellTracker.active[eventName].d end -- bar already exists, use its duration
				local timeStarted = GetTime() - (duration - timeLeft)
				if (not self.db.char.spellSetup[name].installed and duration ~= nil and duration > 0) and (self.db.profile.disableDetection == false) then
					self.db.char.spellSetup[name] = self:InstallWatch(name,rank,nil,duration,iconTexture)
					if not self:IsInSpellbook(name) then
						self:Print(L["Detected new spell! (%s)"]:format(self.db.char.spellSetup[name].displayName))
						self.db.char.spellSetup[name].detected = true
					end
				end
				local info = self.db.char.spellSetup[name]
				--if duration == nil and unit == "player" then duration = self:GetPlayerBuffDuration(name) end
				if info.installed and info.active == true then --and duration ~= nil then
					self.db.char.spellSetup[name].icon = iconTexture
					self:SetSpellCategory(name,'Buffs')
					local castingInfo = self:TrackSpell(self:GetCastingObject(name,info.displayName,rank,targetName,unitGUID,timeStarted,duration,info.r,eventName,info.c,"buff",iconTexture),true)
--				castingInfo.tID = self:GetTargetId(unit,castingInfo.tID)
					if castingInfo then
						castingInfo["applications"] = applications
						hasAura[eventName] = true
						info.persist = false
--		self:Print('made UNpersist')
					end
--					castingInfo.canRemove = true
				--	self:CreateReminderBar(eventName, castingInfo, timeLeft)
				end
			end
			i = i + 1
		end
	end
	
	do	-- DEBUFFS
		local i = 1
		while UnitExists(unit) do
			local name, rank, iconTexture, applications, spellType, duration, timeEnd, timeLeft, isMine
			if WotLK then
				name, rank, iconTexture, applications, spellType, duration, timeEnd, isMine = UnitDebuff(unit, i)
				timeLeft = (timeEnd and (timeEnd - GetTime())) or nil
			else
				name, rank, iconTexture, applications, spellType, duration, timeLeft = UnitDebuff(unit, i)
				timeEnd = (timeLeft and (GetTime() + timeLeft)) or nil
				isMine = (timeEnd ~= nil)
			end
			if (name == nil) then break end
			
			local eventName = self:GetEventName(name,unitGUID)
			while hasAura[eventName] do local i = (i or 0)+1; eventName = self:GetEventName(name..i,unitGUID) end -- this line allows multiple buffs of the same spell based on aura, useful for dual mongoose proc
			if duration ~= nil and duration >0 and timeLeft ~= nil and timeLeft > 0 and isMine then
				if (spellTracker.active[eventName]) then duration = spellTracker.active[eventName].d end -- bar already exists, use its duration
				local timeStarted = GetTime() - (duration - timeLeft)
				if (not self.db.char.spellSetup[name].installed and duration ~= nil and duration > 0) and (self.db.profile.disableDetection == false) then
					self.db.char.spellSetup[name] = self:InstallWatch(name,rank,nil,duration,iconTexture)
					if not self:IsInSpellbook(name) then
						self:Print(L["Detected new spell! (%s)"]:format(self.db.char.spellSetup[name].displayName))
						self.db.char.spellSetup[name].detected = true
					end
				end
				local info = self.db.char.spellSetup[name]
				if info.installed and info.active == true then --and duration ~= nil then
					self.db.char.spellSetup[name].icon = iconTexture
					self:SetSpellCategory(name,'Debuffs')
				--	if spellTracker.active[eventName] == nil then spellTracker.active[eventName] = self:new() end
					local castingInfo = self:TrackSpell(self:GetCastingObject(name,info.displayName,rank,targetName,unitGUID,timeStarted,duration,info.r,eventName,info.c,"debuff",iconTexture),true)
--				castingInfo.tID = self:GetTargetId(unit,castingInfo.tID)
					if castingInfo then
						castingInfo["applications"]=applications
						hasAura[eventName] = true
						info.persist = false
--		self:Print('made UNpersist')
					end
--					castingInfo.canRemove = true
				--	self:CreateReminderBar(eventName, castingInfo, timeLeft)
				end
			end
			i = i + 1
		end
	end
	
	if unitGUID == playerGUID then
		-- totems
		for i=1, MAX_TOTEMS do
			local haveTotem, spellName, startTime, duration, icon = GetTotemInfo(i)
			local eventName = self:GetEventName('TOTEM_'..i,UnitGUID("player"))
			if spellName and spellName ~= "" then
				local spellRank
				if string.find(spellName," ([CDILMVX]+)$") then
					spellName, spellRank = string.match(spellName, "(.*) ([CDILMVX]*)$")
				end
				local info = self.db.char.spellSetup[spellName]
				if (((not info) or (not info.installed)) and duration ~= nil and duration > 0) and (self.db.profile.disableDetection == false) then
					info = self:InstallWatch(spellName,spellRank,nil,duration,icon)
				end
				if info and info.installed and info.active == true then
					self:SetSpellCategory(spellName,'Totems')
					if (spellTracker[eventName]) then timeStarted = spellTracker[eventName].s end
					local castingInfo = self:TrackSpell(self:GetCastingObject(spellName,info.displayName,'',UnitName("player"),playerGUID,startTime,duration,info.r,eventName,info.c,"buff",icon))
					if castingInfo then
						hasAura[eventName] = true
						info.persist = false
						--castingInfo.persistent = info.persistent
					end
				end
			end
		end
	
		-- weaponbuffs
		hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges = GetWeaponEnchantInfo()
		if hasMainHandEnchant then
			local name = 'wep:'..self:GetTempBuffName(GetInventorySlotInfo("MainHandSlot"))
			local timeLeft = mainHandExpiration/1000
			local eventName = self:GetEventName('MainHandEnchant',playerGUID)
			local iconTexture = GetInventoryItemTexture("player", GetInventorySlotInfo("MainHandSlot"))
			local duration = math.ceil(mainHandExpiration/1000)
			
			local info = self.db.char.spellSetup[name]
			if ((not info.installed) and duration ~= nil and duration > 0) and (self.db.profile.disableDetection == false) then
				self.db.char.spellSetup[name] = self:InstallWatch(name,rank,nil,duration,iconTexture)
				if not self:IsInSpellbook(name) then
					self:Print("Detected new spell! ("..self.db.char.spellSetup[name].displayName..")")
					self.db.char.spellSetup[name].detected = true
				end
			end
			local info = self.db.char.spellSetup[name]
			if info ~= nil and info.active == true then --and duration ~= nil then
				hasAura[eventName] = true
				info.persist = false
				self:SetSpellCategory(name,'Weapon Buffs')
				if (duration > info.d) then info.d = duration end
				info.icon = iconTexture
				local timeStarted = math.floor(GetTime() - (info.d - timeLeft))
		--		if spellTracker.active[eventName] == nil then spellTracker.active[eventName] = self:new() end
				local castingInfo = self:TrackSpell(self:GetCastingObject(name,info.displayName,rank,UnitName("player"),playerGUID,timeStarted,info.d,info.r,eventName,info.c,"buff",info.icon),true)
				if castingInfo then
					castingInfo["applications"]=mainHandCharges
				end
			end
		end
		if hasOffHandEnchant then
			local name = 'wep:'..self:GetTempBuffName(GetInventorySlotInfo("SecondaryHandSlot"))--((string.find(self:GetTempBuffName(GetInventorySlotInfo("MainHandSlot")),".* Totem") == nil) and "Weapon Buff") or "Weapon Buff (Totem)"
			local timeLeft = offHandExpiration/1000
			local eventName = self:GetEventName('OffHandEnchant',playerGUID)
			local iconTexture = GetInventoryItemTexture("player", GetInventorySlotInfo("SecondaryHandSlot"))
			local duration = math.ceil(offHandExpiration/1000)
			
			local info = self.db.char.spellSetup[name]
			if ((not info.installed) and duration ~= nil and duration > 0) and (self.db.profile.disableDetection == false) then
				self.db.char.spellSetup[name] = self:InstallWatch(name,rank,nil,duration,iconTexture)
				if not self:IsInSpellbook(name) then
					self:Print("Detected new spell! ("..self.db.char.spellSetup[name].displayName..")")
					self.db.char.spellSetup[name].detected = true
				end
			end
			local info = self.db.char.spellSetup[name]
			if info ~= nil and info.active == true then --and duration ~= nil then
				hasAura[eventName] = true
				info.persist = false
				self:SetSpellCategory(name,'Weapon Buffs')
				if (duration > info.d) then info.d = duration end
				info.icon = iconTexture
				local timeStarted = math.floor(GetTime() - (info.d - timeLeft))
		--		if spellTracker.active[eventName] == nil then spellTracker.active[eventName] = self:new() end
				local castingInfo = self:TrackSpell(self:GetCastingObject(name,info.displayName,rank,UnitName("player"),playerGUID,timeStarted,info.d,info.r,eventName,info.c,"buff",info.icon),true)
				if castingInfo then
					castingInfo["applications"]=offHandCharges
				end
			end
		end
	end
	
	--self:PrintLiteral(hasAura)
	for eventName,castingInfo in pairs(spellTracker.active) do
		local info = self.db.char.spellSetup[castingInfo.n]
--		self:Print("Checking for DontRemove "..(castingInfo.tGUID or "no tGUID").."="..(unitGUID or "no targetGUID").." and not "..((hasAura[info.n] and "true") or "false"))
--		self:Print("Check: "..castingInfo.n)
		if castingInfo.tGUID == unitGUID and (not hasAura[eventName]) and (info and info.persist == false) and (castingInfo.n ~= UnitName("pet")) then -- and (not info.DontRemove) then -- call OnDurationEnded
			--self:CleanUp(eventName) -- use ODE so we can keep the audio
			self:OnDurationEnded(eventName)
		end
	end
	
	if (not dontRefresh) then
		self:RefreshAllBars()
	end
	
	hasAura = self:del(hasAura)
end
