--[[
	Copyright (C) 2006-2007 Nymbia

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
]]
local _G = getfenv(0)
local L = AceLibrary("AceLocale-2.2"):new("SpellBinder")
SpellBinder = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local awaitinginput=false
local currentmode --one of "spell" "macro" or "item"
local currentitem --the item we're gonna add a binding to, ie "Fireball(Rank 5)" or "Major Mana Potion"
local currentbind1 --the binding that we're gonna add to the item
local currentbind2
BINDING_HEADER_SpellBinder = L["SpellBinder"]
BINDING_NAME_SpellBinder = L["SpellBinder"]
--the slash commands
local options = {
	type = 'execute',
	name = L["SpellBinder"],
	desc = L["SpellBinder"],
	func = function()
		SpellBinder:Toggle()
	end,
}
function SpellBinder:OnInitialize()
	self:RegisterChatCommand({"/spellbinder", "/spellbind"}, options)
end
function SpellBinder:OnEnable()
	self:RegisterEvent("SPELLS_CHANGED")
end
function SpellBinder:OnDisable()
	if SpellBinderFrame then
		SpellBinderFrame:Hide()
	end
end
function SpellBinder:Toggle()
	if not SpellBinderFrame then
		local SpellBinderFrame = CreateFrame("Frame","SpellBinderFrame",UIParent)
		SpellBinderFrame:SetFrameStrata("DIALOG")
		SpellBinderFrame:SetWidth(300)
		SpellBinderFrame:SetHeight(215)
		SpellBinderFrame:SetBackdrop( {
		  bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		  edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = false, tileSize = 16, edgeSize = 16,
		  insets = { left = 5, right = 5, top = 5, bottom = 5 }
		})
		SpellBinderFrame:SetBackdropColor(0,0,0)
		SpellBinderFrame:EnableMouse(true)
		SpellBinderFrame:SetMovable(true)
		SpellBinderFrame:SetPoint("CENTER",0,0)
		SpellBinderFrame:SetScript("OnMouseDown", function() this:StartMoving() end)
		SpellBinderFrame:SetScript("OnMouseUp", function() this:StopMovingOrSizing() end)

		local SpellBinderFrameListButton = CreateFrame("Button","SpellBinderFrameListButton",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameListButton:SetFrameStrata("DIALOG")
		SpellBinderFrameListButton:SetWidth(40)
		SpellBinderFrameListButton:SetHeight(20)
		SpellBinderFrameListButton:SetPoint("TOPRIGHT",SpellBinderFrame, -10,-20)
		SpellBinderFrameListButton:RegisterForClicks("LeftButtonUp", "RightButtonUp", "MiddleButtonUp", "Button4Up", "Button5Up")
		SpellBinderFrameListButton:SetScript("OnClick", function() SpellBinder:MakeListMenu() end)
		SpellBinderFrameListButton:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameListButton:Enable()
		SpellBinderFrameListButton:SetTextColor(1, 1, 1)
		SpellBinderFrameListButton:SetText(L["List"])

		local SpellBinderFrameKeyBindButton1 = CreateFrame("Button","SpellBinderFrameKeyBindButton1",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameKeyBindButton1:SetFrameStrata("DIALOG")
		SpellBinderFrameKeyBindButton1:SetWidth(140)
		SpellBinderFrameKeyBindButton1:SetHeight(24)
		SpellBinderFrameKeyBindButton1:SetPoint("TOPRIGHT",SpellBinderFrame, -10,-55)
		SpellBinderFrameKeyBindButton1:RegisterForClicks("LeftButtonUp", "RightButtonUp", "MiddleButtonUp", "Button4Up", "Button5Up")
		SpellBinderFrameKeyBindButton1:SetScript("OnClick", function() SpellBinder:Press(1, arg1) end)
		SpellBinderFrameKeyBindButton1:SetScript("OnKeyDown", function() SpellBinder:Press(1) end)
		SpellBinderFrameKeyBindButton1:SetScript("OnMouseWheel", function() if arg1 == 1 then SpellBinder:Press(1, "MOUSEWHEELUP") else SpellBinder:Press(1, "MOUSEWHEELDOWN") end end)
		SpellBinderFrameKeyBindButton1:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameKeyBindButton1:Enable()
		SpellBinderFrameKeyBindButton1:SetTextColor(1, 1, 1)
		SpellBinderFrameKeyBindButton1:SetText(L["Click to Set"])

		local SpellBinderFrameKeyBindButton2 = CreateFrame("Button","SpellBinderFrameKeyBindButton2",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameKeyBindButton2:SetFrameStrata("DIALOG")
		SpellBinderFrameKeyBindButton2:SetWidth(140)
		SpellBinderFrameKeyBindButton2:SetHeight(24)
		SpellBinderFrameKeyBindButton2:SetPoint("TOPRIGHT",SpellBinderFrame, -10,-85)
		SpellBinderFrameKeyBindButton2:RegisterForClicks("LeftButtonUp", "RightButtonUp", "MiddleButtonUp", "Button4Up", "Button5Up")
		SpellBinderFrameKeyBindButton2:SetScript("OnClick", function() SpellBinder:Press(2, arg1) end)
		SpellBinderFrameKeyBindButton2:SetScript("OnKeyDown", function() SpellBinder:Press(2) end)
		SpellBinderFrameKeyBindButton2:SetScript("OnMouseWheel", function() if arg1 == 1 then SpellBinder:Press(2, "MOUSEWHEELUP") else SpellBinder:Press(2, "MOUSEWHEELDOWN") end end)
		SpellBinderFrameKeyBindButton2:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameKeyBindButton2:Enable()
		SpellBinderFrameKeyBindButton2:SetTextColor(1, 1, 1)
		SpellBinderFrameKeyBindButton2:SetText(L["Click to Set"])

		local SpellBinderFrameSpellBook1Button = CreateFrame("Button","SpellBinderFrameSpellBook1Button",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameSpellBook1Button:SetFrameStrata("DIALOG")
		SpellBinderFrameSpellBook1Button:SetWidth(140)
		SpellBinderFrameSpellBook1Button:SetHeight(24)
		SpellBinderFrameSpellBook1Button:SetPoint("TOPLEFT",SpellBinderFrame, 10,-20)
		SpellBinderFrameSpellBook1Button:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameSpellBook1Button:SetScript("OnClick", function() SpellBinder:ClickBookButton(1) end)
		SpellBinderFrameSpellBook1Button:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameSpellBook1Button:Enable()
		SpellBinderFrameSpellBook1Button:SetTextColor(1, 1, 1)

		local SpellBinderFrameSpellBook2Button = CreateFrame("Button","SpellBinderFrameSpellBook2Button",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameSpellBook2Button:SetFrameStrata("DIALOG")
		SpellBinderFrameSpellBook2Button:SetWidth(140)
		SpellBinderFrameSpellBook2Button:SetHeight(24)
		SpellBinderFrameSpellBook2Button:SetPoint("TOPLEFT",SpellBinderFrame, 10,-41)
		SpellBinderFrameSpellBook2Button:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameSpellBook2Button:SetScript("OnClick", function() SpellBinder:ClickBookButton(2) end)
		SpellBinderFrameSpellBook2Button:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameSpellBook2Button:Enable()
		SpellBinderFrameSpellBook2Button:SetTextColor(1, 1, 1)

		local SpellBinderFrameSpellBook3Button = CreateFrame("Button","SpellBinderFrameSpellBook3Button",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameSpellBook3Button:SetFrameStrata("DIALOG")
		SpellBinderFrameSpellBook3Button:SetWidth(140)
		SpellBinderFrameSpellBook3Button:SetHeight(24)
		SpellBinderFrameSpellBook3Button:SetPoint("TOPLEFT",SpellBinderFrame, 10,-62)
		SpellBinderFrameSpellBook3Button:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameSpellBook3Button:SetScript("OnClick", function() SpellBinder:ClickBookButton(3) end)
		SpellBinderFrameSpellBook3Button:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameSpellBook3Button:Enable()
		SpellBinderFrameSpellBook3Button:SetTextColor(1, 1, 1)

		local SpellBinderFrameSpellBook4Button = CreateFrame("Button","SpellBinderFrameSpellBook4Button",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameSpellBook4Button:SetFrameStrata("DIALOG")
		SpellBinderFrameSpellBook4Button:SetWidth(140)
		SpellBinderFrameSpellBook4Button:SetHeight(24)
		SpellBinderFrameSpellBook4Button:SetPoint("TOPLEFT",SpellBinderFrame, 10,-83)
		SpellBinderFrameSpellBook4Button:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameSpellBook4Button:SetScript("OnClick", function() SpellBinder:ClickBookButton(4) end)
		SpellBinderFrameSpellBook4Button:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameSpellBook4Button:Enable()
		SpellBinderFrameSpellBook4Button:SetTextColor(1, 1, 1)

		local SpellBinderFrameSpellBook5Button = CreateFrame("Button","SpellBinderFrameSpellBook5Button",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameSpellBook5Button:SetFrameStrata("DIALOG")
		SpellBinderFrameSpellBook5Button:SetWidth(140)
		SpellBinderFrameSpellBook5Button:SetHeight(24)
		SpellBinderFrameSpellBook5Button:SetPoint("TOPLEFT",SpellBinderFrame, 10,-104)
		SpellBinderFrameSpellBook5Button:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameSpellBook5Button:SetScript("OnClick", function() SpellBinder:ClickBookButton(5) end)
		SpellBinderFrameSpellBook5Button:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameSpellBook5Button:Enable()
		SpellBinderFrameSpellBook5Button:SetText(L["Pet"])
		SpellBinderFrameSpellBook5Button:SetTextColor(1, 1, 1)

		local SpellBinderFrameItemButton = CreateFrame("Button","SpellBinderFrameItemButton",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameItemButton:SetFrameStrata("DIALOG")
		SpellBinderFrameItemButton:SetWidth(140)
		SpellBinderFrameItemButton:SetHeight(24)
		SpellBinderFrameItemButton:SetPoint("TOPLEFT",SpellBinderFrame, 10,-125)
		SpellBinderFrameItemButton:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameItemButton:SetScript("OnClick", function() SpellBinder:ClickItemButton() end)
		SpellBinderFrameItemButton:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameItemButton:Enable()
		SpellBinderFrameItemButton:SetText(L["Item"])
		SpellBinderFrameItemButton:SetTextColor(1, 1, 1)

		local SpellBinderFrameMacroButton = CreateFrame("Button","SpellBinderFrameMacroButton",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameMacroButton:SetFrameStrata("DIALOG")
		SpellBinderFrameMacroButton:SetWidth(140)
		SpellBinderFrameMacroButton:SetHeight(24)
		SpellBinderFrameMacroButton:SetPoint("TOPLEFT",SpellBinderFrame, 10,-146)
		SpellBinderFrameMacroButton:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameMacroButton:SetScript("OnClick", function() SpellBinder:ClickMacroButton() end)
		SpellBinderFrameMacroButton:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameMacroButton:Enable()
		SpellBinderFrameMacroButton:SetText(L["Macro"])
		SpellBinderFrameMacroButton:SetTextColor(1, 1, 1)

		local SpellBinderFrameCloseButton = CreateFrame("Button","SpellBinderFrameCloseButton",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameCloseButton:SetFrameStrata("DIALOG")
		SpellBinderFrameCloseButton:SetWidth(100)
		SpellBinderFrameCloseButton:SetHeight(24)
		SpellBinderFrameCloseButton:SetPoint("BOTTOMRIGHT",SpellBinderFrame, -10, 10)
		SpellBinderFrameCloseButton:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameCloseButton:SetScript("OnClick", function() SpellBinder:Toggle() end)
		SpellBinderFrameCloseButton:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameCloseButton:Enable()
		SpellBinderFrameCloseButton:SetTextColor(1, 1, 1)
		SpellBinderFrameCloseButton:SetText(L["Close"])

		--SpellBinderFrameDoItButton
		local SpellBinderFrameDoItButton = CreateFrame("Button","SpellBinderFrameDoItButton",SpellBinderFrame,"UIPanelButtonTemplate2")
		SpellBinderFrameDoItButton:SetFrameStrata("DIALOG")
		SpellBinderFrameDoItButton:SetWidth(100)
		SpellBinderFrameDoItButton:SetHeight(24)
		SpellBinderFrameDoItButton:SetPoint("BOTTOMLEFT",SpellBinderFrame, 10, 10)
		SpellBinderFrameDoItButton:RegisterForClicks("LeftButtonUp")
		SpellBinderFrameDoItButton:SetScript("OnClick", function() SpellBinder:Set() end)
		SpellBinderFrameDoItButton:SetFont("GameFontHighlightSmall",12)
		SpellBinderFrameDoItButton:Disable()
		SpellBinderFrameDoItButton:SetTextColor(1, 1, 1)
		SpellBinderFrameDoItButton:SetText(L["Set Key"])

		local SpellBinderFrameRightText = SpellBinderFrame:CreateFontString("SpellBinderFrameRightText","DIALOG")
		SpellBinderFrameRightText:SetPoint("BOTTOMRIGHT",SpellBinderFrame, -10, 35)
		SpellBinderFrameRightText:SetFontObject("GameTooltipTextSmall")
		SpellBinderFrameRightText:SetTextColor(1, 1, 1)
		local SpellBinderFrameLeftText = SpellBinderFrame:CreateFontString("SpellBinderFrameLeftText","DIALOG")
		SpellBinderFrameLeftText:SetPoint("BOTTOMLEFT",SpellBinderFrame, 10, 35)
		SpellBinderFrameLeftText:SetFontObject("GameTooltipTextSmall")
		SpellBinderFrameLeftText:SetTextColor(1, 1, 1)
		local SpellBinderFrameTopText = SpellBinderFrame:CreateFontString("SpellBinderFrameTopText","DIALOG")
		SpellBinderFrameTopText:SetPoint("TOP",SpellBinderFrame, 0, -10)
		SpellBinderFrameTopText:SetFontObject("GameTooltipTextSmall")
		SpellBinderFrameTopText:SetTextColor(1, 1, 1)
		SpellBinderFrameTopText:SetText(L["SpellBinder by Nymbia"])

		SpellBinderFrame:Hide()

		self:SPELLS_CHANGED()
	end
	if SpellBinderFrame:IsVisible() then
		SpellBinderFrame:Hide()
	else
		SpellBinderFrame:Show()
		currentitem=nil
		currentbind1=nil
		currentbind2=nil
		SpellBinderFrameKeyBindButton1:SetText(L["Click to Set"])
		SpellBinderFrameKeyBindButton2:SetText(L["Click to Set"])
		SpellBinderFrameRightText:SetText("")
		SpellBinder:UpdateText()
		if SpellBinderFrameSpellBook1Button:GetText()==nil then
			SpellBinder:SPELLS_CHANGED()
		end
	end
end
function SpellBinder:Press(frame, button)
	if awaitinginput==false then
		_G["SpellBinderFrameKeyBindButton"..frame]:EnableKeyboard(true)
		_G["SpellBinderFrameKeyBindButton"..frame]:EnableMouseWheel(true)
		awaitinginput=true
		_G["SpellBinderFrameKeyBindButton"..frame]:SetText(L["Enter Key Combo"])
		SpellBinderFrameRightText:SetText(L["Left click binding button to unbind"])
		return
	end

	local screenshotKey = GetBindingKey("SCREENSHOT")
	if screenshotKey and arg1 == screenshotKey then
		Screenshot()
		return
	end

	if button == "LeftButton" then
		button = "BUTTON1"
	elseif button == "RightButto" then
		button = "BUTTON2"
	elseif button == "MiddleButton" then
		button = "BUTTON3"
	elseif button == "Button4" then
		button = "BUTTON4"
	elseif button == "Button5" then
		button = "BUTTON5"
	end
	local keyPressed = arg1
	if button then
		if button == "BUTTON1" or button == "BUTTON2" then
			_G["SpellBinderFrameKeyBindButton"..frame]:SetText(L["Click to Set"])
			_G["SpellBinderFrameKeyBindButton"..frame]:EnableKeyboard(false)
			_G["SpellBinderFrameKeyBindButton"..frame]:EnableMouseWheel(false)
			awaitinginput=false
			if frame == 1 then
				if currentbind1 then SetBinding(currentbind1) end
				currentbind1=currentbind2
				currentbind2=nil
			else
				if currentbind2 then SetBinding(currentbind2) end
				currentbind2=nil
			end
			SpellBinderFrameRightText:SetText("")
			self:UpdateText()
			return
		end
		keyPressed = button
	else
		keyPressed = arg1
	end
	if keyPressed == "UNKNOWN" or  keyPressed == "ESCAPE" then
		self:Toggle()
		return
	end

	if keyPressed:match(".SHIFT") or keyPressed:match(".CTRL") or keyPressed:match(".ALT") then
		return
	end
	if IsShiftKeyDown() then
		keyPressed = "SHIFT-"..keyPressed
	end
	if IsControlKeyDown() then
		keyPressed = "CTRL-"..keyPressed
	end
	if IsAltKeyDown() then
		keyPressed = "ALT-"..keyPressed
	end
	awaitinginput=false
	_G["SpellBinderFrameKeyBindButton"..frame]:EnableKeyboard(false)
	_G["SpellBinderFrameKeyBindButton"..frame]:EnableMouseWheel(false)
	_G["SpellBinderFrameKeyBindButton"..frame]:SetText(keyPressed)
	local oldkey = GetBindingAction(keyPressed)
	if string.len(oldkey) > 1 then
		SpellBinderFrameRightText:SetText(keyPressed..L[" bound to "]..oldkey)
	end
	if frame == 1 then
		currentbind1=keyPressed
	else
		if currentbind1 then
			currentbind2=keyPressed
		else
			currentbind1=keyPressed
		end
	end
	self:UpdateText()
end
function SpellBinder:UpdateText()
	SpellBinderFrameLeftText:SetText(currentitem)
	if currentitem == nil then
		currentbind1=nil
		currentbind2=nil
	end
	if currentbind1 then
		SpellBinderFrameKeyBindButton1:SetText(currentbind1)
	else
		SpellBinderFrameKeyBindButton1:SetText(L["Click to Set"])
	end
	if currentbind2 then
		SpellBinderFrameKeyBindButton2:SetText(currentbind2)
	else
		SpellBinderFrameKeyBindButton2:SetText(L["Click to Set"])
	end
	if currentitem then
		SpellBinderFrameKeyBindButton1:Enable()
		SpellBinderFrameKeyBindButton2:Enable()
		if currentbind1 then
			SpellBinderFrameDoItButton:Enable()
		else
			SpellBinderFrameDoItButton:Disable()
		end
	else
		SpellBinderFrameKeyBindButton1:Disable()
		SpellBinderFrameKeyBindButton2:Disable()
	end
end
function SpellBinder:ClickBookButton(num)
	if num == 5 then
		dewdrop:Open(_G["SpellBinderFrameSpellBook"..num.."Button"],
		'children', function(ar1, ar2)
			if ar1==1 then
				local numSpells = HasPetSpells()
				local multirankedspells={}
				for i=1,numSpells do
					local spell, rank = GetSpellName(i, BOOKTYPE_PET)
					local nextspell = GetSpellName(i+1, BOOKTYPE_PET)
					local passive = IsPassiveSpell(i, BOOKTYPE_PET)
					if not passive then
						if ((nextspell and nextspell~=spell) or (not nextspell)) and multirankedspells[spell]==nil then
							if string.len(rank)>2 then
								dewdrop:AddLine(
									'text', spell.."("..rank..")",
									'func', function()
										currentitem=spell.."("..rank..")"
										currentmode="spell"
										currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
										SpellBinder:UpdateText()
										dewdrop:Close()
									end
								)
							else
								dewdrop:AddLine(
									'text', spell,
									'func', function()
										currentitem=spell
										currentmode="spell"
										currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
										SpellBinder:UpdateText()
										dewdrop:Close()
									end
								)
							end
						elseif multirankedspells[spell]==nil then
							multirankedspells[spell]=true
							dewdrop:AddLine(
								'text', spell,
								'value', spell,
								'hasArrow', true
							)
						end
					end
				end
			elseif ar1==2 then
				local _, _, offset, numSpells = GetSpellTabInfo(num)
				for i=(1+offset),(offset+numSpells) do
					local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
					if spell==ar2 then
						dewdrop:AddLine(
							'text', spell.."("..rank..")",
							'func', function()
								currentitem=spell.."("..rank..")"
								currentmode="spell"
								currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
								SpellBinder:UpdateText()
								dewdrop:Close()
							end
						)
					end
				end
				dewdrop:AddLine(
					'text', L["Use No Rank (Will Always Cast Highest)"],
					'func', function()
						currentitem=ar2
						currentmode="spell"
						currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
						SpellBinder:UpdateText()
						dewdrop:Close()
					end
				)
			end
		end)
	else
		dewdrop:Open(_G["SpellBinderFrameSpellBook"..num.."Button"],
		'children', function(ar1, ar2)
			if ar1==1 then
				local _, _, offset, numSpells = GetSpellTabInfo(num)
				local multirankedspells={}
				for i=(1+offset),(offset+numSpells) do
					local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
					local nextspell = GetSpellName(i+1, BOOKTYPE_SPELL)
					local passive = IsPassiveSpell(i, BOOKTYPE_SPELL)
					if not passive then
						if ((nextspell and nextspell~=spell) or (not nextspell)) and multirankedspells[spell]==nil then
							if string.len(rank)>2 then
								dewdrop:AddLine(
									'text', spell.."("..rank..")",
									'func', function()
										currentitem=spell.."("..rank..")"
										currentmode="spell"
										currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
										SpellBinder:UpdateText()
										dewdrop:Close()
									end
								)
							else
								dewdrop:AddLine(
									'text', spell,
									'func', function()
										currentitem=spell
										currentmode="spell"
										currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
										SpellBinder:UpdateText()
										dewdrop:Close()
									end
								)
							end
						elseif multirankedspells[spell]==nil then
							multirankedspells[spell]=true
							dewdrop:AddLine(
								'text', spell,
								'value', spell,
								'hasArrow', true
							)
						end
					end
				end
			elseif ar1==2 then
				local _, _, offset, numSpells = GetSpellTabInfo(num)
				for i=(1+offset),(offset+numSpells) do
					local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
					if spell==ar2 then
						dewdrop:AddLine(
							'text', spell.."("..rank..")",
							'func', function()
								currentitem=spell.."("..rank..")"
								currentmode="spell"
								currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
								SpellBinder:UpdateText()
								dewdrop:Close()
							end
						)
					end
				end
				dewdrop:AddLine(
					'text', L["Use No Rank (Will Always Cast Highest)"],
					'func', function()
						currentitem=ar2
						currentmode="spell"
						currentbind1, currentbind2=GetBindingKey("SPELL "..currentitem)
						SpellBinder:UpdateText()
						dewdrop:Close()
					end
				)
			end
		end)
	end
end
function SpellBinder:ClickMacroButton()
	local allmacros = ""
	local warned = false
	dewdrop:Open(SpellBinderFrameMacroButton,
	'children', function(ar1, ar2)
		local numglobal,numchar = GetNumMacros()
		for i=1,numglobal do
			local name = GetMacroInfo(i)
			dewdrop:AddLine(
				'text', name,
				'func', function()
					currentitem=name
					currentmode="macro"
					currentbind1, currentbind2=GetBindingKey("MACRO "..currentitem)
					SpellBinder:UpdateText()
					dewdrop:Close()
				end
			)
			if allmacros:match(":"..name..":") and not warned then
				SpellBinder:Print(L["Warning"])
				warned = true
			end
			allmacros = allmacros..":"..name..":"
		end
		for i=19,(numchar+18) do
			local name = GetMacroInfo(i)
			dewdrop:AddLine(
				'text', name,
				'func', function()
					currentitem=name
					currentmode="macro"
					currentbind1, currentbind2=GetBindingKey("MACRO "..currentitem)
					SpellBinder:UpdateText()
					dewdrop:Close()
				end
			)
			if allmacros:match(":"..name..":") and not warned then
				SpellBinder:Print(L["Warning"])
				warned = true
			end
			allmacros = allmacros..":"..name..":"
		end
	end)
end
function SpellBinder:ClickItemButton()
	dewdrop:Open(SpellBinderFrameItemButton,
	'children', function(ar1, ar2)
		dewdrop:AddLine(
			'text', L["Enter Exact Item Name or Drag and Drop"],
			'hasArrow', true,
			'hasEditBox', true,
			'editBoxFunc', function(text)
				currentitem=text
				if currentitem:match("%|h%[(.+)%]%|h") then
					currentitem = currentitem:match("%|h%[(.+)%]%|h")
				end
				currentmode="item"
				currentbind1, currentbind2=GetBindingKey("ITEM "..currentitem)
				SpellBinder:UpdateText()
				dewdrop:Close()
			end
		)
	end)
end

--feel free to correct this crap if it's wrong.
local bindables = {
	'ESCAPE', "`", 'TAB', 'SPACE', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S',
	'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '-', '=', '[', ']',
	'\\', ';', "'", '.', '/', ',', 'ENTER', 'MOUSEWHEELUP', 'MOUSEWHEELDOWN', 'BACKSPACE', 'DELETE',
	'INSERT', 'HOME', 'END', 'PAGEUP', 'PAGEDOWN', 'NUMLOCK', 'NUMPADSLASH', 'NUMPADMULTIPLY', 'NUMPADMINUS',
	'NUMPADPLUS', 'NUMPADENTER', 'NUMPADPERIOD',
}
for i = 0, 9 do
	bindables[#bindables+1] = tostring(i)
	bindables[#bindables+1] = 'NUMPAD'..i
end
for i = 1, 12 do
	bindables[#bindables+1] = 'F'..i
end
for i = 1, 5 do
	bindables[#bindables+1] = 'BUTTON'..i
end
local modifiers = { -- order: alt-ctrl-shift-
	'', 'ALT-', 'CTRL-', 'SHIFT-', 'ALT-CTRL-', 'ALT-SHIFT-', 'CTRL-SHIFT-', 'ALT-CTRL-SHIFT-'
}
local bound = {
	ITEM = {},
	SPELL = {},
	MACRO = {},
}
function SpellBinder:MakeListMenu()
	for k, v in pairs(bound) do
		for k in pairs(v) do
			v[k] = nil
		end
	end
	for _, key in ipairs(bindables) do
		for _, modifier in ipairs(modifiers) do
			local action = GetBindingAction(modifier..key)
			if action then
				local spell = action:match('^SPELL (.+)$')
				if spell then
					bound.SPELL[modifier..key] = spell
				end
				local item = action:match('^ITEM (.+)$')
				if item then
					bound.ITEM[modifier..key] = item
				end
				local macro = action:match('^MACRO (.+)$')
				if macro then
					bound.MACRO[modifier..key] = macro
				end
			end
		end
	end
	dewdrop:Open(SpellBinderFrameListButton,
		'children', function(ar1, ar2)
			if ar1==1 then
				dewdrop:AddLine('text', L["Spell"], 'hasArrow', true, 'value', "SPELL")
				dewdrop:AddLine('text', L["Item"], 'hasArrow', true, 'value', "ITEM")
				dewdrop:AddLine('text', L["Macro"], 'hasArrow', true, 'value', "MACRO")
			elseif ar1==2 then
				if ar2 == 'SPELL' then
					for key, spellname in pairs(bound.SPELL) do
						dewdrop:AddLine(
							'text', spellname..' - '..key,
							'func', function()
								currentitem = spellname
								currentmode = 'spell'
								currentbind1, currentbind2=GetBindingKey("SPELL "..spellname)
								SpellBinder:UpdateText()
								dewdrop:Close()
							end
						)
					end
				elseif ar2 == 'ITEM' then
					for key, itemname in pairs(bound.ITEM) do
						dewdrop:AddLine(
							'text', itemname..' - '..key,
							'func', function()
								currentitem = itemname
								currentmode = 'item'
								currentbind1, currentbind2=GetBindingKey("ITEM "..itemname)
								SpellBinder:UpdateText()
								dewdrop:Close()
							end
						)
					end
				else --MACRO
					for key, macroname in pairs(bound.MACRO) do
						dewdrop:AddLine(
							'text', macroname..' - '..key,
							'func', function()
								currentitem = macroname
								currentmode = 'macro'
								currentbind1, currentbind2=GetBindingKey("MACRO "..macroname)
								SpellBinder:UpdateText()
								dewdrop:Close()
							end
						)
					end
				end
			end
		end)


end
function SpellBinder:Set()
	if InCombatLockdown() then
		self:Print(L["Cannot bind keys while in combat"])
		return
	end
	local clear1, clear2
	if currentmode == "spell" then
		clear1, clear2 = GetBindingKey("SPELL "..currentitem)
		if clear1 then
			SetBinding(clear1)
		end
		if clear2 then
			SetBinding(clear2)
		end
		SetBinding(currentbind1)
		SetBindingSpell(currentbind1, currentitem)
		if currentbind2 then
			SetBinding(currentbind2)
			SetBindingSpell(currentbind2, currentitem)
		end
	elseif currentmode == "macro" then
		if currentitem:match("^(%d+)$") then
			self:Print(L["NumWarn"])
		end
		clear1, clear2 = GetBindingKey("MACRO "..currentitem)
		if clear1 then
			SetBinding(clear1)
		end
		if clear2 then
			SetBinding(clear2)
		end
		SetBinding(currentbind1)
		SetBindingMacro(currentbind1, currentitem)
		if currentbind2 then
			SetBinding(currentbind2)
			SetBindingMacro(currentbind2, currentitem)
		end
	elseif currentmode == "item" then
		clear1, clear2 = GetBindingKey("ITEM "..currentitem)
		if clear1 then
			SetBinding(clear1)
		end
		if clear2 then
			SetBinding(clear2)
		end
		SetBinding(currentbind1)
		SetBindingItem(currentbind1, currentitem)
		if currentbind2 then
			SetBinding(currentbind2)
			SetBindingItem(currentbind2, currentitem)
		end
	end
	if currentbind2 then
		if ( GetLocale() == "koKR" ) then
			SpellBinder:Print(currentitem.."의 단축키 설정을 "..currentbind1.." 그리고 "..currentbind2.."|1로;으로; 설정합니다.")
		else
			SpellBinder:Print("Set "..currentitem.." to "..currentbind1.." and "..currentbind2)
		end
	else
		if ( GetLocale() == "koKR" ) then
			SpellBinder:Print(currentitem.."의 단축키 설정을 "..currentbind1.."|1로;으로; 설정합니다.")
		else
			SpellBinder:Print("Set "..currentitem.." to "..currentbind1)
		end
	end
	currentmode=nil
	currentitem=nil
	currentbind1=nil
	currentbind2=nil
	SpellBinderFrameKeyBindButton1:SetText(L["Click to Set"])
	SpellBinderFrameKeyBindButton2:SetText(L["Click to Set"])
	SpellBinderFrameRightText:SetText("")
	SpellBinderFrameDoItButton:Disable()
	self:UpdateText()
	SaveBindings(GetCurrentBindingSet())
end
function SpellBinder:SPELLS_CHANGED()
	if not SpellBinderFrame then
		return
	end
	for i=1,GetNumSpellTabs() do
		local name=GetSpellTabInfo(i)
		_G["SpellBinderFrameSpellBook"..i.."Button"]:SetText(name)
	end
	if HasPetSpells() then
		SpellBinderFrameSpellBook5Button:Enable()
	else
		SpellBinderFrameSpellBook5Button:Disable()
	end
end
