--[[
    Soundtrack addon for World of Warcraft

    Mount events functions.
]]

local function debugEvents(msg)
    Soundtrack.Trace(msg, 0.25, 0.25, 0.25)
end


Soundtrack.MountEvents.InFlight = false
Soundtrack.MountEvents.IsMounted = false

function Soundtrack.MountEvents.OnLoad()
end


function Soundtrack.MountEvents.OnUpdate(deltaT)

    if not Soundtrack.Settings.EnableMiscMusic then
        return
    end
    
    -- Really inefficient way to detect taxis...
    local unitOnTaxi = UnitOnTaxi("player")
    
    if Soundtrack.MountEvents.InFlight and unitOnTaxi == nil then
        Soundtrack.MountEvents.InFlight = false
        debugEvents("UnitOnTaxi and in Flight! Stop flight")
        Soundtrack.StopEvent("Misc", "Flight")
    elseif not Soundtrack.MountEvents.InFlight and unitOnTaxi == 1 then 
        debugEvents("UnitOnTaxi and not in Flight! Start flight")
        Soundtrack.MountEvents.InFlight = true
        Soundtrack.PlayEvent("Misc", "Flight")
    end
    
    if not unitOnTaxi then
        local isFlying = IsFlying()
        local isMounted = IsMounted()
        
        -- TODO would be nicer to deal with each mount event separately and just use the priorities to avoid 
        -- these complicated conditions:
        if not Soundtrack.MountEvents.IsFlying and isFlying then
            Soundtrack.MountEvents.IsFlying = true
            Soundtrack.PlayEvent("Misc", "Flying Mount")
        elseif (not Soundtrack.MountEvents.IsMounted or not Soundtrack.MountEvents.IsFlying) and isMounted then
            Soundtrack.MountEvents.IsMounted = true
            Soundtrack.PlayEvent("Misc", "Mount")
        elseif Soundtrack.MountEvents.IsMounted and not isMounted then
            debugEvents("IsMounted and and IsMounted! Stop mount")
            Soundtrack.MountEvents.IsMounted = false
            Soundtrack.StopEvent("Misc", "Mount") 
        elseif Soundtrack.MountEvents.IsFlying and not isFlying then
            Soundtrack.MountEvents.IsFlying = false
            Soundtrack.StopEvent("Misc", "Flying Mount")
        end
    end
end

function Soundtrack.MountEvents.Initalize()
    Soundtrack.AddEvent("Misc", "Mount", 5, true)
    Soundtrack.AddEvent("Misc", "Flight", 5, true)
    Soundtrack.AddEvent("Misc", "Flying Mount", 5, true)
end