--[[
    Soundtrack addon for World of Warcraft

    Soundtrack library functions.
    Functions that manage the users list of available music tracks.
]]

-- Remove track popup
StaticPopupDialogs["SOUNDTRACK_REMOVETRACK"] = {
    text = [[Do you want to remove this track from your library?]],
    button1 = "OK",
    button2 = "Cancel",
    OnAccept = function() 
        Soundtrack.Library.RemoveTrack(SoundtrackFrame_SelectedTrack) 
    end,
    timeout = 0,
    whileDead = 1,
    hideOnEscape = 1
}


Soundtrack.Library.CurrentlyPlayingTrack = nil
local fadeOut = false

function Soundtrack.Library.AddTrack(trackName, _length, _title, _artist, _album)
    Soundtrack_Tracks[trackName] = { length = _length, title = _title, artist = _artist, album = _album }
    Soundtrack.SortTracks()
end

    
function Soundtrack.Library.AddDefaultTrack(trackName, _length, _title, _artist, _album)             
    Soundtrack_Tracks[trackName] = { length = _length, title = _title, artist = _artist, album = _album, defaultTrack = true }
    Soundtrack.SortTracks()
end


function Soundtrack.Library.PauseMusic()
    --StopMusic()
    Soundtrack.Library.CurrentlyPlayingTrack = "None"
    Soundtrack.TraceLibrary("Playing empty track.")
    Soundtrack.TraceLibrary("PlayMusic('Interface\\AddOns\\Soundtrack\\EmptyTrack.mp3')")
    PlayMusic("Interface\\AddOns\\Soundtrack\\EmptyTrack.mp3")
    SoundtrackFrame_TouchTracks()
end

function Soundtrack.Library.StopTrack()
    Soundtrack.TraceLibrary("StopTrack()")
    fadeOut = true
    nextTrackInfo = nil
end    

local nextTrackInfo;
local nextFileName;
local nextTrackName;
    
local function DelayedPlayMusic()
   Soundtrack.Library.CurrentlyPlayingTrack = nextTrackName
   SetNowPlayingText(nextTrackInfo.title, nextTrackInfo.artist, nextTrackInfo.album)
   Soundtrack.TraceLibrary("PlayMusic(".. nextFileName ..")")
   -- Soundtrack.Library.StopTrack()
   PlayMusic(nextFileName)
   SoundtrackFrame_TouchTracks()
end


local originalVolume
local currentVolume

function Soundtrack.Library.OnUpdate(deltaT)
   if fadeOut == true then
      if currentVolume <= 0 then
	 Soundtrack.TraceLibrary("Restoring volume to" .. originalVolume)
	 StopMusic()
	 SetCVar("Sound_MusicVolume", originalVolume)
	 currentVolume = originalVolume
	 Soundtrack.Library.CurrentlyPlayingTrack = nil

	 if nextTrackInfo ~= nil then
	    DelayedPlayMusic()
	    nextTrackInfo = nil
	 end
	 SoundtrackFrame_TouchTracks()
	 fadeOut = false
      else
	 currentVolume = currentVolume - 0.01
	 if currentVolume < 0 then currentVolume = 0 end
	 SetCVar("Sound_MusicVolume", currentVolume)
      end
   end
end

function Soundtrack.Library.PlayTrack(trackName, soundEffect)

    if soundEffect == nil then soundEffect = false end

    Soundtrack.TraceLibrary("PlayTrack(".. Soundtrack.GetPathFileName(trackName) ..")")
    
    -- Check if the track is valid
    if not Soundtrack_Tracks[trackName] then
        return
    end
    
    -- Check if that track is already playing
    if trackName == Soundtrack.Library.CurrentlyPlayingTrack then
        return
    end
    
    nextTrackInfo = Soundtrack_Tracks[trackName]
    
    -- TODO : Change DefaultScore name
    if nextTrackInfo.defaultTrack then
        nextFileName = "Sound\\Music\\" .. trackName .. ".mp3"
    else
        nextFileName = "Interface\\AddOns\\Soundtrack\\Music\\"..trackName..".mp3"
    end        
    
    -- Everything ok, play the track
    if not soundEffect then
        nextTrackName = trackName
        -- HACK because of Blizzard broke cross fading
        -- Start fading out current song
	if fadeOut == false then -- Only record current volume if we aren't already fading out
	   originalVolume = tonumber(GetCVar("Sound_MusicVolume"))
	   currentVolume = originalVolume    
	end
	fadeOut = true
    else
        Soundtrack.TraceLibrary("PlaySoundFile(".. fileName ..")")
        PlaySoundFile(fileName) -- sound effect. play the music overlapping other music
	nextTrackInfo = nil
    end
    
    -- Update the UI if its opened
    SoundtrackFrame_TouchTracks()
end



-- Removes a track from the library.
function Soundtrack.Library.RemoveTrackWithConfirmation()
    -- Confirmation
    StaticPopup_Show("SOUNDTRACK_REMOVETRACK")
end
    
function Soundtrack.Library.RemoveTrack(trackName)
    if trackName then
        Soundtrack_Tracks[trackName] = nil
        Soundtrack.SortTracks()
        
        -- Remove the track from any event that assigns it
        for _,eventTab in ipairs(Soundtrack_EventTabs) do
            for k,v in Soundtrack_Events[eventTab] do 
                for i,tn in ipairs(v.tracks) do
                    if tn == trackName then
                        Soundtrack.TraceLibrary("Removed assigned track "..trackName)
                        table.remove(v.tracks, i)
                        break
                    end
                end
            end
        end
        
        -- Refresh assigned counts
        SoundtrackFrame_RefreshEvents()
    end
end