--[[
    Soundtrack addon for World of Warcraft

    Dance events functions.
]]

local function debugDance(msg)
    Soundtrack.Util.DebugPrint(msg, 0.0, 1.0, 1.0)
end

function Soundtrack.DanceEvents.OnLoad()
    this:RegisterEvent("CHAT_MSG_TEXT_EMOTE")
end

function Soundtrack.DanceEvents.OnEvent(arg1, arg2)
    if not Soundtrack.Settings.EnableMiscMusic then
        return
    end
    
    if event == "CHAT_MSG_TEXT_EMOTE" then
        for i,emote in ipairs(SOUNDTRACK_DANCE_EMOTES) do
            if string.find(arg1, emote) then
                -- Check if the dance is initated by the player
                if UnitName("player") == arg2 then
                    local raceName = UnitRace("player")
                    local sex = UnitSex("player")
                    if sex == 2 then 
                        Soundtrack.PlayEvent("Dance", raceName .. " male")
                    elseif sex == 3 then
                        Soundtrack.PlayEvent("Dance", raceName .. " female")
                    end
                end
                break
            end
        end
    end
end


function Soundtrack.DanceEvents.Initialize()
    Soundtrack.AddEvent("Dance", "Human male", 5, false)
    Soundtrack.AddEvent("Dance", "Human male", 5, false)
    Soundtrack.AddEvent("Dance", "Human female", 5, false)
    Soundtrack.AddEvent("Dance", "Dwarf male", 5, false)
    Soundtrack.AddEvent("Dance", "Dwarf female", 5, false)
    Soundtrack.AddEvent("Dance", "Gnome male", 5, false)
    Soundtrack.AddEvent("Dance", "Gnome female", 5, false)
    Soundtrack.AddEvent("Dance", "Night Elf male", 5, false)
    Soundtrack.AddEvent("Dance", "Night Elf female", 5, false)
    Soundtrack.AddEvent("Dance", "Undead male", 5, false)
    Soundtrack.AddEvent("Dance", "Undead female", 5, false)
    Soundtrack.AddEvent("Dance", "Orc male", 5, false)
    Soundtrack.AddEvent("Dance", "Orc female", 5, false)
    Soundtrack.AddEvent("Dance", "Tauren male", 5, false)
    Soundtrack.AddEvent("Dance", "Tauren female", 5, false)
    Soundtrack.AddEvent("Dance", "Troll male", 5, false)
    Soundtrack.AddEvent("Dance", "Troll female", 5, false)
    Soundtrack.AddEvent("Dance", "Blood Elf male", 5, false)
    Soundtrack.AddEvent("Dance", "Blood Elf female", 5, false)
    Soundtrack.AddEvent("Dance", "Draenei male", 5, false)
    Soundtrack.AddEvent("Dance", "Draenei female", 5, false)
end