
local function debug(msg)
	Soundtrack.Util.DebugPrint(msg, 0.6, 0.6, 1.0)
end

Soundtrack.CustomEvents = {
    BuffEvents = {}
}

Soundtrack.ActionHouse = false
Soundtrack.Bank = false
Soundtrack.Merchant = false

-- table can be Custom or Misc. 
function Soundtrack.CustomEvents.RegisterUpdateScript(name, table, _priority, _continuous, _script)
    if table == "Custom" then
        Soundtrack_CustomEvents[name] = { script = _script, type = "Update Script", priority=_priority, continuous=_continuous };
    elseif table == "Misc" then
        Soundtrack_MiscEvents[name] = { script = _script, type = "Update Script", priority=_priority, continuous=_continuous };
    end
    
    if _trigger ~= nil then
        this:RegisterEvent(_trigger);
    end
    
    Soundtrack.AddEvent(table, name, _priority, _continuous)
end

-- table can be Custom or Misc. 
function Soundtrack.CustomEvents.RegisterEventScript(name, table, _trigger, _priority, _continuous, _script)
    if table == "Custom" then
        Soundtrack_CustomEvents[name] = { trigger = _trigger, script = _script, type = "Event Script", priority=_priority, continuous=_continuous };
    elseif table == "Misc" then
        Soundtrack_MiscEvents[name] = { trigger = _trigger, script = _script, type = "Event Script", priority=_priority, continuous=_continuous }; 
    end
    
    if _trigger ~= nil then
        this:RegisterEvent(_trigger);
    end
    
    Soundtrack.AddEvent(table, name, _priority, _continuous)
end

function Soundtrack.IsBuffActive(buffTexture)
    for i=1,24 do
	    if GetPlayerBuffTexture(i) == buffTexture then
	        return true
	    end
	end
	
	return false
end

function Soundtrack.CustomEvents.RegisterBuffEvent(eventName, table, _buffTexture, _priority, _continuous)
    
    if table == "Custom" then
        Soundtrack_CustomEvents[eventName] = 
        { 
            buffTexture=_buffTexture, 
            stackLevel=_priority, 
            active=false,
            type="Buff",
            priority=_priority, 
            continuous=_continuous
        }    
    elseif table == "Misc" then
        Soundtrack_MiscEvents[eventName] = 
        { 
            buffTexture=_buffTexture, 
            stackLevel=_priority, 
            active=false,
            type="Buff",
            priority=_priority, 
            continuous=_continuous
        }  
    end
    Soundtrack.AddEvent(table, eventName, _priority, _continuous);
end

function Soundtrack.CustomEvents.Initialize()
    this:RegisterEvent("PLAYER_AURAS_CHANGED")
    this:RegisterEvent("AUCTION_HOUSE_CLOSED")
    this:RegisterEvent("AUCTION_HOUSE_SHOW")
    this:RegisterEvent("BANKFRAME_CLOSED")
    this:RegisterEvent("BANKFRAME_OPENED")
    this:RegisterEvent("MERCHANT_CLOSED")
    this:RegisterEvent("MERCHANT_SHOW")
    
   
    -- Add fixed custom events  
    
    Soundtrack.CustomEvents.RegisterUpdateScript(
        "Swimming", 
        "Misc",
        5,
        true,
        function()
            if SNDCUSTOM_IsSwimming == nil then 
                SNDCUSTOM_IsSwimming = false 
            end

            if SNDCUSTOM_IsSwimming and not IsSwimming() then
                Soundtrack.StopEvent("Misc", "Swimming");
                SNDCUSTOM_IsSwimming = false
            elseif not SNDCUSTOM_IsSwimming and IsSwimming() then
                Soundtrack.PlayEvent("Misc", "Swimming");
                SNDCUSTOM_IsSwimming = true;
            end
        end
	    );
	    
	Soundtrack.CustomEvents.RegisterUpdateScript(
        "AuctionHouse", 
        "Misc",
        5,
        true,
        function()
            if SNDCUSTOM_AuctionHouse == nil then 
                SNDCUSTOM_AuctionHouse = false 
            end

            if SNDCUSTOM_AuctionHouse and not Soundtrack.AuctionHouse then
                Soundtrack.StopEvent("Misc", "AuctionHouse");
                SNDCUSTOM_AuctionHouse = false
            elseif not SNDCUSTOM_AuctionHouse and Soundtrack.AuctionHouse then
                Soundtrack.PlayEvent("Misc", "AuctionHouse");
                SNDCUSTOM_AuctionHouse = true;
            end
        end
	    );
	    
	Soundtrack.CustomEvents.RegisterUpdateScript(
        "Bank", 
        "Misc",
        5,
        true,
        function()
            if SNDCUSTOM_Bank == nil then 
                SNDCUSTOM_Bank = false 
            end

            if SNDCUSTOM_Bank and not Soundtrack.Bank then
                Soundtrack.StopEvent("Misc", "Bank");
                SNDCUSTOM_Bank = false
            elseif not SNDCUSTOM_Bank and Soundtrack.Bank then
                Soundtrack.PlayEvent("Misc", "Bank");
                SNDCUSTOM_Bank = true;
            end
        end
	    );
	    
	Soundtrack.CustomEvents.RegisterUpdateScript(
        "Merchant", 
        "Misc",
        6, -- TODO Anthony: This conflicts with battle level
        true,
        function()
            if SNDCUSTOM_Merchant == nil then 
                SNDCUSTOM_Merchant = false 
            end

            if SNDCUSTOM_Merchant and not Soundtrack.Merchant then
                Soundtrack.StopEvent("Misc", "Merchant");
                SNDCUSTOM_Merchant = false
            elseif not SNDCUSTOM_Merchant and Soundtrack.Merchant then
                Soundtrack.PlayEvent("Misc", "Merchant");
                SNDCUSTOM_Merchant = true;
            end
        end
	    );
	    
	
	Soundtrack.CustomEvents.RegisterEventScript(
	    "LevelUp",
	    "Misc",
	    "PLAYER_LEVEL_UP",
	    8,
	    false,
	    function()
	        Soundtrack.PlayEvent("Misc", "LevelUp");
	    end
	    );
	
	Soundtrack.CustomEvents.RegisterEventScript(
	    "JoinParty",
	    "Misc",
	    "PARTY_MEMBERS_CHANGED",
	    6,
	    false,
	    function()
	        if SOUNDTRACK_InParty == nil then 
                SOUNDTRACK_InParty = false 
            end
	        if not SOUNDTRACK_InParty and GetNumRaidMembers() == 0 and GetNumPartyMembers() > 0 then
                Soundtrack.PlayEvent("Misc", "JoinParty")
                SOUNDTRACK_InParty = true
	        elseif SOUNDTRACK_InParty and GetNumPartyMembers() == 0 then
                SOUNDTRACK_InParty = false
	        end
	    end
	    );
	    
	Soundtrack.CustomEvents.RegisterEventScript(
	    "JoinRaid",
	    "Misc",
	    "PARTY_MEMBERS_CHANGED",
	    6,
	    false,
	    function()
	        if SOUNDTRACK_InRaid == nil then 
                SOUNDTRACK_InRaid = false 
            end
	        if not SOUNDTRACK_InRaid and GetNumRaidMembers() > 0 then
                Soundtrack.PlayEvent("Misc", "JoinRaid")
                SOUNDTRACK_InRaid = true
	        elseif SOUNDTRACK_InRaid and not GetNumRaidMembers() == 0 then
                SOUNDTRACK_InRaid = false
	        end
	    end
	    );
	   
	    
	Soundtrack.CustomEvents.RegisterEventScript(
	    "DuelRequested",
	    "Misc",
	    "DUEL_REQUESTED",
	    5,
	    false,
	    function()
	        Soundtrack.PlayEvent("Misc", "DuelRequested")
	    end
	    );
	
	Soundtrack.CustomEvents.RegisterEventScript(
	    "QuestComplete",
	    "Misc",
	    "QUEST_COMPLETE",
	    6,
	    false,
	    function()
	        Soundtrack.PlayEvent("Misc", "QuestComplete")
	    end
	    );    
	   
	Soundtrack.CustomEvents.RegisterBuffEvent("RogueSprint", "Misc", "Interface\\Icons\\Ability_Rogue_Sprint", 8, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("RogueStealth", "Misc", "Interface\\Icons\\Ability_Stealth", 5, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidCatFormAmbush", "Misc", "Interface\\Icons\\Ability_Ambush", 5, true)
	
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidDash", "Misc", "Interface\\Icons\\Ability_Druid_Dash", 8, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidCatForm", "Misc", "Interface\\Icons\\Ability_Druid_CatForm", 8, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidAquaticForm", "Misc", "Interface\\Icons\\Ability_Druid_AquaticForm", 8, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidBearForm", "Misc", "Interface\\Icons\\Ability_Racial_BearForm", 8, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidTravelForm", "Misc", "Interface\\Icons\\Ability_Druid_TravelForm", 8, true)
	Soundtrack.CustomEvents.RegisterBuffEvent("DruidFlightForm", "Misc", "Interface\\Icons\\Ability_Druid_FlightForm", 8, true)
	
	-- Make sure there are events for each customevent
	for k,v in pairs(Soundtrack_CustomEvents) do
	    Soundtrack.AddEvent("Custom", k, v.priority, v.continuous)
	end
end

local delayTime = 0
local updateTime = 1


-- nil triggers are called at each update.
function Soundtrack.CustomEvents.OnUpdate()    
       
    if Soundtrack.Settings.EnableCustomMusic then
        for k,v in pairs(Soundtrack_CustomEvents) do
            if v.type == "Update Script" then
                RunScript(v.script);
            end
        end
    end
    
    if Soundtrack.Settings.EnableMiscMusic then
        for k,v in pairs(Soundtrack_MiscEvents) do
            if v.type == "Update Script" then
                
                v.script();
            end
        end
    end
end


function Soundtrack.CustomEvents.OnEvent()
    
    if event == "AUCTION_HOUSE_SHOW" then
        Soundtrack.AuctionHouse = true
    elseif event == "AUCTION_HOUSE_CLOSED" then
        Soundtrack.AuctionHouse = false
    elseif event == "BANKFRAME_OPENED" then
        Soundtrack.Bank = true
    elseif event == "BANKFRAME_CLOSED" then
        Soundtrack.Bank = false
    elseif event == "MERCHANT_SHOW" then
        Soundtrack.Merchant = true
    elseif event == "MERCHANT_CLOSED" then
        Soundtrack.Merchant = false
    
    -- Handle custom buff events
    elseif event == "PLAYER_AURAS_CHANGED" then
        if Soundtrack.Settings.EnableCustomMusic then
            for k,v in pairs(Soundtrack_CustomEvents) do
                if v.type == "Buff" then
                    local buffActive = Soundtrack.IsBuffActive(v.buffTexture)
                    
                    if not v.active and buffActive then
                        v.active = true
                        Soundtrack.PlayEvent("Custom", k)
                    elseif v.active and not buffActive then
                        v.active = false
                        Soundtrack.StopEvent("Custom", k)
                    end
                end
            end
        end
        
        if Soundtrack.Settings.EnableMiscMusic then
            for k,v in pairs(Soundtrack_MiscEvents) do
                if v.type == "Buff" then
                    local buffActive = Soundtrack.IsBuffActive(v.buffTexture)
                    
                    if not v.active and buffActive then
                        v.active = true
                        Soundtrack.PlayEvent("Misc", k)
                    elseif v.active and not buffActive then
                        v.active = false
                        Soundtrack.StopEvent("Misc", k)
                    end
                end
            end
        end
    end
    
    -- Handle custom events
    if Soundtrack.Settings.EnableCustomMusic then
        for k,v in pairs(Soundtrack_CustomEvents) do
            if v.type == "Event Script" then
                if event == v.trigger then
                    RunScript(v.script)
                end
            end
        end
    end
    
    if Soundtrack.Settings.EnableMiscMusic then
        for k,v in pairs(Soundtrack_MiscEvents) do
            if v.type == "Event Script" then
                if event == v.trigger then
                    v.script();
                end
            end
        end
    end
end