SOLACEREP_VER=0.1;

SOLACE_REPHELP="Displays your reputation with the faction of your choice: e.g. `/solace rep Storm` returns your Stormwind and Stormpike Guard reputation values.  `/solace rep showall` for all."

local SolaceRepList = { };

function SolaceRep_OnLoad()
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("UPDATE_FACTION");
end

function SolaceRepHandler(msg,index)
	local bool repFound = false;
	if msg then
		msg = strlower(msg);
		if ( msg == "showall" ) then
			for i = 1, SolaceRepList.count do
				local _, _, _, _, _,earnedFaction, _, _, _, _, _ = GetFactionInfo(i);
				local prettyFaction = SolaceParseFaction(earnedFaction);
				DEFAULT_CHAT_FRAME:AddMessage("Your "..SolaceRepList[i].." reputation is "..prettyFaction.."!");
			end
			return;
		end
		local msglen = strlen(msg);
		for i = 1, SolaceRepList.count do
			if ( strsub(strlower(SolaceRepList[i]),1,msglen) == msg ) then
				local _, _, _, _, _,earnedFaction, _, _, _, _, _ = GetFactionInfo(i);
				local prettyFaction = SolaceParseFaction(earnedFaction);
				DEFAULT_CHAT_FRAME:AddMessage("Your "..SolaceRepList[i].." reputation is "..prettyFaction.."!");
				repFound = true;
			end
		end
	end
	if not repFound then
		DEFAULT_CHAT_FRAME:AddMessage(SOLACE_REPHELP);
	end
end

function SolaceParseFaction(earned)
	local string pretty = "";
	local Exalted = 42000;
	local Revered = 21000;
	local Honored = 9000;
	local Friendly = 3000;
	local Neutral = 0;
	local Unfriendly = -3000;
	local Hostile = -6000;
	local Hated = -42000;
	
	if ( earned >= Exalted ) then
		pretty = "Exalted ("..earned-Exalted.."/999)";
	elseif ( earned >= Revered ) then
		pretty = "Revered ("..earned-Revered.."/21000)";
	elseif (earned >= Honored ) then
		pretty = "Honored ("..earned-Honored.."/12000)";
	elseif ( earned >= Friendly ) then
		pretty = "Friendly ("..earned-Friendly.."/6000)";
	elseif ( earned >= Neutral ) then
		pretty = "Neutral ("..earned-Neutral.."/3000)";
	elseif ( earned >= Unfriendly ) then
		pretty = "Unfriendly ("..earned-Unfriendly.."/3000)";
	elseif ( earned >= Hostile ) then
		pretty = "Hostile ("..earned-Hostile.."/3000)";
	elseif ( earned >= Hated ) then
		pretty = "Hated ("..earned-Hated.."/36000)";
	end
	
	return pretty;
end

local function SolaceUpdateRepList()
	if not SolaceRepList.count then
		SolaceRepList.count = GetNumFactions();
	elseif ( SolaceRepList.count == GetNumFactions() ) then
		return;
	end
	
	for i = 1,SolaceRepList.count do
		SolaceRepList[i], _, _, _, _, _, _, _, _, _, _ = GetFactionInfo(i);
	end
end

function SolaceRep_OnEvent(event)
	if ( event == "ADDON_LOADED" and arg1 == "SolaceRep" ) then
		SolaceCmdInit("rep",SOLACE_REPHELP,SolaceRepHandler);
		DEFAULT_CHAT_FRAME:AddMessage("SolaceRep-"..SOLACEREP_VER.." loaded!");
	elseif ( event == "PLAYER_ENTERING_WORLD" or event == "UPDATE_FACTION" ) then
		SolaceUpdateRepList();
	end
end