--[[
	Copyright (C) 2006-2007 Nymbia

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
]]
local delay = 1.5

Sniff = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0")
local previous
local toget = {}
local table_remove = table.remove
local function slashhandler(msg)
	if tonumber(msg) then
		toget[#toget+1] = tonumber(msg)
	elseif msg:match('%-') then
		local first, last = msg:match('(%d+)%-(%d+)')
		for i = tonumber(first), tonumber(last) do
			toget[#toget+1] = i
		end
	elseif msg:match(',') then
		for id in msg:gmatch('(%d+)') do
			toget[#toget+1] = tonumber(id)
		end
	else
		return Sniff:Print('Usage: /item itemid or /item itemid1, itemid2 or /item startid-endid')
	end
	if not Sniff:IsEventScheduled('SniffDataGrabber') then
		Sniff:GrabData()
		Sniff:ScheduleRepeatingEvent('SniffDataGrabber', Sniff.GrabData, delay, Sniff)
	end
end
function Sniff:OnInitialize()
	self:RegisterChatCommand({'/item'},slashhandler)
	CreateFrame("GameTooltip","SniffTooltip",UIParent,"GameTooltipTemplate")
end
function Sniff:GrabData()
	local skipforward
	if previous then
		local _, link = GetItemInfo(previous)
		if link then
			local id = link:match('item:(%d+)')
			self:Print(id..':', link)
		else
			self:Print(previous..': no data')
		end
		previous = nil
	end
	if toget[1] then
		if GetItemInfo(toget[1]) then
			local _, link = GetItemInfo(toget[1])
			local id = link:match('item:(%d+)')
			self:Print(id..':', link)
			skipforward = true
		else
			SniffTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE")
			SniffTooltip:SetHyperlink("item:" .. toget[1])
			previous = toget[1]
		end
		table_remove(toget, 1)
	else
		self:CancelScheduledEvent('SniffDataGrabber')
	end
	if skipforward then
		self:GrabData()
	end
end