if select(2, UnitClass("player")) ~= "DRUID" then
	return
end

SmartyCatManaBar = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0")

local L = AceLibrary("AceLocale-2.2"):new("SmartyCatManaBar")

local dewdrop, SML, LibDruidMana, options

function SmartyCatManaBar:OnInitialize()
	dewdrop = AceLibrary("Dewdrop-2.0")
	SML = LibStub('LibSharedMedia-2.0')
	self:RegisterDB("SmartyCatManaBarDB")
	
	SML:Register("statusbar", "Perl", "Interface\\AddOns\\SmartyCatManaBar\\perl")
	SML:Register("statusbar", "Charcoal", "Interface\\AddOns\\SmartyCatManaBar\\charcoal")
	SML:Register("statusbar", "Otravi", "Interface\\AddOns\\SmartyCatManaBar\\otravi")
	SML:Register("statusbar", "Smooth", "Interface\\AddOns\\SmartyCatManaBar\\smooth")
	SML:Register("statusbar", "Glaze", "Interface\\AddOns\\SmartyCatManaBar\\glaze")
	SML:Register("statusbar", "Granite", "Interface\\AddOns\\SmartyCatManaBar\\granite")
	
	self:RegisterDefaults("profile", {
		border = "Blizzard Tooltip",
		height = 10,
		width = 130,
		font = "Arial Narrow",
		fontsize = 11,
		texture = "Otravi",
		barcolor = { r = 0, g = 0, b = 1, a = 1 },
		bordercolor = { r = 0.5, g = 0.5, b = 0.5, a = 1 },
		backcolor = { r = 0, g = 0, b = 0, a = 0.5 },
		fontcolor = { r = 1, g = 1, b = 1 },
		hideInCaster = true,
		hideWhenFull = false,
		centerText = false,
		lStyle = "Absolute",
		rStyle = "Percentage",
		x = 0,
		y = 0,
		relativePoint = "CENTER",
	})
	
	self:RegisterChatCommand({"/SmartyCatManaBar", "/scmb"}, self:LoadOptions())
end

function SmartyCatManaBar:OnEnable()
	if not self.frame then
		self:SetupFrame()
		
		LibDruidMana = LibStub("LibDruidMana-1.0")
		if not LibDruidMana then
			error("SmartyCatManaBar requires LibDruidMana-1.0 to be available.")
		end
		
		LibDruidMana:AddListener(function(currMana, maxMana)
			if self:IsActive() then
				self:UpdateFrame(currMana, maxMana)
			end
		end)
	end
	
	self:RegisterEvent("UNIT_DISPLAYPOWER", "UpdateMana")
	self:RegisterEvent("SharedMedia_SetGlobal", "UpdateLook")
	
	self:OnProfileEnable()
end

function SmartyCatManaBar:OnDisable()
	self.frame:Hide()
end

function SmartyCatManaBar:OnProfileEnable()
	if self:IsActive() then
		self.frame:ClearAllPoints()
		self.frame:SetPoint(self.db.profile.relativePoint, UIParent, self.db.profile.relativePoint, self.db.profile.x, self.db.profile.y)
		self:UpdateLook()
		self:UpdateMana()
	end
end

local textStyles = {
	["Absolute"] = function(currMana, maxMana)
		return currMana .. "/" .. maxMana
	end,
	["Percentage"] = function(currMana, maxMana)
		return ("%.0f%%"):format(currMana / maxMana * 100)
	end,
	["Absolute and Percentage"] = function(currMana, maxMana)
		return ("%d/%d || %.0f%%"):format(currMana, maxMana, currMana / maxMana * 100)
	end,
	["Hide"] = function()
		return "" 
	end,
}

function SmartyCatManaBar:UpdateMana()
	self:UpdateFrame(LibDruidMana:GetCurrentMana(), LibDruidMana:GetMaximumMana())
end

function SmartyCatManaBar:UpdateFrame(currMana, maxMana)
	local f = self.frame 
	local db = self.db.profile
	if maxMana == 0 then
		currMana, maxMana = 100, 100
	end
	if (db.hideInCaster and UnitPowerType("player") == 0) or (currMana == maxMana and db.hideWhenFull) then
		f:Hide()
	else
		f:Show()
		f.lTextField:SetText(textStyles[db.lStyle](currMana, maxMana))
		f.rTextField:SetText(textStyles[db.rStyle](currMana, maxMana))
		f.bar:SetValue(currMana / maxMana)
	end
end

function SmartyCatManaBar:LoadOptions()
	if not options then
		options = {
			type = "group",
			args = {
				header = {
					type = "header",
					name = "SmartyCatManaBar",
					order = 1,
				},
				frame = {
					type = "group",
					name = L["Mana Bar"],
					desc = L["Set Mana Bar"],
					order = 2,
					disabled = "~IsActive",
					args = {
						height = {
							type = "range",
							name = L["Height"],
							desc = L["Set the bar height"],
							get = function() return self.db.profile.height end,
							set = function(v)
								self.db.profile.height = v
								self:UpdateLook()
							end,
							min = 1, max = 50, step = 1,
							order = 1,
						},
						width = {
							type = "range",
							name = L["Width"],
							desc = L["Set the bar width"],
							get = function() return self.db.profile.width end,
							set = function(v)
								self.db.profile.width = v
								self:UpdateLook()
							end,
							min = 80, max = 300, step = 2,
							order = 2,
						},
						border = {
							type = "text",
							name = L["Border"],
							desc = L["Set the border style"],
							get = function() return self.db.profile.border end,
							set = function(v) 
								self.db.profile.border = v
								self:UpdateLook() 
							end,
							validate = SML:List("border"),
							order = 3,
						},
						bartexture = {
							type = "text", 
							name = L["Bar Texture"],
							desc = L["Set the bar texture"],
							get = function() return self.db.profile.texture end,
							set = function(v) 
								self.db.profile.texture = v 
								self:UpdateLook()
							end,
							validate = SML:List("statusbar"),
							order = 4,
						},
						font = {
							type = "text",
							name = L["Font"],
							desc = L["Set the font"],
							get = function() return self.db.profile.font end,
							set = function(v) 
								self.db.profile.font = v
								self:UpdateLook()
							end,
							validate = SML:List("font"),
							order = 5,
						},
						fontsize = {
							type = "range",
							name = L["Font Size"],
							desc = L["Set the font size"],
							get = function() return self.db.profile.fontsize end,
							set = function(v)
								self.db.profile.fontsize = v
								self:UpdateLook()
							end,
							min = 6, max = 26, step = 1,
							order = 6,
						},
						textStyles = {
							type = "group",
							name = L["Text Styles"],
							desc = L["Set the text styles"],
							order = 7,
							args = {
								centerText = {
									type = "toggle", 
									name = L["Center Text"],
									desc = L["Center the text"],
									get = function() return self.db.profile.centerText end,
									set = function(v) 
										self.db.profile.centerText = v
										if v then
											self.db.profile.lStyle = "Hide"
											self.db.profile.rStyle = "Absolute and Percentage"
										else
											self.db.profile.lStyle = "Absolute"
											self.db.profile.rStyle = "Percentage"
										end 
										self:UpdateLook()
										self:UpdateMana()
									end,
									order = 1,
								},
								lText = {
									type = "text", 
									name = L["Left Text Style"],
									desc = L["Set the left text style"],
									get = function() return self.db.profile.lStyle end,
									set = function(v) 
										self.db.profile.lStyle = v 
										self:UpdateMana()
									end,
									validate = {"Absolute", "Percentage", "Absolute and Percentage", "Hide"},
									hidden = function() return self.db.profile.centerText end,
									order = 2,
								},
								rText = {
									type = "text", 
									name = L["Right Text Style"],
									desc = L["Set the right text style"],
									get = function() return self.db.profile.rStyle end,
									set = function(v) 
										self.db.profile.rStyle = v 
										self:UpdateMana()
									end,
									validate = {"Absolute", "Percentage", "Absolute and Percentage", "Hide"},
									hidden = function() return self.db.profile.centerText end,
									order = 3,
								},
								cText = {
									type = "text", 
									name = L["Center Text Style"],
									desc = L["Set the center text style"],
									get = function() return self.db.profile.rStyle end,
									set = function(v) 
										self.db.profile.rStyle = v 
										self:UpdateMana()
									end,
									validate = {"Absolute", "Percentage", "Absolute and Percentage", "Hide"},
									hidden = function() return not self.db.profile.centerText end,
									order = 4,
								},
							},
						},
						barcolor = {
							type = "color",
							name = L["Bar Color"],
							desc = L["Set the bar color"],
							get = function() return self.db.profile.barcolor.r, self.db.profile.barcolor.g, self.db.profile.barcolor.b, self.db.profile.barcolor.a end,
							set = function(r,g,b,a) 
								self.db.profile.barcolor = {r=r, g=g, b=b, a=a}
								self.frame.bar:SetStatusBarColor(r, g, b, a) 
							end,
							hasAlpha = true,
							order = 20,
						},
						bordercolor = {
							type = "color",
							name = L["Border Color"],
							desc = L["Set the border color"],
							get = function() return self.db.profile.bordercolor.r, self.db.profile.bordercolor.g, self.db.profile.bordercolor.b, self.db.profile.bordercolor.a end,
							set = function(r,g,b,a)
								self.db.profile.bordercolor = {r=r, g=g, b=b, a=a}
								self.frame:SetBackdropBorderColor(r, g, b, a)
							end,
							hasAlpha = true,
							order = 21,
						},
						backcolor = {
							type = "color",
							name = L["Background Color"], 
							desc = L["Set the background color"],
							get = function() return self.db.profile.backcolor.r, self.db.profile.backcolor.g, self.db.profile.backcolor.b, self.db.profile.backcolor.a end,
							set = function(r,g,b,a)
								self.db.profile.backcolor = {r=r, g=g, b=b, a=a}
								self.frame:SetBackdropColor(r, g, b, a)
							end,
							hasAlpha = true,
							order = 22,
						},
						fontcolor = {
							type = "color",
							name = L["Font Color"], 
							desc = L["Set the font color"],
							get = function() return self.db.profile.fontcolor.r, self.db.profile.fontcolor.g, self.db.profile.fontcolor.b end,
							set = function(r,g,b)
								self.db.profile.fontcolor = {r=r, g=g, b=b}
								self.frame.lTextField:SetTextColor(r, g, b)
								self.frame.rTextField:SetTextColor(r, g, b)
							end,
							order = 23,
						},
					},
				},
				hideInCaster = {
					type = "toggle",
					name = L["Hide in Caster Form"], 
					desc = L["Hides the mana bar when not in Cat or Bear form"],
					get = function() return self.db.profile.hideInCaster end,
					set = function(v)
						self.db.profile.hideInCaster = v
						self:UpdateMana()
					end,
					order = 3,
					disabled = "~IsActive",
				},
				hideWhenFull = {
					type = "toggle",
					name = L["Hide at Full Mana"], 
					desc = L["Hides the mana bar when mana is full"],
					get = function() return self.db.profile.hideWhenFull end,
					set = function(v)
						self.db.profile.hideWhenFull = v
						self:UpdateMana()
					end,
					order = 4,
					disabled = "~IsActive",
				},
			},
		}
	end
	
	return options
end

function SmartyCatManaBar:SetupFrame()
	local f = CreateFrame("Frame", "SCMBFrame", UIParent)
	
	f:SetClampedToScreen(true)
	
	f:SetMovable(true)
	f:EnableMouse(true)
	f:RegisterForDrag("LeftButton")
	f:SetScript("OnDragStart", function() if IsShiftKeyDown() then this:StartMoving() end end)
	f:SetScript("OnDragStop", function() 
		this:StopMovingOrSizing() 
		local _, _, relativePoint, xOfs, yOfs = this:GetPoint()
		self.db.profile.relativePoint = relativePoint
		self.db.profile.x = floor(xOfs + 0.5)
		self.db.profile.y = floor(yOfs + 0.5)
	end)
	
	f.bar = CreateFrame("StatusBar", nil, f)
	f.bar:SetMinMaxValues(0, 1)
	f.lTextField = f.bar:CreateFontString(nil, "OVERLAY")
	f.rTextField = f.bar:CreateFontString(nil, "OVERLAY")
	f.bar:ClearAllPoints()
	f.bar:SetPoint("TOPLEFT", 4, -4)
	f.bar:SetPoint("BOTTOMRIGHT", -4, 4)
	
	dewdrop:Register(f, 'children', function() dewdrop:FeedAceOptionsTable(self:LoadOptions()) end, 'cursorX', true, 'cursorY', true)
	
	self.frame = f
end

function SmartyCatManaBar:UpdateLook()
	local db = self.db.profile
	local font = SML:Fetch("font", db.font)
	local f = self.frame
	local inset = 4
	
	f:SetWidth(db.width+10)
	f:SetHeight(db.height+10)
	f:SetBackdrop({ 
		bgFile = SML:Fetch("statusbar", db.texture),
		edgeFile = SML:Fetch("border", db.border),
		edgeSize = 12,
		insets = {left = inset, right = inset, top = inset, bottom = inset},
	})
	f:SetBackdropColor(db.backcolor.r, db.backcolor.g, db.backcolor.b, db.backcolor.a)
	f:SetBackdropBorderColor(db.bordercolor.r, db.bordercolor.g, db.bordercolor.b, db.bordercolor.a) 
	
	f.bar:SetStatusBarTexture(SML:Fetch("statusbar", db.texture))
	f.bar:SetStatusBarColor(db.barcolor.r, db.barcolor.g, db.barcolor.b, db.barcolor.a)
	
	f.lTextField:SetFont(font, db.fontsize)
	f.lTextField:ClearAllPoints()
	f.lTextField:SetShadowColor(0.1, 0.1, 0.1)
	f.lTextField:SetShadowOffset(1,-1)
	f.lTextField:SetTextColor(db.fontcolor.r, db.fontcolor.g, db.fontcolor.b)
	f.lTextField:SetWidth(f:GetWidth()*0.7)
	f.lTextField:SetJustifyH("LEFT")
	f.lTextField:SetPoint("LEFT", f, "LEFT", 6, 0)
	
	f.rTextField:SetFont(font, db.fontsize)
	f.rTextField:ClearAllPoints()
	f.rTextField:SetShadowColor(0.1, 0.1, 0.1)
	f.rTextField:SetShadowOffset(1,-1)
	f.rTextField:SetTextColor(db.fontcolor.r, db.fontcolor.g, db.fontcolor.b)
	f.rTextField:SetWidth(f:GetWidth())
	if db.centerText then
		f.rTextField:SetJustifyH("CENTER")
		f.rTextField:SetPoint("CENTER", f, "CENTER")
	else
		f.rTextField:SetJustifyH("RIGHT")
		f.rTextField:SetPoint("RIGHT", f, "RIGHT", -6, 0)
	end
end