if select(2, UnitClass("player")) ~= "DRUID" then
	return
end

SmartyCat = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0")

local Gratuity

local maxMana, currMana, currInt, fsr, bearID, bearName, catName

function SmartyCat:OnEnable()
	Gratuity = AceLibrary("Gratuity-2.0")
	
	if UnitPowerType("player") == 0 then
		self:Enable()
	else
		self:RegisterEvent("UNIT_DISPLAYPOWER", "WaitForShapeshift")
	end
end

function SmartyCat:WaitForShapeshift(arg1)
	if arg1 ~= "player" then 
		return
	end
	
	if UnitPowerType("player") == 0 then
		self:UnregisterEvent("UNIT_DISPLAYPOWER")
		self:Enable()
	end
end

function SmartyCat:Enable()
	maxMana = UnitManaMax("player")
	currMana = UnitMana("player")
	_, currInt  = UnitStat("player", 4)
	self:LEARNED_SPELL_IN_TAB()
	
	self:RegisterEvent("UNIT_MANA")
	self:RegisterEvent("UNIT_MAXMANA")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:RegisterEvent("PLAYER_AURAS_CHANGED")
	self:RegisterEvent("LEARNED_SPELL_IN_TAB")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PLAYER_LEAVING_WORLD")
	
	self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
end

function SmartyCat:PLAYER_ENTERING_WORLD()
	if UnitPowerType("player") ~= 0 then
		self:ScheduleEvent("SC_MaxMana", self.SetMax, 7, self)
	end
end

function SmartyCat:PLAYER_LEAVING_WORLD()
	self:CancelAllScheduledEvents()
end

--Update players max mana
function SmartyCat:UNIT_MAXMANA(arg1)
	if arg1 ~= "player" then 
		return
	end
	
	local _, int  = UnitStat("player", 4)
	if UnitPowerType("player") == 0 then
		maxMana = UnitManaMax("player")
		currMana = UnitMana("player")
		currInt = int
	elseif currInt ~= int then
		maxMana = maxMana + ((int - currInt) * 15)
		currInt = int
		if currMana > maxMana then
			currMana = maxMana
		end
	end
	
	self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
end

local regenMana		--Dont count the first call to UNIT_MANA after shapeshifting

function SmartyCat:UNIT_MANA(arg1)
	if arg1 ~= "player" then
		return
	end
	
	if UnitPowerType("player") == 0 then
		currMana = UnitMana("player")
		maxMana = UnitManaMax("player")
		self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
	else
		if not self:IsEventScheduled("SC_Event") and regenMana then
			--Update mana every 2 seconds
			self:UpdateMana()
			self:ScheduleRepeatingEvent("SC_Event", self.UpdateMana, 2, self)
		end
		--if mana hasnt been updated for 7 seconds, set current mana to max mana
		self:ScheduleEvent("SC_MaxMana", self.SetMax, 7, self)
	end
end

local function getShapeshiftCost()
	Gratuity:SetSpell(bearID, BOOKTYPE_SPELL)
	local line = Gratuity:GetLine(2)
	if line then
		line = tonumber(line:match("(%d+)"))
	end
	return line or 0
end

local function killFSR()
	fsr = false
end

function SmartyCat:UNIT_SPELLCAST_SUCCEEDED(arg1, arg2)
	if arg1 ~= "player" then
		return
	end
	
	if (bearName and arg2 == bearName) or (catName and arg2 == catName) then
		regenMana = true
		--Five second rule
		fsr = true
		self:ScheduleEvent("FSR", killFSR, 5)
		--subtract the mana cost of shapeshifting
		currMana = currMana - getShapeshiftCost()
		
		self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
	end
end

function SmartyCat:PLAYER_AURAS_CHANGED()
	if UnitPowerType("player") == 0 then
		regenMana = false
		self:CancelAllScheduledEvents()
		currMana = UnitMana("player")
		maxMana = UnitManaMax("player")
		
		self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
	end
end

--finds the spell ID and localized names of Bear Form and Cat Form
function SmartyCat:LEARNED_SPELL_IN_TAB()
    for i = 1, GetNumSpellTabs() do
        local _, texture, offset, numSpells = GetSpellTabInfo(i)
        if string.find(texture, "Ability_Racial_BearForm") then
        	for j = offset + 1, offset + numSpells do
        		if string.find(GetSpellTexture(j, BOOKTYPE_SPELL), "Ability_Racial_BearForm") then
        			bearID = j
					bearName = GetSpellName(j, BOOKTYPE_SPELL)
				elseif string.find(GetSpellTexture(j, BOOKTYPE_SPELL), "Ability_Druid_CatForm") then
					catName = GetSpellName(j, BOOKTYPE_SPELL)
        		end
        	end
			break
        end
    end
end

function SmartyCat:UpdateMana()
	local regen, castingRegen = GetManaRegen()
	if fsr then
		--Five second rule mana regen
		currMana=currMana+floor(castingRegen*2+.5)
	else
		--Normal mana regen
		currMana=currMana+floor(regen*2+.5)
	end
	
	if currMana>=maxMana then
		currMana=maxMana
		self:CancelAllScheduledEvents()
	end
	
	self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
end

function SmartyCat:SetMax()
	currMana=maxMana
	self:CancelAllScheduledEvents()
	self:TriggerEvent("SmartyCat_ManaUpdated", currMana, maxMana)
end

function SmartyCat:GetManaPercent()
	if currMana then
		return floor((currMana / maxMana) * 100)
	else
		return 100
	end
end

function SmartyCat:GetManaValue()
	if currMana then
		return currMana / maxMana
	else
		return 1
	end
end

function SmartyCat:GetMaxMana()
	if maxMana then
		return maxMana
	else
		return 100
	end
end

function SmartyCat:GetCurrMana()
	if currMana then
		return currMana
	else
		return 100
	end
end