local L =  AceLibrary("AceLocale-2.2"):new("SmartRes")
local DD = AceLibrary("Dewdrop-2.0")
local SM = AceLibrary("SharedMedia-1.0")
local P =  AceLibrary("PaintChips-2.0")
local SmartRes = SmartRes

-- Returns table of available colors
local function RegisterColorsAndTextures()
	P:RegisterColor("gray", 0.5, 0.5, 0.5)
	P:RegisterColor("forest", 0.0, 0.5, 0.0)
	P:RegisterColor("maroon", 0.5, 0.0, 0.0)
	P:RegisterColor("navy", 0.0, 0.0, 0.5)
	P:RegisterColor("olive", 0.5, 0.5, 0.0)
	P:RegisterColor("purple", 0.5, 0.0, 0.5)
	P:RegisterColor("teal", 0.0, 0.5, 0.5)

	-- Additional textures
	SM:Register("statusbar", "BantoBar", "Interface\\Addons\\SmartRes\\Textures\\banto")
	SM:Register("statusbar", "Smooth", "Interface\\Addons\\SmartRes\\Textures\\smooth")
	SM:Register("statusbar", "Perl", "Interface\\Addons\\SmartRes\\Textures\\perl")
	SM:Register("statusbar", "Glaze", "Interface\\Addons\\SmartRes\\Textures\\glaze")
	SM:Register("statusbar", "Cilo", "Interface\\Addons\\SmartRes\\Textures\\cilo")
	SM:Register("statusbar", "Charcoal", "Interface\\Addons\\SmartRes\\Textures\\Charcoal")

	return {"white", "black", "blue", "magenta", "cyan", "green", "yellow",
		"orange", "red", "gray", "forest", "maroon", "navy", "olive",
		"purple", "teal"}
end

local function RegisterDefaults(self)
	local defaults = {
		autokey = "-",
		normalkey = ".",
		disablecombat = false,
		notify = true,
		whisper = false,
		resmessage = L["Resurrecting %s"],
		chattype = nil,
		customchannel = nil,
		customchannelname = nil,
		enable = true,
		bartex = "Smooth",
		barcolor = "green",
		collisionbarcolor = "red",
		bgcolor = "teal",
		textcolor = "white",
		textsize = 11,
		barscale = 1,
		barwidth = 280,
		barheight = 15,
		growup = false,
		reverse = true,
		shorttext = false,
		classcolors = true,
		barposition = {},
	}
	self:RegisterDefaults("profile", defaults)
end

local function RegisterMenu(self, colors)
	local anchor = false
	local profile = self.db.profile
	local options = {
		name = L["SmartRes"],
		desc = L["SmartRes"],
		type = "group",
		disabled = function()
			if InCombatLockdown() then
				return true
			end
		end,
		args = {}
	}

	options.args.anchor = {
		name = L["Anchor"],
		desc = L["Show a dragable anchor."],
		order = 20,
		type = "toggle",
		get = function () return anchor end,
		set = function (v)
			anchor = v
			self:SetAnchor(v)
		end
	}

	-- Bar options inspired by MendWatch
	options.args.bar = { 
		name = L["Resurrection Bars"],
		desc = L["Options for resurrection statusbar."],
		order = 21,
		type = "group",
		args = {
			texture = {
				name = L["Bar Texture"],
				desc = L["Change the texture of the timer bars."],
				type = "text",
				get = function () return profile.bartex end,
				set = function (v) profile.bartex = v end,
				validate = SM:List("statusbar"),
			},
			barcolor = {
				name = L["Bar Color"],
				desc = L["Set the bar color for resurrects."],
				type = "text",
				get = function () return profile.securebarcolor end,
				set = function (v) profile.securecolor = v end,
				validate = colors,
			},
			collisionbarcolor = {
				name = L["Collision Bar Color"],
				desc = L["Set the bar color for colliding resurrects."],
				type = "text",
				get = function () return profile.collisionbarcolor end,
				set = function (v) profile.collisionbarcolor = v end,
				validate = colors,
			},
			bgcolor = {
				name = L["Background Color"],
				desc = L["Set the bar background color."],
				type = "text",
				get = function () return profile.bgcolor end,
				set = function (v) profile.bgcolor = v end,
				validate = colors,
			},
			textcolor = {
				name = L["Text Color"],
				desc = L["Set the bar text color."],
				type = "text",
				get = function () return profile.textcolor end,
				set = function (v) profile.textcolor = v end,
				validate = colors,
			},
			textsize = {
				name = L["Text Size"],
				desc = L["Set the bar text size."],
				type = "range",
				get = function () return profile.textsize end,
				set = function (v) profile.textsize = v end,
				min = 8,
				max = 20,
			},
			scale = {
				name = L["Bar Scale"],
				desc = L["Set the bar scale."],
				type = "range",
				get = function () return profile.barscale end,
				set = function (v) profile.barscale = v end,
				min = 0.5,
				max = 1.5,
			},
			height = {
				name = L["Bar Height"],
				desc = L["Set the bar height."],
				type = "range",
				get = function () return profile.barheight end,
				set = function (v) profile.barheight = v end,
				min = 8,
				max = 30,
			},
			width = {
				name = L["Bar Width"],
				desc = L["Set the bar width."],
				type = "range",
				get = function () return profile.barwidth end,
				set = function (v) profile.barwidth = v end,
				min = 50,
				max = 300,
			},
			growth = {
				name = L["Bar Growth"],
				desc = L["Toggle the bar growing upwards or downwards."],
				type = "toggle",
				get = function () return profile.growup end,
				set = function (v) profile.growup = v
					if v then
						self:SetCandyBarGroupPoint("SmartRes", "BOTTOM", self.Anchor, "TOP", 0, 0)	
					else
						self:SetCandyBarGroupPoint("SmartRes", "TOP", self.Anchor, "BOTTOM", 0, 0)	
					end
					self:SetCandyBarGroupGrowth("SmartRes", profile.growup)
				end,
			},
			reverse = {
				name = L["Reverse"],
				desc = L["Toggle the bar fill direction."],
				type = "toggle",
				get = function() return profile.reverse end,
				set = function(f) profile.reverse = f end,
			},
			text = {
				name = L["Short Bar Text"],
				desc = L["Enable short text for bars."],
				type = "toggle",
				get = function () return profile.shorttext end,
				set = function (v) profile.shorttext = v end,
			},
			classcolors = {
				name = L["Use class colors"],
				desc = L["Enable coloring of player names according to class."],
				type = "toggle",
				get = function () return profile.classcolors end,
				set = function (v) profile.classcolors = v end,
			},
			enable = {
				name = L["Enable Bars"],
				desc = L["Enable timer bars."],
				order = -2,
				type = "toggle",
				get = function () return profile.enable end,
				set = function (v) profile.enable = v end,
			},
			test = {
				name = L["Start Test Bars"],
				desc = L["Start a few test bars."],
				order = -1,
				type = "execute",
				func = function()
					local text
					if  profile.shorttext then
						text = L["%s: %s"]
					else
						text = L["%s is resurrecting %s"]
					end
					self:CreateBar("Resser4", "Dead1", 25, true, true)
					self:CreateBar("Resser3", "Dead1", 20, false, true)
					self:CreateBar("Resser2", "Dead2", 15, true, true)
					self:CreateBar("Resser1", "Dead1", 10, false, true)
				end,
			}
		}
	}

	options.args.broadcast = {
		name = L["Broadcast"],
		desc = L["Broadcast resurrections to different chats."],
		order = 40,
		type = "group",
		args = {
			notify = {
				name = L["Notify Yourself"],
				desc = L["Show notifications for your resurrects."],
				order = 1,
				type = "toggle",
				get = function () return profile.notify end,
				set = function (v) profile.notify = v end
			},
			whisper = {
				name = L["Whisper Target"],
				desc = L["Whisper your target when resurrecting."],
				order = 2,
				type = "toggle",
				get = function () return profile.whisper end,
				set = function (v) profile.whisper = v end
			},
			chattype = {
				name = L["Chat Type"],
				desc = L["Set the chat to output to."],
				type = "text",
				order = 3,
				validate = {"SAY", "YELL", "PARTY", "RAID", "GUILD", "OFFICER", "OFF"},
				get = function()
					if not profile.chattype then
						return "OFF"
					else
						return profile.chattype
					end
				end,
				set = function(text)
					if text == "OFF" then
						profile.chattype = nil
					else
						profile.chattype = text
					end
				end
			},
			customchannel = {
				name = L["Custom Channel"],
				desc = L["Send the Resurrection Message to a custom chat channel."],
				type = "text",
				order = 4,
				validate = {["1"] = "Channel 1", ["2"] = "Channel 2", ["3"] = "Channel 3",
					    ["4"] = "Channel 4", ["5"] = "Channel 5", ["6"] = "Channel 6",
					    ["7"] = "Channel 7", ["8"] = "Channel 8", ["9"] = "Channel 9",
					    ["10"] = "Channel 10", ["OFF"] = "OFF"},
				validateDesc = setmetatable({}, {__index =
					function(table, key)
						return "[" .. key .. ". " .. (select(2, GetChannelName(key)) or "(invalid)") .. "]"
					end
				}),
				get = function()
					if not profile.customchannel then
						return "OFF"
					else
						return "" .. profile.customchannel
					end
				end,
				set = function(num)
					if num == "OFF" then
						profile.customchannel = nil
						profile.customchannelname = nil
						return
					end
					local id, channelname = GetChannelName(num)
					if id == 0 then
						self:Print("[" .. num .. "] is not a valid chat channel")
					else
						profile.customchannel = id
						profile.customchannelname = channelname
					end
				end
			},
			resmessage = {
				name = L["Resurrection Message"],
				type = "text",
				order = 5,
				desc = L["Change the Resurrection Message."],
				get = function()
					return string.format(profile.resmessage, "%s")
				end,
				set = function(text)
					profile.resmessage = text
				end,
				validate = function(text)
					return select(1, pcall(function() string.format(text, "%s") end) and text:find("%%s"))
				end,
				usage = L["<msg> (Example: Resurrecting: %s) **Be sure to include %s where you want the target's name to be**"]
			}
		}
	}

	options.args.autokey = {
		name = L["Auto Res Key"],
		desc = L["Key Binding for automated resurrection."],
		order = 50,
		type = "text",
		validate = "keybinding",
		set = function(value)
			self:UnbindKeys()
			profile.autokey = value
			self:BindKeys()
		end,
		get = function() return profile.autokey end
	}

	options.args.normalkey = {
		name = L["Normal Res Key"],
		desc = L["Key Binding for normal resurrection. Used to target people who have released when dead."],
		order = 51,
		type = "text",
		validate = "keybinding",
		set = function(value)
			self:UnbindKeys()
			profile.normalkey = value
			self:BindKeys()
		end,
		get = function() return profile.normalkey end
	}

	options.args.config = {
		name = L["Config"],
		desc = L["Show the GUI configuration menu."],
		type = "execute",
		guiHidden = true,
		func = function() DD:Open(UIParent, "children", function() DD:FeedAceOptionsTable(options) end, "cursorX", true, "cursorY", true) end,
	}

	-- Chat commands
	self:RegisterChatCommand({"/sr", "/smartres"}, options)

	-- FuBar
	self.OnMenuRequest = options
end

-- CreateAnchor taken from MendWatch
function SmartRes:CreateAnchor(text, cRed, cGreen, cBlue)
	local f = CreateFrame("Button", nil, UIParent)
	f:SetWidth(200)
	f:SetHeight(25)

	f.owner = self

	if self.db.profile.barposition.x and self.db.profile.barposition.y and self.db.profile.barposition.anchor and self.db.profile.barposition.point then
		f:ClearAllPoints()
		f:SetPoint(self.db.profile.barposition.point, UIParent, self.db.profile.barposition.anchor, self.db.profile.barposition.x, self.db.profile.barposition.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER", 0, 50)
	end

	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
		function()
			this:StopMovingOrSizing()
			local point, _, anchor, x, y = this:GetPoint()
			this.owner.db.profile.barposition.x = math.floor(x)
			this.owner.db.profile.barposition.y = math.floor(y)
			this.owner.db.profile.barposition.anchor = anchor
			this.owner.db.profile.barposition.point = point
		end)

	f:SetBackdrop({
		--bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = false, tileSize = 16, edgeSize = 16,
		insets = {left = 5, right = 5, top = 5, bottom = 5}
	})
	f:SetBackdropColor(cRed, cGreen, cBlue, .6)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")

	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFontObject(GameFontNormalSmall)
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(1, 1, 1, 1)
	f.Text:SetWidth(200)
	f.Text:SetHeight(25)
	f.Text:SetPoint("TOPLEFT", f, "TOPLEFT")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	f.Text:SetText(text)

	f:Hide()

	return f
end

function SmartRes:SetAnchor(v)
	local anchor = self.Anchor
	if v then
		anchor:Show()
	else
		anchor:Hide()
	end
end

function SmartRes:InitializeOptions()
	local colors = RegisterColorsAndTextures()

	self:RegisterDB("SmartResDB")
	RegisterDefaults(self)

	RegisterMenu(self, colors)

	self.Anchor = self:CreateAnchor(L["SmartRes"], 0, 0, 0)

	local profile = self.db.profile
	self:RegisterCandyBarGroup("SmartRes")
	if profile.growup then
		self:SetCandyBarGroupPoint("SmartRes", "BOTTOM", self.Anchor, "TOP", 0, 0)	
	else
		self:SetCandyBarGroupPoint("SmartRes", "TOP", self.Anchor, "BOTTOM", 0, 0)	
	end
	self:SetCandyBarGroupGrowth("SmartRes", profile.growup)
end