
--		spell (EN),		is mount/speedindex,	fly-speed,		in:combat		in:air			outlandonly		icon
--										ground-speed,	water-speed,	in:water		on:ground		can indoor

SmartMount.InitSpells = {
		{'Ghost Wolf',			2,		140,	false,	66,		true,	true,	false,	true,	false,	false,	'Interface\\Icons\\Spell_Nature_SpiritWolf'},
		{'Summon Warhorse',		3,		160,	false,	false,	false,	false,	false,	true,	false,	false,	'Interface\\Icons\\Spell_Nature_Swiftness'},
		{'Summon Charger',		4,		200,	false,	false,	false,	false,	false,	true,	false,	false,	'Interface\\Icons\\Ability_Mount_Charger'}, 
		{'Summon Felsteed',		3,		160,	false,	false,	false,	false,	false,	true,	false,	false,	'Interface\\Icons\\Spell_Nature_Swiftness'},
		{'Summon Dreadsteed',	4,		200,	false,	false,	false,	false,	false,	true,	false,	false,	'Interface\\Icons\\Ability_Mount_Dreadsteed'},
		{'Levitate',			false,	100,	100,	100,	false,	true,	true,	true,	false,	false,	'Interface\\Icons\\Spell_Holy_LayOnHands'},
		{'Slow Fall',			false,	100,	100,	false,	false,	false,	true,	true,	false,	false,	'Interface\\Icons\\Spell_Magic_FeatherFall'},
	}

SmartMount.InitShapeshifts = {
		{'Bear Form',			false,	100,	false,	66,		true,	true,	false,	true,	false,	true,	'Interface\\Icons\\Ability_Racial_BearForm'},
		{'Dire Bear Form',		false,	100,	false,	66,		true,	true,	false,	true,	false,	true,	'Interface\\Icons\\Ability_Racial_BearForm'},
		{'Aquatic Form',		false,	false,	false,	100,	true,	true,	false,	false,	false,	false,	'Interface\\Icons\\Ability_Druid_AquaticForm'},
		{'Cat Form',			false,	100,	false,	66,		true,	true,	false,	true,	false,	true,	'Interface\\Icons\\Ability_Druid_CatForm'},
		{'Travel Form',			2,		140,	false,	false,	true,	false,	false,	true,	false,	false,	'Interface\\Icons\\Ability_Druid_TravelForm'},
		{'Moonkin Form',		false,	100,	false,	66,		true,	true,	false,	true,	false,	true,	'Interface\\Icons\\Spell_Nature_ForceOfNature'},
		{'Tree of Life',		false,	100,	false,	66,		true,	true,	false,	true,	false,	true,	'Interface\\Icons\\Ability_Druid_TreeofLife'},
		{'Flight Form',			5,		false,	160,	false,	false,	false,	true,	true,	true,	false,	'Interface\\Icons\\Ability_Druid_FlightForm'},
		{'Swift Flight Form',	6,		false,	380,	false,	false,	false,	true,	true,	true,	false,	'Interface\\Icons\\Ability_Druid_FlightForm'},
	}

function SmartMount:InitClick()
	self.SpecialSpells = {}

	-- check for spells...
	for _, spell in pairs(self.InitSpells) do
		local locspell = self.SpellLocale[spell[1]]
		
		self.SpecialSpells['spell:' .. spell[1]] = {
			type = 'spell',
			spell = locspell,
			name = locspell,
			can = GetSpellTexture(locspell),
			mount = spell[2],
			land = spell[3],
			fly = spell[4],
			swim = spell[5],
			incombat = spell[6],
			inwater = spell[7],
			inair = spell[8],
			onground = spell[9],
			outlandonly = spell[10],
			inhouse = spell[11],
			icon = spell[12],
		}
	end -- for
	
	-- check for shapeshift forms
	for _, spell in pairs(self.InitShapeshifts) do
		local locspell = self.SpellLocale[spell[1]]

		local can = false
		for i=1, GetNumShapeshiftForms() do
			local _,name, _ = GetShapeshiftFormInfo(i)
			if name == locspell then
				can = true
			end -- if
		end -- for
		self.SpecialSpells['spell:' .. spell[1]] = {
			type = 'spell',
			spell = locspell,
			name = locspell,
			can = can,
			mount = spell[2],
			land = spell[3],
			fly = spell[4],
			swim = spell[5],
			incombat = spell[6],
			inwater = spell[7],
			inair = spell[8],
			onground = spell[9],
			outlandonly = spell[10],
			inhouse = spell[11],
			icon = spell[12],
		}
	end -- for
	
	-- special enties
	self.SpecialSpells['special:instantform'] = {
		type = 'special',
		name = self.rock and self.L['Travel, Flight or Swift Flight Form'],
		can = self.SpecialSpells['spell:Travel Form'].can,
		mount = 2,
		land = 140,
		fly = false,
		swim = false,
		incombat = false,
		inwater = false,
		inair = false,
		onground = true,
		outlandonly = false,
		inhouse = false,
		icon = 'Interface\\Icons\\Ability_Hunter_Pathfinding',
	}
	
	-- 'join' flight form
	if self.SpecialSpells['spell:Swift Flight Form'].can then
		-- just say, that the Flight Form has speed 6, and another spell...
		self.SpecialSpells['spell:Flight Form'].spell = self.SpecialSpells['spell:Swift Flight Form'].spell
		self.SpecialSpells['spell:Flight Form'].mount = self.SpecialSpells['spell:Swift Flight Form'].mount
		self.SpecialSpells['spell:Flight Form'].fly = self.SpecialSpells['spell:Swift Flight Form'].fly
		self.SpecialSpells['spell:Flight Form'].can = true
	end
	self.SpecialSpells['spell:Flight Form'].name = self.rock and self.L['Flight / Swift Flight Form']
	self.SpecialSpells['spell:Swift Flight Form'] = nil
	
	-- 'join' bear form
	if self.SpecialSpells['spell:Dire Bear Form'].can then
		-- just say, that the Flight Form has speed 6, and another spell...
		self.SpecialSpells['spell:Bear Form'].spell = self.SpecialSpells['spell:Dire Bear Form'].spell
		self.SpecialSpells['spell:Bear Form'].can = true
	end
	self.SpecialSpells['spell:Bear Form'].name = self.rock and self.L['Bear / Dire Bear Form']
	self.SpecialSpells['spell:Dire Bear Form'] = nil

	-- Hook of the Master Angler
	self.SpecialSpells['special:Hook of the Master Angler'] = {
		type = 'item',
		item = 'item:19979:0:0:0:0:0:0:',
		name = self.SpellLocale['Hook of the Master Angler'],
		spell = self.SpellLocale['Hook of the Master Angler'],
		can = self:WearItem('item:19979:'),
		mount = false,
		land = false,
		fly = false,
		swim = 100,
		incombat = false,
		inwater = true,
		inair = false,
		onground = false,
		outlandonly = false,
		inhouse = false,
		icon = [[Interface\Icons\Trade_Fishing]],
	}
	
	if self.rock then
		-- update the ListOfMountsCache (profile)
		-- and generate the self.ListOfMounts

		local mountspeed = { [1]={100, false}, [2]={140,false}, [3]={160,false}, [4]={200,false}, [5]={160,160}, [6]={200,380}, [7]={200,410} }

		self.ListOfMounts = {}
	
		-- count the mounts I have	
		local mounts = self:CountMounts(true)
		for i=1, 6 do
			for _, v in pairs(mounts[i]) do
				local itemName, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(v.item)
				-- update cache
				self:GetPref('ListOfMountsCache')[v.item] = i..':'..itemName
				-- set list
				self.ListOfMounts[v.item] = {
					action = v.item,
					name = itemName,
					spell = itemName,
					can = true,
					mount = i,
					land = mountspeed[i][1],
					fly = mountspeed[i][2],
					swim = false,
					incombat = false,
					inwater = false,
					inair = false,
					onground = true,
					outlandonly = mountspeed[i][2],
					inhouse = false,
					icon = itemTexture,
				}
			end -- for
		end -- for
	
		for k,v in pairs(self:GetPref('ListOfMountsCache')) do
			local found, _, speed, name = string.find(v, '(%d+):(.*)')
			if not found then
				self:GetPref('ListOfMountsCache')[k] = nil
			elseif self.ListOfMounts[k] == nil then
				self.ListOfMounts[k] = {
					action = k,
					name = name,
					spell = name,
					can = false,
					land = mountspeed[tonumber(speed)][1],
					fly = mountspeed[tonumber(speed)][2],
					swim = false,
					incombat = false,
					inwater = false,
					inair = false,
					onground = true,
					outlandonly = mountspeed[tonumber(speed)][2],
					inhouse = false,
					icon = nil,
				}
				-- we can set icon/spell to nil, because of 'can=false'
			end -- if
		end -- for
	
		for k, v in pairs(self.SpecialSpells) do
			v['action'] = k
			self.ListOfMounts[k] = v
		end -- for
		
		for k,v in pairs(self.ListOfMounts) do
			if not v['can'] then
				if string.sub(k, 1, 5) == 'item:' then
					v['icon'] = 'Interface\\AddOns\\SmartMount\\Icons\\Mount_Item'
				elseif k == 'special:Hook of the Master Angler' then
					v['icon'] = 'Interface\\AddOns\\SmartMount\\Icons\\Special_Hook'
				elseif (v.land and v.land > 100) or (v.fly and v.fly > 100) then
					v['icon'] = 'Interface\\AddOns\\SmartMount\\Icons\\Mount_Spell'
				else
					v['icon'] = 'Interface\\AddOns\\SmartMount\\Icons\\Spell'
				end -- if
			end -- if
		end -- do
	end
	
	self:PostClick('LeftButton')
	self:PostClick('RightButton')
	self:PostClick('MiddleButton')
end

function SmartMount:HijackBindings(showmessage)
    self:dump('hijack');
	
	if showmessage then
		DEFAULT_CHAT_FRAME:AddMessage('|cff3fcf26SmartMount|r: Please press the key again to use SmartMount.')
	end -- if

	-- normal bindings
	ClearOverrideBindings(SmartMount_Button)
	
	local key1, key2 = GetBindingKey('SMARTMOUNT_MOUNTORCONFIG')
	if key1 then
		SetOverrideBindingClick(SmartMount_Button, true, key1, 'SmartMount_Button')
	end --if
	if key2 then
		SetOverrideBindingClick(SmartMount_Button, true, key2, 'SmartMount_Button')
	end --if
end

function SmartMount:PreClick(btn)
	local config

	if btn == 'MiddleButton' then
		config = 3
	elseif btn == 'RightButton' then
		config = 2
	else -- if btn == 'LeftButton' then
		config = 1
	end -- if

	local mounted = nil
	
	if IsMounted() then
		mounted = 'regular';
	end -- if
	
	for _, spell in pairs(self.SpecialSpells) do
		if spell['mount'] and GetPlayerBuffName(spell['spell']) then
			mounted = spell['spell']
		end -- if
	end -- for

	local name, mode
	if InCombatLockdown() then
		name = 'combat'
	elseif IsSwimming() then
		name = 'swim'
	elseif IsFlying() or IsFalling() then
		name = 'fly'
	else
		name = 'land'
	end -- if
	
    self:dump('preclick', {cfg = config, name = name, mounted = mounted})

	if mounted then
		mode = 'dis'
		
		if not self:GetPref('c'..config..'-'..name..'-dis-do') then
			-- cancel here, cause we would'nt dismount
			if name ~= 'combat' then
				-- if in combat: don't change button; otherwise: don't do anything
				self:SetAttributes(config, {})
			end -- if
			return
		end
	
		if name == 'fly' and self:GetPref('c'..config..'-'..name..'-dis-do-groundonly') and IsFlying() then
			-- cancel here, cause we would'nt dismount
			self:SetAttributes(config, {})
			return
		end
	
	    if mounted == 'regular' then
			Dismount()
		else
			CancelPlayerBuff(mounted)
		end -- if
	else
		mode = 'mnt'
	end -- if
	
	self:dump('preclick-mode:', mode)
	
	if name == 'combat' then
		-- cancel here, cause we can't do anything
		return
	end -- if
		
	local chgbutton = self:GetMount('c'..config..'-'..name..'-'..mode..'-try', name) or {}
	-- or => if nothing found: nothing

	self:dump('preclick-button', chgbutton)
	
	self:SetAttributes(config, chgbutton)
end

function SmartMount:PostClick(btn)
	if btn == 'MiddleButton' then
		config = 3
	elseif btn == 'RightButton' then
		config = 2
	else -- if btn == 'LeftButton' then
		config = 1
	end -- if
    self:dump('postclick', config)

	if not InCombatLockdown() then
		local chgbutton = self:GetMount('c'..config..'-combat-mnt-try', 'combat') or {}
		-- or => if nothing found: nothing

		self:dump('postclick-button', chgbutton)
	
		self:SetAttributes(config, chgbutton)
	end
end

function SmartMount:SetAttributes(config, attr)
	SmartMount_Button:SetAttribute('type'..config, attr['type'])
	SmartMount_Button:SetAttribute('spell'..config, attr['spell'])
	SmartMount_Button:SetAttribute('item'..config, attr['item'])
end

function SmartMount:GetMount(prefix, name)
	for i=1, 3 do
		local mount = self:GetPref(prefix .. i)

		-- self:dump(prefix..i, 

		local result = nil
		if not mount or mount == 'off' then
			return nil -- found nothing: do nothing
		elseif mount == 'rnd_fast' and IsOutdoors() then
			result = self:GetRandomMount(self:IsInOutland(GetZoneText()))
		elseif mount == 'rnd_all' and IsOutdoors() then
			result = self:GetAnyRandomMount(self:IsInOutland(GetZoneText()))
		elseif mount == 'rnd_pet' then
			if AceLibrary and AceLibrary:HasInstance('LibPeriodicTable-3.1') then
				local PT = AceLibrary('LibPeriodicTable-3.1')
				local pets = {}			
				for bag = 0, NUM_BAG_FRAMES do
					for slot = 1, GetContainerNumSlots(bag) do
						local link = GetContainerItemLink(bag, slot)
						if link then
							local found, _, fullitemid, itemid = string.find(link, '(item:(%d+):[0-9:]*)')
							if found and PT:ItemInSet(fullitemid, 'Misc.Minipet.Normal') and self.currentPet ~= fullitemid then
								table.insert(pets, fullitemid)
							end -- if
						end -- if
					end -- for
				end -- for
				if #pets > 0 then
					self.currentPet = pets[math.random(#pets)]
					result = {
						type = 'item',
						item = self.currentPet,
					}
				end
			end -- if
		elseif string.sub(mount, 1, 5) == 'item:' then
			if self:WearItem(mount) then
				result = {
					type = 'item',
					item = mount,
				}
			end -- if
		elseif self.SpecialSpells[mount] then
			-- something special (which is in SpecialSpells)
			if 
				(
					(self.SpecialSpells[mount].type == 'spell' and self.SpecialSpells[mount].can) or
					(self.SpecialSpells[mount].type == 'item' and self:WearItem(self.SpecialSpells[mount].item))
				)
					and
				(
					not self.SpecialSpells[mount].outlandonly or self:IsInOutland(GetZoneText())
				)
					and
				(
					self.SpecialSpells[mount].inhouse or IsOutdoors()
				)
					and
				(
					(name == 'swim' and self.SpecialSpells[mount].inwater) or
					(name == 'fly' and self.SpecialSpells[mount].inair) or
					(name == 'land' and self.SpecialSpells[mount].onground) or
					(name == 'combat' and self.SpecialSpells[mount].incombat)
				)
			then
				result = self.SpecialSpells[mount]
			end -- if
		end -- if
		if result then
			return result
		end -- if
	end
	return nil
end

function SmartMount:GetRandomMount(inoutland)
	-- get 'regular' mounts
	local mounts = self:CountMounts(false)
	
	-- max speed (outland or not)
	local maxspeed = 4
	if inoutland then
		maxspeed = 7
	end -- if
	
	self:dump('mounts_avail', mounts)
	
	-- pick speed category
	for speed = maxspeed, 1, -1 do
		if #(mounts[speed]) > 0 then
			self:dump('mounts_sele', mounts[speed])
			return mounts[speed][math.random(#(mounts[speed]))]
		end
	end -- for
	
	return nil
end

function SmartMount:GetAnyRandomMount(inoutland)
	-- get 'regular' mounts
	local mounts = self:CountMounts(false)
	
	-- max speed (outland or not)
	local maxspeed = 4
	if inoutland then
		maxspeed = 7
	end -- if
	
	self:dump('mounts_biglist', mounts)
	
	local biglist = {}
	
	-- pick speed category
	for speed = maxspeed, 1, -1 do
		for _, v in pairs(mounts[speed]) do
			table.insert(biglist, v)
		end -- for
	end -- for
	
	if #biglist > 0 then
		return biglist[math.random(#biglist)]
	end -- if
	
	return nil
end

function SmartMount:CountMounts(withoutSpells)
	local mounts = { {}, {}, {}, {}, {}, {}, {} }

	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
			local link = GetContainerItemLink(bag, slot)
			if link then
				local found, _, fullitemid, itemid = string.find(link, '(item:(%d+):[0-9:]*)')
				if found then
					local speed = self.Mounts[tonumber(itemid)]
					if speed then
						table.insert(mounts[speed], { type = 'item', item = fullitemid } )
					end -- if
				end -- if
			end -- if
		end -- for
	end -- for

	if not withoutSpells then
		for name, spell in pairs(self.SpecialSpells) do
			if spell.can and spell['mount'] then
				table.insert(mounts[spell['mount']], spell)
			end -- if
		end -- for
	end -- if

	return mounts
end

function SmartMount:WearItem(item)
	-- search in bags
	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
			local link = GetContainerItemLink(bag, slot)
			if link and string.find(link, item) then
				return true
			end -- if
		end -- for
	end -- for
	
	-- search on me
	for slot = 1, 39 do
		local link = GetInventoryItemLink('player', slot)
		if link and string.find(link, item) then
			return true
		end -- if
	end -- for
	return false
end

function SmartMount:IsInOutland(zone)
	for _,name in pairs({GetMapZones(3)}) do
		if(name == zone) then
			return true
		end
	end
	return false
end

SmartMount.Mounts = {
	-- 1 = Riding Skill 0 / Speed 100% (±0%)
	[5874] = 1, -- Harness: Black Ram, Lvl 40
	[5875] = 1, -- Harness: Blue Ram, Lvl 40
	[8627] = 1, -- Reins of the Night saber, Lvl 40
	[8628] = 1, -- Reins of the Spotted Nightsaber, Lvl 40
	[14062] = 1, -- Kodo Mount, Lvl 40
	[23720] = 1, -- Riding Turtle, Lvl 1
	[33189] = 1, -- Rickety Magic Broom, Lvl 1
	-- 3 = Riding Skill 75 / Speed +60%
	[1132] = 3, -- Horn of the Timber Wolf, Lvl 30
	[2411] = 3, -- Black Stallion Bridle, Lvl 30
	[2414] = 3, -- Pinto Bridle, Lvl 30
	[5655] = 3, -- Chestnut Mare Bridle, Lvl 30
	[5656] = 3, -- Brown Horse Bridle, Lvl 30
	[5665] = 3, -- Horn of the Dire Wolf, Lvl 30
	[5668] = 3, -- Horn of the Brown Wolf, Lvl 30
	[5864] = 3, -- Gray Ram, Lvl 30
	[5872] = 3, -- Brown Ram, Lvl 30
	[5873] = 3, -- White Ram, Lvl 30
	[8563] = 3, -- Red Mechanostrider, Lvl 30
	[8588] = 3, -- Whistle of the Emerald Raptor, Lvl 30
	[8591] = 3, -- Whistle of the Turquoise Raptor, Lvl 30
	[8592] = 3, -- Whistle of the Violet Raptor, Lvl 30
	[8595] = 3, -- Blue Mechanostrider, Lvl 30
	[8629] = 3, -- Reins of the Striped Nightsaber, Lvl 30
	[8631] = 3, -- Reins of the Striped Frostsaber, Lvl 30
	[8632] = 3, -- Reins of the Spotted Frostsaber, Lvl 30
	[13086] = 3, -- Reins of the Winterspring Frostsaber, Lvl 60
	[13321] = 3, -- Green Mechanostrider, Lvl 30
	[13322] = 3, -- Unpainted Mechanostrider, Lvl 30
	[13331] = 3, -- Red Skeletal Horse, Lvl 30
	[13332] = 3, -- Blue Skeletal Horse, Lvl 30
	[13333] = 3, -- Brown Skeletal Horse, Lvl 30
	[15277] = 3, -- Gray Kodo, Lvl 30
	[15290] = 3, -- Brown Kodo, Lvl 30
	[18241] = 3, -- Black War Steed Bridle, Lvl 55
	[18242] = 3, -- Reins of the Black War Tiger, Lvl 55
	[18243] = 3, -- Black Battlestrider, Lvl 55
	[18244] = 3, -- Black War Ram, Lvl 55
	[18245] = 3, -- Horn of the Black War Wolf, Lvl 55
	[18246] = 3, -- Whistle of the Black War Raptor, Lvl 55
	[18247] = 3, -- Black War Kodo, Lvl 55
	[18248] = 3, -- Red Skeletal Warhorse, Lvl 55
	-- [21218] = 3, -- Blue Qiraji Resonating Crystal, Lvl 60
	-- [21321] = 3, -- Red Qiraji Resonating Crystal, Lvl 60
	-- [21323] = 3, -- Green Qiraji Resonating Crystal, Lvl 60
	-- [21324] = 3, -- Yellow Qiraji Resonating Crystal, Lvl 60
	[28481] = 3, -- Brown Elekk, Lvl 30
	[28927] = 3, -- Red Hawkstrider, Lvl 30
	[29220] = 3, -- Blue Hawkstrider, Lvl 30
	[29221] = 3, -- Black Hawkstrider, Lvl 30
	[29222] = 3, -- Purple Hawkstrider, Lvl 30
	[29743] = 3, -- Purple Elekk, Lvl 30
	[29744] = 3, -- Gray Elekk, Lvl 30
	[33183] = 3, -- Old Magic Broom, Lvl 40
	[33224] = 3, -- Reins of the Spectral Tiger, Lvl 30
	[33976] = 3, -- Brewfest Ram, Lvl 30
	-- 4 = Riding Skill 150 / Speed +100%
	[8586] = 4, -- Whistle of the Mottled Red Raptor, Lvl 60
	[12302] = 4, -- Reins of the Frostsaber, Lvl 60
	[12303] = 4, -- Reins of the Nightsaber, Lvl 60
	[12330] = 4, -- Horn of the Red Wolf, Lvl 60
	[12351] = 4, -- Horn of the Arctic Wolf, Lvl 60
	[12353] = 4, -- White Stallion Bridle, Lvl 60
	[12354] = 4, -- Palomino Bridle, Lvl 60
	[13317] = 4, -- Whistle of the Ivory Raptor, Lvl 60
	[13326] = 4, -- White Mechanostrider Mod A, Lvl 60
	[13327] = 4, -- Icy Blue Mechanostrider Mod A, Lvl 60
	[13328] = 4, -- Black Ram, Lvl 60
	[13329] = 4, -- Frost Ram, Lvl 60
	[13334] = 4, -- Green Skeletal Warhorse, Lvl 60
	[13335] = 4, -- Deathcharger's Reins, Lvl 60
	[15292] = 4, -- Green Kodo, Lvl 60
	[15293] = 4, -- Teal Kodo, Lvl 60
	[18766] = 4, -- Reins of the Swift Frostsaber, Lvl 60
	[18767] = 4, -- Reins of the Swift Mistsaber, Lvl 60
	[18772] = 4, -- Swift Green Mechanostrider, Lvl 60
	[18773] = 4, -- Swift White Mechanostrider, Lvl 60
	[18774] = 4, -- Swift Yellow Mechanostrider, Lvl 60
	[18776] = 4, -- Swift Palomino, Lvl 60
	[18777] = 4, -- Swift Brown Steed, Lvl 60
	[18778] = 4, -- Swift White Steed, Lvl 60
	[18785] = 4, -- Swift White Ram, Lvl 60
	[18786] = 4, -- Swift Brown Ram, Lvl 60
	[18787] = 4, -- Swift Gray Ram, Lvl 60
	[18788] = 4, -- Swift Blue Raptor, Lvl 60
	[18789] = 4, -- Swift Olive Raptor, Lvl 60
	[18790] = 4, -- Swift Orange Raptor, Lvl 60
	[18791] = 4, -- Purple Skeletal Warhorse, Lvl 60
	[18793] = 4, -- Great White Kodo, Lvl 60
	[18794] = 4, -- Great Brown Kodo, Lvl 60
	[18795] = 4, -- Great Gray Kodo, Lvl 60
	[18796] = 4, -- Horn of the Swift Brown Wolf, Lvl 60
	[18797] = 4, -- Horn of the Swift Timber Wolf, Lvl 60
	[18798] = 4, -- Horn of the Swift Gray Wolf, Lvl 60
	[18902] = 4, -- Reins of the Swift Stormsaber, Lvl 60
	[19029] = 4, -- Horn of the Frostwolf Howler, Lvl 60
	[19030] = 4, -- Stormpike Battle Charger, Lvl 60
	[19872] = 4, -- Swift Razzashi Raptor, Lvl 60
	[19902] = 4, -- Swift Zulian Tiger, Lvl 60
	[28915] = 4, -- Reins of the Dark Riding Talbuk, Lvl 60
	[28936] = 4, -- Swift Pink Hawkstrider, Lvl 60
	[29102] = 4, -- Reins of the Cobalt War Talbuk, Lvl 60
	[29103] = 4, -- Reins of the White War Talbuk, Lvl 60
	[29104] = 4, -- Reins of the Silver War Talbuk, Lvl 60
	[29105] = 4, -- Reins of the Tan War Talbuk, Lvl 60
	[29223] = 4, -- Swift Green Hawkstrider, Lvl 60
	[29224] = 4, -- Swift Purple Hawkstrider, Lvl 60
	[29227] = 4, -- Reins of the Cobalt War Talbuk, Lvl 60
	[29228] = 4, -- Reins of the Dark War Talbuk, Lvl 60
	[29229] = 4, -- Reins of the Silver War Talbuk, Lvl 60
	[29230] = 4, -- Reins of the Tan War Talbuk, Lvl 60
	[29231] = 4, -- Reins of the White War Talbuk, Lvl 60
	[29465] = 4, -- Black Battlestrider, Lvl 60
	[29466] = 4, -- Black War Kodo, Lvl 60
	[29467] = 4, -- Black War Ram, Lvl 60
	[29468] = 4, -- Black War Steed Bridle, Lvl 60
	[29469] = 4, -- Horn of the Black War Wolf, Lvl 60
	[29470] = 4, -- Red Skeletal Warhorse, Lvl 60
	[29471] = 4, -- Reins of the Black War Tiger, Lvl 60
	[29472] = 4, -- Whistle of the Black War Raptor, Lvl 60
	[29745] = 4, -- Great Blue Elekk, Lvl 60
	[29746] = 4, -- Great Green Elekk, Lvl 60
	[29747] = 4, -- Great Purple Elekk, Lvl 60
	[30480] = 4, -- Fiery Warhorse's Reins, Lvl 70
	[31829] = 4, -- Reins of the Cobalt Riding Talbuk, Lvl 60
	[31830] = 4, -- Reins of the Cobalt Riding Talbuk, Lvl 60
	[31831] = 4, -- Reins of the Silver Riding Talbuk, Lvl 60
	[31832] = 4, -- Reins of the Silver Riding Talbuk, Lvl 60
	[31833] = 4, -- Reins of the Tan Riding Talbuk, Lvl 60
	[31834] = 4, -- Reins of the Tan Riding Talbuk, Lvl 60
	[31835] = 4, -- Reins of the White Riding Talbuk, Lvl 60
	[31836] = 4, -- Reins of the White Riding Talbuk, Lvl 60
	[32768] = 4, -- Reins of the Raven Lord, Lvl 70
	[33184] = 4, -- Swift Magic Broom, Lvl 60
	[33225] = 4, -- Reins of the Swift Spectral Tiger, Lvl 60
	[33809] = 4, -- Amani War Bear, Lvl 70
	[33977] = 4, -- Swift Brewfest Ram, Lvl 60
	[34129] = 4, -- Swift Warstrider, Lvl 60
	[35513] = 4, -- Swift White Hawkstrider, Lvl 60
	[35906] = 4, -- Reins of the Black War Elekk, Lvl 60
	-- 5 = Riding Skill 225 / Speed +60%/+60%
	[25470] = 5, -- Golden Gryphon, Lvl 70
	[25471] = 5, -- Ebon Gryphon, Lvl 70
	[25472] = 5, -- Snowy Gryphon, Lvl 70
	[25474] = 5, -- Tawny Windrider, Lvl 70
	[25475] = 5, -- Blue Windrider, Lvl 70
	[25476] = 5, -- Green Windrider, Lvl 70
	[33176] = 5, -- Flying Broom, Lvl 70
	[34060] = 5, -- Flying Machine Control, Lvl 70
	[35225] = 5, -- X-51 Nether-Rocket, Lvl 70
	-- 6 = Riding Skill 300 / Speed +100%/+280%
	[25473] = 6, -- Swift Blue Gryphon, Lvl 70
	[25477] = 6, -- Swift Red Windrider, Lvl 70
	[25527] = 6, -- Swift Red Gryphon, Lvl 70
	[25528] = 6, -- Swift Green Gryphon, Lvl 70
	[25529] = 6, -- Swift Purple Gryphon, Lvl 70
	[25531] = 6, -- Swift Green Windrider, Lvl 70
	[25532] = 6, -- Swift Yellow Windrider, Lvl 70
	[25533] = 6, -- Swift Purple Windrider, Lvl 70
	[32314] = 6, -- Green Riding Nether Ray, Lvl 70
	[32316] = 6, -- Purple Riding Nether Ray, Lvl 70
	[32317] = 6, -- Red Riding Nether Ray, Lvl 70
	[32318] = 6, -- Silver Riding Nether Ray, Lvl 70
	[32319] = 6, -- Blue Riding Nether Ray, Lvl 70
	[32857] = 6, -- Reins of the Onyx Netherwing Drake, Lvl 70
	[32858] = 6, -- Reins of the Azure Netherwing Drake, Lvl 70
	[32859] = 6, -- Reins of the Cobalt Netherwing Drake, Lvl 70
	[32860] = 6, -- Reins of the Purple Netherwing Drake, Lvl 70
	[32861] = 6, -- Reins of the Veridian Netherwing Drake, Lvl 70
	[32862] = 6, -- Reins of the Violet Netherwing Drake, Lvl 70
	[33182] = 6, -- Swift Flying Broom, Lvl 70
	[33999] = 6, -- Cenarion War Hippogryph, Lvl 70
	[34061] = 6, -- Turbo-Charged Flying Machine Control, Lvl 70
	[34092] = 6, -- Merciless Nether Drake, Lvl 70
	[35226] = 6, -- X-51 Nether-Rocket X-TREME, Lvl 70
	-- 7 = Riding Skill 310 / Speed +100%/+310%
	[30609] = 7, -- Swift Nether Drake, Lvl 70
	[32458] = 7, -- Ashes of Al'ar, Lvl 70
	[37676] = 7, -- Vengeful Nether Drake, Lvl 70
}
