--[[
		locale, only if Rock is used!
--]]

if Rock and Rock:HasLibrary('LibRockLocale-1.0') then

	local L = Rock('LibRockLocale-1.0'):GetTranslationNamespace('SmartMount')
	
	L:AddTranslations('enUS', function() return {
		-- fresh start
		['welcome_info'] = [[Welcome to |cff3fcf26SmartMount|r V%s

Would you like to see the configuration now?
(Or use /smartmount later.)]],
		['welcome_now'] = [[Yes, open it]],
		['welcome_later'] = [[No, later]],
	
		-- translated by
		['translated_by'] = [[Nobody]],
		
		-- global keybings
		['Show Options'] = true,

		-- some special spells
		['Travel, Flight or Swift Flight Form'] = true,
		['Flight / Swift Flight Form'] = true,
		['Bear / Dire Bear Form'] = true,

		-- config, first page
		['key1'] = '1st Mount',
		['key2'] = '2nd Mount',
		['key3'] = '3rd Mount',
		['key1_desc'] = [[Here you can configure a key which summons a mount which is in the 1st page configured.]],
		['key2_desc'] = [[Here you can configure a key which summons a mount which is in the 2nd page configured.]],
		['key3_desc'] = [[Here you can configure a key which summons a mount which is in the 3rd page configured.]],

		['key_helper_name'] = [[Help with Keys]],
		['key_helper_desc'] = [[WARNING:
Use this only if you can't enter the keys you want (e.g. Mouse4, Mouse5, Shift-Mouse3, ...).

The first "Show Options" key from the global key bindings will be "1st Mount", the second "Show Options" key the "2nd Mount", and both "Open Config" keys will be unset.

Please use with care!]],
		['key_helper_confirm'] = [[I've read the Tooltip]],
		['key_helper_button'] = [[Import from key bindings]],
		['show_action_button_name'] = [[Show Action Button]],
		['show_action_button_desc'] = [[Left: 1st Mount
Right: 2nd Mount
Middle: 3rd Mount
Shift-Left: Move Button]],
		['debug_name'] = [[Enable Debugging]],
		['debug_desc'] = [[Many debug informations will flood the chat window]],

		-- config, page 1-4
		['config1_name'] = [[1st Config]],
		['config2_name'] = [[2nd Config]],
		['config3_name'] = [[3rd Config]],
		['configX_desc'] = [[Configure here what sould happen when you press the key/button.]],
		['grp_mount_name'] = [[If not mounted]],
		['grp_mount_desc'] = [[If you're not mounted, do the first available of the following.]],
		['grp_dismount_name'] = [[If mounted]],
		['grp_dismount_desc'] = [[Decide weather to dismount or not.]],
		['grp_dismount_do_name'] = [[Dismount]],
		['grp_dismount_do_desc'] = [[After dismounting do the first available of the following, or nothing at all.]],
		['mount_mnt_off'] = [[Don't Mount]],
		['mount_dis_off'] = [[Just dismount]],
		['mount_rnd_fast'] = [[Random Mount (fastest)]],
		['mount_rnd_any'] = [[Random Mount (any)]],
		['mount_rnd_pet'] = [[Random Pet]],
		['mount_rnd_pet_req'] = [[Random Pet (Requires "LibPeriodicTable-3.1")]],
		['grp_mount_1st'] = [[1st choice]],
		['grp_mount_2nd'] = [[2nd choice]],
		['grp_mount_3rd'] = [[3rd choice]],
		['grp_mount_1st2nd_desc'] = [[Which mount?
If this mount is not available, try next.]],
		['grp_mount_3rd_desc'] = [[Which mount?
If this mount is not available noting will happen.]],

		-- config, page 1. combat
		['combat_name'] = [[1. In Combat]],
		['combat_desc'] = [[Here you can set what should be done if you're in combat.]],
		['grp_dismount_do_combat_no'] = [[No, but do the things above]],
		['grp_dismount_do_combat_yes'] = [[Yes, and do the things above]],

		-- config, page 2. swimming
		['swim_name'] = [[2. In Water]],
		['swim_desc'] = [[Here you can set what should be done if you're in water.]],

		-- config, page 3. flying
		['fly_name'] = [[3. In Air]],
		['fly_desc'] = [[Here you can set what should be done if you're in the air.]],
		['grp_dismount_do_fly_no'] = [[No]],
		['grp_dismount_do_fly_yes'] = [[Yes]],
		['grp_dismount_do_fly_yes_groundonly'] = [[Yes, but not from an flying mount]],

		-- config, page 4. on ground
		['land_name'] = [[4. On Ground]],
		['land_desc'] = [[Here you can set what should be done if you're on ground.]],
		
		-- config, help
		['help_name'] = [[Help]],
		['help_desc'] = [[Do you need help?]],
		['help_geturl'] = [[Get URL]],
		['help_help_name'] = [[Help]],
		['help_help_desc'] = [[It's easy.]],
		['help_help_btn'] = [[Read always the ToolTips!]],
		['help_mounts_name'] = [[Mounts are ...]],
		['help_mounts_desc'] = [[This list shows you, what this addon counts as mounts.]],
		['help_mounts_reg'] = [[Regular Mounts]],
		['help_mounts_reg_ex'] = [[e.g. Reins of the Striped Nightsaber]],
		['help_mounts_sum'] = [[Summoned Mounts]],
		['help_mounts_dru'] = [[Druid Forms]],
		['help_mounts_sha'] = [[Shaman Form]],
		['help_macro_name'] = [[Macro]],
		['help_macro_desc'] = [[This will create an macro, which can be used like this:

Left Click = 1st Mount
Right Click = 2nd Mount
Middle Click = 3rd Mount]],
		['help_macro_btn'] = [[Create a Macro]],
		['help_libpt_desc'] = [[This Addon makes it (for SmartMount) possible to summon a random pet after dismounting.]],
		['help_menagerie_desc'] = [[This is an Addon which swaps minipets and mounts when visiting the bank — which makes it even more random.]],
		['help_inspiration_name'] = [[Inspiration]],
		['help_inspiration_btn'] = [[Inspired by Timo's RandomMount Macro and Tabethial's RandomPet Addon]],
			-- "Timo", "RandomMount", "Tabethial" and "RandomPet" are names and should not translated
		['help_ranslator_name'] = [[Translator]],
		['help_donate'] = [[Donate]],
		['geturl_info'] = [[Just copy and paste the URL to your favorite browser.]],
		
	} end )
	
	L:AddTranslations('deDE', function() return {
		-- fresh start
		['welcome_info'] = [[Wilkommen zu |cff3fcf26SmartMount|r V%s

Möchtest du die Einstellungen jetzt sehen?
(Oder öffne sie später mit /smartmount).]],
		['welcome_now'] = [[Ja, öffnen]],
		['welcome_later'] = [[Nein, später]],
	
		-- translated by
		['translated_by'] = [[Niemand]],
		
		-- global keybings
		['Show Options'] = [[Zeige Optionen]],

		-- some special spells
		['Travel, Flight or Swift Flight Form'] = [[Reise-/ Flug-/ Schnelle Fluggestalt]],
		['Flight / Swift Flight Form'] = [[Flug- / Schnelle Fluggestalt]],
		['Bear / Dire Bear Form'] = [[Bären- / Terrorbärengestalt]],

		-- config, first page
		['key1'] = '1. Reittier',
		['key2'] = '2. Reittier',
		['key3'] = '3. Reittier',
		['key1_desc'] = [[Hier kannst du eine Taste belegen, welche das Reittier herbei ruft, welches in Konfiguration 1 festgelegt ist.]],
		['key2_desc'] = [[Hier kannst du eine Taste belegen, welche das Reittier herbei ruft, welches in Konfiguration 2 festgelegt ist.]],
		['key3_desc'] = [[Hier kannst du eine Taste belegen, welche das Reittier herbei ruft, welches in Konfiguration 3 festgelegt ist.]],
		['key_helper_name'] = [[Hilfe bei Tasten]],
		['key_helper_desc'] = [[WARNUNG:
Benutze dieses nur wenn du nicht die Tasten eingeben kannst, die du möchtest (z.B. Maus4, Maus5, Shift-Maus3, ...).

Die erste Taste von "Zeige Optionen" der Globalen Tastaturbelegung wird das "1. Reittier", die zweite Taste von "Zeige Optionen" wird das "2. Reittier", beide "Zeige Optionen" Tasten werden gelöscht.

Bitte mit Vorsicht benutzen!]],
		['key_helper_confirm'] = [[Hab' den Tooltip gelesen]],
		['key_helper_button'] = [[Importiere von der Tastenbelegung]],
		['show_action_button_name'] = [[Zeige Action Button]],
		['show_action_button_desc'] = [[Links: 1. Reittier
Rechts: 2. Reittier
Mitte: 3. Reittier
Shift-Links: Bewege Button]],
		['debug_name'] = [[Aktiviere Debugging]],
		['debug_desc'] = [[Viele Informationen werden das Chat-Fenster fluten. ]],

		-- config, page 1-4
		['config1_name'] = [[1. Konfiguration]],
		['config2_name'] = [[2. Konfiguration]],
		['config3_name'] = [[3. Konfiguration]],
		['configX_desc'] = [[Hier kannst du einstellen, was passieren soll, wenn du die Taste / den Knopf drückst.]],
		['grp_mount_name'] = [[Wenn nicht reitend]],
		['grp_mount_desc'] = [[Wenn du nicht reitest, mache das erste, was verfügbar ist.]],
		['grp_dismount_name'] = [[Wenn reitend]],
		['grp_dismount_desc'] = [[Entscheide, ob du absitzen möchtest, oder nicht.]],
		['grp_dismount_do_name'] = [[Absitzen]],
		['grp_dismount_do_desc'] = [[Wenn du absitzt, mache auch das erste verfügbare des folgenden.]],
		['mount_mnt_off'] = [[Nicht aufsitzen]],
		['mount_dis_off'] = [[Nur absitzen]],
		['mount_rnd_fast'] = [[Zufälliges Reittier (schnellstes)]],
		['mount_rnd_any'] = [[Zufälliges Reittier (irgendeins)]],
		['mount_rnd_pet'] = [[Zufälliges Haustier]],
		['mount_rnd_pet_req'] = [[Zufälliges Haustier (Benötigt "LibPeriodicTable-3.1")]],
		['grp_mount_1st'] = [[1. Wahl]],
		['grp_mount_2nd'] = [[2. Wahl]],
		['grp_mount_3rd'] = [[3. Wahl]],
		['grp_mount_1st2nd_desc'] = [[Welches Reittier?
Wenn dieses Reittier nicht verfügbar ist, probiere nächstes.]],
		['grp_mount_3rd_desc'] = [[Welches Reittier?
Wenn dieses Reittier nicht verfügbar ist wird nichts passieren.]],

		-- config, page 1. combat
		['combat_name'] = [[1. Im Kampf]],
		['combat_desc'] = [[Hier kannst du einstellen, was passieren soll wenn du im Kampf bist.]],
		['grp_dismount_do_combat_no'] = [[Nein, aber mache das was oben steht]],
		['grp_dismount_do_combat_yes'] = [[Ja, und mache das was oben steht]],

		-- config, page 2. swimming
		['swim_name'] = [[2. Im Wasser]],
		['swim_desc'] = [[Hier kannst du einstellen, was passieren soll wenn du schwimmst.]],

		-- config, page 3. flying
		['fly_name'] = [[3. In der Luft]],
		['fly_desc'] = [[Hier kannst du einstellen, was passieren soll wenn du in der Luft bist.]],
		['grp_dismount_do_fly_no'] = [[Nein]],
		['grp_dismount_do_fly_yes'] = [[Ja]],
		['grp_dismount_do_fly_yes_groundonly'] = [[Ja, aber nicht von einem Flugtier]],

		-- config, page 4. on ground
		['land_name'] = [[4. Am Boden]],
		['land_desc'] = [[Hier kannst du einstellen, was passieren soll wenn du am Boden stehst.]],
		
		-- config, help
		['help_name'] = [[Hilfe]],
		['help_desc'] = [[Brauchst du Hilfe?]],
		['help_geturl'] = [[Hole URL]],
		['help_help_name'] = [[Hilfe]],
		['help_help_desc'] = [[Es ist einfach.]],
		['help_help_btn'] = [[Lies immer die ToolTips!]],
		['help_mounts_name'] = [[Reittiere sind ...]],
		['help_mounts_desc'] = [[Diese Liste zeigt, was dieses Addon als Reittier ansieht.]],
		['help_mounts_reg'] = [[Normale Reittiere]],
		['help_mounts_reg_ex'] = [[z.B. Zügel des gestreiften Nachtsäblers]],
		['help_mounts_sum'] = [[Beschworene Reittiere]],
		['help_mounts_dru'] = [[Druiden Formen]],
		['help_mounts_sha'] = [[Schamanen Form]],
		['help_macro_name'] = [[Makro]],
		['help_macro_desc'] = [[Dies wird ein Makro erstellen, was wie folgt benutzt werden kann:

Links klick = 1. Reittier
Rechts klick = 2. Reittier
Mittel klick = 3. Reittier]],
		['help_macro_btn'] = [[Erstelle ein Makro]],
		['help_libpt_desc'] = [[Dieses Addon ermöglicht es SmartMount zufällige Haustiere beim absitzen zu benutzen.]],
		['help_menagerie_desc'] = [[Dieses Addon tauscht Haustiere und Reittiere beim besuch der Bank aus - was es noch zufälliger macht.]],
		['help_inspiration_name'] = [[Inspiration]],
		['help_inspiration_btn'] = [[Inspiriert durch Timos RandomMount Makro und Tabethials RandomPet Addon]],
			-- "Timo", "RandomMount", "Tabethial" and "RandomPet" are names and should not translated
		['help_ranslator_name'] = [[Übersetzer]],
		['help_donate'] = [[Spenden]],
		['geturl_info'] = [[Kopiere einfach diese URL in einen Browser deiner Wahl.]],
		
	} end )

	L:AddTranslations('zhCN', function() return {

		-- fresh start
		['welcome_info'] = [[欢迎使用|cff3fcf26SmartMount|r V%s.

请首先进行配置 (/smartmount)。]],
		['welcome_now'] = [[好的，打开配置窗口]],
		['welcome_later'] = [[不，稍候进行配置]],
	
		-- translated by
		['translated_by'] = [[wangmarsfa@cwdg]],
		
		-- global keybings
		['Show Options'] = [[显示选项]],

		-- some special spells
		['Travel, Flight or Swift Flight Form'] = [[旅行、飞行或者迅捷飞行形态]],
		['Flight / Swift Flight Form'] = [[飞行/迅捷飞行形态]],
		['Bear / Dire Bear Form'] = [[熊/巨熊形态]],

		-- config, first page
		['key1'] = [[首选座骑]],
		['key2'] = [[次选座骑]],
		['key3'] = [[候补座骑]],
		['key1_desc'] = [[你可以在这里设置一个按键，用以召唤你在第一页配置好的座骑]],
		['key2_desc'] = [[你可以在这里设置一个按键，用以召唤你在第二页配置好的座骑]],
		['key3_desc'] = [[你可以在这里设置一个按键，用以召唤你在第三页配置好的座骑]],

		['key_helper_name'] = [[按键绑定帮助]],
		['key_helper_desc'] = [[警告：
仅在你不能键入你想要键入的按键绑定 (例如：第四候选、第五候选、Shift-候补、……)。

第一个"显示选项"按键将绑定到"首选座骑"，第二个"显示选项"按键将绑定到"次选座骑"，且所有的"打开配置"将重置按键绑定。

请三思而后行！]],
		['key_helper_confirm'] = [[我已经读了这些提示信息了]],
		['key_helper_button'] = [[从按键绑定导入]],
		['show_action_button_name'] = [[显示动作按钮]],
		['show_action_button_desc'] = [[左键：首选座骑
右键：次选座骑
中键：候补座骑
Shift+左键：移动按钮]],
		['debug_name'] = [[启用调试模式]],
		['debug_desc'] = [[可以让你获取更多调试信息。]],

		-- config, page 1-4
		['config1_name'] = [[首选座骑配置选项]],
		['config2_name'] = [[次选座骑配置选项]],
		['config3_name'] = [[候补座骑配置选项]],
		['configX_desc'] = [[在这里配置当绑定的按键或者按钮按下时将做什么动作。]],
		['grp_mount_name'] = [[不在骑乘状态]],
		['grp_mount_desc'] = [[如果你不在骑乘状态，则执行列表中最靠前的可执行动作。]],
		['grp_dismount_name'] = [[处于骑乘状态]],
		['grp_dismount_desc'] = [[是取消骑乘还是保持骑乘状态。]],
		['grp_dismount_do_name'] = [[取消骑乘状态]],
		['grp_dismount_do_desc'] = [[当取消骑乘状态后，是执行列表中最靠前的可执行动作还是什么都不做。]],
		['mount_mnt_off'] = [[不再进入骑乘状态]],
		['mount_dis_off'] = [[仅取消骑乘状态]],
		['mount_rnd_fast'] = [[随机座骑(速度最快)]],
		['mount_rnd_any'] = [[随机座骑(任意)]],
		['mount_rnd_pet'] = [[随机宠物]],
		['mount_rnd_pet_req'] = [[随机宠物(需要"LibPeriodicTable-3.1")]],
		['grp_mount_1st'] = [[首选]],
		['grp_mount_2nd'] = [[次选]],
		['grp_mount_3rd'] = [[候补]],
		['grp_mount_1st2nd_desc'] = [[哪个座骑？
如果这个座骑不可用，尝试下一个。]],
		['grp_mount_3rd_desc'] = [[哪个坐骑？
如果这个座骑不存在，什么也不做。]],

		-- config, page 1. combat
		['combat_name'] = [[1. 进入战斗]],
		['combat_desc'] = [[在这里你可以设置如果你在战斗状态下，使用什么设置。]],
		['grp_dismount_do_combat_no'] = [[不，但执行下列动作]],
		['grp_dismount_do_combat_yes'] = [[是，并执行下列动作]],

		-- config, page 2. swimming
		['swim_name'] = [[2. 在水中]],
		['swim_desc'] = [[你可以在这里设置如果在水中时，点击按钮会执行什么动作。]],

		-- config, page 3. flying
		['fly_name'] = [[3. 在空中]],
		['fly_desc'] = [[你可以在这里设置如果在空中时，点击按钮会执行什么动作。]],
		['grp_dismount_do_fly_no'] = [[否]],
		['grp_dismount_do_fly_yes'] = [[是]],
		['grp_dismount_do_fly_yes_groundonly'] = [[是，但不是从一个飞行座骑上。]],

		-- config, page 4. on ground
		['land_name'] = [[4. 在地上]],
		['land_desc'] = [[你可以在这里设置如果在地上是，点击按钮会执行什么动作。]],
		
		-- config, help
		['help_name'] = [[帮助]],
		['help_desc'] = [[你需要帮助么？]],
		['help_geturl'] = [[获取地址(URL)]],
		['help_help_name'] = [[帮助]],
		['help_help_desc'] = [[这很容易。]],
		['help_help_btn'] = [[请仔细阅读提示信息！]],
		['help_mounts_name'] = [[座骑有……]],
		['help_mounts_desc'] = [[这个列表将告诉你这个插件把哪些东西作为座骑。]],
		['help_mounts_reg'] = [[普通座骑]],
		['help_mounts_reg_ex'] = [[例如：条纹夜刃豹韁绳]],
		['help_mounts_sum'] = [[召唤座骑]],
		['help_mounts_dru'] = [[德鲁伊形态]],
		['help_mounts_sha'] = [[萨满形态(幽灵狼)]],
		['help_macro_name'] = [[宏]],
		['help_macro_desc'] = [[这将会创建一个宏，你可以这样用：

左键：首选座骑
右键：次选座骑
中键：候补座骑]],
		['help_macro_btn'] = [[创建宏]],
		['help_libpt_desc'] = [[这个插件允许你在可行的情况下，取消骑乘后自动召唤一个非战斗宠物。]],
		['help_menagerie_desc'] = [[这个插件也允许你在可行的情况下，在访问银行的时候自动随机更换非战斗宠物和座骑。]],
		['help_inspiration_name'] = [[灵感]],
		['help_inspiration_btn'] = [[这个插件的灵感来源于Timo的RandomMount宏和Tabethial的RandomPet插件。]],
			-- "Timo", "RandomMount", "Tabethial" and "RandomPet" are names and should not translated
		['help_ranslator_name'] = [[翻译者]],
		['help_donate'] = [[捐助者]],
		['geturl_info'] = [[拷贝下列地址(URL)并粘贴到你的浏览器即可 ^_^]],

	} end )
	
end -- if
