--[[

	this file conatins everything which is neccecary to configure via rock
	
--]]

--
-- create the main-config-menu
--

function SmartMount:OnInitialize()
	local L = self.L

	self.options = {
		type = 'group',
		name = 'SmartMount',
		desc = [[The One-Key-Mount™

Simple to use, configured with Rock]],
		icon = 'Interface\\Icons\\Ability_Mount_BlackPanther',
		child_get = 'GetSetting',
		child_set = 'SetSetting',
		child_child_get = 'GetSetting',
		child_child_set = 'SetSetting',
		child_child_child_get = 'GetSetting',
		child_child_child_set = 'SetSetting',
		child_child_child_child_get = 'GetSetting',
		child_child_child_child_set = 'SetSetting',
		args = {
			{
				order = 1,
				type = 'keybinding',
				name = L['key1'],
				desc = L['key1_desc'],
				passValue = 'key1',
				disabled = InCombatLockdown,
			},
			{
				order = 2,
				type = 'keybinding',
				name = L['key2'],
				desc = L['key2_desc'],
				passValue = 'key2',
				disabled = InCombatLockdown,
			},
			{
				order = 2,
				type = 'keybinding',
				name = L['key3'],
				desc = L['key3_desc'],
				passValue = 'key3',
				disabled = InCombatLockdown,
			},
			{
				order = 3,
				type = 'execute',
				name = L.key_helper_name,
				desc = L.key_helper_desc,
				confirmText = L.key_helper_confirm,
				buttonText = L.key_helper_button,
				func = 'ImportKeys'
			},
			{
				order = 4,
				type = 'boolean',
				name = L.show_action_button_name,
				desc = L.show_action_button_desc,
				passValue = 'ShowActionButton',
				disabled = InCombatLockdown,
			},
			{
				order = 5,
				type = 'boolean',
				name = L.debug_name,
				desc = L.debug_desc,
				passValue = 'Debug',
			},
			
			self:CreateConfigGroup(1),
			self:CreateConfigGroup(2),
			self:CreateConfigGroup(3),

			{
				order = 20,
				type = 'group',
				name = L['help_name'],
				desc = L['help_desc'],
				args = {
					{
						order = 1,
						type = 'execute',
						name = L['help_help_name'],
						desc = L['help_help_desc'],
						buttonText = L['help_help_btn'],
						func = function() end,
					},
					{
						order = 2,
						type = 'group',
						groupType = 'inline',
						name = L['help_mounts_name'],
						desc = L['help_mounts_desc'],
						args = {
							{
								order = 1,
								type = 'string',
								name = L['help_mounts_reg'],
								desc = L['help_mounts_reg'],
								get = function() return ' ' .. L['help_mounts_reg'] end,
								usage = '',
								disabled = true,
							},
							{
								order = 2,
								type = 'string',
								name = L['help_mounts_sum'],
								desc = self.SpellLocale['Summon Charger'] .. ', ' .. self.SpellLocale['Summon Felsteed'] .. ', ...',
								get = function() return ' ' .. self.SpellLocale['Summon Charger'] .. ', ' .. self.SpellLocale['Summon Felsteed'] .. ', ...' end,
								usage = '',
								disabled = true,
							},
							{
								order = 3,
								type = 'string',
								name = L['help_mounts_dru'],
								desc = self.SpellLocale['Travel Form'] .. ', ' .. L['Flight / Swift Flight Form'],
								get = function() return ' ' .. self.SpellLocale['Travel Form'] .. ', ' .. L['Flight / Swift Flight Form'] end,
								usage = '',
								disabled = true,
							},
							{
								order = 4,
								type = 'string',
								name = L['help_mounts_sha'],
								desc = self.SpellLocale['Ghost Wolf'],
								get = function() return ' ' .. self.SpellLocale['Ghost Wolf'] end,
								usage = '',
								disabled = true,
							},
						},
					},
					{
						order = 3,
						type = 'execute',
						name = L['help_macro_name'],
						desc = L['help_macro_desc'],
						buttonText = L['help_macro_btn'],
						func = 'createMacro',
						disabled = InCombatLockdown,
					},
					{
						order = 4,
						type = 'execute',
						name = 'LibPeriodicTable-3.1',
						desc = L['help_libpt_desc'],
						buttonText = L['help_geturl'],
						func = function() self:DisplayURL([[http://files.wowace.com/LibPeriodicTable-3.1/LibPeriodicTable-3.1.zip]]) end,
					},
					{
						order = 5,
						type = 'execute',
						name = 'Menagerie',
						desc = L['help_menagerie_desc'],
						buttonText = L['help_geturl'],
						func = function() self:DisplayURL([[http://files.wowace.com/Menagerie/Menagerie.zip]]) end,
					},
					{
						order = 6,
						type = 'string',
						name = L['help_inspiration_name'],
						desc = L['help_inspiration_btn'],
						get = function() return L['help_inspiration_btn'] end,
						usage = '',
						disabled = true,
					},
					{
						order = 7,
						type = 'string',
						name = L['help_ranslator_name'],
						desc = L['translated_by'],
						get = function() return L['translated_by'] end,
						usage = '',
						disabled = true,
					},
					{
						order = 8,
						type = 'execute',
						name = L['help_donate'],
						desc = L['help_donate'],
						buttonText = L['help_donate'],
						func = function() self:DisplayURL([[https://www.paypal.com/de/cgi-bin/webscr?business=alex@kazik.de&item_number=Version%20]]..self.Version..[[%20%28]]..GetLocale()..[[%29&currency_code=]]..((GetLocale() == 'enUS' or GetLocale() == 'esMX') and 'USD' or 'EUR')..[[&cmd=_xclick&no_shipping=1&item_name=SmartMount]]) end,
					},
				},
			},
		},
	}

	self:SetConfigTable(self.options)
end

--
-- generate sub-menus
--

function SmartMount:CreateConfigGroup(number)
	local L = self.L

	return {
		order = 10 + number,
		type = 'group',
		name = L['config'..number..'_name'],
		desc = L['configX_desc'],
		args = {
			self:CreateConfigPage(number, 1, 'combat'),
			self:CreateConfigPage(number, 2, 'swim'),
			self:CreateConfigPage(number, 3, 'fly'),
			self:CreateConfigPage(number, 4, 'land'),
		}
	}
end

function SmartMount:CreateConfigPage(number, order, name)
	local L = self.L

	local page = {
		order = order,
		type = 'group',
		name = L[name..'_name'],
		desc = L[name..'_desc'],
		args = {
			m = {
				order = 1,
				type = 'group',
				groupType = 'inline',
				name = L['grp_mount_name'],
				desc = L['grp_mount_desc'],
				args = {}
			},
			d = {
				order = 2,
				type = 'group',
				groupType = 'inline',
				name = L['grp_dismount_name'],
				desc = L['grp_dismount_desc'],
				args = {}
			},
		}
	}

	-- combat page: add disable	
	if name == 'combat' then
		page['disabled'] = InCombatLockdown
	end -- if
	
	for _,v in pairs(self:getCfgMount(number, name, 'mnt')) do
		table.insert(page['args']['m']['args'], v)
	end -- for

	if name == 'fly' then
		-- add a button to dismount
		table.insert(page['args']['d']['args'], {
			order = 1,
			type = 'choice',
			choiceType = 'dict',
			choices = { [1] = L['grp_dismount_do_fly_no'], [2] = L['grp_dismount_do_fly_yes'], [3] = L['grp_dismount_do_fly_yes_groundonly'] },
			name = L['grp_dismount_do_name'],
			desc = L['grp_dismount_do_desc'],
			get = function() return (self:GetPref('c'..number..'-'..name..'-dis-do-groundonly') and 3) or ((self:GetPref('c'..number..'-'..name..'-dis-do') and 2) or 1) end,
			set = function(v) self:SetPref('c'..number..'-'..name..'-dis-do', v >= 2); self:SetPref('c'..number..'-'..name..'-dis-do-groundonly', v == 3) end,
		})
	elseif name == 'combat' then
		-- add a button to dismount
		table.insert(page['args']['d']['args'], {
			order = 1,
			type = 'choice',
			choiceType = 'dict',
			choices = { [false] = L['grp_dismount_do_combat_no'], [true] = L['grp_dismount_do_combat_yes'] },
			name = L['grp_dismount_do_name'],
			desc = L['grp_dismount_do_desc'],
			passValue = 'c'..number..'-'..name..'-dis-do',
		})
	else
		-- add a button to dismount
		table.insert(page['args']['d']['args'], {
			order = 1,
			type = 'boolean',
			name = L['grp_dismount_do_name'],
			desc = L['grp_dismount_do_desc'],
			passValue = 'c'..number..'-'..name..'-dis-do',
		})
	end -- if

	if name ~= 'combat' then
		for _,v in pairs(self:getCfgMount(number, name, 'dis')) do
			table.insert(page['args']['d']['args'], v)
		end -- for
	end -- if
	
	return page
end

function SmartMount:getCfgMount(number, name, mode)
	local L = self.L

	return
		{
			{
				order = 11,
				type = 'choice',
				name = L.grp_mount_1st,
				desc = L.grp_mount_1st2nd_desc,
				choices = function() return self:GetListOfMounts(name, mode) end,
				choiceIcons = 'GetListOfMountIcons',
				choiceOrder = 'GetListOfMountOrder',
				choiceType = 'dict',
				passValue = 'c'..number..'-'..name..'-'..mode..'-try1',
				disabled = function() return mode == 'dis' and not self:GetPref('c'..number..'-'..name..'-dis-do') end,
			},
			{
				order = 12,
				type = 'choice',
				name = L.grp_mount_2nd,
				desc = L.grp_mount_1st2nd_desc,
				choices = function() return self:GetListOfMounts(name, mode) end,
				choiceIcons = 'GetListOfMountIcons',
				choiceOrder = 'GetListOfMountOrder',
				choiceType = 'dict',
				passValue = 'c'..number..'-'..name..'-'..mode..'-try2',
				disabled = function() return mode == 'dis' and not self:GetPref('c'..number..'-'..name..'-dis-do') end,
			},
			{
				order = 13,
				type = 'choice',
				name = L.grp_mount_3rd,
				desc = L.grp_mount_3rd_desc,
				choices = function() return self:GetListOfMounts(name, mode) end,
				choiceIcons = 'GetListOfMountIcons',
				choiceOrder = 'GetListOfMountOrder',
				choiceType = 'dict',
				passValue = 'c'..number..'-'..name..'-'..mode..'-try3',
				disabled = function() return mode == 'dis' and not self:GetPref('c'..number..'-'..name..'-dis-do') end,
			},
		}
end


--
-- perform an action
--

function SmartMount:createMacro()
	if GetMacroIndexByName('SmartMount') == 0 then
		local icon, numicons, i = 1, GetNumMacroIcons()
		for i=1, numicons do
			if GetMacroIconInfo(i) == 'Interface\\Icons\\Ability_Mount_BlackPanther' then
				icon = i
			end -- if
		end -- for
		CreateMacro('SmartMount', icon, '/click [button:3] SmartMount_Button MiddleButton; [button:2] SmartMount_Button RightButton ; SmartMount_Button LeftButton', 1, 0)
	end
end

function SmartMount:DisplayURL(theLink)
	-- thanks to WIM
	
	-- The following code was written by the creator of Prat.
	StaticPopupDialogs['SMARTMOUNT_SHOW_URL'] = {
		text = '%s',
		button2 = TEXT(ACCEPT),
		hasEditBox = 1,
		hasWideEditBox = 1,
		--showAlert = 1, -- HACK : it's the only way I found to make de StaticPopup have sufficient width to show WideEditBox :(

		OnShow = function()
			local editBox = getglobal(this:GetName()..'WideEditBox');
			editBox:SetText(theLink);
			editBox:SetFocus();
			editBox:HighlightText(0);

			local button = getglobal(this:GetName()..'Button2');
			button:ClearAllPoints();
			button:SetWidth(200);
			button:SetPoint('CENTER', editBox, 'CENTER', 0, -30);

			--getglobal(this:GetName()..'AlertIcon'):Hide();  -- HACK : we hide the false AlertIcon
		end,

		OnHide = function() end,
		OnAccept = function() end,
		OnCancel = function() end,
		EditBoxOnEscapePressed = function() this:GetParent():Hide() end,
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1,
	}

	StaticPopup_Show('SMARTMOUNT_SHOW_URL', self.L['geturl_info']);
end

function SmartMount:ImportKeys()
	local key1, key2 = GetBindingKey('SMARTMOUNT_MOUNTORCONFIG')
	if key1 then
		SetBinding(key1)
	end -- if
	if key2 then
		SetBinding(key2)
	end -- if
	self:SetPref('key1', key1 or false)
	self:SetPref('key2', key2 or false)
	self:UpdateSettings()
	Rock('LibRockConfig-1.0'):RefreshConfigMenu(self)
end

--
-- get/set a key
--

function SmartMount:GetSetting(key)
	return self:GetPref(key)
end

function SmartMount:SetSetting(key, value)
	if value == self:GetPref(key) then
		-- no change: don't do anything
		return
	end
	
	-- preserve old value (currently not needed)
	-- local oldvalue = self:GetPref(key)
	
	-- update setting
	self:SetPref(key, value)
	
	-- check for duplicates
	if key == 'key1' then
		if value == self:GetPref('key2') then
			self:SetPref('key2', false)
		elseif value == self:GetPref('key3') then
			self:SetPref('key3', false)
		end
	elseif key == 'key2' then
		if value == self:GetPref('key1') then
			self:SetPref('key1', false)
		elseif value == self:GetPref('key3') then
			self:SetPref('key3', false)
		end
	elseif key == 'key3' then
		if value == self:GetPref('key1') then
			self:SetPref('key1', false)
		elseif value == self:GetPref('key2') then
			self:SetPref('key2', false)
		end
	end

	self:UpdateSettings()
end

--
-- sorted list of mounts
--

local function sort_fly(a, b)
	if a.s == 0 and b.s == 0 then
		-- both fly = 0: just primary speed
		if a.f == b.f then
			return a.m < b.m
		else
			return a.f < b.f
		end -- if
	else
		-- at laest one is flying: check ONLY fly speed
		if a.s == b.s then
			return a.m < b.m
		else
			return a.s < b.s
		end -- if
	end -- if
end

local function sort_fs(a, b)
	if a.f == b.f then
		if a.s == nil or a.s == b.s then
			return a.m < b.m
		else
			return a.s < b.s
		end -- if
	else
		return a.f < b.f
	end -- if
end

local function ppp(n)
	if not n then
		return '--'
	elseif n < 100 then
		return (n - 99) .. '%'
	elseif n > 100 then
		return '+' .. (n - 100) .. '%'
	else
		return '±0%'
	end -- if
end

function SmartMount:GetListOfMounts(name, mode)
	local MustCanCombat = false
	local MustCanSwim = false
	local MustCanFly = false
	local MustCanLand = false

	local MustCanSpecial = false

	if mode == 'dis' then
		MustCanSpecial = true
	end -- if
	
	if name == 'combat' then
		MustCanCombat = true
	elseif name == 'swim' then
		MustCanSwim = true
	elseif name == 'fly' then
		MustCanFly = true
	else -- if name == 'land' then
		MustCanLand = true
	end -- if

	local first, second, sortfn, secondbr
	
	if MustCanSpecial then
		self.chooseMounts = { ['off'] = ' - ' .. self.L['mount_dis_off'] }
		first = false
		sortfn = sort_fs
		secondbr = false
	elseif MustCanLand then
		self.chooseMounts = { ['off'] = ' - ' .. self.L['mount_mnt_off'] .. ': ' .. ppp(100) .. '' }
		first = 'land'
		second = 'fly'
		sortfn = sort_fly
		secondbr = false
	elseif MustCanFly then
		self.chooseMounts = { ['off'] = ' - ' .. self.L['mount_mnt_off'] .. ': ' .. ppp(100) .. '' }
		first = 'fly'
		second = '__'
		sortfn = sort_fly
		secondbr = false
	elseif MustCanSwim then
		self.chooseMounts = { ['off'] = ' - ' .. self.L['mount_mnt_off'] .. ': ' .. ppp(66) .. '' }
		first = 'swim'
		second = '__'
		sortfn = sort_fs
		secondbr = false
	else --if MustCanCombat then
		self.chooseMounts = { ['off'] = ' - ' .. self.L['mount_mnt_off'] .. ': ' .. ppp(100) .. ' (' .. ppp(66) .. ')' }
		first = 'land'
		second = 'swim'
		sortfn = sort_fs
		secondbr = true
	end -- if
	self.chooseMountIcons = { ['off'] = 'Interface\\Icons\\Temp'}
	self.chooseMountOrder = {}
	table.insert(self.chooseMountOrder, {a = 'off', f = -100, s = 0, m = '' })
	if MustCanLand and not MustCanSpecial then
		self.chooseMounts['rnd_fast'] = ' ' .. self.L['mount_rnd_fast']
		self.chooseMountIcons['rnd_fast'] = 'Interface\\Icons\\INV_Gizmo_RocketBootExtreme'
		table.insert(self.chooseMountOrder, {a = 'rnd_fast', f = -50, s = 0, m = '' })
		self.chooseMounts['rnd_all'] = ' ' .. self.L['mount_rnd_any']
		self.chooseMountIcons['rnd_all'] = 'Interface\\Icons\\INV_Gizmo_RocketBoot_01'
		table.insert(self.chooseMountOrder, {a = 'rnd_all', f = -25, s = 0, m = '' })
	end -- if
	if ( MustCanSpecial and not MustCanCombat and not MustCanFly ) or MustCanLand then
		if AceLibrary and AceLibrary:HasInstance('LibPeriodicTable-3.1') then
			self.chooseMounts['rnd_pet'] = ' - ' .. self.L['mount_rnd_pet']
		else
			self.chooseMounts['rnd_pet'] = ' - ' .. self.L['mount_rnd_pet_req']
		end -- if
		self.chooseMountIcons['rnd_pet'] = 'Interface\\Icons\\INV_Jewelcrafting_GoldenHare'
		table.insert(self.chooseMountOrder, {a = 'rnd_pet', f = -5, s = 0, m = '' })
	end -- if
	
	for k, v in pairs(self.ListOfMounts) do
		if (not MustCanCombat or v.incombat) and (not MustCanSwim or v.inwater) and (not MustCanFly or v.inair) and (not MustCanLand or v.onground) and (not MustCanSpecial or not v.mount) then
			local fspeed
			local sspeed
			if first then
				fspeed = v[first]
				sspeed = v[second]
				if secondbr then
					-- 'xxx% (xxx%): '
					self.chooseMounts[v.action] = ' ' .. ppp(fspeed) .. ' (' .. ppp(sspeed) .. '): ' .. v.name
				elseif sspeed then
					-- 'xxx% / xxx%: '
					self.chooseMounts[v.action] = ' ' .. ppp(fspeed) .. ' / ' .. ppp(sspeed) .. ': ' .. v.name
				else
					-- 'xxx%: '
					self.chooseMounts[v.action] = ' ' .. ppp(fspeed) .. ': ' .. v.name
				end -- if
			else
				fspeed, sspeed = 0, 0
				self.chooseMounts[v.action] = ' ' .. v.name
			end -- if
			self.chooseMountIcons[v.action] = v.icon
			table.insert(self.chooseMountOrder, {a = v.action, f = fspeed or 100, s = sspeed or 0, m = v.name})
		end -- if
	end -- for
	
	table.sort(self.chooseMountOrder, sortfn)
	for k,v in pairs(self.chooseMountOrder) do
		self.chooseMountOrder[k] = v.a
	end -- for
	
	return self.chooseMounts
end

function SmartMount:GetListOfMountIcons()
	return self.chooseMountIcons
end

function SmartMount:GetListOfMountOrder()
	return self.chooseMountOrder
end

