
if Rock and Rock:HasLibrary('LibRockConfig-1.0') and Rock:HasLibrary('LibRockLocale-1.0') and Rock:HasLibrary('LibRockDB-1.0') then
	SmartMount = Rock:NewAddon('SmartMount', 'LibRockConfig-1.0', 'LibRockDB-1.0')
	SmartMount.L = Rock('LibRockLocale-1.0'):GetTranslationNamespace('SmartMount')
	
	BINDING_HEADER_SMARTMOUNT = 'Smart Mount'
	BINDING_NAME_SMARTMOUNT_MOUNTORCONFIG = SmartMount.L['Show Options']

	SmartMount:SetDatabase('SmartMount_Config')
	
	SmartMount.Version = '1.1'
	
	SmartMount.rock = true
else
	SmartMount = {}

	-- no Rock: only english
	BINDING_HEADER_SMARTMOUNT = 'Smart Mount'
	BINDING_NAME_SMARTMOUNT_MOUNTORCONFIG = 'Mount'

	SmartMount.db = { profile = {} }
	
	SmartMount.rock = false
	
end -- if

SmartMount.currentPet = '-'

function SmartMount:OnLoad()
	SLASH_SMARTMOUNT1 = '/smartmount';
	SlashCmdList['SMARTMOUNT'] = SmartMount_HelpOrConfig
	if self.rock then
		this:RegisterEvent('PLAYER_REGEN_DISABLED')
		this:RegisterEvent('PLAYER_REGEN_ENABLED')
		self:SetDatabaseDefaults('profile', self.ConfigDefaults)
	else
		this:RegisterEvent('PLAYER_LOGIN')
	end
	this:RegisterEvent('PLAYER_ENTERING_WORLD');
end

function SmartMount:OnEvent(event)
	-- only get's called without rock
	if event == 'PLAYER_LOGIN' then
		self:CheckConfig()
		self:InitClick()
		self:HijackBindings(false)

		-- hide action button
		SmartMount_Button:Hide()

		-- for debugging without rock, uncomment the following line
		-- SmartMount.db.profile[SmartMount.ConfigVersion].Debug = true

	elseif event == 'PLAYER_REGEN_DISABLED' or event == 'PLAYER_REGEN_ENABLED' then
		-- disable some configs while in combat
		Rock('LibRockConfig-1.0'):RefreshConfigMenu(self)
	elseif event == 'PLAYER_ENTERING_WORLD' then
		self.currentPet = '-'
	end -- if
end

function SmartMount:MountOrConfig()
	if self.rock then
		self:InitClick()
		self:OpenConfigMenu()
	else
		self:HijackBindings(true)
	end
end

function SmartMount_HelpOrConfig()
	if SmartMount.rock then
		SmartMount:InitClick()
		SmartMount:OpenConfigMenu()
	else
		DEFAULT_CHAT_FRAME:AddMessage('|cff3fcf26SmartMount|r: If you want to configure SmartMount (the One-Key-Mount™) please install LibRock-1.0, LibRockConfig-1.0 and LibRockLocale-1.0.')
		DEFAULT_CHAT_FRAME:AddMessage('|cff3fcf26SmartMount|r: Even with this default configuration you should have much fun!')
		DEFAULT_CHAT_FRAME:AddMessage('|cff3fcf26SmartMount|r: For an use in a macro, use |cff3fcf26/click SmartMount_Button|r.')
	end
end

function SmartMount:GetPref(k)
	return self.db.profile[self.ConfigVersion][k]
end

function SmartMount:SetPref(k, v)
	self.db.profile[self.ConfigVersion][k] = v
end

-- for debugging

function SmartMount:dump(na, va, hide)
	-- for debugging without rock, see near line 50

	-- debug only when needed
	if not self:GetPref('Debug') then return end

	-- output	
	local t
	
	-- name
	if(na ~= nil)then
		t = self:dump(nil, na, true)..': '
	else
		t = ''
	end

	-- data
	local ty = type(va)
	if(ty == 'table')then
		t = t .. '{ '
		for k,v in pairs(va) do
			t = t .. self:dump(k, v, true) .. ', '
		end
		t = t .. '}'
	elseif(ty == 'string')then
		t = t .. '\'' .. va .. '\''
	elseif(ty == 'number')then
		t = t .. va
	elseif(ty == 'boolean')then
		t = t .. ((va and 'true') or 'false')
	else
		t = t .. '(' .. ty .. ')'
	end
	
	if(hide)then
		return t
	else
		DEFAULT_CHAT_FRAME:AddMessage('dump: '..t)
	end
end
