﻿-- Author      : Administrator
-- Create Date : 9/10/2008 6:44:47 PM
SLICECMDR = { };
SLICECMDR.AlertPending = 0;
SLICECMDR.LastTime = 0;
SLICECMDR.BarFont = 0;
SLICECMDR.LastEnergy = 0;


function SliceCmdr_MoveStart()
	if (SliceCmdr_Save.IsLocked == false) then
		VTimer:StartMoving();
	 end
end

function SliceCmdr_MoveStop()
	if (SliceCmdr_Save.IsLocked == false) then
		VTimer:StopMovingOrSizing();
	end		
end

function SliceCmdr_SoundTest(name) 
	if (SliceCmdr_Sounds[name]) then
		PlaySoundFile( SliceCmdr_Sounds[name] );
	end
end

function SliceCmdr_Sound(saved) 
	if (SliceCmdr_Save[saved]) then
		PlaySoundFile( SliceCmdr_Sounds[ SliceCmdr_Save[saved] ] );
	end
end

function SliceCmdr_OnEvent(self, event, ...)
	local timestamp, type, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags = select(1, ...);
	if (event == "COMBAT_LOG_EVENT_UNFILTERED") then
		if (type == "SPELL_AURA_REMOVED") then
			local spellId, spellName, spellSchool = select(9, ...);
			if ((spellName == "Slice and Dice") and (destName == UnitName("player"))) then
				if (UnitAffectingCombat("player")) then
					SliceCmdr_Sound("Fail");
				else
					SliceCmdr_Sound("Expire");
				end					
			end
		end
	end
end

function SliceCmdr_Unload()
	VTimer:UnregisterAllEvents();
	VTimer:Hide();
end

function SliceCmdr_OnLoad()
	local localizedClass, englishClass = UnitClass("player");
	if (englishClass == "ROGUE") then
		VTimer:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		SLICECMDR.BarFont = CreateFont("VTimerFont");
		SLICECMDR.BarFont:SetFont("Fonts\\FRIZQT__.TTF", 12)
		SLICECMDR.BarFont:SetShadowColor(0,0,0, 0.7);
		SLICECMDR.BarFont:SetTextColor(1,1,1,1);
		SLICECMDR.BarFont:SetShadowOffset(0.8, -0.8);
		SLICECMDR.LastEnergy = UnitMana('player');
		
		VTimerEnergyTxt:SetFontObject(SLICECMDR.BarFont);
		VTimerSNDTxt:SetFontObject(SLICECMDR.BarFont);
		--VTimerEnergyTxt:SetShadowColor(0,0,0);
		
		
		VTimerEnergy:SetMinMaxValues(0,UnitManaMax("player"));
		VTimerEnergy:SetBackdrop({
		  bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
		  edgeFile="",
		  tile=true, tileSize=1, edgeSize=0,
		  insets={left=0, right=0, top=0, bottom=0}
		});
		--"Interface\\TargetingFrame\\UI-StatusBar"
		VTimerEnergy:SetBackdropBorderColor(1,1,1,1);
		VTimerEnergy:SetBackdropColor(0,0,0,0.2);
		VTimerEnergy:SetStatusBarTexture("Interface\\AddOns\\SliceCommander\\Images\\Smooth.tga");
		VTimerEnergy:SetStatusBarColor(1, 0.843137264, 0, 1); -- gold
		SliceCmdr_OnUpdate();

		VTimerSND:SetMinMaxValues(0, 3);
		VTimerSND:SetValue(0);
		VTimerSND:SetStatusBarTexture("Interface\\AddOns\\SliceCommander\\Images\\Smooth.tga");
		VTimerSND:SetStatusBarColor(1, 0.549019635, 0, 1); -- dark orange
		
		SliceCmdr_Config_OtherVars();
		
	else
		SliceCmdr_Unload();
		return;
	end
	
end

function VTimer_util_SnDBuffTime()
	for i=0,31 do
		local id,cancel = GetPlayerBuff(i,"HELPFUL|HARMFUL|PASSIVE");
		local buffText = GetPlayerBuffTexture(id);	
		if(id > 0 and buffText and string.find(buffText,"Ability_Rogue_SliceDice")) then
			local timeleft = GetPlayerBuffTimeLeft(id);
			if (SLICECMDR.LastTime < timeleft) then
				-- spell buff was applied
				if (SLICECMDR.LastTime > 0) then
					if (SLICECMDR.LastTime > 3) then
						-- regular refresh
						SliceCmdr_Sound("Applied");
					else
						if (SLICECMDR.LastTime <= 1) then
							-- best award
							SliceCmdr_Sound("Apply1");
						else
							if (SLICECMDR.LastTime <= 2) then
								-- average award
								SliceCmdr_Sound("Apply2");
							else
								-- standard reward
								SliceCmdr_Sound("Apply3");
							end
						end
					end					
				else
					-- initial cast
					SliceCmdr_Sound("Applied");
				end
			end
			SLICECMDR.LastTime = timeleft;
			return timeleft;
		end
	end
	SLICECMDR.LastTime = 0;
	return 0;
end

function SliceCmdr_SNDCooldown() 
	local x = VTimer_util_SnDBuffTime();

	if (x > 0) then
		if (x <= 3) then
			if (SLICECMDR.AlertPending == 3) then
				SliceCmdr_Sound("Tick3");
				SLICECMDR.AlertPending = 2;
			else 
				if (x <= 2) then
					if (SLICECMDR.AlertPending == 2) then
						SliceCmdr_Sound("Tick2");
						SLICECMDR.AlertPending = 1;
					else 
						if (x <= 1) then
							if (SLICECMDR.AlertPending == 1) then
								SliceCmdr_Sound("Tick1");
								SLICECMDR.AlertPending = 0;
							end
						end
					end
				end
			end
		else
			SLICECMDR.AlertPending = 3;
		end
		
	end
	
	VTimerSND:SetValue(x);
	if (x > 0) then
		VTimerSNDTxt:SetText(string.format("%0.1f", x));
	else
		VTimerSNDTxt:SetText("");
	end		

end

function SliceCmdr_OnUpdate()
	VTimerEnergy:SetValue(UnitMana("player"));
	VTimerEnergy:SetMinMaxValues(0,UnitManaMax("player"));
	VTimerEnergyTxt:SetText(UnitMana("player"));
	SliceCmdr_Config_OtherVars();
	
	if (SLICECMDR.LastEnergy < UnitMana('player')) then
		if ((SLICECMDR.LastEnergy < SliceCmdr_Save.Energy2) and (UnitMana('player') >= SliceCmdr_Save.Energy2)) then
			SliceCmdr_Sound("EnergySound2");
		else
			if ((SLICECMDR.LastEnergy < SliceCmdr_Save.Energy1) and (UnitMana('player') >= SliceCmdr_Save.Energy1)) then
				SliceCmdr_Sound("EnergySound1");
			end
		end
	end
	
	SLICECMDR.LastEnergy = UnitMana('player');
	SliceCmdr_SNDCooldown();
end