-- Simple Raid Target Icons
--
--------------------------------
--                            --
-- Concept originally by Qzot --
--                            --
--------------------------------

local srti = {};
srti.version = GetAddOnMetadata("simpleraidtargeticons","version");

SRTI_TITLE = "SimpleRaidTargetIcons";
SRTI_HEADER = SRTI_TITLE .. " " .. srti.version;

SRTI_MSG_OUT_OF_RANGE = SRTI_TITLE .. " - %1Party leader is out of range of target.";
SRTI_MSG_PROMOTED = SRTI_TITLE .. " - %1Promoted";
SRTI_MSG_NOT_PROMOTED = SRTI_TITLE .. " - %1Not Promoted";
SRTI_MSG_DEMOTED = SRTI_TITLE .. " - %1Demoted";

SRTI_MSG_HELP_TEXT = SRTI_HEADER .. " - %0/srti\n no command opens the options menu\n commands to set icon on target";

SRTI_UNIT_SRTI = "SRTI";
SRTI_UNIT_ASSISTANTS = "SRTI Assistants";
SRTI_UNIT_ASSISTANT = "SRTI Assistant";
SRTI_UNIT_ASSISTANT_PROMOTE = "Promote SRTI Assistant";
SRTI_UNIT_ASSISTANT_PROMOTE_TEXT = "Promotes party member to SRTI assistant.";
SRTI_UNIT_ASSISTANT_DEMOTE = "Demote SRTI Assistant";
SRTI_UNIT_ASSISTANT_DEMOTE_TEXT = "Demotes party member from SRTI assistant.";
SRTI_UNIT_ASSISTANT_NOT_PROMOTED = "SRTI Not Promoted";
SRTI_UNIT_ASSISTANT_DISABLED = "SRTI Disabled";

SRTI_OPTIONS_HEADER = "Radial Menu Options";
SRTI_OPTIONS_SINGLE_HEADER = "Left Click";
SRTI_OPTIONS_SINGLE_MODIFIERS = "Modifiers";
SRTI_OPTIONS_SINGLE_CTRL = "Ctrl";
SRTI_OPTIONS_SINGLE_ALT = "Alt";
SRTI_OPTIONS_SINGLE_SHIFT = "Shift";
SRTI_OPTIONS_DOUBLE_HEADER = "Double Left Click";
SRTI_OPTIONS_DOUBLE_ENABLE = "Enable";
SRTI_OPTIONS_DOUBLE_SPEED = "Double Click Speed - %s sec";
SRTI_OPTIONS_DOUBLE_SPEED_MIN = "Quick";
SRTI_OPTIONS_DOUBLE_SPEED_MAX = "Slow";
SRTI_OPTIONS_BINDING_HEADER = "Key Bindings";
SRTI_OPTIONS_HOVER = "Select Icon on Hover";
SRTI_OPTIONS_HOVER_TIME = "Hover Wait Time - %s sec";
SRTI_OPTIONS_HOVER_TIME_MIN = "Quick";
SRTI_OPTIONS_HOVER_TIME_MAX = "Slow";
SRTI_OPTIONS_TEST = "Test Me";
SRTI_OPTIONS_TEST_HELP = "Click above to test settings";

SRTI_BINDINGS_BIND_HELP = "|cffffffffPress a key to bind |r%s";
SRTI_BINDINGS_BIND_WARN_KEY = "|cffff0000%s Function will be Unbound from this Key!";
SRTI_BINDINGS_BIND_WARN_UNBOUND = "|cffff0000%s Function will be Unbound!";
SRTI_BINDINGS_UNBIND_HELP = "|cffff0000You are about to unbind key from |r%s";
SRTI_BINDINGS_ESC = "Press |cffffffffEsc|r to cancel";

BINDING_HEADER_SRTI_TITLE = SRTI_TITLE;
BINDING_NAME_SRTI_SHOW = "Show Radial Menu";
BINDING_NAME_SRTI_STAR = "Yellow Star Icon";
BINDING_NAME_SRTI_CIRCLE = "Orange Circle Icon";
BINDING_NAME_SRTI_DIAMOND = "Purple Diamond Icon";
BINDING_NAME_SRTI_TRIANGLE = "Green Triangle Icon";
BINDING_NAME_SRTI_MOON = "Silver Moon Icon";
BINDING_NAME_SRTI_SQUARE = "Blue Square Icon";
BINDING_NAME_SRTI_CROSS = "Red Cross Icon";
BINDING_NAME_SRTI_SKULL = "White Skull Icon";
BINDING_NAME_SRTI_CLEAR = "Remove Icon";

local iconStrings = {
	none = 0,
	clear = 0,
	remove = 0,
	yellow = 1,
	star = 1,
	orange = 2,
	circle = 2,
	purple = 3,
	diamond = 3,
	green = 4,
	triangle = 4,
	silver = 5,
	moon = 5,
	blue = 6,
	square = 6,
	red = 7,
	x = 7,
	cross = 7,
	white = 8,
	skull = 8,
};

local iconNames = {
	"remove icon",
	"yellow star",
	"orange circle",
	"purple diamond",
	"green triangle",
	"silver moon",
	"blue square",
	"red cross",
	"white skull",
};

function srti.Print(msg)
	for text in string.gmatch(msg, "[^\n]+") do
		text = string.gsub(text,"%%1","|cffffcc00");
		text = string.gsub(text,"%%0(%S+)","|cff9999ff%1|r");
		DEFAULT_CHAT_FRAME:AddMessage(text,0.7,0.7,0.7);
	end
end

local function print(msg)
	srti.Print(msg);
end

function srti.PrintHelp()
	print(SRTI_MSG_HELP_TEXT);
	for i=0, 8 do
		local text = "";
		for string, index in pairs(iconStrings) do
			if ( index == i ) then
				text = text.." / %0"..string;
			end
		end

		print("  %0"..i..text.." - %1"..iconNames[i+1]);
	end
end

srti.defaults = {
	["ctrl"] = true,
	["alt"] = false,
	["shift"] = false,
	["singlehover"] = false,

	["double"] = true,
	["speed"] = 0.25,
	["doublehover"] = false,

	["bindinghover"] = false,

	["hovertime"] = 0.2,
};

-- srti.promoted
-- promotion / srti status

-- srti.assistants
-- list of promoted people

-- srti.frame
-- the main menu frame and event catcher

srti.frame = CreateFrame("button", "SRTIRadialMenu", UIParent);

srti.frame:RegisterForClicks("LeftButtonUp", "RightButtonUp");
srti.frame:RegisterEvent("ADDON_LOADED");
srti.frame:RegisterEvent("PLAYER_TARGET_CHANGED");
srti.frame:RegisterEvent("CHAT_MSG_ADDON");
srti.frame:RegisterEvent("PARTY_MEMBERS_CHANGED");
srti.frame:RegisterEvent("PLAYER_ENTERING_WORLD");

srti.frame:SetFrameStrata("DIALOG");

srti.frame:SetWidth(100);
srti.frame:SetHeight(100);
srti.frame:SetPoint( "CENTER", UIParent, "BOTTOMLEFT", 0, 0 );

srti.frame:Hide();
srti.frame.origShow = srti.frame.Show;

function srti.frame:Show()
	srti.frame.p = srti.frame:CreateTexture("SRTIRadialMenuPortrait","BORDER");
	srti.frame.p:SetWidth(40);
	srti.frame.p:SetHeight(40);
	srti.frame.p:SetPoint("CENTER", srti.frame, "CENTER", 0, 0 );
	srti.frame.b = srti.frame:CreateTexture("SRTIRadialMenuBorder", "BACKGROUND");
	srti.frame.b:SetTexture("Interface\\Minimap\\UI-TOD-Indicator");
	srti.frame.b:SetWidth(80);
	srti.frame.b:SetHeight(80);
	srti.frame.b:SetTexCoord(0.5,1,0,1);
	srti.frame.b:SetPoint("CENTER", srti.frame, "CENTER", 10, -10 );
	for i=1, 8 do
		srti.frame[i] = srti.frame:CreateTexture("SRTIRadialMenu"..i,"OVERLAY");
	end

	srti.frame:origShow();
	srti.frame.Show = srti.frame.origShow;
	srti.frame.origShow = nil;

	srti.frame:SetScript("OnUpdate", function()
			local portrait = srti.frame.portrait;
			srti.frame.portrait = nil;
			local saved, index = this.i, GetRaidTargetIndex("target");
			this.i = nil;
			if ( this.test ) then
				index = srti.menu.test.index or 0;
			end
			local curtime = GetTime();
			if ( not this.h ) then
				if ( this.test ) then
					SetPortraitTexture( srti.frame.p, "player" );
				elseif ( not UnitExists("target") or ( not UnitPlayerOrPetInRaid("target") and UnitIsDeadOrGhost("target") ) ) then
					if ( portrait ) then
						this:Hide();
						return;
					else
						this.h = curtime;
					end
				elseif ( portrait ) then
					if ( portrait == 0 and not UnitIsUnit("target","mouseover") ) then
						this:Hide();
						return;
					end
					PlaySound("igMainMenuOptionCheckBoxOn");
					SetPortraitTexture( srti.frame.p, "target" );
				end

				local x, y = GetCursorPosition();
				local s = srti.frame:GetEffectiveScale();
				local mx, my = srti.frame:GetCenter();
				x = x / s;
				y = y / s;

				local a, b = y - my, x - mx;

				local dist = floor(math.sqrt( a*a + b*b ));

				if ( dist > 60 ) then
					if ( dist > 200 ) then
						this.l = nil;
						this.h = curtime;
						this.s = nil;
						PlaySound("igMainMenuOptionCheckBoxOff");
					elseif ( not this.l ) then
						this.l = curtime;
					end
				else
					this.l = nil;

					if ( dist > 20 and dist < 50 ) then
						local pos = math.deg(math.atan2( a, b )) + 27.5;
						this.i = mod(11-ceil(pos/45),8)+1;
					end
				end

				for i=1, 8 do
					local t = this[i];
					if ( index == i ) then
						t:SetTexCoord(0,1,0,1);
						t:SetTexture("Interface\\Buttons\\UI-GroupLoot-Pass-Up");
					else
						t:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons");
						SetRaidTargetIconTexture(t,i);
					end
				end

				if ( this.c ) then
					if ( this.i and ( not saved or saved == this.i ) ) then
						this.c = this.c + arg1;
						if ( this.c > ( SRTISaved.hovertime or 0.2 ) ) then
							this:Click();
						end
					else
						this.c = 0;
					end
				end
			end

			if ( this.s ) then
				local status = curtime - this.s;
				if ( status > 0.1 ) then
					srti.frame.p:SetAlpha(1);
					srti.frame.b:SetAlpha(1);
					for i=1, 8 do
						local t, radians = this[i], (0.375 - i/8) * 360;
						t:SetPoint("CENTER", this, "CENTER", 36*cos(radians), 36*sin(radians) );
						t:SetAlpha(0.5);
						t:SetWidth(18);
						t:SetHeight(18);
					end
					this.s = nil;
				else
					status = status / 0.1;
					srti.frame.p:SetAlpha(status);
					srti.frame.b:SetAlpha(status);
					for i=1, 8 do
						local t, radians = this[i], (0.375 - i/8) * 360;
						t:SetPoint("CENTER", this, "CENTER", (20*status + 16)*cos(radians), (20*status + 16)*sin(radians) );
						if ( i == index ) then
							t:SetAlpha(status);
						else
							t:SetAlpha(0.5*status);
						end
						t:SetWidth(9*status + 9);
						t:SetHeight(9*status + 9);
					end
				end
			elseif ( this.h ) then
				local status = curtime - this.h;
				if ( status > 0.1 ) then
					this.h = nil;
					this:Hide();
				else
					status = 1 - status / 0.1;
					srti.frame.p:SetAlpha(status);
					srti.frame.b:SetAlpha(status);
					for i=1, 8 do
						local t, radians = this[i], (0.375 - i/8) * 360;
						if ( this.i == i ) then
							t:SetWidth(36-18*status);
							t:SetHeight(36-18*status);
							t:SetAlpha(min(4*status,1));
						else
							t:SetPoint("CENTER", this, "CENTER", (20*status + 16)*cos(radians), (20*status + 16)*sin(radians) );
							t:SetAlpha(0.75*status);
							t:SetWidth(18*status);
							t:SetHeight(18*status);
						end
					end
				end
			else
				for i=1, 8 do
					local t = this[i];
					if ( i == index ) then
						t:SetAlpha(1);
					else
						t:SetAlpha(0.75);
					end
					t:SetWidth(18);
					t:SetHeight(18);
				end
			end

			if ( this.i ) then
				local t = this[this.i];
				local a, w = t:GetAlpha(), t:GetWidth();

				if ( not this.t or saved ~= this.i ) then
					this.t = curtime;
				end
				local s = 1 + min( (curtime - this.t)/0.05, 1 );

				t:SetAlpha(min(a+0.125*s,1));
				t:SetWidth(w*s);
				t:SetHeight(w*s);
			end

			if ( this.l ) then
				local status = curtime - this.l;
				if ( status > 0.75 ) then
					this.h = curtime;
					this.l = nil
					this.s = nil
					this.i = nil;
					PlaySound("igMainMenuOptionCheckBoxOff");
				end
			end
		end
		);

	srti.frame:SetScript("OnClick", function()
			if ( not this.h ) then
				local index = GetRaidTargetIndex("target");
				if ( this.test ) then
					index = srti.menu.test.index;
				end
				if ( ( arg1 == "RightButton" and index and index > 0 ) or ( this.i and this.i > 0 and this.i == index ) ) then
					this.i = index;
					PlaySound("igMiniMapZoomOut");
					srti.SetRaidTarget(0);
				elseif ( this.i ) then
					PlaySound("igMiniMapZoomIn");
					srti.SetRaidTarget(this.i);
				else
					PlaySound("igMainMenuOptionCheckBoxOff");
				end
				this.s = nil;
				this.h = GetTime();
			end
		end
		);

	--[[srti.frame:SetScript("OnShow", function()
			SetOverrideBinding(srti.frame,false,"W",RAIDTARGET1);
			SetOverrideBinding(srti.frame,false,"E",RAIDTARGET2);
			SetOverrideBinding(srti.frame,false,"D",RAIDTARGET3);
			SetOverrideBinding(srti.frame,false,"C",RAIDTARGET4);
			SetOverrideBinding(srti.frame,false,"X",RAIDTARGET5);
			SetOverrideBinding(srti.frame,false,"Z",RAIDTARGET6);
			SetOverrideBinding(srti.frame,false,"A",RAIDTARGET7);
			SetOverrideBinding(srti.frame,false,"Q",RAIDTARGET8);
			--SetOverrideBindingClick(srti.frame,false,"W","SRTIRadialMenu");
			--SetOverrideBindingClick(srti.frame,false,"S","SRTIRadialMenu","RightButton");
		end
		);
	srti.frame:SetScript("OnHide", function()
			ClearOverrideBindings(srti.frame);
		end
		);--]]
end

function srti.UpdateSaved()
	if ( not SRTISaved ) then
		SRTISaved = {};
	end
	for k, v in pairs(srti.defaults) do
		if ( SRTISaved[k] == nil ) then
			SRTISaved[k] = v;
		end
	end
	SRTISaved.assistants = SRTISaved.assistants or {};

	srti.saved = SRTISaved;
end

srti.frame:SetScript("OnEvent", function()
	if ( event == "CHAT_MSG_ADDON" ) then
		if ( arg1 == "SRTI" ) then
			if ( IsPartyLeader() ) then
				if ( arg2 == "REQUEST" ) then
					srti.UpdateAssistants();
				elseif ( SRTISaved.assistants[arg4] ) then
					local index = tonumber(arg2:match("^ICON (%d+)$"));
					local name, unit, target;
					if ( index ) then
						target = 1;
						name = arg4;
					else
						name, index = arg2:match("^PARTY (%S+) (%d)$");
						index = tonumber(index);
					end
					if ( name ) then
						if ( name == UnitName("player") ) then
							unit = "player";
						else
							for i=1, GetNumPartyMembers() do
								if ( name == UnitName("party"..i) ) then
									unit = "party"..i;
									break;
								end
							end
						end
					end
					if ( unit and index ) then
						if ( target ) then
							if ( UnitExists(unit.."target") ) then
								SetRaidTarget( unit.."target", index );
							else
								SendAddonMessage("SRTI","FAILED "..arg4,"PARTY");
							end
						else
							SetRaidTarget( unit, index );
						end
					end
				end
			else
				if ( arg2:match("PROMOTE "..(UnitName("player"))) ) then
					if ( srti.lastpromoted ~= 1 ) then
						print(SRTI_MSG_PROMOTED);
					end
					srti.promoted = 1;
				elseif ( arg2:match("DEMOTE "..(UnitName("player"))) ) then
					if ( srti.lastpromoted == 1 ) then
						print(SRTI_MSG_DEMOTED);
					elseif ( srti.lastpromoted == nil ) then
						print(SRTI_MSG_NOT_PROMOTED);
					end
					srti.promoted = 0;
				elseif ( arg2:match("FAILED "..(UnitName("player"))) ) then
					print(SRTI_MSG_OUT_OF_RANGE);
				end
			end
		end
	elseif ( event == "PLAYER_ENTERING_WORLD" ) then
		this:UnregisterEvent("PLAYER_ENTERING_WORLD");
		if ( GetNumPartyMembers() > 0 and GetNumRaidMembers() == 0 and not IsPartyLeader() ) then
			SendAddonMessage("SRTI","REQUEST","PARTY");
		end
	elseif ( event == "PARTY_MEMBERS_CHANGED" ) then
		srti.lastpromoted = srti.promoted or srti.lastpromoted;
		srti.promoted = nil;
		if ( GetNumPartyMembers() > 0 and GetNumRaidMembers() == 0 and not IsPartyLeader() ) then
			SendAddonMessage("SRTI","REQUEST","PARTY");
		else
			srti.lastpromoted = nil;
		end
	elseif ( event == "ADDON_LOADED" ) then
		this:UnregisterEvent("ADDON_LOADED");
		srti.UpdateSaved();
	else
		if ( this:IsVisible() and not this.e and not this.h ) then
			this.i = nil;
			this.s = nil;
			this.h = GetTime();
			PlaySound("igMainMenuOptionCheckBoxOff");
			this.e = nil;
		elseif ( this.e ) then
			this.e = nil;
		end
	end
end
);

function srti.ShowFromBinding()
	if ( not srti.frame:IsVisible() ) then
		local c = nil;
		if ( SRTISaved.bindinghover ) then
			c = 0;
		end
		if ( srti.menu and srti.menu:IsVisible() ) then
			srti.menu.test.ShowRadial(c);
		else
			srti.frame.c = c;
			srti.Show(1);
		end
	end
end

function srti.Show(frombinding)
	if ( SRTISaved.debug == nil and not IsPartyLeader() and srti.promoted ~= 1 ) then
		local num = GetNumRaidMembers();
		if ( num == 0 ) then
			return;
		end

		local rank = select(2,GetRaidRosterInfo(num));
		if ( rank == 0 ) then return; end
	end

	srti.frame.s = GetTime();
	srti.frame.h = nil;
	srti.frame.i = nil;
	srti.frame.l = nil;
	srti.frame.test = nil;
	if ( UnitExists("target") and (frombinding or UnitIsUnit("target","mouseover")) ) then
		srti.frame.e = nil;
	else
		srti.frame.e = 1;
	end
	srti.frame.portrait = frombinding or 0;

	local x,y = GetCursorPosition();
	local s = srti.frame:GetEffectiveScale();
	srti.frame:SetPoint( "CENTER", UIParent, "BOTTOMLEFT", x/s, y/s );
	srti.frame:Show();
end

function srti.AreModifiersDown()
	if ( not SRTISaved.ctrl and not SRTISaved.alt and not SRTISaved.shift ) then
		return;
	elseif ( SRTISaved.ctrl ~= (IsControlKeyDown() == 1) ) then
		return;
	elseif ( SRTISaved.alt ~= (IsAltKeyDown() == 1) ) then
		return;
	elseif ( SRTISaved.shift ~= (IsShiftKeyDown() == 1) ) then
		return;
	end
	return 1;
end

local origSetRaidTarget = SetRaidTarget;
function srti.SetRaidTarget(index,unit,fromBinding)
	index = index or 0;
	if ( srti.frame.test ) then
		if ( index == 0 ) then
			srti.menu.test.icon:Hide();
			srti.menu.test.index = nil;
		else
			srti.menu.test.icon:Show();
			srti.menu.test.index = index;
			SetRaidTargetIconTexture(srti.menu.test.icon,index);
		end
		return;
	elseif ( not IsPartyLeader() ) then
		local num = GetNumRaidMembers();
		if ( num == 0 ) then
			if ( unit ) then
				local unitName = UnitName(unit);
				if ( unitName ) then
					SendAddonMessage("SRTI","PARTY "..unitName.." "..index,"PARTY");
				end
			else
				SendAddonMessage("SRTI","ICON "..index,"PARTY");
			end
			return;
		end

		local _, rank = GetRaidRosterInfo(num);
		if ( rank == 0 ) then return; end
	end
	if ( srti.frame:IsVisible() ) then
		srti.frame.i = index;
		srti.frame:Click();
	end
	if ( not fromBinding ) then
		origSetRaidTarget("target", index);
	end
end
hooksecurefunc("SetRaidTarget",function(unit,index) srti.SetRaidTarget(index,unit,1) end);

function srti.UpdateAssistants()
	for i=1, GetNumPartyMembers() do
		local text = "";
		if ( SRTISaved.assistants[(UnitName("party"..i))] ) then
			text = text .. " PROMOTE "..(UnitName("party"..i));
		else
			text = text .. " DEMOTE "..(UnitName("party"..i));
		end
		if ( text ~= "" ) then
			SendAddonMessage("SRTI", text, "PARTY");
		end
	end
end

function srti.GenericRaidDropdown(unit,unitName)
	local info;
	for index, value in ipairs( UnitPopupMenus["RAID_TARGET_ICON"] ) do
		info = {};
		info.text = UnitPopupButtons[value].text;
		info.owner = UIDROPDOWNMENU_MENU_VALUE;
		-- Set the text color
		color = UnitPopupButtons[value].color;
		if ( color ) then
			info.textR = color.r;
			info.textG = color.g;
			info.textB = color.b;
		else
			info.textR = nil;
			info.textG = nil;
			info.textB = nil;
		end
		-- Icons
		info.icon = UnitPopupButtons[value].icon;
		info.tCoordLeft = UnitPopupButtons[value].tCoordLeft;
		info.tCoordRight = UnitPopupButtons[value].tCoordRight;
		info.tCoordTop = UnitPopupButtons[value].tCoordTop;
		info.tCoordBottom = UnitPopupButtons[value].tCoordBottom;
		-- Checked conditions
		local raidTargetIndex = GetRaidTargetIndex(unit);
		if ( raidTargetIndex == index ) then
			info.checked = 1;
			info.arg1 = nil;
		elseif ( index == 9 ) then
			info.arg1 = nil;
		else
			info.arg1 = index;
		end
		info.func = srti.SetRaidTarget;
		if ( unitName ) then
			info.arg2 = unit;
		end
		UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL);
	end
end

function srti.TogglePlayer(player)
	if ( SRTISaved.assistants[player] ) then
		SRTISaved.assistants[player] = nil;
	else
		SRTISaved.assistants[player] = 1;
	end
	srti.UpdateAssistants();
end

function srti.UnitPopup_ShowMenuHook(dropdownMenu, which, unit, name, userData)
	if ( GetNumRaidMembers() == 0 ) then
		local info = {};
		if ( which == "PARTY" or ( which == "PLAYER" and unit == "target" and UnitCanCooperate("player",unit) ) ) then
			if ( UIDROPDOWNMENU_MENU_LEVEL == 2 ) then
				if ( which == "PARTY" and UIDROPDOWNMENU_MENU_VALUE == "RAID_TARGET_ICON" and IsPartyLeader() ) then
					info.notClickable = 1;
					UIDropDownMenu_AddButton(info,2);

					info = {};
					info.text = SRTI_UNIT_ASSISTANT;
					info.arg1 = UnitName(unit);
					info.func = srti.TogglePlayer;
					if ( SRTISaved.assistants[info.arg1] ) then
						info.checked = 1;
						info.tooltipTitle = SRTI_UNIT_ASSISTANT_DEMOTE;
						info.tooltipText = SRTI_UNIT_ASSISTANT_DEMOTE_TEXT;
					else
						info.tooltipTitle = SRTI_UNIT_ASSISTANT_PROMOTE;
						info.tooltipText = SRTI_UNIT_ASSISTANT_PROMOTE_TEXT;
					end
					UIDropDownMenu_AddButton(info,2);
				elseif ( UIDROPDOWNMENU_MENU_VALUE == "SRTI" ) then
					srti.GenericRaidDropdown(unit,1);
				end
			elseif ( not IsPartyLeader() and srti.promoted == 1 ) then
				info.notCheckable = 1;
				info.text = SRTI_UNIT_ASSISTANT;
				info.hasArrow = 1;
				info.tooltipTitle = SRTI_UNIT_SRTI;
				info.tooltipText = SRTI_TITLE;
				info.value = SRTI_UNIT_SRTI;
				info.owner = which;
				UIDropDownMenu_AddButton(info);
			end
		elseif ( which == "SELF" ) then
			local num = GetNumPartyMembers();
			if ( num == 0 ) then return; end

			if ( UIDROPDOWNMENU_MENU_LEVEL == 1 ) then
				if ( IsPartyLeader() or srti.promoted == 1 ) then
					info.notCheckable = 1;
					if ( srti.promoted == 1 ) then
						info.text = SRTI_UNIT_ASSISTANT;
						info.hasArrow = 1;
					else
						info.text = SRTI_UNIT_SRTI;
						info.hasArrow = 1;
					end
					info.tooltipTitle = SRTI_UNIT_SRTI;
					info.tooltipText = SRTI_TITLE;
					info.value = SRTI_UNIT_SRTI;
					info.owner = which;
					UIDropDownMenu_AddButton(info);
				else
					info.notCheckable = 1;
					info.disabled = 1;
					if ( srti.promoted == 0 ) then
						info.text = SRTI_UNIT_ASSISTANT_NOT_PROMOTED;
					else
						info.text = SRTI_UNIT_ASSISTANT_DISABLED;
					end
					UIDropDownMenu_AddButton(info);
				end
			elseif ( UIDROPDOWNMENU_MENU_LEVEL == 2 and UIDROPDOWNMENU_MENU_VALUE == "SRTI" ) then
				if ( IsPartyLeader() ) then
					info.text = SRTI_UNIT_ASSISTANTS;
					info.clickable = 0;
					info.isTitle = 1;
					info.notCheckable = 1;
					info.notClickable = 1;
					UIDropDownMenu_AddButton(info,2);
					info = {};

					for i=1, num do
						local name = UnitName("party"..i);
						info.text = name;
						if ( SRTISaved.assistants[name] ) then
							info.checked = 1;
							info.tooltipTitle = SRTI_UNIT_ASSISTANT_DEMOTE;
							info.tooltipText = SRTI_UNIT_ASSISTANT_DEMOTE_TEXT;
						else
							info.checked = nil;
							info.tooltipTitle = SRTI_UNIT_ASSISTANT_PROMOTE;
							info.tooltipText = SRTI_UNIT_ASSISTANT_PROMOTE_TEXT;
						end
						info.func = srti.TogglePlayer;
						info.arg1 = name;
						UIDropDownMenu_AddButton(info,2);
						info = UIDropDownMenu_CreateInfo();
					end
				elseif ( srti.promoted == 1 ) then
					srti.GenericRaidDropdown("player",1);
				end
			end
		elseif ( ( which == "RAID_TARGET_ICON" or ( which == "PLAYER" and not UnitCanCooperate("player",unit) ) ) and unit == "target" and not IsPartyLeader() and srti.promoted == 1 ) then
			info.text = SRTI_UNIT_ASSISTANT;
			info.isTitle = 1;
			info.notClickable = 1;
			info.notCheckable = 1;
			UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL);
			srti.GenericRaidDropdown(unit);
		end
	end
end

UnitPopupMenus["SRTI"] = {};
hooksecurefunc("UnitPopup_ShowMenu",srti.UnitPopup_ShowMenuHook);

local OnMouseUp = WorldFrame:GetScript("OnMouseUp");
WorldFrame:SetScript("OnMouseUp", function()
		if ( arg1 == "LeftButton" ) then
			local curtime = GetTime();
			local x, y = GetCursorPosition();
			local modifiers = srti.AreModifiersDown();
			local double = ( SRTISaved.double and srti.click and curtime - srti.click < (SRTISaved.speed or 0.25) and abs(x-srti.clickX) < 20 and abs(y-srti.clickY) < 20 );
			if ( modifiers or double ) then
				if ( ( modifiers and SRTISaved.singlehover ) or ( double and SRTISaved.doublehover ) ) then
					srti.frame.c = 0;
				else
					srti.frame.c = nil;
				end
				srti.click = nil;
				srti.Show();
			else
				srti.click = curtime;
			end
			srti.clickX, srti.clickY = x, y;
		end
		if ( OnMouseUp ) then
			OnMouseUp();
		end
	end
	);

SlashCmdList["SRTI"] = function(msg)
	msg = msg:lower();
	local num = tonumber(msg);
	if ( msg == "" ) then
		srti.Options();
	elseif ( num and num < 9 ) then
		srti.SetRaidTarget(num);
	elseif ( msg == "debug" ) then
		if ( SRTISaved.debug ) then
			SRTISaved.debug = nil;
		else
			SRTISaved.debug = 1;
		end
	else
		for string, index in pairs(iconStrings) do
			if ( msg == string ) then
				srti.SetRaidTarget(index);
				return;
			end
		end

		srti.PrintHelp();
	end
end

SLASH_SRTI1 = "/srti";

-- ugly quick hack to make old UIOptions style check box
local function CreateCheckBox(name, parent)
	local f = CreateFrame("CheckButton", name, parent, "OptionsCheckButtonTemplate")
	f:SetWidth(26)
	f:SetHeight(26)
	return f
end

function srti.Options()
	srti.menu = CreateFrame("FRAME","SRTIOptionsMenu",UIParent);
	srti.menu:SetWidth(460);
	srti.menu:SetHeight(31);
	srti.menu:SetPoint("CENTER");
	srti.menu:EnableMouse(1);
	srti.menu:SetMovable(1);

	tinsert(UISpecialFrames,"SRTIOptionsMenu");

	srti.menu:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 3, top = 3, bottom = 5 }
		});
	srti.menu:SetBackdropBorderColor(0.4, 0.4, 0.4);
	srti.menu:SetBackdropColor(0.15, 0.15, 0.15);

	srti.menu.titleregion = srti.menu:CreateTitleRegion(srti.menu);
	srti.menu.titleregion:SetAllPoints(srti.menu);

	srti.menu.title = srti.menu:CreateFontString(nil,"ARTWORK","GameFontHighlight");
	srti.menu.title:SetText(SRTI_HEADER);
	srti.menu.title:SetPoint("TOPLEFT",srti.menu,"TOPLEFT",8,-8);

	srti.menu.close = CreateFrame("BUTTON",nil,srti.menu,"UIPanelCloseButton");
	srti.menu.close:SetPoint("TOPRIGHT",srti.menu,"TOPRIGHT");

	srti.menu.options = CreateFrame("FRAME",nil,srti.menu);
	srti.menu.options:SetWidth(272);
	srti.menu.options:SetHeight(348);
	srti.menu.options:SetPoint("TOPLEFT",srti.menu,"BOTTOMLEFT");
	srti.menu.options:EnableMouse(1);
	srti.menu.options:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 3, top = 3, bottom = 5 }
		});
	srti.menu.options:SetBackdropBorderColor(0.4, 0.4, 0.4);
	srti.menu.options:SetBackdropColor(0.15, 0.15, 0.15);

	srti.menu.optionheader = srti.menu.options:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	srti.menu.optionheader:SetText(SRTI_OPTIONS_HEADER);
	srti.menu.optionheader:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",8,-8);


	srti.menu.options.singleframe = CreateFrame("FRAME",nil,srti.menu.options);
	srti.menu.options.singleframe:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT", 8, -40);
	srti.menu.options.singleframe:SetPoint("BOTTOMRIGHT",srti.menu.options,"TOPRIGHT", -8, -94);
	srti.menu.options.singleframe:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 8, edgeSize = 8,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
	srti.menu.options.singleframe:SetBackdropBorderColor(0, 0, 0);
	srti.menu.options.singleframe:SetBackdropColor(0.1, 0.1, 0.1);

	srti.menu.singletext = srti.menu.options:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	srti.menu.singletext:SetText(SRTI_OPTIONS_SINGLE_HEADER);
	srti.menu.singletext:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",18,-28);

	srti.menu.modifiertext = srti.menu.options.singleframe:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	srti.menu.modifiertext:SetText(SRTI_OPTIONS_SINGLE_MODIFIERS);
	srti.menu.modifiertext:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",18,-49);

	srti.menu.shift = CreateCheckBox("SRTIcb3",srti.menu.options.singleframe);
	srti.menu.shift:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",82,-42);
	srti.menu.shift:SetHitRectInsets(0,-30,5,5);
	srti.menu.shift.option = "shift";
	SRTIcb3Text:SetText(SRTI_OPTIONS_SINGLE_SHIFT);

	srti.menu.ctrl = CreateCheckBox("SRTIcb1",srti.menu.options.singleframe);
	srti.menu.ctrl:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",142,-42);
	srti.menu.ctrl:SetHitRectInsets(0,-30,5,5);
	srti.menu.ctrl.option = "ctrl";
	SRTIcb1Text:SetText(SRTI_OPTIONS_SINGLE_CTRL);

	srti.menu.alt = CreateCheckBox("SRTIcb2",srti.menu.options.singleframe);
	srti.menu.alt:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",202,-42);
	srti.menu.alt:SetHitRectInsets(0,-30,5,5);
	srti.menu.alt.option = "alt";
	SRTIcb2Text:SetText(SRTI_OPTIONS_SINGLE_ALT);

	srti.menu.singlehover = CreateCheckBox("SRTIcb4",srti.menu.options.singleframe);
	srti.menu.singlehover:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",16,-66);
	srti.menu.singlehover:SetHitRectInsets(0,-130,5,5);
	srti.menu.singlehover.option = "singlehover";
	SRTIcb4Text:SetText(SRTI_OPTIONS_HOVER);


	srti.menu.options.doubleframe = CreateFrame("FRAME",nil,srti.menu.options);
	srti.menu.options.doubleframe:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT", 8, -113);
	srti.menu.options.doubleframe:SetPoint("BOTTOMRIGHT",srti.menu.options,"TOPRIGHT", -8, -194);
	srti.menu.options.doubleframe:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 8, edgeSize = 8,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
	srti.menu.options.doubleframe:SetBackdropBorderColor(0, 0, 0);
	srti.menu.options.doubleframe:SetBackdropColor(0.1, 0.1, 0.1);

	srti.menu.doubletext = srti.menu.options:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	srti.menu.doubletext:SetText(SRTI_OPTIONS_DOUBLE_HEADER);
	srti.menu.doubletext:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",18,-101);

	srti.menu.doublecb = CreateCheckBox("SRTIcb5",srti.menu.options.doubleframe);
	srti.menu.doublecb:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",16,-115);
	srti.menu.doublecb:SetHitRectInsets(0,-30,5,5);
	SRTIcb5Text:SetText(SRTI_OPTIONS_DOUBLE_ENABLE);

	srti.menu.doublehover = CreateCheckBox("SRTIcb6",srti.menu.options.doubleframe);
	srti.menu.doublehover:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",90,-115);
	srti.menu.doublehover:SetHitRectInsets(0,-130,5,5);
	srti.menu.doublehover.option = "doublehover";
	SRTIcb6Text:SetText(SRTI_OPTIONS_HOVER);

	srti.menu.doublespeed = CreateFrame("Slider","SRTIslider1",srti.menu.options.doubleframe,"OptionsSliderTemplate");
	srti.menu.doublespeed:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",18,-160);
	srti.menu.doublespeed:SetPoint("TOPRIGHT",srti.menu.options,"TOPRIGHT",-18,-160);
	srti.menu.doublespeed:SetMinMaxValues(0.15,0.5);
	srti.menu.doublespeed:SetValueStep(0.01);
	srti.menu.doublespeed.option = "speed";
	SRTIslider1Low:SetText(SRTI_OPTIONS_DOUBLE_SPEED_MIN);
	SRTIslider1High:SetText(SRTI_OPTIONS_DOUBLE_SPEED_MAX);


	srti.menu.options.bindingframe = CreateFrame("FRAME",nil,srti.menu.options);
	srti.menu.options.bindingframe:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT", 8, -213);
	srti.menu.options.bindingframe:SetPoint("BOTTOMRIGHT",srti.menu.options,"TOPRIGHT", -8, -296);
	srti.menu.options.bindingframe:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 8, edgeSize = 8,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
	srti.menu.options.bindingframe:SetBackdropBorderColor(0, 0, 0);
	srti.menu.options.bindingframe:SetBackdropColor(0.1, 0.1, 0.1);

	srti.menu.bindingtext = srti.menu.options:CreateFontString(nil,"ARTWORK","GameFontHighlightSmall");
	srti.menu.bindingtext:SetText(SRTI_OPTIONS_BINDING_HEADER);
	srti.menu.bindingtext:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",18,-201);

	srti.menu.bindingkey1 = CreateFrame("Button","SRTIkb1",srti.menu.options.bindingframe,"UIPanelButtonTemplate2");
	srti.menu.bindingkey1:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",16,-219);
	srti.menu.bindingkey1:SetWidth(220);
	srti.menu.bindingkey1:SetTextFontObject(GameFontHighlightSmall);
	srti.menu.bindingkey1:SetHighlightFontObject(GameFontHighlightSmall);
	srti.menu.bindingkey1:SetScript("OnClick",function() srti.SetKeyBinding(arg1,"SRTI_SHOW",1) end);
	srti.menu.bindingkey1:RegisterForClicks("AnyUp")

	srti.menu.unbindingkey1 = CreateFrame("Button",nil,srti.menu.options.bindingframe);
	srti.menu.unbindingkey1:SetPoint("LEFT",srti.menu.bindingkey1,"RIGHT",-6,-1.5);
	srti.menu.unbindingkey1:SetWidth(32);
	srti.menu.unbindingkey1:SetHeight(32);
	--clear:SetHitRectInsets(9,7,-7,10);
	srti.menu.unbindingkey1:SetNormalTexture("Interface\\Buttons\\CancelButton-Up");
	srti.menu.unbindingkey1:SetPushedTexture("Interface\\Buttons\\CancelButton-Down");
	local h = srti.menu.unbindingkey1:CreateTexture(nil,"HIGHLIGHT");
	h:SetTexture("Interface\\Buttons\\CancelButton-Highlight");
	h:SetAllPoints();
	h:SetBlendMode("ADD");
	srti.menu.unbindingkey1:SetHighlightTexture(h);
	srti.menu.unbindingkey1:SetScript("OnClick",function() srti.SetKeyBinding(arg1,"SRTI_SHOW",1,1) end);

	srti.menu.bindingkey2 = CreateFrame("Button","SRTIkb2",srti.menu.options.bindingframe,"UIPanelButtonTemplate2");
	srti.menu.bindingkey2:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",16,-242);
	srti.menu.bindingkey2:SetWidth(220);
	srti.menu.bindingkey2:SetTextFontObject(GameFontHighlightSmall);
	srti.menu.bindingkey2:SetHighlightFontObject(GameFontHighlightSmall);
	srti.menu.bindingkey2:SetScript("OnClick",function() srti.SetKeyBinding(arg1,"SRTI_SHOW",2) end);
	srti.menu.bindingkey2:RegisterForClicks("AnyUp")

	srti.menu.unbindingkey2 = CreateFrame("Button",nil,srti.menu.options.bindingframe);
	srti.menu.unbindingkey2:SetPoint("LEFT",srti.menu.bindingkey2,"RIGHT",-6,-1.5);
	srti.menu.unbindingkey2:SetWidth(32);
	srti.menu.unbindingkey2:SetHeight(32);
	--clear:SetHitRectInsets(9,7,-7,10);
	srti.menu.unbindingkey2:SetNormalTexture("Interface\\Buttons\\CancelButton-Up");
	srti.menu.unbindingkey2:SetPushedTexture("Interface\\Buttons\\CancelButton-Down");
	h = srti.menu.unbindingkey2:CreateTexture(nil,"HIGHLIGHT");
	h:SetTexture("Interface\\Buttons\\CancelButton-Highlight");
	h:SetAllPoints();
	h:SetBlendMode("ADD");
	srti.menu.unbindingkey2:SetHighlightTexture(h);
	srti.menu.unbindingkey2:SetScript("OnClick",function() srti.SetKeyBinding(arg1,"SRTI_SHOW",2,1) end);

	srti.menu.bindinghover = CreateCheckBox("SRTIcb7",srti.menu.options.bindingframe);
	srti.menu.bindinghover:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",16,-268);
	srti.menu.bindinghover:SetHitRectInsets(0,-130,5,5);
	srti.menu.bindinghover.option = "bindinghover";
	SRTIcb7Text:SetText(SRTI_OPTIONS_HOVER);


	srti.menu.options.hoverframe = CreateFrame("FRAME",nil,srti.menu.options);
	srti.menu.options.hoverframe:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT", 8, -298);
	srti.menu.options.hoverframe:SetPoint("BOTTOMRIGHT",srti.menu.options,"TOPRIGHT", -8, -342);
	srti.menu.options.hoverframe:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 8, edgeSize = 8,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
	srti.menu.options.hoverframe:SetBackdropBorderColor(0, 0, 0);
	srti.menu.options.hoverframe:SetBackdropColor(0.1, 0.1, 0.1);

	srti.menu.hovertime = CreateFrame("Slider","SRTIslider2",srti.menu.options,"OptionsSliderTemplate");
	srti.menu.hovertime:SetPoint("TOPLEFT",srti.menu.options,"TOPLEFT",18,-312);
	srti.menu.hovertime:SetPoint("TOPRIGHT",srti.menu.options,"TOPRIGHT",-18,-312);
	srti.menu.hovertime:SetMinMaxValues(0.0,0.5);
	srti.menu.hovertime:SetValueStep(0.05);
	srti.menu.hovertime.option = "hovertime";
	SRTIslider2Low:SetText(SRTI_OPTIONS_HOVER_TIME_MIN);
	SRTIslider2High:SetText(SRTI_OPTIONS_HOVER_TIME_MAX);

	srti.menu.test = CreateFrame("FRAME",nil,srti.menu);
	srti.menu.test:EnableMouse(1);
	srti.menu.test:SetMovable(1);
	srti.menu.test:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 3, top = 3, bottom = 5 }
		});
	srti.menu.test:SetBackdropBorderColor(0.4, 0.4, 0.4);
	srti.menu.test:SetBackdropColor(0.15, 0.15, 0.15);
	srti.menu.test:SetPoint("TOPRIGHT",srti.menu,"BOTTOMRIGHT",0,0);
	srti.menu.test:SetPoint("BOTTOMLEFT",srti.menu.options,"BOTTOMRIGHT",0,0);


	srti.menu.test.model = CreateFrame("PLAYERMODEL",nil,srti.menu.test);
	srti.menu.test.model:SetPoint("TOPRIGHT",srti.menu.test,"TOPRIGHT",-6,-6);
	srti.menu.test.model:SetPoint("BOTTOMLEFT",srti.menu.test,"BOTTOMLEFT",6,6);
	srti.menu.test.model:SetRotation(0.61);
	srti.menu.test.model:SetLight(1,0,-.5,-.2,-.6,0.5,1,1,1,1,1,1,0.8);
	srti.menu.test.model:SetScript("OnShow", function()
			srti.menu.test.model:SetPosition(0,0,0);
			srti.menu.test.model:SetUnit("player");
			srti.menu.test.model:SetPosition(0,0,-0.2);
		end
		);
	srti.menu.test.model:GetScript("OnShow")();

	srti.menu.test.icon = srti.menu.test.model:CreateTexture(nil,"OVERLAY");
	srti.menu.test.icon:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons");
	srti.menu.test.icon:SetWidth(42);
	srti.menu.test.icon:SetHeight(42);
	srti.menu.test.icon:SetPoint("TOP",srti.menu.test.model,"TOP",0,-2);
	srti.menu.test.icon:Hide();

	srti.menu.test.text = srti.menu.test.model:CreateFontString(nil,"OVERLAY","NumberFontNormal");
	srti.menu.test.text:SetText(SRTI_OPTIONS_TEST);
	srti.menu.test.text:SetPoint("TOP",srti.menu.test.icon,"BOTTOM");

	srti.menu.test.help = srti.menu.test:CreateFontString(nil,"ARTWORK","GameFontDisable");
	srti.menu.test.help:SetText(SRTI_OPTIONS_TEST_HELP);
	srti.menu.test.help:SetPoint("BOTTOM",srti.menu.test,"BOTTOM",0,8);
	srti.menu.test.help:SetPoint("LEFT",srti.menu.test,"LEFT",0,8);
	srti.menu.test.help:SetPoint("RIGHT",srti.menu.test,"RIGHT",0,-8);


	srti.menu.test.ShowRadial = function(c)
		srti.frame.c = c;
		srti.frame.s = GetTime();
		srti.frame.h = nil;
		srti.frame.i = nil;
		srti.frame.l = nil;
		srti.frame.test = 1;
		srti.frame.portrait = nil;

		local x,y = GetCursorPosition();
		local s = srti.frame:GetEffectiveScale();
		srti.frame:SetPoint( "CENTER", UIParent, "BOTTOMLEFT", x/s, y/s );
		srti.frame:Show();
	end

	srti.menu.test:SetScript("OnMouseUp",function()
		if ( arg1 == "LeftButton" ) then
			local time = GetTime();
			local x, y = GetCursorPosition();
			local modifiers = srti.AreModifiersDown();
			local double = ( SRTISaved.double and srti.click and time - srti.click < (SRTISaved.speed or 0.25) and abs(x-srti.clickX) < 20 and abs(y-srti.clickY) < 20 );
			if ( modifiers or double ) then
				if ( ( modifiers and SRTISaved.singlehover ) or ( double and SRTISaved.doublehover ) ) then
					srti.menu.test.ShowRadial(0);
				else
					srti.menu.test.ShowRadial();
				end
			else
				srti.click = time;
			end
			srti.clickX, srti.clickY = x, y;
		end
	end
	);

	srti.menu.UpdateCB = function()
		if ( SRTISaved.ctrl or SRTISaved.alt or SRTISaved.shift ) then
			srti.menu.singletext:SetFontObject("GameFontHighlightSmall");
			srti.menu.modifiertext:SetFontObject("GameFontHighlightSmall");
			SRTIcb4Text:SetFontObject("GameFontNormalSmall");
		else
			srti.menu.singletext:SetFontObject("GameFontDisableSmall");
			srti.menu.modifiertext:SetFontObject("GameFontDisableSmall");
			SRTIcb4Text:SetFontObject("GameFontDisableSmall");
		end
	end;

	srti.menu.ModiferCB = function()
		SRTISaved[this.option] = this:GetChecked() == 1;
		srti.menu.UpdateCB();
	end;

	srti.menu.UpdateDouble = function()
		if ( SRTISaved.double ) then
			srti.menu.doubletext:SetFontObject("GameFontHighlightSmall");
			SRTIslider1Text:SetFontObject("GameFontNormalSmall");
			SRTIslider1Low:SetFontObject("GameFontHighlightSmall");
			SRTIslider1High:SetFontObject("GameFontHighlightSmall");
			SRTIcb6Text:SetFontObject("GameFontNormalSmall");
		else
			srti.menu.doubletext:SetFontObject("GameFontDisableSmall");
			SRTIslider1Text:SetFontObject("GameFontDisableSmall");
			SRTIslider1Low:SetFontObject("GameFontDisableSmall");
			SRTIslider1High:SetFontObject("GameFontDisableSmall");
			SRTIcb6Text:SetFontObject("GameFontDisableSmall");
		end
	end;

	srti.menu.DoubleCB = function()
		SRTISaved.double = this:GetChecked() == 1;
		srti.menu.UpdateDouble();
	end;

	srti.menu.UpdateSlider = function()
		SRTIslider1Text:SetText(SRTI_OPTIONS_DOUBLE_SPEED:format(string.sub(SRTISaved.speed,1,4) or 0.25));
		SRTIslider2Text:SetText(SRTI_OPTIONS_HOVER_TIME:format(string.sub(SRTISaved.hovertime,1,4) or 0.2));
	end;

	srti.menu.DoubleSlider = function()
		SRTISaved[this.option] = this:GetValue();
		srti.menu.UpdateSlider();
	end;

	srti.menu.ctrl:SetScript("OnClick",srti.menu.ModiferCB);
	srti.menu.alt:SetScript("OnClick",srti.menu.ModiferCB);
	srti.menu.shift:SetScript("OnClick",srti.menu.ModiferCB);
	srti.menu.singlehover:SetScript("OnClick",srti.menu.ModiferCB);

	srti.menu.doublecb:SetScript("OnClick",srti.menu.DoubleCB);
	srti.menu.doublespeed:SetScript("OnValueChanged",srti.menu.DoubleSlider);
	srti.menu.hovertime:SetScript("OnValueChanged",srti.menu.DoubleSlider);
	srti.menu.doublehover:SetScript("OnClick",srti.menu.ModiferCB);

	srti.menu.bindinghover:SetScript("OnClick",srti.menu.ModiferCB);

	srti.menu.UpdateBindings = function()
		local binding1, binding2 = GetBindingKey("SRTI_SHOW");

		if ( binding1 ) then
			srti.menu.bindingkey1:SetText(GetBindingText(binding1, "KEY_"));
			srti.menu.bindingkey1:SetAlpha(1);
		else
			srti.menu.bindingkey1:SetText(NORMAL_FONT_COLOR_CODE..NOT_BOUND..FONT_COLOR_CODE_CLOSE);
			srti.menu.bindingkey1:SetAlpha(0.8);
		end
		if ( binding2 ) then
			srti.menu.bindingkey2:SetText(GetBindingText(binding2, "KEY_"));
			srti.menu.bindingkey2:SetAlpha(1);
		else
			srti.menu.bindingkey2:SetText(NORMAL_FONT_COLOR_CODE..NOT_BOUND..FONT_COLOR_CODE_CLOSE);
			srti.menu.bindingkey2:SetAlpha(0.8);
		end
	end;

	srti.menu.Update = function()
		srti.menu.ctrl:SetChecked(SRTISaved.ctrl or 0);
		srti.menu.alt:SetChecked(SRTISaved.alt or 0);
		srti.menu.shift:SetChecked(SRTISaved.shift or 0);
		srti.menu.singlehover:SetChecked(SRTISaved.singlehover or 0);

		srti.menu.doublespeed:SetValue(SRTISaved.speed or 0.25);
		srti.menu.hovertime:SetValue(SRTISaved.hovertime or 0.2);
		srti.menu.doublecb:SetChecked(SRTISaved.double or 0);
		srti.menu.doublehover:SetChecked(SRTISaved.doublehover or 0);

		srti.menu.UpdateCB();
		srti.menu.UpdateSlider();
		srti.menu.UpdateDouble();
		srti.menu.UpdateBindings();
	end;

	srti.menu:SetScript("OnShow", srti.menu.Update);

	srti.menu.Update();

	srti.Options = function()
		if ( srti.menu:IsVisible() ) then
			srti.menu:Hide();
		else
			srti.menu:Show();
		end
	end
end

function srti.SetKeyBinding(button,binding,index,mode)
	srti.keybindings = CreateFrame("FRAME","SRTIKeyBindingsFrame",UIParent);
	srti.keybindings:EnableKeyboard(1);
	srti.keybindings:EnableMouse(1);
	srti.keybindings:EnableMouseWheel(1);
	srti.keybindings:SetFrameStrata("FULLSCREEN_DIALOG");
	srti.keybindings:SetAllPoints();

	srti.keybindings.bg = srti.keybindings:CreateTexture(nil,"BACKGROUND");
	srti.keybindings.bg:SetTexture(0.15,0.15,0.15);
	srti.keybindings.bg:SetAlpha(0.75);
	srti.keybindings.bg:SetAllPoints();

	srti.keybindings.frame = CreateFrame("FRAME",nil,srti.keybindings);
	srti.keybindings.frame:SetPoint("CENTER",srti.keybindings,"CENTER", 0, 50);
	srti.keybindings.frame:SetWidth(400);
	srti.keybindings.frame:SetHeight(100);
	srti.keybindings.frame:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 8, edgeSize = 8,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
	srti.keybindings.frame:SetBackdropBorderColor(0, 0, 0);
	srti.keybindings.frame:SetBackdropColor(0.1, 0.1, 0.1);

	srti.keybindings.keytext = srti.keybindings.frame:CreateFontString(nil,"ARTWORK","GameFontHighlightLarge");
	srti.keybindings.keytext:SetPoint("CENTER");

	srti.keybindings.helptext = srti.keybindings.frame:CreateFontString(nil,"ARTWORK","GameFontNormal");
	srti.keybindings.helptext:SetPoint("TOP",srti.keybindings.frame,"TOP",0,-4);

	srti.keybindings.warntext = srti.keybindings.frame:CreateFontString(nil,"ARTWORK","GameFontNormal");
	srti.keybindings.warntext:SetPoint("BOTTOM",srti.keybindings.frame,"BOTTOM",0,4);

	srti.keybindings.acceptframe = CreateFrame("FRAME",nil,srti.keybindings.frame);
	srti.keybindings.acceptframe:SetPoint("TOP",srti.keybindings.frame,"BOTTOM", 0, 0);
	srti.keybindings.acceptframe:SetWidth(400);
	srti.keybindings.acceptframe:SetHeight(28);
	srti.keybindings.acceptframe:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 8, edgeSize = 8,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
	srti.keybindings.acceptframe:SetBackdropBorderColor(0, 0, 0);
	srti.keybindings.acceptframe:SetBackdropColor(0.1, 0.1, 0.1);

	srti.keybindings.esctext = srti.keybindings.acceptframe:CreateFontString(nil,"ARTWORK","GameFontHighlight");
	srti.keybindings.esctext:SetPoint("CENTER",srti.keybindings.acceptframe,"CENTER",0);
	srti.keybindings.esctext:SetText(SRTI_BINDINGS_ESC);

	srti.keybindings.accept = CreateFrame("BUTTON",nil,srti.keybindings.acceptframe,"UIPanelButtonTemplate");
	srti.keybindings.accept:SetPoint("RIGHT",srti.keybindings.acceptframe,"RIGHT",-2,0);
	srti.keybindings.accept:SetText(ACCEPT);
	srti.keybindings.accept:SetWidth(80);
	srti.keybindings.accept:SetHeight(22);
	srti.keybindings.accept:Disable();

	srti.keybindings.accept:SetScript("OnClick", function()
			srti.keybindings:Hide();
			if ( srti.keybindings.mode ) then
				if ( srti.keybindings.key ) then
					SetBinding(srti.keybindings.key);
				end
			elseif ( srti.keybindings.key and srti.keybindings.binding ) then
				local key1, key2 = GetBindingKey(srti.keybindings.binding);
				if ( key1 ) then
					SetBinding(key1);
				end
				if ( key2 ) then
					SetBinding(key2);
				end
				if ( srti.keybindings.index == 1 ) then
					SetBinding(srti.keybindings.key, srti.keybindings.binding);
					if ( key2 ) then
						SetBinding(key2, srti.keybindings.binding);
					end
				else
					if ( key1 ) then
						SetBinding(key1, srti.keybindings.binding);
					end
					SetBinding(srti.keybindings.key, srti.keybindings.binding);
				end
			end
			SaveBindings(GetCurrentBindingSet());
			srti.menu.UpdateBindings();
		end);

	function srti.keybindings.OnShow()
		if ( srti.keybindings.mode ) then
			if ( not srti.keybindings.key ) then
				srti.keybindings:Hide();
			end
			srti.keybindings.helptext:SetText(format(SRTI_BINDINGS_UNBIND_HELP, GetBindingText(binding, "BINDING_NAME_")));
			srti.keybindings.keytext:SetText(srti.keybindings.key);
			srti.keybindings.warntext:SetText("");
			srti.keybindings.accept:Enable();
		else
			srti.keybindings.helptext:SetText(format(SRTI_BINDINGS_BIND_HELP, GetBindingText(binding, "BINDING_NAME_")));
			srti.keybindings.keytext:SetText(srti.keybindings.key or NOT_BOUND);
			srti.keybindings.warntext:SetText("");
			if ( srti.keybindings.key ) then
				srti.keybindings.accept:Enable();
			else
				srti.keybindings.accept:Disable();
			end
		end
	end

	function srti.keybindings.OnKeyDown(key)
		local screenshotKey = GetBindingKey("SCREENSHOT");
		if ( screenshotKey and key == screenshotKey ) then
			Screenshot();
			return;
		end
		if ( key=="ESCAPE" ) then
			srti.keybindings:Hide();
		elseif ( not srti.keybindings.mode and key ~= "LeftButton" and key ~= "RightButton" and key ~= "SHIFT" and key ~= "ALT" and key ~= "CTRL" and key ~= "UNKNOWN" ) then
			srti.keybindings.OnShow();
			if ( key == "MiddleButton" ) then
				key = "BUTTON3";
			elseif ( key == "Button4" ) then
				key = "BUTTON4"
			elseif ( key == "Button5" ) then
				key = "BUTTON5"
			end
			if ( srti.keybindings.modifier ) then
				if IsLeftShiftKeyDown() then
					key = "LSHIFT-"..key
				end
				if IsLeftAltKeyDown() then
					key = "LALT-"..key
				end
				if IsLeftControlKeyDown() then
					key = "LCTRL-"..key
				end
				if IsRightShiftKeyDown() then
					key = "RSHIFT-"..key
				end
				if IsRightAltKeyDown() then
					key = "RALT-"..key
				end
				if IsRightControlKeyDown() then
					key = "RCTRL-"..key
				end
			else
				if IsShiftKeyDown() then
					key = "SHIFT-"..key
				end
				if IsAltKeyDown() then
					key = "ALT-"..key
				end
				if IsControlKeyDown() then
					key = "CTRL-"..key
				end
			end

			srti.keybindings.keytext:SetText( key );
			srti.keybindings.key = key;
			srti.keybindings.accept:Enable()

			local oldAction = GetBindingAction(key);
			if ( oldAction ~= "" and oldAction ~= srti.keybindings.binding ) then
				local oldkeys = select("#",GetBindingKey(oldAction));
				if ( oldkeys > 1 ) then
					srti.keybindings.warntext:SetText(format(SRTI_BINDINGS_BIND_WARN, GetBindingText(oldAction, "BINDING_NAME_")));
				else
					srti.keybindings.warntext:SetText(format(SRTI_BINDINGS_BIND_WARN_UNBOUND, GetBindingText(oldAction, "BINDING_NAME_")));
				end
			end
		end
	end

	srti.keybindings:SetScript("OnKeyDown", function() srti.keybindings.OnKeyDown(arg1) end);
	srti.keybindings:SetScript("OnMouseUp", function() srti.keybindings.OnKeyDown(arg1) end);
	srti.keybindings:SetScript("OnMouseWheel", function()
			if ( arg1 > 0 ) then
				srti.keybindings.OnKeyDown("MOUSEWHEELUP")
			else
				srti.keybindings.OnKeyDown("MOUSEWHEELDOWN")
			end
		end);

	srti.SetKeyBinding = function(button,binding,index,mode)
		srti.keybindings.binding = binding or "SRTI_SHOW";
		srti.keybindings.index = index or 1;
		srti.keybindings.key = select(srti.keybindings.index,GetBindingKey(srti.keybindings.binding));
		srti.keybindings.mode = mode;

		srti.keybindings.accept:Disable();
		srti.keybindings:Show();
		srti.keybindings.OnShow();
		srti.keybindings.OnKeyDown(button);
	end;

	srti.SetKeyBinding(button, binding, index, mode);
end

SRTI = srti;