------------------------------------------------------
-- Playlist Functions
------------------------------------------------------

function PLInfo(x, num)
	if (Smp3_Save.SimpleMp3PlayList[1]) then
		if (x == 'song') then
			if (Smp3_Save.SimpleMp3PlayList[num].Title == 'None') then
				return string.gsub(Smp3_Save.SimpleMp3PlayList[num].Name, "^.+\\", "");
			else
				return Smp3_Save.SimpleMp3PlayList[num].Title;
			end
		elseif (x == 'artist') then
			if (Smp3_Save.SimpleMp3PlayList[num].Artist == 'None') then
				return SIMPLEMP3_UNK_ARTIST;
			else
				return Smp3_Save.SimpleMp3PlayList[num].Artist;
			end
		elseif (x == 'album') then
			if (Smp3_Save.SimpleMp3PlayList[num].Album == 'None') then
				return SIMPLEMP3_UNK_ALBUM;
			else
				return Smp3_Save.SimpleMp3PlayList[num].Album;
			end
		elseif (x == 'genre') then
			if (Smp3_Save.SimpleMp3PlayList[num].Genre == 'None') then
				return SIMPLEMP3_UNK_GENRE;
			else
				return Smp3_Save.SimpleMp3PlayList[num].Genre;
			end
		elseif (x == 'bitrate') then
			if (Smp3_Save.SimpleMp3PlayList[num].BitRate == 'None') then
				return SIMPLEMP3_UNK_BITRATE;
			else
				return Smp3_Save.SimpleMp3PlayList[num].BitRate;
			end
		elseif (x == 'name') then
			return Smp3_Save.SimpleMp3PlayList[num].Name;
		elseif (x == 'name2') then
			return string.gsub(Smp3_Save.SimpleMp3PlayList[num].Name, "^.+\\", "");
		elseif (x == 'length') then
			return Smp3_Save.SimpleMp3PlayList[num].Length;
		elseif (x == 'length2') then
			return Time(Smp3_Save.SimpleMp3PlayList[num].Length);
		end
	else
		return SIMPLEMP3_UNK
	end
end

function PlayListDisplay(num)
	if (Smp3_Save.UseTags == 1) then
		return PLInfo('song', num) .. " " .. "|cFFFFFFFF" .. PLInfo('artist', num) .. " " .. "|r" .. PLInfo('album', num) .. " ".. "|cFFFFFFFF"  .. PLInfo('genre', num) .. " " .. "|r" .. PLInfo('bitrate', num) .. "k " .. "|cFFFFFFFF" .. PLInfo('length2', num) .. "|r";
	else
		return PLInfo('name2', num) .. " " .. PLInfo('length2', num);
	end
end

-- Playlist Onshow tells it to update
function SimpleMp3Playlist_OnShow()
	SimpleMp3Playlist_update()    
end

 -- When the scrollbar is changed so shall the list
function SimpleMp3Playlist_OnValueChanged()
	SimpleMp3Playlist_update()
end 
-- First load to set total population for the slider
function SimpleMp3Playlist_OnLoad()
	local SliderVar;
	this:RegisterForDrag("LeftButton");
	SliderVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistSlider");     
    	if (Smp3_Save.SimpleMp3PlayList[1]) then
		SliderVar:SetMinMaxValues(1, SliderMax(table.getn(Smp3_Save.SimpleMp3PlayList), Smp3_Save.VisibleSlots));
	end
	SimpleMp3Playlist_update()
end

function SimpleMp3Playlist_OnEvent()
end

-- Playlist form populates the list according to window size
function PopulateList()
	local LabelVar, SliderVar;    
	SliderVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistSlider");
	MaxPlayListNum = table.getn(Smp3_Save.SimpleMp3PlayList);
	
	if (MaxPlayListNum == 1) then
		LabelVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistPanel" .. 1);
		LabelVar:SetText(SliderVar:GetValue() + 0 .. ". " .. PlayListDisplay(SliderVar:GetValue() + 0));
    	elseif (Smp3_Save.VisibleSlots <= MaxPlayListNum) then
		for i=1,Smp3_Save.VisibleSlots do
			LabelVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistPanel" .. i);	
			LabelVar:SetText(SliderVar:GetValue() + (i - 1) .. ". " .. PlayListDisplay(SliderVar:GetValue() + (i - 1)));
		end
	else
		for i=1,MaxPlayListNum do
			LabelVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistPanel" .. i);	

			if (i > MaxPlayListNum) then
				return;		
			end        

			-- Debugging purposes while fixing playlist resizing issue
			-- DEFAULT_CHAT_FRAME:AddMessage(SliderVar:GetValue() .. " " .. i .. " " .. Smp3_Save.SimpleMp3PlayList[(SliderVar:GetValue() + i) - 1].Name);
			LabelVar:SetText(SliderVar:GetValue() + (i - 1) .. ". " .. PlayListDisplay(SliderVar:GetValue() + (i - 1)));
		end
	end
end

-- Playlist update (text show/hide routine)
-- This tells the resizable window how many slots are viewable at that size
function SimpleMp3Playlist_update()
	if (Smp3_Save.SimpleMp3PlayList == 1) then
		SimpleMp3PlaylistFormPlaylistPanel1:Hide()
		Smp3_Save.VisibleSlots = 0;
	end
	MaxPlayListNum = table.getn(Smp3_Save.SimpleMp3PlayList);
	local fheight = SimpleMp3PlaylistForm:GetHeight() 
	local SliderVar;
	SliderVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistSlider");

	for i = 1, 25 do
		if (MaxPlayListNum >= i) then
			if ((i * 14) + 37.8 < fheight) then
				x = 'SimpleMp3PlaylistFormPlaylistPanel' .. i .. ':Show()'
				RunScript(x)
				SliderVar:SetMinMaxValues(1, SliderMax(table.getn(Smp3_Save.SimpleMp3PlayList), (i-1)));
				Smp3_Save.VisibleSlots = i;
			else
				x = 'SimpleMp3PlaylistFormPlaylistPanel' .. i .. ':Hide()'
				RunScript(x)
			end
		else
			x = 'SimpleMp3PlaylistFormPlaylistPanel' .. i .. ':Hide()'
			RunScript(x)
			if (MaxPlayListNum == 0) then
				Smp3_Save.VisibleSlots = 0;
			end
		end
	end      

	-- Debugging purposes while fixing playlist issues
	-- DEFAULT_CHAT_FRAME:AddMessage(fheight);

	PopulateList() 
end

-- Function for when something in the playlist is clicked
function SimpleMp3Playlist_OnClick(MouseButton, Number)
	local SliderVar;
	SliderVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistSlider");
	Smp3_Save.Current = (SliderVar:GetValue() + Number - 1);
	if (MouseButton == 'LeftButton' and IsShiftKeyDown() == nil) then
		if (isPlaying == true) then
			SimpleMp3_PlayStopClick()
			SimpleMp3_PlayStopClick()
		else
			SimpleMp3_PlayStopClick()
		end
	elseif (MouseButton == 'LeftButton' and IsShiftKeyDown()) then
		if (Smp3_Save.isShuffled == true) then
			DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_CANT_REMOVE);
		else
			--tinsert(SimpleMp3Library, 1, Smp3_Save.SimpleMp3PlayList[(SliderVar:GetValue() + Number - 1)]);
			tremove(Smp3_Save.SimpleMp3PlayList, (SliderVar:GetValue() + Number - 1));
			--tsort(SimpleMp3Library, Smp3_Save.sortField, Smp3_Save.sortOrder)
			if (Smp3_Save.PlaySounds == 1) then
				PlaySound("igMiniMapZoomIn");
			end
			if (Number == Smp3_Save.Current) then
				if (isScrolling == true) then
					Count = 0;
					ScrollBackward = true;
					ScrollForward = false;
				end
				Hr  = 0;
				Min = 0;
				Sec = 0;
				if (Smp3_Save.Current == 1) then
					Smp3_Save.Current = Number
				else
					Smp3_Save.Current = (Number - 1)
				end
				StopMusic();
				SetScrollText(Smp3_Save.Current);
				SetNameLabel(Smp3_Save.ScrollText);
				SetTimeLabel("00:00:00");
				isPlaying = false;
				isScrolling = true;
				ScrollBackward = true;
				ScrollForward = false;
				SetPlayStopBnText(SIMPLEMP3_BINDPLAY);
			elseif (Number < Smp3_Save.Current) then
				if (isScrolling == true) then
					Count = 0;
					ScrollBackward = true;
					ScrollForward = false;
				end
				Smp3_Save.Current = (Smp3_Save.Current -1)
				SetScrollText(Smp3_Save.Current);
				SetNameLabel(Smp3_Save.ScrollText);
			end
		end
	end
end

-- Exit Button
function SimpleMp3Playlist_OnExitClick()
	SimpleMp3PlaylistForm:Hide();
end

-- Playlist scroll function
function SimpleMp3Playlist_OnMouseWheel(Direction)
	local SliderVar;
	SliderVar = getglobal("SimpleMp3PlaylistForm" .. "PlaylistSlider");
	
	if (Direction == 1) then
		SliderVar:SetValue(SliderVar:GetValue() - 1);
	else
		SliderVar:SetValue(SliderVar:GetValue() + 1);
	end
end

-- Function to Remove All songs from the PlayList
function RemoveAll_button()
		if (Smp3_Save.isShuffled == false) then
			--[[for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				tinsert(SimpleMp3Library, i, Smp3_Save.SimpleMp3PlayList[i]);
			end]]
			for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				tremove(Smp3_Save.SimpleMp3PlayList);
			end
		else
			--[[for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				tinsert(SimpleMp3Library, i, Smp3_Save.SimpleMp3PlayList[i]);
			end]]
			for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				tremove(Smp3_Save.SimpleMp3PlayList);
			end
			Smp3_Save.isShuffled = false
			SetShuffleBnText(SIMPLEMP3_BINDSHUFFLEOFF)
			DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_SHUFFLEOFF);
		end
		Hr  = 0;
		Min = 0;
		Sec = 0;
		Smp3_Save.Current = 1
		StopMusic();
		SetScrollText(Smp3_Save.Current);
		SetNameLabel(Smp3_Save.ScrollText);
		SetTimeLabel("00:00:00");
		Count = 0;
		ScrollBackward = true;
		ScrollForward = false;
		isPlaying = false;
		isScrolling = true;
		ScrollBackward = true;
		ScrollForward = false;
		SetPlayStopBnText(SIMPLEMP3_BINDPLAY);
		SimpleMp3Playlist_update()
end