-- Timer
function SimpleMp3_MiniMapOnUpdate(ElapsedTime)
	this.TimeSinceLastUpdate = this.TimeSinceLastUpdate + ElapsedTime; 	
	this.TimeSinceLastScrollUpdate = this.TimeSinceLastScrollUpdate + ElapsedTime; 	


 	while (this.TimeSinceLastUpdate > SimpleMp3_UpdateInterval) do
		
		if (isPlaying == true) then
			Sec = Sec + 1;
		
			if (Sec == 60) then
				Min = Min + 1;
				Sec = 0;
			end
			
			if (Min == 60) then
				Hr = Hr + 1;
				Min = 0;
				Sec = 0;
			end
			
			TotalSecs = ((Hr * 60) + (Min * 60) + Sec);
			
			if(TotalSecs == PLInfo('length', Smp3_Save.Current)) then
				SimpleMp3_NextClick();
			end
		end
		if (isPlayingDemo == true) then
			Sec = Sec + 1;
		
			if (Sec == 60) then
				Min = Min + 1;
				Sec = 0;
			end
			
			if (Min == 60) then
				Hr = Hr + 1;
				Min = 0;
				Sec = 0;
			end
			
			TotalSecs = ((Hr * 60) + (Min * 60) + Sec);
			
			if(TotalSecs == LIBInfo('length', LIBCurrent)) then
				StopMusic();
				Hr  = 0;
				Min = 0;
				Sec = 0;
				isPlayingDemo = false
			elseif(TotalSecs == demoLimit) then
				StopMusic();
				Hr  = 0;
				Min = 0;
				Sec = 0;
				isPlayingDemo = false
			end
		end
		
		this.TimeSinceLastUpdate = this.TimeSinceLastUpdate - SimpleMp3_UpdateInterval;
  	end					
end

-- MiniMap
function SimpleMp3_MiniMapOnload()
	this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	this.TimeSinceLastUpdate = 0;
	this.TimeSinceLastScrollUpdate = 0;
	SlashCmdList["SIMPLEMP3COMMAND"] = SimpleMp3_SlashCommands;
	SLASH_SIMPLEMP3COMMAND1 = "/smp3";
end

-- MiniMap Button Dragging Functions
function SimpleMp3_OnDragStart()
	if (not lbDraggingButton) then
   			this:StartMoving();
   			lbDraggingButton = true;
   		end
end

function SimpleMp3_OnDragStop()
		if (lbDraggingButton) then
			this:StopMovingOrSizing()
			lbDraggingButton = false;		
        end
end

--MiniMap Button Clicks 
--Left click shows/hides the player
--Shift + left click = shows/hides the playlist
--Right click shows/hides the volume control
--Shift + right click shows/hides the library

function SimpleMp3_MinimapButtonClick(MouseButton)
	if (MouseButton == 'LeftButton' and IsShiftKeyDown() == nil) then
		if (SimpleMp3Form:IsVisible()) then
			SimpleMp3Form:Hide();
		else
			SimpleMp3Form:Show();
		end
	elseif (MouseButton == 'LeftButton' and IsShiftKeyDown()) then
		if (SimpleMp3PlaylistForm:IsVisible()) then
			SimpleMp3PlaylistForm:Hide();
		else
			SimpleMp3PlaylistForm:Show();
		end
	elseif (MouseButton == 'RightButton' and IsShiftKeyDown() == nil) then
		if (SimpleMp3VolumeForm:IsVisible()) then
			SimpleMp3VolumeForm:Hide();
		else
			SimpleMp3VolumeForm:Show();
		end
	elseif (MouseButton == 'RightButton' and IsShiftKeyDown()) then
		if (SimpleMp3LibraryForm:IsVisible()) then
			SimpleMp3LibraryForm:Hide();
		else
			SimpleMp3LibraryForm:Show();
		end
	end
end

-- Minimap Tooltip Text
function SimpleMp3MiniMap_OnEnter()
    GameTooltip:SetText(SIMPLEMP3_TOOLTIP_TITLE);
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
    GameTooltip:AddLine(SIMPLEMP3_TOOLTIP_TEXT);
    GameTooltip:Show();
end

