------------------------------------------------------
-- Library Functions
------------------------------------------------------

function LIBInfo(x, num)
	if (SimpleMp3Library) then
		if (x == 'song') then
			if (SimpleMp3Library[num].Title == 'None') then
				return string.gsub(SimpleMp3Library[num].Name, "^.+\\", "");
			else
				return SimpleMp3Library[num].Title;
			end
		elseif (x == 'artist') then
			if (SimpleMp3Library[num].Artist == 'None') then
				return SIMPLEMP3_UNK_ARTIST;
			else
				return SimpleMp3Library[num].Artist;
			end
		elseif (x == 'album') then
			if (SimpleMp3Library[num].Album == 'None') then
				return SIMPLEMP3_UNK_ALBUM;
			else
				return SimpleMp3Library[num].Album;
			end
		elseif (x == 'genre') then
			if (SimpleMp3Library[num].Genre == 'None') then
				return SIMPLEMP3_UNK_GENRE;
			else
				return SimpleMp3Library[num].Genre;
			end
		elseif (x == 'bitrate') then
			if (SimpleMp3Library[num].BitRate == 'None') then
				return SIMPLEMP3_UNK_BITRATE;
			else
				return SimpleMp3Library[num].BitRate;
			end
		elseif (x == 'name') then
			return SimpleMp3Library[num].Name;
		elseif (x == 'name2') then
			return string.gsub(SimpleMp3Library[num].Name, "^.+\\", "");
		elseif (x == 'length') then
			return SimpleMp3Library[num].Length;
		elseif (x == 'length2') then
			return Time(SimpleMp3Library[num].Length);
		end
	else
		return SIMPLEMP3_UNK
	end
end

function LibraryDisplay(num)
	if (Smp3_Save.UseTags == 1) then
		return LIBInfo('song', num) .. " " .. "|cFFFFFFFF" .. LIBInfo('artist', num) .. " " .. "|r" .. LIBInfo('album', num) .. " " .. "|cFFFFFFFF" .. LIBInfo('genre', num) .. " " .. "|r" .. LIBInfo('bitrate', num) .. "k " .. "|cFFFFFFFF" .. LIBInfo('length2', num) .. "|r";
	else
		return LIBInfo('name2', num) .. " " .. LIBInfo('length2', num);
	end
end

-- Library Onshow tells it to update
function SimpleMp3Library_OnShow()
	SimpleMp3Library_update()
end

 -- When the scrollbar is changed so shall the list
function SimpleMp3Library_OnValueChanged()
	SimpleMp3Library_update()
end 
-- First load to set total population for the slider
function SimpleMp3Library_OnLoad()
	local SliderVar;
	this:RegisterForDrag("LeftButton");
	SliderVar = getglobal("SimpleMp3LibraryForm" .. "LibrarySlider");     
	if (SimpleMp3Library) then
		SliderVar:SetMinMaxValues(1, SliderMax(table.getn(SimpleMp3Library), Smp3_Save.LIBVisibleSlots));
	end
	SimpleMp3Library_update()
end

function SimpleMp3Library_OnEvent()
end

-- Library form populates the list according to window size
function PopulateLibrary()
	local LabelVar, SliderVar;    
	SliderVar = getglobal("SimpleMp3LibraryForm" .. "LibrarySlider");
	MaxLibraryNum = table.getn(SimpleMp3Library);
    
	if (MaxLibraryNum == 1) then
		LabelVar = getglobal("SimpleMp3LibraryForm" .. "LibraryPanel" .. 1);
		LabelVar:SetText(SliderVar:GetValue() + 0 .. ". " .. LibraryDisplay(SliderVar:GetValue() + 0));
    	elseif (Smp3_Save.LIBVisibleSlots <= MaxLibraryNum) then
		for i=1,Smp3_Save.LIBVisibleSlots do
			LabelVar = getglobal("SimpleMp3LibraryForm" .. "LibraryPanel" .. i);	
			LabelVar:SetText(SliderVar:GetValue() + (i - 1) .. ". " .. LibraryDisplay(SliderVar:GetValue() + (i - 1)));
		end
	else
		for i=1,MaxLibraryNum do
			LabelVar = getglobal("SimpleMp3LibraryForm" .. "LibraryPanel" .. i);	

			if (i > MaxLibraryNum) then
				return;		
			end        

			-- Debugging purposes while fixing playlist resizing issue
			-- DEFAULT_CHAT_FRAME:AddMessage(SliderVar:GetValue() .. " " .. i .. " " .. SimpleMp3Library[(SliderVar:GetValue() + i) - 1].Name);
			LabelVar:SetText(SliderVar:GetValue() + (i - 1) .. ". " .. LibraryDisplay(SliderVar:GetValue() + (i - 1)));
		end
	end
end

-- Library update (text show/hide routine)
-- This tells the resizable window how many slots are viewable at that size
function SimpleMp3Library_update()
	if (SimpleMp3Library) then
		MaxLibraryNum = table.getn(SimpleMp3Library);
		local fheight = SimpleMp3LibraryForm:GetHeight() 
		local SliderVar;
		SliderVar = getglobal("SimpleMp3LibraryForm" .. "LibrarySlider");
		
		for i = 1, 25 do
			if (MaxLibraryNum >= i) then
				if ((i * 14) + 37.8 < fheight) then   
					x = 'SimpleMp3LibraryFormLibraryPanel' .. i .. ':Show()'
					RunScript(x)
					SliderVar:SetMinMaxValues(1, SliderMax(table.getn(SimpleMp3Library), (i-1)));
					Smp3_Save.LIBVisibleSlots = i;
				else
					x = 'SimpleMp3LibraryFormLibraryPanel' .. i .. ':Hide()'
					RunScript(x)
				end
			else
				x = 'SimpleMp3LibraryFormLibraryPanel' .. i .. ':Hide()'
				RunScript(x)
			end
		end      

		-- Debugging purposes while fixing playlist issues
		-- DEFAULT_CHAT_FRAME:AddMessage(fheight);

		PopulateLibrary() 
	end
end

-- Function for when something in the Library is clicked
function SimpleMp3Library_OnClick(MouseButton, Number)
	if (SimpleMp3Library) then
		local SliderVar;
		SliderVar = getglobal("SimpleMp3LibraryForm" .. "LibrarySlider");
		SliderVar2 = getglobal("SimpleMp3VolumeForm" .. "Slider");
		LIBCurrent = (SliderVar:GetValue() + Number - 1);
		if (MouseButton == 'LeftButton' and IsShiftKeyDown()) then
			StopMusic();
			SliderVar2:SetValue(Smp3_Save.Volume);
			if (Smp3_Save.PlaySounds == 1) then
				PlaySound("igMiniMapZoomIn");
			end
			Hr  = 0;
			Min = 0;
			Sec = 0;
			SetTimeLabel("00:00:00");
			isPlaying = false;
			isPlayingDemo = true;
			SetPlayStopBnText(SIMPLEMP3_BINDPLAY);
			PlayMusic(Mp3Path .. LIBInfo('name', LIBCurrent) .. ".mp3"); -- FIXME
		elseif (MouseButton == 'LeftButton' and IsShiftKeyDown() == nil) then
			if (Smp3_Save.isShuffled == true) then
				DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_CANT_ADD);
			else
				if (Smp3_Save.PlaySounds == 1) then
					PlaySound("igMiniMapZoomIn");
				end
				tinsert(Smp3_Save.SimpleMp3PlayList, SimpleMp3Library[LIBCurrent]);
				--tremove(SimpleMp3Library, LIBCurrent);
			end
		end
		SetScrollText(Smp3_Save.Current);
		SetNameLabel(Smp3_Save.ScrollText);
		SimpleMp3Library_update()
	end
end

-- Exit Button
function SimpleMp3Library_OnExitClick()
	SimpleMp3LibraryForm:Hide();
end

-- Library scroll function
function SimpleMp3Library_OnMouseWheel(Direction)
	local SliderVar;
	SliderVar = getglobal("SimpleMp3LibraryForm" .. "LibrarySlider");
	
	if (Direction == 1) then
		SliderVar:SetValue(SliderVar:GetValue() - 1);
	else
		SliderVar:SetValue(SliderVar:GetValue() + 1);
	end
end

-- Function to Add All songs to the PlayList
function AddAll_button()
	for i = 1, table.getn(SimpleMp3Library) do
		tinsert(Smp3_Save.SimpleMp3PlayList, i, SimpleMp3Library[i]);
	end
	--[[for i = 1, table.getn(SimpleMp3Library) do
		tremove(SimpleMp3Library);
	end]]
	SetScrollText(Smp3_Save.Current);
	SetNameLabel(Smp3_Save.ScrollText);
	SimpleMp3Library_update()
end