function SimpleMp3Form_OnLoad()
	this:RegisterEvent("ADDON_LOADED")
	this:RegisterEvent("PLAYER_LEAVING_WORLD");
	this.TimeSinceLastUpdate = 0;
	this.TimeSinceLastScrollUpdate = 0;
end

function SimpleMp3Form_OnEvent()
	if (event == "ADDON_LOADED") then
		if (arg1 == 'SimpleMp3') then
			hooksecurefunc("ReloadUI", SimpleMp3_ReloadUI);
			hooksecurefunc("Logout", SimpleMp3_Logout);
			SavedVariablesUpdate()
			if (Smp3_Save.PlayListVersion ~= SimpleMp3_PL_VERSION) then
				DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_NEW_PL)
				Smp3_Save.PlayListVersion = SimpleMp3_PL_VERSION
			end
			SetTimeLabel("00:00:00");
			SetScrollText(Smp3_Save.Current);
			SetNameLabel(Smp3_Save.ScrollText);
			SetCVar("Sound_EnableMusic", Smp3_Save.MuteOnStop);
			StopMusic();
			tsort(SimpleMp3Library, Smp3_Save.sortFieldLIB, Smp3_Save.sortOrderLIB)			
			this:UnregisterEvent("ADDON_LOADED")
		end
	end
	if (event == "PLAYER_LEAVING_WORLD") then
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		if (isPlaying == true) then	-- stop music
			if (isScrolling == true) then
				Count = 0;
			end
			Hr  = 00;
			Min = 00;
			Sec = 00;
			if (Smp3_Save.PlaySounds == 1) then
				PlaySound("igMiniMapZoomIn");
			end
			StopMusic();
			Smp3_Save.Volume = SliderVar:GetValue()
			SetTimeLabel("00:00:00");
			SetCVar("Sound_EnableMusic", Smp3_Save.MuteOnStop);
			SetScrollText(Smp3_Save.Current);
			SetNameLabel(Smp3_Save.ScrollText);
			Smp3_Save.wasPlaying = true;
			isPlaying = false;
			isScrolling = true;
			ScrollBackward = true;
			ScrollForward = false;
			DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_STOPMUSIC);
			SetPlayStopBnText(SIMPLEMP3_BINDPLAY);
		end
		this:UnregisterEvent("PLAYER_LEAVING_WORLD");
	end
	if (event == "PLAYER_ENTERING_WORLD") then
		this:RegisterEvent("PLAYER_LEAVING_WORLD");
		if (Smp3_Save.wasPlaying == true) then
			Smp3_Save.playDelay = 5
		end
		this:UnregisterEvent("PLAYER_ENTERING_WORLD");
	end
end

function SimpleMp3Form_OnUpdate(ElapsedTime)
	this.TimeSinceLastUpdate = this.TimeSinceLastUpdate + ElapsedTime; 	
	this.TimeSinceLastScrollUpdate = this.TimeSinceLastScrollUpdate + ElapsedTime; 	
 	while (this.TimeSinceLastScrollUpdate > SimpleMp3_ScrollUpdate) do
		if (isScrolling == true) then
			ScrollNameLabel();
		end
   	this.TimeSinceLastScrollUpdate = this.TimeSinceLastScrollUpdate - SimpleMp3_ScrollUpdate;
  	end					
 	while (this.TimeSinceLastUpdate > SimpleMp3_UpdateInterval) do
 		if (Smp3_Save.wasPlaying == true) then
			if (Smp3_Save.playDelay >= 1) then
				Smp3_Save.playDelay = (Smp3_Save.playDelay - 1)
			elseif (Smp3_Save.playDelay == 0) then
				Smp3_Save.wasPlaying = false
				SimpleMp3_PlayStopClick()
			end
 		end
		if (Hr <= 9) then
			if (Min <= 9) then
				if (Sec <= 9) then
					SetTimeLabel("0" .. Hr .. ":0" .. Min .. ":0" .. Sec);            

				elseif (Sec >= 10) then
					SetTimeLabel ("0" .. Hr .. ":0" .. Min .. ":" .. Sec);
				end
			elseif (Min >= 10) then
				if (Sec <= 9) then
					SetTimeLabel("0" .. Hr .. ":" .. Min .. ":0" .. Sec);            

				elseif (Sec >= 10) then
					SetTimeLabel ("0" .. Hr .. ":" .. Min .. ":" .. Sec);
				end
			end
		elseif (Hr >= 10) then
			if (Min <= 9) then
				if (Sec <= 9) then
					SetTimeLabel(Hr .. ":0" .. Min .. ":0" .. Sec);            

				elseif (Sec >= 10) then
					SetTimeLabel (Hr .. ":0" .. Min .. ":" .. Sec);
				end
			elseif (Min >= 10) then
				if (Sec <= 9) then
					SetTimeLabel(Hr .. ":" .. Min .. ":0" .. Sec);            

				elseif (Sec >= 10) then
					SetTimeLabel (Hr .. ":" .. Min .. ":" .. Sec);
				end
			end
		end
		this.TimeSinceLastUpdate = this.TimeSinceLastUpdate - SimpleMp3_UpdateInterval;
  	end					
end

function NowPlaying()
	return SIMPLEMP3_NOWPLAY .. Smp3_Save.Current .. ". " .. PLInfo('song', Smp3_Save.Current) .. " " .. SIMPLEMP3_BY .. " " .. PLInfo('artist', Smp3_Save.Current) .. " " .. SIMPLEMP3_FROM .. " " .. PLInfo('album', Smp3_Save.Current);
end

function SetScrollText(num)
	if (PLInfo('name', num) ~= 'Unknown') then
		Smp3_Save.ScrollText = "    " .. num .. ". " .. PLInfo('song', num) .. " " .. SIMPLEMP3_BY .. " " .. PLInfo('artist', num) .. " " .. SIMPLEMP3_FROM .. " " .. PLInfo('album', num) .. " " .. PLInfo('length2', num);
	else
		Smp3_Save.ScrollText = SIMPLEMP3_DEFAULT_SCROLLTEXT
	end
end

-- Text Scrolling
function ScrollNameLabel()
	LengthOfStr = string.len(Smp3_Save.ScrollText);
	if (LengthOfStr <= 40) then
		return;
	end
	if (ScrollBackward == true) then
		Count = Count + 1;
		
		SetNameLabel(string.sub(Smp3_Save.ScrollText, Count));
		
		if (Count == (LengthOfStr - 40)) then
			ScrollBackward = false;
			ScrollForward = true;
			isScrolling = true;
		end
	elseif (ScrollForward == true) then
		Count = Count - 1;
		
		SetNameLabel(string.sub(Smp3_Save.ScrollText, Count));
		
		if (Count == 1) then
			ScrollBackward = true;
			ScrollForward = false;
			isScrolling = true;
		end
	end	
end

-- Sets the mp3 Name label text/color
function SetNameLabel(Text)
	local Name_Label;
	Name_Label = getglobal("SimpleMp3Form" .. "Mp3Name" .. "Label");
	Name_Label:SetText(Text);
	Name_Label:SetTextColor(0.50,1.0,1.0);	-- Blue
end

-- Sets the mp3 Time label text/color
function SetTimeLabel(Text)
	local Time_Label;
	Time_Label = getglobal("SimpleMp3Form" .. "Mp3Time" .. "Label");
	Time_Label:SetText(Text);
	Time_Label:SetTextColor(0.50,1.0,1.0);	-- Blue
end

-- Play/Stop button
function SimpleMp3_PlayStopClick()
	SliderVar = getglobal("SimpleMp3VolumeForm" .. "Slider");
	if (isPlaying == true) then	-- stop music
		if (isScrolling == true) then
			Count = 0;
		end
		Hr  = 00;
		Min = 00;
	   	Sec = 00;
	   	if (Smp3_Save.PlaySounds == 1) then
	        	PlaySound("igMiniMapZoomIn");
	        end
		StopMusic();
		Smp3_Save.Volume = SliderVar:GetValue()
		SetTimeLabel("00:00:00");
		SetCVar("Sound_EnableMusic", Smp3_Save.MuteOnStop);
		SetScrollText(Smp3_Save.Current);
		SetNameLabel(Smp3_Save.ScrollText);
		isPlaying = false;
		isScrolling = true;
		ScrollBackward = true;
		ScrollForward = false;
		DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_STOPMUSIC);
        	SetPlayStopBnText(SIMPLEMP3_BINDPLAY);
	elseif (isPlaying == false) then -- start music
		
		if (Smp3_Save.SimpleMp3PlayList[1]) then
			MaxPlayListNum = table.getn(Smp3_Save.SimpleMp3PlayList);
		else
			MaxPlayListNum = 0;
		end
		if (MaxPlayListNum == 0) then
			return;
		end
		if (isScrolling == true) then
			Count = 0;
		end
		
	   	if (Smp3_Save.PlaySounds == 1) then
	        	PlaySound("igMiniMapZoomIn");
	        end
		SliderVar:SetValue(Smp3_Save.Volume);
		SetCVar("Sound_EnableMusic", 1);
		PlayMusic(Mp3Path .. PLInfo('name', Smp3_Save.Current) .. ".mp3"); -- FIXME
		SetScrollText(Smp3_Save.Current);
       		SetNameLabel(Smp3_Save.ScrollText);
		isPlaying = true;
		isScrolling = true;
		ScrollBackward = true;
		DEFAULT_CHAT_FRAME:AddMessage(NowPlaying());
		SetPlayStopBnText(SIMPLEMP3_BINDSTOP);
	end	
end

--sets the play/stop button text
function SetPlayStopBnText(Text)
	local PlayStopBn;
	PlayStopBn = getglobal("SimpleMp3Form" .. "BnPlayStop");
	PlayStopBn:SetText(Text);
end

-- next button
function SimpleMp3_NextClick()
	Hr  = 00;
	Min = 00;
	Sec = 00;
	if (Smp3_Save.SimpleMp3PlayList[1]) then
		MaxPlayListNum = table.getn(Smp3_Save.SimpleMp3PlayList);
	else
		MaxPlayListNum = 1;
	end
	if (MaxPlayListNum == 1) then
		return;
	end
	
	if (Smp3_Save.Current == MaxPlayListNum) then
		Smp3_Save.Current = 1;
	else
		Smp3_Save.Current = Smp3_Save.Current + 1;
	end
	SetScrollText(Smp3_Save.Current);
	SetNameLabel(Smp3_Save.ScrollText);
	if (isPlaying == true) then
        StopMusic();
	if (Smp3_Save.PlaySounds == 1) then
		PlaySound("igMiniMapZoomIn");
	end
        PlayMusic(Mp3Path .. PLInfo('name', Smp3_Save.Current) .. ".mp3"); -- FIXME
        SetTimeLabel("00:00:00");
		DEFAULT_CHAT_FRAME:AddMessage(NowPlaying());
		
	end
	
	Count = 0;
	isScrolling = true;
	ScrollBackward = true;
	ScrollForward = false;
end

-- prev button
function SimpleMp3_PrevCLick()
	Hr  = 00;
	Min = 00;
	Sec = 00;
	if (Smp3_Save.SimpleMp3PlayList[1]) then
		MaxPlayListNum = table.getn(Smp3_Save.SimpleMp3PlayList);
	else
		MaxPlayListNum = 1;
	end
	if (MaxPlayListNum == 1) then
		return;
	end
	
	if (Smp3_Save.Current == 1) then
		Smp3_Save.Current = MaxPlayListNum;
	else
		Smp3_Save.Current = Smp3_Save.Current - 1;
	end
	
	SetScrollText(Smp3_Save.Current);
	SetNameLabel(Smp3_Save.ScrollText);
	if (isPlaying == true) then
        StopMusic();
	if (Smp3_Save.PlaySounds == 1) then
		PlaySound("igMiniMapZoomIn");
	end
	PlayMusic(Mp3Path .. PLInfo('name', Smp3_Save.Current) .. ".mp3"); -- FIXME
        SetTimeLabel("00:00:00");
	DEFAULT_CHAT_FRAME:AddMessage(NowPlaying());

	end
	
	Count = 0;
	isScrolling = true;
	ScrollBackward = true;
	ScrollForward = false;
end

-- Shuffle Button 
function SimpleMp3_ShuffleClick()
	   	if (Smp3_Save.PlaySounds == 1) then
	        	PlaySound("igMiniMapZoomIn");
	        end
	playing = PLInfo('name', Smp3_Save.Current)
	if (Smp3_Save.isShuffled == false) then
		if (Smp3_Save.SimpleMp3PlayList[1]) then
			for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				tinsert(Smp3_Save.BackupList, i, Smp3_Save.SimpleMp3PlayList[i]);
			end
			for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				local x = math.random(1,table.getn(Smp3_Save.SimpleMp3PlayList));
				tinsert(TempList, Smp3_Save.SimpleMp3PlayList[x]);
				tremove(Smp3_Save.SimpleMp3PlayList,x);
			end
			for i = 1, table.getn(TempList) do
				tinsert(Smp3_Save.SimpleMp3PlayList, i, TempList[i]);
				if (Smp3_Save.SimpleMp3PlayList[i].Name == playing) then
					Smp3_Save.Current = i
				end
			end
			for i = 1, table.getn(TempList) do
				tremove(TempList);
			end

			if (isPlaying == true) then
				if (isScrolling == true) then
					Count = 0;
				end
				SetScrollText(Smp3_Save.Current);
				SetNameLabel(Smp3_Save.ScrollText);
				ScrollBackward = true;
			end

			Smp3_Save.isShuffled = true;
			SetShuffleBnText(SIMPLEMP3_BINDSHUFFLEON)
			DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_SHUFFLEON);
			isScrolling = true;
			ScrollBackward = true;
			ScrollForward = false;
			Count = 0;
			SetScrollText(Smp3_Save.Current);
			SetNameLabel(Smp3_Save.ScrollText);
		else
			return
		end
	elseif (Smp3_Save.isShuffled == true) then
		if (Smp3_Save.SimpleMp3PlayList[1]) then
			for i = 1, table.getn(Smp3_Save.SimpleMp3PlayList) do
				tremove(Smp3_Save.SimpleMp3PlayList);
			end
			for i = 1, table.getn(Smp3_Save.BackupList) do
				tinsert(Smp3_Save.SimpleMp3PlayList, i, Smp3_Save.BackupList[i]);
				if (Smp3_Save.SimpleMp3PlayList[i].Name == playing) then
					Smp3_Save.Current = i
				end
			end
			for i = 1, table.getn(Smp3_Save.BackupList) do
				tremove(Smp3_Save.BackupList);
			end

			if (isPlaying == true) then
				if (isScrolling == true) then
					Count = 0;
				end
				SetScrollText(Smp3_Save.Current);
				SetNameLabel(Smp3_Save.ScrollText);
				ScrollBackward = true;
			end

			Smp3_Save.isShuffled = false;
			SetShuffleBnText(SIMPLEMP3_BINDSHUFFLEOFF)
			DEFAULT_CHAT_FRAME:AddMessage(SIMPLEMP3_SHUFFLEOFF);
			isScrolling = true;
			ScrollBackward = true;
			ScrollForward = false;
			Count = 0;
			SetScrollText(Smp3_Save.Current);
			SetNameLabel(Smp3_Save.ScrollText);
		else
			return
		end
	end
end

--sets the Shuffle button text
function SetShuffleBnText(Text)
	local ShuffleBn;
	ShuffleBn = getglobal("SimpleMp3Form" .. "BnShuffle");
	ShuffleBn:SetText(Text);
end

-- Playlist Button
function Playlist_button()
    if (SimpleMp3PlaylistForm:IsVisible()) then
       SimpleMp3PlaylistForm:Hide();
    else
       SimpleMp3PlaylistForm:Show();
    end
end

-- Library Button
function Library_button()
    if (SimpleMp3LibraryForm:IsVisible()) then
       SimpleMp3LibraryForm:Hide();
    else
       SimpleMp3LibraryForm:Show();
    end
end
