-- Lua is The Devil's Script 
-- SimpleMp3 code maintained by Paradox
-- Co Author (and previous Maintainer) Riptides

-- Global Variables
Mp3Path = "Interface\\AddOns\\SimpleMp3\\Mp3\\";
SimpleMp3_UpdateInterval = 1.0;
SimpleMp3_ScrollUpdate = 0.4;
isPlaying = false;
isPlayingDemo = false;
demoLimit = 15;
isScrolling = true;
ScrollBackward = true;
ScrollForward = false;
TempList = {};
Count = 0;
Hr  = 0;
Min = 0;
Sec = 0;
-- Stop the music after a ReloadUI
function SimpleMp3_ReloadUI()
	StopMusic();
	SetCVar("Sound_EnableMusic", Smp3_Save.MuteOnStop);
end

-- Stop the music after logging out
function SimpleMp3_Logout()
	StopMusic();
	SetCVar("Sound_EnableMusic", Smp3_Save.MuteOnStop);
end

function SavedVariablesUpdate()
	if (not Smp3_Save) then 
		Smp3_Save = {}
	end
	if (not Smp3_Save.Volume) then
		Smp3_Save.Volume = 0.5
	end
	if (not Smp3_Save.MuteOnStop) then
		Smp3_Save.MuteOnStop = 1
	end
	if (not Smp3_Save.PlaySounds) then
		Smp3_Save.PlaySounds = 1
	end
	if (not Smp3_Save.UseTags) then
		Smp3_Save.UseTags = 1
	end
	if (not Smp3_Save.isShuffled) then
		Smp3_Save.isShuffled = false
	end
	if (not Smp3_Save.Current) then
		Smp3_Save.Current = 1
	end
	if (not Smp3_Save.VisibleSlots) then
		Smp3_Save.VisibleSlots = 25
	end
	if (not Smp3_Save.LIBVisibleSlots) then
		Smp3_Save.LIBVisibleSlots = 25
	end
	if (not Smp3_Save.ScrollText) then
		Smp3_Save.ScrollText = SIMPLEMP3_DEFAULT_SCROLLTEXT
	end
	if (not Smp3_Save.PlayListVersion) then
		Smp3_Save.PlayListVersion = 0
	end
	if (not Smp3_Save.BackupList) then
		Smp3_Save.BackupList = {}
	end
	if (not Smp3_Save.SimpleMp3PlayList) then
		Smp3_Save.SimpleMp3PlayList = {}
	end
	if (not Smp3_Save.sortList) then
		Smp3_Save.sortList = 1
	end
	if (not Smp3_Save.sortOrderPL) then
		Smp3_Save.sortOrderPL = 1
	end
	if (not Smp3_Save.sortFieldPL) then
		Smp3_Save.sortFieldPL = 1
	end
	if (not Smp3_Save.sortOrderLIB) then
		Smp3_Save.sortOrderLIB = 1
	end
	if (not Smp3_Save.sortFieldLIB) then
		Smp3_Save.sortFieldLIB = 1
	end
	if (not Smp3_Save.wasPlaying) then
		Smp3_Save.wasPlaying = false
	end
	if (not Smp3_Save.playDelay) then
		Smp3_Save.playDelay = 0
	end
	return true
end
SavedVariablesUpdate()

function Time(sec)
	return SecondsToTime(sec);
end

function SliderMax(pln, num)
	if (pln <= num) then
		return (pln);
	else
		return (pln - num);
	end
end

function sortedpairs(t,comparator)
	local sortedKeys = {};
	table.foreach(t, function(k,v) table.insert(sortedKeys,k) end);
	table.sort(sortedKeys,comparator);
	local i = 0;
	local function _f(_s,_v)
		i = i + 1;
		local k = sortedKeys[i];
		if (k) then
			return k,t[k];
		end
	end
	return _f,nil,nil;
end

function tsort(t, field, direction)
	if (field == 1) then -- Name
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].Name) < string.lower(t[b].Name); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].Name) > string.lower(t[b].Name); end
		end
	elseif (field == 2) then -- Title
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].Title) < string.lower(t[b].Title); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].Title) > string.lower(t[b].Title); end
		end
	elseif (field == 3) then -- Artist
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].Artist) < string.lower(t[b].Artist); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].Artist) > string.lower(t[b].Artist); end
		end
	elseif (field == 4) then -- Album
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].Album) < string.lower(t[b].Album); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].Album) > string.lower(t[b].Album); end
		end
	elseif (field == 5) then -- Genre
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].Genre) < string.lower(t[b].Genre); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].Genre) > string.lower(t[b].Genre); end
		end
	elseif (field == 6) then -- Length
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].Length) < string.lower(t[b].Length); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].Length) > string.lower(t[b].Length); end
		end
	elseif (field == 7) then -- BitRate
		if (direction == 1) then
			function f(a,b) return string.lower(t[a].BitRate) < string.lower(t[b].BitRate); end
		elseif (direction == 2) then
			function f(a,b) return string.lower(t[a].BitRate) > string.lower(t[b].BitRate); end
		end
	end
	for k,v in sortedpairs(t, f) do
		tinsert(TempList, t[k])
	end
	for i = 1, table.getn(t) do
		tremove(t)
	end
	for i = 1, table.getn(TempList) do
		tinsert(t, TempList[i])
	end
	TempList = {}
end