local SML = LibStub("LibSharedMedia-2.0")
local SML_bars = SML:List("statusbar")
local SML_font = SML:List("font")

local lastUpdate = 0
function SimpleMD:OnUpdate()
	local doslow
	lastUpdate = lastUpdate + arg1
	if lastUpdate > 0.04 then
		doslow = true
		lastUpdate = 0
	end
	
	local t
	for k, v in pairs(this.owner.anchor.timers) do
		if not t then t = GetTime() end
		if (not doslow) and v.slow then
			--do nothing
		elseif v.running then
			v.elapsed = t - v.start
			if v.stop <= t then
				this.owner:StopTimer(k)
			else
				this.owner:UpdateTimer(k)
			end
		end
	end	
end

function SimpleMD:ClearTimers()
	for i = table.getn(SimpleMD.anchor.timers), 1, -1 do
		SimpleMD.anchor.timers[i]:Hide()
		table.insert(SimpleMD.recyclePile, table.remove(SimpleMD.anchor.timers))
		table.remove(SimpleMD.idents, i)
		SimpleMD.timercount = SimpleMD.timercount - 1
	end
end

function SimpleMD:ReadinessCheck(name)
	for k, v in pairs(SimpleMD.idents) do
		if v == name then
			local reverse = SimpleMD.anchor.timers[k].reversed
			SimpleMD.anchor.timers[k].timer:SetValue(reverse and 1 or 0)
			SimpleMD:StopTimer(k)
		end
	end
end

function SimpleMD:UpdateTimer(index)
	local t = SimpleMD.anchor.timers[index].time - SimpleMD.anchor.timers[index].elapsed
	SimpleMD.anchor.timers[index].slow = t > 11
	
	local newtimetext
	
	local h = floor(t/3600)
	local m = t - (h*3600)
	m = floor(m/60)
	local s = t - ((h*3600) + (m*60))
	
	if h > 0 then
		newtimetext = ("%d:%02d"):format(h, m)
	elseif m > 0 then
		newtimetext = string.format("%d:%02d", m, floor(s))
	elseif s < 10 then
		newtimetext = string.format("%1.1f", s)
	else
		newtimetext = string.format("%.0f", floor(s))
	end
	
	SimpleMD.anchor.timers[index].timetext:SetText(newtimetext)
	
	local percent = t / SimpleMD.anchor.timers[index].time
	local reverse = SimpleMD.anchor.timers[index].reversed
	SimpleMD.anchor.timers[index].timer:SetValue(reverse and 1-percent or percent)
end

function SimpleMD:StopTimer(index)	
	SimpleMD.anchor.timers[index].running = false
	if not SimpleMD.anchor.timers[index].stayonscreen then
		for k, v in pairs(SimpleMD.anchor.timers) do
			if k == 1 then
				--nothing
			elseif k == 2 then
				SimpleMD.anchor.timers[k]:ClearAllPoints()
				SimpleMD.anchor.timers[k]:SetPoint("TOP", SimpleMD.frame, "BOTTOM", 10, 5)
			else
				if SimpleMD.anchor.timers[index].growup then
					SimpleMD.anchor.timers[k]:ClearAllPoints()
					SimpleMD.anchor.timers[k]:SetPoint("BOTTOM", SimpleMD.anchor.timers[k-1], "TOP", 0, 0)
				else
					SimpleMD.anchor.timers[k]:ClearAllPoints()
					SimpleMD.anchor.timers[k]:SetPoint("TOP", SimpleMD.anchor.timers[k-1], "BOTTOM", 0, 0)
				end
			end
		end
		SimpleMD:RecycleTimer(index)
	else
		SimpleMD.anchor.timers[index].timetext:SetText("")
		local i = string.find(SimpleMD.anchor.timers[index].text:GetText(), " ")
		local temp = string.sub(SimpleMD.anchor.timers[index].text:GetText(), 1, i-1)
		SimpleMD.anchor.timers[index].text:SetJustifyH("CENTER")
		SimpleMD.anchor.timers[index].text:SetText(temp.." ready!")
	end
end

function SimpleMD:RecycleTimer(index)
	local alias = SimpleMD.anchor.timers[index]
	if not alias then
		return
	end
	
	alias:Hide()
	SimpleMD.timercount = SimpleMD.timercount - 1
	table.insert(SimpleMD.recyclePile, alias)
	table.remove(SimpleMD.anchor.timers, index)
	table.remove(SimpleMD.idents, index)
end

function SimpleMD:ReanchorTimers(growth)
	for k, v in pairs(SimpleMD.anchor.timers) do
		if k >= 2 then
			if growth then
				SimpleMD.anchor.timers[k]:ClearAllPoints()
				SimpleMD.anchor.timers[k]:SetPoint("BOTTOM", SimpleMD.anchor.timers[k-1], "TOP", 0, 0)
				SimpleMD.anchor.timers[k].growup = growth
			else
				SimpleMD.anchor.timers[k]:ClearAllPoints()
				SimpleMD.anchor.timers[k]:SetPoint("TOP", SimpleMD.anchor.timers[k-1], "BOTTOM", 0, 0)
				SimpleMD.anchor.timers[k].growup = growth
			end
		end
	end
end

function SimpleMD:RefreshTimer(index, caster, target, runtime, reverse, stay, growth)
	local alias = SimpleMD.anchor.timers[index]
	if not alias then
		return
	end
	
	alias.timer:SetStatusBarColor(self.db.profile.cbarR, self.db.profile.cbarG, self.db.profile.cbarB, 1)
	alias.timer.bg:SetVertexColor(self.db.profile.BGr, self.db.profile.BGg, self.db.profile.BGb)
	alias.timer.bg:SetAlpha(self.db.profile.bg_alpha)
	alias.timer:SetValue(1)
	alias.text:SetJustifyH("LEFT")
	if target then
		alias.text:SetText(caster.." - "..target)
	else
		alias.text:SetText(caster)
	end
	alias.timetext:SetText(runtime)
	alias.timer:SetStatusBarTexture(SML:Fetch('statusbar', SimpleMD.db.profile.texture))
	alias.timer.bg:SetTexture(SML:Fetch('statusbar', SimpleMD.db.profile.texture))
	
	local curTime = GetTime()
	alias.start = curTime
	alias.stop = curTime + runtime
	alias.elapsed = 0
	alias.time = runtime
	alias.running = true
	alias.reversed = reverse
	alias.stayonscreen = stay
end

function SimpleMD:CreateTimer(caster, target, runtime, reverse, stay, growth)
	for k, v in pairs(SimpleMD.idents) do
		if v == caster then
			SimpleMD:RefreshTimer(k, caster, target, runtime, reverse, stay, growth)
			return
		end
	end
	
	SimpleMD.timercount = SimpleMD.timercount + 1
	
	local t
	if #SimpleMD.recyclePile > 0 then
		t = table.remove(SimpleMD.recyclePile)
	else
		t = CreateFrame("BUTTON", nil, SimpleMD.frame)
	end
	
	t.owner = SimpleMD
	t:SetWidth(SimpleMD.db.profile.barWidth * SimpleMD.db.profile.barScale)
	t:SetHeight(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
	t:ClearAllPoints()
	if SimpleMD.timercount == 1 then
		t:SetPoint("TOP", SimpleMD.frame, "BOTTOM", 10, 5)
	else
		if growth then
			t:SetPoint("BOTTOM", SimpleMD.anchor.timers[SimpleMD.timercount-1], "TOP", 0, 0)
		else
			t:SetPoint("TOP", SimpleMD.anchor.timers[SimpleMD.timercount-1], "BOTTOM", 0, 0)
		end
	end
	if not t.timer then
		t.timer = CreateFrame("STATUSBAR", nil, t)
	end
	t.timer:ClearAllPoints()
	t.timer:SetPoint("TOPLEFT", t, "TOPLEFT")
	t.timer:SetPoint("BOTTOMRIGHT", t, "BOTTOMRIGHT")
	t.timer:SetStatusBarTexture(SML:Fetch('statusbar', SimpleMD.db.profile.texture))
	t.timer:SetStatusBarColor(self.db.profile.cbarR, self.db.profile.cbarG, self.db.profile.cbarB, 1)
	t.timer:SetMinMaxValues(0, 1)
	t.timer:SetValue(1)
	
	if not t.timer.bg then
		t.timer.bg = t.timer:CreateTexture(nil, "BACKGROUND")
	end
	t.timer.bg:ClearAllPoints()
	t.timer.bg:SetAllPoints(t.timer)
	t.timer.bg:SetTexture(SML:Fetch('statusbar', SimpleMD.db.profile.texture))
	t.timer.bg:SetVertexColor(self.db.profile.BGr, self.db.profile.BGg, self.db.profile.BGb)
	t.timer.bg:SetAlpha(self.db.profile.bg_alpha)
	
	if not t.icon then
		t.icon = t:CreateTexture()
	end
	t.icon:SetTexture(SimpleMD.tex)
	t.icon:ClearAllPoints()
	t.icon:SetPoint("RIGHT", t, "LEFT", 0, 0)
	t.icon:SetTexCoord(.07, .93, .07, .93)
	t.icon:SetWidth(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
	t.icon:SetHeight(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
	
	if not t.text then
		t.text = t.timer:CreateFontString(nil, "LOW")
	end
	t.text:SetWidth(SimpleMD.db.profile.barWidth * SimpleMD.db.profile.barScale)
	t.text:SetHeight(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
	t.text:SetFont(SML:Fetch('font', SimpleMD.db.profile.font), SimpleMD.db.profile.textSize)
	t.text:SetTextColor(SimpleMD.db.profile.txtR, SimpleMD.db.profile.txtG, SimpleMD.db.profile.txtB, 1)
	t.text:SetJustifyH("LEFT")
	t.text:SetJustifyV("MIDDLE")
	t.text:ClearAllPoints()
	t.text:SetPoint("TOP", t.timer, "TOP", 5, 0)
	if target then
		t.text:SetText(caster.."  -  "..target)
	else
		t.text:SetText(caster)
	end
	
	if not t.timetext then
		t.timetext = t.timer:CreateFontString(nil, "LOW")
	end
	t.timetext:SetWidth(SimpleMD.db.profile.barWidth * SimpleMD.db.profile.barScale)
	t.timetext:SetHeight(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
	t.timetext:SetFont(SML:Fetch('font', SimpleMD.db.profile.font), SimpleMD.db.profile.textSize)
	t.timetext:SetTextColor(SimpleMD.db.profile.txtR, SimpleMD.db.profile.txtG, SimpleMD.db.profile.txtB, 1)
	t.timetext:SetJustifyH("RIGHT")
	t.timetext:SetJustifyV("MIDDLE")
	t.timetext:ClearAllPoints()
	t.timetext:SetPoint("TOP", t.timer, "TOP", -5, 0)
	t.timetext:SetText(runtime)
	
	local curTime = GetTime()
	t.start = curTime
	t.stop = curTime + runtime
	t.elapsed = 0
	t.time = runtime
	t.running = true
	t.reversed = reverse
	t.growup = growth
	t.stayonscreen = stay
	
	t:SetFrameStrata("LOW")
	t:Show()
	
	local function DisableMouse(Frame)
		if Frame:IsMouseEnabled() then
			Frame:EnableMouse(false)
		end
		if Frame:GetChildren() then
			for _,child in pairs({Frame:GetChildren()}) do
				if child:IsMouseEnabled() then
					child:EnableMouse(false)
				end
				DisableMouse(child)
			end 
		end
	end
	DisableMouse(t)
	
	table.insert(SimpleMD.anchor.timers, t)
	table.insert(SimpleMD.idents, caster)
end

function SimpleMD:CreateAnchor(text)
	local f = CreateFrame("BUTTON", "smdAnchor", UIParent)
	local g = CreateFrame("FRAME", nil, UIParent)
	f:SetWidth(200)
	f:SetHeight(25)
	g:SetWidth(200)
	g:SetHeight(25)
	
	f.owner = SimpleMD
	g.owner = SimpleMD
	
	if SimpleMD.db.profile.position.x and SimpleMD.db.profile.position.y and SimpleMD.db.profile.position.anchor and SimpleMD.db.profile.position.point then
		f:ClearAllPoints()
		g:ClearAllPoints()
		f:SetPoint(SimpleMD.db.profile.position.point, UIParent, SimpleMD.db.profile.position.anchor, SimpleMD.db.profile.position.x, SimpleMD.db.profile.position.y)
		g:SetPoint(SimpleMD.db.profile.position.point, UIParent, SimpleMD.db.profile.position.anchor, SimpleMD.db.profile.position.x, SimpleMD.db.profile.position.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER")
		g:SetPoint("CENTER", UIParent, "CENTER")
	end
	
	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
		function ()
			this:StopMovingOrSizing()
			local point, _, anchor, x, y = this:GetPoint()
			this.owner.db.profile.position.x = math.floor(x)
			this.owner.db.profile.position.y = math.floor(y)
			this.owner.db.profile.position.anchor = anchor
			this.owner.db.profile.position.point = point
			g:ClearAllPoints()
			g:SetPoint(point, UIParent, anchor, x, y)
		end)
	
	f:SetBackdrop({
		bgFile = [[Interface\Tooltips\UI-Tooltip-Background]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 5, top = 5, bottom = 5 }
		})
		
	f:SetBackdropColor(0, 1, 0, .65)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	f:SetClampedToScreen(true)
	f:EnableMouse(true)
	
	f.text = f:CreateFontString(nil, "OVERLAY")
	f.text:SetFontObject(GameFontNormalSmall)
	f.text:ClearAllPoints()
	f.text:SetTextColor(1, 1, 1, 1)
	f.text:SetWidth(200)
	f.text:SetHeight(25)
	f.text:SetPoint("TOP", f, "TOP")
	f.text:SetJustifyH("CENTER")
	f.text:SetJustifyV("MIDDLE")
	f.text:SetText(text)
	
	f:Hide()
	g:Show()
	
	g:SetScript("OnUpdate", SimpleMD.OnUpdate)
	g:EnableMouse(false)
	
	return f, g
end
