

local o = SimpleDruidBar; if (o == nil) then return; end


local l_t_Init; -- ()

local l_OnEvent_PLAYER_LOGIN; -- ()
local l_OnEvent_PLAYER_LOGOUT; -- ()

local l_OnEvent_UNIT_MANA; -- (unit)
local l_OnEvent_UNIT_STATS; -- (unit)

local l_OnFeralShapeshiftCast; -- (name)
local l_OnEvent_UNIT_SPELLCAST_SUCCEEDED; -- (unit, abilityName, abilityRank)

local l_OnShiftIn; -- ()
local l_OnShiftOut; -- ()
local l_OnEvent_UNIT_DISPLAYPOWER; -- (unit)

local l_DisplayBar_OnValueChanged; -- (self, value)
local l_DisplayBar_OnDragStart; -- (self)
local l_DisplayBar_OnDragStop; -- (self)
local l_t_CreateBar; -- bar = ()


local mathfloor = math.floor; -- OnEvent_UNIT_MANA, OnEvent_PLAYER_LOGIN, OnShiftIn

local GetTime = GetTime; -- OnEvent_UNIT_MANA, OnEvent_PLAYER_LOGIN, OnFeralShapeshiftCast
local UnitMana = UnitMana; -- OnFeralShapeshiftCast, OnEvent_PLAYER_LOGIN
local UnitManaMax = UnitManaMax; -- OnFeralShapeshiftCast, OnEvent_PLAYER_LOGIN
local UnitStat = UnitStat; -- OnEvent_UNIT_STATS, OnShiftIn
local UnitPowerType = UnitPowerType; -- OnEvent_PLAYER_LOGOUT, OnEvent_UNIT_DISPLAYPOWER


local l_DISPLAY_BAR;


local l_currMana;
local l_maxMana;
local l_lastPulse;
local l_lastKnownInt;
local l_fiveSecInit;




function l_t_Init()
	l_t_Init = nil;
	o.t_Display_Init = nil;
	
	local RFE = o.EventsManager1.RegisterForEvent;
	RFE(l_OnEvent_UNIT_DISPLAYPOWER, nil, "UNIT_DISPLAYPOWER", false, false);
	RFE(l_OnEvent_UNIT_SPELLCAST_SUCCEEDED, nil, "UNIT_SPELLCAST_SUCCEEDED", false, false);
	RFE(l_OnEvent_PLAYER_LOGIN, nil, "PLAYER_LOGIN", false, false);
	RFE(l_OnEvent_PLAYER_LOGOUT, nil, "PLAYER_LOGOUT", false, false);
end

o.t_Display_Init = l_t_Init;




function l_OnEvent_PLAYER_LOGIN()
	l_OnEvent_PLAYER_LOGIN = nil;
	
	local mem = SimpleDruidBar_ManaMemory;
	if (mem ~= nil) then
		SimpleDruidBar_ManaMemory = nil;
		local currMana, maxMana, lastInt = (","):split(mem);
		if (maxMana ~= nil) then
			local tonumber = tonumber;
			l_currMana = tonumber(currMana);
			l_maxMana = tonumber(maxMana);
			l_lastKnownInt = tonumber(lastInt);
			l_lastPulse = GetTime();
			
			local bar = (l_DISPLAY_BAR or l_t_CreateBar());
			bar:SetMinMaxValues(0, l_maxMana);
			bar:SetValue(mathfloor(l_currMana));
			bar:Show();
		end
	else
		l_currMana = UnitMana("player");
		l_maxMana = UnitManaMax("player");
	end
end



function l_OnEvent_PLAYER_LOGOUT()
	if (UnitPowerType("player") ~= 0) then
		SimpleDruidBar_ManaMemory = (","):join(l_currMana,  l_maxMana, l_lastKnownInt);
	end
	if (l_DISPLAY_BAR ~= nil) then
		l_DISPLAY_BAR:SetUserPlaced(false);
		local config = SimpleDruidBar_Config;
		config.offsetX, config.offsetY = l_DISPLAY_BAR:GetCenter();
	end
end




do
	local GetManaRegen = GetManaRegen;
	
	-- This function is only called while in a non-mana form.
	function l_OnEvent_UNIT_MANA(unit)
		if (unit ~= "player") then return; end
		
		local currTime = GetTime();
		local regen, whileCasting = GetManaRegen();
		if (l_fiveSecInit ~= nil) then
			if (currTime < l_fiveSecInit) then
				regen = whileCasting;
			else
				l_fiveSecInit = nil;
			end
		end
		local tickMana = (((currTime - l_lastPulse) / 2.0) * (regen * 2.0));
		l_lastPulse = currTime;
		
		local newMana = (l_currMana + tickMana);
		if (newMana > l_maxMana) then
			newMana = l_maxMana;
		end
		l_currMana = newMana;
		l_DISPLAY_BAR:SetValue(mathfloor(newMana));
	end
end



-- This function is only called while in a non-mana form.
function l_OnEvent_UNIT_STATS(unit)
	if (unit ~= "player") then return; end
	
	local lastInt = l_lastKnownInt;
	local currInt = UnitStat("player", 4);
	local difference;
	if (currInt ~= lastInt) then
		if (currInt < lastInt) then
			difference = -((lastInt - currInt) * 15);
		else
			difference = ((currInt - lastInt) * 15);
		end
	else
		difference = 0;
	end
	
	if (difference ~= 0) then
		local newMax = (l_maxMana + difference);
		l_DISPLAY_BAR:SetMinMaxValues(0, newMax);
		l_DisplayBar_OnValueChanged(l_DISPLAY_BAR, l_DISPLAY_BAR:GetValue());
		l_maxMana = newMax;
		l_lastKnownInt = currInt;
	end
end




do
	local GetSpellInfo = GetSpellInfo;
	
	-- This function is called after the shapeshift spell is cast, but before the power bar changes.
	function l_OnFeralShapeshiftCast(name)
		local currMana;
		if (UnitPowerType("player") == 0) then
			currMana = UnitMana("player");
			l_maxMana = UnitManaMax("player");
		else
			currMana = l_currMana;
		end
		
		local currTime = GetTime();
		l_fiveSecInit = (currTime + 5.0);
		l_lastPulse = currTime;
		
		local _, _, _, cost = GetSpellInfo(name);
		l_currMana = (currMana - cost);
	end
	
	o.Display_OnFeralShapeshiftCast = l_OnFeralShapeshiftCast;
end



do
	l_OnEvent_UNIT_SPELLCAST_SUCCEEDED = assert(loadstring([[
		local l_OnFeralShapeshiftCast = SimpleDruidBar.Display_OnFeralShapeshiftCast;
		return (
		  function(unit, abilityName, abilityRank)
			if (
			  unit == "player"
			  and abilityRank == "]] .. o.Localization.SHAPESHIFT .. [["
			  and (
				abilityName == "]] .. o.Localization.CAT_FORM .. [["
				or abilityName == "]] .. o.Localization.DIRE_BEAR_FORM .. [["
				or abilityName == "]] .. o.Localization.BEAR_FORM .. [["
			  )
			) then
				l_OnFeralShapeshiftCast(abilityName);
			end
		  end
		);
	]]))();
	o.Display_OnFeralShapeshiftCast = nil;
	o.Localization.SHAPESHIFT = nil;
	o.Localization.CAT_FORM = nil;
	o.Localization.DIRE_BEAR_FORM = nil;
	o.Localization.BEAR_FORM = nil;
end




-- This function is called right after the power bar changes to rage/energy.
function l_OnShiftIn()
	l_lastKnownInt = UnitStat("player", 4);
	o.EventsManager1.RegisterForEvent(l_OnEvent_UNIT_STATS, nil, "UNIT_STATS", false, false);
	o.EventsManager1.RegisterForEvent(l_OnEvent_UNIT_MANA, nil, "UNIT_MANA", false, false);
	
	local bar = (l_DISPLAY_BAR or l_t_CreateBar());
	bar:SetMinMaxValues(0, l_maxMana);
	bar:SetValue(mathfloor(l_currMana));
	bar:Show();
end



-- This function is called right after the power bar changes to mana.
function l_OnShiftOut()
	l_fiveSecInit = nil;
	l_lastPulse = nil;
	l_lastKnownInt = nil;
	o.EventsManager1.UnregisterForEvent(l_OnEvent_UNIT_STATS, "UNIT_STATS");
	o.EventsManager1.UnregisterForEvent(l_OnEvent_UNIT_MANA, "UNIT_MANA");
	
	local bar = l_DISPLAY_BAR;
	if (bar ~= nil) then
		bar:Hide();
	end
end



function l_OnEvent_UNIT_DISPLAYPOWER(unit)
	if (unit ~= "player") then return; end
	
	if (UnitPowerType("player") == 0) then
		l_OnShiftOut();
	else
		l_OnShiftIn();
	end
end




function l_DisplayBar_OnValueChanged(self, value)
	local minVal, maxVal = self:GetMinMaxValues();
	self.TEXT:SetFormattedText("%d / %d", value, maxVal);
end



do
	l_DisplayBar_OnDragStart = GENERIC_FRAME_START_MOVING;
	if (l_DisplayBar_OnDragStart == nil) then
		local func = (function(self) self:StartMoving(); end);
		GENERIC_FRAME_START_MOVING = func;
		l_DisplayBar_OnDragStart = func;
	end
end


do
	l_DisplayBar_OnDragStop = GENERIC_FRAME_STOP_MOVING_OR_SIZING;
	if (l_DisplayBar_OnDragStop == nil) then
		local func = (function(self) self:StopMovingOrSizing(); end);
		GENERIC_FRAME_STOP_MOVING_OR_SIZING = func;
		l_DisplayBar_OnDragStop = func;
	end
end



function l_t_CreateBar()
	l_t_CreateBar = nil;
	
	local bar = CreateFrame("StatusBar", "SimpleDruidBar_DisplayBar", UIParent, nil);
	l_DISPLAY_BAR = bar;
	bar:Hide();
	bar:SetFrameStrata("LOW");
	bar:SetWidth(120);
	bar:SetHeight(14);
	bar:SetAlpha(1.0);
	local config = SimpleDruidBar_Config;
	bar:SetPoint("CENTER", UIParent, "BOTTOMLEFT", config.offsetX, config.offsetY);
	bar:SetScript("OnValueChanged", l_DisplayBar_OnValueChanged);
	bar:SetMovable(true);
	bar:EnableMouse(true);
	bar:RegisterForDrag("LeftButton", "RightButton");
	bar:SetScript("OnDragStart", l_DisplayBar_OnDragStart);
	bar:SetScript("OnDragStop", l_DisplayBar_OnDragStop);
	bar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar");
	bar:SetStatusBarColor(0.0, 0.0, 1.0);
	
	local barText = bar:CreateFontString("SimpleDruidBar_DisplayBarText", "OVERLAY", nil);
	barText:SetFont("Fonts\\ARIALN.ttf", 14, "OUTLINE");
	barText:SetPoint("CENTER", bar, "CENTER", 0, 0);
	barText:SetJustifyH("CENTER");
	bar.TEXT = barText;
	
	local border = bar:CreateTexture("SimpleDruidBar_DisplayBarBorder", "OVERLAY", nil);
	border:Show();
	border:SetTexture("Interface\\Tooltips\\UI-StatusBar-Border");
	
	local backdrop = bar:CreateTexture("SimpleDruidBar_DisplayBarBackdrop", "BACKGROUND", nil);
	backdrop:Show();
	backdrop:SetAllPoints(bar);
	backdrop:SetTexture(0.2, 0.2, 0.2, 1.0);
	
	o.t_Config_OnDisplayBarLoaded(bar);
	return bar;
end

