

local o = SimpleDruidBar; if (o == nil) then return; end


local l_t_Init; -- ()
local l_t_OnDisplayBarLoaded; -- (bar)

local l_OnAlphaChanged; -- (new)
local l_OnWidthChanged; -- (new)
local l_OnHeightChanged; -- (new)
local l_SetupBarBorder; -- ()
local l_OnTextStyleChanged; -- (new)
	-- local l_DisplayBar_OnEnter; -- (self)
	-- local l_DisplayBar_OnLeave; -- (self)


local l_DISPLAY_BAR;




function l_t_Init()
	l_t_Init = nil;
	o.t_Config_Init = nil;
	
	
	local defaults = {
		alpha = 1.0;
		width = 120;
		height = 14;
		textStyle = 1;
	};
	
	local handlers = {
		alpha = {
			validInputTypes = ("number");
			onChange = l_OnAlphaChanged;
		};
		width = {
			validInputTypes = ("number");
			onChange = l_OnWidthChanged;
		};
		height = {
			validInputTypes = ("number");
			onChange = l_OnHeightChanged;
		};
		textStyle = {
			validInputTypes = ("number");
			onChange = l_OnTextStyleChanged;
			extraInputValidators = {
				matchAll = {
					[1] = {
						validatorType = ("string-comparison");
						stringMatcher = ("^[123]$");
					};
				};
			};
		};
	};
	
	local configClient = ConfigManager1.RegisterClient("SimpleDruidBar_Config", handlers, defaults, nil, nil, false);
	
	
	local sCmds = o.Localization.SLASH_COMMANDS;
	SimpleSlash1.RegisterClient(
	  "SimpleDruidBar",
	  {
		_handlerObj = configClient;
		_sendHandler = true;
		[sCmds.TEXT] = {
			extraStartArg = ("textStyle");
			get = ("GetValue");
			noArgForGet = true;
			set = ("SetValue");
			noStatusInversion = true;
			usageText = sCmds.TEXT_USAGE;
			statusText = sCmds.TEXT_STATUS;
			plainStatus = true;
			errorText = sCmds.TEXT_ERROR;
		};
		[sCmds.WIDTH] = {
			extraStartArg = ("width");
			get = ("GetValue");
			noArgForGet = true;
			set = ("SetValue");
			noStatusInversion = true;
			usageText = sCmds.WIDTH_USAGE;
			statusText = sCmds.WIDTH_STATUS;
			plainStatus = true;
			errorText = sCmds.WIDTH_ERROR;
		};
		[sCmds.HEIGHT] = {
			extraStartArg = ("height");
			get = ("GetValue");
			noArgForGet = true;
			set = ("SetValue");
			noStatusInversion = true;
			usageText = sCmds.HEIGHT_USAGE;
			statusText = sCmds.HEIGHT_STATUS;
			plainStatus = true;
			errorText = sCmds.HEIGHT_ERROR;
		};
		[sCmds.ALPHA] = {
			extraStartArg = ("alpha");
			get = ("GetValue");
			noArgForGet = true;
			set = ("SetValue");
			noStatusInversion = true;
			usageText = sCmds.ALPHA_USAGE;
			statusText = sCmds.ALPHA_STATUS;
			plainStatus = true;
			errorText = sCmds.ALPHA_ERROR;
		};
	  }
	);
	SimpleSlash1.RegisterPrefix("SimpleDruidBar", sCmds.PREFIX_1);
	o.Localization = nil;
end

o.t_Config_Init = l_t_Init;



function l_t_OnDisplayBarLoaded(bar)
	l_t_OnDisplayBarLoaded = nil;
	o.t_Config_OnDisplayBarLoaded = nil;
	
	l_DISPLAY_BAR = bar;
	local config = SimpleDruidBar_Config;
	bar:SetAlpha(config.alpha);
	bar:SetWidth(config.width);
	bar:SetHeight(config.height);
	l_SetupBarBorder();
	l_OnTextStyleChanged(config.textStyle);
end

o.t_Config_OnDisplayBarLoaded = l_t_OnDisplayBarLoaded;




function l_OnAlphaChanged(new)
	if (l_DISPLAY_BAR ~= nil) then
		l_DISPLAY_BAR:SetAlpha(new);
	end
end



function l_OnWidthChanged(new)
	if (l_DISPLAY_BAR ~= nil) then
		l_DISPLAY_BAR:SetWidth(new);
		l_SetupBarBorder();
	end
end


function l_OnHeightChanged(new)
	if (l_DISPLAY_BAR ~= nil) then
		l_DISPLAY_BAR:SetHeight(new);
		l_SetupBarBorder();
	end
end


do
	local mathceil = math.ceil;
	
	function l_SetupBarBorder()
		local bar = l_DISPLAY_BAR;
		local border = SimpleDruidBar_DisplayBarBorder;
		border:ClearAllPoints();
		
		local widthOffset = mathceil(bar:GetWidth() / 40);
		border:SetPoint("LEFT", bar, "LEFT", -widthOffset, 0);
		border:SetPoint("RIGHT", bar, "RIGHT", widthOffset, 0);
		
		local heightOffset = mathceil(bar:GetHeight() / 4);
		border:SetPoint("TOP", bar, "TOP", 0, heightOffset);
		border:SetPoint("BOTTOM", bar, "BOTTOM", 0, -heightOffset);
	end
end



do
	local l_DisplayBar_OnEnter;
	local l_DisplayBar_OnLeave;
	
	function l_OnTextStyleChanged(new)
		local bar = l_DISPLAY_BAR;
		if (bar ~= nil) then
			if (new == 1) then
				bar:SetScript("OnEnter", nil);
				bar:SetScript("OnLeave", nil);
				bar.TEXT:Show();
			elseif (new == 2) then
				bar:SetScript("OnEnter", l_DisplayBar_OnEnter);
				bar:SetScript("OnLeave", l_DisplayBar_OnLeave);
				bar.TEXT:Hide();
			elseif (new == 3) then
				bar:SetScript("OnEnter", nil);
				bar:SetScript("OnLeave", nil);
				bar.TEXT:Hide();
			end
		end
	end
	
	
	do
		function l_DisplayBar_OnEnter(self)
			self.TEXT:Show();
		end
	end
	
	
	do
		function l_DisplayBar_OnLeave(self)
			self.TEXT:Hide();
		end
	end
end

