function SimpleBar:BagsBar_posUpdate()
    if not self.db.account.bags then return false; end
	point, relativeTo, relativePoint, xOfs, yOfs = MainMenuBar:GetPoint();
	x = -5;
	y = yOfs + 5;
    MainMenuBarBackpackButton:ClearAllPoints();
	MainMenuBarBackpackButton:SetPoint("BOTTOMRIGHT", relativeTo, "BOTTOMRIGHT", x, y);
	KeyRingButton:ClearAllPoints();
    KeyRingButton:SetPoint("BOTTOMRIGHT", CharacterBag3Slot, "BOTTOMLEFT", -5, -2);
end

function SimpleBar:MenuBar_posUpdate()
	if not self.db.account.menu then return false; end
	point, relativeTo, relativePoint, xOfs, yOfs = MainMenuBar:GetPoint();
	x = -185;
	y = yOfs + 45;
	if not self.db.account.bags then
		y = y - 40;
	end
    CharacterMicroButton:ClearAllPoints();
    CharacterMicroButton:SetPoint("BOTTOMRIGHT", WorldFrame, "BOTTOMRIGHT", x, y);
end

function SimpleBar:LatencyBar_posUpdate()
	if not self.db.account.latency then return false; end
	point, relativeTo, relativePoint, xOfs, yOfs = MainMenuBar:GetPoint();
	if self.db.account.bags then
		x = -230;
	elseif self.db.account.menu then
		x = -210;
	else
		x = 0;
	end
	y = yOfs -7;
	MainMenuBarPerformanceBarFrame:ClearAllPoints();
    MainMenuBarPerformanceBarFrame:SetPoint("BOTTOMRIGHT", WorldFrame, "BOTTOMRIGHT", x, y);
end

function SimpleBar:UpdateFrames(...) 
	self:BagsBar_posUpdate();
	self:MenuBar_posUpdate();
	self:LatencyBar_posUpdate()
end

function SimpleBar:InitTextures()
    MainMenuBarPageNumber:Hide();
    ActionBarUpButton:Hide();
    ActionBarDownButton:Hide();

    UpdateTalentButton = function() return; end	

    MainMenuXPBarTexture2:Hide();
    MainMenuXPBarTexture3:Hide();
    MainMenuBarTexture2:Hide();
    MainMenuBarTexture3:Hide();
    MainMenuMaxLevelBar2:Hide();
    MainMenuMaxLevelBar3:Hide();
    ReputationWatchBarTexture2:SetTexture("");
    ReputationWatchBarTexture3:SetTexture("");
    ReputationXPBarTexture2:SetTexture("");
    ReputationXPBarTexture3:SetTexture("");

    ShapeshiftBarRight:Hide();

    MainMenuBar:SetWidth(512);
    MainMenuExpBar:SetWidth(512);
    ReputationWatchBar:SetWidth(512);
    MainMenuBarMaxLevelBar:SetWidth(512);
    ReputationWatchStatusBar:SetWidth(512);
    
	MainMenuXPBarTexture0:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", -128, 2);
    MainMenuXPBarTexture1:SetPoint("BOTTOM", "MainMenuExpBar", "BOTTOM", 128, 3);
    MainMenuMaxLevelBar0:SetPoint("BOTTOM", "MainMenuBarMaxLevelBar", "TOP", -128, 0);
    MainMenuBarTexture0:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -128, 0);
    MainMenuBarTexture1:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", 128, 0);
    MainMenuBarLeftEndCap:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", -290, 0);
    MainMenuBarRightEndCap:SetPoint("BOTTOM", "MainMenuBarArtFrame", "BOTTOM", 287, 0);
    
    if self.db.account.bags == true then
        self:ShowBags();
    else
        self:HideBags();
    end
    
    if self.db.account.menu == true then
        self:ShowMenu();
    else
        self:HideMenu();
    end
    
    if self.db.account.gryphons == true then
        self:ShowGryphons();
    else
        self:HideGryphons();
    end
	
	if self.db.account.latency == true then
		self:ShowLatency();
	else
		self:HideLatency();
	end
end

function SimpleBar:UIParent_ManageFramePositions()
	SlidingActionBarTexture0:Hide();
	SlidingActionBarTexture1:Hide();
	ShapeshiftBarLeft:Hide();
	ShapeshiftBarMiddle:Hide();
	ShapeshiftBarRight:Hide();
	PossessBarLeft:Hide();
	PossessBarRight:Hide();

	parent = MainMenuBar;
	parent = leftActionBarManagePos(parent);
	parent = rightActionBarManagePos(parent);
	parent = caBarManagePos(parent);
	self:UpdateFrames();
	parent = adjustCastBar(parent);
end

function leftActionBarManagePos(parent)
	if not MultiBarBottomLeft:IsShown() then return parent end;
	
	yoff = 5;
	if UnitLevel("player") == 70 and not ReputationWatchBar:IsShown() then
		yoff = 0;
	elseif MainMenuExpBar:IsShown() and ReputationWatchBar:IsShown() then
		yoff = 14;
	end
	
	MultiBarBottomLeft:ClearAllPoints();
	MultiBarBottomLeft:SetPoint("BOTTOMLEFT", parent, "TOPLEFT", 8, yoff);
	return MultiBarBottomLeft;
end

function rightActionBarManagePos(parent)
	if not MultiBarBottomRight:IsShown() then return parent end;
	-- base = MultiBarBottomLeft;
	
	xoff = 0
	yoff = 5;
	if parent == MainMenuBar then
		xoff = 8
		-- yoff = 5;
		if UnitLevel("player") == 70 and not ReputationWatchBar:IsShown() then
			yoff = 0;
		elseif MainMenuExpBar:IsShown() and ReputationWatchBar:IsShown() then
			yoff = 14;
		end
	end
	
	MultiBarBottomRight:ClearAllPoints();
	MultiBarBottomRight:SetPoint("BOTTOMLEFT", parent, "TOPLEFT", xoff, yoff);
	return MultiBarBottomRight;
end

function caBarManagePos(parent)
	base = MultiBarBottomRight;
	y = 2;
	if parent == MainMenuBar and not PetActionBarFrame:IsShown() then
		y = 8;
	elseif parent == MultiBarBottomRight and not MultiBarBottomLeft:IsShown() and not PetActionBarFrame:IsShown() then
		y = 8
	end

	if PetActionBarFrame:IsShown() then
		UIPARENT_MANAGED_FRAME_POSITIONS["PetActionBarFrame"] = nil;
		PetActionBarFrame:ClearAllPoints();
		PetActionBarFrame:SetPoint("BOTTOMLEFT", parent, "TOPLEFT", 0, y);
		return PetActionBarFrame
	elseif ShapeshiftButton1:IsShown() then
		UIPARENT_MANAGED_FRAME_POSITIONS["ShapeshiftBarFrame"] = nil;
		ShapeshiftBarFrame:ClearAllPoints();
		ShapeshiftButton1:SetPoint("BOTTOMLEFT", parent, "TOPLEFT", 0, y);
		return ShapeshiftButton1;
	elseif PossessBarFrame:IsShown() then
		UIPARENT_MANAGED_FRAME_POSITIONS["PossessBarFrame"] = nil;
		PossessBarFrame:ClearAllPoints();
		PossessBarFrame:SetPoint("BOTTOMLEFT", parent, "TOPLEFT", 0, y);
		return PossessBarFrame;
	else
		return parent;
	end
end

function adjustCastBar(parent)
	y = 40;
	
	if MultiBarBottomLeft:IsShown() then
		y = y - 10;
	end
	if MultiBarBottomRight:IsShown() then
		y = y - 10;
	end
	
	UIPARENT_MANAGED_FRAME_POSITIONS["CastingBarFrame"] = nil;
	CastingBarFrame:ClearAllPoints();
	CastingBarFrame:SetPoint("CENTER", parent, "TOP", 0, y);
end
