﻿SlashCmdList['FRAME'] = function() ChatFrame1:AddMessage(GetMouseFocus():GetName()) end
SLASH_FRAME1 = '/frame'
SlashCmdList['RELOAD'] = function() ReloadUI() end
SLASH_RELOAD1 = '/rl'

if (GetLocale() == "ruRU") then
	MNU_TOGGLE_BAGS = "Показать сумки";
	MNU_TOGGLE_MENU = "Показать меню";
	MNU_TOGGLE_GRYPHONS = "Показать грифонов";
	MNU_TOGGLE_LATENCY = "Показать пинг";
	MNU_TOGGLE_BAGS_DESC = "Включение отображения панели сумок";
	MNU_TOGGLE_MENU_DESC = "Включение отображения панели меню";
	MNU_TOGGLE_GRYPHONS_DESC = "Включение отображения грифонов";
	MNU_TOGGLE_LATENCY_DESC = "Включение отображения производительности";
else
	MNU_TOGGLE_BAGS = "Show bags";
	MNU_TOGGLE_MENU = "Show menu";
	MNU_TOGGLE_GRYPHONS = "Show gryphons";
	MNU_TOGGLE_LATENCY = "Show latency";
	MNU_TOGGLE_BAGS_DESC = "Toggle bags on/off";
	MNU_TOGGLE_MENU_DESC = "Toggle micro menu on/off";
	MNU_TOGGLE_GRYPHONS_DESC = "Toggle gryphons on/off";
	MNU_TOGGLE_LATENCY_DESC = "Toggle latency meter";
end

SimpleBar = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceConsole-2.0", "AceHook-2.1", "FuBarPlugin-2.0");
SimpleBar.hasIcon = "Interface\\Icons\\Ability_Hunter_Pet_WindSerpent.blp" 

function SimpleBar:OnInitialize()
    self:RegisterDB("SimpleBarDB");
    	self:RegisterDefaults("account", {
		bags = false,
		menu = false,
        gryphons = true,
		latency = false
	})
	
    self:RegisterChatCommand({"/simplebar", "/sb" }, {
        type = "group",
        args = {
            bags = {
                order = 1,
                type = "execute",
                name = "bags",
                desc = MNU_TOGGLE_BAGS_DESC,
                func = "setBags"
            },
            menu = {
                order = 2,
                type = "execute",
                name = "menu",
                desc = MNU_TOGGLE_MENU_DESC,
                func = "setMenu"
            },
            gryphons = {
                order = 3,
                type = "execute",
                name = "gryphons",
                desc = MNU_TOGGLE_GRYPHONS_DESC,
                func = "setGryphons"
            },
            latency = {
                order = 4,
                type = "execute",
                name = "latency",
                desc = MNU_TOGGLE_LATENCY_DESC,
                func = "setLatency"
            }
        }
    });
    
    self.OnMenuRequest = {
        type = 'group',
        args = {
            bags = {
                order = 1,
                type = "toggle",
                name = MNU_TOGGLE_BAGS,
                desc = MNU_TOGGLE_BAGS_DESC,
                get = "getBags",
                set = "setBags"
            },
            menu = {
                order = 2,
                type = "toggle",
                name = MNU_TOGGLE_MENU,
                desc = MNU_TOGGLE_MENU_DESC,
                get = "getMenu",
                set = "setMenu"
            },
            gryphons = {
                order = 3,
                type = "toggle",
                name = MNU_TOGGLE_GRYPHONS,
                desc = MNU_TOGGLE_GRYPHONS_DESC,
                get = "getGryphons",
                set = "setGryphons"
            },
            latency = {
                order = 4,
                type = "toggle",
                name = MNU_TOGGLE_LATENCY,
                desc = MNU_TOGGLE_LATENCY_DESC,
                get = "getLatency",
                set = "setLatency"
            }
        }
    }
    
    self:SecureHook("UIParent_ManageFramePositions");
	hooksecurefunc(MainMenuBar, "SetPoint", function()
		SimpleBar:UpdateFrames();
	end)
    
    self:InitTextures();
end

function SimpleBar:getBags()
    return self.db.account.bags;
end

function SimpleBar:setBags()
    if self.db.account.bags == true then
        self:HideBags();
        self.db.account.bags = false;
    else
        self:ShowBags();
        self.db.account.bags = true;
    end
	self:UpdateFrames()
end

function SimpleBar:HideBags()
    MainMenuBarBackpackButton:Hide();
	CharacterBag0Slot:Hide();
	CharacterBag1Slot:Hide();
	CharacterBag2Slot:Hide();
	CharacterBag3Slot:Hide();
    KeyRingButton:Disable();
    KeyRingButton:DisableDrawLayer();
    KeyRingButton:Hide();
end

function SimpleBar:ShowBags()
    MainMenuBarBackpackButton:Show();
	CharacterBag0Slot:Show();
	CharacterBag1Slot:Show();
	CharacterBag2Slot:Show();
	CharacterBag3Slot:Show();
    KeyRingButton:Enable();
    KeyRingButton:EnableDrawLayer();
    KeyRingButton:Show();
end

function SimpleBar:getMenu()
    return self.db.account.menu;
end

function SimpleBar:setMenu()
    if self.db.account.menu == true then
        self:HideMenu();
        self.db.account.menu = false;
    else
        self:ShowMenu();
        self.db.account.menu = true;
    end
	self:UpdateFrames();
end

function SimpleBar:HideMenu()
    TalentMicroButton:Hide();
	CharacterMicroButton:Hide();
	SpellbookMicroButton:Hide();
	QuestLogMicroButton:Hide();
	SocialsMicroButton:Hide();
	MainMenuMicroButton:Hide();
	HelpMicroButton:Hide();
	LFGMicroButton:Hide();
end

function SimpleBar:ShowMenu()
    TalentMicroButton:Show();
	CharacterMicroButton:Show();
	SpellbookMicroButton:Show();
	QuestLogMicroButton:Show();
	SocialsMicroButton:Show();
	MainMenuMicroButton:Show();
	HelpMicroButton:Show();
	LFGMicroButton:Show();
end

function SimpleBar:getGryphons()
    return self.db.account.gryphons;
end

function SimpleBar:setGryphons()
    if self.db.account.gryphons == true then
        self:HideGryphons();
        self.db.account.gryphons = false;
    else
        self:ShowGryphons();
        self.db.account.gryphons = true;
    end
	self:UpdateFrames();
end

function SimpleBar:HideGryphons()
    MainMenuBarLeftEndCap:Hide();
    MainMenuBarRightEndCap:Hide();
end

function SimpleBar:ShowGryphons()
    MainMenuBarLeftEndCap:Show();
    MainMenuBarRightEndCap:Show();
end

function SimpleBar:getLatency()
    return self.db.account.latency;
end

function SimpleBar:setLatency()
    if self.db.account.latency == true then
        self:HideLatency();
        self.db.account.latency = false;
    else
        self:ShowLatency();
        self.db.account.latency = true;
    end
	self:UpdateFrames();
end

function SimpleBar:HideLatency()
    MainMenuBarPerformanceBarFrame:Hide();
end

function SimpleBar:ShowLatency()
    MainMenuBarPerformanceBarFrame:Show();
end
