-- Globals:
-- ========
-- SimpleAssist_SavedVars = {};
SimpleAssist_variablesLoaded = false;
-- SimpleAssist_units={};
SimpleAssist_PendingLearn=nil;
SimpleAssistPrefs_PanelFrames =
{
	"SimpleAssistDescriptionPanel",
	"SimpleAssistOptionsPanel"
};

-- Locals:
-- =======

local MYADDON_NAME = "SimpleAssist";
local MYADDON_VERSION = "2.5";
local MYADDON_AUTHOR = "Schnoggo";
local MYADDON_EMAIL = "schnoggo@gmail.com";
local MYADDON_WEBSITE = "http://schnoggo.com";

local myPlayerRealm=GetCVar("realmName");
local myPlayerName=UnitName("player");
local myPlayerClassText, myPlayerClassType = UnitClass("player");

-- default config settings   


local SimpleAssistDefaults={SimpleAssistPrefsRAID=false,
	SimpleAssistPrefsSAY = false,
	SimpleAssistPrefsYELL = false,
	SimpleAssistPrefsPARTY = false
	};
	SimpleAssistDefaults["CustomChat"]={};
	SimpleAssistDefaults["CustomChat"][1]="Help";
	SimpleAssistDefaults["CustomChat"][2]="in attacking";
	SimpleAssistDefaults["CustomChat"][3]=".";
	SimpleAssistDefaults["version"]=2;

-- My local functions:
-- ====================







-- Event functions
-- Onload:
function SimpleAssist_OnLoad()
	-- this:RegisterEvent("ADDON_LOADED");

	-- Register the slash command
	-- --------------------------
	SLASH_SIMPLEASSIST1 = "/sass";
	SlashCmdList["SIMPLEASSIST"] = SimpleAssist_CommandLine;
	
--[[this is code]]--




-- Register the event handlers:
-- =============================	

	this:RegisterEvent("VARIABLES_LOADED");
	-- this:RegisterEvent("CHAT_MSG_TEXT_EMOTE");
	this:RegisterEvent("PLAYER_ENTERING_WORLD"); 
	this:RegisterEvent("UPDATE_BINDINGS"); 
	this:RegisterEvent("PLAYER_LEAVE_COMBAT"); 	
	this:RegisterEvent("PLAYER_REGEN_ENABLED");
		
	if (not myPlayerName) then
		myPlayerName = UnitName("player");
	end

	DEFAULT_CHAT_FRAME:AddMessage(SASSTEXT.WELCOME,  0.5, 1.0, 0.5, 1);


end -- OnLoad





	
function SimpleAssist_Event(event)
	local eventHandled = false;
	local inParty, unitID;

-- VARIABLES_LOADED
-- ================

	if ( event == "VARIABLES_LOADED" ) then	
		-- record that we have been loaded:
		SimpleAssist_variablesLoaded = true;
		
		
		if not (SimpleAssistSavedVars) then		
			SimpleAssistSavedVars={
			SimpleAssistPrefsRAID=false,
			SimpleAssistPrefsSAY = false,
			SimpleAssistPrefsYELL = false,
			SimpleAssistPrefsPARTY = false,
			SimpleAssistRaidIcon=0};
			SimpleAssistSavedVars["CustomChat"]={};
			SimpleAssistSavedVars["CustomChat"][1]=SASSTEXT_CUSTOM_CALL_BEFORE;
			SimpleAssistSavedVars["CustomChat"][2]=SASSTEXT_CUSTOM_CALL_MIDDLE;
			SimpleAssistSavedVars["CustomChat"][3]=SASSTEXT_CUSTOM_CALL_AFTER;
		end


		if (SimpleAssistSavedVars["version"] == nil) then
			SimpleAssistSavedVars["version"]=2;
			SimpleAssistSavedVars["CustomChat"]={};
			SimpleAssistSavedVars["CustomChat"][1]=SASSTEXT_CUSTOM_CALL_BEFORE;
			SimpleAssistSavedVars["CustomChat"][2]=SASSTEXT_CUSTOM_CALL_MIDDLE;
			SimpleAssistSavedVars["CustomChat"][3]=SASSTEXT_CUSTOM_CALL_AFTER;
		else
		
		end

		eventHandled = true;
	end -- ( event == "VARIABLES_LOADED" )
	
	

--[[		
	if (eventHandled == false and event == "CHAT_MSG_TEXT_EMOTE") then
		if ( arg1 ~= nil) then
			msgText = string.lower(arg1);
			if (string.find( msgText, SASSTEXT_ATTACK_EMOTE)   ) then
				if (arg2 ~= nil) then
					-- if (UnitIsPlayer(arg2)) then
					inParty, unitID=SimpleAssist_PlayerInParty(arg2)
					if (inParty) then -- setup pref to toggle party behavior
						-- SimpleAssist_units["assist1"]=UnitName(unit);
						AssistUnit(arg2);
						SimpleAssist_PopMsg(SASSTEXT.ASSISTING .. " " .. arg2);
					end -- party member
	

				end -- speaker is not nil
			end -- message asks to attack
		end -- msg not nil
	end -- is in chat msg
]]--	
	if (eventHandled == false and event == "PLAYER_ENTERING_WORLD") then
	-- "frameType", "frameName", parentFrame[, "inheritsFrame"]);
	-- local f = CreateFrame("Button", "SimpleAssistActionFrame", nil, "SecureActionButtonTemplate");
	local f =  CreateFrame("CheckButton", "SimpleAssistActionButton", UIParent, "ActionBarButtonTemplate");

	f:SetAttribute("type", "macro");
	f:SetAttribute("width", "30");
	f:SetAttribute("height", "30");
	f:SetAttribute("macrotext", "/assist target");
	f:ClearAllPoints();
	f:SetPoint("TOPLEFT", "UIParent", "TOPLEFT", -100, -100); -- (point, frame, relativePoint , x, y);
	-- putting the button off-screen to make it invisible
	-- f:SetPoint("BOTTOMRIGHT", "UIParent", "TOPLEFT", 2, -2); -- (point, frame, relativePoint , x, y);
	
	
	SimpleAssist_UpdateBindings();
	eventHandled = true;

	end -- PLAYER_ENTERING_WORLD
	
	if (eventHandled == false and event == "UPDATE_BINDINGS") then	
		SimpleAssist_UpdateBindings();
		eventHandled = true;
	end
	
	
	if (eventHandled == false and ((event == "PLAYER_LEAVE_COMBAT") or (event == "PLAYER_REGEN_ENABLED"))) then	
		if (SimpleAssist_PendingLearn ~= nil) then
			-- SimpleAssist_PrivateLearnAssist(SimpleAssist_PendingLearn);
			-- replace with code that uses player name instead of unitID
			
			if (SimpleAssist_PendingLearn == "pending clear") then
				getglobal("SimpleAssistActionButton"):SetAttribute("macrotext", "/assist target");
				SimpleAssist_PopMsg(SASSTEXT.CLEARED);
			else
				-- expand the macro code here
				getglobal("SimpleAssistActionButton"):SetAttribute("macrotext", "/assist "..SimpleAssist_PendingLearn);
				SimpleAssist_PopMsg(SASSTEXT.ASSIST_SET ..": " .. SimpleAssist_PendingLearn);
			end
			SimpleAssist_PendingLearn = nil;
		end
		eventHandled = true;
	end -- event handled?
	
	
	
	
	
	if (eventHandled == false) then
		-- msgText = string.lower(arg1);
	end 
	

	
	
		

end -- end of function
 
 
 
 
function SimpleAssist_UpdateBindings()
 if getglobal("SimpleAssistActionButton") then
			local k1, k2, k3 = GetBindingKey("SASS_ASSIST");
				if (k1) then -- SetOverrideBindingClick(owner, isPriority, "KEY", "ButtoName"[,"mouseButton"]);
				-- DEFAULT_CHAT_FRAME:AddMessage("SASS key="..k1,  0.5, 1.0, 0.5, 1);
				SetOverrideBindingClick(getglobal("SimpleAssistActionButton"),nil,k1,"SimpleAssistActionButton");
			end
		end -- button instantiated
end

function SimpleAssistTester()
SimpleAssist_PopMsg("Yadda");

end 

-- command line parameters: (slash command handler)
function SimpleAssist_CommandLine(msg)
	cmd=string.lower(msg);

		if ( ( msg=="1") or (msg=="")) then
			SimpleAssistPrefsFrame:Show();
		end

	if ( msg =="0") then
		SimpleAssistPrefsFrame:Hide();
	end
		

end




-- GUI Handlers:
-- =============================


-- prefs:
function SimpleAssist_Options_OnClick(arg1)
	id = this:GetID()
	local buttonName=this:GetName()
	SimpleAssistDefaults[buttonName] =getglobal(buttonName):GetChecked();
	SimpleAssistSavedVars[buttonName] =getglobal(buttonName):GetChecked();
end


function SimpleAssist_Radio_OnClick(arg1)
	SimpleAssistSavedVars["SimpleAssistRaidIcon"]=arg1;
	SimpleAssistUpdateRadios();
end


 -- OnShow
 function SimpleAssistPrefsFrameOnShow()


	-- draw the current settings:
	table.foreach(SimpleAssistSavedVars,
		function(k,v)
			if (getglobal(k) ~= nil) then
				if string.find("Text",k) then
					
				else
					getglobal(k):SetChecked(v);
				end
	
			end
		end

	);
	-- fill in the text for the custom chat message:
	for i = 1,3 do
		local tMsgName="SimpleAssistChatText"..i;
		local tMsgText=	SimpleAssistSavedVars["CustomChat"][i];
		if (tMsgText ~= nil) then
			getglobal(tMsgName):SetText(tMsgText);
		end
	end
	
	-- draw the radio buttons for Icon
	if (SimpleAssistSavedVars["SimpleAssistRaidIcon"] == nil) then
		SimpleAssistSavedVars["SimpleAssistRaidIcon"] = 0;
	end
	
	SimpleAssistUpdateRadios();
	
	-- update tabs:
	if (SimpleAssistPrefs_CurrentPanel==nil) then
		SimpleAssistPrefs_CurrentPanel=-1;
	end
	local tPanel = 	SimpleAssistPrefs_CurrentPanel;
	SimpleAssistPrefs_CurrentPanel=-1;
	SimpleAssist_HidePanel(2);
	SimpleAssist_HidePanel(1);
	
	if (tPanel<1) then
		tPanel=1
	end
		SimpleAssist_ShowPanel(tPanel);

	
	
 end



function SimpleAssistUpdateRadios()
i=0;
	while (i<9) do
		if (i==SimpleAssistSavedVars["SimpleAssistRaidIcon"]) then
		getglobal("SimpleAssist_RB"..i):SetChecked(true);
		else
			getglobal("SimpleAssist_RB"..i):SetChecked(false);
		end
		i=i+1;
	end
end
 




 function SimpleAssist_ShowPanel(whichPanel)

 	if (SimpleAssistPrefs_CurrentPanel > 0) then
 		SimpleAssist_HidePanel(SimpleAssistPrefs_CurrentPanel);
	end

	
	getglobal(SimpleAssistPrefs_PanelFrames[whichPanel]):Show();
 	SimpleAssistPrefs_CurrentPanel=whichPanel;
 end


function SimpleAssist_HidePanel(whichPanel)
	getglobal(SimpleAssistPrefs_PanelFrames[whichPanel]):Hide();
	SimpleAssistPrefs_CurrentPanel = 0;
end



function SimpleAssist_GetPrefsText()

	SimpleAssistSavedVars["CustomChat"]={};
	for i = 1,3 do
		local tMsgName="SimpleAssistChatText"..i;
		local tMsgText=getglobal(tMsgName):GetText();
		if (tMsgText ~= nil) then
			SimpleAssistSavedVars["CustomChat"][i]=tMsgText;
		end
	end
end






-- In Game Functions:

function  SimpleAssist_LearnAssist(unit)
-- {unit} = ID of unit to be set as assist (from Target)
	
	if (InCombatLockdown()) then
		local thisUnitName=UnitName(unit);
		if (thisUnitName==nil) then
			SimpleAssist_PendingLearn="pending clear"; -- use a name with a space and no upper-case 
			SimpleAssist_PopMsg(SASSTEXT.CLEAR_PENDING);
		else
			SimpleAssist_PendingLearn=thisUnitName;
			SimpleAssist_PopMsg(SASSTEXT.ASSIST_PENDING .. thisUnitName);
		end
	else
		SimpleAssist_PrivateLearnAssist(unit);
	end

end -- function


function SimpleAssist_PrivateLearnAssist(unit)
	if (UnitName(unit) == nil) then
			-- SimpleAssist_units["assist1"]=nil;
			getglobal("SimpleAssistActionButton"):SetAttribute("macrotext", "/assist target");
			SimpleAssist_PopMsg(SASSTEXT.CLEARED);
	end
			
	if (UnitIsPlayer(unit)) then
		if (UnitIsFriend("target", unit)) then -- unit could technically be "target" here... (changed from player to target for Battle of Darrowshire and similar events
				-- SimpleAssist_units["assist1"]=UnitName(unit);
				local thisUnitName=UnitName(unit);
				-- expand the macro code here
				-- /assist [target=focus, exists]
				-- check for modifier to use 
				-- /use [nomodifier, nomounted]Snowy Gryphon;
				-- /use [modifier:alt]Palomino Bridle;
				getglobal("SimpleAssistActionButton"):SetAttribute("macrotext", "/assist "..thisUnitName);
				SimpleAssist_PopMsg(SASSTEXT.ASSIST_SET ..": " .. thisUnitName);
		end -- friend
	end -- player
end


  
function  SimpleAssist_AskAssist()
	local partyCount = GetNumPartyMembers();
	local raidCount = GetNumRaidMembers();
	local uName=UnitName("target");
	if (uName ~= nil) then
		-- local msg = SASSTEXT.CHAT_ASSIST;
		-- string.gsub(s, pattern, replace [, n])
		-- msg=string.gsub(msg, "{name}", myPlayerName );
		-- msg=string.gsub(msg, "{target}", uName );
		local p1=SimpleAssistSavedVars["CustomChat"][1];
		local p2=SimpleAssistSavedVars["CustomChat"][2];
		local p3=SimpleAssistSavedVars["CustomChat"][3];
		if (p1 ~= "") then
			p1=p1.." ";
		end
		-- if (p2 ~= "") then
			-- p2=" "..p2.." ";
		-- end
		-- if (p3 ~= "") then
			-- p3=" "..p3;
		-- end
		
		local msg = p1 .. myPlayerName .. p2 .. uName .. p3;	
		if ((SimpleAssistSavedVars["SimpleAssistPrefsRAID"]) and (raidCount > 0)) then
			SendChatMessage(msg, "RAID");
		
		else -- only show party if not in raid
			if ((SimpleAssistSavedVars["SimpleAssistPrefsPARTY"]) and (partyCount > 0)) then
				SendChatMessage(msg, "PARTY");
			end
		end
		if (SimpleAssistSavedVars["SimpleAssistPrefsYELL"]) then
			SendChatMessage(msg, "YELL");
		end
		if (SimpleAssistSavedVars["SimpleAssistPrefsSAY"]) then
			SendChatMessage(msg, "SAY");
		end
		
		if (SimpleAssistSavedVars["SimpleAssistPrefsRW"]) then
			SendChatMessage(msg, "RAID_WARNING");
		end
	end
	-- if (GetNumRaidMembers()>0) then 
		if (SimpleAssistSavedVars["SimpleAssistRaidIcon"] ~= 0) then
			SetRaidTarget("target",SimpleAssistSavedVars["SimpleAssistRaidIcon"]);
		end
	-- end
	if (SimpleAssistSavedVars["SimpleAssistPrefsEMOTE"]) then
		DoEmote("ATTACKMYTARGET");
	end

  
end
  
  
  
  
function SimpleAssist_PopMsg(msg)
-- Our head's up display for this AddOn
-- Inputs: {msg} = message to display in the HUD
	if (msg == nil) then
    	msg="Oh Baby!";
    end
    if (SchnoggoAlertInform) then
    	SchnoggoAlertInform(msg);
    else
		SimpleAssistAlertFrame:AddMessage(msg, 1, 1, 1, 1, 3);
    end
end
    
function SimpleAssist_DoAssist()
-- this function is now a dummy. It exists only so that a keybinding can be set.

end




function SimpleAssist_PlayerInParty(name)
-- Determine if {name} is in our party or raid
-- Inputs: {name} = a player name [string]
-- 
-- Outputs: {arg1} = whether {name} is in our group/raid [boolean]
--          {arg2} = unitID of {name}

	local partyCount = GetNumPartyMembers();
	local raidCount = GetNumRaidMembers();
	local inRaid=false;
	local raidID=nil;
	if true and raidCount > 0 then
	-- see if in raid
		for i=1, raidCount do
			local raidName, rank, subgroup, level, class, fileName, zone, online = GetRaidRosterInfo(i);
			if (raidName ~= nil) then
				if (raidName == name) then
					inRaid=true;
					raidID="raid"..i;
					break;
				end
			end
		end
		
	elseif  (partyCount > 0) then
	-- see if in party
		for i=1, partyCount do
			if UnitName("party"..i) == name then
				inRaid=true;
				break;
			end
		end
	end
	return inRaid, raidID;
end


