SASFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
SASFu:RegisterDB("SASFuDB")
SASFu.hasIcon = "Interface\\AddOns\\SimpleActionSets\\sas"

local Tablet = AceLibrary("Tablet-2.0");
local Dewdrop = AceLibrary("Dewdrop-2.0");

function SASFu:OnClick()
	SASMain_Toggle();
end

function SASFu:OnTextUpdate()
	local set = SAS_GetCurrentSet();
	if ( set ) then
		self:SetText("SASFu |cffffffff"..set);
	else
		self:SetText("SASFu");
	end
end

function SASFu:OnTooltipUpdate()
	local cat = Tablet:AddCategory( "columns", 2 );
	cat:AddLine(
		"text", "Current Set",
		"text2", (SAS_GetCurrentSet() or "|cff808080none|r"),
		"text2R", 1, "text2G", 1, "text2B", 1
		);
end

function SASFu:OnMenuRequest()
	Dewdrop:AddLine(
		"text", SAS_TEXT_DROPDOWN_OPEN,
		"func", ShowUIPanel,
		"arg1", SASMain
		);
	Dewdrop:AddLine(
		"text", SAS_TEXT_DROPDOWN_SAVENEW,
		"func", SASActions_SaveNew
		);
	Dewdrop:AddLine(
		"text", SAS_TEXT_DROPDOWN_SAVECURRENT,
		"func", SAS_Warning,
		"arg1", "SAVE",
		"arg2", SAS_SaveSet,
		"arg3", SAS_GetCurrentSet(),
		"disabled", ( SAS_GetCurrentSet() == nil )
		);

	Dewdrop:AddLine(
		"text", SAS_TEXT_DROPDOWN_SETS,
		"isTitle", true
		);

	local list = SAS_GetSetList();
	if ( list ) then
		for i, set in ipairs(list) do
			Dewdrop:AddLine(
				"text", set,
				"func", SAS_SwapSet,
				"arg1", set,
				"checked", (SAS_GetCurrentSet() == set)
				);
		end
	else
		Dewdrop:AddLine(
			"text", SAS_TEXT_DROPDOWN_NONE,
			"hasCheck", true,
			"checked", false,
			"disabled", true
			);
	end

	Dewdrop:AddLine("disabled",true);
end