-- (c) 2007 Nymbia.  see LGPLv2.1.txt for full details.
--this tool is run in the lua command line.  http://lua.org
--socket is required for internet data.
--get socket here: http://luaforge.net/projects/luasocket/
--if available curl will be used, which allows connection re-use

local SOURCE = SOURCE or "Defaults.lua"
local DEBUG = DEBUG or 1

local function dprint(dlevel, ...)
	if dlevel and DEBUG >= dlevel then
		print(...)
	end
end

local url = require("socket.url")
local httptime, httpcount = 0, 0
local getpage
do
	local status, curl = pcall(require, "curl")
	if status then
		local temp
		local write = function (s, len)
			temp[#temp + 1] = s
			return len
		end
		local c = curl.easy_init()
		function getpage(url)
			dprint(2, "curl", url)
			temp = {}
			c:setopt(curl.OPT_URL, url)
			c:setopt(curl.OPT_WRITEFUNCTION, write)
			local stime = os.time()
			local err, info = c:perform()
			httptime = httptime + (os.time() - stime)
			httpcount = httpcount + 1
			if err ~= 0 then
				dprint(1, "curl error", url, info)
			else
				temp = table.concat(temp)
				if temp:len() > 0 then
					return temp
				end
			end
		end
	else
		local http = require("socket.http")

		function getpage(url)
			dprint(2, "socket.http", url)
			local stime = os.time()
			local r = http.request(url)
			httptime = httptime + (os.time() - stime)
			httpcount = httpcount + 1
			return r
		end
	end
end

if not NOCACHE then
	local real_getpage = getpage
	local status, sqlite = pcall(require, "lsqlite3")
	if status then
		db = sqlite.open("wowhead.db")
		db:exec([[
CREATE TABLE IF NOT EXISTS cache (
	url TEXT,
	content BLOB,
	time TEXT,
	PRIMARY KEY (url)
)]])
		local CACHE_TIMEOUT = CACHE_TIMEOUT or "+7 day"
		local select_stmt = db:prepare("SELECT content FROM cache WHERE url = ? AND datetime(time, '"..CACHE_TIMEOUT.."') > datetime('now')")
		local insert_stmt = db:prepare("INSERT INTO cache VALUES (?, ?, CURRENT_TIMESTAMP)")
		getpage = function (url)
			select_stmt:bind_values(url)
			local result = select_stmt:step()
			if result == sqlite3.ROW then
				result = select_stmt:get_value(0)
				select_stmt:reset()
				return result
			else
				select_stmt:reset()
			end
			local content = real_getpage(url)
			if content then
				insert_stmt:bind_values(url, content)
				insert_stmt:step()
				insert_stmt:reset()
			end
			return content
		end
	else
		local page_cache = {}
		getpage = function (url)
			local page = page_cache[url]
			if not page then
				page = real_getpage(url)
				page_cache[url] = page
			end
			return page
		end
	end
end

local function write_output(data)
	local f = assert(io.open(SOURCE, "w"))
	f:write('-- DO NOT EDIT THIS FILE; run dataminer.lua to regenerate.\n')
	f:write('function SilverDragon:ImportDefaults()\n')
	f:write('\tlocal defaults = {\n')
	for zone, mobs in pairs(data) do
		f:write('\t\t["'..zone..'"] = {\n')
		for name, mob in pairs(mobs) do
			f:write('\t\t\t["'..name..'"] = {')
			f:write((mob.type and ('type="'..mob.type..'", ') or '')..'elite='..(mob.elite and 'true' or 'false')..', level='..mob.level..', ')
			f:write('locations = {')
			for _,loc in pairs(mob.locations) do
				f:write('{'..loc[1]..','..loc[2]..',"",0},')
			end
			f:write('},}\n')
		end
		f:write('\t\t},\n')
	end
	f:write('\t}\n')
	f:write([[
	for zone, mobs in pairs(defaults) do
		for name, info in pairs(mobs) do
			if not self.db.profile.mobs[zone][name] then self.db.profile.mobs[zone][name] = {} end
			local mob = self.db.profile.mobs[zone][name]
			mob.type = info.type
			mob.level = info.level
			mob.elite = info.elite
			mob.lastseen = (mob.lastseen and tonumber(mob.lastseen) > 0) and tonumber(mob.lastseen) or 0
			for _, loc in pairs(info.locations) do local newloc = true
				if not mob.locations then mob.locations = {} end
				local newloc = true
				for _, oldloc in pairs(mob.locations) do
					if (math.abs(loc[1] - oldloc[1]) < 5) and (math.abs(loc[2] - oldloc[2]) < 5) then
						newloc = false
						break
					end
				end
				if newloc then
					table.insert(mob.locations, loc)
				end
			end
		end
	end
	defaults = nil
end
]])
	f:close()
	print('defaults written')
end

local zones = {}
local function zone_mappings()
	local url = "http://www.wowhead.com/common/locale_enus.js"
	local page = getpage(url)
	if not page then return end
	page = page:match('g_zones=_=%[%];(.-)var')
	if not page then return end
	for entry in page:gmatch('%[%d+%]="[^"]+"') do
		local id, zone = entry:match('^%[(%d+)%]="([^"]+)"$')
		zones[id] = zone
	end
end

local function npc_coords(id)
	local url = "http://www.wowhead.com/?npc="..id
	local page = getpage(url)
	if not page then return end
	
	page = page:match("myMapper.update(%b())")
	if not page then return end
	page = page:match("coords: (%b[])")
	if not page then return end
	page = page:match("^%[(.-)%]$")
	if not page then return end
	
	coords = {}
	for entry in page:gmatch("%b[]") do
		local x, y = entry:match("([0-9%.]+),([0-9%.]+)")
		table.insert(coords, {tonumber(x), tonumber(y)})
	end
	return coords
end

local npctypes = {
	[1] = 'Beast',
	[2] = 'Dragonkin',
	[3] = 'Demon',
	[4] = 'Elemental',
	[5] = 'Giant',
	[6] = 'Undead',
	[7] = 'Humanoid',
--	[8] = 'Critter',
	[9] = 'Mechanical',
	[10] = 'Uncategorized',
}
local function main()
	zone_mappings()
	defaults = {}
	for i,c in pairs(npctypes) do
		print("Acquiring rares for category: "..c)
		local url = "http://www.wowhead.com/?npcs="..i.."&filter=cl=4:2"
		local page = getpage(url)
		if not page then return end
		page = page:match("new Listview(%b())")
		if not page then return end
		page = page:match("data: (%b[])")
		if not page then return end
		for entry in page:gmatch("%b{}") do
			local id = entry:match("{id:(%d+)")
			local name = entry:match("name:'(.-)',")
			name = name:gsub("\\'", "'")
			local level = tonumber(entry:match("maxlevel:(%d+)"))
			local ctype = tonumber(entry:match("type:(%d+)"))
			if ctype==10 then
				ctype = nil
			else
				ctype = npctypes[ctype]
			end
			local elite = (entry:match("classification:(%d+)") == '2')
			local zone = zones[entry:match("location:%[(%d+)")]
			if zone then
				local locations = {}
				local raw_coords = npc_coords(id)
				if raw_coords and #raw_coords > 0 then
					for _,loc in pairs(raw_coords) do
						local x,y = unpack(loc)
						local is_new = true
						for _,oldloc in pairs(locations) do
							local old_x, old_y = unpack(oldloc)
							if math.abs(old_x - x) < 5 and math.abs(old_y - y) < 5 then
								is_new = false
								break
							end
						end
						if is_new then
							table.insert(locations, {x, y, '', 0})
						end
					end
				else
					table.insert(locations, {0, 0, '', 0})
				end
				if not defaults[zone] then defaults[zone] = {} end
				defaults[zone][name] = {
					level = level,
					type = ctype,
					locations = locations,
					elite = elite,
					lastseen = 0,
				}
				print("Added "..name.." to "..zone)
			end
		end
	end
	write_output(defaults)
end

main()
