﻿--Simplified Chinese: wangmarsfa@CWDG http://bbs.cwowaddon.com

if (GetLocale() == "zhCN") then 

function SilverDragon:ImportDefaults()
	local defaults = {
		["厄运之槌"] = {
			["姆斯高格"] = "43:67:60:1:元素生物:巨槌竞技场:0",
			["无敌的斯卡尔"] = "43:67:58:1:人型生物:巨槌竞技场:0",
			["拉里尔"] = "43:67:60:1:野兽:巨槌竞技场:0",
		},
		["辛特兰"] = {
			["铁背龟"] = "0:0:51:0:野兽::0",
			["加林德·夏龙"] = "31:43:49:0:人型生物:奎尔丹尼小屋:0",
			["狂暴者雷瑟罗克"] = "0:0:48:0:人型生物::0",
			["附魔师米瑟雷希斯"] = "0:0:52:1:人型生物:辛萨罗:0",
			["锋爪"] = "0:0:44:0:人型生物::0",
			["格瑞姆格斯"] = "0:0:50:1:巨人::0",
			["海崖奔跳者"] = "17:55:42:0:野兽::0",
			["漫步者维瑟哈特"] = "0:0:45:0:人型生物::0",
			["祖拉雷克"] = "0:0:43:0:人型生物::0",
		},
		["千针石林"] = {
			["哈尔伯·邪泉"] = "35:31:27:0:人型生物:黑云峰:0",
			["哈特拉斯"] = "0:0:32:0:野兽::0",
			["不可战胜的的铁眼"] = "0:0:37:0:野兽::0",
			["邪刺恐蝎"] = "0:0:35:1:野兽:闪光平原:0",
			["被流放的阿切鲁斯"] = "0:0:31:0:人型生物::0",
			["吉比斯尼克"] = "58:46:28:0:人型生物:风裂峡谷:0",
		},
		["冬泉谷"] = {
			["雪爪灰熊怪"] = "0:0:59:0:人型生物::0",
			["嚎叫者米基尔"] = "0:0:55:0:人型生物::0",
			["拉克西里"] = "0:0:57:0:野兽::0",
			["科巴塔恩将军"] = "58:51:57:1:龙类:麦索瑞尔:0",
			["埃苏罗斯"] = "60:39:59:1:龙类:永望镇:0",
			["劫掠者卡苏克"] = "62:69:60:1:巨人:霜语峡谷:0",
		},
		["黑石塔"] = {
			["尖石统帅"] = "0:0:58:1:人型生物::0",
			["乌洛克"] = "0:0:60:1:人型生物:霍德玛尔城:0",
			["尖石屠夫"] = "0:0:57:1:人型生物::0",
			["班诺克·巨斧"] = "0:0:59:1:人型生物::0",
			["杰德"] = "0:0:59:1:人型生物::0",
			["军需官兹格雷斯"] = "0:0:59:1:人型生物:霍德玛尔城:0",
			["燃烧地狱卫士"] = "0:0:57:1:恶魔:霍德玛尔城:0",
			["尖石首席法师"] = "0:0:58:1:人型生物::0",
			["水晶之牙"] = "0:0:60:1:野兽::0",
			["霍克·巴什古德"] = "0:0:59:1:人型生物:霍德玛尔城:0",
		},
		["血色修道院"] = {
			["永醒的艾希尔"] = "0:0:33:1:亡灵::0",
			["死灵勇士"] = "0:0:33:1:亡灵:遗忘回廊:0",
			["铁脊死灵"] = "0:0:33:1:亡灵::0",
		},
		["阿拉希高地"] = {
			["纳兹加克王子"] = "0:0:41:0:人型生物::0",
			["札拉斯·枯木"] = "0:0:40:0:人型生物::0",
			["达贝尔·蒙特罗斯"] = "0:0:39:1:人型生物::0",
			["地占师弗林塔格"] = "86:30:40:0:人型生物:枯须峡谷:0",
			["弗尔伯利"] = "0:0:42:1:人型生物::0",
			["考沃克"] = "33:45:36:0:人型生物::0",
			["碎骨者穆罗克"] = "0:0:39:0:人型生物::0",
			["歌唱者"] = "31:26:34:0:人型生物:诺斯弗德农场:0",
			["屠戮者尼玛尔"] = "0:0:37:0:人型生物::0",
		},
		["西部荒野"] = {
			["布拉克"] = "30:79:19:0:人型生物:长滩:0",
			["莱普利瑟斯"] = "0:0:19:0:亡灵::0",
			["斯拉克"] = "0:0:15:0:人型生物::0",
			["乌尔图斯"] = "0:0:26:0:野兽::0",
			["掘地工头目"] = "0:0:15:0:人型生物::0",
			["死神4000型"] = "47:68:20:0:机械:法布隆南瓜农场:0",
			["利爪队长"] = "35:31:18:0:人型生物::0",
		},
		["荒芜之地"] = {
			["拉姆布勒"] = "4:80:45:0:元素生物:卡格营地:0",
			["攻城傀儡"] = "0:0:40:1:元素生物::0",
			["作战傀儡"] = "48:8:36:0:元素生物:造物者遗迹:0",
			["安纳塞姆斯"] = "0:0:45:1:巨人::0",
			["暗炉指挥官"] = "41:27:40:0:人型生物:苦痛堡垒:0",
			["7:XT"] = "0:0:41:0:机械::0",
			["札里科特"] = "54:60:55:1:野兽::0",
			["断牙"] = "0:0:60:0:野兽::0",
		},
		["黑海岸"] = {
			["卡尼沃斯"] = "39:78:16:0:人型生物:暮光谷:0",
			["残忍的弗拉格莫克"] = "0:0:16:0:人型生物::0",
			["莫嘉泽尔"] = "0:0:17:0:亡灵::0",
			["薇丝普拉"] = "0:0:22:0:人型生物::0",
			["影爪"] = "0:0:13:0:野兽::0",
			["雌性森林陆行鸟"] = "34:86:20:0:野兽:雷姆塔维尔挖掘场:0",
			["利斯林"] = "0:0:14:0:恶魔::0",
			["辛斯雷尔"] = "0:0:16:0:人型生物::0",
			["召火者拉迪森"] = "0:0:19:0:人型生物::0",
		},
		["洛克莫丹"] = {
			["玛高什"] = "69:67:21:0:人型生物:铁环挖掘场:0",
			["大头目加尔高西"] = "68:66:22:0:人型生物:铁环挖掘场:0",
			["摧毁者埃摩戈"] = "0:0:19:1:人型生物::0",
			["格瑞兹拉克"] = "0:0:15:0:人型生物::0",
			["大型洛克鳄"] = "59:34:23:0:野兽::0",
			["纺织者杉达"] = "0:0:19:0:野兽::0",
			["康达尔"] = "76:72:16:0:野兽:旅行者营地:0",
		},
		["监狱"] = {
			["布鲁戈·艾尔克纳寇"] = "0:0:26:1:人型生物::0",
		},
		["塔纳利斯"] = {
			["失落者欧姆高尔"] = "39:72:50:0:人型生物:南月废墟:0",
			["残忍的疱爪土狼"] = "0:0:43:0:野兽::0",
			["巨型火鸟"] = "44:34:46:0:野兽:深沙平原:0",
			["疯狂的塞科洛克"] = "0:0:48:0:人型生物::0",
			["克雷格·尼哈鲁"] = "72:46:47:0:人型生物:落帆海湾:0",
			["克莱吉拉克"] = "37:25:45:1:人型生物:流沙岗哨:0",
			["唤沙者辛萨拉"] = "0:0:46:1:人型生物::0",
		},
		["提里斯法林地"] = {
			["穆亚德"] = "36:37:10:0:人型生物:耳语海岸:0",
			["贝恩"] = "51:51:10:0:恶魔:静水池:0",
			["菲林森特的阴影"] = "75:60:12:0:亡灵:巴尼尔农场:0",
			["痛苦的灵魂"] = "43:32:9:0:亡灵:阿加曼德磨房:0",
			["农夫索利丹"] = "38:49:8:0:人型生物:索利丹农场:0",
			["迪布"] = "0:0:12:0:人型生物::0",
			["毒针雷萨恩"] = "52:62:11:0:野兽::0",
			["瑟斯库克"] = "87:52:13:0:野兽:毒蛛峡谷:0",
			["失落的灵魂"] = "53:48:7:0:亡灵::0",
		},
		["暴风城"] = {
			["下水道鳄鱼"] = "63:35:50:0:野兽:运河:0",
		},
		["尘泥沼泽"] = {
			["达尔特"] = "47:18:38:0:野兽::0",
			["贼眼"] = "57:16:38:0:人型生物:恐惧海岸:0",
			["咆哮者杜格斯"] = "0:0:37:0:元素生物::0",
			["雷普斯凯尔"] = "45:50:39:0:野兽:泥潭沼泽:0",
			["泥浆虫"] = "36:70:42:0:野兽:黑龙谷:0",
			["布雷姆戈"] = "0:0:45:1:人型生物::0",
			["安戈雷尔"] = "0:0:44:0:人型生物::0",
			["暗雾寡妇蛛"] = "0:0:40:0:野兽::0",
			["哈尤克"] = "0:0:41:0:野兽::0",
		},
		["杜隆塔尔"] = {
			["死亡毒蝎"] = "0:0:11:0:野兽::0",
			["指挥官萨拉菲尔"] = "58:58:9:0:人型生物:提拉加德城堡:0",
			["獠牙队长"] = "44:49:11:1:人型生物:钢鬃营地:0",
			["吉欧洛德·杂斑"] = "46:49:9:0:人型生物:钢鬃营地:0",
			["科卡尼斯"] = "0:0:9:0:人型生物::0",
			["斯考恩"] = "0:0:11:1:人型生物::0",
		},
		["希尔斯布莱德丘陵"] = {
			["萨姆拉斯"] = "84:42:27:0:野兽:敦霍尔德城堡:0",
			["斯卡基尔"] = "34:70:30:0:人型生物:西部海岸:0",
			["塞菲莉斯"] = "59:74:33:0:人型生物:东部海滩:0",
			["洛巴尔克"] = "65:60:28:0:人型生物:奈杉德哨岗:0",
			["塔尔玛·雷矛"] = "70:81:28:1:人型生物:丹加洛克:0",
			["克雷普塞斯"] = "28:64:24:0:野兽:碧玉矿坑:0",
		},
		["阿塔哈卡神庙"] = {
			["泽基斯"] = "0:0:38:1:亡灵::0",
			["食尸者维萨克"] = "0:0:48:1:人型生物::0",
		},
		["希利苏斯"] = {
			["格雷瑟尔"] = "0:0:57:0:野兽::0",
			["暮光之王艾沃兰"] = "39:47:60:0:人型生物:暮光营地:0",
			["哈瑞坎尼安"] = "18:26:58:0:元素生物::0",
			["苏尔拉"] = "0:0:59:1:异种蝎::0",
			["瑟提斯"] = "37:27:61:1:人型生物::0",
			["拉普雷斯"] = "58:77:60:1:异种蝎:雷戈虫巢:0",
			["雷克斯·亚希尔"] = "49:25:57:1:异种蝎:亚什虫巢:0",
			["格鲁布索尔"] = "36:72:58:0:野兽::0",
			["克里拉克"] = "0:0:56:0:野兽::0",
		},
		["石爪山脉"] = {
			["巨翼雄兽"] = "44:43:25:0:野兽:暗色湖:0",
			["瑞雯"] = "25:70:24:1:人型生物:焦炭谷:0",
			["工头里格尔"] = "0:0:24:1:人型生物::0",
			["哨兵阿玛拉珊"] = "0:0:27:1:人型生物::0",
			["狂怒的树人"] = "34:69:24:0:元素生物:焦炭谷:0",
			["工头维普弗恩"] = "0:0:22:1:人型生物::0",
			["纳尔塔萨"] = "0:0:30:1:龙类::0",
			["拉文诺克修士"] = "0:0:29:1:人型生物::0",
		},
		["悲伤沼泽"] = {
			["芬加特"] = "62:82:43:0:人型生物:雄鹿沼泽洞穴:0",
			["摩塔索恩"] = "31:51:42:0:元素生物::0",
			["维尔玛克将军"] = "79:63:45:1:龙类:忧伤湿地:0",
			["玉龙"] = "70:56:47:1:龙类::0",
			["失落者酋长"] = "63:20:39:0:人型生物:农田避难所:0",
			["基摩里安"] = "94:56:43:0:人型生物:芦苇海滩:0",
			["失落者厨师"] = "59:24:37:0:人型生物:农田避难所:0",
		},
		["哀嚎洞穴"] = {
			["鞭笞者特里高雷"] = "0:0:19:1:多头怪::0",
			["变异精灵龙"] = "0:0:20:1:龙类:狂风裂口:0",
			["博艾恩"] = "52:54:20:1:人型生物::0",
		},
		["奥特兰克山脉"] = {
			["洛格罗什"] = "54:52:39:0:人型生物:绞刑场:0",
			["斯格霍尔"] = "0:0:36:0:人型生物::0",
			["格拉维斯·斯里诺特"] = "59:41:36:0:人型生物:斯坦恩布莱德:0",
			["纳瑞尔拉萨斯"] = "0:0:44:1:龙类::0",
			["流血者吉米"] = "0:0:23:0:人型生物::0",
			["阿拉加"] = "0:0:35:0:野兽::0",
			["暴躁的本希"] = "0:0:32:0:野兽::0",
			["狂怒的石元素"] = "0:0:38:0:元素生物::0",
		},
		["艾萨拉"] = {
			["长者莫诺斯"] = "0:0:54:1:巨人::0",
			["安提里奥斯"] = "0:0:50:0:野兽::0",
			["鳞须海龟"] = "54:48:52:1:野兽:鳞须海龟洞穴:0",
			["拉格罗尔"] = "0:0:50:0:人型生物::0",
			["伊夫卡尔"] = "17:54:48:0:野兽::0",
			["玛济斯·鹰盔"] = "0:0:52:0:人型生物::0",
			["瓦罗森的幽灵"] = "18:68:48:0:亡灵::0",
			["菲达雷德"] = "0:0:52:0:恶魔::0",
			["方弗罗将军"] = "0:0:51:0:人型生物::0",
			["瑟丝彼拉"] = "35:51:51:0:人型生物:埃达拉斯废墟:0",
		},
		["斯坦索姆"] = {
			["弗雷斯特恩"] = "0:0:57:1:亡灵:长者广场:0",
			["悲惨的提米"] = "0:0:58:1:亡灵:十字军广场:0",
			["石脊"] = "0:0:60:1:亡灵::0",
			["斯库尔"] = "0:0:58:1:亡灵:节日小道:0",
		},
		["荆棘谷"] = {
			["萨克拉希斯"] = "0:0:47:0:人型生物::0",
			["库尔莫克"] = "0:0:42:0:野兽::0",
			["戈鲁格尔"] = "0:0:37:0:人型生物::0",
			["金鳞蜥蜴"] = "44:47:45:0:野兽:水晶矿坑:0",
			["维里弗尼克斯"] = "0:0:42:0:人型生物::0",
			["瑞帕"] = "0:0:44:0:野兽::0",
			["罗洛克"] = "0:0:38:0:人型生物::0",
			["莫什奥格屠夫"] = "0:0:44:1:人型生物::0",
		},
		["东瘟疫之地"] = {
			["塔雷什森"] = "68:21:58:0:人型生物:祖玛沙尔:0",
			["腐烂者海德姆什"] = "81:27:57:0:亡灵::0",
			["游侠之王霍克斯比尔"] = "53:17:60:0:人型生物:奎尔林斯小屋:0",
			["阿比迪斯将军"] = "88:86:59:1:人型生物:血色十字军教堂:0",
			["祖布林·扭枝"] = "72:14:59:0:人型生物:玛兹拉罗:0",
			["僵硬的吉斯"] = "55:45:56:0:亡灵:黑木湖:0",
			["亡语者塞伦德"] = "39:51:56:0:人型生物:蘑菇谷:0",
			["黑暗镰刀"] = "32:25:57:0:亡灵:病木林:0",
			["杜甘·蛮锤"] = "0:0:55:0:人型生物::0",
		},
		["暮色森林"] = {
			["鲁伯斯"] = "23:26:23:0:野兽:暗色河滩:0",
			["纳拉克西斯"] = "0:0:27:0:野兽::0",
			["玛拉索姆公爵"] = "26:29:31:0:亡灵:黎明墓穴:0",
			["芬罗斯"] = "61:41:32:0:人型生物:阳光树林:0",
			["奈法鲁"] = "0:0:34:0:人型生物::0",
			["指挥官菲斯托姆"] = "16:34:32:0:亡灵:黎明墓穴:0",
		},
		["玛拉顿"] = {
			["收割者麦什洛克"] = "0:0:48:1:元素生物:邪恶洞穴:0",
		},
		["灰谷"] = {
			["迷雾嚎叫者"] = "0:0:22:0:野兽::0",
			["乌索洛克"] = "0:0:31:0:野兽::0",
			["恐狼族长"] = "0:0:32:0:人型生物::0",
			["薇丝比娅"] = "9:13:22:0:人型生物:佐拉姆海岸:0",
			["药剂师法尔瑟斯"] = "0:0:22:0:人型生物::0",
			["橡爪"] = "55:62:27:0:人型生物:绿爪村:0",
			["玛戈芬"] = "0:0:23:0:人型生物::0",
			["洛吉什"] = "0:0:25:0:人型生物::0",
			["拉兹王子"] = "0:0:32:0:恶魔::0",
			["阿克瑞鲁斯"] = "0:0:26:0:恶魔::0",
			["埃卡洛姆"] = "0:0:27:0:元素生物::0",
			["钳枝沼泽兽"] = "0:0:25:0:元素生物::0",
		},
		["奥达曼"] = {
			["挖掘专家舒尔弗拉格"] = "33:16:38:1:人型生物:南会议厅:0",
		},
		["诅咒之地"] = {
			["毁灭"] = "48:38:51:0:野兽:巨槌岗哨:0",
			["斯比弗雷尔"] = "0:0:52:0:野兽::0",
			["死眼"] = "22:99:49:0:野兽:污染者高地:0",
			["先知阿库巴尔"] = "0:0:54:0:人型生物::0",
			["格朗特"] = "0:0:50:0:野兽::0",
			["扭曲者莫吉尔"] = "47:15:48:0:人型生物:巨槌要塞:0",
			["顽强的玛古诺斯"] = "0:0:56:0:人型生物::0",
			["德雷斯克恩"] = "44:39:57:0:人型生物::0",
			["掠夺者科拉克"] = "0:0:53:0:野兽::0",
		},
		["艾尔文森林"] = {
			["母蜘蛛"] = "60:50:10:0:野兽:玉石矿坑:0",
			["费德菲尼尔"] = "66:40:12:0:人型生物:石碑湖:0",
			["狡猾的莫加尼"] = "31:67:10:0:人型生物:明镜湖果园:0",
			["索罗斯·莱特芬格"] = "50:81:11:0:人型生物::0",
			["格拉夫·疾齿"] = "26:89:12:0:人型生物:林边空地:0",
			["监工纳尔格"] = "40:76:10:0:人型生物:法戈第矿坑:0",
		},
		["安戈洛环形山"] = {
			["格鲁夫"] = "31:68:57:1:野兽:恐惧小道:0",
			["暴掠龙女王"] = "61:75:50:0:野兽:沼泽地:0",
			["乌卡洛克"] = "68:13:53:0:野兽:蘑菇石:0",
			["萨瓦丝女王"] = "49:83:54:0:异种蝎:巨痕谷:0",
			["暴龙之王摩什"] = "32:35:60:1:野兽::0",
		},
		["莫高雷"] = {
			["执行者埃米尔冈德"] = "41:15:11:0:人型生物:蛮鬃水井:0",
			["鬼嚎"] = "0:0:12:0:野兽::0",
			["马兹拉纳其"] = "55:45:9:0:野兽:被破坏的货车:0",
			["海特拉什"] = "0:0:11:1:人型生物::0",
			["断矛"] = "48:70:9:0:人型生物::0",
			["扫荡者"] = "0:0:10:0:野兽::0",
		},
		["泰达希尔"] = {
			["暮色巡游者"] = "0:0:9:0:野兽::0",
			["乌鲁森"] = "67:58:7:0:人型生物:星风村:0",
			["格雷莫尔"] = "41:78:12:0:人型生物:脊骨堡:0",
			["瑟雷基尔"] = "51:50:6:0:恶魔:地狱石:0",
			["恶臭的黑苔兽"] = "43:29:13:0:元素生物:涌泉河:0",
			["愤怒的谢尔达"] = "36:38:8:0:人型生物:神谕林地:0",
		},
		["费伍德森林"] = {
			["拉吉波尔"] = "48:91:51:0:人型生物:死木村:0",
			["智者奥尔姆"] = "56:22:52:0:野兽:铁木森林:0",
			["莫戈雷斯"] = "0:0:50:0:野兽::0",
			["奥辛尔·灵息"] = "41:86:54:0:恶魔:碧火谷:0",
			["伊姆拉图斯"] = "42:43:56:1:恶魔:碎痕谷:0",
			["死亡之嚎"] = "0:0:49:0:野兽::0",
			["迪塞库斯"] = "0:0:56:0:元素生物::0",
		},
		["黑石山"] = {
			["贝哈默斯"] = "0:0:50:1:人型生物:碾石场:0",
			["裂盾军需官"] = "0:0:55:1:人型生物:黑石塔:0",
		},
		["诺姆瑞根"] = {
			["黑铁大师"] = "0:0:33:1:人型生物::0",
		},
		["燃烧平原"] = {
			["失控的掠夺者"] = "0:0:56:0:元素生物::0",
			["沃尔查"] = "90:39:60:1:巨人:龙翼小径:0",
			["高戈诺奇"] = "0:0:54:0:人型生物::0",
			["赫玛图斯"] = "0:0:60:0:龙类::0",
			["格鲁克拉什"] = "0:0:59:0:人型生物::0",
			["特罗斯巴克"] = "64:34:55:0:恶魔:索瑞森废墟:0",
			["萨里斯·巴加尔"] = "69:36:57:0:人型生物:索瑞森废墟0",
			["死亡之喉"] = "87:48:53:0:野兽:龙翼小径:0",
			["哈克佐尔"] = "79:47:54:0:人型生物:巨槌石:0",
		},
		["西瘟疫之地"] = {
			["玛达萨尔"] = "53:79:56:0:人型生物:悔恨岭:0",
			["工头杰瑞斯"] = "0:0:62:1:人型生物:壁炉谷:0",
			["弗曼恩"] = "0:0:52:0:亡灵::0",
			["血色高阶牧师"] = "54:23:63:1:人型生物::0",
			["哈斯克"] = "62:34:62:0:元素生物:哭泣之洞:0",
			["普特迪乌斯"] = "0:0:58:1:亡灵::0",
			["工头玛希瑞德"] = "0:0:58:0:人型生物::0",
			["血色铁匠"] = "45:13:59:1:人型生物:壁炉谷:0",
			["血色法官"] = "0:0:60:0:人型生物::0",
			["血色质问者"] = "46:14:61:1:人型生物:壁炉谷:0",
			["血色刽子手"] = "0:0:60:1:人型生物:壁炉谷:0",
		},
		["影牙城堡"] = {
			["死亡之誓"] = "0:0:25:1:亡灵::0",
		},
		["赤脊山"] = {
			["雷布查斯"] = "0:0:17:0:人型生物::0",
			["沉默的罗恩"] = "0:0:26:0:人型生物::0",
			["搜寻者埃库隆"] = "0:0:21:0:元素生物::0",
			["查特"] = "0:0:23:0:野兽::0",
			["斯纳弗赖尔"] = "35:67:18:0:龙类::0",
			["卡松"] = "35:8:27:0:人型生物:撕裂者营地:0",
			["斯奎迪克"] = "0:0:19:0:人型生物::0",
			["波德哈特"] = "0:0:25:0:巨人::0",
		},
		["湿地"] = {
			["刺喉雌龙"] = "67:31:31:0:野兽:恐龙岭:0",
			["米尔洛"] = "25:27:25:0:元素生物:日落沼泽:0",
			["纳博恩"] = "0:0:24:0:人型生物::0",
			["马鲁克·龙鳞"] = "0:0:23:0:人型生物::0",
			["加内格·焦颅"] = "0:0:29:0:人型生物::0",
			["龙喉军官"] = "50:49:30:0:人型生物:怒牙营地:0",
			["吸血寡妇"] = "0:0:24:0:野兽::0",
		},
		["死亡矿坑"] = {
			["被洗脑的贵族"] = "0:0:18:1:人型生物::0",
			["玛里莎·杜派格"] = "41:79:18:1:人型生物::0",
			["艾德温·范克里夫"] = "0:0:21:1:人型生物::0",
			["矿工约翰森"] = "0:0:18:1:人型生物::0",
		},
		["剃刀沼泽"] = {
			["剃刀沼泽刺鬃守卫"] = "0:0:30:1:人型生物::0",
			["盲眼猎手"] = "0:0:32:1:野兽::0",
			["唤地者哈穆加"] = "0:0:32:1:人型生物::0",
		},
		["银松森林"] = {
			["血牙狼人"] = "46:25:13:0:野兽:亡者农场:0",
			["维斯迦尔"] = "50:62:14:0:野兽::0",
			["腐皮惩戒者"] = "68:25:22:0:亡灵:芬里斯岛:0",
			["斯纳麦恩"] = "65:24:23:0:亡灵:芬里斯城堡:0",
			["达拉然书记员"] = "62:65:21:0:人型生物:安伯米尔:0",
			["克雷希斯"] = "35:10:15:0:野兽:粘丝洞k:0",
		},
		["灼热峡谷"] = {
			["雷克提拉克"] = "0:0:48:0:野兽::0",
			["斯卡尔德"] = "0:0:49:0:元素生物::0",
			["夏雷纳尔"] = "0:0:47:0:恶魔::0",
			["奴隶主托恩·黑心"] = "41:28:50:0:人型生物:熔渣之池:0",
			["斯莫达尔"] = "0:0:50:0:元素生物:观火岭:0",
			["玛斯托格"] = "0:0:51:1:人型生物::0",
			["未完善的作战傀儡"] = "35:48:46:0:元素生物:大熔炉:0",
		},
		["菲拉斯"] = {
			["基洛特"] = "78:64:47:0:异种蝎:痛苦深渊:0",
			["钻石头"] = "0:0:45:0:人型生物::0",
			["滑翔者安蒂鲁斯"] = "0:0:48:0:野兽::0",
			["潜行者布拉多尔"] = "0:0:48:0:人型生物::0",
			["纳尔利夫"] = "0:0:44:0:元素生物::0",
			["莎尔莱"] = "0:0:46:0:人型生物::0",
			["咆哮者"] = "80:39:42:0:野兽:低地荒野:0",
			["阿拉瑟希斯"] = "46:27:49:0:野兽:双塔山:0",
			["灰腹老熊"] = "0:0:43:0:野兽::0",
		},
		["祖尔法拉克"] = {
			["泽雷利斯"] = "0:0:45:1:人型生物::0",
		},
		["贫瘠之地"] = {
			["哈格"] = "0:0:26:1:人型生物::0",
			["狮王休玛"] = "62:33:23:1:野兽::0",
			["布拉德雷大使"] = "0:0:36:1:亡灵::0",
			["石臂"] = "42:26:15:0:人型生物::0",
			["断矛"] = "57:40:17:0:人型生物::0",
			["赫金·石须"] = "47:84:24:0:人型生物:巴尔莫丹:0",
			["技师维尔雷格"] = "56.3:8.7:19:0:人型生物:淤泥沼:0",
			["「跳跃者」塔克"] = "60:9:19:1:野兽::0",
			["莱丝塔伦"] = "40:14:19:1:人型生物:无水岭:0",
			["矿工弗雷姆"] = "0:0:24:0:人型生物::0",
			["秘法师拉佐斯诺特"] = "59:24:15:1:人型生物:荆棘岭:0",
			["石枪"] = "53:41:17:1:人型生物::0",
			["布隆塔斯"] = "46:73:27:1:野兽:巨人旷野:0",
			["格沙拉罕"] = "47:39:20:1:多头蛇:甜水绿洲:0",
			["工头葛瑞尔斯"] = "56.7:9.1:19:0:人型生物:淤泥沼:0",
			["玛尔金·麦酒"] = "0:0:25:0:人型生物::0",
			["迅鬃斑马"] = "61:33:21:1:野兽::0",
			["拉索利安"] = "47:19:15:0:恶魔:鬼雾峰:0",
			["马库斯·拜尔"] = "46:62:24:1:人型生物:南贫瘠之地:0",
			["雷霆践踏"] = "0:0:24:0:野兽::0",
			["淤泥兽"] = "54.4:9.1:19:0:无可追踪形态:淤泥沼泽:0",
			["天空之刃艾泽里"] = "0:0:25:0:野兽::0",
			["土狼斯诺特"] = "41:21:17:0:野兽::0",
			["艾恩·流水"] = "46:62:25:1:人型生物:南贫瘠之地:0",
			["基洛戈·锤趾队长"] = "0:0:27:1:人型生物::0",
			["汉娜·刃叶"] = "46:63:24:1:人型生物:南贫瘠之地:0",
			["迪舒"] = "51:20:13:0:野兽:黄金之路:0",
			["土地祭司古科罗克"] = "0:0:19:0:人型生物::0",
			["斯文格加特·矛鬃"] = "0:0:22:1:人型生物::0",
			["索拉·羽月"] = "46:63:25:1:人型生物:南贫瘠之地:0",
		},
		["黑石深渊"] = {
			["典狱官斯迪尔基斯"] = "0:0:56:1:人型生物:黑色宝库:0",
			["无敌的潘佐尔"] = "0:0:57:1:元素生物:浇铸间:0",
			["洛考尔"] = "0:0:51:1:元素生物:秩序大厅:0",
			["控火师罗格雷恩"] = "0:0:52:1:人型生物:索瑞森神殿:0",
			["维雷克"] = "0:0:55:1:恶魔:黑色宝库:0",
		},
		["丹莫洛"] = {
			["霜鬃长老阿克提卡斯"] = "21:52:11:0:人型生物:霜鬃食人妖要塞:0",
			["游荡的冰爪熊"] = "55:55:12:0:野兽:冻土岭:0",
			["饥饿的雪怪"] = "40:48:9:0:人型生物:灰色洞穴:0",
			["狂暴的冬狼"] = "31:40:10:0:野兽:涌冰湖:0",
			["吉波维特"] = "26:43:11:0:人型生物:诺姆瑞根:0",
			["雪盲石齶怪"] = "72:52:12:0:人型生物:古博拉采掘场:0",
		},
		["凄凉之地"] = {
			["凯雷恩王子"] = "74:12:33:0:恶魔:萨格隆:0",
			["可憎的滑刃纳迦"] = "35:7:35:0:人型生物:萨瑟里斯海岸:0",
			["卡斯克"] = "49:75:40:0:恶魔:玛诺洛克集会所:0",
			["基格勒尔"] = "58:24:34:0:野兽:雷斧堡垒:0",
			["西斯普拉克"] = "41:60:37:0:野兽::0",
			["被诅咒的半人马"] = "0:0:43:0:人型生物::0",
			["鸦爪摄政者"] = "0:0:22:0:亡灵::0",
		}, 
		--- TBC Rares
		--- x:y:level:elite?:type:subzone:lastseen
		["永歌森林"] = {
			["特雷格拉"] = "70.5:72.3:10:0:人型生物::0",
			["埃迪纳库斯"] = "69.0:46.7:11:0:元素生物::0",
		},
		["幽魂之地"] = {
			["维斯利姆博士"] = "36.0:88.8:18:0:亡灵::0",
		},
		["秘血岛"] = {
			["刺客芬妮萨"] = "19.5:54.3:18:0:人型生物::0",
		},
		["地狱火半岛"] = {
			["野蛮的麦索格"] = "45.3:44.1:61:0:人型生物::0",
			["沃拉克姆"] = "72.7:42.0:62:0:恶魔::0",
			["弗尔古格"] = "24.0:55.4:62:1:::0",
			},
		["赞加沼泽"] = {
			["泥沼潜伏者"] = "50.9:61.0:63:0:元素生物::0",
			["盘牙大使"] = "64.7:41.1:63:0:人型生物::0",
			["玛尔提卡"] = "16.5:36.7:63:1:野兽::0",
			},
		["泰罗卡森林"] = {
			["灾难预言者尤瑞姆"] = "35.8:34.4:64:0:人形生物::0",
			["奥卡雷"] = "58.5:23.4:64:0:人形生物::0",
			["残骨骷髅"] = "38.6:66.9:65:0:亡灵::0",
			},
		["纳格兰"] = {
			["血齿鳄"] = "32.5:53.0:65:0:野兽::0",
			["独行者布罗加斯"] = "29.0:35.0:66:0:人形生物::0",
			["空灵猎手亚尔"] = "32.3:72.8:68:0:恶魔::0",
		},
		["影月谷"] = {
			["扭曲观察者科里度斯"] = "43.5:47.9:68:1:恶魔::0",
			["克兰托尔"] = "45.3:12.3:68:1:恶魔::0",
			["耶瑞卡尔大使"] = "47.5:68.2:69:0:恶魔::0",
		},
		["虚空风暴"] = {
			["惩罚者埃沃考尔"] = "20.2:69.8:68:0:元素生物::0",
			["主工程师洛杉德尔"] = "59.4:62.5:69:0:人形生物::0",
			["努拉莫克"] = "35.1:22.8:70:1:野兽::0",
		},
		["刀锋山"] = {
			["赫玛希恩"] = "28.5:67.6:68:1:龙类::0",
			["莫克拉什"] = "67.4:47.3:68:1:巨人::0",
			["演讲者玛尔高姆"] = "42.2:50.8:68:0:人形生物::0",
			["萨贝里安"] = "64.0:19.0:72:1:龙类::0",
		},
		["卡拉赞"] = {
			["潜伏者希亚其斯"] = "0:0:73:1:野兽::0",
			["滑翔者沙德基斯"] = "0:0:73:1:野兽::0",
			["蹂躏者洛卡德"] = "0:0:73:1:恶魔::0",
		},
	}
	for zone, mobs in pairs(defaults) do
		for name, info in pairs(mobs) do
			if not self.db.profile.mobs[zone][name] then
				self.db.profile.mobs[zone][name] = info
			end
		end
	end
end
end