--[[
Name: LibBabble-CreatureType-3.0
Revision: $Rev: 99 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-creaturetype-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-CreatureType-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 99 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	Bat = "Bat",
	Bear = "Bear",
	Beast = "Beast",
	Beetle = "Beetle",
	["Bird of Prey"] = "Bird of Prey",
	Boar = "Boar",
	["Carrion Bird"] = "Carrion Bird",
	Cat = "Cat",
	Chimaera = "Chimaera",
	["Core Hound"] = "Core Hound",
	Crab = "Crab",
	Critter = "Critter",
	Crocolisk = "Crocolisk",
	Demon = "Demon",
	Devilsaur = "Devilsaur",
	Dog = "Dog",
	Doomguard = "Doomguard",
	Dragonhawk = "Dragonhawk",
	Dragonkin = "Dragonkin",
	Elemental = "Elemental",
	Felguard = "Felguard",
	Felhunter = "Felhunter",
	Fox = "Fox",
	["Gas Cloud"] = "Gas Cloud",
	Ghoul = "Ghoul",
	Giant = "Giant",
	Gorilla = "Gorilla",
	Humanoid = "Humanoid",
	Hyena = "Hyena",
	Imp = "Imp",
	Mechanical = "Mechanical",
	Monkey = "Monkey",
	Moth = "Moth",
	["Nether Ray"] = "Nether Ray",
	["Non-combat Pet"] = "Non-combat Pet",
	["Not specified"] = "Not specified",
	Raptor = "Raptor",
	Ravager = "Ravager",
	["Remote Control"] = "Remote Control",
	Rhino = "Rhino",
	Scorpid = "Scorpid",
	Serpent = "Serpent",
	["Shale Spider"] = "Shale Spider",
	Silithid = "Silithid",
	Spider = "Spider",
	["Spirit Beast"] = "Spirit Beast",
	Sporebat = "Sporebat",
	Succubus = "Succubus",
	Tallstrider = "Tallstrider",
	Totem = "Totem",
	Turtle = "Turtle",
	Undead = "Undead",
	Voidwalker = "Voidwalker",
	["Warp Stalker"] = "Warp Stalker",
	Wasp = "Wasp",
	["Water Elemental"] = "Water Elemental",
	["Wind Serpent"] = "Wind Serpent",
	Wolf = "Wolf",
	Worm = "Worm",
}


if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)
elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations {
	Bat = "Fledermaus",
	Bear = "Bär",
	Beast = "Wildtier",
	Beetle = "Käfer",
	["Bird of Prey"] = "Raubvogel",
	Boar = "Eber",
	["Carrion Bird"] = "Aasvogel",
	Cat = "Katze",
	Chimaera = "Schimäre",
	["Core Hound"] = "Kernhund",
	Crab = "Krebs",
	Critter = "Tier",
	Crocolisk = "Krokilisk",
	Demon = "Dämon",
	Devilsaur = "Teufelssaurier",
	Dog = "Hund",
	Doomguard = "Verdammniswache",
	Dragonhawk = "Drachenfalke",
	Dragonkin = "Drachkin",
	Elemental = "Elementar",
	Felguard = "Teufelswache",
	Felhunter = "Teufelsjäger",
	Fox = "Fuchs",
	["Gas Cloud"] = "Gaswolke",
	Ghoul = "Ghul",
	Giant = "Riese",
	Gorilla = "Gorilla",
	Humanoid = "Humanoid",
	Hyena = "Hyäne",
	Imp = "Wichtel",
	Mechanical = "Mechanisch",
	Monkey = "Affe",
	Moth = "Motte",
	["Nether Ray"] = "Netherrochen",
	["Non-combat Pet"] = "Haustier",
	["Not specified"] = "Nicht spezifiziert",
	Raptor = "Raptor",
	Ravager = "Felshetzer",
	["Remote Control"] = "Ferngesteuert",
	Rhino = "Rhinozeros",
	Scorpid = "Skorpid",
	Serpent = "Schlange",
	["Shale Spider"] = "Shale Spider",
	Silithid = "Silithid",
	Spider = "Spinne",
	["Spirit Beast"] = "Geisterbestie",
	Sporebat = "Sporensegler",
	Succubus = "Sukkubus",
	Tallstrider = "Weitschreiter",
	Totem = "Totem",
	Turtle = "Schildkröte",
	Undead = "Untoter",
	Voidwalker = "Leerwandler",
	["Warp Stalker"] = "Sphärenjäger",
	Wasp = "Wespe",
	["Water Elemental"] = "Wasserelementar",
	["Wind Serpent"] = "Windnatter",
	Wolf = "Wolf",
	Worm = "Wurm",
}
elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations {
	Bat = "Chauve-souris",
	Bear = "Ours",
	Beast = "Bête",
	Beetle = "Hanneton",
	["Bird of Prey"] = "Oiseau de proie",
	Boar = "Sanglier",
	["Carrion Bird"] = "Charognard",
	Cat = "Félin",
	Chimaera = "Chimère",
	["Core Hound"] = "Chien du Magma",
	Crab = "Crabe",
	Critter = "Bestiole",
	Crocolisk = "Crocilisque",
	Demon = "Démon",
	Devilsaur = "Diablosaure",
	Dog = "Chien",
	Doomguard = "Garde funeste",
	Dragonhawk = "Faucon-dragon",
	Dragonkin = "Draconien",
	Elemental = "Elémentaire",
	Felguard = "Gangregarde",
	Felhunter = "Chasseur corrompu",
	Fox = "Renard",
	["Gas Cloud"] = "Nuage de gaz",
	Ghoul = "Goule",
	Giant = "Géant",
	Gorilla = "Gorille",
	Humanoid = "Humanoïde",
	Hyena = "Hyène",
	Imp = "Diablotin",
	Mechanical = "Machine",
	Monkey = "Singe",
	Moth = "Phalène",
	["Nether Ray"] = "Raie du Néant",
	["Non-combat Pet"] = "Familier pacifique",
	["Not specified"] = "Non spécifié",
	Raptor = "Raptor",
	Ravager = "Ravageur",
	["Remote Control"] = "Télécommande",
	Rhino = "Rhinocéros",
	Scorpid = "Scorpide",
	Serpent = "Serpent",
	["Shale Spider"] = "Shale Spider",
	Silithid = "Silithide",
	Spider = "Araignée",
	["Spirit Beast"] = "Esprit de bête",
	Sporebat = "Sporoptère",
	Succubus = "Succube",
	Tallstrider = "Haut-trotteur",
	Totem = "Totem",
	Turtle = "Tortue",
	Undead = "Mort-vivant",
	Voidwalker = "Marcheur du Vide",
	["Warp Stalker"] = "Traqueur dim.",
	Wasp = "Guêpe",
	["Water Elemental"] = "Elémentaire d'eau",
	["Wind Serpent"] = "Serpent des vents",
	Wolf = "Loup",
	Worm = "Ver",
}
elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations {
	Bat = "박쥐",
	Bear = "곰",
	Beast = "야수",
	Beetle = "딱정벌레",
	["Bird of Prey"] = "맹금",
	Boar = "멧돼지",
	["Carrion Bird"] = "독수리",
	Cat = "살쾡이",
	Chimaera = "키메라",
	["Core Hound"] = "심장부 사냥개",
	Crab = "게",
	Critter = "동물",
	Crocolisk = "악어",
	Demon = "악마",
	Devilsaur = "데빌사우루스",
	Dog = "개",
	Doomguard = "파멸의 수호병",
	Dragonhawk = "용매",
	Dragonkin = "용족",
	Elemental = "정령",
	Felguard = "지옥수호병",
	Felhunter = "지옥사냥개",
	Fox = "여우",
	["Gas Cloud"] = "가스",
	Ghoul = "구울",
	Giant = "거인",
	Gorilla = "고릴라",
	Humanoid = "인간형",
	Hyena = "하이에나",
	Imp = "임프",
	Mechanical = "기계",
	Monkey = "원숭이",
	Moth = "나방",
	["Nether Ray"] = "황천의 가오리",
	["Non-combat Pet"] = "애완동물",
	["Not specified"] = "기타",
	Raptor = "랩터",
	Ravager = "칼날발톱",
	["Remote Control"] = "무선조종 장난감",
	Rhino = "코뿔소",
	Scorpid = "전갈",
	Serpent = "뱀",
	["Shale Spider"] = "혈암 거미",
	Silithid = "실리시드",
	Spider = "거미",
	["Spirit Beast"] = "야수 정령",
	Sporebat = "포자날개",
	Succubus = "서큐버스",
	Tallstrider = "타조",
	Totem = "토템",
	Turtle = "거북",
	Undead = "언데드",
	Voidwalker = "보이드워커",
	["Warp Stalker"] = "차원의 추적자",
	Wasp = "말벌",
	["Water Elemental"] = "물 정령",
	["Wind Serpent"] = "천둥매",
	Wolf = "늑대",
	Worm = "벌레",
}
elseif GAME_LOCALE == "esES" then
	lib:SetCurrentTranslations {
	Bat = "Murciélago",
	Bear = "Oso",
	Beast = "Bestia",
	Beetle = "Alfazaque",
	["Bird of Prey"] = "Ave rapaz",
	Boar = "Jabalí",
	["Carrion Bird"] = "Carroñero",
	Cat = "Felino",
	Chimaera = "Quimera",
	["Core Hound"] = "Can del Núcleo",
	Crab = "Cangrejo",
	Critter = "Alma",
	Crocolisk = "Crocolisco",
	Demon = "Demonio",
	Devilsaur = "Demosaurio",
	Dog = "Perro",
	Doomguard = "Guardia apocalíptico",
	Dragonhawk = "Dracohalcón",
	Dragonkin = "Dragón",
	Elemental = "Elemental",
	Felguard = "Guardia vil",
	Felhunter = "Manáfago",
	Fox = "Zorro",
	["Gas Cloud"] = "Nube de Gas",
	Ghoul = "Necrófago",
	Giant = "Gigante",
	Gorilla = "Gorila",
	Humanoid = "Humanoide",
	Hyena = "Hiena",
	Imp = "Diablillo",
	Mechanical = "Mecánico",
	Monkey = "Mono",
	Moth = "Palomilla",
	["Nether Ray"] = "Raya abisal",
	["Non-combat Pet"] = "Mascota no combatiente",
	["Not specified"] = "No especificado",
	Raptor = "Raptor",
	Ravager = "Devastador",
	["Remote Control"] = "Control remoto",
	Rhino = "Rinoceronte",
	Scorpid = "Escórpido",
	Serpent = "Serpiente",
	["Shale Spider"] = "Shale Spider",
	Silithid = "Silítido",
	Spider = "Araña",
	["Spirit Beast"] = "Bestia espíritu",
	Sporebat = "Esporiélago",
	Succubus = "Súcubo",
	Tallstrider = "Zancaalta",
	Totem = "Tótem",
	Turtle = "Tortuga",
	Undead = "No-muerto",
	Voidwalker = "Abisario",
	["Warp Stalker"] = "Acechador deformado",
	Wasp = "Avispa",
	["Water Elemental"] = "Elemental de agua",
	["Wind Serpent"] = "Serpiente alada",
	Wolf = "Lobo",
	Worm = "Gusano",
}
elseif GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations {
	Bat = "Murciélago",
	Bear = "Oso",
	Beast = "Bestia",
	Beetle = "Alfazaque",
	["Bird of Prey"] = "Ave rapaz",
	Boar = "Jabalí",
	["Carrion Bird"] = "Carroñero",
	Cat = "Felino",
	Chimaera = "Quimera",
	["Core Hound"] = "Can del Núcleo",
	Crab = "Cangrejo",
	Critter = "Alma",
	Crocolisk = "Crocolisco",
	Demon = "Demonio",
	Devilsaur = "Demosaurio",
	Dog = "Perro",
	Doomguard = "Guardia apocalíptico",
	Dragonhawk = "Dracohalcón",
	Dragonkin = "Dragon",
	Elemental = "Elemental",
	Felguard = "Guardia vil",
	Felhunter = "Manáfago",
	Fox = "Zorro",
	["Gas Cloud"] = "Nube de Gas", -- Needs review
	Ghoul = "Necrófago",
	Giant = "Gigante",
	Gorilla = "Gorila",
	Humanoid = "Humanoide",
	Hyena = "Hiena",
	Imp = "Diablillo",
	Mechanical = "Mecánico",
	Monkey = "Mono",
	Moth = "Palomilla",
	["Nether Ray"] = "Raya abisal",
	["Non-combat Pet"] = "Mascota mansa",
	["Not specified"] = "Sin especificar",
	Raptor = "Raptor",
	Ravager = "Devastador",
	["Remote Control"] = "Control remoto",
	Rhino = "Rinoceronte",
	Scorpid = "Escórpido",
	Serpent = "Serpiente",
	["Shale Spider"] = "Shale Spider",
	Silithid = "Silítido",
	Spider = "Araña",
	["Spirit Beast"] = "Bestia espíritu",
	Sporebat = "Esporiélago",
	Succubus = "Súcubo",
	Tallstrider = "Zancaalta",
	Totem = "Totém",
	Turtle = "Tortuga",
	Undead = "No-muerto",
	Voidwalker = "Abisario",
	["Warp Stalker"] = "Acechador deformado",
	Wasp = "Avispa",
	["Water Elemental"] = "Elemental de agua",
	["Wind Serpent"] = "Serpiente alada",
	Wolf = "Lobo",
	Worm = "Gusano",
}
elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations {
	Bat = "Летучая мышь",
	Bear = "Медведь",
	Beast = "Животное",
	Beetle = "Жук",
	["Bird of Prey"] = "Сова",
	Boar = "Вепрь",
	["Carrion Bird"] = "Падальщик",
	Cat = "Кошка",
	Chimaera = "Химера",
	["Core Hound"] = "Гончая Недр",
	Crab = "Краб",
	Critter = "Существо",
	Crocolisk = "Кроколиск",
	Demon = "Демон",
	Devilsaur = "Дьявозавр",
	Dog = "Собака",
	Doomguard = "Стражник ужаса",
	Dragonhawk = "Дракондор",
	Dragonkin = "Дракон",
	Elemental = "Элементаль",
	Felguard = "Страж Скверны",
	Felhunter = "Охотник Скверны",
	Fox = "Лиса",
	["Gas Cloud"] = "Газовое облако",
	Ghoul = "Вурдалак",
	Giant = "Великан",
	Gorilla = "Горилла",
	Humanoid = "Гуманоид",
	Hyena = "Гиена",
	Imp = "Бес",
	Mechanical = "Механизм",
	Monkey = "Обезьяна",
	Moth = "Мотылек",
	["Nether Ray"] = "Скат Пустоты",
	["Non-combat Pet"] = "Спутник",
	["Not specified"] = "Не указано",
	Raptor = "Ящер",
	Ravager = "Опустошитель",
	["Remote Control"] = "Управление",
	Rhino = "Люторог",
	Scorpid = "Скорпид",
	Serpent = "Змей",
	["Shale Spider"] = "Сланцевый паук",
	Silithid = "Силитид",
	Spider = "Паук",
	["Spirit Beast"] = "Дух зверя",
	Sporebat = "Спороскат",
	Succubus = "Суккуб",
	Tallstrider = "Долгоног",
	Totem = "Тотем",
	Turtle = "Черепаха",
	Undead = "Нежить",
	Voidwalker = "Демон Бездны",
	["Warp Stalker"] = "Прыгуана",
	Wasp = "Оса",
	["Water Elemental"] = "Элементаль воды",
	["Wind Serpent"] = "Крылатый змей",
	Wolf = "Волк",
	Worm = "Червь",
}
elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations {
	Bat = "蝙蝠",
	Bear = "熊",
	Beast = "野兽",
	Beetle = "甲虫",
	["Bird of Prey"] = "猛禽",
	Boar = "野猪",
	["Carrion Bird"] = "食腐鸟",
	Cat = "豹",
	Chimaera = "奇美拉",
	["Core Hound"] = "熔岩犬",
	Crab = "螃蟹",
	Critter = "小动物",
	Crocolisk = "鳄鱼",
	Demon = "恶魔",
	Devilsaur = "魔暴龙",
	Dog = "狗",
	Doomguard = "末日守卫",
	Dragonhawk = "龙鹰",
	Dragonkin = "龙类",
	Elemental = "元素生物",
	Felguard = "恶魔卫士",
	Felhunter = "地狱猎犬",
	Fox = "狐狸",
	["Gas Cloud"] = "气体云雾",
	Ghoul = "食尸鬼",
	Giant = "巨人",
	Gorilla = "猩猩",
	Humanoid = "人型生物",
	Hyena = "土狼",
	Imp = "小鬼",
	Mechanical = "机械",
	Monkey = "猴子",
	Moth = "蛾子",
	["Nether Ray"] = "虚空鳐",
	["Non-combat Pet"] = "非战斗宠物",
	["Not specified"] = "未指定",
	Raptor = "迅猛龙",
	Ravager = "掠食者",
	["Remote Control"] = "远程控制",
	Rhino = "犀牛",
	Scorpid = "蝎子",
	Serpent = "蛇",
	["Shale Spider"] = "页岩蜘蛛",
	Silithid = "异种虫",
	Spider = "蜘蛛",
	["Spirit Beast"] = "灵魂兽",
	Sporebat = "孢子蝠",
	Succubus = "魅魔",
	Tallstrider = "陆行鸟",
	Totem = "图腾",
	Turtle = "海龟",
	Undead = "亡灵",
	Voidwalker = "虚空行者",
	["Warp Stalker"] = "迁跃捕猎者",
	Wasp = "巨蜂",
	["Water Elemental"] = "水元素",
	["Wind Serpent"] = "风蛇",
	Wolf = "狼",
	Worm = "蠕虫",
}
elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations {
	Bat = "蝙蝠",
	Bear = "熊",
	Beast = "野獸",
	Beetle = "甲殼蟲",
	["Bird of Prey"] = "猛禽",
	Boar = "野豬",
	["Carrion Bird"] = "食腐鳥",
	Cat = "豹",
	Chimaera = "奇美拉",
	["Core Hound"] = "熔核犬",
	Crab = "螃蟹",
	Critter = "小動物",
	Crocolisk = "鱷魚",
	Demon = "惡魔",
	Devilsaur = "魔暴龍",
	Dog = "狗",
	Doomguard = "末日守衛",
	Dragonhawk = "龍鷹",
	Dragonkin = "龍類",
	Elemental = "元素生物",
	Felguard = "惡魔守衛",
	Felhunter = "惡魔獵犬",
	Fox = "狐狸",
	["Gas Cloud"] = "氣體雲",
	Ghoul = "食屍鬼",
	Giant = "巨人",
	Gorilla = "猩猩",
	Humanoid = "人型生物",
	Hyena = "土狼",
	Imp = "小鬼",
	Mechanical = "機械",
	Monkey = "猴子",
	Moth = "蛾",
	["Nether Ray"] = "虛空鰭刺",
	["Non-combat Pet"] = "非戰鬥寵物",
	["Not specified"] = "不明",
	Raptor = "迅猛龍",
	Ravager = "劫毀者",
	["Remote Control"] = "遙控",
	Rhino = "犀牛",
	Scorpid = "蠍子",
	Serpent = "毒蛇",
	["Shale Spider"] = "岩蛛",
	Silithid = "異種蟲族",
	Spider = "蜘蛛",
	["Spirit Beast"] = "靈獸",
	Sporebat = "孢子蝙蝠",
	Succubus = "魅魔",
	Tallstrider = "陸行鳥",
	Totem = "圖騰",
	Turtle = "海龜",
	Undead = "不死族",
	Voidwalker = "虛無行者",
	["Warp Stalker"] = "扭曲巡者",
	Wasp = "黃蜂",
	["Water Elemental"] = "水元素",
	["Wind Serpent"] = "風蛇",
	Wolf = "狼",
	Worm = "蟲",
}

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
