-- ShowGuild 20003.2 - Shows guild above target or player frames.
-- Credits: Shim / PIng -- Extracted from SKMap 1.6.

SGVAR = {}

function ShowGuild_OnLoad()
  this:RegisterEvent("PLAYER_ENTERING_WORLD");
  this:RegisterEvent("PLAYER_LEAVING_WORLD");
  this:RegisterEvent("ADDON_LOADED");
  SlashCmdList["ShowGuild"] = ShowGuild_ChatCommandHandler;
  SLASH_ShowGuild1 = "/showguild";
end

function ShowGuild_OnEvent()
  if (event == "PLAYER_ENTERING_WORLD") then
    this:RegisterEvent("PLAYER_TARGET_CHANGED");
  end;
  if (event == "PLAYER_LEAVING_WORLD") then
    this:UnregisterEvent("PLAYER_TARGET_CHANGED");
  end;
  if (event == "ADDON_LOADED" and arg1 == "ShowGuild") then
    ShowGuild_VarReset = false;
    if (SGVAR["Player"] == nil) then
      ShowGuild_VarReset = true;
    elseif (SGVAR["Target"] == nil) then
      ShowGuild_VarReset = true;
    end;
    if (DV_VarReset == true) then
      ShowGuild_ChatMsg("ShowGuild loaded for the first time.");
      ShowGuild_DisplayHelp();
      SGVAR["Target"] = true;
      SGVAR["Player"] = false;
      return true;
    end;
    local oGuildName = GetGuildInfo("player");
    if UnitInRaid("player") then
      ShowGuild_setOwnGuild("");
    else
      ShowGuild_setOwnGuild(oGuildName);
    end;
  end;

  if (event == "PLAYER_TARGET_CHANGED") then
    local oGuildName = GetGuildInfo("player");
    local sGuildName = GetGuildInfo("target");
    local oFaction = UnitFactionGroup("player");
    local sFaction = UnitFactionGroup("target");
    ShowGuild_setGuild(oGuildName, sGuildName, oFaction, sFaction);
    if UnitInRaid("player") then
      ShowGuild_setOwnGuild("");
    else
      ShowGuild_setOwnGuild(oGuildName);
    end;
  end;
end

function ShowGuild_setGuild(oGuildName, sGuildName, oFaction, sFaction)
  if(SGVAR["Target"] == true) then
    if (sGuildName == nil) or (sGuildName == "") then
      TargetGuildInfo:Hide();
    else
      local id=1;
      local SG_String;
      TextValue = getglobal("TargetGuildInfoButton"..id.."Value");
      SG_String = "|cffffffff"..sGuildName;
      if (oGuildName == sGuildName) then SG_String = "|cff00ff00"..sGuildName; end;
      if not (oFaction == sFaction) then SG_String = "|cffffffff"..strsub(sFaction, 1, 1)..": |cffff0000"..sGuildName; end;
      TextValue:SetText(SG_String);
      TargetGuildInfo:Show();
    end;
  else
    TargetGuildInfo:Hide();
  end;
end

function ShowGuild_setOwnGuild(oGuildName)
  if(SGVAR["Player"] == true) then
    if (oGuildName == nil) or (oGuildName == "") then
      PlayerGuildInfo:Hide();
    else
      local id=1;
      TextValue = getglobal("PlayerGuildInfoButton"..id.."Value");
      TextValue:SetText("|cffffffff"..oGuildName);
      PlayerGuildInfo:Show();
    end;
  else
    PlayerGuildInfo:Hide();
  end;
end

function ShowGuild_DisplayHelp()
  ShowGuild_ChatMSG("/showguild help - display this help");
  ShowGuild_ChatMSG("/showguild player (toggle/show/hide) - Shows guild above the player frame");
  ShowGuild_ChatMSG("/showguild target (toggle/show/hide) - Shows guild above the target frame");
end

function ShowGuild_ChatCommandHandler(msg)
  argv = {};
  for arg in string.gmatch(string.lower(msg), '[%a%d%-%.]+') do
    table.insert(argv, arg);
  end;
  if (argv[1] == nil) then
    ShowGuild_DisplayHelp();
  elseif (argv[1] == "help") then
    ShowGuild_DisplayHelp();
  elseif (argv[1] == "player") then
    if (argv[2] == nil or argv[2] == "toggle") then
      if (SGVAR["Player"] == true) then
        SGVAR["Player"] = false;
        PlayerGuildInfo:Hide();
      else
        SGVAR["Player"] = true;
        PlayerGuildInfo:Show();
      end;
    elseif (argv[2] == "show") then
      SGVAR["Player"] = true;
      PlayerGuildInfo:Show();
    elseif (argv[2] == "hide") then
      SGVAR["Player"] = false;
      PlayerGuildInfo:Hide();
    end;
  elseif (argv[1] == "target") then
    if (argv[2] == nil or argv[2] == "toggle") then
      if (SGVAR["Target"] == true) then
        SGVAR["Target"] = false;
        TargetGuildInfo:Hide();
      else
        SGVAR["Target"] = true;
        TargetGuildInfo:Show();
      end;
    elseif (argv[2] == "show") then
      SGVAR["Target"] = true;
      TargetGuildInfo:Show();
    elseif (argv[2] == "hide") then
      SGVAR["Target"] = false;
      TargetGuildInfo:Hide();
    end;
  end;
end

function ShowGuild_ChatMSG(msg)
  if (DEFAULT_CHAT_FRAME) then
    DEFAULT_CHAT_FRAME:AddMessage("|cffffff00" .. msg );
  end;
end