-- binding variables
BINDING_HEADER_SHITLIST = "ShitList"
BINDING_NAME_TOGGLEGUI = "Toggle GUI"
BINDING_NAME_ADDTARGET = "Add Targeted Player"
BINDING_NAME_REMOVETARGET = "Remove Targeted Player"

-- populate the ShitList.checksdefault table
for i = 1, 51 do
    table.insert(ShitList.checksdefault, "true")
end


-------------------------
-- begin local functions
-------------------------     

-- function to handle options listbutton clicks
local function ShitListClickOptionsListButton()
    if ("LeftButton" == arg1) then
        ShitListemote1 = this:GetText()
        ShitListisrandom = 0
    end
    if ("RightButton" == arg1) then
        ShitListemote2 = this:GetText()
        ShitListisrandom = 0
    end
end


-- function to update the main scrollbar
local function ShitListScrollBar_Update()
    local line
    local lineplusoffset
    FauxScrollFrame_Update(ShitListScrollBar, 50, 5, 16)
    for line = 1, 5 do
        lineplusoffset = line + FauxScrollFrame_GetOffset(ShitListScrollBar)
        if (lineplusoffset <= 50) then
            ShitList.listbuttons[line]:SetText(ShitList.players[lineplusoffset])
            ShitList.listbuttons[line]:Show()
        else
            ShitList.listbuttons[line]:Hide()
        end
    end
end


-- function to left-justify main button text
local function ShitListLeftJustify()
    for i = 1, 5 do
        for _,region in pairs{ ShitList.listbuttons[i]:GetRegions() } do
            if (region.SetTextColor) then
                ShitList.listbuttons[i].text = region
            end
        ShitList.listbuttons[i].text:ClearAllPoints()
        ShitList.listbuttons[i].text:SetPoint("LEFT")
        end
    end
end


-- function to left-justify options button text
local function ShitListOptionsLeftJustify()
    for i = 1, 23 do
        for _,region in pairs{ ShitList.listbuttonsoptions[i]:GetRegions() } do
            if (region.SetTextColor) then
                ShitList.listbuttonsoptions[i].text = region
            end
        ShitList.listbuttonsoptions[i].text:ClearAllPoints()
        ShitList.listbuttonsoptions[i].text:SetPoint("LEFT")
        end
    end
end



-- function to create the buttons in the main scroll list
local function ShitListCreateListButton(name)
    local listbutton = CreateFrame("Button", name, ShitListMainFrame)
    listbutton:SetWidth(150)
    listbutton:SetHeight(16)
    listbutton:SetTextFontObject("GameFontHighlight")
    listbutton:SetTextColor(0, 1, 1)
    return listbutton
end


-- function to create the buttons in the options scroll list
local function ShitListCreateOptionsListButton(name)
    local listbutton = CreateFrame("Button", name, ShitListOptionsFrame)
    listbutton:SetWidth(84)
    listbutton:SetHeight(16)
    listbutton:SetTextFontObject("GameFontHighlight")
    listbutton:SetTextColor(0, 1, 1)
    listbutton:RegisterForClicks("LeftButtonUp", "RightButtonUp")
    listbutton:SetScript("OnMouseUp", function() ShitListClickOptionsListButton() end)
    return listbutton
end


-- function to create main frame buttons
local function CreateMainButtons(name)
    local button = CreateFrame("Button", name, ShitListMainFrame)
    button:SetWidth(112)
    button:SetHeight(20)
    button.texture = button:CreateTexture()
    button.texture:SetAllPoints(button)
    button.texture:SetTexture(0, 0, 0, 0.7)
    button:SetTextFontObject("GameFontNormal")
    button:SetTextColor(0, 1, 1)
    return button
end


-- function to clear list
local function ShitListClickClearList()
    setmetatable(ShitList.players, nil)
    for k,v in pairs(ShitList.players) do
        ShitList.players[k] = nil
    end
    DEFAULT_CHAT_FRAME:AddMessage("Your shit list has been cleared.", 0, 1, 0)
    ShitListScrollBar_Update()
    ShitListLeftJustify()
end


-- function to add target when "Add Target" button is clicked
local function ShitListClickAddTarget()
    local target = UnitName("target")
    if (nil ~= target) then
        for k,v in ipairs(ShitList.players) do
            if (string.find(v, target)) then
                return
            end
        end
        table.insert(ShitList.players, target)
        DEFAULT_CHAT_FRAME:AddMessage("[" .. target .. "]" ..
            " has been shit listed!", 0, 1.0, 0)
        ShitListScrollBar_Update()
        ShitListLeftJustify()
    else
        DEFAULT_CHAT_FRAME:AddMessage("You have nothing targeted!", 1.0, 0, 0)
    end
end


-- function to remove target when "Remove Target" button is clicked
local function ShitListClickRemoveTarget()
    local target = UnitName("target")
    if (nil ~= target) then
        for k,v in ipairs(ShitList.players) do
            if (string.find(v, target)) then
                table.remove(ShitList.players, k)
                DEFAULT_CHAT_FRAME:AddMessage("[" .. target .. "]" ..
                    " has been de-shit listed!", 0, 1.0, 0)
                ShitListScrollBar_Update()
                ShitListLeftJustify()
            end
        end
    end
end


-- function to add name from editbox when "Add Player" button is clicked
local function ShitListClickAddPlayer()
    local player = ShitListEditBox:GetText()
    if (#player > 0) then
        for k,v in ipairs(ShitList.players) do
            if (string.find(v, player)) then
                return
            end
        end
        table.insert(ShitList.players, player)
        DEFAULT_CHAT_FRAME:AddMessage("[" .. player .. "]" ..
            " has been shit listed!", 0, 1.0, 0)
        ShitListScrollBar_Update()
        ShitListLeftJustify()
    else
        DEFAULT_CHAT_FRAME:AddMessage("You must enter a name first!", 1, 0, 0)
    end
    ShitListEditBox:HighlightText()
end


-- function to remove name from editbox when "Remove Player" button is clicked
local function ShitListClickRemovePlayer()
    local player = ShitListEditBox:GetText()
    if (#player > 0) then
        for k,v in ipairs(ShitList.players) do
            if (string.find(v, player)) then
                table.remove(ShitList.players, k)
                DEFAULT_CHAT_FRAME:AddMessage("[" .. player .. "]" ..
                    " has been de-shit listed!", 0, 1.0, 0)
                ShitListScrollBar_Update()
                ShitListLeftJustify()
            end
        end
    end
end

-- OnEvent function for Killing Blow
local function ShitListHostileDeathOnEvent(self, event, ...)
    local player = UnitGUID("player")
    local target = UnitGUID("target")
    local _, desc, sourceGUID, _, _, destGUID = select(1, ...)
    local name
    if (desc == "PARTY_KILL" and sourceGUID == player and destGUID == target) then
        name = UnitName("target")
        for k, v in pairs(ShitList.players) do
            if (string.find(v, name)) then
                name = 1
                break
            else
                name = 0
            end
        end
    end
    if (ShitListisrandom == 1) then
        local firstemote
        local secondemote
        repeat
            firstemote = math.random(51)
        until
            ShitList.checkedstate[firstemote] == "true"
        repeat
            secondemote = math.random(51)
        until 
            ShitList.checkedstate[secondemote] == "true" and secondemote ~= firstemote
        if (desc == "PARTY_KILL" and sourceGUID == player and destGUID == target and ShitListAddEnemyFactionCheckButton:GetChecked()) then
            DoEmote(ShitList.emotes[firstemote])
            DoEmote(ShitList.emotes[secondemote])
        end
        if (desc == "PARTY_KILL" and sourceGUID == player and destGUID == target and not ShitListAddEnemyFactionCheckButton:GetChecked()) then
            if (name == 1) then
                DoEmote(ShitList.emotes[firstemote])
                DoEmote(ShitList.emotes[secondemote])
            end
        end
    end
    if (ShitListisrandom == 0) then
        if (desc == "PARTY_KILL" and sourceGUID == player and destGUID == target and ShitListAddEnemyFactionCheckButton:GetChecked()) then
            DoEmote(ShitListemote1)
            DoEmote(ShitListemote2)
        end
        if (desc == "PARTY_KILL" and sourceGUID == player and destGUID == target and not ShitListAddEnemyFactionCheckButton:GetChecked()) then
            if (name == 1) then
                DoEmote(ShitListemote1)
                DoEmote(ShitListemote2)
            end
        end
    end
end

-- function to create checkbuttons
local function CCB(par)
    local TCB = CreateFrame("CheckButton", nil, par)
    TCB:SetWidth(25)
    TCB:SetHeight(25)
    TCB.text = TCB:CreateFontString(nil, nil, "GameFontNormalSmall")
    TCB.text:SetTextColor(0, 1.0, 1.0)
    TCB.text:SetPoint("LEFT", TCB, "RIGHT", -2, 0)
    TCB:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up")
    TCB:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
    TCB:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight", "ADD")
    TCB:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")    
    return TCB
end


-- function to set minimap icon position
local function ShitListMoveMinimapButton()
    local angle = ShitListSettings_MinimapPosition or 0
    local xpos = 80 * cos(angle)
    local ypos = 80 * sin(angle)
    ShitListIconFrame:SetPoint("TOPLEFT", Minimap, "TOPLEFT", 52-xpos, ypos-52)
end


-- function to calculate minimap icon position on drag
local function ShitListTimerFrame_OnUpdate()
    local xpos, ypos = GetCursorPosition()
    local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom()
    xpos = xmin - xpos / Minimap:GetEffectiveScale()+70
    ypos = ypos / Minimap:GetEffectiveScale() - ymin - 70
    -- assume ShitListSettings_MinimapPosition is a saved variable
    ShitListSettings_MinimapPosition = math.deg(math.atan2(ypos,xpos))
    ShitListMoveMinimapButton()
end

-- function to toggle GUIs
local function ToggleGUIs()
    if ("LeftButton" == arg1) then
        if (ShitListMainFrame:IsVisible()) then
            ShitListMainFrame:Hide()
        else
            ShitListEditEmotesFrame:Hide()
            ShitListOptionsFrame:Hide()
            ShitListMainFrame:Show()
        end
    end
    if ("RightButton" == arg1 and IsShiftKeyDown()) then
        if (ShitListEditEmotesFrame:IsVisible()) then
            ShitListEditEmotesFrame:Hide()
        else
            ShitListOptionsFrame:Hide()
            ShitListMainFrame:Hide()
            ShitListEditEmotesFrame:Show()
        end
    end
    if ("RightButton" == arg1 and not IsShiftKeyDown()) then
        if (ShitListOptionsFrame:IsVisible()) then
            ShitListOptionsFrame:Hide()
        else
            ShitListMainFrame:Hide()
            ShitListEditEmotesFrame:Hide()
            ShitListOptionsFrame:Show()
        end
    end
end


-- function to check all boxes of ShitListEditEmotesFrame
local function ShitListEnableAllEmotes()
    for i = 1, 51 do
        local button = ShitList.checkbuttons[i]
        button:SetChecked(1)
    end
end


-- function to uncheck all boxes of ShitListEditEmotesFrame
local function ShitListDisableAllEmotes()
    for i = 1, 51 do
        local button = ShitList.checkbuttons[i]
        button:SetChecked(nil)
    end
end


-- function to save the checked state of ShitListEditEmotesList check buttons
local function ShitListSaveEditedEmotesList()
    local testvar = 0
    for i = 1, 51 do
        local buttontest = ShitList.checkbuttons[i]
        if (buttontest:GetChecked() == 1) then
            testvar = testvar + 1
        end
    end
    if (2 > testvar) then
        return DEFAULT_CHAT_FRAME:AddMessage("You must select at least two emotes!", 1, 0, 0)
    end
    setmetatable(ShitList.checkedstate, nil)
        for k,v in pairs(ShitList.checkedstate) do
            ShitList.checkedstate[k] = nil
        end
    for i = 1, 51 do
        local button = ShitList.checkbuttons[i]
        local checked = button:GetChecked()
        if (1 == checked) then
            table.insert(ShitList.checkedstate, "true")
        else
            table.insert(ShitList.checkedstate, "false")
        end
    end
    ShitListEditEmotesFrame:Hide()
end

-- function to update the options scrollbar
local function ShitListOptionsScrollBar_Update()
    local line
    local lineplusoffset
    FauxScrollFrame_Update(ShitListOptionsScrollBar, 51, 23, 16)
    for line = 1, 23 do
        lineplusoffset = line + FauxScrollFrame_GetOffset(ShitListOptionsScrollBar)
        if (lineplusoffset <= 51) then
            ShitList.listbuttonsoptions[line]:SetText(ShitList.emotes[lineplusoffset])
            ShitList.listbuttonsoptions[line]:Show()
        else
            ShitList.listbuttonsoptions[line]:Hide()
        end
    end
end

-- function to manage what happens when editbox is selected and enter is pressed
local function ShitListEditBoxOnEnterPressed()
    local player = ShitListEditBox:GetText()
    for k,v in ipairs(ShitList.players) do
        if (string.find(v, player)) then
            table.remove(ShitList.players, k)
            DEFAULT_CHAT_FRAME:AddMessage("["..player.."]".." has been de-shit listed!", 0, 1, 0)
            ShitListScrollBar_Update()
            ShitListLeftJustify()
            ShitListEditBox:HighlightText()
            return
        end
    end
    table.insert(ShitList.players, player)
    DEFAULT_CHAT_FRAME:AddMessage("["..player.."]".." has been shitlisted!", 0, 1, 0)
    ShitListScrollBar_Update()
    ShitListLeftJustify()
    ShitListEditBox:HighlightText()
end

-- global bindings function
function ShitList.bindings(binding)
    if (binding == "TOGGLEGUI") then
        if (ShitListMainFrame:IsVisible()) then
            ShitListMainFrame:Hide()
        else
            ShitListEditEmotesFrame:Hide()
            ShitListOptionsFrame:Hide()
            ShitListMainFrame:Show()
        end
    end
    if (binding == "ADDTARGET") then
        ShitListClickAddTarget()
    end
    if (binding == "REMOVETARGET") then
        ShitListClickRemoveTarget()
    end
end

-- function to toggle saved check button state for main check button
local function ShitListMainCheck_OnClick()
    if (ShitListAddEnemyFactionCheckButton:GetChecked() == 1) then
        ShitListMainCheckButtonState = "true"
    end
    if (ShitListAddEnemyFactionCheckButton:GetChecked() == nil) then
        ShitListMainCheckButtonState = "false"
    end
end

-- set up saved variables
local function ShitListAddonLoaded_OnEvent()
    if (arg1 == "ShitList") then
        ShitListMoveMinimapButton()
        ShitList_list = ShitList_list or {}
        ShitList.players = ShitList_list
        ShitList_checks = ShitList_checks or ShitList.checksdefault
        ShitList.checkedstate = ShitList_checks
        for i = 1, 51 do
            ShitList.checkbuttons[i]:SetChecked(ShitList.checkedstate[i])
        end
        ShitListemote1 = ShitListemote1 or "LAUGH"
        ShitListemote2 = ShitListemote2 or "SPIT"
        ShitListisrandom = ShitListisrandom or 1
        ShitListMainCheckButtonState = ShitListMainCheckButtonState or "false"
        ShitListAddEnemyFactionCheckButton:SetChecked(ShitListMainCheckButtonState)
        ShitListScrollBar_Update()
        ShitListLeftJustify()
    end
end

-- function to show tooltip when mouse is over minimap icon
local function ShitListMinimapIcon_OnEnter()
    ShitListTooltip:Show()
    ShitListTooltip:ClearAllPoints()
    ShitListTooltip:SetPoint("BOTTOMRIGHT", "ShitListIconFrame", "TOPLEFT", 5, -5)
end


-----------------------
-- end local functions
-----------------------


--------------------
-- begin main frame
--------------------

local ShitListFrame = CreateFrame("Frame", "ShitListMainFrame", UIParent)
ShitListFrame:SetHeight(128)
ShitListFrame:SetWidth(256)
ShitListFrame:SetPoint("CENTER")
ShitListFrame:SetBackdrop({ bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
    tile = true, tileSize = 16, edgeSize = 16,
    insets = { left = 4, right = 4, top = 4, bottom = 4 }})
ShitListFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
ShitListFrame:SetScript("OnEvent", function(...) ShitListHostileDeathOnEvent(...) end)


-- main frame version label
ShitListFrame:CreateFontString("ShitListVersionLabel")
ShitListVersionLabel:SetFont("Fonts\\ARIALN.ttf", 14)
ShitListVersionLabel:SetTextColor(0, 1, 0)
ShitListVersionLabel:SetPoint("TOPLEFT", 5, -6)
ShitListVersionLabel:SetText("ShitList v1.4.0")


-- main frame checkbutton label
ShitListFrame:CreateFontString("ShitListCheckBoxMessage")
ShitListCheckBoxMessage:SetFont("Fonts\\ARIALN.ttf", 14)
ShitListCheckBoxMessage:SetPoint("TOPRIGHT", -27, -6)
ShitListCheckBoxMessage:SetTextColor(1, 1, 1, 0.6)
ShitListCheckBoxMessage:SetText("Add Enemy Faction:")


-- scroll frame
local ShitListScroll = CreateFrame("ScrollFrame", "ShitListScrollBar", ShitListMainFrame, "FauxScrollFrameTemplate")
ShitListScroll:SetPoint("TOPLEFT", "ShitListMainFrame", 0, -24)
ShitListScroll:SetPoint("BOTTOMRIGHT", "ShitListMainFrame", -30, 24)
ShitListScroll:SetScript("OnVerticalScroll", function() FauxScrollFrame_OnVerticalScroll(16, ShitListScrollBar_Update) end)


-- first, "anchor" button
local anchorbutton = ShitListCreateListButton("ShitListEntry1")
anchorbutton:SetPoint("TOPLEFT", "ShitListScrollBar", "TOPLEFT", 8, 0)
ShitList.listbuttons[1] = anchorbutton


-- create buttons 2 through 5
for i = 2, 5 do
    local listbutton = ShitListCreateListButton("ShitListEntry"..i)
    listbutton:SetPoint("TOPLEFT", "ShitListEntry"..i-1, "BOTTOMLEFT")
    ShitList.listbuttons[i] = listbutton
end


-- main frame close button
local closebutton = CreateFrame("Button", "ShitListCloseButton", ShitListMainFrame)
closebutton:SetWidth(20)
closebutton:SetHeight(20)
closebutton:SetPoint("TOPRIGHT", "ShitListMainFrame", "TOPRIGHT", -16, 22)
closebutton.texture = closebutton:CreateTexture()
closebutton.texture:SetAllPoints(closebutton)
closebutton.texture:SetTexture(0, 0, 0, 0.7)
closebutton:SetTextFontObject("GameFontNormal")
closebutton:SetText("X")
closebutton:SetTextColor(0, 1, 1)
closebutton:SetScript("OnClick", function() ShitListMainFrame:Hide() end)


-- create main frame clear button
local button = CreateMainButtons("ShitListClearButton")
button:SetPoint("BOTTOM", "ShitListMainFrame", "TOP", 0, 2)
button:SetText("Clear")
button:SetScript("OnClick", function() ShitListClickClearList() end)


-- create main frame add target button
local button = CreateMainButtons("ShitListAddTargetButton")
button:SetPoint("BOTTOMLEFT", "ShitListMainFrame", "BOTTOMLEFT", 16, -22)
button:SetText("Add Target")
button:SetScript("OnClick", function() ShitListClickAddTarget() end)


-- create main frame add player button
local button = CreateMainButtons("ShitListAddPlayerButton")
button:SetPoint("BOTTOMLEFT", "ShitListMainFrame", "BOTTOMLEFT", 16, -42)
button:SetText("Add Player")
button:SetScript("OnClick", function() ShitListClickAddPlayer() end)


-- create main frame remove player button
local button = CreateMainButtons("ShitListRemovePlayerButton")
button:SetPoint("BOTTOMRIGHT", "ShitListMainFrame", "BOTTOMRIGHT", -16, -42)
button:SetText("Remove Player")
button:SetScript("OnClick", function() ShitListClickRemovePlayer() end)


-- create main frame remove target button
local button = CreateMainButtons("ShitListRemoveTargetButton")
button:SetPoint("BOTTOMRIGHT", "ShitListMainFrame", "BOTTOMRIGHT", -16, -22)
button:SetText("Remove Target")
button:SetScript("OnClick", function() ShitListClickRemoveTarget() end)


-- create main frame add enemy faction checkbutton
local check = CreateFrame("CheckButton", "ShitListAddEnemyFactionCheckButton", ShitListMainFrame)
check:SetWidth(25)
check:SetHeight(25)
check:SetPoint("TOPRIGHT", -3, -2)
check:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up")
check:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
check:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight", "ADD")
check:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")
check:SetScript("OnClick", function() ShitListMainCheck_OnClick() end)


-- create main frame editbox and colored frame
local editbox = CreateFrame("EditBox", "ShitListEditBox", ShitListMainFrame)
editbox:SetWidth(226)
editbox:SetHeight(16)
editbox:SetPoint("BOTTOM", 0, 6)
editbox:SetAutoFocus(false)
editbox:SetScript("OnEscapePressed", function() this:ClearFocus() end)
editbox:SetFont("Fonts\\ARIALN.ttf", 14)
editbox:SetTextColor(0, 1, 1)
editbox:ClearFocus()
editbox:SetScript("OnMouseUp", function() this:HighlightText() end)
editbox:SetScript("OnEnterPressed", function() ShitListEditBoxOnEnterPressed() end)
editbox:SetText("Enter player's name.")
editbox:HighlightText()

local editframe = CreateFrame("Frame", "ShitListEditBoxFrame", ShitListMainFrame)
editframe:SetWidth(226)
editframe:SetHeight(16)
editframe:SetPoint("BOTTOM", 0, 6)
editframe.texture = editframe:CreateTexture()
editframe.texture:SetAllPoints(editframe)
editframe.texture:SetTexture(0.2, 0.1, 0.4, 0.5)

-------------------
-- end main frame
-------------------


---------------------------
-- begin edit emotes frame
---------------------------

-- main edit emotes frame
local editemotes = CreateFrame("Frame", "ShitListEditEmotesFrame", UIParent)
editemotes:SetHeight(512)
editemotes:SetWidth(384)
editemotes:SetPoint("CENTER")
editemotes:SetBackdrop({ bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
    tile = true, tileSize = 16, edgeSize = 16,
    insets = { left = 4, right = 4, top = 4, bottom = 4 }})
editemotes:RegisterEvent("ADDON_LOADED")
editemotes:SetScript("OnEvent", function() ShitListAddonLoaded_OnEvent() end)

-- ShitListEditEmotesFrame check buttons with emote text labels
ShitListCheckButton1 = CCB(ShitListEditEmotesFrame)
ShitListCheckButton1:SetPoint("TOPLEFT", ShitListEditEmotesFrame, 5, -5)
ShitListCheckButton1.text:SetText(ShitList.emotes[1])
table.insert(ShitList.checkbuttons, ShitListCheckButton1)

for i = 2, 20 do 
    local button = CCB(ShitListEditEmotesFrame) 
    button:SetPoint("TOP", ShitList.checkbuttons[i-1], "BOTTOM") 
    button.text:SetText(ShitList.emotes[i]) 
    ShitList.checkbuttons[i] = button
end 

ShitListCheckButton21 = CCB(ShitListEditEmotesFrame)
ShitListCheckButton21:SetPoint("TOP", ShitListEditEmotesFrame, "TOP", -22, -5)
ShitListCheckButton21.text:SetText(ShitList.emotes[21])
table.insert(ShitList.checkbuttons, ShitListCheckButton21)

for i = 22, 40 do 
    local button = CCB(ShitListEditEmotesFrame) 
    button:SetPoint("TOP", ShitList.checkbuttons[i-1], "BOTTOM") 
    button.text:SetText(ShitList.emotes[i]) 
    ShitList.checkbuttons[i] = button 
end 

ShitListCheckButton41 = CCB(ShitListEditEmotesFrame)
ShitListCheckButton41:SetPoint("TOPRIGHT", ShitListEditEmotesFrame, "TOPRIGHT", -50, -5)
ShitListCheckButton41.text:SetText(ShitList.emotes[41])
table.insert(ShitList.checkbuttons, ShitListCheckButton41)

for i = 42, 51 do 
    local button = CCB(ShitListEditEmotesFrame) 
    button:SetPoint("TOP", ShitList.checkbuttons[i-1], "BOTTOM") 
    button.text:SetText(ShitList.emotes[i]) 
    ShitList.checkbuttons[i] = button 
end

-- ShitListEditEmotesFrame buttons
local TEA = CreateFrame("Button", "ShitListEnableAll", ShitListEditEmotesFrame)
TEA:SetHeight(20)
TEA:SetWidth(112)
TEA.texture = TEA:CreateTexture()
TEA.texture:SetAllPoints(TEA)
TEA.texture:SetTexture(0, 0, 0, 0.7)
TEA:SetPoint("BOTTOMRIGHT", ShitListEditEmotesFrame, "BOTTOMRIGHT", -10, 50)
TEA:SetTextFontObject("GameFontNormal")
TEA:SetText("Enable All")
TEA:SetTextColor(0, 1, 1)
TEA:SetScript("OnClick", function() ShitListEnableAllEmotes() end)

local TDA = CreateFrame("Button", "ShitListDisableAll", ShitListEditEmotesFrame)
TDA:SetHeight(20)
TDA:SetWidth(112)
TDA.texture = TDA:CreateTexture()
TDA.texture:SetAllPoints(TDA)
TDA.texture:SetTexture(0, 0, 0, 0.7)
TDA:SetPoint("BOTTOMRIGHT", ShitListEditEmotesFrame, "BOTTOMRIGHT", -10, 30)
TDA:SetTextFontObject("GameFontNormal")
TDA:SetText("Disable All")
TDA:SetTextColor(0, 1, 1)
TDA:SetScript("OnClick", function() ShitListDisableAllEmotes() end)

local TOK = CreateFrame("Button", "ShitListOkay", ShitListEditEmotesFrame)
TOK:SetHeight(20)
TOK:SetWidth(112)
TOK.texture = TOK:CreateTexture()
TOK.texture:SetAllPoints(TOK)
TOK.texture:SetTexture(0, 0, 0, 0.7)
TOK:SetPoint("BOTTOMRIGHT", ShitListEditEmotesFrame, "BOTTOMRIGHT", -10, 10)
TOK:SetTextFontObject("GameFontNormal")
TOK:SetText("Okay")
TOK:SetTextColor(0, 1, 1)
TOK:SetScript("OnClick", function() ShitListSaveEditedEmotesList() end)

ShitListEditEmotesFrame:Hide()

-------------------------
-- end edit emotes frame
-------------------------


---------------------------
-- begin minimap icon code
---------------------------

-- main minimap icon frame
local micon = CreateFrame("Button", "ShitListIconFrame", Minimap)
micon:SetFrameStrata("LOW")
micon:EnableMouse(true)
micon:SetMovable(true)
micon:SetToplevel(true)
micon:SetWidth(32)
micon:SetHeight(32)
micon:SetPoint("TOPLEFT")
micon:SetNormalTexture("Interface\\AddOns\\ShitList\\ShitList-Icon-Up")
micon:SetPushedTexture("Interface\\AddOns\\ShitList\\ShitList-Icon-Down")
micon:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", "ADD")
micon:RegisterForClicks("LeftButtonUp", "RightButtonUp")
micon:RegisterForDrag("LeftButton")
micon:SetScript("OnMouseUp", function() ToggleGUIs() ShitListEditBox:SetText("Enter player's name.") ShitListEditBox:HighlightText() end)
micon:SetScript("OnDragStart", function() this:LockHighlight() ShitListTimerFrame:Show() end)
micon:SetScript("OnDragStop", function() ShitListTimerFrame:Hide() this:UnlockHighlight() end)
micon:SetScript("OnEnter", function() ShitListMinimapIcon_OnEnter() end)
micon:SetScript("OnLeave", function() ShitListTooltip:Hide() end)


-- timer frame
local timer = CreateFrame("Frame", "ShitListTimerFrame")
timer:SetScript("OnUpdate", function() ShitListTimerFrame_OnUpdate() end)
timer:Hide()

-------------------------
-- end minimap icon code
-------------------------


-----------------------
-- begin options frame
-----------------------

-- main frame
local optframe = CreateFrame("Frame", "ShitListOptionsFrame", UIParent)
optframe:SetWidth(117)
optframe:SetHeight(384)
optframe:SetPoint("CENTER")
optframe:SetBackdrop({ bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
    tile = true, tileSize = 16, edgeSize = 16,
    insets = { left = 4, right = 4, top = 4, bottom = 4 }})

-- scroll frame
local ShitListScroll = CreateFrame("ScrollFrame", "ShitListOptionsScrollBar", ShitListOptionsFrame, "FauxScrollFrameTemplate")
ShitListScroll:SetPoint("TOPLEFT", "ShitListOptionsFrame", 0, -8)
ShitListScroll:SetPoint("BOTTOMRIGHT", "ShitListOptionsFrame", -30, 8)
ShitListScroll:SetScript("OnVerticalScroll", function() FauxScrollFrame_OnVerticalScroll(16, ShitListOptionsScrollBar_Update) end)

-- first, "anchor" button
local anchorbutton = ShitListCreateOptionsListButton("ShitListOptionsEntry1")
anchorbutton:SetPoint("TOPLEFT", "ShitListOptionsScrollBar", "TOPLEFT", 8, 0)
ShitList.listbuttonsoptions[1] = anchorbutton

-- create buttons 2 through 23
for i = 2, 23 do
    local listbutton = ShitListCreateOptionsListButton("ShitListOptionsEntry"..i)
    listbutton:SetPoint("TOPLEFT", "ShitListOptionsEntry"..i-1, "BOTTOMLEFT")
    ShitList.listbuttonsoptions[i] = listbutton
end

-- "Random" button
local button = CreateFrame("Button", "ShitListOptionsRandom", ShitListOptionsFrame)
button:SetWidth(112)
button:SetHeight(20)
button:SetPoint("BOTTOM", "ShitListOptionsFrame", "TOP", 0, 2)
button.texture = button:CreateTexture()
button.texture:SetAllPoints()
button.texture:SetTexture(0, 0, 0, 0.7)
button:SetTextFontObject("GameFontNormal")
button:SetTextColor(0, 1, 1)
button:SetText("Random")
button:SetScript("OnClick", function() ShitListisrandom = 1 ShitListemote1 = "RANDOM" ShitListemote2 = "RANDOM" end)

-- "Okay" button
local button = CreateFrame("Button", "ShitListOptionsOkay", ShitListOptionsFrame)
button:SetWidth(112)
button:SetHeight(20)
button:SetPoint("TOP", "ShitListOptionsFrame", "BOTTOM", 0, -2)
button.texture = button:CreateTexture()
button.texture:SetAllPoints()
button.texture:SetTexture(0, 0, 0, 0.7)
button:SetTextFontObject("GameFontNormal")
button:SetTextColor(0, 1, 1)
button:SetText("Okay")
button:SetScript("OnClick", function() ShitListOptionsFrame:Hide() DEFAULT_CHAT_FRAME:AddMessage("Emote1: "..ShitListemote1..".  Emote2: "..ShitListemote2..".", 0, 1, 0) end)

-- "Help" button
local button = CreateFrame("Button", "ShitListOptionsHelp", ShitListOptionsFrame)
button:SetWidth(112)
button:SetHeight(20)
button:SetPoint("TOP", "ShitListOptionsFrame", "BOTTOM", 0, -24)
button.texture = button:CreateTexture()
button.texture:SetAllPoints()
button.texture:SetTexture(0, 0, 0, 0.7)
button:SetTextFontObject("GameFontNormal")
button:SetTextColor(0, 1, 1)
button:SetText("Help")
button:SetScript("OnClick", function() ShitListOptionsHelpScreen:Show() end)

ShitListOptionsFrame:Hide()

---------------------
-- end options frame
---------------------


--------------------
-- begin help frame
--------------------

local helpframe = CreateFrame("Frame", "ShitListOptionsHelpScreen", UIParent)
helpframe:SetWidth(256)
helpframe:SetHeight(286)
helpframe:SetPoint("CENTER")
helpframe:SetBackdrop({ bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
    tile = true, tileSize = 16, edgeSize = 16,
    insets = { left = 4, right = 4, top = 4, bottom = 4 }})
helpframe:SetScript("OnShow", function() ShitListOptionsFrame:Hide() end)

-- create fontstring
local fs = ShitListOptionsHelpScreen:CreateFontString("$parentText", "ARTWORK", "GameFontNormal")
fs:SetPoint("TOPLEFT", "ShitListOptionsHelpScreen", "TOPLEFT", 10, -10)
fs:SetPoint("BOTTOMRIGHT", "ShitListOptionsHelpScreen", "BOTTOMRIGHT", -10, 10)
fs:SetTextHeight(16)
fs:SetTextColor(0, 1, 1, 1)
fs:SetText("Left-Click an option to set it as your first emote.  Right-Click an option to set it as your second emote.  Click 'Random' to randomly select from a list of 51 emotes for each of your emotes.  After making your selection click 'Okay'.  Shift-Right-Click the minimap icon to bring up a menu to edit which emotes will fire in random mode.  Uncheck the ones you do not wish to use and then click 'Okay'.")

-- create 'Okay' button
local button = CreateFrame("Button", "ShitListHelpOkay", ShitListOptionsHelpScreen)
button:SetWidth(112)
button:SetHeight(20)
button:SetPoint("TOP", "ShitListOptionsHelpScreen", "BOTTOM", 0, -2)
button.texture = button:CreateTexture()
button.texture:SetAllPoints()
button.texture:SetTexture(0, 0, 0, 0.7)
button:SetTextFontObject("GameFontNormal")
button:SetTextColor(0, 1, 1)
button:SetText("Okay")
button:SetScript("OnClick", function() ShitListOptionsHelpScreen:Hide() ShitListOptionsFrame:Show() end)

-- hide frame by default
ShitListOptionsHelpScreen:Hide()

------------------
-- end help frame
------------------


-----------------
-- begin tooltip
-----------------

-- main tooltip frame
local tooltip = CreateFrame("Frame", "ShitListTooltip", UIParent)
tooltip:SetWidth(250)
tooltip:SetHeight(86)
tooltip:SetPoint("CENTER")
tooltip:SetClampedToScreen(true)
tooltip:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background",
    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
    tile = true, tileSize = 16, edgeSize = 16,
    insets = { left = 5, right = 5, top = 5, bottom = 5 }})
tooltip:SetBackdropColor(0, 0, 0)
tooltip:SetBackdropBorderColor(1, 1, 1)
tooltip:SetScript("OnLoad", function() this:Raise() end)
tooltip:SetScript("OnShow", function() this:SetScale(UIParent:GetScale()) end)

-- tooltip "ShitList"
tooltip.text = tooltip:CreateFontString("ShitListTooltipText", "ARTWORK", "GameFontNormalLarge")
tooltip.text:SetPoint("TOPLEFT", 10, -10)
tooltip.text:SetText("ShitList")
tooltip.text:SetTextHeight(15)
tooltip.text:SetTextColor(1, 1, 1)

-- tooltip version label
tooltip.text2 = tooltip:CreateFontString("ShitListTooltipText2", "ARTWORK", "GameFontNormal")
tooltip.text2:SetPoint("TOPRIGHT", -10, -10)
tooltip.text2:SetText("v1.4.0")
tooltip.text2:SetTextHeight(11)
tooltip.text2:SetTextColor(0.5, 0.5, 0.5)

-- tooltip "Toggle GUI"
tooltip.text3 = tooltip:CreateFontString("ShitListTooltipText3", "ARTWORK", "GameFontNormal")
tooltip.text3:SetPoint("TOPLEFT", "ShitListTooltipText", "BOTTOMLEFT", 0, -5)
tooltip.text3:SetText("Toggle GUI")
tooltip.text3:SetTextHeight(11)
tooltip.text3:SetTextColor(0, 1, 1)

-- tooltip "Left-Click"
tooltip.text4 = tooltip:CreateFontString("ShitListTooltipText4", "ARTWORK", "GameFontNormal")
tooltip.text4:SetPoint("TOPRIGHT", "ShitListTooltipText2", "BOTTOMRIGHT", 0, -9)
tooltip.text4:SetText("Left-Click")
tooltip.text4:SetTextHeight(11)
tooltip.text4:SetTextColor(0, 1, 0)

-- tooltip "Toggle Options"
tooltip.text5 = tooltip:CreateFontString("ShitListTooltipText5", "ARTWORK", "GameFontNormal")
tooltip.text5:SetPoint("TOPLEFT", "ShitListTooltipText3", "BOTTOMLEFT", 0, -5)
tooltip.text5:SetText("Toggle Options")
tooltip.text5:SetTextHeight(11)
tooltip.text5:SetTextColor(0, 1, 1)

-- tooltip "Right-Click"
tooltip.text6 = tooltip:CreateFontString("ShitListTooltipText6", "ARTWORK", "GameFontNormal")
tooltip.text6:SetPoint("TOPRIGHT", "ShitListTooltipText4", "BOTTOMRIGHT", 0, -5)
tooltip.text6:SetText("Right-Click")
tooltip.text6:SetTextHeight(11)
tooltip.text6:SetTextColor(0, 1, 0)

-- tooltip "Toggle Edit Emotes"
tooltip.text7 = tooltip:CreateFontString("ShitListTooltipText7", "ARTWORK", "GameFontNormal")
tooltip.text7:SetPoint("TOPLEFT", "ShitListTooltipText5", "BOTTOMLEFT", 0, -5)
tooltip.text7:SetText("Toggle Edit Emotes")
tooltip.text7:SetTextHeight(11)
tooltip.text7:SetTextColor(0, 1, 1)

-- tooltip "Shift-Right-Click"
tooltip.text8 = tooltip:CreateFontString("ShitListTooltipText8", "ARTWORK", "GameFontNormal")
tooltip.text8:SetPoint("TOPRIGHT", "ShitListTooltipText6", "BOTTOMRIGHT", 0, -5)
tooltip.text8:SetText("Shift-Right-Click")
tooltip.text8:SetTextHeight(11)
tooltip.text8:SetTextColor(0, 1, 0)

tooltip:Hide()

---------------
-- end tooltip
---------------


-- set up initial scrollbar and left-justify initial button text
ShitListScrollBar_Update()
ShitListOptionsScrollBar_Update()
ShitListLeftJustify()
ShitListOptionsLeftJustify()


-- make ShitListMainFrame and children closable with escape key
table.insert(UISpecialFrames, "ShitListMainFrame")