--- Shield Left
--- This mod was originally written by VincentGdG
--- This incarnation of ShieldLeft as modifications by adougherty (Starspring on Silver Hand)
--- **** This latest version was editted by Firegrove (Firehunter of Velen) to include Mage's Ice Barrier (14 May 2008)
--[[ **** The Ice Barrier portion only works with the English version - have not updated for others since I don't 
	know the spell names for those languages. It would be very easy to update if I had the translations ]]--

--[[ (Firegrove, 20 May 08) For mages, if you cast Mana Shield and Ice Barrier, the ShieldLeft bar will disappear when the first shield
	 fades - even though the other shield is still active. Haven't tried to fix that one since I'm pretty sure most
	 people wouldn't be casting both Mana Shield and Ice Barrier at the same time.]]--

SL = (SL or {});
SL.MeleeStats = (SL.MeleeStats or {});
SL.SpellStats = (SL.SpellStats or {});
SL.verbose = (SL.verbose or false);
SL.Debug = (SL.Debug or false);
SL_MaxShield = 0;
SL_MaxShield_other = 0; -- **** used to assign MaxShield since now have to pick between two for Mages
SL_MaxShield_ice = 0; -- **** added to account for Mage Ice Barrier
SL_ShieldLeft = 0;
SL_HasShield = false;
SL_VERSION = "3.1.7.1b";

SL_TextRed = "|cFFFF0000"; -- **** added these to make color selection easier to understand
SL_TextGreen = "|cFF00FF00";
SL_TextBlue = "|cFF0000FF";
SL_TextYellow = "|cFFFFFF00";

SLASH_SHIELDLEFT1 = "/shieldleft";
SLASH_SHIELDLEFT2 = "/sl";

eventlist = {
	"COMBAT_LOG_EVENT_UNFILTERED",
	"UNIT_SPELLCAST_SUCCEEDED",
	"LEARNED_SPELL_IN_TAB",
	"PLAYER_DEAD",
	"PLAYER_ENTERING_WORLD"
}

-- ****************************************************************
-- debug
-- ****************************************************************


local function debug(msg)
	if SL.Debug then
		DEFAULT_CHAT_FRAME:AddMessage(SL_TextGreen.."SL [Debug]: "..msg);
	end
end

-- ****************************************************************
-- verbose
-- ****************************************************************


local function verbose(msg)
	if SL.verbose then
		DEFAULT_CHAT_FRAME:AddMessage(SL_TextYellow.."SL [Verbose]: "..msg);
	end
end

-- ****************************************************************
-- print
-- ****************************************************************


local function print(msg)
	DEFAULT_CHAT_FRAME:AddMessage(SL_TextYellow.."SL: "..msg);
end

-- ****************************************************************
-- error
-- ****************************************************************


local function error(msg)
	DEFAULT_CHAT_FRAME:AddMessage(SL_TextRed.."ERROR: " .. msg);
	UIErrorsFrame:AddMessage("!! " .. msg .. " !!", 1.0, 1.0, 0, 1, 3)
end

-- ****************************************************************
-- RegisterEvents
-- ****************************************************************

local function RegisterEvents(EventList)
	debug("Registering Events");
	if not EventList then
		error("eventlist is missing")
		return
	end
	for _,aktEvent in pairs(EventList) do
		this:RegisterEvent(aktEvent)
	end
end

-- ****************************************************************
-- UnregisterEvents
-- ****************************************************************

local function UnregisterEvents(EventList)
	if not EventList then
		error("eventlist is missing")
		return
	end
	for _,aktEvent in pairs(EventList) do
		this:UnregisterEvent(aktEvent)
	end
end

-- ****************************************************************
-- CheckShieldSpells
-- ****************************************************************

local function CheckShieldSpells()
	verbose(SL_MSG_CHECKINGSPELLS);
	
	SL_MaxShield = 0; -- Reset incase gear changed
	SL_MaxShield_ice = 0; -- **** added to reset Ice Barrier

	-- Priests and Mages
	local i = 1
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			do break end
		end
		if spellName == SL_SHIELD then
			--debug("found " .. spellName .. '(' .. spellRank .. ')' )
			ShieldLeftTooltip:SetSpell(i, BOOKTYPE_SPELL);
			-- For some reason this is coming back as nil sometimes
			if (SL_ABSORBING and ShieldLeftTooltipTextLeft4:GetText()) then
				local _, _, dmg = string.find(ShieldLeftTooltipTextLeft4:GetText(), SL_ABSORBING);
				--debug(ShieldLeftTooltipTextLeft4:GetText())
				if ( dmg ) then
					--debug("Can Absorb: "..dmg)
					if SL_MaxShield < tonumber(dmg) then
						dmg = tonumber(dmg);
						SL_MaxShield = dmg;
						--debug(SL_MSG_NEWMAXSHIELD .. SL_MaxShield);
					end
				end
			end
-- **** For Mages with Ice Barrier
		elseif spellName == SL_SHIELD_ICE then
			--debug("found " .. spellName .. '(' .. spellRank .. ')' )
			ShieldLeftTooltip:SetSpell(i, BOOKTYPE_SPELL);
			-- For some reason this is coming back as nil sometimes
			if (SL_ABSORBING_ICE and ShieldLeftTooltipTextLeft4:GetText()) then
				local _, _, dmg = string.find(ShieldLeftTooltipTextLeft4:GetText(), SL_ABSORBING_ICE);
				--debug(ShieldLeftTooltipTextLeft4:GetText())
				if ( dmg ) then
					--debug("Can Absorb: "..dmg)
					if SL_MaxShield_ice < tonumber(dmg) then
						dmg = tonumber(dmg);
						SL_MaxShield_ice = dmg;
						--debug(SL_MSG_NEWMAXSHIELD .. SL_MaxShield_ice);
					end
				end
			end
		end
		i = i + 1
	end
	
	-- Warlocks
	local i = 1
	if PetHasActionBar() then
		while true do
			local spellName, spellRank = GetSpellName(i, BOOKTYPE_PET)
			if not spellName then
                          do break end
			end
			if spellName == SL_SHIELD then
				-- debug("found " .. spellName .. '(' .. spellRank .. ')' )
				ShieldLeftTooltip:SetSpell(i, BOOKTYPE_PET);
				local text = ShieldLeftTooltipTextLeft4:GetText()
				-- debug(text)
				local _, _, dmg = string.find(text, SL_ABSORBING);
				if ( dmg ) then
						
					if SL_MaxShield < tonumber(dmg) then
						SL_MaxShield = tonumber(dmg);
						-- debug(SL_MSG_NEWMAXSHIELD .. SL_MaxShield);
					end
				end
			end
			i = i + 1
		end
	end
	
	-- Add in Priest's healing bonus
	local _,playerclass = UnitClass("player");
	if playerclass == "PRIEST" then
		bonusHealing = GetSpellBonusHealing();
		--debug("Bonus Healing: "..bonusHealing);
		SL_MaxShield = SL_MaxShield + math.floor(bonusHealing * .25);
	end

end

-- ****************************************************************
-- SlashCmdList
-- ****************************************************************

SlashCmdList["SHIELDLEFT"] = function(msg)
	if msg == "reset" then
		ShieldLeft_Reset()
	elseif msg == "info" then
		ShieldLeft_ShowInfo()
	elseif msg == "check" then
		CheckShieldSpells()
	elseif msg == "verbose" then
		SL.verbose = not SL.verbose;
		if SL.verbose then
			print(SL_MSG_VERBOSEON)
		else
			print(SL_MSG_VERBOSEOFF)
		end
	elseif msg == "debug" then
		SL.Debug = not SL.Debug;
		if SL.Debug then
			print(SL_MSG_DEBUGON)
		else
			print(SL_MSG_DEBUGOFF)
		end
	else
		print(SL_MSG_HELP);
	end
end

-- ****************************************************************
-- ShieldLeft_OnEnter
-- ****************************************************************

function ShieldLeft_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	GameTooltip:SetText(SL_MSG_CLICKTODRAG);
end

-- ****************************************************************
-- ShieldLeft_OnLoad
-- ****************************************************************

function ShieldLeft_OnLoad()
	RegisterEvents(eventlist);
	local _,playerclass = UnitClass("player");

	if playerclass == "PRIEST" then
		debug("adjusting for Priest");
		SL_SHIELD = SL_SHIELD_PRIEST;
		SL_ABSORBING = SL_ABSORBING_PRIEST;
		SL_YOUGAINSHIELD = SL_YOUGAINSHIELD_PRIEST;
		SL_YOULOOSESHIELD = SL_YOULOOSESHIELD_PRIEST;
	elseif playerclass == "WARLOCK" then
		debug("adjusting for Warlock");
		SL_SHIELD = SL_SHIELD_WARLOCK
		SL_ABSORBING = SL_ABSORBING_WARLOCK
		SL_YOUGAINSHIELD = SL_YOUGAINSHIELD_WARLOCK;
		SL_YOULOOSESHIELD = SL_YOULOOSESHIELD_WARLOCK;
		this:RegisterEvent("PET_BAR_UPDATE");
	elseif playerclass == "MAGE" then
		debug("adjusting for Mage");
		SL_SHIELD = SL_SHIELD_MAGE;
		SL_ABSORBING = SL_ABSORBING_MAGE;
		SL_YOUGAINSHIELD = SL_YOUGAINSHIELD_MAGE;
		SL_YOULOOSESHIELD = SL_YOULOOSESHIELD_MAGE;

-- *** Added these variables - should set the variables for the shield to reflect Ice Barrier variables
		SL_SHIELD_ICE = SL_SHIELD_MAGE_ICE;
		SL_ABSORBING_ICE = SL_ABSORBING_MAGE_ICE;
		SL_YOUGAINSHIELD_ICE = SL_YOUGAINSHIELD_MAGE_ICE;
		SL_YOULOOSESHIELD_ICE = SL_YOULOOSESHIELD_MAGE_ICE;
-- **** moved the unload section here if not mage, warlock, or priest
	else
		UnregisterEvents(eventlist)
		return;
	end
	verbose(SL_MSG_LOADED);
end

-- ****************************************************************
-- ShieldLeft_ShowInfo
-- ****************************************************************

function ShieldLeft_ShowInfo()
	print(SL_MSG_VERSION..SL_VERSION);
	if SL.verbose then
		print(SL_MSG_VERBOSEON)
	else
		print(SL_MSG_VERBOSEOFF)
	end
	if SL.Debug then
		print(SL_MSG_DEBUGON)
	else
		print(SL_MSG_DEBUGOFF)
	end
	print(SL_MSG_MAXSHIELD .. SL_MaxShield .. "\n");
-- **** Added this to show the MaxShield for Ice Barrier - it was more for debugging
	print(SL_MSG_MAXSHIELD_ICE .. SL_MaxShield_ice.. "\n"); 
end

-- ****************************************************************
-- ShieldLeft_Reset
-- ****************************************************************

function ShieldLeft_Reset()
	SL.MeleeStats = {};
	SL.SpellStats = {};
	print(SL_MSG_STATSRESET);
end

-- ****************************************************************
-- ShieldLeft_AddDamage
-- ****************************************************************

-- this adds meelee damage to the database
local function ShieldLeft_AddDamage(unit, dmg)
	if ( not SL.MeleeStats[unit] ) then
		SL.MeleeStats[unit] = { ["hits"] = 1, ["dmg"] = dmg, ["med"] = dmg };
		verbose(SL_MSG_NEWCRITTER .. unit .. "(" .. dmg .. ")");
	else
		SL.MeleeStats[unit].hits = SL.MeleeStats[unit].hits + 1;
		SL.MeleeStats[unit].dmg = SL.MeleeStats[unit].dmg + dmg;
		local oldmed = (SL.MeleeStats[unit].med or 0);
		SL.MeleeStats[unit].med = ceil(SL.MeleeStats[unit].dmg / SL.MeleeStats[unit].hits);
		if abs(SL.MeleeStats[unit].med - oldmed) > 0 then
			verbose(unit .. ": " .. SL.MeleeStats[unit].med);
		end
	end
end

-- ****************************************************************
-- ShieldLeft_AddSpellDamage
-- ****************************************************************

-- this adds spell/ranged damage to the database
local function ShieldLeft_AddSpellDamage(unit, spell, dmg)
	if ( not SL.SpellStats[unit] ) then
		SL.SpellStats[unit] = { 
			[spell] = {
				["hits"] = 1, ["dmg"] = dmg, ["med"] = dmg
			}
		};
		verbose(SL_MSG_NEWCRITTER .. unit);
	elseif ( not SL.SpellStats[unit][spell] ) then
		SL.SpellStats[unit][spell] = { 
			["hits"] = 1, ["dmg"] = dmg, ["med"] = dmg
		};
		verbose(SL_MSG_NEWSPELLFOR .. unit .. ": " .. spell);
	else
		SL.SpellStats[unit][spell].hits = SL.SpellStats[unit][spell].hits + 1;
		SL.SpellStats[unit][spell].dmg = SL.SpellStats[unit][spell].dmg + dmg;
		local oldmed = (SL.SpellStats[unit][spell].med or 0);
		SL.SpellStats[unit][spell].med = ceil(SL.SpellStats[unit][spell].dmg / SL.SpellStats[unit][spell].hits);
		if abs(SL.SpellStats[unit][spell].med - oldmed) > 0 then
			verbose(unit .. "'s " .. spell .. ": " .. SL.SpellStats[unit][spell].med);
		end
	end
end

-- ****************************************************************
-- AbsorbShield
-- ****************************************************************

-- this subtracts the damagage the shield has absorbed from the "shield left" counter
local function AbsorbShield(unit, spell)
	if ( not SL_HasShield ) then 
		return; 
	end
	local recognized;
	if ( spell and spell ~= '' ) then
		if ( SL.SpellStats[unit] and SL.SpellStats[unit][spell] ) then
				SL_ShieldLeft = SL_ShieldLeft - SL.SpellStats[unit][spell].med;
			recognized = true;
		end
	else
		if ( SL.MeleeStats[unit] ) then
			SL_ShieldLeft = SL_ShieldLeft - (SL.MeleeStats[unit].med or 0);
			recognized = true;
		end
	end
	if ( SL_ShieldLeft < 0 ) then
		SL_ShieldLeft = 0;
	end
	ShieldLeftText:SetText(SL_MSG_SHIELDLEFT .. SL_ShieldLeft .. "|r");
	ShieldLeftFrameStatusBar:SetValue(SL_ShieldLeft);

	if ( not recognized ) then
		ShieldLeft.recognized = nil;
		ShieldLeftFrameStatusBar:SetStatusBarColor(1, 0, 0, 0.5);
	elseif ( ShieldLeft.recognized ) then
		ShieldLeft.recognized = 1;
		ShieldLeftFrameStatusBar:SetStatusBarColor(0, 0, 1, 0.5);
	end
	return recognized;
end

-- ****************************************************************
-- ShieldLeft_Cast
-- ****************************************************************

-- **** had to change this whole section to get the initial cast of a barrier to work correctly
function ShieldLeft_Cast(playerName, playerClass, Event, Rank)
	if (playerClass == "PRIEST" or playerClass == "WARLOCK" or playerClass == "MAGE") then
		SL_HasShield = true;
		CheckShieldSpells();
		if (Event == SL_SHIELD) then
			SL_ShieldLeft = SL_MaxShield;
			SL_MaxShield_other = SL_MaxShield;
			debug("Casted "..SL_SHIELD.." "..Rank.." on "..playerName);
		elseif (Event == SL_SHIELD_ICE) then
			SL_ShieldLeft = SL_MaxShield_ice;
			SL_MaxShield_other = SL_MaxShield_ice;
			debug("Casted "..SL_SHIELD_ICE.." "..Rank.." on "..playerName);
		end
		ShieldLeftFrameStatusBar:SetMinMaxValues(0,SL_MaxShield_other);
		ShieldLeftFrameStatusBar:SetValue(SL_ShieldLeft);
		ShieldLeftText:SetText(SL_MSG_SHIELDLEFT..SL_ShieldLeft .. "|r");
		ShieldLeft:Show();
	else
		ShieldLeft_UnCast();
	end
end

-- ****************************************************************
-- ShieldLeft_UnCast
-- ****************************************************************

function ShieldLeft_UnCast()
	SL_HasShield = false;  -- **** fixed a typo - false was originally faslse
	SL_ShieldLeft = 0; -- **** Think I fixed a typo here - did say SH_ShieldLeft = 0
	ShieldLeft:Hide();
end

-- ****************************************************************
-- ShieldLeft_OnEvent
-- ****************************************************************

function ShieldLeft_OnEvent(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	local _,playerclass = UnitClass("player");
	playerName = UnitName('player');
		
	-- **** added this if statement to account for a rare "nil" error when debug is turned on
	-- **** also should fix the last error reported on the incgamers site comments by lothaer
	if sourceName == "nil" then
		if sourceMob == "nil" then
			sourceMob = "unknown"
		end
		sourceName = sourceMob			
	else
		sourceMob = sourceName
	end
	
	if ( event == SL_SHIELD or event == SL_SHIELD_ICE ) then
		-- Args are different for event UNIT_SPELLCAST_SUCCEEDED (arg1-name of caster, arg2-spellname, arg3-spellrank) 
		destName = timestamp;
		rank = sourceGUID; 
-- **** changed this so it didn't say Power Word: Shield for all spells and added the ice info
-- **** moved this whole sectino to ShieldLeft_Cast function
		if (destName) then 
			ShieldLeft_Cast(playerName, playerclass, event, rank); 
		end
	elseif ( event == "SPELL_AURA_REMOVED" ) then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...)
		-- **** added the or and SL_SHIELD_ICE
		if (destName == UnitName("player") and (spellName == SL_SHIELD or spellName == SL_SHIELD_ICE)) then 
			ShieldLeft_UnCast();
		end
	elseif ( event == "SWING_DAMAGE" ) then
		if destName == UnitName("player") then
			amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...)
			dmg1 = amount;
			dmg2 = absorbed or 0;
			dmg3 = blocked or 0;
			debug("Took "..dmg1.." damage from: "..sourceName.." ("..dmg2.." absorbed / "..dmg3.." blocked) " );
			ShieldLeft_AddDamage(sourceName, dmg1+dmg2+dmg3);
		end
	elseif ( event == "SPELL_DAMAGE" or event == "RANGE_DAMAGE" ) then
		if destName == UnitName("player") then
			spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...)
			dmg1 = amount;
			dmg2 = absorbed or 0;
			debug("Took "..dmg1.." damage from: "..sourceName.." ("..dmg2.." absorbed) " );
			ShieldLeft_AddSpellDamage(sourceName, spellName, dmg1+dmg2);
		end
	elseif event == "ENVIRONMENTAL_DAMAGE" then
		if destName == UnitName("player") then
			environmentalType, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...)
			dmg1 = amount;
			dmg2 = absorbed or 0;
			if sourceName then
				debug("Took "..dmg1.." environmental damage from: "..sourceName.." ("..dmg2.." absorbed)" );
				ShieldLeft_AddDamage(sourceName, dmg1+dmg2);
			end
		end
	elseif event == "SPELL_MISSED" or event == "RANGE_MISSED" or event == "SWING_MISSED" then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...)
		if ( destName == UnitName("player") ) then
			spellName = spellName or '';
			AbsorbShield(sourceName, spellName)
		end
	elseif (event == "PLAYER_DEAD") then
		ShieldLeft_UnCast();
	end
end
