﻿local ccdebuffs = {
	[(GetSpellInfo(18647))] = true, -- "Banish"
	[(GetSpellInfo(13323))] = true, -- "Polymorph"
	[(GetSpellInfo(11297))] = true, -- "Sap"
	[(GetSpellInfo(6358))]  = true, -- "Seduction"
	[(GetSpellInfo(18658))] = true, -- "Hibernate"
	[(GetSpellInfo(10955))] = true, -- "Shackle Undead"
	[(GetSpellInfo(14309))] = true, -- "Freezing Trap Effect"
}

Sheppard = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
Sheppard:RegisterDB("SheppardDB")

function Sheppard:OnEnable()
    self:RegisterEvent("SpecialEvents_UnitDebuffGained")
    self:RegisterChatCommand({"/shep", "/sheppard"}, {
        type = "group",
        args = {
        },
    })
end

function Sheppard:OSD(msg)
    if (MikSBT) then
        MikSBT.DisplayMessage(msg, MikSBT.DISPLAYTYPE_NOTIFICATION, true, 1.0*255, 0.1*255, 0.1*255)
    elseif (SCT and SCT_MSG_FRAME) then
        SCT_MSG_FRAME:AddMessage(msg, 1.0, 0.1, 0.1, 1)
    elseif (CombatText_AddMessage) then
        CombatText_AddMessage(msg, COMBAT_TEXT_SCROLL_FUNCTION, 1.0, 0.1, 0.1, "sticky", nil)
    else
        UIErrorsFrame:AddMessage(msg, 1.0, 0.1, 0.1, 1.0, UIERRORS_HOLD_TIME)
    end
end

function Sheppard:SpecialEvents_UnitDebuffGained(targ, debuff)
    if (targ == "target" and ccdebuffs[debuff]) then
        self:OSD("Your target is crowd-controlled (" .. debuff .. ")")
        PlaySoundFile("Interface\\AddOns\\Sheppard\\wreee.wav")
    end
end
