﻿--[[
Name: Babble-Spell-2.2
Revision: $Rev: 69946 $
Author(s): ckknight (ckknight@gmail.com)
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Spell-2.2
SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Spell-2.2
Description: A library to provide localizations for spells.
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Spell-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 69946 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleSpell = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleSpell:EnableDebugging()

BabbleSpell:RegisterTranslations("enUS", function()
	return {
		["Abolish Disease"] = true,
		["Abolish Poison"] = true,
		["Abolish Poison Effect"] = true,
		["Activate MG Turret"] = true,
		["Adrenaline Rush"] = true,
		["Aftermath"] = true,
		["Aggression"] = true,
		["Agonizing Flames"] = true,
		["Aimed Shot"] = true,
		["Alchemy"] = true,
		["Ambush"] = true,
		["Amplify Curse"] = true,
		["Amplify Magic"] = true,
		["Ancestral Fortitude"] = true,
		["Ancestral Healing"] = true,
		["Ancestral Knowledge"] = true,
		["Ancestral Spirit"] = true,
		["Ancient Hysteria"] = true,
		["Anesthetic Poison"] = true,
		["Anger Management"] = true,
		["Anguish"] = true,
		["Anticipation"] = true,
		["Aquatic Form"] = true,
		["Arcane Blast"] = true,
		["Arcane Brilliance"] = true,
		["Arcane Concentration"] = true,
		["Arcane Energy"] = true,
		["Arcane Explosion"] = true,
		["Arcane Focus"] = true,
		["Arcane Fortitude"] = true,
		["Arcane Impact"] = true,
		["Arcane Instability"] = true,
		["Arcane Intellect"] = true,
		["Arcane Meditation"] = true,
		["Arcane Mind"] = true,
		["Arcane Missiles"] = true,
		["Arcane Potency"] = true,
		["Arcane Power"] = true,
		["Arcane Resistance"] = true,
		["Arcane Shot"] = true,
		["Arcane Shroud"] = true,
		["Arcane Subtlety"] = true,
		["Arcane Torrent"] = true,
		["Arcane Weakness"] = true,
		["Arctic Reach"] = true,
		["Arctic Winds"] = true,
		["Armor of Faith"] = true,
		["Armorsmith"] = true,
		["Aspect of the Beast"] = true,
		["Aspect of the Cheetah"] = true,
		["Aspect of the Hawk"] = true,
		["Aspect of the Monkey"] = true,
		["Aspect of the Pack"] = true,
		["Aspect of the Viper"] = true,
		["Aspect of the Wild"] = true,
		["Astral Recall"] = true,
		["Attack"] = true,
		["Attacking"] = true,
		["Auto Shot"] = true,
		["Avenger's Shield"] = true,
		["Avenging Wrath"] = true,
		["Avoidance"] = true,
		["Axe Specialization"] = true,
		["Backlash"] = true,
		["Backstab"] = true,
		["Badge of the Swarmguard"] = true,
		["Balance of Power"] = true,
		["Bane"] = true,
		["Banish"] = true,
		["Banshee Curse"] = true,
		["Barkskin"] = true,
		["Barrage"] = true,
		["Bash"] = true,
		["Basic Campfire"] = true,
		["Battle Rush"] = true,
		["Battle Shout"] = true,
		["Battle Stance"] = true,
		["Battle Stance Passive"] = true,
		["Bear Form"] = true,
		["Beast Lore"] = true,
		["Beast Slaying"] = true,
		["Beast Training"] = true,
		["Benediction"] = true,
		["Berserker Rage"] = true,
		["Berserker Stance"] = true,
		["Berserker Stance Passive"] = true,
		["Berserking"] = true,
		["Bestial Discipline"] = true,
		["Bestial Swiftness"] = true,
		["Bestial Wrath"] = true,
		["Binding Heal"] = true,
		["Bite"] = true,
		["Black Arrow"] = true,
		["Blackout"] = true,
		["Blacksmithing"] = true,
		["Blade Flurry"] = true,
		["Blade Turning"] = true,
		["Blade Twisting"] = true,
		["Blast Wave"] = true,
		["Blazing Speed"] = true,
		["Blessed Recovery"] = true,
		["Blessed Resilience"] = true,
		["Blessing of Auchindoun"] = true,
		["Blessing of Freedom"] = true,
		["Blessing of Kings"] = true,
		["Blessing of Light"] = true,
		["Blessing of Might"] = true,
		["Blessing of Protection"] = true,
		["Blessing of Sacrifice"] = true,
		["Blessing of Salvation"] = true,
		["Blessing of Sanctuary"] = true,
		["Blessing of Wisdom"] = true,
		["Blind"] = true,
		["Blinding Powder"] = true,
		["Blink"] = true,
		["Blizzard"] = true,
		["Block"] = true,
		["Blood Craze"] = true,
		["Blood Frenzy"] = true,
		["Blood Fury"] = true,
		["Blood Pact"] = true,
		["Bloodboil"] = true,
		["Bloodlust"] = true,
		["Bloodrage"] = true,
		["Bloodthirst"] = true,
		["Boar Charge"] = true,
		["Booming Voice"] = true,
		["Bow Specialization"] = true,
		["Bows"] = true,
		["Bright Campfire"] = true,
		["Brittle Armor"] = true,
		["Brutal Impact"] = true,
		["Burning Adrenaline"] = true,
		["Burning Soul"] = true,
		["Burning Wish"] = true,
		["Call Pet"] = true,
		["Call of Flame"] = true,
		["Call of Thunder"] = true,
		["Call of the Nexus"] = true,
		["Camouflage"] = true,
		["Cannibalize"] = true,
		["Cat Form"] = true,
		["Cataclysm"] = true,
		["Celestial Focus"] = true,
		["Chain Heal"] = true,
		["Chain Lightning"] = true,
		["Challenging Roar"] = true,
		["Challenging Shout"] = true,
		["Charge"] = true,
		["Charge Rage Bonus Effect"] = true,
		["Charge Stun"] = true,
		["Chastise"] = true,
		["Cheap Shot"] = true,
		["Chilled"] = true,
		["Circle of Healing"] = true,
		["Claw"] = true,
		["Cleanse"] = true,
		["Clearcasting"] = true,
		["Cleave"] = true,
		["Clever Traps"] = true,
		["Cloak of Shadows"] = true,
		["Closing"] = true,
		["Cloth"] = true,
		["Coarse Sharpening Stone"] = true,
		["Cobra Reflexes"] = true,
		["Cold Blood"] = true,
		["Cold Snap"] = true,
		["Combat Endurance"] = true,
		["Combustion"] = true,
		["Command"] = true,
		["Commanding Presence"] = true,
		["Commanding Shout"] = true,
		["Concentration Aura"] = true,
		["Concussion"] = true,
		["Concussion Blow"] = true,
		["Concussive Barrage"] = true,
		["Concussive Shot"] = true,
		["Cone of Cold"] = true,
		["Conflagrate"] = true,
		["Conflagration"] = true,
		["Conjure Food"] = true,
		["Conjure Mana Agate"] = true,
		["Conjure Mana Citrine"] = true,
		["Conjure Mana Emerald"] = true,
		["Conjure Mana Jade"] = true,
		["Conjure Mana Ruby"] = true,
		["Conjure Water"] = true,
		["Consecration"] = true,
		["Consume Magic"] = true,
		["Consume Shadows"] = true,
		["Contagion"] = true,
		["Convection"] = true,
		["Conviction"] = true,
		["Cooking"] = true,
		["Corruption"] = true,
		["Counterattack"] = true,
		["Counterspell"] = true,
		["Counterspell - Silenced"] = true,
		["Cower"] = true,
		["Create Firestone"] = true,
		["Create Firestone (Greater)"] = true,
		["Create Firestone (Lesser)"] = true,
		["Create Firestone (Major)"] = true,
		["Create Healthstone"] = true,
		["Create Healthstone (Greater)"] = true,
		["Create Healthstone (Lesser)"] = true,
		["Create Healthstone (Major)"] = true,
		["Create Healthstone (Minor)"] = true,
		["Create Soulstone"] = true,
		["Create Soulstone (Greater)"] = true,
		["Create Soulstone (Lesser)"] = true,
		["Create Soulstone (Major)"] = true,
		["Create Soulstone (Minor)"] = true,
		["Create Spellstone"] = true,
		["Create Spellstone (Greater)"] = true,
		["Create Spellstone (Major)"] = true,
		["Create Spellstone (Master)"] = true,
		["Creeping Paralysis"] = true,
		["Cripple"] = true,
		["Crippling Poison"] = true,
		["Crippling Poison II"] = true,
		["Critical Mass"] = true,
		["Crossbows"] = true,
		["Cruelty"] = true,
		["Crusade"] = true,
		["Crusader Aura"] = true,
		["Crusader Strike"] = true,
		["Cultivation"] = true,
		["Cure Disease"] = true,
		["Cure Poison"] = true,
		["Curse of Agony"] = true,
		["Curse of Doom"] = true,
		["Curse of Doom Effect"] = true,
		["Curse of Exhaustion"] = true,
		["Curse of Idiocy"] = true,
		["Curse of Recklessness"] = true,
		["Curse of Shadow"] = true,
		["Curse of Tongues"] = true,
		["Curse of Weakness"] = true,
		["Curse of the Elements"] = true,
		["Cyclone"] = true,
		["Dagger Specialization"] = true,
		["Daggers"] = true,
		["Dampen Magic"] = true,
		["Dark Barrage"] = true,
		["Dark Pact"] = true,
		["Darkness"] = true,
		["Dash"] = true,
		["Dawnstone Crab"] = true,
		["Dazed"] = true,
		["Deadly Interrupt Effect"] = true,
		["Deadly Poison"] = true,
		["Deadly Poison II"] = true,
		["Deadly Poison III"] = true,
		["Deadly Poison IV"] = true,
		["Deadly Poison V"] = true,
		["Deadly Poison VI"] = true,
		["Deadly Poison VII"] = true,
		["Deadly Throw"] = true,
		["Death Coil"] = true,
		["Death Wish"] = true,
		["Deep Wound"] = true,
		["Deep Wounds"] = true,
		["Defense"] = true,
		["Defensive Stance"] = true,
		["Defensive Stance Passive"] = true,
		["Defiance"] = true,
		["Deflection"] = true,
		["Delusions of Jin'do"] = true,
		["Demon Armor"] = true,
		["Demon Skin"] = true,
		["Demonic Aegis"] = true,
		["Demonic Embrace"] = true,
		["Demonic Frenzy"] = true,
		["Demonic Knowledge"] = true,
		["Demonic Resilience"] = true,
		["Demonic Sacrifice"] = true,
		["Demonic Tactics"] = true,
		["Demoralizing Roar"] = true,
		["Demoralizing Shout"] = true,
		["Dense Sharpening Stone"] = true,
		["Desperate Prayer"] = true,
		["Destructive Reach"] = true,
		["Detect"] = true,
		["Detect Greater Invisibility"] = true,
		["Detect Invisibility"] = true,
		["Detect Lesser Invisibility"] = true,
		["Detect Magic"] = true,
		["Detect Traps"] = true,
		["Deterrence"] = true,
		["Devastate"] = true,
		["Devastation"] = true,
		["Devotion Aura"] = true,
		["Devour Magic"] = true,
		["Devour Magic Effect"] = true,
		["Devouring Plague"] = true,
		["Diplomacy"] = true,
		["Dire Bear Form"] = true,
		["Dirty Deeds"] = true,
		["Dirty Tricks"] = true,
		["Disarm"] = true,
		["Disarm Trap"] = true,
		["Disease Cleansing Totem"] = true,
		["Disenchant"] = true,
		["Disengage"] = true,
		["Dismiss Pet"] = true,
		["Dispel Magic"] = true,
		["Distract"] = true,
		["Distracting Shot"] = true,
		["Dive"] = true,
		["Divine Favor"] = true,
		["Divine Fury"] = true,
		["Divine Illumination"] = true,
		["Divine Intellect"] = true,
		["Divine Intervention"] = true,
		["Divine Protection"] = true,
		["Divine Shield"] = true,
		["Divine Spirit"] = true,
		["Divine Strength"] = true,
		["Divine Wrath"] = true,
		["Dodge"] = true,
		["Doomfire"] = true,
		["Dragon's Breath"] = true,
		["Dragonscale Leatherworking"] = true,
		["Drain Life"] = true,
		["Drain Mana"] = true,
		["Drain Soul"] = true,
		["Dreamless Sleep"] = true,
		["Drink"] = true,
		["Dual Wield"] = true,
		["Dual Wield Specialization"] = true,
		["Duel"] = true,
		["Dust Cloud"] = true,
		["Eagle Eye"] = true,
		["Earth Elemental Totem"] = true,
		["Earth Shield"] = true,
		["Earth Shock"] = true,
		["Earthbind"] = true,
		["Earthbind Totem"] = true,
		["Earthstrike"] = true,
		["Efficiency"] = true,
		["Elemental Devastation"] = true,
		["Elemental Focus"] = true,
		["Elemental Fury"] = true,
		["Elemental Leatherworking"] = true,
		["Elemental Mastery"] = true,
		["Elemental Precision"] = true,
		["Elemental Sharpening Stone"] = true,
		["Elemental Weapons"] = true,
		["Elune's Grace"] = true,
		["Elusiveness"] = true,
		["Emberstorm"] = true,
		["Empowered Arcane Missiles"] = true,
		["Empowered Corruption"] = true,
		["Empowered Fireball"] = true,
		["Empowered Frostbolt"] = true,
		["Empowered Healing"] = true,
		["Empowered Rejuvenation"] = true,
		["Empowered Touch"] = true,
		["Enamored Water Spirit"] = true,
		["Enchanting"] = true,
		["Endurance"] = true,
		["Endurance Training"] = true,
		["Engineering"] = true,
		["Engineering Specialization"] = true,
		["Enrage"] = true,
		["Enriched Manna Biscuit"] = true,
		["Enslave Demon"] = true,
		["Entangling Roots"] = true,
		["Entrapment"] = true,
		["Envenom"] = true,
		["Escape Artist"] = true,
		["Evasion"] = true,
		["Eviscerate"] = true,
		["Evocation"] = true,
		["Execute"] = true,
		["Exorcism"] = true,
		["Expansive Mind"] = true,
		["Explosive Trap"] = true,
		["Explosive Trap Effect"] = true,
		["Expose Armor"] = true,
		["Expose Weakness"] = true,
		["Extract Gas"] = true,
		["Eye for an Eye"] = true,
		["Eye of Kilrogg"] = true,
		["Eye of the Storm"] = true,
		["Eyes of the Beast"] = true,
		["Fade"] = true,
		["Faerie Fire"] = true,
		["Faerie Fire (Feral)"] = true,
		["Fanaticism"] = true,
		["Far Sight"] = true,
		["Fatal Attraction"] = true,
		["Fear"] = true,
		["Fear Ward"] = true,
		["Feed Pet"] = true,
		["Feed Pet Effect"] = true,
		["Feedback"] = true,
		["Feign Death"] = true,
		["Feint"] = true,
		["Fel Armor"] = true,
		["Fel Concentration"] = true,
		["Fel Domination"] = true,
		["Fel Energy"] = true,
		["Fel Intellect"] = true,
		["Fel Rage"] = true,
		["Fel Stamina"] = true,
		["Felfire"] = true,
		["Feline Grace"] = true,
		["Feral Aggression"] = true,
		["Feral Charge"] = true,
		["Feral Instinct"] = true,
		["Feral Swiftness"] = true,
		["Ferocious Bite"] = true,
		["Ferocious Inspiration"] = true,
		["Ferocity"] = true,
		["Fetish"] = true,
		["Find Fish"] = true,
		["Find Herbs"] = true,
		["Find Minerals"] = true,
		["Find Treasure"] = true,
		["Find Weakness"] = true,
		["Fire Blast"] = true,
		["Fire Breath"] = true,
		["Fire Elemental Totem"] = true,
		["Fire Nova Totem"] = true,
		["Fire Power"] = true,
		["Fire Resistance"] = true,
		["Fire Resistance Aura"] = true,
		["Fire Resistance Totem"] = true,
		["Fire Shield"] = true,
		["Fire Vulnerability"] = true,
		["Fire Ward"] = true,
		["Fire Weakness"] = true,
		["Fireball"] = true,
		["Firebolt"] = true,
		["First Aid"] = true,
		["Fishing"] = true,
		["Fishing Poles"] = true,
		["Fist Weapon Specialization"] = true,
		["Fist Weapons"] = true,
		["Flame Shock"] = true,
		["Flame Throwing"] = true,
		["Flamestrike"] = true,
		["Flamethrower"] = true,
		["Flametongue Attack"] = true,
		["Flametongue Totem"] = true,
		["Flametongue Weapon"] = true,
		["Flare"] = true,
		["Flash Heal"] = true,
		["Flash of Light"] = true,
		["Flight Form"] = true,
		["Flurry"] = true,
		["Focused Casting"] = true,
		["Focused Mind"] = true,
		["Focused Power"] = true,
		["Focused Rage"] = true,
		["Focused Starlight"] = true,
		["Food"] = true,
		["Forbearance"] = true,
		["Force of Nature"] = true,
		["Force of Will"] = true,
		["Freezing Trap"] = true,
		["Freezing Trap Effect"] = true,
		["Frenzied Regeneration"] = true,
		["Frenzy"] = true,
		["Frenzy Effect"] = true,
		["Frost Armor"] = true,
		["Frost Blast"] = true,
		["Frost Channeling"] = true,
		["Frost Nova"] = true,
		["Frost Resistance"] = true,
		["Frost Resistance Aura"] = true,
		["Frost Resistance Totem"] = true,
		["Frost Shock"] = true,
		["Frost Trap"] = true,
		["Frost Trap Aura"] = true,
		["Frost Ward"] = true,
		["Frost Warding"] = true,
		["Frost Weakness"] = true,
		["Frostbite"] = true,
		["Frostbolt"] = true,
		["Frostbrand Attack"] = true,
		["Frostbrand Weapon"] = true,
		["Frozen Core"] = true,
		["Furious Howl"] = true,
		["Furor"] = true,
		["Fury of the Crashing Waves"] = true,
		["Garrote"] = true,
		["Garrote - Silence"] = true,
		["Ghost Wolf"] = true,
		["Ghostly Strike"] = true,
		["Gift of Life"] = true,
		["Gift of Nature"] = true,
		["Gift of the Naaru"] = true,
		["Gift of the Wild"] = true,
		["Gouge"] = true,
		["Grace of Air"] = true,
		["Grace of Air Totem"] = true,
		["Great Stamina"] = true,
		["Greater Blessing of Kings"] = true,
		["Greater Blessing of Light"] = true,
		["Greater Blessing of Might"] = true,
		["Greater Blessing of Salvation"] = true,
		["Greater Blessing of Sanctuary"] = true,
		["Greater Blessing of Wisdom"] = true,
		["Greater Dreamless Sleep"] = true,
		["Greater Heal"] = true,
		["Grievous Throw"] = true,
		["Grim Reach"] = true,
		["Grounding Totem"] = true,
		["Grounding Totem Effect"] = true,
		["Grovel"] = true,
		["Growl"] = true,
		["Guardian's Favor"] = true,
		["Gun Specialization"] = true,
		["Guns"] = true,
		["Hammer of Justice"] = true,
		["Hammer of Wrath"] = true,
		["Hamstring"] = true,
		["Harass"] = true,
		["Hardiness"] = true,
		["Haste"] = true,
		["Hawk Eye"] = true,
		["Heal"] = true,
		["Healing Focus"] = true,
		["Healing Light"] = true,
		["Healing Stream"] = true,
		["Healing Stream Totem"] = true,
		["Healing Touch"] = true,
		["Healing Wave"] = true,
		["Healing Way"] = true,
		["Health Funnel"] = true,
		["Heart of the Wild"] = true,
		["Heavy Sharpening Stone"] = true,
		["Hellfire"] = true,
		["Hellfire Effect"] = true,
		["Hellfire Superiority"] = true,
		["Hemorrhage"] = true,
		["Herb Gathering"] = true,
		["Herbalism"] = true,
		["Heroic Strike"] = true,
		["Heroism"] = true,
		["Hex of Weakness"] = true,
		["Hibernate"] = true,
		["Holy Fire"] = true,
		["Holy Light"] = true,
		["Holy Nova"] = true,
		["Holy Power"] = true,
		["Holy Reach"] = true,
		["Holy Shield"] = true,
		["Holy Shock"] = true,
		["Holy Specialization"] = true,
		["Holy Vengeance"] = true,
		["Holy Wrath"] = true,
		["Honorless Target"] = true,
		["Horse Riding"] = true,
		["Howl of Terror"] = true,
		["Humanoid Slaying"] = true,
		["Hunter's Mark"] = true,
		["Hurricane"] = true,
		["Hypothermia"] = true,
		["Ice Armor"] = true,
		["Ice Barrier"] = true,
		["Ice Block"] = true,
		["Ice Floes"] = true,
		["Ice Lance"] = true,
		["Ice Shards"] = true,
		["Icy Veins"] = true,
		["Ignite"] = true,
		["Ignite Mana"] = true,
		["Illumination"] = true,
		["Immolate"] = true,
		["Immolation Trap"] = true,
		["Immolation Trap Effect"] = true,
		["Impact"] = true,
		["Impale"] = true,
		["Impaling Spine"] = true,
		["Improved Ambush"] = true,
		["Improved Arcane Missiles"] = true,
		["Improved Arcane Shot"] = true,
		["Improved Aspect of the Hawk"] = true,
		["Improved Aspect of the Monkey"] = true,
		["Improved Backstab"] = true,
		["Improved Barrage"] = true,
		["Improved Berserker Rage"] = true,
		["Improved Blessing of Might"] = true,
		["Improved Blessing of Wisdom"] = true,
		["Improved Blink"] = true,
		["Improved Blizzard"] = true,
		["Improved Bloodrage"] = true,
		["Improved Chain Heal"] = true,
		["Improved Chain Lightning"] = true,
		["Improved Challenging Shout"] = true,
		["Improved Charge"] = true,
		["Improved Cleave"] = true,
		["Improved Concentration Aura"] = true,
		["Improved Concussive Shot"] = true,
		["Improved Cone of Cold"] = true,
		["Improved Corruption"] = true,
		["Improved Counterspell"] = true,
		["Improved Curse of Agony"] = true,
		["Improved Curse of Weakness"] = true,
		["Improved Demoralizing Shout"] = true,
		["Improved Devotion Aura"] = true,
		["Improved Disarm"] = true,
		["Improved Drain Life"] = true,
		["Improved Drain Soul"] = true,
		["Improved Enrage"] = true,
		["Improved Enslave Demon"] = true,
		["Improved Eviscerate"] = true,
		["Improved Execute"] = true,
		["Improved Expose Armor"] = true,
		["Improved Eyes of the Beast"] = true,
		["Improved Fade"] = true,
		["Improved Feign Death"] = true,
		["Improved Fire Blast"] = true,
		["Improved Fire Totems"] = true,
		["Improved Fire Ward"] = true,
		["Improved Fireball"] = true,
		["Improved Firebolt"] = true,
		["Improved Flamestrike"] = true,
		["Improved Flash of Light"] = true,
		["Improved Frost Nova"] = true,
		["Improved Frostbolt"] = true,
		["Improved Ghost Wolf"] = true,
		["Improved Gouge"] = true,
		["Improved Hammer of Justice"] = true,
		["Improved Hamstring"] = true,
		["Improved Healing"] = true,
		["Improved Healing Touch"] = true,
		["Improved Healing Wave"] = true,
		["Improved Health Funnel"] = true,
		["Improved Healthstone"] = true,
		["Improved Heroic Strike"] = true,
		["Improved Holy Shield"] = true,
		["Improved Howl of Terror"] = true,
		["Improved Hunter's Mark"] = true,
		["Improved Immolate"] = true,
		["Improved Imp"] = true,
		["Improved Inner Fire"] = true,
		["Improved Intercept"] = true,
		["Improved Intimidating Shout"] = true,
		["Improved Judgement"] = true,
		["Improved Kick"] = true,
		["Improved Kidney Shot"] = true,
		["Improved Lash of Pain"] = true,
		["Improved Lay on Hands"] = true,
		["Improved Leader of the Pack"] = true,
		["Improved Life Tap"] = true,
		["Improved Lightning Bolt"] = true,
		["Improved Lightning Shield"] = true,
		["Improved Magma Totem"] = true,
		["Improved Mana Burn"] = true,
		["Improved Mana Shield"] = true,
		["Improved Mana Spring Totem"] = true,
		["Improved Mark of the Wild"] = true,
		["Improved Mend Pet"] = true,
		["Improved Mind Blast"] = true,
		["Improved Moonfire"] = true,
		["Improved Mortal Strike"] = true,
		["Improved Nature's Grasp"] = true,
		["Improved Overpower"] = true,
		["Improved Power Word: Fortitude"] = true,
		["Improved Power Word: Shield"] = true,
		["Improved Prayer of Healing"] = true,
		["Improved Psychic Scream"] = true,
		["Improved Regrowth"] = true,
		["Improved Reincarnation"] = true,
		["Improved Rejuvenation"] = true,
		["Improved Rend"] = true,
		["Improved Renew"] = true,
		["Improved Retribution Aura"] = true,
		["Improved Revenge"] = true,
		["Improved Revive Pet"] = true,
		["Improved Righteous Fury"] = true,
		["Improved Rupture"] = true,
		["Improved Scorch"] = true,
		["Improved Scorpid Sting"] = true,
		["Improved Seal of Righteousness"] = true,
		["Improved Seal of the Crusader"] = true,
		["Improved Searing Pain"] = true,
		["Improved Serpent Sting"] = true,
		["Improved Shadow Bolt"] = true,
		["Improved Shadow Word: Pain"] = true,
		["Improved Shield Bash"] = true,
		["Improved Shield Block"] = true,
		["Improved Shield Wall"] = true,
		["Improved Sinister Strike"] = true,
		["Improved Slam"] = true,
		["Improved Slice and Dice"] = true,
		["Improved Sprint"] = true,
		["Improved Stings"] = true,
		["Improved Succubus"] = true,
		["Improved Sunder Armor"] = true,
		["Improved Taunt"] = true,
		["Improved Thunder Clap"] = true,
		["Improved Tranquility"] = true,
		["Improved Vampiric Embrace"] = true,
		["Improved Vanish"] = true,
		["Improved Voidwalker"] = true,
		["Improved Weapon Totems"] = true,
		["Improved Whirlwind"] = true,
		["Improved Wing Clip"] = true,
		["Incinerate"] = true,
		["Incineration"] = true,
		["Inferno"] = true,
		["Initiative"] = true,
		["Inner Fire"] = true,
		["Inner Focus"] = true,
		["Innervate"] = true,
		["Insect Swarm"] = true,
		["Insidious Whisper"] = true,
		["Insignifigance"] = true,
		["Inspiration"] = true,
		["Instant Poison"] = true,
		["Instant Poison II"] = true,
		["Instant Poison III"] = true,
		["Instant Poison IV"] = true,
		["Instant Poison V"] = true,
		["Instant Poison VI"] = true,
		["Instant Poison VII"] = true,
		["Intensity"] = true,
		["Intercept"] = true,
		["Intercept Stun"] = true,
		["Intervene"] = true,
		["Intimidating Shout"] = true,
		["Intimidation"] = true,
		["Invisibility"] = true,
		["Iron Will"] = true,
		["Jewelcrafting"] = true,
		["Jom Gabbar"] = true,
		["Judgement"] = true,
		["Judgement of Blood"] = true,
		["Judgement of Command"] = true,
		["Judgement of Justice"] = true,
		["Judgement of Light"] = true,
		["Judgement of Reckoning"] = true,
		["Judgement of Righteousness"] = true,
		["Judgement of Wisdom"] = true,
		["Judgement of the Crusader"] = true,
		["Kick"] = true,
		["Kick - Silenced"] = true,
		["Kidney Shot"] = true,
		["Kill Command"] = true,
		["Killer Instinct"] = true,
		["Kiss of the Spider"] = true,
		["Kodo Riding"] = true,
		["Lacerate"] = true,
		["Lash of Pain"] = true,
		["Last Stand"] = true,
		["Lay on Hands"] = true,
		["Leader of the Pack"] = true,
		["Leather"] = true,
		["Leatherworking"] = true,
		["Lesser Heal"] = true,
		["Lesser Healing Wave"] = true,
		["Lesser Invisibility"] = true,
		["Lethal Shots"] = true,
		["Lethality"] = true,
		["Levitate"] = true,
		["Libram"] = true,
		["Life Tap"] = true,
		["Lifebloom"] = true,
		["Light's Grace"] = true,
		["Lightning Bolt"] = true,
		["Lightning Breath"] = true,
		["Lightning Mastery"] = true,
		["Lightning Reflexes"] = true,
		["Lightning Shield"] = true,
		["Lightning Speed"] = true,
		["Lightwell"] = true,
		["Lightwell Renew"] = true,
		["Lockpicking"] = true,
		["Long Daze"] = true,
		["Lust for Battle"] = true,
		["Mace Specialization"] = true,
		["Mace Stun Effect"] = true,
		["Mage Armor"] = true,
		["Magic Absorption"] = true,
		["Magic Attunement"] = true,
		["Magma Totem"] = true,
		["Mail"] = true,
		["Maim"] = true,
		["Major Dreamless Sleep"] = true,
		["Malediction"] = true,
		["Malice"] = true,
		["Mana Burn"] = true,
		["Mana Feed"] = true,
		["Mana Shield"] = true,
		["Mana Spring"] = true,
		["Mana Spring Totem"] = true,
		["Mana Tap"] = true,
		["Mana Tide"] = true,
		["Mana Tide Totem"] = true,
		["Mangle"] = true,
		["Mangle (Bear)"] = true,
		["Mangle (Cat)"] = true,
		["Mark of the Wild"] = true,
		["Martyrdom"] = true,
		["Mass Dispel"] = true,
		["Master Conjuror"] = true,
		["Master Demonologist"] = true,
		["Master Summoner"] = true,
		["Master Tactician"] = true,
		["Master of Deception"] = true,
		["Master of Elements"] = true,
		["Master of Subtlety"] = true,
		["Maul"] = true,
		["Mechanostrider Piloting"] = true,
		["Meditation"] = true,
		["Melee Specialization"] = true,
		["Melt Armor"] = true,
		["Mend Pet"] = true,
		["Mental Agility"] = true,
		["Mental Strength"] = true,
		["Mind Blast"] = true,
		["Mind Control"] = true,
		["Mind Flay"] = true,
		["Mind Mastery"] = true,
		["Mind Soothe"] = true,
		["Mind Vision"] = true,
		["Mind-numbing Poison"] = true,
		["Mind-numbing Poison II"] = true,
		["Mind-numbing Poison III"] = true,
		["Mining"] = true,
		["Misdirection"] = true,
		["Misery"] = true,
		["Mocking Blow"] = true,
		["Molten Armor"] = true,
		["Molten Fury"] = true,
		["Mongoose Bite"] = true,
		["Monster Slaying"] = true,
		["Moonfire"] = true,
		["Moonfury"] = true,
		["Moonglow"] = true,
		["Moonkin Aura"] = true,
		["Moonkin Form"] = true,
		["Mortal Shots"] = true,
		["Mortal Strike"] = true,
		["Multi-Shot"] = true,
		["Murder"] = true,
		["Mutilate"] = true,
		["Natural Armor"] = true,
		["Natural Perfection"] = true,
		["Natural Shapeshifter"] = true,
		["Naturalist"] = true,
		["Nature Resistance"] = true,
		["Nature Resistance Totem"] = true,
		["Nature Weakness"] = true,
		["Nature's Focus"] = true,
		["Nature's Grace"] = true,
		["Nature's Grasp"] = true,
		["Nature's Guidance"] = true,
		["Nature's Reach"] = true,
		["Nature's Swiftness"] = true,
		["Negative Charge"] = true,
		["Nether Protection"] = true,
		["Netherstorm Flag"] = true,
		["Nightfall"] = true,
		["Nurturing Instinct"] = true,
		["Omen of Clarity"] = true,
		["One-Handed Axes"] = true,
		["One-Handed Maces"] = true,
		["One-Handed Swords"] = true,
		["One-Handed Weapon Specialization"] = true,
		["Opening"] = true,
		["Opening - No Text"] = true,
		["Opportunity"] = true,
		["Overpower"] = true,
		["Pain Suppression"] = true,
		["Panic"] = true,
		["Paranoia"] = true,
		["Parasitic Shadowfiend"] = true,
		["Parry"] = true,
		["Pathfinding"] = true,
		["Perceived Weakness"] = true,
		["Perception"] = true,
		["Permafrost"] = true,
		["Pet Aggression"] = true,
		["Pet Hardiness"] = true,
		["Pet Recovery"] = true,
		["Pet Resistance"] = true,
		["Phase Shift"] = true,
		["Pick Lock"] = true,
		["Pick Pocket"] = true,
		["Piercing Howl"] = true,
		["Piercing Ice"] = true,
		["Plate Mail"] = true,
		["Playing with Fire"] = true,
		["Poison Cleansing Totem"] = true,
		["Poison Spit"] = true,
		["Poisons"] = true,
		["Polearms"] = true,
		["Poleaxe Specialization"] = true,
		["Polymorph"] = true,
		["Polymorph: Pig"] = true,
		["Polymorph: Turtle"] = true,
		["Portal: Darnassus"] = true,
		["Portal: Exodar"] = true,
		["Portal: Ironforge"] = true,
		["Portal: Orgrimmar"] = true,
		["Portal: Shattrath"] = true,
		["Portal: Silvermoon"] = true,
		["Portal: Stormwind"] = true,
		["Portal: Thunder Bluff"] = true,
		["Portal: Undercity"] = true,
		["Positive Charge"] = true,
		["Pounce"] = true,
		["Pounce Bleed"] = true,
		["Power Infusion"] = true,
		["Power Word: Fortitude"] = true,
		["Power Word: Shield"] = true,
		["Prayer of Fortitude"] = true,
		["Prayer of Healing"] = true,
		["Prayer of Mending"] = true,
		["Prayer of Shadow Protection"] = true,
		["Prayer of Spirit"] = true,
		["Precision"] = true,
		["Predatory Instincts"] = true,
		["Predatory Strikes"] = true,
		["Premeditation"] = true,
		["Preparation"] = true,
		["Presence of Mind"] = true,
		["Primal Fury"] = true,
		["Prismatic Cloak"] = true,
		["Prospecting"] = true,
		["Prowl"] = true,
		["Psychic Scream"] = true,
		["Pummel"] = true,
		["Purge"] = true,
		["Purification"] = true,
		["Purify"] = true,
		["Purifying Power"] = true,
		["Pursuit of Justice"] = true,
		["Pyroblast"] = true,
		["Pyroclasm"] = true,
		["Pyromaniac"] = true,
		["Quick Recovery"] = true,
		["Quick Shots"] = true,
		["Quickness"] = true,
		["Rage of the Unraveller"] = true,
		["Rain of Fire"] = true,
		["Rake"] = true,
		["Ram Riding"] = true,
		["Rampage"] = true,
		["Ranged Weapon Specialization"] = true,
		["Rapid Fire"] = true,
		["Rapid Killing"] = true,
		["Raptor Riding"] = true,
		["Raptor Strike"] = true,
		["Ravage"] = true,
		["Readiness"] = true,
		["Rebirth"] = true,
		["Reckless Charge"] = true,
		["Recklessness"] = true,
		["Reckoning"] = true,
		["Redemption"] = true,
		["Redoubt"] = true,
		["Reflection"] = true,
		["Regeneration"] = true,
		["Regrowth"] = true,
		["Reincarnation"] = true,
		["Reinforced Shield"] = true,
		["Rejuvenation"] = true,
		["Relentless Strikes"] = true,
		["Remorseless"] = true,
		["Remorseless Attacks"] = true,
		["Remote Toy"] = true,
		["Remove Curse"] = true,
		["Remove Insignia"] = true,
		["Remove Lesser Curse"] = true,
		["Rend"] = true,
		["Renew"] = true,
		["Repentance"] = true,
		["Restless Strength"] = true,
		["Restorative Totems"] = true,
		["Resurrection"] = true,
		["Retaliation"] = true,
		["Retribution Aura"] = true,
		["Revenge"] = true,
		["Revenge Stun"] = true,
		["Reverberation"] = true,
		["Revive Pet"] = true,
		["Righteous Defense"] = true,
		["Righteous Fury"] = true,
		["Rip"] = true,
		["Riposte"] = true,
		["Ritual of Doom"] = true,
		["Ritual of Doom Effect"] = true,
		["Ritual of Refreshment"] = true,
		["Ritual of Souls"] = true,
		["Ritual of Summoning"] = true,
		["Rockbiter Weapon"] = true,
		["Rough Sharpening Stone"] = true,
		["Ruin"] = true,
		["Rupture"] = true,
		["Ruthlessness"] = true,
		["Sacrifice"] = true,
		["Safe Fall"] = true,
		["Sanctified Crusader"] = true,
		["Sanctified Judgement"] = true,
		["Sanctified Light"] = true,
		["Sanctity Aura"] = true,
		["Sap"] = true,
		["Savage Fury"] = true,
		["Savage Strikes"] = true,
		["Scare Beast"] = true,
		["Scatter Shot"] = true,
		["Scorch"] = true,
		["Scorpid Poison"] = true,
		["Scorpid Sting"] = true,
		["Screech"] = true,
		["Seal Fate"] = true,
		["Seal of Blood"] = true,
		["Seal of Command"] = true,
		["Seal of Justice"] = true,
		["Seal of Light"] = true,
		["Seal of Righteousness"] = true,
		["Seal of Vengeance"] = true,
		["Seal of Wisdom"] = true,
		["Seal of the Crusader"] = true,
		["Searing Light"] = true,
		["Searing Pain"] = true,
		["Searing Totem"] = true,
		["Second Wind"] = true,
		["Seduction"] = true,
		["Seed of Corruption"] = true,
		["Seethe"] = true,
		["Sense Demons"] = true,
		["Sense Undead"] = true,
		["Sentry Totem"] = true,
		["Serpent Sting"] = true,
		["Serrated Blades"] = true,
		["Setup"] = true,
		["Shackle Undead"] = true,
		["Shadow Affinity"] = true,
		["Shadow Bolt"] = true,
		["Shadow Embrace"] = true,
		["Shadow Focus"] = true,
		["Shadow Mastery"] = true,
		["Shadow Power"] = true,
		["Shadow Protection"] = true,
		["Shadow Reach"] = true,
		["Shadow Resistance"] = true,
		["Shadow Resistance Aura"] = true,
		["Shadow Trance"] = true,
		["Shadow Vulnerability"] = true,
		["Shadow Ward"] = true,
		["Shadow Weakness"] = true,
		["Shadow Weaving"] = true,
		["Shadow Word: Death"] = true,
		["Shadow Word: Pain"] = true,
		["Shadow and Flame"] = true,
		["Shadow of Death"] = true,
		["Shadowburn"] = true,
		["Shadowfiend"] = true,
		["Shadowform"] = true,
		["Shadowfury"] = true,
		["Shadowguard"] = true,
		["Shadowmeld"] = true,
		["Shadowmeld Passive"] = true,
		["Shadowstep"] = true,
		["Shamanistic Rage"] = true,
		["Sharpened Claws"] = true,
		["Shatter"] = true,
		["Shear"] = true,
		["Shell Shield"] = true,
		["Shield"] = true,
		["Shield Bash"] = true,
		["Shield Bash - Silenced"] = true,
		["Shield Block"] = true,
		["Shield Slam"] = true,
		["Shield Specialization"] = true,
		["Shield Wall"] = true,
		["Shiv"] = true,
		["Shoot"] = true,
		["Shoot Bow"] = true,
		["Shoot Gun"] = true,
		["Shred"] = true,
		["Shredding Attacks"] = true,
		["Silence"] = true,
		["Silencing Shot"] = true,
		["Silent Resolve"] = true,
		["Silverwing Flag"] = true,
		["Sinister Strike"] = true,
		["Siphon Life"] = true,
		["Skinning"] = true,
		["Slam"] = true,
		["Slayer's Crest"] = true,
		["Sleep"] = true,
		["Slice and Dice"] = true,
		["Slow"] = true,
		["Slow Fall"] = true,
		["Smelting"] = true,
		["Smite"] = true,
		["Snake Trap"] = true,
		["Solid Sharpening Stone"] = true,
		["Sonic Burst"] = true,
		["Soothe Animal"] = true,
		["Soothing Kiss"] = true,
		["Soul Fire"] = true,
		["Soul Leech"] = true,
		["Soul Link"] = true,
		["Soul Siphon"] = true,
		["Soulshatter"] = true,
		["Soulstone Resurrection"] = true,
		["Spell Haste"] = true,
		["Spell Lock"] = true,
		["Spell Power"] = true,
		["Spell Reflection"] = true,
		["Spell Vulnerability"] = true,
		["Spell Warding"] = true,
		["Spellsteal"] = true,
		["Spirit Bond"] = true,
		["Spirit Tap"] = true,
		["Spirit of Redemption"] = true,
		["Spiritual Attunement"] = true,
		["Spiritual Focus"] = true,
		["Spiritual Guidance"] = true,
		["Spiritual Healing"] = true,
		["Spiteful Fury"] = true,
		["Sprint"] = true,
		["Stance Mastery"] = true,
		["Starfire"] = true,
		["Starfire Stun"] = true,
		["Starlight Wrath"] = true,
		["Starshards"] = true,
		["Static Charge"] = true,
		["Staves"] = true,
		["Steady Shot"] = true,
		["Stealth"] = true,
		["Stoneclaw Stun"] = true,
		["Stoneclaw Totem"] = true,
		["Stoneform"] = true,
		["Stoneskin"] = true,
		["Stoneskin Totem"] = true,
		["Stormstrike"] = true,
		["Strength of Earth"] = true,
		["Strength of Earth Totem"] = true,
		["Strength of the Halaani"] = true,
		["Stuck"] = true,
		["Stun"] = true,
		["Subtlety"] = true,
		["Suffering"] = true,
		["Summon Charger"] = true,
		["Summon Dreadsteed"] = true,
		["Summon Felguard"] = true,
		["Summon Felhunter"] = true,
		["Summon Felsteed"] = true,
		["Summon Imp"] = true,
		["Summon Succubus"] = true,
		["Summon Voidwalker"] = true,
		["Summon Warhorse"] = true,
		["Summon Water Elemental"] = true,
		["Sunder Armor"] = true,
		["Suppression"] = true,
		["Surefooted"] = true,
		["Surge of Light"] = true,
		["Surprise Attacks"] = true,
		["Survivalist"] = true,
		["Sweeping Strikes"] = true,
		["Swift Flight Form"] = true,
		["Swiftmend"] = true,
		["Swipe"] = true,
		["Sword Specialization"] = true,
		["Symbol of Hope"] = true,
		["Tactical Mastery"] = true,
		["Tailoring"] = true,
		["Tainted Blood"] = true,
		["Tainted Mind"] = true,
		["Tame Beast"] = true,
		["Taunt"] = true,
		["Teleport: Darnassus"] = true,
		["Teleport: Exodar"] = true,
		["Teleport: Ironforge"] = true,
		["Teleport: Moonglade"] = true,
		["Teleport: Orgrimmar"] = true,
		["Teleport: Shattrath"] = true,
		["Teleport: Silvermoon"] = true,
		["Teleport: Stormwind"] = true,
		["Teleport: Thunder Bluff"] = true,
		["Teleport: Undercity"] = true,
		["Temporal Rift"] = true,
		["The Beast Within"] = true,
		["The Human Spirit"] = true,
		["Thick Hide"] = true,
		["Thorns"] = true,
		["Thrill of the Hunt"] = true,
		["Throw"] = true,
		["Throwing Specialization"] = true,
		["Thrown"] = true,
		["Thunder Clap"] = true,
		["Thunderfury"] = true,
		["Thundering Strikes"] = true,
		["Thunderstomp"] = true,
		["Tidal Focus"] = true,
		["Tidal Mastery"] = true,
		["Tiger Riding"] = true,
		["Tiger's Fury"] = true,
		["Time's Favor"] = true,
		["Torment"] = true,
		["Totem"] = true,
		["Totem of Wrath"] = true,
		["Totemic Call"] = true,
		["Totemic Focus"] = true,
		["Touch of Shadow"] = true,
		["Touch of Weakness"] = true,
		["Toughness"] = true,
		["Traces of Silithyst"] = true,
		["Track Beasts"] = true,
		["Track Demons"] = true,
		["Track Dragonkin"] = true,
		["Track Elementals"] = true,
		["Track Giants"] = true,
		["Track Hidden"] = true,
		["Track Humanoids"] = true,
		["Track Undead"] = true,
		["Tranquil Air"] = true,
		["Tranquil Air Totem"] = true,
		["Tranquil Spirit"] = true,
		["Tranquility"] = true,
		["Tranquilizing Shot"] = true,
		["Trap Mastery"] = true,
		["Travel Form"] = true,
		["Tree of Life"] = true,
		["Tremor Totem"] = true,
		["Tribal Leatherworking"] = true,
		["Trueshot Aura"] = true,
		["Turn Undead"] = true,
		["Twin Spire Blessing"] = true,
		["Two-Handed Axes"] = true,
		["Two-Handed Axes and Maces"] = true,
		["Two-Handed Maces"] = true,
		["Two-Handed Swords"] = true,
		["Two-Handed Weapon Specialization"] = true,
		["Unarmed"] = true,
		["Unbreakable Will"] = true,
		["Unbridled Wrath"] = true,
		["Undead Horsemanship"] = true,
		["Underwater Breathing"] = true,
		["Unending Breath"] = true,
		["Unholy Power"] = true,
		["Unleashed Fury"] = true,
		["Unleashed Rage"] = true,
		["Unstable Affliction"] = true,
		["Unstable Power"] = true,
		["Unyielding Faith"] = true,
		["Upset Tummy"] = true,
		["Vampiric Embrace"] = true,
		["Vampiric Touch"] = true,
		["Vanish"] = true,
		["Vanished"] = true,
		["Vengeance"] = true,
		["Venomous Totem"] = true,
		["Victory Rush"] = true,
		["Vigor"] = true,
		["Vile Beam"] = true,
		["Vile Poisons"] = true,
		["Vindication"] = true,
		["Viper Sting"] = true,
		["Volley"] = true,
		["Wand Specialization"] = true,
		["Wands"] = true,
		["War Stomp"] = true,
		["Warp"] = true,
		["Warsong Flag"] = true,
		["Water Breathing"] = true,
		["Water Shield"] = true,
		["Water Tomb"] = true,
		["Water Walking"] = true,
		["Waterbolt"] = true,
		["Watery Grave"] = true,
		["Weakened Soul"] = true,
		["Weapon Mastery"] = true,
		["Weaponsmith"] = true,
		["Well Fed"] = true,
		["Whirlwind"] = true,
		["Will of the Forsaken"] = true,
		["Windfury"] = true,
		["Windfury Attack"] = true,
		["Windfury Totem"] = true,
		["Windfury Weapon"] = true,
		["Windwall"] = true,
		["Windwall Totem"] = true,
		["Wing Clip"] = true,
		["Winter's Chill"] = true,
		["Wisp Spirit"] = true,
		["Wolf Riding"] = true,
		["Wound Poison"] = true,
		["Wound Poison II"] = true,
		["Wound Poison III"] = true,
		["Wound Poison IV"] = true,
		["Wound Poison V"] = true,
		["Wrath"] = true,
		["Wrath of Air Totem"] = true,
		["Wrath of Cenarius"] = true,
		["Wrath of the Astromancer"] = true,
		["Wyvern Sting"] = true,
	}
end)

BabbleSpell:RegisterTranslations("deDE", function()
	return {
		["Abolish Disease"] = "Krankheit aufheben",
		["Abolish Poison"] = "Vergiftung aufheben",
		["Abolish Poison Effect"] = "Vergiftung aufheben - Effekt",
		["Activate MG Turret"] = "MG-Turm aktivieren",
		["Adrenaline Rush"] = "Adrenalinrausch",
		["Aftermath"] = "Nachwirkung",
		["Aggression"] = "Aggression",
		["Agonizing Flames"] = "Peinigende Flammen",
		["Aimed Shot"] = "Gezielter Schuss",
		["Alchemy"] = "Alchimie",
		["Ambush"] = "Hinterhalt",
		["Amplify Curse"] = "Fluch verstärken",
		["Amplify Magic"] = "Magie verstärken",
		["Ancestral Fortitude"] = "Seelenstärke der Ahnen",
		["Ancestral Healing"] = "Heilung der Ahnen",
		["Ancestral Knowledge"] = "Wissen der Ahnen",
		["Ancestral Spirit"] = "Geist der Ahnen",
		["Ancient Hysteria"] = "Uralte Hysterie",
		["Anesthetic Poison"] = "Beruhigendes Gift",
		["Anger Management"] = "Aggressionskontrolle",
		["Anguish"] = "Seelenpein",
		["Anticipation"] = "Vorahnung",
		["Aquatic Form"] = "Wassergestalt",
		["Arcane Blast"] = "Arkanschlag",
		["Arcane Brilliance"] = "Arkane Brillanz",
		["Arcane Concentration"] = "Arkane Konzentration",
		["Arcane Energy"] = "Arkane Energie",
		["Arcane Explosion"] = "Arkane Explosion",
		["Arcane Focus"] = "Arkaner Fokus",
		["Arcane Fortitude"] = "Arkane Seelenstärke",
		["Arcane Impact"] = "Arkaner Einschlag",
		["Arcane Instability"] = "Arkane Instabilität",
		["Arcane Intellect"] = "Arkane Intelligenz",
		["Arcane Meditation"] = "Arkane Meditation",
		["Arcane Mind"] = "Arkaner Geist",
		["Arcane Missiles"] = "Arkane Geschosse",
		["Arcane Potency"] = "Arkane Kraft",
		["Arcane Power"] = "Arkane Macht",
		["Arcane Resistance"] = "Arkanwiderstand",
		["Arcane Shot"] = "Arkaner Schuss",
		["Arcane Shroud"] = "Arkaner Schleier",
		["Arcane Subtlety"] = "Arkanes Feingefühl",
		["Arcane Torrent"] = "Arkaner Strom",
		["Arcane Weakness"] = "Arkane Verwundbarkeit",
		["Arctic Reach"] = "Arktische Reichweite",
		["Arctic Winds"] = "Arktische Winde",
		["Armor of Faith"] = "Rüstung des Glaubens",
		["Armorsmith"] = "Rüstungsschmied",
		["Aspect of the Beast"] = "Aspekt des Wildtiers",
		["Aspect of the Cheetah"] = "Aspekt des Geparden",
		["Aspect of the Hawk"] = "Aspekt des Falken",
		["Aspect of the Monkey"] = "Aspekt des Affen",
		["Aspect of the Pack"] = "Aspekt des Rudels",
		["Aspect of the Viper"] = "Aspekt der Viper",
		["Aspect of the Wild"] = "Aspekt der Wildnis",
		["Astral Recall"] = "Astraler Rückruf",
		["Attack"] = "Angreifen",
		["Attacking"] = "Angreifen",
		["Auto Shot"] = "Automatischer Schuss",
		["Avenger's Shield"] = "Schild des Rächers",
		["Avenging Wrath"] = "Zornige Vergeltung",
		["Avoidance"] = "Vermeidung",
		["Axe Specialization"] = "Axt-Spezialisierung",
		["Backlash"] = "Heimzahlen",
		["Backstab"] = "Meucheln",
		["Badge of the Swarmguard"] = "Abzeichen der Schwarmwache",
		["Balance of Power"] = "Gleichgewicht der Kräfte",
		["Bane"] = "Dunkle Macht",
		["Banish"] = "Verbannen",
		["Banshee Curse"] = "Bansheefluch",
		["Barkskin"] = "Baumrinde",
		["Barrage"] = "Sperrfeuer",
		["Bash"] = "Hieb",
		["Basic Campfire"] = "Einfaches Lagerfeuer",
		["Battle Rush"] = "Kampfsturm",
		["Battle Shout"] = "Schlachtruf",
		["Battle Stance"] = "Kampfhaltung",
		["Battle Stance Passive"] = "Kampfhaltung Passiv",
		["Bear Form"] = "Bärengestalt",
		["Beast Lore"] = "Wildtierkunde",
		["Beast Slaying"] = "Wildtierschlächter",
		["Beast Training"] = "Wildtierausbildung",
		["Benediction"] = "Segnung",
		["Berserker Rage"] = "Berserkerwut",
		["Berserker Stance"] = "Berserkerhaltung",
		["Berserker Stance Passive"] = "Berserkerhaltung - Passiv",
		["Berserking"] = "Berserker",
		["Bestial Discipline"] = "Wildtierdisziplin",
		["Bestial Swiftness"] = "Erhöhte Tiergeschwindigkeit",
		["Bestial Wrath"] = "Zorn des Wildtiers",
		["Binding Heal"] = "Verbindende Heilung",
		["Bite"] = "Beißen",
		["Black Arrow"] = "Schwarzer Pfeil",
		["Blackout"] = "Blackout",
		["Blacksmithing"] = "Schmiedekunst",
		["Blade Flurry"] = "Klingenwirbel",
		["Blade Turning"] = "Klingendrehen",
		["Blade Twisting"] = "Klingenwendung",
		["Blast Wave"] = "Druckwelle",
		["Blazing Speed"] = "Heiße Sohlen",
		["Blessed Recovery"] = "Gesegnete Erholung",
		["Blessed Resilience"] = "Gesegnete Abhärtung",
		["Blessing of Auchindoun"] = "Segen von Auchindoun",
		["Blessing of Freedom"] = "Segen der Freiheit",
		["Blessing of Kings"] = "Segen der Könige",
		["Blessing of Light"] = "Segen des Lichts",
		["Blessing of Might"] = "Segen der Macht",
		["Blessing of Protection"] = "Segen des Schutzes",
		["Blessing of Sacrifice"] = "Segen der Opferung",
		["Blessing of Salvation"] = "Segen der Rettung",
		["Blessing of Sanctuary"] = "Segen des Refugiums",
		["Blessing of Wisdom"] = "Segen der Weisheit",
		["Blind"] = "Blenden",
		["Blinding Powder"] = "Blendungspulver",
		["Blink"] = "Blinzeln",
		["Blizzard"] = "Blizzard",
		["Block"] = "Blocken",
		["Blood Craze"] = "Blutwahnsinn",
		["Blood Frenzy"] = "Blutraserei",
		["Blood Fury"] = "Kochendes Blut",
		["Blood Pact"] = "Blutpakt",
		["Bloodlust"] = "Kampfrausch",
		["Bloodrage"] = "Blutrausch",
		["Bloodthirst"] = "Blutdurst",
		["Boar Charge"] = "Eber Strumangriff",
		["Booming Voice"] = "Donnernde Stimme",
		["Bow Specialization"] = "Bogenspezialisierung",
		["Bows"] = "Bogen",
		["Bright Campfire"] = "Helles Lagerfeuer",
		["Brittle Armor"] = "Spröde Rüstung",
		["Brutal Impact"] = "Brutaler Hieb",
		["Burning Adrenaline"] = "Brennendes Adrenalin",
		["Burning Soul"] = "Brennende Seele",
		["Burning Wish"] = "Brennender Wunsch",
		["Call Pet"] = "Tier rufen",
		["Call of Flame"] = "Ruf der Flamme",
		["Call of Thunder"] = "Ruf des Donners",
		["Call of the Nexus"] = "Ruf des Nexus",
		["Camouflage"] = "Tarnung",
		["Cannibalize"] = "Kannibalismus",
		["Cat Form"] = "Katzengestalt",
		["Cataclysm"] = "Katastrophe",
		["Celestial Focus"] = "Verbessertes Sternenfeuer",
		["Chain Heal"] = "Kettenheilung",
		["Chain Lightning"] = "Kettenblitzschlag",
		["Challenging Roar"] = "Herausforderndes Gebrüll",
		["Challenging Shout"] = "Herausforderungsruf",
		["Charge"] = "Sturmangriff",
		["Charge Rage Bonus Effect"] = "Wut-Aufladung-Bonus-Effekt",
		["Charge Stun"] = "Sturmangriffsbetäubung",
		["Chastise"] = "Züchtigung",
		["Cheap Shot"] = "Fieser Trick",
		["Chilled"] = "Kälte",
		["Circle of Healing"] = "Kreis der Heilung",
		["Claw"] = "Klaue",
		["Cleanse"] = "Reinigung des Glaubens",
		["Clearcasting"] = "Freizaubern",
		["Cleave"] = "Spalten",
		["Clever Traps"] = "Falleneffizienz",
		["Cloak of Shadows"] = "Mantel der Schatten",
		["Closing"] = "Schließen",
		["Cloth"] = "Stoff",
		["Coarse Sharpening Stone"] = "Grober Wetzstein",
		["Cobra Reflexes"] = "Kobrareflexe",
		["Cold Blood"] = "Kaltblütigkeit",
		["Cold Snap"] = "Kälteeinbruch",
		["Combat Endurance"] = "Durchhaltevermögen des Kämpfers",
		["Combustion"] = "Verbrennung",
		["Command"] = "Befehlsgewalt",
		["Commanding Presence"] = "Verbesserter Schlachtruf",
		["Commanding Shout"] = "Befehlsruf",
		["Concentration Aura"] = "Aura der Konzentration",
		["Concussion"] = "Erschütterung",
		["Concussion Blow"] = "Erschütternder Schlag",
		["Concussive Barrage"] = "Erschütterndes Sperrfeuer",
		["Concussive Shot"] = "Erschütternder Schuss",
		["Cone of Cold"] = "Kältekegel",
		["Conflagrate"] = "Feuersbrunst",
		["Conflagration"] = "Großbrand",
		["Conjure Food"] = "Essen herbeizaubern",
		["Conjure Mana Agate"] = "Manaachat herbeizaubern",
		["Conjure Mana Citrine"] = "Manacitrin herbeizaubern",
		["Conjure Mana Emerald"] = "Manasmaragd herbeizaubern",
		["Conjure Mana Jade"] = "Manajadestein herbeizaubern",
		["Conjure Mana Ruby"] = "Manarubin herbeizaubern",
		["Conjure Water"] = "Wasser herbeizaubern",
		["Consecration"] = "Weihe",
		["Consume Magic"] = "Magie verzehren",
		["Consume Shadows"] = "Schatten verzehren",
		["Contagion"] = "Ansteckung",
		["Convection"] = "Konvektion",
		["Conviction"] = "Überzeugung",
		["Cooking"] = "Kochkunst",
		["Corruption"] = "Verderbnis",
		["Counterattack"] = "Gegenangriff",
		["Counterspell"] = "Gegenzauber",
		["Counterspell - Silenced"] = "Gegenzauber - zum Schweigen gebracht",
		["Cower"] = "Ducken",
		["Create Firestone"] = "Feuerstein herstellen",
		["Create Firestone (Greater)"] = "Feuerstein herstellen (Grösser)",
		["Create Firestone (Lesser)"] = "Feuerstein herstellen (Kleiner)",
		["Create Firestone (Major)"] = "Feuerstein herstellen (Großer)",
		["Create Healthstone"] = "Gesundheitsstein herstellen",
		["Create Healthstone (Greater)"] = "Gesundheitsstein herstellen (Grösser)",
		["Create Healthstone (Lesser)"] = "Gesundheitsstein herstellen (Kleiner)",
		["Create Healthstone (Major)"] = "Gesundheitsstein herstellen (Großer)",
		["Create Healthstone (Minor)"] = "Gesundheitsstein herstellen (Klein)",
		["Create Soulstone"] = "Seelenstein herstellen",
		["Create Soulstone (Greater)"] = "Seelenstein herstellen (Grösser)",
		["Create Soulstone (Lesser)"] = "Seelenstein herstellen (Kleiner)",
		["Create Soulstone (Major)"] = "Seelenstein herstellen (Großer)",
		["Create Soulstone (Minor)"] = "Seelenstein herstellen (Klein)",
		["Create Spellstone"] = "Zauberstein herstellen",
		["Create Spellstone (Greater)"] = "Zauberstein herstellen (Grösser)",
		["Create Spellstone (Major)"] = "Zauberstein herstellen (Großer)",
		["Create Spellstone (Master)"] = "Zauberstein herstellen (meisterlich)",
		["Creeping Paralysis"] = "Schleichende Paralyse",
		["Cripple"] = "Verkrüppeln",
		["Crippling Poison"] = "Verkrüppelndes Gift",
		["Crippling Poison II"] = "Verkrüppelndes Gift II",
		["Critical Mass"] = "Kritische Masse",
		["Crossbows"] = "Armbrüste",
		["Cruelty"] = "Grausamkeit",
		["Crusade"] = "Kreuzzug",
		["Crusader Aura"] = "Aura des Kreuzfahrers",
		["Crusader Strike"] = "Kreuzfahrerstoß",
		["Cultivation"] = "Grüner Daumen",
		["Cure Disease"] = "Krankheit heilen",
		["Cure Poison"] = "Vergiftung heilen",
		["Curse of Agony"] = "Fluch der Pein",
		["Curse of Doom"] = "Fluch der Verdammnis",
		["Curse of Doom Effect"] = "Fluch der Verdammnis'-Effekt",
		["Curse of Exhaustion"] = "Fluch der Erschöpfung",
		["Curse of Idiocy"] = "Fluch der Torheit",
		["Curse of Recklessness"] = "Fluch der Tollkühnheit",
		["Curse of Shadow"] = "Fluch der Schatten",
		["Curse of Tongues"] = "Fluch der Sprachen",
		["Curse of Weakness"] = "Fluch der Schwäche",
		["Curse of the Elements"] = "Fluch der Elemente",
		["Cyclone"] = "Wirbelsturm",
		["Dagger Specialization"] = "Dolch-Spezialisierung",
		["Daggers"] = "Dolche",
		["Dampen Magic"] = "Magie dämpfen",
		["Dark Barrage"] = "Dunkles Sperrfeuer",
		["Dark Pact"] = "Dunkler Pakt",
		["Darkness"] = "Dunkelheit",
		["Dash"] = "Spurt",
		["Dawnstone Crab"] = "Dämmersteinkrebs",
		["Dazed"] = "Benommen",
		["Deadly Interrupt Effect"] = "Tödlicher Unterbrechungseffekt",
		["Deadly Poison"] = "Tödliches Gift",
		["Deadly Poison II"] = "Tödliches Gift II",
		["Deadly Poison III"] = "Tödliches Gift III",
		["Deadly Poison IV"] = "Tödliches Gift IV",
		["Deadly Poison V"] = "Tödliches Gift V",
		["Deadly Poison VI"] = "Tödliches Gift VI",
		["Deadly Poison VII"] = "Tödliches Gift VII",
		["Deadly Throw"] = "Tödlicher Wurf",
		["Death Coil"] = "Todesmantel",
		["Death Wish"] = "Todeswunsch",
		["Deep Wound"] = "Tiefe Wunde",
		["Deep Wounds"] = "Tiefe Wunden",
		["Defense"] = "Verteidigung",
		["Defensive Stance"] = "Verteidigungshaltung",
		["Defensive Stance Passive"] = "Verteidigungshaltung - Passiv",
		["Defiance"] = "Trotz",
		["Deflection"] = "Abwehr",
		["Delusions of Jin'do"] = "Irrbilder von Jin'do",
		["Demon Armor"] = "Dämonenrüstung",
		["Demon Skin"] = "Dämonenhaut",
		["Demonic Aegis"] = "Dämonische Ägide",
		["Demonic Embrace"] = "Dämonische Umarmung",
		["Demonic Frenzy"] = "Dämonische Raserei",
		["Demonic Knowledge"] = "Dämonisches Wissen",
		["Demonic Resilience"] = "Dämonische Seelenstärke",
		["Demonic Sacrifice"] = "Dämonische Opferung",
		["Demonic Tactics"] = "Dämonische Taktiken",
		["Demoralizing Roar"] = "Demoralisierendes Gebrüll",
		["Demoralizing Shout"] = "Demoralisierender Ruf",
		["Dense Sharpening Stone"] = "Verdichteter Wetzstein",
		["Desperate Prayer"] = "Verzweifeltes Gebet",
		["Destructive Reach"] = "Zerstörerische Reichweite",
		["Detect"] = "Entdecken",
		["Detect Greater Invisibility"] = "Große Unsichtbarkeit entdecken",
		["Detect Invisibility"] = "Unsichtbarkeit entdecken",
		["Detect Lesser Invisibility"] = "Geringe Unsichtbarkeit entdecken",
		["Detect Magic"] = "Magie entdecken",
		["Detect Traps"] = "Fallen entdecken",
		["Deterrence"] = "Abschreckung",
		["Devastate"] = "Verwüsten",
		["Devastation"] = "Verwüstung",
		["Devotion Aura"] = "Aura der Hingabe",
		["Devour Magic"] = "Magie verschlingen",
		["Devour Magic Effect"] = "Magie verschlingen' - Effekt",
		["Devouring Plague"] = "Verschlingende Seuche",
		["Diplomacy"] = "Diplomatie",
		["Dire Bear Form"] = "Terrorbärengestalt",
		["Dirty Deeds"] = "Gemeinheiten",
		["Dirty Tricks"] = "Verbesserte Kopfnuss",
		["Disarm"] = "Entwaffnen",
		["Disarm Trap"] = "Falle entschärfen",
		["Disease Cleansing Totem"] = "Totem der Krankheitsreinigung",
		["Disenchant"] = "Entzaubern",
		["Disengage"] = "Rückzug",
		["Dismiss Pet"] = "Tier freigeben",
		["Dispel Magic"] = "Magiebannung",
		["Distract"] = "Ablenken",
		["Distracting Shot"] = "Ablenkender Schuss",
		["Dive"] = "Sturzflug",
		["Divine Favor"] = "Göttliche Gunst",
		["Divine Fury"] = "Göttlicher Furor",
		["Divine Illumination"] = "Göttliche Eingebung",
		["Divine Intellect"] = "Göttliche Weisheit",
		["Divine Intervention"] = "Göttliches Eingreifen",
		["Divine Protection"] = "Göttlicher Schutz",
		["Divine Shield"] = "Gottesschild",
		["Divine Spirit"] = "Göttlicher Wille",
		["Divine Strength"] = "Göttliche Stärke",
		["Divine Wrath"] = "Göttlicher Zorn",
		["Dodge"] = "Ausweichen",
		["Doomfire"] = "Verdammnisfeuer",
		["Dragon's Breath"] = "Drachenodem",
		["Dragonscale Leatherworking"] = "Drachenschuppenlederverarbeitung",
		["Drain Life"] = "Blutsauger",
		["Drain Mana"] = "Mana entziehen",
		["Drain Soul"] = "Seelendieb",
		["Dreamless Sleep"] = "Traumloser Schlaf",
		["Drink"] = "Trinken",
		["Dual Wield"] = "Beidhändigkeit",
		["Dual Wield Specialization"] = "Beidhändigkeits-Spezialisierung",
		["Duel"] = "Duell",
		["Dust Cloud"] = "Staubwolke",
		["Eagle Eye"] = "Adlerauge",
		["Earth Elemental Totem"] = "Totem des Erdelementars",
		["Earth Shield"] = "Erdschild",
		["Earth Shock"] = "Erdschock",
		["Earthbind"] = "Erdbindung",
		["Earthbind Totem"] = "Totem der Erdbindung",
		["Earthstrike"] = "Erdschlag",
		["Efficiency"] = "Effizienz",
		["Elemental Devastation"] = "Elementare Verwüstung",
		["Elemental Focus"] = "Elementarfokus",
		["Elemental Fury"] = "Elementarfuror",
		["Elemental Leatherworking"] = "Elementarlederverarbeitung",
		["Elemental Mastery"] = "Elementarbeherrschung",
		["Elemental Precision"] = "Elementare Präzision",
		["Elemental Sharpening Stone"] = "Elementarwetzstein",
		["Elemental Weapons"] = "Elementarwaffen",
		["Elune's Grace"] = "Elunes Anmut",
		["Elusiveness"] = "Flüchtigkeit",
		["Emberstorm"] = "Glutsturm",
		["Empowered Arcane Missiles"] = "Machtvolle arkane Geschosse",
		["Empowered Corruption"] = "Machtvolle Verderbnis",
		["Empowered Fireball"] = "Machtvoller Feuerball",
		["Empowered Frostbolt"] = "Machtvoller Frostblitz",
		["Empowered Healing"] = "Machtvolle Heilung",
		["Empowered Rejuvenation"] = "Machtvolle Verjüngung",
		["Empowered Touch"] = "Machtvolle Berührung",
		["Enamored Water Spirit"] = "Entzückter Wassergeist",
		["Enchanting"] = "Verzauberkunst",
		["Endurance"] = "Durchhaltevermögen",
		["Endurance Training"] = "Belastbarkeit-Ausbildung",
		["Engineering"] = "Ingenieurskunst",
		["Engineering Specialization"] = "Technologist",
		["Enrage"] = "Wutanfall",
		["Enriched Manna Biscuit"] = "Angereicherter Manakeks",
		["Enslave Demon"] = "Dämonensklave",
		["Entangling Roots"] = "Wucherwurzeln",
		["Entrapment"] = "Einfangen",
		["Envenom"] = "Vergiften",
		["Escape Artist"] = "Entfesselungskünstler",
		["Evasion"] = "Entrinnen",
		["Eviscerate"] = "Ausweiden",
		["Evocation"] = "Hervorrufung",
		["Execute"] = "Hinrichten",
		["Exorcism"] = "Exorzismus",
		["Expansive Mind"] = "Wacher Geist",
		["Explosive Trap"] = "Sprengfalle",
		["Explosive Trap Effect"] = "Sprengfalle'-Effekt",
		["Expose Armor"] = "Rüstung schwächen",
		["Expose Weakness"] = "Schwäche aufdecken",
		["Extract Gas"] = "Gas extrahieren",
		["Eye for an Eye"] = "Auge um Auge",
		["Eye of Kilrogg"] = "Auge von Kilrogg",
		["Eye of the Storm"] = "Auge des Sturms",
		["Eyes of the Beast"] = "Augen des Wildtiers",
		["Fade"] = "Verblassen",
		["Faerie Fire"] = "Feenfeuer",
		["Faerie Fire (Feral)"] = "Feenfeuer (Tiergestalt)",
		["Fanaticism"] = "Fanatismus",
		["Far Sight"] = "Fernsicht",
		["Fatal Attraction"] = "Verhängnisvolle Affäre",
		["Fear"] = "Furcht",
		["Fear Ward"] = "Furchtzauberschutz",
		["Feed Pet"] = "Tier füttern",
		["Feed Pet Effect"] = "Tier füttern Effekt",
		["Feedback"] = "Rückkopplung",
		["Feign Death"] = "Totstellen",
		["Feint"] = "Finte",
		["Fel Armor"] = "Teufelsrüstung",
		["Fel Concentration"] = "Teufelskonzentration",
		["Fel Domination"] = "Teufelsbeherrschung",
		["Fel Energy"] = "Teufelsenergie",
		["Fel Intellect"] = "Teufelsintelligenz",
		["Fel Rage"] = "Teufelswut",
		["Fel Stamina"] = "Teufelsausdauer",
		["Felfire"] = "Teufelsfeuer",
		["Feline Grace"] = "Katzenhafte Anmut",
		["Feral Aggression"] = "Wilde Aggression",
		["Feral Charge"] = "Wilde Attacke",
		["Feral Instinct"] = "Instinkt der Wildnis",
		["Feral Swiftness"] = "Katzenhafte Schnelligkeit",
		["Ferocious Bite"] = "Wilder Biss",
		["Ferocious Inspiration"] = "Wilde Eingebung",
		["Ferocity"] = "Wildheit",
		["Fetish"] = "Fetisch",
		["Find Herbs"] = "Kräutersuche",
		["Find Minerals"] = "Mineraliensuche",
		["Find Treasure"] = "Schatzsucher",
		["Find Weakness"] = "Schwächen aufspüren",
		["Fire Blast"] = "Feuerschlag",
		["Fire Breath"] = "Feueratem",
		["Fire Elemental Totem"] = "Totem des Feuerelementars",
		["Fire Nova Totem"] = "Totem der Feuernova",
		["Fire Power"] = "Feuermacht",
		["Fire Resistance"] = "Feuerwiderstand",
		["Fire Resistance Aura"] = "Aura des Feuerwiderstands",
		["Fire Resistance Totem"] = "Totem des Feuerwiderstands",
		["Fire Shield"] = "Feuerschild",
		["Fire Vulnerability"] = "Feuerverwundbarkeit",
		["Fire Ward"] = "Feuerzauberschutz",
		["Fire Weakness"] = "Feuer Verwundbarkeit",
		["Fireball"] = "Feuerball",
		["Firebolt"] = "Feuerblitz",
		["First Aid"] = "Erste Hilfe",
		["Fishing"] = "Angeln",
		["Fishing Poles"] = "Angel",
		["Fist Weapon Specialization"] = "Faustwaffen-Spezialisierung",
		["Fist Weapons"] = "Faustwaffen",
		["Flame Shock"] = "Flammenschock",
		["Flame Throwing"] = "Flammenwerfen",
		["Flamestrike"] = "Flammenstoß",
		["Flamethrower"] = "Flammenwerfer",
		["Flametongue Attack"] = "Angriff der Flammenzunge",
		["Flametongue Totem"] = "Totem der Flammenzunge",
		["Flametongue Weapon"] = "Waffe der Flammenzunge",
		["Flare"] = "Leuchtfeuer",
		["Flash Heal"] = "Blitzheilung",
		["Flash of Light"] = "Lichtblitz",
		["Flight Form"] = "Fluggestalt",
		["Flurry"] = "Schlaghagel",
		["Focused Casting"] = "Fokussiertes Zauberwirken",
		["Focused Mind"] = "Fokussierte Gedanken",
		["Focused Power"] = "Fokussierte Energie",
		["Focused Rage"] = "Fokussierte Wut",
		["Focused Starlight"] = "Gebündeltes Sternenlicht",
		["Food"] = "Essen",
		["Forbearance"] = "Vorahnung",
		["Force of Nature"] = "Naturgewalt",
		["Force of Will"] = "Macht des Willens",
		["Freezing Trap"] = "Eiskältefalle",
		["Freezing Trap Effect"] = "Eiskältefalle",
		["Frenzied Regeneration"] = "Rasende Regeneration",
		["Frenzy"] = "Raserei",
		["Frenzy Effect"] = "Wilde Eingebung",
		["Frost Armor"] = "Frostrüstung",
		["Frost Blast"] = "Frostschlag",
		["Frost Channeling"] = "Frost-Kanalisierung",
		["Frost Nova"] = "Frostnova",
		["Frost Resistance"] = "Frostwiderstand",
		["Frost Resistance Aura"] = "Aura des Frostwiderstands",
		["Frost Resistance Totem"] = "Totem des Frostwiderstands",
		["Frost Shock"] = "Frostschock",
		["Frost Trap"] = "Frostfalle",
		["Frost Trap Aura"] = "Frostfalle-Aura",
		["Frost Ward"] = "Frostzauberschutz",
		["Frost Warding"] = "Schutz des Frostes",
		["Frost Weakness"] = "Frost Verwundbarkeit",
		["Frostbite"] = "Erfrierung",
		["Frostbolt"] = "Frostblitz",
		["Frostbrand Attack"] = "Frostbrandangriff",
		["Frostbrand Weapon"] = "Waffe des Frostbrands",
		["Frozen Core"] = "Tiefgefroren",
		["Furious Howl"] = "Wutgeheul",
		["Furor"] = "Furor",
		["Fury of the Crashing Waves"] = "Wut der zerschmetternden Wellen",
		["Garrote"] = "Erdrosseln",
		["Garrote - Silence"] = "Erdrossseln - Stille",
		["Ghost Wolf"] = "Geisterwolf",
		["Ghostly Strike"] = "Geisterhafter Stoß",
		["Gift of Life"] = "Geschenk des Lebens",
		["Gift of Nature"] = "Geschenk der Natur",
		["Gift of the Naaru"] = "Gabe der Naaru",
		["Gift of the Wild"] = "Gabe der Wildnis",
		["Gouge"] = "Solarplexus",
		["Grace of Air"] = "Luftgleiche Anmut",
		["Grace of Air Totem"] = "Totem der luftgleichen Anmut",
		["Great Stamina"] = "Große Ausdauer",
		["Greater Blessing of Kings"] = "Großer Segen der Könige",
		["Greater Blessing of Light"] = "Großer Segen des Lichts",
		["Greater Blessing of Might"] = "Großer Segen der Macht",
		["Greater Blessing of Salvation"] = "Großer Segen der Rettung",
		["Greater Blessing of Sanctuary"] = "Großer Segen des Refugiums",
		["Greater Blessing of Wisdom"] = "Großer Segen der Weisheit",
		["Greater Dreamless Sleep"] = "Großer traumloser Schlaf",
		["Greater Heal"] = "Große Heilung",
		["Grievous Throw"] = "Schrecklicher Wurf",
		["Grim Reach"] = "Grimmige Reichweite",
		["Grounding Totem"] = "Totem der Erdung",
		["Grounding Totem Effect"] = "Totem der Erdung Effekt",
		["Grovel"] = "Kriechen",
		["Growl"] = "Knurren",
		["Guardian's Favor"] = "Gunst des Hüters",
		["Gun Specialization"] = "Schusswaffenspezialisierung",
		["Guns"] = "Schusswaffen",
		["Hammer of Justice"] = "Hammer der Gerechtigkeit",
		["Hammer of Wrath"] = "Hammer des Zorns",
		["Hamstring"] = "Kniesehne",
		["Harass"] = "Belästigen",
		["Hardiness"] = "Zähigkeit",
		["Haste"] = "Eile",
		["Hawk Eye"] = "Falkenauge",
		["Heal"] = "Heilen",
		["Healing Focus"] = "Heilfokus",
		["Healing Light"] = "Heilendes Licht",
		["Healing Stream"] = "Heilender Fluss",
		["Healing Stream Totem"] = "Totem des heilenden Flusses",
		["Healing Touch"] = "Heilende Berührung",
		["Healing Wave"] = "Welle der Heilung",
		["Healing Way"] = "Pfad der Heilung",
		["Health Funnel"] = "Lebenslinie",
		["Heart of the Wild"] = "Herz der Wildnis",
		["Heavy Sharpening Stone"] = "Schwerer Wetzstein",
		["Hellfire"] = "Höllenfeuer",
		["Hellfire Effect"] = "Höllenfeuer - Effekt",
		["Hellfire Superiority"] = "Überlegenheit des Höllenfeuers",
		["Hemorrhage"] = "Blutsturz",
		["Herb Gathering"] = "Kräutersammeln",
		["Herbalism"] = "Kräuterkunde",
		["Heroic Strike"] = "Heldenhafter Stoß",
		["Heroism"] = "Heldentum",
		["Hex of Weakness"] = "Verhexung der Schwäche",
		["Hibernate"] = "Winterschlaf",
		["Holy Fire"] = "Heiliges Feuer",
		["Holy Light"] = "Heiliges Licht",
		["Holy Nova"] = "Heilige Nova",
		["Holy Power"] = "Heilige Macht",
		["Holy Reach"] = "Heilige Reichweite",
		["Holy Shield"] = "Heiliger Schild",
		["Holy Shock"] = "Heiliger Schock",
		["Holy Specialization"] = "Macht des Glaubens",
		["Holy Vengeance"] = "Heilige Vergeltung",
		["Holy Wrath"] = "Heiliger Zorn",
		["Honorless Target"] = "Ehrenloses Ziel",
		["Horse Riding"] = "Pferdreiten",
		["Howl of Terror"] = "Schreckgeheul",
		["Humanoid Slaying"] = "Humanoidentöten",
		["Hunter's Mark"] = "Mal des Jägers",
		["Hurricane"] = "Hurrikan",
		["Hypothermia"] = "Hypothermie",
		["Ice Armor"] = "Eisrüstung",
		["Ice Barrier"] = "Eisbarriere",
		["Ice Block"] = "Eisblock",
		["Ice Floes"] = "Eisschollen",
		["Ice Lance"] = "Eislanze",
		["Ice Shards"] = "Eissplitter",
		["Icy Veins"] = "Eisige Adern",
		["Ignite"] = "Entzünden",
		["Ignite Mana"] = "Mana entzünden",
		["Illumination"] = "Illumination",
		["Immolate"] = "Feuerbrand",
		["Immolation Trap"] = "Feuerbrandfalle",
		["Immolation Trap Effect"] = "Feuerbrandfalle",
		["Impact"] = "Einschlag",
		["Impale"] = "Durchbohren",
		["Impaling Spine"] = "Aufspießender Stachel",
		["Improved Ambush"] = "Verbesserter Hinterhalt",
		["Improved Arcane Missiles"] = "Verbesserte arkane Geschosse",
		["Improved Arcane Shot"] = "Verbesserter Arkaner Schuss",
		["Improved Aspect of the Hawk"] = "Verbesserter Aspekt des Falken",
		["Improved Aspect of the Monkey"] = "Verbesserter Aspekt des Affen",
		["Improved Backstab"] = "Verbessertes Meucheln",
		["Improved Barrage"] = "Verbessertes Sperrfeuer",
		["Improved Berserker Rage"] = "Verbesserte Berserkerwut",
		["Improved Blessing of Might"] = "Verbesserter Segen der Macht",
		["Improved Blessing of Wisdom"] = "Verbesserter Segen der Weisheit",
		["Improved Blink"] = "Verbessertes Blinzeln",
		["Improved Blizzard"] = "Verbesserter Blizzard",
		["Improved Bloodrage"] = "Verbesserter Blutrausch",
		["Improved Chain Heal"] = "Verbesserte Kettenheilung",
		["Improved Chain Lightning"] = "Verbesserter Kettenblitzschlag",
		["Improved Challenging Shout"] = "Verbesserter Herausforderungsruf",
		["Improved Charge"] = "Verbesserter Sturmangriff",
		["Improved Cleave"] = "Verbessertes Spalten",
		["Improved Concentration Aura"] = "Verbesserte Aura der Konzentration",
		["Improved Concussive Shot"] = "Verbesserter Erschütternder Schuss",
		["Improved Cone of Cold"] = "Verbesserter Kältekegel",
		["Improved Corruption"] = "Verbesserte Verderbnis",
		["Improved Counterspell"] = "Verbesserter Gegenzauber",
		["Improved Curse of Agony"] = "Verbesserter Fluch der Pein",
		["Improved Curse of Weakness"] = "Verbesserter Fluch der Schwäche",
		["Improved Demoralizing Shout"] = "Verbesserter Demoralisierender Ruf",
		["Improved Devotion Aura"] = "Verbesserte Aura der Hingabe",
		["Improved Disarm"] = "Verbessertes Entwaffnen",
		["Improved Drain Life"] = "Verbesserter Blutsauger",
		["Improved Drain Soul"] = "Verbesserter Seelendieb",
		["Improved Enrage"] = "Verbesserter Wutanfall",
		["Improved Enslave Demon"] = "Verbesserter Dämonensklave",
		["Improved Eviscerate"] = "Verbessertes Ausweiden",
		["Improved Execute"] = "Verbessertes Hinrichten",
		["Improved Expose Armor"] = "Verbessertes Rüstung schwächen",
		["Improved Eyes of the Beast"] = "Verbesserte Augen des Wildtiers",
		["Improved Fade"] = "Verbessertes Verblassen",
		["Improved Feign Death"] = "Verbessertes Totstellen",
		["Improved Fire Blast"] = "Verbesserter Feuerschlag",
		["Improved Fire Totems"] = "Verbesserte Feuertotems",
		["Improved Fire Ward"] = "Verbesserter Feuerzauberschutz",
		["Improved Fireball"] = "Verbesserter Feuerball",
		["Improved Firebolt"] = "Verbesserter Feuerblitz",
		["Improved Flamestrike"] = "Verbesserter Flammenstoß",
		["Improved Flash of Light"] = "Verbesserter Lichtblitz",
		["Improved Frost Nova"] = "Verbesserte Frostnova",
		["Improved Frostbolt"] = "Verbesserter Frostblitz",
		["Improved Ghost Wolf"] = "Verbesserter Geisterwolf",
		["Improved Gouge"] = "Verbesserter Solarplexus",
		["Improved Hammer of Justice"] = "Verbesserter Hammer der Gerechtigkeit",
		["Improved Hamstring"] = "Verbesserte Kniesehne",
		["Improved Healing"] = "Verbesserte Heilung",
		["Improved Healing Touch"] = "Verbesserte Heilende Berührung",
		["Improved Healing Wave"] = "Verbesserte Welle der Heilung",
		["Improved Health Funnel"] = "Verbesserte Lebenslinie",
		["Improved Healthstone"] = "Verbesserter Gesundheitsstein",
		["Improved Heroic Strike"] = "Verbesserter Heldenhafter Stoß",
		["Improved Holy Shield"] = "Verbesserter Heiliger Schild",
		["Improved Howl of Terror"] = "Verbessertes Schreckensgeheul",
		["Improved Hunter's Mark"] = "Verbessertes Mal des Jägers",
		["Improved Immolate"] = "Verbesserter Feuerbrand",
		["Improved Imp"] = "Verbesserter Wichtel",
		["Improved Inner Fire"] = "Verbessertes Inneres Feuer",
		["Improved Intercept"] = "Verbessertes Abfangen",
		["Improved Intimidating Shout"] = "Verbesserter Drohruf",
		["Improved Judgement"] = "Verbessertes Richturteil",
		["Improved Kick"] = "Verbesserter Tritt",
		["Improved Kidney Shot"] = "Verbesserter Nierenhieb",
		["Improved Lash of Pain"] = "Verbesserte Schmerzenspeitsche",
		["Improved Lay on Hands"] = "Verbesserte Handauflegung",
		["Improved Leader of the Pack"] = "Verbesserte Rudelführer",
		["Improved Life Tap"] = "Verbesserter Aderlass",
		["Improved Lightning Bolt"] = "Verbesserter Blitzschlag",
		["Improved Lightning Shield"] = "Verbesserter Blitzschlag-Schild",
		["Improved Magma Totem"] = "Verbessertes Totem der glühenden Magma",
		["Improved Mana Burn"] = "Verbesserter Manabrand",
		["Improved Mana Shield"] = "Verbesserter Manaschild",
		["Improved Mana Spring Totem"] = "Verbessertes Totem der Manaquelle",
		["Improved Mark of the Wild"] = "Verbessertes Mal der Wildnis",
		["Improved Mend Pet"] = "Verbessertes Tier heilen",
		["Improved Mind Blast"] = "Verbesserter Gedankenschlag",
		["Improved Moonfire"] = "Verbessertes Mondfeuer",
		["Improved Mortal Strike"] = "Verbesserter tödlicher Stoß",
		["Improved Nature's Grasp"] = "Verbesserter Griff der Natur",
		["Improved Overpower"] = "Verbessertes Überwältigen",
		["Improved Power Word: Fortitude"] = "Verbessertes Machtwort: Seelenstärke",
		["Improved Power Word: Shield"] = "Verbessertes Machtwort: Schild",
		["Improved Prayer of Healing"] = "Verbessertes Gebet der Heilung",
		["Improved Psychic Scream"] = "Verbesserter Psychischer Schrei",
		["Improved Regrowth"] = "Verbessertes Nachwachsen",
		["Improved Reincarnation"] = "Verbesserte Reinkarnation",
		["Improved Rejuvenation"] = "Verbesserte Verjüngung",
		["Improved Rend"] = "Verbessertes Verwunden",
		["Improved Renew"] = "Verbesserte Erneuerung",
		["Improved Retribution Aura"] = "Verbesserte Aura der Vergeltung",
		["Improved Revenge"] = "Verbesserte Rache",
		["Improved Revive Pet"] = "Verbessertes Tier wiederbeleben",
		["Improved Righteous Fury"] = "Verbesserter Zorn der Gerechtigkeit",
		["Improved Rupture"] = "Verbesserte Blutung",
		["Improved Scorch"] = "Verbessertes Versengen",
		["Improved Scorpid Sting"] = "Verbesserter Skorpidstich",
		["Improved Seal of Righteousness"] = "Verbessertes Siegel der Rechtschaffenheit",
		["Improved Seal of the Crusader"] = "Verbessertes Siegel des Kreuzfahrers",
		["Improved Searing Pain"] = "Verbesserter Sengender Schmerz",
		["Improved Serpent Sting"] = "Verbesserter Schlangenbiss",
		["Improved Shadow Bolt"] = "Verbesserter Schattenblitz",
		["Improved Shadow Word: Pain"] = "Verbessertes Schattenwort: Schmerz",
		["Improved Shield Bash"] = "Verbesserter Schildhieb",
		["Improved Shield Block"] = "Verbesserter Schildblock",
		["Improved Shield Wall"] = "Verbesserter Schildwall",
		["Improved Sinister Strike"] = "Verbesserter Finsterer Stoß",
		["Improved Slam"] = "Verbessertes Zerschmettern",
		["Improved Slice and Dice"] = "Verbessertes Zerhäckseln",
		["Improved Sprint"] = "Verbessertes Sprinten",
		["Improved Stings"] = "Verbesserte Stiche und Bisse",
		["Improved Succubus"] = "Verbesserter Sukkubus",
		["Improved Sunder Armor"] = "Verbessertes Rüstung zerreißen",
		["Improved Taunt"] = "Verbesserter Spott",
		["Improved Thunder Clap"] = "Verbesserter Donnerknall",
		["Improved Tranquility"] = "Verbesserte Gelassenheit",
		["Improved Vampiric Embrace"] = "Verbesserte Vampirumarmung",
		["Improved Vanish"] = "Verbessertes Verschwinden",
		["Improved Voidwalker"] = "Verbesserter Leerwandler",
		["Improved Weapon Totems"] = "Verbesserte Waffentotems",
		["Improved Whirlwind"] = "Verbesserter Wirbelwind",
		["Improved Wing Clip"] = "Verbessertes Zurechtstutzen",
		["Incinerate"] = "Verbrennen",
		["Incineration"] = "Verbrennung",
		["Inferno"] = "Inferno",
		["Initiative"] = "Initiative",
		["Inner Fire"] = "Inneres Feuer",
		["Inner Focus"] = "Innerer Fokus",
		["Innervate"] = "Anregen",
		["Insect Swarm"] = "Insektenschwarm",
		["Insidious Whisper"] = "Heimtückisches Geflüster",
		["Insignifigance"] = "Bedeutungslosigkeit",
		["Inspiration"] = "Inspiration",
		["Instant Poison"] = "Sofort wirkendes Gift",
		["Instant Poison II"] = "Sofort wirkendes Gift II",
		["Instant Poison III"] = "Sofort wirkendes Gift III",
		["Instant Poison IV"] = "Sofort wirkendes Gift IV",
		["Instant Poison V"] = "Sofort wirkendes Gift V",
		["Instant Poison VI"] = "Sofort wirkendes Gift VI",
		["Instant Poison VII"] = "Sofort wirkendes Gift VII",
		["Intensity"] = "Intensität",
		["Intercept"] = "Abfangen",
		["Intercept Stun"] = "Betäubung abfangen",
		["Intervene"] = "Einschreiten",
		["Intimidating Shout"] = "Drohruf",
		["Intimidation"] = "Einschüchterung",
		["Invisibility"] = "Unsichtbarkeit",
		["Iron Will"] = "Eiserner Wille",
		["Jewelcrafting"] = "Juwelenschleifen",
		["Jom Gabbar"] = "Jom Gabbar",
		["Judgement"] = "Richturteil",
		["Judgement of Blood"] = "Richturteil des Blutes",
		["Judgement of Command"] = "Richturteil des Befehls",
		["Judgement of Justice"] = "Richturteil der Gerechtigkeit",
		["Judgement of Light"] = "Richturteil des Lichts",
		["Judgement of Reckoning"] = "Richturteil der Abrechnung",
		["Judgement of Righteousness"] = "Richturteil der Rechtschaffenheit",
		["Judgement of Wisdom"] = "Richturteil der Weisheit",
		["Judgement of the Crusader"] = "Richturteil des Kreuzfahrers",
		["Kick"] = "Tritt",
		["Kick - Silenced"] = "Tritt - zum Schweigen gebracht",
		["Kidney Shot"] = "Nierenhieb",
		["Kill Command"] = "Fass!",
		["Killer Instinct"] = "Tötungstrieb",
		["Kiss of the Spider"] = "Kuss der Spinne",
		["Kodo Riding"] = "Kodoreiten",
		["Lacerate"] = "Aufschlitzen",
		["Lash of Pain"] = "Schmerzenspeitsche",
		["Last Stand"] = "Letztes Gefecht",
		["Lay on Hands"] = "Handauflegung",
		["Leader of the Pack"] = "Rudelführer",
		["Leather"] = "Leder",
		["Leatherworking"] = "Lederverarbeitung",
		["Lesser Heal"] = "Geringes Heilen",
		["Lesser Healing Wave"] = "Geringe Welle der Heilung",
		["Lesser Invisibility"] = "Geringe Unsichtbarkeit",
		["Lethal Shots"] = "Tödliche Schüsse",
		["Lethality"] = "Tödlichkeit",
		["Levitate"] = "Levitieren",
		["Libram"] = "Buchband",
		["Life Tap"] = "Aderlass",
		["Lifebloom"] = "Blühendes Leben",
		["Light's Grace"] = "Anmut des Lichts",
		["Lightning Bolt"] = "Blitzschlag",
		["Lightning Breath"] = "Blitzschlagatem",
		["Lightning Mastery"] = "Blitzschlagbeherrschung",
		["Lightning Reflexes"] = "Blitzartige Reflexe",
		["Lightning Shield"] = "Blitzschlagschild",
		["Lightning Speed"] = "Blitzschnell",
		["Lightwell"] = "Brunnen des Lichts",
		["Lightwell Renew"] = "Erneuerung des Lichtbrunnens",
		["Lockpicking"] = "Schlossknacken",
		["Long Daze"] = "Lange Benommenheit",
		["Lust for Battle"] = "Kampfeslust",
		["Mace Specialization"] = "Streitkolben-Spezialisierung",
		["Mace Stun Effect"] = "Streitkolbenbetäubung",
		["Mage Armor"] = "Magische Rüstung",
		["Magic Absorption"] = "Magische Vereinnahmung",
		["Magic Attunement"] = "Einklang der Magie",
		["Magma Totem"] = "Totem des glühenden Magmas",
		["Mail"] = "Panzer",
		["Maim"] = "Zerfleddern",
		["Major Dreamless Sleep"] = "Erheblicher traumloser Schlaf",
		["Malediction"] = "Verhängnis",
		["Malice"] = "Tücke",
		["Mana Burn"] = "Manabrand",
		["Mana Feed"] = "Mananachschub",
		["Mana Shield"] = "Manaschild",
		["Mana Spring"] = "Manaquelle",
		["Mana Spring Totem"] = "Totem der Manaquelle",
		["Mana Tap"] = "Manaanzapfen",
		["Mana Tide"] = "Manaflut",
		["Mana Tide Totem"] = "Totem der Manaflut",
		["Mangle"] = "Fleddern",
		["Mangle (Bear)"] = "Zerfleischen (Bär)",
		["Mangle (Cat)"] = "Zerfleischen (Katze)",
		["Mark of the Wild"] = "Mal der Wildnis",
		["Martyrdom"] = "Märtyrertum",
		["Mass Dispel"] = "Massenbannung",
		["Master Conjuror"] = "Meister der Herbeizauberung",
		["Master Demonologist"] = "Meister der Dämonologie",
		["Master Summoner"] = "Meister der Beschwörung",
		["Master Tactician"] = "Meister der Taktik",
		["Master of Deception"] = "Meister der Täuschung",
		["Master of Elements"] = "Meister der Elemente",
		["Master of Subtlety"] = "Meister der Subtilität",
		["Maul"] = "Zermalmen",
		["Mechanostrider Piloting"] = "Roboschreiter-Lenken",
		["Meditation"] = "Meditation",
		["Melee Specialization"] = "Nahkampf-Spezialisierung",
		["Melt Armor"] = "Rüstungsschmelze",
		["Mend Pet"] = "Tier heilen",
		["Mental Agility"] = "Mentale Beweglichkeit",
		["Mental Strength"] = "Mentale Stärke",
		["Mind Blast"] = "Gedankenschlag",
		["Mind Control"] = "Gedankenkontrolle",
		["Mind Flay"] = "Gedankenschinden",
		["Mind Mastery"] = "Geistesbeherrschung",
		["Mind Soothe"] = "Gedankenbesänftigung",
		["Mind Vision"] = "Gedankensicht",
		["Mind-numbing Poison"] = "Gedankenbenebelndes Gift",
		["Mind-numbing Poison II"] = "Gedankenbenebelndes Gift II",
		["Mind-numbing Poison III"] = "Gedankenbenebelndes Gift III",
		["Mining"] = "Bergbau",
		["Misdirection"] = "Irreführung",
		["Misery"] = "Elend",
		["Mocking Blow"] = "Spöttischer Schlag",
		["Molten Armor"] = "Glühende Rüstung",
		["Molten Fury"] = "Glühender Zorn",
		["Mongoose Bite"] = "Mungobiss",
		["Monster Slaying"] = "Monstertöten",
		["Moonfire"] = "Mondfeuer",
		["Moonfury"] = "Mondfuror",
		["Moonglow"] = "Mondschein",
		["Moonkin Aura"] = "Aura des Mondkin",
		["Moonkin Form"] = "Mondkingestalt",
		["Mortal Shots"] = "Todbringende Schüsse",
		["Mortal Strike"] = "Tödlicher Stoß",
		["Multi-Shot"] = "Mehrfachschuss",
		["Murder"] = "Mord",
		["Mutilate"] = "Verstümmeln",
		["Natural Armor"] = "Natürliche Rüstung",
		["Natural Perfection"] = "Vollkommenheit der Natur",
		["Natural Shapeshifter"] = "Schnellwandlung",
		["Naturalist"] = "Naturalist",
		["Nature Resistance"] = "Naturwiderstand",
		["Nature Resistance Totem"] = "Totem des Naturwiderstands",
		["Nature Weakness"] = "Natur Verwundbarkeit",
		["Nature's Focus"] = "Naturfokus",
		["Nature's Grace"] = "Anmut der Natur",
		["Nature's Grasp"] = "Griff der Natur",
		["Nature's Guidance"] = "Weisheit der Natur",
		["Nature's Reach"] = "Reichweite der Natur",
		["Nature's Swiftness"] = "Schnelligkeit der Natur",
		["Negative Charge"] = "Negative Ladung",
		["Nether Protection"] = "Netherschutz",
		["Netherstorm Flag"] = "Nethersturmbanner",
		["Nightfall"] = "Einbruch der Nacht",
		["Nurturing Instinct"] = "Beschützerinstinkt",
		["Omen of Clarity"] = "Omen der Klarsicht",
		["One-Handed Axes"] = "Einhandäxte",
		["One-Handed Maces"] = "Einhandstreitkolben",
		["One-Handed Swords"] = "Einhandschwerter",
		["One-Handed Weapon Specialization"] = "Einhandwaffen-Spezialisierung",
		["Opening"] = "Öffnen",
		["Opening - No Text"] = "Öffnen - Kein Text",
		["Opportunity"] = "Günstige Gelegenheit",
		["Overpower"] = "Überwältigen",
		["Pain Suppression"] = "Schmerzunterdrückung",
		["Panic"] = "Panik",
		["Paranoia"] = "Paranoia",
		["Parasitic Shadowfiend"] = "Schädlicher Schattengeist",
		["Parry"] = "Parieren",
		["Pathfinding"] = "Orientierung",
		["Perceived Weakness"] = "Schwäche aufdecken",
		["Perception"] = "Wachsamkeit",
		["Permafrost"] = "Dauerfrost",
		["Pet Aggression"] = "Tieraggression",
		["Pet Hardiness"] = "Tier-Widerstandskraft",
		["Pet Recovery"] = "Tiererholung",
		["Pet Resistance"] = "Tier-Widerstand",
		["Phase Shift"] = "Phasenverschiebung",
		["Pick Lock"] = "Schloss knacken",
		["Pick Pocket"] = "Taschendiebstahl",
		["Piercing Howl"] = "Durchdringendes Heulen",
		["Piercing Ice"] = "Stechendes Eis",
		["Plate Mail"] = "Plattenpanzer",
		["Playing with Fire"] = "Spiel mit dem Feuer",
		["Poison Cleansing Totem"] = "Totem der Giftreinigung",
		["Poison Spit"] = "Giftspucke",
		["Poisons"] = "Gifte",
		["Polearms"] = "Stangenwaffen",
		["Poleaxe Specialization"] = "Stangenwaffen-Spezialisierung",
		["Polymorph"] = "Verwandlung",
		["Polymorph: Pig"] = "Verwandlung: Schwein",
		["Polymorph: Turtle"] = "Verwandlung: Schildkröte",
		["Portal: Darnassus"] = "Portal: Darnassus",
		["Portal: Exodar"] = "Portal: Exodar",
		["Portal: Ironforge"] = "Portal: Eisenschmiede",
		["Portal: Orgrimmar"] = "Portal: Orgrimmar",
		["Portal: Shattrath"] = "Portal: Shattrath",
		["Portal: Silvermoon"] = "Portal: Silbermond",
		["Portal: Stormwind"] = "Portal: Sturmwind",
		["Portal: Thunder Bluff"] = "Portal: Donnerfels",
		["Portal: Undercity"] = "Portal: Unterstadt",
		["Positive Charge"] = "Positive Ladung",
		["Pounce"] = "Anspringen",
		["Pounce Bleed"] = "Anspringblutung",
		["Power Infusion"] = "Seele der Macht",
		["Power Word: Fortitude"] = "Machtwort: Seelenstärke",
		["Power Word: Shield"] = "Machtwort: Schild",
		["Prayer of Fortitude"] = "Gebet der Seelenstärke",
		["Prayer of Healing"] = "Gebet der Heilung",
		["Prayer of Mending"] = "Gebet der Besserung",
		["Prayer of Shadow Protection"] = "Gebet des Schattenschutzes",
		["Prayer of Spirit"] = "Gebet der Willenskraft",
		["Precision"] = "Präzision",
		["Predatory Instincts"] = "Instinkt des Raubtiers",
		["Predatory Strikes"] = "Raubtierschläge",
		["Premeditation"] = "Konzentration",
		["Preparation"] = "Vorbereitung",
		["Presence of Mind"] = "Geistesgegenwart",
		["Primal Fury"] = "Urfuror",
		["Prismatic Cloak"] = "Prismatischer Mantel",
		["Prospecting"] = "Sondieren",
		["Prowl"] = "Schleichen",
		["Psychic Scream"] = "Psychischer Schrei",
		["Pummel"] = "Zuschlagen",
		["Purge"] = "Reinigen",
		["Purification"] = "Läuterung",
		["Purify"] = "Läutern",
		["Purifying Power"] = "Reinigende Macht",
		["Pursuit of Justice"] = "Streben nach Gerechtigkeit",
		["Pyroblast"] = "Pyroschlag",
		["Pyroclasm"] = "Feuerschwall",
		["Pyromaniac"] = "Brandstifter",
		["Quick Recovery"] = "Schnelle Erholung",
		["Quick Shots"] = "Schnelle Schüsse",
		["Quickness"] = "Schnelligkeit",
		["Rage of the Unraveller"] = "Zorn des Entwirrers",
		["Rain of Fire"] = "Feuerregen",
		["Rake"] = "Krallenhieb",
		["Ram Riding"] = "Widderreiten",
		["Rampage"] = "Toben",
		["Ranged Weapon Specialization"] = "Distanzwaffen-Spezialisierung",
		["Rapid Fire"] = "Schnellfeuer",
		["Rapid Killing"] = "Schneller Tod",
		["Raptor Riding"] = "Raptorreiten",
		["Raptor Strike"] = "Raptorstoß",
		["Ravage"] = "Verheeren",
		["Readiness"] = "Bereitschaft",
		["Rebirth"] = "Wiedergeburt",
		["Reckless Charge"] = "Rücksichtsloser Sturmangriff",
		["Recklessness"] = "Tollkühnheit",
		["Reckoning"] = "Abrechnung",
		["Redemption"] = "Erlösung",
		["Redoubt"] = "Verschanzen",
		["Reflection"] = "Reflexion",
		["Regeneration"] = "Regeneration",
		["Regrowth"] = "Nachwachsen",
		["Reincarnation"] = "Reinkarnation",
		["Reinforced Shield"] = "Verstärktes Schild",
		["Rejuvenation"] = "Verjüngung",
		["Relentless Strikes"] = "Unerbittliche Stöße",
		["Remorseless"] = "Gnadenlos",
		["Remorseless Attacks"] = "Gnadenlose Angriffe",
		["Remote Toy"] = "Ferngesteuertes Spielzeug",
		["Remove Curse"] = "Fluch aufheben",
		["Remove Insignia"] = "Abzeichen entfernen",
		["Remove Lesser Curse"] = "Geringen Fluch aufheben",
		["Rend"] = "Verwunden",
		["Renew"] = "Erneuerung",
		["Repentance"] = "Buße",
		["Restless Strength"] = "Ruhelose Stärke",
		["Restorative Totems"] = "Regenerationstotems",
		["Resurrection"] = "Auferstehung",
		["Retaliation"] = "Gegenschlag",
		["Retribution Aura"] = "Aura der Vergeltung",
		["Revenge"] = "Rache",
		["Revenge Stun"] = "Rachebetäubung",
		["Reverberation"] = "Nachklingen",
		["Revive Pet"] = "Tier wiederbeleben",
		["Righteous Defense"] = "Rechtschaffene Verteidigung",
		["Righteous Fury"] = "Zorn der Gerechtigkeit",
		["Rip"] = "Zerfetzen",
		["Riposte"] = "Riposte",
		["Ritual of Doom"] = "Ritual der Verdammnis",
		["Ritual of Doom Effect"] = "Ritual der Verdammnis'-Effekt",
		["Ritual of Refreshment"] = "Tischlein deck dich",
		["Ritual of Souls"] = "Ritual der Seelen",
		["Ritual of Summoning"] = "Ritual der Beschwörung",
		["Rockbiter Weapon"] = "Waffe des Felsbeißers",
		["Rough Sharpening Stone"] = "Rauher Wetzstein",
		["Ruin"] = "Verderben",
		["Rupture"] = "Blutung",
		["Ruthlessness"] = "Skrupellosigkeit",
		["Sacrifice"] = "Opferung",
		["Safe Fall"] = "Sicheres Fallen",
		["Sanctified Crusader"] = "Geweihter Kreuzfahrer",
		["Sanctified Judgement"] = "Geweihtes Richturteil",
		["Sanctified Light"] = "Geweihtes Licht",
		["Sanctity Aura"] = "Aura der Heiligkeit",
		["Sap"] = "Kopfnuss",
		["Savage Fury"] = "Ungezähmte Wut",
		["Savage Strikes"] = "Wilde Schläge",
		["Scare Beast"] = "Wildtier ängstigen",
		["Scatter Shot"] = "Streuschuss",
		["Scorch"] = "Versengen",
		["Scorpid Poison"] = "Skorpidgift",
		["Scorpid Sting"] = "Skorpidstich",
		["Screech"] = "Schrei",
		["Seal Fate"] = "Schicksal besiegeln",
		["Seal of Blood"] = "Siegel des Blutes",
		["Seal of Command"] = "Siegel des Befehls",
		["Seal of Justice"] = "Siegel der Gerechtigkeit",
		["Seal of Light"] = "Siegel des Lichts",
		["Seal of Righteousness"] = "Siegel der Rechtschaffenheit",
		["Seal of Vengeance"] = "Siegel der Vergeltung",
		["Seal of Wisdom"] = "Siegel der Weisheit",
		["Seal of the Crusader"] = "Siegel des Kreuzfahrers",
		["Searing Light"] = "Sengendes Licht",
		["Searing Pain"] = "Sengender Schmerz",
		["Searing Totem"] = "Totem der Verbrennung",
		["Second Wind"] = "Kräfte sammeln",
		["Seduction"] = "Verführung",
		["Seed of Corruption"] = "Saat der Verderbnis",
		["Seethe"] = "Brodeln",
		["Sense Demons"] = "Dämonen spüren",
		["Sense Undead"] = "Untote spüren",
		["Sentry Totem"] = "Totem des Wachens",
		["Serpent Sting"] = "Schlangenbiss",
		["Serrated Blades"] = "Gezahnte Klingen",
		["Setup"] = "Reinlegen",
		["Shackle Undead"] = "Untote fesseln",
		["Shadow Affinity"] = "Schattenaffinität",
		["Shadow Bolt"] = "Schattenblitz",
		["Shadow Embrace"] = "Umschlingende Schatten",
		["Shadow Focus"] = "Schattenfokus",
		["Shadow Mastery"] = "Schattenbeherrschung",
		["Shadow Power"] = "Schattenmacht",
		["Shadow Protection"] = "Schattenschutz",
		["Shadow Reach"] = "Schattenreichweite",
		["Shadow Resistance"] = "Schattenwiderstand",
		["Shadow Resistance Aura"] = "Aura des Schattenwiderstands",
		["Shadow Trance"] = "Schattentrance",
		["Shadow Vulnerability"] = "Schattenverwundbarkeit",
		["Shadow Ward"] = "Schattenzauberschutz",
		["Shadow Weakness"] = "Schatten Verwundbarkeit",
		["Shadow Weaving"] = "Schattenwirken",
		["Shadow Word: Death"] = "Schattenwort: Tod",
		["Shadow Word: Pain"] = "Schattenwort: Schmerz",
		["Shadow and Flame"] = "Schatten und Flamme",
		["Shadow of Death"] = "Schatten des Todes",
		["Shadowburn"] = "Schattenbrand",
		["Shadowfiend"] = "Schattengeist",
		["Shadowform"] = "Schattengestalt",
		["Shadowfury"] = "Schattenfurie",
		["Shadowguard"] = "Schattenschild",
		["Shadowmeld"] = "Schattenhaftigkeit",
		["Shadowmeld Passive"] = "Schattenmimik Passiv",
		["Shadowstep"] = "Schattenschritt",
		["Shamanistic Rage"] = "Schamanistische Wut",
		["Sharpened Claws"] = "Geschärfte Klauen",
		["Shatter"] = "Zertrümmern",
		["Shear"] = "Abscheren",
		["Shell Shield"] = "Panzerschild",
		["Shield"] = "Schild",
		["Shield Bash"] = "Schildhieb",
		["Shield Bash - Silenced"] = "Schildhieb - zum Schweigen gebracht",
		["Shield Block"] = "Schildblock",
		["Shield Slam"] = "Schildschlag",
		["Shield Specialization"] = "Schild-Spezialisierung",
		["Shield Wall"] = "Schildwall",
		["Shiv"] = "Tückische Klinge",
		["Shoot"] = "Schießen",
		["Shoot Bow"] = "Bogenschuss",
		["Shoot Gun"] = "Schusswaffe abfeuern",
		["Shred"] = "Schreddern",
		["Shredding Attacks"] = "Schreddernde Angriffe",
		["Silence"] = "Stille",
		["Silencing Shot"] = "Unterdrückender Schuss",
		["Silent Resolve"] = "Schweigsame Entschlossenheit",
		["Silverwing Flag"] = "Flagge der Silberschwingen",
		["Sinister Strike"] = "Finsterer Stoß",
		["Siphon Life"] = "Lebensentzug",
		["Skinning"] = "Kürschnerei",
		["Slam"] = "Zerschmettern",
		["Slayer's Crest"] = "Wappen des Schlächters",
		["Sleep"] = "Schlaf",
		["Slice and Dice"] = "Zerhäckseln",
		["Slow"] = "Verlangsamen",
		["Slow Fall"] = "Langsamer Fall",
		["Smelting"] = "Verhüttung",
		["Smite"] = "Göttliche Pein",
		["Snake Trap"] = "Schlangenfalle",
		["Solid Sharpening Stone"] = "Robuster Wetzstein",
		["Sonic Burst"] = "Schallexplosion",
		["Soothe Animal"] = "Tier besänftigen",
		["Soothing Kiss"] = "Besänftigender Kuss",
		["Soul Fire"] = "Seelenfeuer",
		["Soul Leech"] = "Seele entziehen",
		["Soul Link"] = "Seelenverbindung",
		["Soul Siphon"] = "Seelenentzug",
		["Soulshatter"] = "Seele brechen",
		["Soulstone Resurrection"] = "Seelensteinauferstehung",
		["Spell Haste"] = "Zaubertempo",
		["Spell Lock"] = "Zaubersperre",
		["Spell Power"] = "Zauberkraft",
		["Spell Reflection"] = "Zauberreflexion",
		["Spell Vulnerability"] = "Zauber Empfindlichkeit",
		["Spell Warding"] = "Zauberschutz",
		["Spellsteal"] = "Zauberraub",
		["Spirit Bond"] = "Geistbande",
		["Spirit Tap"] = "Willensentzug",
		["Spirit of Redemption"] = "Geist der Erlösung",
		["Spiritual Attunement"] = "Einklang des Geistes",
		["Spiritual Focus"] = "Spiritueller Fokus",
		["Spiritual Guidance"] = "Geistige Führung",
		["Spiritual Healing"] = "Spirituelle Heilung",
		["Spiteful Fury"] = "Boshafter Furor",
		["Sprint"] = "Sprinten",
		["Stance Mastery"] = "Haltung bewahren",
		["Starfire"] = "Sternenfeuer",
		["Starfire Stun"] = "Sternenfeuerbetäubung",
		["Starlight Wrath"] = "Zorniges Sternenlicht",
		["Starshards"] = "Sternensplitter",
		["Static Charge"] = "Statische Aufladung",
		["Staves"] = "Stäbe",
		["Steady Shot"] = "Zuverlässiger Schuss",
		["Stealth"] = "Verstohlenheit",
		["Stoneclaw Stun"] = "Steinklauenbetäuben",
		["Stoneclaw Totem"] = "Totem der Steinklaue",
		["Stoneform"] = "Steingestalt",
		["Stoneskin"] = "Steinhaut",
		["Stoneskin Totem"] = "Totem der Steinhaut",
		["Stormstrike"] = "Sturmschlag",
		["Strength of Earth"] = "Erdstärke",
		["Strength of Earth Totem"] = "Totem der Erdstärke",
		["Strength of the Halaani"] = "Stärke der Halaani",
		["Stuck"] = "Feststecken",
		["Stun"] = "Betäubt",
		["Subtlety"] = "Feingefühl",
		["Suffering"] = "Leiden",
		["Summon Charger"] = "Streitross beschwören",
		["Summon Dreadsteed"] = "Schreckensross herbeirufen",
		["Summon Felguard"] = "Teufelswache beschwören",
		["Summon Felhunter"] = "Teufelsjäger beschwören",
		["Summon Felsteed"] = "Teufelsross beschwören",
		["Summon Imp"] = "Wichtel beschwören",
		["Summon Succubus"] = "Sukkubus beschwören",
		["Summon Voidwalker"] = "Leerwandler beschwören",
		["Summon Warhorse"] = "Schlachtross beschwören",
		["Summon Water Elemental"] = "Wasserelementar beschwören",
		["Sunder Armor"] = "Rüstung zerreißen",
		["Suppression"] = "Unterdrückung",
		["Surefooted"] = "Sicherer Stand",
		["Surge of Light"] = "Woge des Lichts",
		["Surprise Attacks"] = "Überraschungsangriffe",
		["Survivalist"] = "Überlebenskünstler",
		["Sweeping Strikes"] = "Weitreichende Stöße",
		["Swift Flight Form"] = "Schnelle Fluggestalt",
		["Swiftmend"] = "Rasche Heilung",
		["Swipe"] = "Prankenhieb",
		["Sword Specialization"] = "Schwert-Spezialisierung",
		["Symbol of Hope"] = "Symbol der Hoffnung",
		["Tactical Mastery"] = "Taktiker",
		["Tailoring"] = "Schneiderei",
		["Tainted Blood"] = "Besudeltes Blut",
		["Tainted Mind"] = "Besudelte Gedanken",
		["Tame Beast"] = "Wildtier zähmen",
		["Taunt"] = "Spott",
		["Teleport: Darnassus"] = "Teleportieren: Darnassus",
		["Teleport: Exodar"] = "Teleportieren: Exodar",
		["Teleport: Ironforge"] = "Teleportieren: Eisenschmiede",
		["Teleport: Moonglade"] = "Teleportieren: Mondlichtung",
		["Teleport: Orgrimmar"] = "Teleportieren: Orgrimmar",
		["Teleport: Shattrath"] = "Teleportieren: Shattrath",
		["Teleport: Silvermoon"] = "Teleportieren: Silbermond",
		["Teleport: Stormwind"] = "Teleportieren: Sturmwind",
		["Teleport: Thunder Bluff"] = "Teleportieren: Donnerfels",
		["Teleport: Undercity"] = "Teleportieren: Unterstadt",
		["Temporal Rift"] = "Temporalriss",
		["The Beast Within"] = "Wildes Herz",
		["The Human Spirit"] = "Unbeugsamkeit",
		["Thick Hide"] = "Dickes Fell",
		["Thorns"] = "Dornen",
		["Thrill of the Hunt"] = "Jagdfieber",
		["Throw"] = "Werfen",
		["Throwing Specialization"] = "Wurfwaffen-Spezialisierung",
		["Thrown"] = "Wurfwaffe",
		["Thunder Clap"] = "Donnerknall",
		["Thunderfury"] = "Donnerzorn",
		["Thundering Strikes"] = "Donnernde Stöße",
		["Thunderstomp"] = "Donnerstampfer",
		["Tidal Focus"] = "Gezeitenfokus",
		["Tidal Mastery"] = "Gezeitenbeherrschung",
		["Tiger Riding"] = "Tigerreiten",
		["Tiger's Fury"] = "Tigerfuror",
		["Time's Favor"] = "Gunst der Zeit",
		["Torment"] = "Qual",
		["Totem"] = "Totem",
		["Totem of Wrath"] = "Totem des Ingrimms",
		["Totemic Call"] = "Ruf der Totems",
		["Totemic Focus"] = "Totemfokus",
		["Touch of Shadow"] = "Berührung des Schattens",
		["Touch of Weakness"] = "Berührung der Schwäche",
		["Toughness"] = "Zähigkeit",
		["Traces of Silithyst"] = "Spuren von Silithyst",
		["Track Beasts"] = "Wildtiere aufspüren",
		["Track Demons"] = "Dämonen aufspüren",
		["Track Dragonkin"] = "Drachkin aufspüren",
		["Track Elementals"] = "Elementare aufspüren",
		["Track Giants"] = "Riesen aufspüren",
		["Track Hidden"] = "Verborgenes aufspüren",
		["Track Humanoids"] = "Humanoide aufspüren",
		["Track Undead"] = "Untote aufspüren",
		["Tranquil Air"] = "Beruhigenden Winde",
		["Tranquil Air Totem"] = "Totem der beruhigenden Winde",
		["Tranquil Spirit"] = "Gelassener Geist",
		["Tranquility"] = "Gelassenheit",
		["Tranquilizing Shot"] = "Einlullender Schuss",
		["Trap Mastery"] = "Fallenbeherrschung",
		["Travel Form"] = "Reisegestalt",
		["Tree of Life"] = "Baum des Lebens",
		["Tremor Totem"] = "Totem des Erdstoßes",
		["Tribal Leatherworking"] = "Stammeslederverarbeitung",
		["Trueshot Aura"] = "Aura des Volltreffers",
		["Turn Undead"] = "Untote vertreiben",
		["Twin Spire Blessing"] = "Segen der Zwillingsspitze",
		["Two-Handed Axes"] = "Zweihandäxte",
		["Two-Handed Axes and Maces"] = "Zweihandäxte und -Streitkolben",
		["Two-Handed Maces"] = "Zweihandstreitkolben",
		["Two-Handed Swords"] = "Zweihandschwerter",
		["Two-Handed Weapon Specialization"] = "Zweihandwaffen-Spezialisierung",
		["Unarmed"] = "Unbewaffnet",
		["Unbreakable Will"] = "Unbezwingbarer Wille",
		["Unbridled Wrath"] = "Entfesselter Zorn",
		["Undead Horsemanship"] = "Untotenreitkunst",
		["Underwater Breathing"] = "Unterwasseratmung",
		["Unending Breath"] = "Unendlicher Atem",
		["Unholy Power"] = "Unheilige Macht",
		["Unleashed Fury"] = "Entfesselter Zorn",
		["Unleashed Rage"] = "Entfesselte Wut",
		["Unstable Affliction"] = "Instabiles Gebrechen",
		["Unstable Power"] = "Instabile Energie",
		["Unyielding Faith"] = "Unumstößlicher Glaube",
		["Upset Tummy"] = "Gereizter Magen",
		["Vampiric Embrace"] = "Vampirumarmung",
		["Vampiric Touch"] = "Vampirberührung",
		["Vanish"] = "Verschwinden",
		["Vanished"] = "Verschwunden",
		["Vengeance"] = "Rache",
		["Venomous Totem"] = "Gifttotem",
		["Victory Rush"] = "Siegesrausch",
		["Vigor"] = "Lebenskraft",
		["Vile Beam"] = "Heimtückischer Strahl",
		["Vile Poisons"] = "Üble Gifte",
		["Vindication"] = "Rechtschaffene Schwächung",
		["Viper Sting"] = "Vipernbiss",
		["Volley"] = "Salve",
		["Wand Specialization"] = "Zauberstab-Spezialisierung",
		["Wands"] = "Zauberstäbe",
		["War Stomp"] = "Kriegsdonner",
		["Warp"] = "Verzerrt",
		["Warsong Flag"] = "Warsong Flagge",
		["Water Breathing"] = "Wasseratmung",
		["Water Shield"] = "Wasserschild",
		["Water Tomb"] = "Wassergrab",
		["Water Walking"] = "Wasserwandeln",
		["Waterbolt"] = "Wasserblitz",
		["Watery Grave"] = "Nasses Grab",
		["Weakened Soul"] = "Geschwächte Seele",
		["Weapon Mastery"] = "Waffenbeherschung",
		["Weaponsmith"] = "Waffenschmied",
		["Well Fed"] = "Satt",
		["Whirlwind"] = "Wirbelwind",
		["Will of the Forsaken"] = "Wille der Verlassenen",
		["Windfury"] = "Windfuror",
		["Windfury Attack"] = "Angriff des Windzorns",
		["Windfury Totem"] = "Totem des Windzorns",
		["Windfury Weapon"] = "Waffe des Windzorns",
		["Windwall"] = "Windmauer",
		["Windwall Totem"] = "Totem der Windmauer",
		["Wing Clip"] = "Zurechtstutzen",
		["Winter's Chill"] = "Winterkälte",
		["Wisp Spirit"] = "Irrwisch-Geist",
		["Wolf Riding"] = "Wolfreiten",
		["Wound Poison"] = "Wundgift",
		["Wound Poison II"] = "Wundgift II",
		["Wound Poison III"] = "Wundgift III",
		["Wound Poison IV"] = "Wundgift IV",
		["Wound Poison V"] = "Wundgift V",
		["Wrath"] = "Zorn",
		["Wrath of Air Totem"] = "Totem des stürmischen Zorns",
		["Wrath of Cenarius"] = "Zorn des Cenarius",
		["Wrath of the Astromancer"] = "Zorn des Astromanten",
		["Wyvern Sting"] = "Stich des Flügeldrachen",
	}
end)

BabbleSpell:RegisterTranslations("frFR", function()
	return {
		["Abolish Disease"] = "Abolir maladie",
		["Abolish Poison"] = "Abolir le poison",
		["Abolish Poison Effect"] = "Effet Abolir le poison",
		["Activate MG Turret"] = "Activation de la tourelle de mitrailleuse",
		["Adrenaline Rush"] = "Poussée d'adrénaline",
		["Aftermath"] = "Conséquences",
		["Aggression"] = "Agressivité",
		["Agonizing Flames"] = "Flammes déchirantes",
		["Aimed Shot"] = "Visée",
		["Alchemy"] = "Alchimie",
		["Ambush"] = "Embuscade",
		["Amplify Curse"] = "Malédiction amplifiée",
		["Amplify Magic"] = "Amplification de la magie",
		["Ancestral Fortitude"] = "Robustesse des anciens",
		["Ancestral Healing"] = "Guérison des anciens",
		["Ancestral Knowledge"] = "Connaissance ancestrale",
		["Ancestral Spirit"] = "Esprit ancestral",
		["Ancient Hysteria"] = "Hystérie ancienne",
		["Anesthetic Poison"] = "Poison anesthésiant",
		["Anger Management"] = "Maîtrise de la Rage",
		["Anguish"] = "Angoisse",
		["Anticipation"] = "Anticipation",
		["Aquatic Form"] = "Forme aquatique",
		["Arcane Blast"] = "Déflagration des arcanes",
		["Arcane Brilliance"] = "Illumination des arcanes",
		["Arcane Concentration"] = "Concentration des arcanes",
		["Arcane Energy"] = "Energie des arcanes",
		["Arcane Explosion"] = "Explosion des arcanes",
		["Arcane Focus"] = "Focalisation des arcanes",
		["Arcane Fortitude"] = "Robustesse des arcanes",
		["Arcane Impact"] = "Impact des arcanes",
		["Arcane Instability"] = "Instabilité des arcanes",
		["Arcane Intellect"] = "Intelligence des arcanes",
		["Arcane Meditation"] = "Méditation des arcanes",
		["Arcane Mind"] = "Esprit des arcanes",
		["Arcane Missiles"] = "Projectiles des arcanes",
		["Arcane Potency"] = "Toute-puissance des arcanes",
		["Arcane Power"] = "Pouvoir des arcanes",
		["Arcane Resistance"] = "Résistance aux Arcanes",
		["Arcane Shot"] = "Tir des arcanes",
		["Arcane Shroud"] = "Voile des arcanes",
		["Arcane Subtlety"] = "Subtilité des arcanes",
		["Arcane Torrent"] = "Torrent arcanique",
		["Arcane Weakness"] = "Sensibilité aux Arcanes",
		["Arctic Reach"] = "Allonge arctique",
		["Arctic Winds"] = "Vents arctiques",
		["Armor of Faith"] = "Armure de la Foi",
		["Armorsmith"] = "Fabricant d'armures",
		["Aspect of the Beast"] = "Aspect de la bête",
		["Aspect of the Cheetah"] = "Aspect du guépard",
		["Aspect of the Hawk"] = "Aspect du faucon",
		["Aspect of the Monkey"] = "Aspect du singe",
		["Aspect of the Pack"] = "Aspect de la meute",
		["Aspect of the Viper"] = "Aspect de la vipère",
		["Aspect of the Wild"] = "Aspect de la nature",
		["Astral Recall"] = "Rappel astral",
		["Attack"] = "Attaque",
		["Attacking"] = "Attaque",
		["Auto Shot"] = "Tir automatique",
		["Avenger's Shield"] = "Bouclier du vengeur",
		["Avenging Wrath"] = "Courroux vengeur",
		["Avoidance"] = "Evitement",
		["Axe Specialization"] = "Spécialisation Hache",
		["Backlash"] = "Contrecoup",
		["Backstab"] = "Attaque sournoise",
		["Badge of the Swarmguard"] = "Insigne de garde-essaim",
		["Balance of Power"] = "Equilibre de la puissance",
		["Bane"] = "Fléau",
		["Banish"] = "Bannir",
		["Banshee Curse"] = "Malédiction de la Banshee",
		["Barkskin"] = "Ecorce",
		["Barrage"] = "Barrage",
		["Bash"] = "Sonner",
		["Basic Campfire"] = "Feu de camp basique",
		["Battle Rush"] = "Ivresse de la bataille",
		["Battle Shout"] = "Cri de guerre",
		["Battle Stance"] = "Posture de combat",
		["Battle Stance Passive"] = "Posture de combat",
		["Bear Form"] = "Forme d'ours",
		["Beast Lore"] = "Connaissance des bêtes",
		["Beast Slaying"] = "Tueur de bêtes",
		["Beast Training"] = "Dressage des bêtes",
		["Benediction"] = "Bénédiction",
		["Berserker Rage"] = "Rage berserker",
		["Berserker Stance"] = "Posture berserker",
		["Berserker Stance Passive"] = "Posture berserker",
		["Berserking"] = "Berserker",
		["Bestial Discipline"] = "Discipline bestiale",
		["Bestial Swiftness"] = "Rapidité bestiale",
		["Bestial Wrath"] = "Courroux bestial",
		["Binding Heal"] = "Soins de lien",
		["Bite"] = "Morsure",
		["Black Arrow"] = "Flèche noire",
		["Blackout"] = "Aveuglement",
		["Blacksmithing"] = "Forge",
		["Blade Flurry"] = "Déluge de lames",
		["Blade Turning"] = "Froissement",
		["Blade Twisting"] = "Tournoiement de lames",
		["Blast Wave"] = "Vague explosive",
		["Blazing Speed"] = "Vitesse flamboyante",
		["Blessed Recovery"] = "Rétablissement béni",
		["Blessed Resilience"] = "Résilience bénie",
		["Blessing of Auchindoun"] = "Bénédiction d'Auchindoun",
		["Blessing of Freedom"] = "Bénédiction de liberté",
		["Blessing of Kings"] = "Bénédiction des rois",
		["Blessing of Light"] = "Bénédiction de lumière",
		["Blessing of Might"] = "Bénédiction de puissance",
		["Blessing of Protection"] = "Bénédiction de protection",
		["Blessing of Sacrifice"] = "Bénédiction de sacrifice",
		["Blessing of Salvation"] = "Bénédiction de salut",
		["Blessing of Sanctuary"] = "Bénédiction du sanctuaire",
		["Blessing of Wisdom"] = "Bénédiction de sagesse",
		["Blind"] = "Cécité",
		["Blinding Powder"] = "Poudre aveuglante",
		["Blink"] = "Transfert",
		["Blizzard"] = "Blizzard",
		["Block"] = "Bloquer",
		["Blood Craze"] = "Folie sanguinaire",
		["Blood Frenzy"] = "Frénésie sanglante",
		["Blood Fury"] = "Fureur sanguinaire",
		["Blood Pact"] = "Pacte de sang",
		["Bloodlust"] = "Furie sanguinaire",
		["Bloodrage"] = "Rage sanguinaire",
		["Bloodthirst"] = "Sanguinaire",
		["Boar Charge"] = "Boutoir",
		["Booming Voice"] = "Voix tonitruante",
		["Bow Specialization"] = "Spécialisation Arc",
		["Bows"] = "Arcs",
		["Bright Campfire"] = "Feu de camp éclatant",
		["Brittle Armor"] = "Armure fragile",
		["Brutal Impact"] = "Impact brutal",
		["Burning Adrenaline"] = "Montée d'adrénaline",
		["Burning Soul"] = "Ame ardente",
		["Burning Wish"] = "Souhait ardent",
		["Call Pet"] = "Appel du familier",
		["Call of Flame"] = "Appel des flammes",
		["Call of Thunder"] = "Appel de la foudre",
		["Call of the Nexus"] = "Appel du nexus",
		["Camouflage"] = "Dissimulation",
		["Cannibalize"] = "Cannibalisme",
		["Cat Form"] = "Forme de félin",
		["Cataclysm"] = "Cataclysme",
		["Celestial Focus"] = "Focalisation céleste",
		["Chain Heal"] = "Salve de guérison",
		["Chain Lightning"] = "Chaîne d'éclairs",
		["Challenging Roar"] = "Rugissement provocateur",
		["Challenging Shout"] = "Cri de défi",
		["Charge"] = "Charge",
		["Charge Rage Bonus Effect"] = "Effet Bonus de Rage de la Charge",
		["Charge Stun"] = "Charge étourdissante",
		["Chastise"] = "Châtier",
		["Cheap Shot"] = "Coup bas",
		["Chilled"] = "Transi",
		["Circle of Healing"] = "Cercle de soins",
		["Claw"] = "Griffe",
		["Cleanse"] = "Epuration",
		["Clearcasting"] = "Idées claires",
		["Cleave"] = "Enchaînement",
		["Clever Traps"] = "Pièges astucieux",
		["Cloak of Shadows"] = "Cape d'ombre",
		["Closing"] = "Fermeture",
		["Cloth"] = "Tissu",
		["Coarse Sharpening Stone"] = "Pierre à aiguiser grossière",
		["Cobra Reflexes"] = "Réflexes du cobra",
		["Cold Blood"] = "Sang froid",
		["Cold Snap"] = "Morsure de glace",
		["Combat Endurance"] = "Endurance de combat",
		["Combustion"] = "Combustion",
		["Command"] = "Commandement",
		["Commanding Presence"] = "Présence de commandement",
		["Commanding Shout"] = "Cri de commandement",
		["Concentration Aura"] = "Aura de concentration",
		["Concussion"] = "Commotion",
		["Concussion Blow"] = "Bourrasque",
		["Concussive Barrage"] = "Barrage commotionnant",
		["Concussive Shot"] = "Trait de choc",
		["Cone of Cold"] = "Cône de froid",
		["Conflagrate"] = "Conflagration",
		["Conflagration"] = "Déflagration",
		["Conjure Food"] = "Invocation de nourriture",
		["Conjure Mana Agate"] = "Invocation d'une agate de mana",
		["Conjure Mana Citrine"] = "Invocation d'une citrine de mana",
		["Conjure Mana Emerald"] = "Invocation d'une émeraude de mana",
		["Conjure Mana Jade"] = "Invocation d'une jade de mana",
		["Conjure Mana Ruby"] = "Invocation d'un rubis de mana",
		["Conjure Water"] = "Invocation d'eau",
		["Consecration"] = "Consécration",
		["Consume Magic"] = "Consumer la magie",
		["Consume Shadows"] = "Consumer les ombres",
		["Contagion"] = "Contagion",
		["Convection"] = "Convection",
		["Conviction"] = "Conviction",
		["Cooking"] = "Cuisine",
		["Corruption"] = "Corruption",
		["Counterattack"] = "Contre-attaque",
		["Counterspell"] = "Contresort",
		["Counterspell - Silenced"] = "Contresort - Silencieux",
		["Cower"] = "Dérobade",
		["Create Firestone"] = "Création de Pierre de feu",
		["Create Firestone (Greater)"] = "Création de Pierre de feu (supérieure)",
		["Create Firestone (Lesser)"] = "Création de Pierre de feu (inférieure)",
		["Create Firestone (Major)"] = "Création de Pierre de feu (majeure)",
		["Create Healthstone"] = "Création de Pierre de soins",
		["Create Healthstone (Greater)"] = "Création de Pierre de soins (supérieure)",
		["Create Healthstone (Lesser)"] = "Création de Pierre de soins (inférieure)",
		["Create Healthstone (Major)"] = "Création de Pierre de soins (majeure)",
		["Create Healthstone (Minor)"] = "Création de Pierre de soins (mineure)",
		["Create Soulstone"] = "Création de Pierre d'âme",
		["Create Soulstone (Greater)"] = "Création de Pierre d'âme (supérieure)",
		["Create Soulstone (Lesser)"] = "Création de Pierre d'âme (inférieure)",
		["Create Soulstone (Major)"] = "Création de Pierre d'âme (majeure)",
		["Create Soulstone (Minor)"] = "Création de Pierre d'âme (mineure)",
		["Create Spellstone"] = "Création de Pierre de sort",
		["Create Spellstone (Greater)"] = "Création de Pierre de sort (supérieure)",
		["Create Spellstone (Major)"] = "Création de Pierre de sort (majeure)",
		["Create Spellstone (Master)"] = "Création de Pierre de sort (magistrale)",
		["Creeping Paralysis"] = "Paralysie progressive",
		["Cripple"] = "Faiblesse",
		["Crippling Poison"] = "Poison affaiblissant",
		["Crippling Poison II"] = "Poison affaiblissant II",
		["Critical Mass"] = "Masse critique",
		["Crossbows"] = "Arbalètes",
		["Cruelty"] = "Cruauté",
		["Crusade"] = "Croisade",
		["Crusader Aura"] = "Aura de croisé",
		["Crusader Strike"] = "Inquisition",
		["Cultivation"] = "Culture",
		["Cure Disease"] = "Guérison des maladies",
		["Cure Poison"] = "Guérison du poison",
		["Curse of Agony"] = "Malédiction d'agonie",
		["Curse of Doom"] = "Malédiction funeste",
		["Curse of Doom Effect"] = "Effet Malédiction funeste",
		["Curse of Exhaustion"] = "Malédiction de fatigue",
		["Curse of Idiocy"] = "Malédiction d'idiotie",
		["Curse of Recklessness"] = "Malédiction de témérité",
		["Curse of Shadow"] = "Malédiction de l'ombre",
		["Curse of Tongues"] = "Malédiction des langages",
		["Curse of Weakness"] = "Malédiction de faiblesse",
		["Curse of the Elements"] = "Malédiction des éléments",
		["Cyclone"] = "Cyclone",
		["Dagger Specialization"] = "Spécialisation Dague",
		["Daggers"] = "Dagues",
		["Dampen Magic"] = "Atténuation de la magie",
		["Dark Barrage"] = "Barrage noir",
		["Dark Pact"] = "Pacte noir",
		["Darkness"] = "Ténèbres",
		["Dash"] = "Célérité",
		["Dawnstone Crab"] = "Crabe de pierre d'aube",
		["Dazed"] = "Hébétement",
		["Deadly Interrupt Effect"] = "Effet d'interruption mortel",
		["Deadly Poison"] = "Poison mortel",
		["Deadly Poison II"] = "Poison mortel II",
		["Deadly Poison III"] = "Poison mortel III",
		["Deadly Poison IV"] = "Poison mortel IV",
		["Deadly Poison V"] = "Poison mortel V",
		["Deadly Poison VI"] = "Poison mortel VI",
		["Deadly Poison VII"] = "Poison mortel VII",
		["Deadly Throw"] = "Lancer mortel",
		["Death Coil"] = "Voile mortel",
		["Death Wish"] = "Souhait mortel",
		["Deep Wound"] = "Blessure profonde",
		["Deep Wounds"] = "Blessures profondes",
		["Defense"] = "Défense",
		["Defensive Stance"] = "Posture défensive",
		["Defensive Stance Passive"] = "Posture défensive",
		["Defiance"] = "Défi",
		["Deflection"] = "Déviation",
		["Delusions of Jin'do"] = "Illusions de Jin'do",
		["Demon Armor"] = "Armure démoniaque",
		["Demon Skin"] = "Peau de démon",
		["Demonic Aegis"] = "Egide démoniaque",
		["Demonic Embrace"] = "Baiser démoniaque",
		["Demonic Frenzy"] = "Frénésie démoniaque",
		["Demonic Knowledge"] = "Connaissance démoniaque",
		["Demonic Resilience"] = "Résilience démoniaque",
		["Demonic Sacrifice"] = "Sacrifice démoniaque",
		["Demonic Tactics"] = "Tactique démoniaque",
		["Demoralizing Roar"] = "Rugissement démoralisant",
		["Demoralizing Shout"] = "Cri démoralisant",
		["Dense Sharpening Stone"] = "Pierre à aiguiser dense",
		["Desperate Prayer"] = "Prière du désespoir",
		["Destructive Reach"] = "Allonge de destruction",
		["Detect"] = "Détection",
		["Detect Greater Invisibility"] = "Détection de l'invisibilité supérieure",
		["Detect Invisibility"] = "Détection de l'invisibilité",
		["Detect Lesser Invisibility"] = "Détection de l'invisibilité inférieure",
		["Detect Magic"] = "Détection de la magie",
		["Detect Traps"] = "Détection des pièges",
		["Deterrence"] = "Dissuasion",
		["Devastate"] = "Dévaster",
		["Devastation"] = "Dévastation",
		["Devotion Aura"] = "Aura de dévotion",
		["Devour Magic"] = "Dévorer la magie",
		["Devour Magic Effect"] = "Effet dévorer la magie",
		["Devouring Plague"] = "Peste dévorante",
		["Diplomacy"] = "Diplomatie",
		["Dire Bear Form"] = "Forme d'ours redoutable",
		["Dirty Deeds"] = "Coups fourrés",
		["Dirty Tricks"] = "Coup tordu",
		["Disarm"] = "Désarmement",
		["Disarm Trap"] = "Désarmement de piège",
		["Disease Cleansing Totem"] = "Totem de Purification des maladies",
		["Disenchant"] = "Désenchanter",
		["Disengage"] = "Désengagement",
		["Dismiss Pet"] = "Renvoyer le familier",
		["Dispel Magic"] = "Dissipation de la magie",
		["Distract"] = "Distraction",
		["Distracting Shot"] = "Trait provocateur",
		["Dive"] = "Plongeon",
		["Divine Favor"] = "Faveur divine",
		["Divine Fury"] = "Fureur divine",
		["Divine Illumination"] = "Illumination divine",
		["Divine Intellect"] = "Intelligence divine",
		["Divine Intervention"] = "Intervention divine",
		["Divine Protection"] = "Protection divine",
		["Divine Shield"] = "Bouclier divin",
		["Divine Spirit"] = "Esprit divin",
		["Divine Strength"] = "Force divine",
		["Divine Wrath"] = "Courroux divin",
		["Dodge"] = "Esquiver",
		["Doomfire"] = "Feu funeste",
		["Dragon's Breath"] = "Souffle du dragon",
		["Dragonscale Leatherworking"] = "Travail du cuir d'écailles de dragon",
		["Drain Life"] = "Drain de vie",
		["Drain Mana"] = "Drain de mana",
		["Drain Soul"] = "Drain d'âme",
		["Dreamless Sleep"] = "Sommeil sans rêve",
		["Drink"] = "Boisson",
		["Dual Wield"] = "Ambidextrie",
		["Dual Wield Specialization"] = "Spécialisation Ambidextrie",
		["Duel"] = "Duel",
		["Dust Cloud"] = "Nuage de poussière",
		["Eagle Eye"] = "Oeil d'aigle",
		["Earth Elemental Totem"] = "Totem élémentaire de terre",
		["Earth Shield"] = "Bouclier de terre",
		["Earth Shock"] = "Horion de terre",
		["Earthbind"] = "Lien à la terre",
		["Earthbind Totem"] = "Totem de lien terrestre",
		["Earthstrike"] = "Choc de terre",
		["Efficiency"] = "Efficacité",
		["Elemental Devastation"] = "Dévastation élémentaire",
		["Elemental Focus"] = "Focalisation élémentaire",
		["Elemental Fury"] = "Fureur élémentaire",
		["Elemental Leatherworking"] = "Travail du cuir élémentaire",
		["Elemental Mastery"] = "Maîtrise élémentaire",
		["Elemental Precision"] = "Précision élémentaire",
		["Elemental Sharpening Stone"] = "Pierre à aiguiser élémentaire",
		["Elemental Weapons"] = "Armes élémentaires",
		["Elune's Grace"] = "Grâce d'Elune",
		["Elusiveness"] = "Insaisissable",
		["Emberstorm"] = "Tempête ardente",
		["Empowered Arcane Missiles"] = "Projectiles des arcanes surpuissants",
		["Empowered Corruption"] = "Corruption surpuissante",
		["Empowered Fireball"] = "Boule de feu surpuissante",
		["Empowered Frostbolt"] = "Eclair de givre surpuissant",
		["Empowered Healing"] = "Soins surpuissants",
		["Empowered Rejuvenation"] = "Récupération surpuissante",
		["Empowered Touch"] = "Toucher surpuissant",
		["Enamored Water Spirit"] = "Esprit de l'eau amoureux",
		["Enchanting"] = "Enchantement",
		["Endurance"] = "Endurance",
		["Endurance Training"] = "Entraînement à l'Endurance",
		["Engineering"] = "Ingénierie",
		["Engineering Specialization"] = "Spécialisation",
		["Enrage"] = "Enrager",
		["Enriched Manna Biscuit"] = "Biscuit enrichi en manne",
		["Enslave Demon"] = "Asservir démon",
		["Entangling Roots"] = "Sarments",
		["Entrapment"] = "Piège",
		["Envenom"] = "Envenimer",
		["Escape Artist"] = "Maître de l'évasion",
		["Evasion"] = "Evasion",
		["Eviscerate"] = "Eviscération",
		["Evocation"] = "Evocation",
		["Execute"] = "Exécution",
		["Exorcism"] = "Exorcisme",
		["Expansive Mind"] = "Pensée expansive",
		["Explosive Trap"] = "Piège explosif",
		["Explosive Trap Effect"] = "Effet Piège explosif",
		["Expose Armor"] = "Exposer l'armure",
		["Expose Weakness"] = "Perce-faille",
		["Extract Gas"] = "Extraction de gaz",
		["Eye for an Eye"] = "Oeil pour oeil",
		["Eye of Kilrogg"] = "Oeil de Kilrogg",
		["Eye of the Storm"] = "Oeil du cyclone",
		["Eyes of the Beast"] = "Oeil de la bête",
		["Fade"] = "Oubli",
		["Faerie Fire"] = "Lucioles",
		["Faerie Fire (Feral)"] = "Lucioles (farouche)",
		["Fanaticism"] = "Fanatisme",
		["Far Sight"] = "Double vue",
		["Fatal Attraction"] = "Liaison fatale",
		["Fear"] = "Peur",
		["Fear Ward"] = "Gardien de peur",
		["Feed Pet"] = "Nourrir le familier",
		["Feed Pet Effect"] = "Effet Nourrir le familier",
		["Feedback"] = "Réaction",
		["Feign Death"] = "Feindre la mort",
		["Feint"] = "Feinte",
		["Fel Armor"] = "Gangrarmure",
		["Fel Concentration"] = "Concentration corrompue",
		["Fel Domination"] = "Domination corrompue",
		["Fel Energy"] = "Energie corrompue",
		["Fel Intellect"] = "Intelligence corrompue",
		["Fel Rage"] = "Gangrerage",
		["Fel Stamina"] = "Endurance corrompue",
		["Felfire"] = "Gangrefeu",
		["Feline Grace"] = "Grâce féline",
		["Feral Aggression"] = "Agressivité farouche",
		["Feral Charge"] = "Charge farouche",
		["Feral Instinct"] = "Instinct farouche",
		["Feral Swiftness"] = "Célérité farouche",
		["Ferocious Bite"] = "Morsure féroce",
		["Ferocious Inspiration"] = "Inspiration féroce",
		["Ferocity"] = "Ferocité",
		["Fetish"] = "Fétiche",
		["Find Herbs"] = "Découverte d'herbes",
		["Find Minerals"] = "Découverte de gisements",
		["Find Treasure"] = "Découverte de trésors",
		["Find Weakness"] = "Découverte des faiblesses",
		["Fire Blast"] = "Trait de feu",
		["Fire Breath"] = "Souffle de feu",
		["Fire Elemental Totem"] = "Totem élémentaire de feu",
		["Fire Nova Totem"] = "Totem Nova de feu",
		["Fire Power"] = "Puissance du feu",
		["Fire Resistance"] = "Résistance au Feu",
		["Fire Resistance Aura"] = "Aura de résistance au Feu",
		["Fire Resistance Totem"] = "Totem de résistance au Feu",
		["Fire Shield"] = "Bouclier de feu",
		["Fire Vulnerability"] = "Vulnérabilité au Feu",
		["Fire Ward"] = "Gardien de feu",
		["Fire Weakness"] = "Sensibilité au Feu",
		["Fireball"] = "Boule de feu",
		["Firebolt"] = "Eclair de feu",
		["First Aid"] = "Premiers soins",
		["Fishing"] = "Pêche",
		["Fishing Poles"] = "Cannes à pêche",
		["Fist Weapon Specialization"] = "Spécialisation Arme de pugilat",
		["Fist Weapons"] = "Armes de pugilat",
		["Flame Shock"] = "Horion de flammes",
		["Flame Throwing"] = "Jet de flammes",
		["Flamestrike"] = "Choc de flammes",
		["Flamethrower"] = "Lance-flammes",
		["Flametongue Attack"] = "Attaque Langue de feu",
		["Flametongue Totem"] = "Totem Langue de feu",
		["Flametongue Weapon"] = "Arme Langue de feu",
		["Flare"] = "Fusée éclairante",
		["Flash Heal"] = "Soins rapides",
		["Flash of Light"] = "Eclair lumineux",
		["Flight Form"] = "Forme de vol",
		["Flurry"] = "Rafale",
		["Focused Casting"] = "Incantation focalisée",
		["Focused Mind"] = "Esprit focalisé",
		["Focused Power"] = "Puissance focalisée",
		["Focused Rage"] = "Rage focalisée",
		["Focused Starlight"] = "Lumière stellaire focalisée",
		["Food"] = "Nourriture",
		["Forbearance"] = "Longanimité",
		["Force of Nature"] = "Force de la nature",
		["Force of Will"] = "Force de volonté",
		["Freezing Trap"] = "Piège givrant",
		["Freezing Trap Effect"] = "Effet Piège givrant",
		["Frenzied Regeneration"] = "Régénération frénétique",
		["Frenzy"] = "Frénésie",
		["Frenzy Effect"] = "Effet de frénésie",
		["Frost Armor"] = "Armure de givre",
		["Frost Blast"] = "Trait de givre",
		["Frost Channeling"] = "Canalisation du givre",
		["Frost Nova"] = "Nova de givre",
		["Frost Resistance"] = "Résistance au Givre",
		["Frost Resistance Aura"] = "Aura de résistance au Givre",
		["Frost Resistance Totem"] = "Totem de résistance au Givre",
		["Frost Shock"] = "Horion de givre",
		["Frost Trap"] = "Piège de givre",
		["Frost Trap Aura"] = "Aura Piège de givre",
		["Frost Ward"] = "Gardien de givre",
		["Frost Warding"] = "Protection contre le Givre",
		["Frost Weakness"] = "Sensibilité au Givre",
		["Frostbite"] = "Morsure de givre",
		["Frostbolt"] = "Eclair de givre",
		["Frostbrand Attack"] = "Attaque Arme de givre",
		["Frostbrand Weapon"] = "Arme de givre",
		["Frozen Core"] = "Cœur de gel",
		["Furious Howl"] = "Hurlement furieux",
		["Furor"] = "Fureur",
		["Fury of the Crashing Waves"] = "Fureur des déferlantes",
		["Garrote"] = "Garrot",
		["Garrote - Silence"] = "Garrot - Silence",
		["Ghost Wolf"] = "Loup fantôme",
		["Ghostly Strike"] = "Frappe fantomatique",
		["Gift of Life"] = "Don de vie",
		["Gift of Nature"] = "Don de la Nature",
		["Gift of the Naaru"] = "Don des naaru",
		["Gift of the Wild"] = "Don du fauve",
		["Gouge"] = "Suriner",
		["Grace of Air"] = "Grâce aérienne",
		["Grace of Air Totem"] = "Totem de Grâce aérienne",
		["Great Stamina"] = "Endurance supérieure",
		["Greater Blessing of Kings"] = "Bénédiction des rois supérieure",
		["Greater Blessing of Light"] = "Bénédiction de lumière supérieure",
		["Greater Blessing of Might"] = "Bénédiction de puissance supérieure",
		["Greater Blessing of Salvation"] = "Bénédiction de salut supérieure",
		["Greater Blessing of Sanctuary"] = "Bénédiction du sanctuaire supérieure",
		["Greater Blessing of Wisdom"] = "Bénédiction de sagesse supérieure",
		["Greater Dreamless Sleep"] = "Sommeil sans rêve supérieur",
		["Greater Heal"] = "Soins supérieurs",
		["Grievous Throw"] = "Lancer effroyable",
		["Grim Reach"] = "Allonge sinistre",
		["Grounding Totem"] = "Totem de Glèbe",
		["Grounding Totem Effect"] = "Effet Totem de Glèbe",
		["Grovel"] = "Ramper",
		["Growl"] = "Grondement",
		["Guardian's Favor"] = "Faveur du Gardien",
		["Gun Specialization"] = "Spécialisation Armes à feu",
		["Guns"] = "Armes à feu",
		["Hammer of Justice"] = "Marteau de la justice",
		["Hammer of Wrath"] = "Marteau de courroux",
		["Hamstring"] = "Brise-genou",
		["Harass"] = "Harcèlement",
		["Hardiness"] = "Solidité",
		["Haste"] = "Hâte",
		["Hawk Eye"] = "Oeil de faucon",
		["Heal"] = "Soins",
		["Healing Focus"] = "Focalisation des soins",
		["Healing Light"] = "Lumière guérisseuse",
		["Healing Stream"] = "Guérisseur",
		["Healing Stream Totem"] = "Totem guérisseur",
		["Healing Touch"] = "Toucher guérisseur",
		["Healing Wave"] = "Vague de soins",
		["Healing Way"] = "Flots de soins",
		["Health Funnel"] = "Captation de vie",
		["Heart of the Wild"] = "Cœur de fauve",
		["Heavy Sharpening Stone"] = "Pierre à aiguiser lourde",
		["Hellfire"] = "Flammes infernales",
		["Hellfire Effect"] = "Effet Flammes infernales",
		["Hellfire Superiority"] = "Supériorité des Flammes infernales",
		["Hemorrhage"] = "Hémorragie",
		["Herb Gathering"] = "Cueillette",
		["Herbalism"] = "Herboristerie",
		["Heroic Strike"] = "Frappe héroïque",
		["Heroism"] = "Héroïsme",
		["Hex of Weakness"] = "Maléfice de faiblesse",
		["Hibernate"] = "Hibernation",
		["Holy Fire"] = "Flammes sacrées",
		["Holy Light"] = "Lumière sacrée",
		["Holy Nova"] = "Nova sacrée",
		["Holy Power"] = "Puissance sacrée",
		["Holy Reach"] = "Allonge du Sacré",
		["Holy Shield"] = "Bouclier sacré",
		["Holy Shock"] = "Horion sacré",
		["Holy Specialization"] = "Spécialisation",
		["Holy Vengeance"] = "Vengeance sacrée",
		["Holy Wrath"] = "Colère divine",
		["Honorless Target"] = "Cible sans honneur",
		["Horse Riding"] = "Equitation",
		["Howl of Terror"] = "Hurlement de terreur",
		["Humanoid Slaying"] = "Tueur d'humanoïdes",
		["Hunter's Mark"] = "Marque du chasseur",
		["Hurricane"] = "Ouragan",
		["Hypothermia"] = "Hypothermie",
		["Ice Armor"] = "Armure de glace",
		["Ice Barrier"] = "Barrière de glace",
		["Ice Block"] = "Bloc de glace",
		["Ice Floes"] = "Iceberg",
		["Ice Lance"] = "Javelot de glace",
		["Ice Shards"] = "Eclats de glace",
		["Ignite"] = "Enflammer",
		["Ignite Mana"] = "Enflammer le mana",
		["Illumination"] = "Illumination",
		["Immolate"] = "Immolation",
		["Immolation Trap"] = "Piège d'immolation",
		["Immolation Trap Effect"] = "Effet de Piège d'immolation",
		["Impact"] = "Impact",
		["Impale"] = "Empaler",
		["Impaling Spine"] = "Epine de perforation",
		["Improved Ambush"] = "Embuscade améliorée",
		["Improved Arcane Missiles"] = "Projectiles des arcanes améliorés",
		["Improved Arcane Shot"] = "Tir des arcanes amélioré",
		["Improved Aspect of the Hawk"] = "Aspect du faucon amélioré",
		["Improved Aspect of the Monkey"] = "Aspect du singe amélioré",
		["Improved Backstab"] = "Attaque sournoise améliorée",
		["Improved Barrage"] = "Barrage amélioré",
		["Improved Berserker Rage"] = "Rage berserker améliorée",
		["Improved Blessing of Might"] = "Bénédiction de puissance améliorée",
		["Improved Blessing of Wisdom"] = "Bénédiction de sagesse améliorée",
		["Improved Blink"] = "Transfert amélioré",
		["Improved Blizzard"] = "Blizzard amélioré",
		["Improved Bloodrage"] = "Rage sanguinaire améliorée",
		["Improved Chain Heal"] = "Salve de guérison améliorée",
		["Improved Chain Lightning"] = "Chaîne d'éclairs améliorée",
		["Improved Challenging Shout"] = "Cri de défi amélioré",
		["Improved Charge"] = "Charge améliorée",
		["Improved Cleave"] = "Enchaînement amélioré",
		["Improved Concentration Aura"] = "Aura de concentration améliorée",
		["Improved Concussive Shot"] = "Trait de choc amélioré",
		["Improved Cone of Cold"] = "Cône de froid amélioré",
		["Improved Corruption"] = "Corruption améliorée",
		["Improved Counterspell"] = "Contresort amélioré",
		["Improved Curse of Agony"] = "Malédiction d'agonie améliorée",
		["Improved Curse of Weakness"] = "Malédiction de faiblesse améliorée",
		["Improved Demoralizing Shout"] = "Cri démoralisant amélioré",
		["Improved Devotion Aura"] = "Aura de dévotion améliorée",
		["Improved Disarm"] = "Désarmement amélioré",
		["Improved Drain Life"] = "Drain de vie amélioré",
		["Improved Drain Soul"] = "Siphon d'âme amélioré",
		["Improved Enrage"] = "Enrager amélioré",
		["Improved Enslave Demon"] = "Asservir démon amélioré",
		["Improved Eviscerate"] = "Eviscération améliorée",
		["Improved Execute"] = "Exécution améliorée",
		["Improved Expose Armor"] = "Exposer l'armure amélioré",
		["Improved Eyes of the Beast"] = "Oeil de la bête amélioré",
		["Improved Fade"] = "Oubli amélioré",
		["Improved Feign Death"] = "Feindre la mort amélioré",
		["Improved Fire Blast"] = "Trait de feu amélioré",
		["Improved Fire Totems"] = "Totems de Feu améliorés",
		["Improved Fire Ward"] = "Gardien de feu amélioré",
		["Improved Fireball"] = "Boule de feu améliorée",
		["Improved Firebolt"] = "Eclair de feu amélioré",
		["Improved Flamestrike"] = "Choc de flammes amélioré",
		["Improved Flash of Light"] = "Eclair lumineux amélioré",
		["Improved Frost Nova"] = "Nova de givre améliorée",
		["Improved Frostbolt"] = "Eclair de givre amélioré",
		["Improved Ghost Wolf"] = "Loup fantôme amélioré",
		["Improved Gouge"] = "Suriner amélioré",
		["Improved Hammer of Justice"] = "Marteau de la justice amélioré",
		["Improved Hamstring"] = "Brise-genou amélioré",
		["Improved Healing"] = "Soin amélioré",
		["Improved Healing Touch"] = "Toucher guérisseur amélioré",
		["Improved Healing Wave"] = "Vague de soins améliorée",
		["Improved Health Funnel"] = "Captation de vie améliorée",
		["Improved Healthstone"] = "Pierre de soins améliorée",
		["Improved Heroic Strike"] = "Frappe héroïque améliorée",
		["Improved Holy Shield"] = "Bouclier sacré amélioré",
		["Improved Howl of Terror"] = "Hurlement de terreur amélioré",
		["Improved Hunter's Mark"] = "Marque du chasseur améliorée",
		["Improved Immolate"] = "Immolation améliorée",
		["Improved Imp"] = "Diablotin amélioré",
		["Improved Inner Fire"] = "Feu intérieur amélioré",
		["Improved Intercept"] = "Interception améliorée",
		["Improved Intimidating Shout"] = "Cri d’intimidation amélioré",
		["Improved Judgement"] = "Jugement amélioré",
		["Improved Kick"] = "Coup de pied amélioré",
		["Improved Kidney Shot"] = "Aiguillon perfide amélioré",
		["Improved Lash of Pain"] = "Fouet de la douleur amélioré",
		["Improved Lay on Hands"] = "Imposition des mains améliorée",
		["Improved Leader of the Pack"] = "Chef de la meute amélioré",
		["Improved Life Tap"] = "Connexion améliorée",
		["Improved Lightning Bolt"] = "Eclair amélioré",
		["Improved Lightning Shield"] = "Bouclier de foudre amélioré",
		["Improved Magma Totem"] = "Totem de Magma amélioré",
		["Improved Mana Burn"] = "Brûlure de mana améliorée",
		["Improved Mana Shield"] = "Bouclier de mana amélioré",
		["Improved Mana Spring Totem"] = "Totem Fontaine de mana amélioré",
		["Improved Mark of the Wild"] = "Marque du fauve améliorée",
		["Improved Mend Pet"] = "Guérison du familier améliorée",
		["Improved Mind Blast"] = "Attaque mentale améliorée",
		["Improved Moonfire"] = "Eclat lunaire amélioré",
		["Improved Mortal Strike"] = "Frappe mortelle améliorée",
		["Improved Nature's Grasp"] = "Emprise de la nature améliorée",
		["Improved Overpower"] = "Fulgurance améliorée",
		["Improved Power Word: Fortitude"] = "Mot de pouvoir : Robustesse amélioré",
		["Improved Power Word: Shield"] = "Mot de pouvoir : Bouclier amélioré",
		["Improved Prayer of Healing"] = "Prière de soins améliorée",
		["Improved Psychic Scream"] = "Cri psychique amélioré",
		["Improved Regrowth"] = "Rétablissement amélioré",
		["Improved Reincarnation"] = "Réincarnation améliorée",
		["Improved Rejuvenation"] = "Récupération améliorée",
		["Improved Rend"] = "Pourfendre amélioré",
		["Improved Renew"] = "Rénovation améliorée",
		["Improved Retribution Aura"] = "Aura de vindicte améliorée",
		["Improved Revenge"] = "Vengeance améliorée",
		["Improved Revive Pet"] = "Ressusciter le familier amélioré",
		["Improved Righteous Fury"] = "Fureur vertueuse améliorée",
		["Improved Rupture"] = "Rupture améliorée",
		["Improved Scorch"] = "Brûlure améliorée",
		["Improved Scorpid Sting"] = "Piqûre de scorpide améliorée",
		["Improved Seal of Righteousness"] = "Sceau de piété amélioré",
		["Improved Seal of the Crusader"] = "Sceau du Croisé amélioré",
		["Improved Searing Pain"] = "Douleur brûlante améliorée",
		["Improved Serpent Sting"] = "Morsure de serpent améliorée",
		["Improved Shadow Bolt"] = "Trait de l'ombre amélioré",
		["Improved Shadow Word: Pain"] = "Mot de l'ombre : Douleur amélioré",
		["Improved Shield Bash"] = "Coup de bouclier amélioré",
		["Improved Shield Block"] = "Maîtrise du blocage améliorée",
		["Improved Shield Wall"] = "Mur protecteur amélioré",
		["Improved Sinister Strike"] = "Attaque pernicieuse améliorée",
		["Improved Slam"] = "Heurtoir amélioré",
		["Improved Slice and Dice"] = "Débiter amélioré",
		["Improved Sprint"] = "Sprint amélioré",
		["Improved Stings"] = "Morsures et piqûres améliorées",
		["Improved Succubus"] = "Succube améliorée",
		["Improved Sunder Armor"] = "Fracasser armure amélioré",
		["Improved Taunt"] = "Provocation améliorée",
		["Improved Thunder Clap"] = "Coup de tonnerre amélioré",
		["Improved Tranquility"] = "Tranquillité améliorée",
		["Improved Vampiric Embrace"] = "Etreinte vampirique améliorée",
		["Improved Vanish"] = "Disparition améliorée",
		["Improved Voidwalker"] = "Marcheur du Vide amélioré",
		["Improved Weapon Totems"] = "Totems d'armes améliorés",
		["Improved Whirlwind"] = "Tourbillon amélioré",
		["Improved Wing Clip"] = "Coupure d'ailes améliorée",
		["Incinerate"] = "Incinérer",
		["Incineration"] = "Incinération",
		["Inferno"] = "Inferno",
		["Initiative"] = "Initiative",
		["Inner Fire"] = "Feu intérieur",
		["Inner Focus"] = "Focalisation améliorée",
		["Innervate"] = "Innervation",
		["Insect Swarm"] = "Essaim d'insectes",
		["Insidious Whisper"] = "Murmure insidieux",
		["Inspiration"] = "Inspiration",
		["Insignifigance"] = "Insignifiance",
		["Instant Poison"] = "Poison instantané",
		["Instant Poison II"] = "Poison instantané II",
		["Instant Poison III"] = "Poison instantané III",
		["Instant Poison IV"] = "Poison instantané IV",
		["Instant Poison V"] = "Poison instantané V",
		["Instant Poison VI"] = "Poison instantané VI",
		["Instant Poison VII"] = "Poison instantané VII",
		["Intensity"] = "Intensité",
		["Intercept"] = "Interception",
		["Intercept Stun"] = "Interception étourdissante",
		["Intervene"] = "Intervention",
		["Intimidating Shout"] = "Cri d’intimidation",
		["Intimidation"] = "Intimidation",
		["Invisibility"] = "Invisibilité",
		["Iron Will"] = "Volonté de fer",
		["Jewelcrafting"] = "Joaillerie",
		["Jom Gabbar"] = "Jom Gabbar",
		["Judgement"] = "Jugement",
		["Judgement of Blood"] = "Jugement de sang",
		["Judgement of Command"] = "Jugement d'autorité",
		["Judgement of Justice"] = "Jugement de justice",
		["Judgement of Light"] = "Jugement de lumière",
		["Judgement of Reckoning"] = "Jugement de vengeance",
		["Judgement of Righteousness"] = "Jugement de piété",
		["Judgement of Wisdom"] = "Jugement de sagesse",
		["Judgement of the Crusader"] = "Jugement du Croisé",
		["Kick"] = "Coup de pied",
		["Kick - Silenced"] = "Coup de pied - Silencieux",
		["Kidney Shot"] = "Aiguillon perfide",
		["Kill Command"] = "Ordre de tuer",
		["Killer Instinct"] = "Instinct du tueur",
		["Kiss of the Spider"] = "Baiser de l'araignée",
		["Kodo Riding"] = "Monte de kodo",
		["Lacerate"] = "Lacérer",
		["Lash of Pain"] = "Fouet de la douleur",
		["Last Stand"] = "Dernier rempart",
		["Lay on Hands"] = "Imposition des mains",
		["Leader of the Pack"] = "Chef de la meute",
		["Leather"] = "Cuir",
		["Leatherworking"] = "Travail du cuir",
		["Lesser Heal"] = "Soins inférieurs",
		["Lesser Healing Wave"] = "Vague de soins inférieurs",
		["Lesser Invisibility"] = "Invisibilité inférieure",
		["Lethal Shots"] = "Coups fatals",
		["Lethality"] = "Mortalité",
		["Levitate"] = "Lévitation",
		["Libram"] = "Libram",
		["Life Tap"] = "Connexion",
		["Lifebloom"] = "Fleur de vie",
		["Light's Grace"] = "Grâce de la lumière",
		["Lightning Bolt"] = "Eclair",
		["Lightning Breath"] = "Souffle de foudre",
		["Lightning Mastery"] = "Maîtrise de la foudre",
		["Lightning Reflexes"] = "Réflexes éclairs",
		["Lightning Shield"] = "Bouclier de foudre",
		["Lightning Speed"] = "Vitesse de l'éclair",
		["Lightwell"] = "Puits de lumière",
		["Lightwell Renew"] = "Rénovation du Puits de lumière",
		["Lockpicking"] = "Crochetage",
		["Long Daze"] = "Hébétement prolongé",
		["Lust for Battle"] = "Soif de bataille",
		["Mace Specialization"] = "Spécialisation Masse",
		["Mace Stun Effect"] = "Effet étourdissant de la masse",
		["Mage Armor"] = "Armure du mage",
		["Magic Absorption"] = "Absorption de magie",
		["Magic Attunement"] = "Harmonisation de la magie",
		["Magma Totem"] = "Totem de Magma",
		["Mail"] = "Mailles",
		["Maim"] = "Estropier",
		["Major Dreamless Sleep"] = "Sommeil sans rêve majeur",
		["Malediction"] = "Imprécation",
		["Malice"] = "Malice",
		["Mana Burn"] = "Brûlure de mana",
		["Mana Feed"] = "Festin de mana",
		["Mana Shield"] = "Bouclier de mana",
		["Mana Spring"] = "Fontaine de mana",
		["Mana Spring Totem"] = "Totem Fontaine de mana",
		["Mana Tap"] = "Ponction de mana",
		["Mana Tide"] = "Vague de mana",
		["Mana Tide Totem"] = "Totem de Vague de mana",
		["Mangle"] = "Mutilation",
		["Mangle (Bear)"] = "Mutilation (ours)",
		["Mangle (Cat)"] = "Mutilation (félin)",
		["Mark of the Wild"] = "Marque du fauve",
		["Martyrdom"] = "Martyre",
		["Mass Dispel"] = "Dissipation de masse",
		["Master Conjuror"] = "Maître conjurateur",
		["Master Demonologist"] = "Maître démonologue",
		["Master Summoner"] = "Maître invocateur",
		["Master Tactician"] = "Maître tacticien",
		["Master of Deception"] = "Maître des illusions",
		["Master of Elements"] = "Maître des éléments",
		["Master of Subtlety"] = "Maître de la discrétion",
		["Maul"] = "Mutiler",
		["Mechanostrider Piloting"] = "Pilotage de mécanotrotteur",
		["Meditation"] = "Méditation",
		["Melee Specialization"] = "Spécialisation Mêlée",
		["Melt Armor"] = "Fondre armure",
		["Mend Pet"] = "Guérison du familier",
		["Mental Agility"] = "Sagacité",
		["Mental Strength"] = "Force mentale",
		["Mind Blast"] = "Attaque mentale",
		["Mind Control"] = "Contrôle mental",
		["Mind Flay"] = "Fouet mental",
		["Mind Mastery"] = "Maîtrise mentale",
		["Mind Soothe"] = "Apaisement",
		["Mind Vision"] = "Vision télépathique",
		["Mind-numbing Poison"] = "Poison de distraction mentale",
		["Mind-numbing Poison II"] = "Poison de distraction mentale II",
		["Mind-numbing Poison III"] = "Poison de distraction mentale III",
		["Mining"] = "Minage",
		["Misdirection"] = "Détournement",
		["Misery"] = "Misère",
		["Mocking Blow"] = "Coup railleur",
		["Molten Armor"] = "Armure de la fournaise",
		["Molten Fury"] = "Sang de la fournaise",
		["Mongoose Bite"] = "Morsure de la mangouste",
		["Monster Slaying"] = "Tueur de monstres",
		["Moonfire"] = "Eclat lunaire",
		["Moonfury"] = "Fureur lunaire",
		["Moonglow"] = "Lueur de la lune",
		["Moonkin Aura"] = "Aura de sélénien",
		["Moonkin Form"] = "Forme de sélénien",
		["Mortal Shots"] = "Coups mortels",
		["Mortal Strike"] = "Frappe mortelle",
		["Multi-Shot"] = "Flèches multiples",
		["Murder"] = "Meurtre",
		["Mutilate"] = "Estropier",
		["Natural Armor"] = "Armure naturelle",
		["Natural Perfection"] = "Perfection naturelle",
		["Natural Shapeshifter"] = "Changeforme naturel",
		["Naturalist"] = "Naturaliste",
		["Nature Resistance"] = "Résistance à la Nature",
		["Nature Resistance Totem"] = "Totem de résistance à la Nature",
		["Nature Weakness"] = "Sensibilité à la Nature",
		["Nature's Focus"] = "Focalisation de la nature",
		["Nature's Grace"] = "Grâce de la nature",
		["Nature's Grasp"] = "Emprise de la nature",
		["Nature's Guidance"] = "Soutien de la nature",
		["Nature's Reach"] = "Allonge de la Nature",
		["Nature's Swiftness"] = "Rapidité de la nature",
		["Negative Charge"] = "Charge négative",
		["Nether Protection"] = "Protection du Néant",
		["Netherstorm Flag"] = "Drapeau de Raz-de-Néant",
		["Nightfall"] = "Crépuscule",
		["Nurturing Instinct"] = "Instinct Nourricier",
		["Omen of Clarity"] = "Augure de clarté",
		["One-Handed Axes"] = "Haches à une main",
		["One-Handed Maces"] = "Masses à une main",
		["One-Handed Swords"] = "Epées à une main",
		["One-Handed Weapon Specialization"] = "Spécialisation Arme 1M",
		["Opening"] = "Ouverture",
		["Opening - No Text"] = "Ouverture - pas de texte",
		["Opportunity"] = "Opportunité",
		["Overpower"] = "Fulgurance",
		["Pain Suppression"] = "Suppression de la douleur",
		["Panic"] = "Panique",
		["Paranoia"] = "Paranoïa",
		["Parasitic Shadowfiend"] = "Ombrefiel parasite",
		["Parry"] = "Parade",
		["Pathfinding"] = "Science des chemins",
		["Perceived Weakness"] = "Faiblesse perçue",
		["Perception"] = "Perception",
		["Permafrost"] = "Gel prolongé",
		["Pet Aggression"] = "Agressivité du familier",
		["Pet Hardiness"] = "Robustesse du familier",
		["Pet Recovery"] = "Rétablissement du familier",
		["Pet Resistance"] = "Résistance du familier",
		["Phase Shift"] = "Changement de phase",
		["Pick Lock"] = "Crochetage",
		["Pick Pocket"] = "Vol à la tire",
		["Piercing Howl"] = "Hurlement perçant",
		["Piercing Ice"] = "Glace perçante",
		["Plate Mail"] = "Armure en plaques",
		["Playing with Fire"] = "Jouer avec le feu",
		["Poison Cleansing Totem"] = "Totem de Purification du poison",
		["Poison Spit"] = "Crachat de poison",
		["Poisons"] = "Poisons",
		["Polearms"] = "Armes d'hast",
		["Poleaxe Specialization"] = "Spécialisation Arme d'hast",
		["Polymorph"] = "Métamorphose",
		["Polymorph: Pig"] = "Métamorphose : cochon",
		["Polymorph: Turtle"] = "Métamorphose : tortue",
		["Portal: Darnassus"] = "Portail : Darnassus",
		["Portal: Exodar"] = "Portail : Exodar",
		["Portal: Ironforge"] = "Portail : Forgefer",
		["Portal: Orgrimmar"] = "Portail : Orgrimmar",
		["Portal: Shattrath"] = "Portail : Shattrath",
		["Portal: Silvermoon"] = "Portail : Lune-d'argent",
		["Portal: Stormwind"] = "Portail : Hurlevent",
		["Portal: Thunder Bluff"] = "Portail : les Pitons du Tonnerre",
		["Portal: Undercity"] = "Portail : Fossoyeuse",
		["Positive Charge"] = "Charge positive",
		["Pounce"] = "Traquenard",
		["Pounce Bleed"] = "Traquenard sanglant",
		["Power Infusion"] = "Infusion de puissance",
		["Power Word: Fortitude"] = "Mot de pouvoir : Robustesse",
		["Power Word: Shield"] = "Mot de pouvoir : Bouclier",
		["Prayer of Fortitude"] = "Prière de robustesse",
		["Prayer of Healing"] = "Prière de soins",
		["Prayer of Mending"] = "Prière de guérison",
		["Prayer of Shadow Protection"] = "Prière de protection contre l'Ombre",
		["Prayer of Spirit"] = "Prière d'Esprit",
		["Precision"] = "Précision",
		["Predatory Instincts"] = "Instincts de prédateur",
		["Predatory Strikes"] = "Frappes de prédateur",
		["Premeditation"] = "Préméditation",
		["Preparation"] = "Préparation",
		["Presence of Mind"] = "Présence spirituelle",
		["Primal Fury"] = "Fureur primitive",
		["Prismatic Cloak"] = "Cape prismatique",
		["Prospecting"] = "Prospection",
		["Prowl"] = "Rôder",
		["Psychic Scream"] = "Cri psychique",
		["Pummel"] = "Volée de coups",
		["Purge"] = "Expiation",
		["Purification"] = "Purification",
		["Purify"] = "Purification",
		["Purifying Power"] = "Puissance purifiante",
		["Pursuit of Justice"] = "Poursuite de la justice",
		["Pyroblast"] = "Explosion pyrotechnique",
		["Pyroclasm"] = "Pyroclasme",
		["Pyromaniac"] = "Pyromane",
		["Quick Recovery"] = "Rétablissement rapide",
		["Quick Shots"] = "Tir rapide",
		["Quickness"] = "Rapidité",
		["Rage of the Unraveller"] = "Rage du détrameur",
		["Rain of Fire"] = "Pluie de feu",
		["Rake"] = "Griffure",
		["Ram Riding"] = "Monte de bélier",
		["Rampage"] = "Saccager",
		["Ranged Weapon Specialization"] = "Spécialisation Armes à distance",
		["Rapid Fire"] = "Tir rapide",
		["Rapid Killing"] = "Tueur rapide",
		["Raptor Riding"] = "Monte de raptor",
		["Raptor Strike"] = "Attaque du raptor",
		["Ravage"] = "Ravage",
		["Readiness"] = "Promptitude",
		["Rebirth"] = "Renaissance",
		["Reckless Charge"] = "Charge furieuse",
		["Recklessness"] = "Témérité",
		["Reckoning"] = "Rétribution",
		["Redemption"] = "Rédemption",
		["Redoubt"] = "Redoute",
		["Reflection"] = "Renvoi",
		["Regeneration"] = "Régénération",
		["Regrowth"] = "Rétablissement",
		["Reincarnation"] = "Réincarnation",
		["Reinforced Shield"] = "Bouclier renforcé",
		["Rejuvenation"] = "Récupération",
		["Relentless Strikes"] = "Frappes implacables",
		["Remorseless"] = "Impitoyable",
		["Remorseless Attacks"] = "Attaques impitoyables",
		["Remote Toy"] = "Jouet à distance",
		["Remove Curse"] = "Délivrance de la malédiction",
		["Remove Insignia"] = "Enlever l'insigne",
		["Remove Lesser Curse"] = "Délivrance de la malédiction mineure",
		["Rend"] = "Pourfendre",
		["Renew"] = "Rénovation",
		["Repentance"] = "Repentir",
		["Restless Strength"] = "Force inconstante",
		["Restorative Totems"] = "Totems de restauration",
		["Resurrection"] = "Résurrection",
		["Retaliation"] = "Représailles",
		["Retribution Aura"] = "Aura de vindicte",
		["Revenge"] = "Vengeance",
		["Revenge Stun"] = "Etourdissement vengeur",
		["Reverberation"] = "Réverbération",
		["Revive Pet"] = "Ressusciter le familier",
		["Righteous Defense"] = "Défense vertueuse",
		["Righteous Fury"] = "Fureur vertueuse",
		["Rip"] = "Déchirure",
		["Riposte"] = "Riposte",
		["Ritual of Doom"] = "Rituel de malédiction",
		["Ritual of Doom Effect"] = "Effet Rituel de malédiction",
		["Ritual of Refreshment"] = "Rituel des rafraîchissements",
		["Ritual of Souls"] = "Rituel des âmes",
		["Ritual of Summoning"] = "Rituel d'invocation",
		["Rockbiter Weapon"] = "Arme Croque-roc",
		["Rough Sharpening Stone"] = "Pierre à aiguiser brute",
		["Ruin"] = "Ruine",
		["Rupture"] = "Rupture",
		["Ruthlessness"] = "Némésis",
		["Sacrifice"] = "Sacrifice",
		["Safe Fall"] = "Chute amortie",
		["Sanctified Crusader"] = "Croisé sanctifié",
		["Sanctified Judgement"] = "Jugement sanctifié",
		["Sanctified Light"] = "Lumière sanctifiée",
		["Sanctity Aura"] = "Aura de sainteté",
		["Sap"] = "Assommer",
		["Savage Fury"] = "Furie sauvage",
		["Savage Strikes"] = "Frappes sauvages",
		["Scare Beast"] = "Effrayer une bête",
		["Scatter Shot"] = "Flèche de dispersion",
		["Scorch"] = "Brûlure",
		["Scorpid Poison"] = "Poison de scorpide",
		["Scorpid Sting"] = "Piqûre de scorpide",
		["Screech"] = "Hurlement",
		["Seal Fate"] = "Scelle le destin",
		["Seal of Blood"] = "Sceau de sang",
		["Seal of Command"] = "Sceau d'autorité",
		["Seal of Justice"] = "Sceau de justice",
		["Seal of Light"] = "Sceau de lumière",
		["Seal of Righteousness"] = "Sceau de piété",
		["Seal of Vengeance"] = "Sceau de vengeance",
		["Seal of Wisdom"] = "Sceau de sagesse",
		["Seal of the Crusader"] = "Sceau du Croisé",
		["Searing Light"] = "Lumière incendiaire",
		["Searing Pain"] = "Douleur brûlante",
		["Searing Totem"] = "Totem incendiaire",
		["Second Wind"] = "Second souffle",
		["Seduction"] = "Séduction",
		["Seed of Corruption"] = "Graine de Corruption",
		["Seethe"] = "Bouillant de rage",
		["Sense Demons"] = "Détection des démons",
		["Sense Undead"] = "Détection des morts-vivants",
		["Sentry Totem"] = "Totem Sentinelle",
		["Serpent Sting"] = "Morsure de serpent",
		["Serrated Blades"] = "Lames dentelées",
		["Setup"] = "Préparatifs",
		["Shackle Undead"] = "Entraves des morts-vivants",
		["Shadow Affinity"] = "Affinité avec l'ombre",
		["Shadow Bolt"] = "Trait de l'ombre",
		["Shadow Embrace"] = "Etreinte de l'ombre",
		["Shadow Focus"] = "Focalisation de l'ombre",
		["Shadow Mastery"] = "Maîtrise de l'ombre",
		["Shadow Power"] = "Puissance de l'ombre",
		["Shadow Protection"] = "Protection contre l'Ombre",
		["Shadow Reach"] = "Allonge de l'Ombre",
		["Shadow Resistance"] = "Résistance à l'Ombre",
		["Shadow Resistance Aura"] = "Aura de résistance à l'Ombre",
		["Shadow Trance"] = "Transe de l'ombre",
		["Shadow Vulnerability"] = "Vulnérabilité à l'Ombre",
		["Shadow Ward"] = "Gardien de l'ombre",
		["Shadow Weakness"] = "Sensibilité à l'Ombre",
		["Shadow Weaving"] = "Tissage de l'ombre",
		["Shadow Word: Death"] = "Mot de l'ombre : Mort",
		["Shadow Word: Pain"] = "Mot de l'ombre : Douleur",
		["Shadow and Flame"] = "Ombre et flammes",
		["Shadow of Death"] = "Ombre de la mort",
		["Shadowburn"] = "Brûlure de l'ombre",
		["Shadowfiend"] = "Ombrefiel",
		["Shadowform"] = "Forme d'Ombre",
		["Shadowfury"] = "Furie de l'ombre",
		["Shadowguard"] = "Garde de l'ombre",
		["Shadowmeld"] = "Camouflage dans l'ombre",
		["Shadowmeld Passive"] = "Camouflage dans l'ombre",
		["Shadowstep"] = "Pas de l'ombre",
		["Shamanistic Rage"] = "Rage du chaman",
		["Sharpened Claws"] = "Griffes aiguisées",
		["Shatter"] = "Fracasser",
		["Shear"] = "Tonte",
		["Shell Shield"] = "Carapace bouclier",
		["Shield"] = "Bouclier",
		["Shield Bash"] = "Coup de bouclier",
		["Shield Bash - Silenced"] = "Coup de bouclier - silencieux",
		["Shield Block"] = "Maîtrise du blocage",
		["Shield Slam"] = "Heurt de bouclier",
		["Shield Specialization"] = "Spécialisation Bouclier",
		["Shield Wall"] = "Mur protecteur",
		["Shiv"] = "Kriss",
		["Shoot"] = "Tir",
		["Shoot Bow"] = "Tir à l'arc",
		["Shoot Gun"] = "Tir avec une arme à feu",
		["Shred"] = "Lambeau",
		["Shredding Attacks"] = "Attaques lacérantes",
		["Silence"] = "Silence",
		["Silencing Shot"] = "Flèche-baîllon",
		["Silent Resolve"] = "Résolution silencieuse",
		["Silverwing Flag"] = "Drapeau d'Aile-argent",
		["Sinister Strike"] = "Attaque pernicieuse",
		["Siphon Life"] = "Siphon de vie",
		["Skinning"] = "Dépeçage",
		["Slam"] = "Heurtoir",
		["Slayer's Crest"] = "Blason de tueur",
		["Sleep"] = "Sommeil",
		["Slice and Dice"] = "Débiter",
		["Slow"] = "Lenteur",
		["Slow Fall"] = "Chute lente",
		["Smelting"] = "Fondre",
		["Smite"] = "Châtiment",
		["Snake Trap"] = "Piège à serpent",
		["Solid Sharpening Stone"] = "Pierre à aiguiser solide",
		["Sonic Burst"] = "Explosion sonore",
		["Soothe Animal"] = "Apaiser les animaux",
		["Soothing Kiss"] = "Baiser apaisant",
		["Soul Fire"] = "Feu de l'âme",
		["Soul Leech"] = "Suceur d'âme",
		["Soul Link"] = "Lien spirituel",
		["Soul Siphon"] = "Siphon d'âme",
		["Soulshatter"] = "Brise-âme",
		["Soulstone Resurrection"] = "Résurrection de Pierre d'âme",
		["Spell Haste"] = "Hâte des sorts",
		["Spell Lock"] = "Verrou magique",
		["Spell Power"] = "Puissance des sorts",
		["Spell Reflection"] = "Renvoi de sort",
		["Spell Vulnerability"] = "Vulnérabilité aux sorts",
		["Spell Warding"] = "Protection contre les sorts",
		["Spellsteal"] = "Vol de sort",
		["Spirit Bond"] = "Engagement spirituel",
		["Spirit Tap"] = "Connexion spirituelle",
		["Spirit of Redemption"] = "Esprit de rédemption",
		["Spiritual Attunement"] = "Harmonisation spirituelle",
		["Spiritual Focus"] = "Focalisation spirituelle",
		["Spiritual Guidance"] = "Direction spirituelle",
		["Spiritual Healing"] = "Soins spirituels",
		["Spiteful Fury"] = "Fureur malveillante",
		["Sprint"] = "Sprint",
		["Stance Mastery"] = "Maîtrise des postures",
		["Starfire"] = "Feu stellaire",
		["Starfire Stun"] = "Feu stellaire étourdissant",
		["Starlight Wrath"] = "Colère stellaire",
		["Starshards"] = "Eclats stellaires",
		["Static Charge"] = "Charge statique",
		["Staves"] = "Bâtons",
		["Steady Shot"] = "Tir assuré",
		["Stealth"] = "Camouflage",
		["Stoneclaw Stun"] = "Etourdissement de Griffes de pierre",
		["Stoneclaw Totem"] = "Totem de Griffes de pierre",
		["Stoneform"] = "Forme de pierre",
		["Stoneskin"] = "Peau de pierre",
		["Stoneskin Totem"] = "Totem de Peau de pierre",
		["Stormstrike"] = "Courroux naturel",
		["Strength of Earth"] = "Force de la Terre",
		["Strength of Earth Totem"] = "Totem de Force de la Terre",
		["Strength of the Halaani"] = "Force des Halaani",
		["Stuck"] = "Bloqué",
		["Stun"] = "Etourdi",
		["Subtlety"] = "Discrétion",
		["Suffering"] = "Souffrance",
		["Summon Charger"] = "Invocation de destrier",
		["Summon Dreadsteed"] = "Invocation d'un destrier de l'effroi",
		["Summon Felguard"] = "Invocation d'un gangregarde",
		["Summon Felhunter"] = "Invocation d'un chasseur corrompu",
		["Summon Felsteed"] = "Invocation d'un palefroi corrompu",
		["Summon Imp"] = "Invocation d'un diablotin",
		["Summon Succubus"] = "Invocation d'une succube",
		["Summon Voidwalker"] = "Invocation d'un marcheur du Vide",
		["Summon Warhorse"] = "Invocation d'un cheval de guerre",
		["Summon Water Elemental"] = "Invocation d'un élémentaire d'eau",
		["Sunder Armor"] = "Fracasser armure",
		["Suppression"] = "Suppression",
		["Surefooted"] = "Pied sûr",
		["Surge of Light"] = "Vague de lumière",
		["Surprise Attacks"] = "Attaques surprises",
		["Survivalist"] = "Survivant",
		["Sweeping Strikes"] = "Attaques circulaires",
		["Swift Flight Form"] = "Forme de vol rapide",
		["Swiftmend"] = "Prompte guérison",
		["Swipe"] = "Balayage",
		["Sword Specialization"] = "Spécialisation Epée",
		["Symbol of Hope"] = "Symbole d'espoir",
		["Tactical Mastery"] = "Maître tacticien",
		["Tailoring"] = "Couture",
		["Tainted Blood"] = "Corruption sanguine",
		["Tainted Mind"] = "Esprit corrompu",
		["Tame Beast"] = "Dompte une bête",
		["Taunt"] = "Provocation",
		["Teleport: Darnassus"] = "Téléportation : Darnassus",
		["Teleport: Exodar"] = "Téléportation : Exodar",
		["Teleport: Ironforge"] = "Téléportation : Forgefer",
		["Teleport: Moonglade"] = "Téléportation : Reflet-de-Lune",
		["Teleport: Orgrimmar"] = "Téléportation : Orgrimmar",
		["Teleport: Shattrath"] = "Téléportation : Shattrath",
		["Teleport: Silvermoon"] = "Téléportation : Lune-d'argent",
		["Teleport: Stormwind"] = "Téléportation : Hurlevent",
		["Teleport: Thunder Bluff"] = "Téléportation : les Pitons du Tonnerre",
		["Teleport: Undercity"] = "Téléportation : Fossoyeuse",
		["Temporal Rift"] = "Faille temporelle",
		["The Beast Within"] = "La bête intérieure",
		["The Human Spirit"] = "L'esprit humain",
		["Thick Hide"] = "Peau épaisse",
		["Thorns"] = "Epines",
		["Thrill of the Hunt"] = "Frisson de la chasse",
		["Throw"] = "Lancer",
		["Throwing Specialization"] = "Spécialisation Armes de jet",
		["Thrown"] = "Armes de jet",
		["Thunder Clap"] = "Coup de tonnerre",
		["Thunderfury"] = "Lame-tonnerre",
		["Thundering Strikes"] = "Frappe foudroyante",
		["Thunderstomp"] = "Grondeterre",
		["Tidal Focus"] = "Focalisation des flots",
		["Tidal Mastery"] = "Maîtrise des flots",
		["Tiger Riding"] = "Monte de tigre",
		["Tiger's Fury"] = "Fureur du tigre",
		["Time's Favor"] = "Faveur du temps",
		["Torment"] = "Tourment",
		["Totem"] = "Totem",
		["Totem of Wrath"] = "Totem de courroux",
		["Totemic Call"] = "Appel totémique",
		["Totemic Focus"] = "Focalisation totémique",
		["Touch of Shadow"] = "Toucher de l'ombre",
		["Touch of Weakness"] = "Toucher de faiblesse",
		["Toughness"] = "Résistance",
		["Traces of Silithyst"] = "Traces de silithyste",
		["Track Beasts"] = "Pistage des bêtes",
		["Track Demons"] = "Pistage des démons",
		["Track Dragonkin"] = "Pistage des draconiens",
		["Track Elementals"] = "Pistage des élémentaires",
		["Track Giants"] = "Pistage des géants",
		["Track Hidden"] = "Pistage des camouflés",
		["Track Humanoids"] = "Pistage des humanoïdes",
		["Track Undead"] = "Pistage des morts-vivants",
		["Tranquil Air"] = "Tranquillité de l'air",
		["Tranquil Air Totem"] = "Totem de Tranquillité de l'air",
		["Tranquil Spirit"] = "Tranquillité de l'esprit",
		["Tranquility"] = "Tranquillité",
		["Tranquilizing Shot"] = "Tir tranquillisant",
		["Trap Mastery"] = "Maîtrise des pièges",
		["Travel Form"] = "Forme de voyage",
		["Tree of Life"] = "Arbre de vie",
		["Tremor Totem"] = "Totem de Séisme",
		["Tribal Leatherworking"] = "Travail du cuir tribal",
		["Trueshot Aura"] = "Aura de précision",
		["Turn Undead"] = "Renvoi des morts-vivants",
		["Twin Spire Blessing"] = "Bénédiction des flèches jumelles",
		["Two-Handed Axes"] = "Haches à deux mains",
		["Two-Handed Axes and Maces"] = "Haches et masses à deux mains",
		["Two-Handed Maces"] = "Masses à deux mains",
		["Two-Handed Swords"] = "Epées à deux mains",
		["Two-Handed Weapon Specialization"] = "Spécialisation Arme 2M",
		["Unarmed"] = "Mains nues",
		["Unbreakable Will"] = "Volonté inflexible",
		["Unbridled Wrath"] = "Colère déchaînée",
		["Undead Horsemanship"] = "Monte de cheval squelette",
		["Underwater Breathing"] = "Respiration aquatique",
		["Unending Breath"] = "Respiration interminable",
		["Unholy Power"] = "Puissance impie",
		["Unleashed Fury"] = "Fureur libérée",
		["Unleashed Rage"] = "Rage libérée",
		["Unstable Affliction"] = "Affliction instable",
		["Unstable Power"] = "Puissance instable",
		["Unyielding Faith"] = "Foi inflexible",
		["Upset Tummy"] = "Mal au ventre",
		["Vampiric Embrace"] = "Etreinte vampirique",
		["Vampiric Touch"] = "Toucher vampirique",
		["Vanish"] = "Disparition",
		["Vanished"] = "Invisible",
		["Vengeance"] = "Vengeance",
		["Venomous Totem"] = "Totem venimeux",
		["Victory Rush"] = "Ivresse de la victoire",
		["Vigor"] = "Vigueur",
		["Vile Beam"] = "Rayon abominable",
		["Vile Poisons"] = "Poisons abominables",
		["Vindication"] = "Justification",
		["Viper Sting"] = "Morsure de vipère",
		["Volley"] = "Salve",
		["Wand Specialization"] = "Spécialisation Baguette",
		["Wands"] = "Baguettes",
		["War Stomp"] = "Choc martial",
		["Warp"] = "Distorsion",
		["Warsong Flag"] = "Drapeau Chanteguerre",
		["Water Breathing"] = "Respiration aquatique",
		["Water Shield"] = "Bouclier d'eau",
		["Water Tomb"] = "Tombe aquatique",
		["Water Walking"] = "Marcher sur l’eau",
		["Waterbolt"] ="Eclair d'eau",
		["Watery Grave"] = "Tombeau aquatique",
		["Weakened Soul"] = "Ame affaiblie",
		["Weapon Mastery"] = "Maîtrise des armes",
		["Weaponsmith"] = "Fabricant d'armes",
		["Well Fed"] = "Bien nourri",
		["Whirlwind"] = "Tourbillon",
		["Will of the Forsaken"] = "Volonté des Réprouvés",
		["Windfury"] = "Furie-des-vents",
		["Windfury Attack"] = "Attaque Furie-des-vents",
		["Windfury Totem"] = "Totem Furie-des-vents",
		["Windfury Weapon"] = "Arme Furie-des-vents",
		["Windwall"] = "Mur des vents",
		["Windwall Totem"] = "Totem de Mur des vents",
		["Wing Clip"] = "Coupure d'ailes",
		["Winter's Chill"] = "Froid hivernal",
		["Wisp Spirit"] = "Esprit feu follet",
		["Wolf Riding"] = "Monte de loup",
		["Wound Poison"] = "Poison douloureux",
		["Wound Poison II"] = "Poison douloureux II",
		["Wound Poison III"] = "Poison douloureux III",
		["Wound Poison IV"] = "Poison douloureux IV",
		["Wound Poison V"] = "Poison douloureux V",
		["Wrath"] = "Colère",
		["Wrath of Air Totem"] = "Totem de courroux de l'air",
		["Wrath of Cenarius"] = "Colère de Cénarius",
		["Wrath of the Astromancer"] = "Courroux de l'Astromancien",
		["Wyvern Sting"] = "Piqûre de wyverne",
	}
end)

BabbleSpell:RegisterTranslations("zhCN", function()
	return {
		["Abolish Disease"] = "驱除疾病",
		["Abolish Poison"] = "驱毒术",
		["Abolish Poison Effect"] = "驱毒术效果",
		["Activate MG Turret"] = "发射MGs",--启动炮台
		["Adrenaline Rush"] = "冲动",
		["Aftermath"] = "清算",
		["Aggression"] = "侵犯",
		["Agonizing Flames"] = "苦痛之焰",
		["Aimed Shot"] = "瞄准射击",
		["Alchemy"] = "炼金术",
		["Ambush"] = "伏击",
		["Amplify Curse"] = "诅咒增幅",
		["Amplify Magic"] = "魔法增效",
		["Ancestral Fortitude"] = "先祖坚韧",
		["Ancestral Healing"] = "先祖治疗",
		["Ancestral Knowledge"] = "先祖知识",
		["Ancestral Spirit"] = "先祖之魂",
		["Ancient Hysteria"] = "上古狂乱",
		["Anesthetic Poison"] = "麻醉药膏",
		["Anger Management"] = "愤怒掌控",
		["Anguish"] = "痛楚",
		["Anticipation"] = "预知",
		["Aquatic Form"] = "水栖形态",
		["Arcane Blast"] = "奥术冲击",
		["Arcane Brilliance"] = "奥术光辉",
		["Arcane Concentration"] = "奥术专注",
		["Arcane Energy"] = "奥术能量",
		["Arcane Explosion"] = "魔爆术",
		["Arcane Focus"] = "奥术集中",
		["Arcane Fortitude"] = "奥术坚韧",
		["Arcane Impact"] = "奥术冲击",
		["Arcane Instability"] = "奥术增效",
		["Arcane Intellect"] = "奥术智慧",
		["Arcane Meditation"] = "奥术冥想",
		["Arcane Mind"] = "奥术心智",
		["Arcane Missiles"] = "奥术飞弹",
		["Arcane Potency"] = "奥术潜能",
		["Arcane Power"] = "奥术强化",
		["Arcane Resistance"] = "奥术抗性",
		["Arcane Shot"] = "奥术射击",
		["Arcane Shroud"] = "奥术环绕",
		["Arcane Subtlety"] = "奥术精妙",
		["Arcane Torrent"] = "奥术洪流",
		["Arcane Weakness"] = "奥术虚弱",
		["Arctic Reach"] = "极寒延伸",
		["Arctic Winds"] = "极寒之风",
		["Armor of Faith"] = "信仰",
		["Armorsmith"] = "防具锻造",
		["Aspect of the Beast"] = "野兽守护",
		["Aspect of the Cheetah"] = "猎豹守护",
		["Aspect of the Hawk"] = "雄鹰守护",
		["Aspect of the Monkey"] = "灵猴守护",
		["Aspect of the Pack"] = "豹群守护",
		["Aspect of the Viper"] = "蝰蛇守护",
		["Aspect of the Wild"] = "野性守护",
		["Astral Recall"] = "星界传送",
		["Attack"] = "攻击",
		["Attacking"] = "攻击",
		["Auto Shot"] = "自动射击",
		["Avenger's Shield"] = "复仇者之盾",
		["Avenging Wrath"] = "复仇之怒",
		["Avoidance"] = "躲避",
		["Axe Specialization"] = "斧专精",
		["Backlash"] = "反冲",
		["Backstab"] = "背刺",
		["Badge of the Swarmguard"] = "虫群卫士徽章",
		["Balance of Power"] = "能量平衡",
		["Bane"] = "灾祸",
		["Banish"] = "放逐术",
		["Banshee Curse"] = "女妖诅咒",
		["Barkskin"] = "树皮术",
		["Barrage"] = "弹幕",
		["Bash"] = "猛击",
		["Basic Campfire"] = "基础营火",
		["Battle Rush"] = "战斗冲刺",
		["Battle Shout"] = "战斗怒吼",
		["Battle Stance"] = "战斗姿态",
		["Battle Stance Passive"] = "战斗姿态（被动）",
		["Bear Form"] = "熊形态",
		["Beast Lore"] = "野兽知识",
		["Beast Slaying"] = "野兽杀手",
		["Beast Training"] = "训练野兽",
		["Benediction"] = "祈福",
		["Berserker Rage"] = "狂暴之怒",
		["Berserker Stance"] = "狂暴姿态",
		["Berserker Stance Passive"] = "狂暴姿态（被动）",
		["Berserking"] = "狂暴",
		["Bestial Discipline"] = "野兽戒律",
		["Bestial Swiftness"] = "野兽迅捷",
		["Bestial Wrath"] = "狂野怒火",
		["Binding Heal"] = "联结治疗",
		["Bite"] = "撕咬",
		["Black Arrow"] = "黑箭",
		["Blackout"] = "昏阙",
		["Blacksmithing"] = "锻造",
		["Blade Flurry"] = "剑刃乱舞",
		["Blade Turning"] = "剑刃扭转",
		["Blade Twisting"] = "利刃漩涡",
		["Blast Wave"] = "冲击波",
		["Blazing Speed"] = "炽热疾速",
		["Blessed Recovery"] = "神恩回复",
		["Blessed Resilience"] = "神佑之韧",
		["Blessing of Auchindoun"] = "奥金顿的祝福",
		["Blessing of Freedom"] = "自由祝福",
		["Blessing of Kings"] = "王者祝福",
		["Blessing of Light"] = "光明祝福",
		["Blessing of Might"] = "力量祝福",
		["Blessing of Protection"] = "保护祝福",
		["Blessing of Sacrifice"] = "牺牲祝福",
		["Blessing of Salvation"] = "拯救祝福",
		["Blessing of Sanctuary"] = "庇护祝福",
		["Blessing of Wisdom"] = "智慧祝福",
		["Blind"] = "致盲",
		["Blinding Powder"] = "致盲粉",
		["Blink"] = "闪现术",
		["Blizzard"] = "暴风雪",
		["Block"] = "格挡",
		["Blood Craze"] = "血之狂热",
		["Blood Frenzy"] = "血之狂暴",
		["Blood Fury"] = "血性狂暴",
		["Blood Pact"] = "血之契印",
		["Bloodlust"] = "嗜血",
		["Bloodrage"] = "血性狂暴",
		["Bloodthirst"] = "嗜血",
		["Boar Charge"] = "野猪冲撞",
		["Booming Voice"] = "震耳嗓音",
		["Bow Specialization"] = "弓箭专精",
		["Bows"] = "弓",
		["Bright Campfire"] = "明亮篝火",
		["Brittle Armor"] = "脆弱护甲",
		["Brutal Impact"] = "野蛮冲撞",
		["Burning Adrenaline"] = "燃烧刺激",
		["Burning Soul"] = "燃烧之魂",
		["Burning Wish"] = "燃烧之愿",
		["Call Pet"] = "召唤宠物",
		["Call of Flame"] = "烈焰召唤",
		["Call of Thunder"] = "雷霆召唤",
		["Call of the Nexus"] = "节点召唤",
		["Camouflage"] = "伪装",
		["Cannibalize"] = "食尸",
		["Cat Form"] = "猎豹形态",
		["Cataclysm"] = "灾变",
		["Celestial Focus"] = "星空专注",
		["Chain Heal"] = "治疗链",
		["Chain Lightning"] = "闪电链",
		["Challenging Roar"] = "挑战咆哮",
		["Challenging Shout"] = "挑战怒吼",
		["Charge"] = "冲锋",
		["Charge Rage Bonus Effect"] = "冲锋怒气加成效果",
		["Charge Stun"] = "冲锋击昏",
		["Chastise"] = "责罚",
		["Cheap Shot"] = "偷袭",
		["Chilled"] = "冰冻",
		["Circle of Healing"] = "治疗之环",
		["Claw"] = "爪击",
		["Cleanse"] = "清洁术",
		["Clearcasting"] = "节能施法",
		["Cleave"] = "顺劈斩",
		["Clever Traps"] = "灵巧陷阱",
		["Cloak of Shadows"] = "暗影斗篷",
		["Closing"] = "关闭",
		["Cloth"] = "布甲",
		["Coarse Sharpening Stone"] = "粗制磨刀石",
		["Cobra Reflexes"] = "毒蛇反射",
		["Cold Blood"] = "冷血",
		["Cold Snap"] = "急速冷却",
		["Combat Endurance"] = "作战持久",
		["Combustion"] = "燃烧",
		["Command"] = "命令",
		["Commanding Presence"] = "统御之力",
		["Commanding Shout"] = "命令怒吼",
		["Concentration Aura"] = "专注光环",
		["Concussion"] = "震荡",
		["Concussion Blow"] = "震荡猛击",
		["Concussive Barrage"] = "冲击弹幕",
		["Concussive Shot"] = "震荡射击",
		["Cone of Cold"] = "冰锥术",
		["Conflagrate"] = "燃烧",
		["Conflagration"] = "燃烧",
		["Conjure Food"] = "造食术",
		["Conjure Mana Agate"] = "制造魔法玛瑙",
		["Conjure Mana Citrine"] = "制造魔法黄水晶",
		["Conjure Mana Emerald"] = "制造魔法玉石",
		["Conjure Mana Jade"] = "制造魔法翡翠",
		["Conjure Mana Ruby"] = "制造魔法红宝石",
		["Conjure Water"] = "造水术",
		["Consecration"] = "奉献",
		["Consume Magic"] = "吞噬魔法",
		["Consume Shadows"] = "吞噬暗影",
		["Contagion"] = "传染",
		["Convection"] = "传导",
		["Conviction"] = "定罪",
		["Cooking"] = "烹饪",
		["Corruption"] = "腐蚀术",
		["Counterattack"] = "反击",
		["Counterspell"] = "法术反制",
		["Counterspell - Silenced"] = "法术反制 - 沉默",
		["Cower"] = "畏缩",
		["Create Firestone"] = "制造火焰石",
		["Create Firestone (Greater)"] = "制造强效火焰石",
		["Create Firestone (Lesser)"] = "制造次级火焰石",
		["Create Firestone (Major)"] = "制造特效火焰石",
		["Create Healthstone"] = "制造治疗石",
		["Create Healthstone (Greater)"] = "制造强效治疗石",
		["Create Healthstone (Lesser)"] = "制造次级治疗石",
		["Create Healthstone (Major)"] = "制造特效治疗石",
		["Create Healthstone (Minor)"] = "制造初级治疗石",
		["Create Soulstone"] = "制造灵魂石",
		["Create Soulstone (Greater)"] = "制造强效灵魂石",
		["Create Soulstone (Lesser)"] = "制造次级灵魂石",
		["Create Soulstone (Major)"] = "制造特效灵魂石",
		["Create Soulstone (Minor)"] = "制造初级灵魂石",
		["Create Spellstone"] = "制造法术石",
		["Create Spellstone (Greater)"] = "制造强效法术石",
		["Create Spellstone (Major)"] = "制造特效法术石",
		["Create Spellstone (Master)"] = "制造极效法术石",
		["Creeping Paralysis"] = "麻痹蔓延",
		["Cripple"] = "残废术",
		["Crippling Poison"] = "减速药膏",
		["Crippling Poison II"] = "减速药膏 II",
		["Critical Mass"] = "火焰重击",
		["Crossbows"] = "弩",
		["Cruelty"] = "残忍",
		["Crusade"] = "征伐",
		["Crusader Aura"] = "十字军光环",
		["Crusader Strike"] = "十字军打击",
		["Cultivation"] = "栽培",
		["Cure Disease"] = "祛病术",
		["Cure Poison"] = "消毒术",
		["Curse of Agony"] = "痛苦诅咒",
		["Curse of Doom"] = "厄运诅咒",
		["Curse of Doom Effect"] = "厄运诅咒效果",
		["Curse of Exhaustion"] = "疲劳诅咒",
		["Curse of Idiocy"] = "痴呆诅咒",
		["Curse of Recklessness"] = "鲁莽诅咒",
		["Curse of Shadow"] = "暗影诅咒",
		["Curse of Tongues"] = "语言诅咒",
		["Curse of Weakness"] = "虚弱诅咒",
		["Curse of the Elements"] = "元素诅咒",
		["Cyclone"] = "飓风术",
		["Dagger Specialization"] = "匕首专精",
		["Daggers"] = "匕首",
		["Dampen Magic"] = "魔法抑制",
		["Dark Barrage"] = "黑暗壁垒",
		["Dark Pact"] = "黑暗契约",
		["Darkness"] = "黑暗",
		["Dash"] = "急奔",
		["Dawnstone Crab"] = "黎明石螃蟹",
		["Dazed"] = "眩晕",
		["Deadly Interrupt Effect"] = "致命中断效果",
		["Deadly Poison"] = "致命药膏",
		["Deadly Poison II"] = "致命药膏 II",
		["Deadly Poison III"] = "致命药膏 III",
		["Deadly Poison IV"] = "致命药膏 IV",
		["Deadly Poison V"] = "致命药膏 V",
		["Deadly Poison VI"] = "致命药膏 VI",
		["Deadly Poison VII"] = "致命药膏 VII",
		["Deadly Throw"] = "致命投掷",
		["Death Coil"] = "死亡缠绕",
		["Death Wish"] = "死亡之愿",
		["Deep Wound"] = "重伤",
		["Deep Wounds"] = "重伤",
		["Defense"] = "防御",
		["Defensive Stance"] = "防御姿态",
		["Defensive Stance Passive"] = "防御姿态（被动）",
		["Defiance"] = "挑衅",
		["Deflection"] = "偏斜",
		["Delusions of Jin'do"] = "金度的欺骗",
		["Demon Armor"] = "魔甲术",
		["Demon Skin"] = "恶魔皮肤",
		["Demonic Aegis"] = "恶魔庇护",
		["Demonic Embrace"] = "恶魔之拥",
		["Demonic Frenzy"] = "恶魔之狂",
		["Demonic Knowledge"] = "恶魔知识",
		["Demonic Resilience"] = "恶魔韧性",
		["Demonic Sacrifice"] = "恶魔牺牲",
		["Demonic Tactics"] = "恶魔战术",
		["Demoralizing Roar"] = "挫志咆哮",
		["Demoralizing Shout"] = "挫志怒吼",
		["Dense Sharpening Stone"] = "致密磨刀石",
		["Desperate Prayer"] = "绝望祷言",
		["Destructive Reach"] = "毁灭延伸",
		["Detect"] = "侦测",
		["Detect Greater Invisibility"] = "侦测强效隐形",
		["Detect Invisibility"] = "侦测隐形",
		["Detect Lesser Invisibility"] = "侦测次级隐形",
		["Detect Magic"] = "侦测魔法",
		["Detect Traps"] = "侦测陷阱",
		["Deterrence"] = "威慑",
		["Devastate"] = "毁灭打击",
		["Devastation"] = "毁坏",
		["Devotion Aura"] = "虔诚光环",
		["Devour Magic"] = "吞噬魔法",
		["Devour Magic Effect"] = "吞噬魔法效果",
		["Devouring Plague"] = "噬灵瘟疫",
		["Diplomacy"] = "外交",
		["Dire Bear Form"] = "巨熊形态",
		["Dirty Deeds"] = "卑鄙",
		["Dirty Tricks"] = "邪恶计谋",
		["Disarm"] = "缴械",
		["Disarm Trap"] = "解除陷阱",
		["Disease Cleansing Totem"] = "祛病图腾",
		["Disenchant"] = "分解",
		["Disengage"] = "逃脱",
		["Dismiss Pet"] = "解散野兽",
		["Dispel Magic"] = "驱散魔法",
		["Distract"] = "扰乱",
		["Distracting Shot"] = "扰乱射击",
		["Dive"] = "俯冲",
		["Divine Favor"] = "神恩术",
		["Divine Fury"] = "神圣之怒",
		["Divine Illumination"] = "神启",
		["Divine Intellect"] = "神圣智慧",
		["Divine Intervention"] = "神圣干涉",
		["Divine Protection"] = "圣佑术",
		["Divine Shield"] = "圣盾术",
		["Divine Spirit"] = "神圣之灵",
		["Divine Strength"] = "神圣之力",
    ["Divine Wrath"] = "神圣愤怒",
		["Dodge"] = "躲闪",
		["Doomfire"] = "厄运之火",
		["Dragon's Breath"] = "龙息术",
		["Dragonscale Leatherworking"] = "龙鳞制皮",
		["Drain Life"] = "吸取生命",
		["Drain Mana"] = "吸取法力",
		["Drain Soul"] = "吸取灵魂",
		["Dreamless Sleep"] = "无梦睡眠",
		["Drink"] = "喝水",
		["Dual Wield"] = "双武器",
		["Dual Wield Specialization"] = "双武器专精",
		["Duel"] = "决斗",
		["Dust Cloud"] = "尘雾之云",
		["Eagle Eye"] = "鹰眼术",
		["Earth Elemental Totem"] = "土元素图腾",
		["Earth Shield"] = "大地之盾",
		["Earth Shock"] = "地震术",
		["Earthbind"] = "地缚术",
		["Earthbind Totem"] = "地缚图腾",
		["Earthstrike"] = "大地之击",
		["Efficiency"] = "效率",
		["Elemental Devastation"] = "元素浩劫",
		["Elemental Focus"] = "元素集中",
		["Elemental Fury"] = "元素之怒",
		["Elemental Leatherworking"] = "元素制皮",
		["Elemental Mastery"] = "元素掌握",
		["Elemental Precision"] = "元素精准",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Elemental Weapons"] = "元素武器",
		["Elune's Grace"] = "艾露恩的赐福",
		["Elusiveness"] = "飘忽不定",
		["Emberstorm"] = "灰烬风暴",
		["Empowered Arcane Missiles"] = "奥术飞弹增效",
		["Empowered Corruption"] = "腐蚀增效",
		["Empowered Fireball"] = "火球增效",
		["Empowered Frostbolt"] = "寒冰箭增效",
		["Empowered Healing"] = "治疗增效",
		["Empowered Rejuvenation"] = "回春增效",
		["Empowered Touch"] = "治疗之触增效",
		["Enamored Water Spirit"] = "被迷惑的水之魂",
		["Enchanting"] = "附魔",
		["Endurance"] = "耐久",
		["Endurance Training"] = "耐久训练",
		["Engineering"] = "工程学",
		["Engineering Specialization"] = "工程学专精",
		["Enrage"] = "激怒",
		["Enriched Manna Biscuit"] = "可口的魔法点心",
		["Enslave Demon"] = "奴役恶魔",
		["Entangling Roots"] = "纠缠根须",
		["Entrapment"] = "诱捕",
		["Envenom"] = "毒伤",
		["Escape Artist"] = "逃命专家",
		["Evasion"] = "闪避",
		["Eviscerate"] = "刺骨",
		["Evocation"] = "唤醒",
		["Execute"] = "斩杀",
		["Exorcism"] = "驱邪术",
		["Expansive Mind"] = "开阔思维",
		["Explosive Trap"] = "爆炸陷阱",
		["Explosive Trap Effect"] = "爆炸陷阱效果",
		["Expose Armor"] = "破甲",
		["Expose Weakness"] = "破甲虚弱",
		["Extract Gas"] = "提炼气体",
		["Eye for an Eye"] = "以眼还眼",
		["Eye of Kilrogg"] = "基尔罗格之眼",
		["Eye of the Storm"] = "风暴之眼",
		["Eyes of the Beast"] = "野兽之眼",
		["Fade"] = "渐隐术",
		["Faerie Fire"] = "精灵之火",
		["Faerie Fire (Feral)"] = "精灵之火（野性）",
		["Fanaticism"] = "狂热",
		["Far Sight"] = "视界术",
		["Fatal Attraction"] = "致命吸引",
		["Fear"] = "恐惧",
		["Fear Ward"] = "防护恐惧结界",
		["Feed Pet"] = "喂养宠物",
		["Feed Pet Effect"] = "喂养宠物效果",
		["Feedback"] = "回馈",
		["Feign Death"] = "假死",
		["Feint"] = "佯攻",
		["Fel Armor"] = "邪甲术",
		["Fel Concentration"] = "恶魔专注",
		["Fel Domination"] = "恶魔支配",
		["Fel Energy"] = "恶魔能量",
		["Fel Intellect"] = "恶魔智力",
		["Fel Rage"] = "邪能狂怒",
		["Fel Stamina"] = "恶魔耐力",
		["Felfire"] = "魔火",
		["Feline Grace"] = "豹之优雅",
		["Feral Aggression"] = "野性侵略",
		["Feral Charge"] = "野性冲锋",
		["Feral Instinct"] = "野性本能",
		["Feral Swiftness"] = "豹之迅捷",
		["Ferocious Bite"] = "凶猛撕咬",
		["Ferocious Inspiration"] = "凶猛灵感",
		["Ferocity"] = "凶暴",
		["Fetish"] = "神像",
		["Find Herbs"] = "寻找草药",
		["Find Minerals"] = "寻找矿物",
		["Find Treasure"] = "寻找财宝",
		["Find Weakness"] = "寻找弱点",
		["Fire Blast"] = "火焰冲击",
		["Fire Breath"] = "火焰吐息",
		["Fire Elemental Totem"] = "火元素图腾",
		["Fire Nova Totem"] = "火焰新星图腾",
		["Fire Power"] = "火焰强化",
		["Fire Resistance"] = "火焰抗性",
		["Fire Resistance Aura"] = "火焰抗性光环",
		["Fire Resistance Totem"] = "抗火图腾",
		["Fire Shield"] = "火焰之盾",
		["Fire Vulnerability"] = "火焰易伤",
		["Fire Ward"] = "防护火焰结界",
		["Fire Weakness"] = "火焰虚弱",
		["Fireball"] = "火球术",
		["Firebolt"] = "火焰箭",
		["First Aid"] = "急救",
		["Fishing"] = "钓鱼",
		["Fishing Poles"] = "鱼竿",
		["Fist Weapon Specialization"] = "拳套专精",
		["Fist Weapons"] = "拳套",
		["Flame Shock"] = "烈焰震击",
		["Flame Throwing"] = "烈焰投掷",
		["Flamestrike"] = "烈焰风暴",
		["Flamethrower"] = "发射火焰喷射器",
		["Flametongue Attack"] = "火舌攻击",
		["Flametongue Totem"] = "火舌图腾",
		["Flametongue Weapon"] = "火舌武器",
		["Flare"] = "照明弹",
		["Flash Heal"] = "快速治疗",
		["Flash of Light"] = "圣光闪现",
		["Flight Form"] = "飞行形态",
		["Flurry"] = "乱舞",
		["Focused Casting"] = "专注施法",
		["Focused Mind"] = "心灵专注",
		["Focused Power"] = "能量集中",
		["Focused Rage"] = "怒火专注",
		["Focused Starlight"] = "汇聚星光",
		["Food"] = "进食",
		["Forbearance"] = "自律",
		["Force of Nature"] = "自然之力",
		["Force of Will"] = "意志之力",
		["Freezing Trap"] = "冰冻陷阱",
		["Freezing Trap Effect"] = "冰冻陷阱效果",
		["Frenzied Regeneration"] = "狂暴回复",
		["Frenzy"] = "狂乱",
		["Frenzy Effect"] = "狂乱效果",
		["Frost Armor"] = "霜甲术",
		["Frost Blast"] = "冰霜冲击",
		["Frost Channeling"] = "冰霜导能",
		["Frost Nova"] = "冰霜新星",
		["Frost Resistance"] = "冰霜抗性",
		["Frost Resistance Aura"] = "冰霜抗性光环",
		["Frost Resistance Totem"] = "抗寒图腾",
		["Frost Shock"] = "冰霜震击",
		["Frost Trap"] = "冰霜陷阱",
		["Frost Trap Aura"] = "冰霜陷阱光环",
		["Frost Ward"] = "防护冰霜结界",
		["Frost Warding"] = "冰霜障壁",
		["Frost Weakness"] = "冰霜虚弱",
		["Frostbite"] = "霜寒刺骨",
		["Frostbolt"] = "寒冰箭",
		["Frostbrand Attack"] = "冰封攻击",
		["Frostbrand Weapon"] = "冰封武器",
		["Frozen Core"] = "冰冻之心",
		["Furious Howl"] = "狂怒之嚎",
		["Furor"] = "激怒",
		["Fury of the Crashing Waves"] = "波涛之怒",
		["Garrote"] = "锁喉",
		["Garrote - Silence"] = "锁喉沉默",
		["Ghost Wolf"] = "幽魂之狼",
		["Ghostly Strike"] = "鬼魅攻击",
		["Gift of Life"] = "生命赐福",
		["Gift of Nature"] = "自然赐福",
		["Gift of the Naaru"] = "纳鲁的赐福",
		["Gift of the Wild"] = "野性赐福",
		["Gouge"] = "凿击",
		["Grace of Air"] = "风之优雅",
		["Grace of Air Totem"] = "风之优雅图腾",
		["Great Stamina"] = "持久耐力",
		["Greater Blessing of Kings"] = "强效王者祝福",
		["Greater Blessing of Light"] = "强效光明祝福",
		["Greater Blessing of Might"] = "强效力量祝福",
		["Greater Blessing of Salvation"] = "强效拯救祝福",
		["Greater Blessing of Sanctuary"] = "强效庇护祝福",
		["Greater Blessing of Wisdom"] = "强效智慧祝福",
		["Greater Dreamless Sleep"] = "强效昏睡",
		["Greater Heal"] = "强效治疗术",
		["Grievous Throw"] = "重伤投掷",
		["Grim Reach"] = "无情延伸",
		["Grounding Totem"] = "根基图腾",
		["Grounding Totem Effect"] = "根基图腾效果",
		["Grovel"] = "匍匐",
		["Growl"] = "低吼",
		["Guardian's Favor"] = "守护者的宠爱",
		["Gun Specialization"] = "枪械专精",
		["Guns"] = "枪械",
		["Hammer of Justice"] = "制裁之锤",
		["Hammer of Wrath"] = "愤怒之锤",
		["Hamstring"] = "断筋",
		["Harass"] = "侵扰",
		["Hardiness"] = "坚韧",
		["Haste"] = "加速",
		["Hawk Eye"] = "鹰眼",
		["Heal"] = "治疗术",
		["Healing Focus"] = "治疗专注",
		["Healing Light"] = "治疗之光",
		["Healing Stream"] = "治疗之泉",
		["Healing Stream Totem"] = "治疗之泉图腾",
		["Healing Touch"] = "治疗之触",
		["Healing Wave"] = "治疗波",
		["Healing Way"] = "治疗之道",
		["Health Funnel"] = "生命通道",
		["Heart of the Wild"] = "野性之心",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Hellfire"] = "地狱烈焰",
		["Hellfire Effect"] = "地狱烈焰效果",
		["Hellfire Superiority"] = "地狱火主宰",
		["Hemorrhage"] = "出血",
		["Herb Gathering"] = "采集草药",
		["Herbalism"] = "草药学",
		["Heroic Strike"] = "英勇打击",
		["Heroism"] = "英雄",
		["Hex of Weakness"] = "虚弱妖术",
		["Hibernate"] = "休眠",
		["Holy Fire"] = "神圣之火",
		["Holy Light"] = "圣光术",
		["Holy Nova"] = "神圣新星",
		["Holy Power"] = "神圣能量",
		["Holy Reach"] = "神圣延伸",
		["Holy Shield"] = "神圣之盾",
		["Holy Shock"] = "神圣震击",
		["Holy Specialization"] = "神圣专精",
		["Holy Vengeance"] = "神圣复仇",
		["Holy Wrath"] = "神圣愤怒",
		["Honorless Target"] = "无荣誉目标",
		["Horse Riding"] = "骑术：马",
		["Howl of Terror"] = "恐惧嚎叫",
		["Humanoid Slaying"] = "人型生物杀手",
		["Hunter's Mark"] = "猎人印记",
		["Hurricane"] = "飓风",
		["Hypothermia"] = "低温",
		["Ice Armor"] = "冰甲术",
		["Ice Barrier"] = "寒冰护体",
		["Ice Block"] = "寒冰屏障",
		["Ice Floes"] = "浮冰",
		["Ice Lance"] = "冰枪术",
		["Ice Shards"] = "寒冰碎片",
		["Icy Veins"] = "冰冷血脉",
		["Ignite"] = "点燃",
		["Ignite Mana"] = "点燃法力",
		["Illumination"] = "启发",
		["Immolate"] = "献祭",
		["Immolation Trap"] = "献祭陷阱",
		["Immolation Trap Effect"] = "献祭陷阱效果",
		["Impact"] = "冲击",
		["Impale"] = "穿刺",
		["Impaling Spine"] = "穿刺之脊",
		["Improved Ambush"] = "强化伏击",
		["Improved Arcane Missiles"] = "强化奥术飞弹",
		["Improved Arcane Shot"] = "强化奥术射击",
		["Improved Aspect of the Hawk"] = "强化雄鹰守护",
		["Improved Aspect of the Monkey"] = "强化灵猴守护",
		["Improved Backstab"] = "强化背刺",
		["Improved Barrage"] = "强化弹幕",
		["Improved Berserker Rage"] = "强化狂暴之怒",
		["Improved Blessing of Might"] = "强化力量祝福",
		["Improved Blessing of Wisdom"] = "强化智慧祝福",
		["Improved Blink"] = "强化闪现术",
		["Improved Blizzard"] = "强化暴风雪",
		["Improved Bloodrage"] = "强化血性狂暴",
		["Improved Chain Heal"] = "强化治疗链",
		["Improved Chain Lightning"] = "强化闪电链",
		["Improved Challenging Shout"] = "强化挑战怒吼",
		["Improved Charge"] = "强化冲锋",
		["Improved Cleave"] = "强化顺劈斩",
		["Improved Concentration Aura"] = "强化专注光环",
		["Improved Concussive Shot"] = "强化震荡射击",
		["Improved Cone of Cold"] = "强化冰锥术",
		["Improved Corruption"] = "强化腐蚀术",
		["Improved Counterspell"] = "强化法术反制",
		["Improved Curse of Agony"] = "强化痛苦诅咒",
		["Improved Curse of Weakness"] = "强化虚弱诅咒",
		["Improved Demoralizing Shout"] = "强化挫志怒吼",
		["Improved Devotion Aura"] = "强化虔诚光环",
		["Improved Disarm"] = "强化缴械",
		["Improved Drain Life"] = "强化吸取生命",
		["Improved Drain Soul"] = "强化吸取灵魂",
		["Improved Enrage"] = "强化狂怒",
		["Improved Enslave Demon"] = "强化奴役恶魔",
		["Improved Eviscerate"] = "强化刺骨",
		["Improved Execute"] = "强化斩杀",
		["Improved Expose Armor"] = "强化破甲",
		["Improved Eyes of the Beast"] = "强化野兽之眼",
		["Improved Fade"] = "强化渐隐术",
		["Improved Feign Death"] = "强化假死",
		["Improved Fire Blast"] = "强化火焰冲击",
		["Improved Fire Totems"] = "强化火焰图腾",
		["Improved Fire Ward"] = "强化防护火焰结界",
		["Improved Fireball"] = "强化火球术",
		["Improved Firebolt"] = "强化火焰箭",
		["Improved Flamestrike"] = "强化烈焰风暴",
		["Improved Flash of Light"] = "强化圣光闪现",
		["Improved Frost Nova"] = "强化冰霜新星",
		["Improved Frostbolt"] = "强化寒冰箭",
		["Improved Ghost Wolf"] = "强化幽魂之狼",
		["Improved Gouge"] = "强化凿击",
		["Improved Hammer of Justice"] = "强化制裁之锤",
		["Improved Hamstring"] = "强化断筋",
		["Improved Healing"] = "强化治疗术",
		["Improved Healing Touch"] = "强化治疗之触",
		["Improved Healing Wave"] = "强化治疗波",
		["Improved Health Funnel"] = "强化生命通道",
		["Improved Healthstone"] = "强化治疗石",
		["Improved Heroic Strike"] = "强化英勇打击",
		["Improved Holy Shield"] = "强化神圣之盾",
		["Improved Howl of Terror"] = "强化恐惧嚎叫",
		["Improved Hunter's Mark"] = "强化猎人印记",
		["Improved Immolate"] = "强化献祭",
		["Improved Imp"] = "强化小鬼",
		["Improved Inner Fire"] = "强化心灵之火",
		["Improved Intercept"] = "强化拦截",
		["Improved Intimidating Shout"] = "强化破胆怒吼",
		["Improved Judgement"] = "强化审判",
		["Improved Kick"] = "强化脚踢",
		["Improved Kidney Shot"] = "强化肾击",
		["Improved Lash of Pain"] = "强化剧痛鞭笞",
		["Improved Lay on Hands"] = "强化圣疗术",
		["Improved Leader of the Pack"] = "强化兽群领袖",
		["Improved Life Tap"] = "强化生命分流",
		["Improved Lightning Bolt"] = "强化闪电箭",
		["Improved Lightning Shield"] = "强化闪电之盾",
		["Improved Magma Totem"] = "强化熔岩图腾",
		["Improved Mana Burn"] = "强化法力燃烧",
		["Improved Mana Shield"] = "强化法力护盾",
		["Improved Mana Spring Totem"] = "强化法力之泉图腾",
		["Improved Mark of the Wild"] = "强化野性印记",
		["Improved Mend Pet"] = "强化治疗宠物",
		["Improved Mind Blast"] = "强化心灵震爆",
		["Improved Moonfire"] = "强化月火术",
		["Improved Mortal Strike"] = "强化致死打击",
		["Improved Nature's Grasp"] = "强化自然之握",
		["Improved Overpower"] = "强化压制",
		["Improved Power Word: Fortitude"] = "强化真言术：韧",
		["Improved Power Word: Shield"] = "强化真言术：盾",
		["Improved Prayer of Healing"] = "强化治疗祷言",
		["Improved Psychic Scream"] = "强化心灵尖啸",
		["Improved Regrowth"] = "强化愈合",
		["Improved Reincarnation"] = "强化复生",
		["Improved Rejuvenation"] = "强化回春术",
		["Improved Rend"] = "强化撕裂",
		["Improved Renew"] = "强化恢复",
		["Improved Retribution Aura"] = "强化惩罚光环",
		["Improved Revenge"] = "强化复仇",
		["Improved Revive Pet"] = "强化复活宠物",
		["Improved Righteous Fury"] = "强化正义之怒",
		["Improved Rupture"] = "强化割裂",
		["Improved Scorch"] = "强化灼烧",
		["Improved Scorpid Sting"] = "强化毒蝎钉刺",
		["Improved Seal of Righteousness"] = "强化正义圣印",
		["Improved Seal of the Crusader"] = "强化十字军圣印",
		["Improved Searing Pain"] = "强化灼热之痛",
		["Improved Serpent Sting"] = "强化毒蛇钉刺",
		["Improved Shadow Bolt"] = "强化暗影箭",
		["Improved Shadow Word: Pain"] = "强化暗言术：痛",
		["Improved Shield Bash"] = "强化盾击",
		["Improved Shield Block"] = "强化盾牌格挡",
		["Improved Shield Wall"] = "强化盾墙",
		["Improved Sinister Strike"] = "强化影袭",
		["Improved Slam"] = "强化猛击",
		["Improved Slice and Dice"] = "强化切割",
		["Improved Sprint"] = "强化疾跑",
		["Improved Stings"] = "强化钉刺",
		["Improved Succubus"] = "强化魅魔",
		["Improved Sunder Armor"] = "强化破甲攻击",
		["Improved Taunt"] = "强化嘲讽",
		["Improved Thunder Clap"] = "强化雷霆一击",
		["Improved Tranquility"] = "强化宁静",
		["Improved Vampiric Embrace"] = "强化吸血鬼的拥抱",
		["Improved Vanish"] = "强化消失",
		["Improved Voidwalker"] = "强化虚空行者",
		["Improved Weapon Totems"] = "强化武器图腾",
		["Improved Whirlwind"] = "强化旋风斩",
		["Improved Wing Clip"] = "强化摔绊",
		["Incinerate"] = "烧尽",
		["Incineration"] = "烧尽",
		["Inferno"] = "地狱火",
		["Initiative"] = "先发制人",
		["Inner Fire"] = "心灵之火",
		["Inner Focus"] = "心灵专注",
		["Innervate"] = "激活",
		["Insect Swarm"] = "虫群",
		["Insidious Whisper"] = "因斯迪安低语",
		["Insignifigance"] = "毫无意义",
		["Inspiration"] = "灵感",
		["Instant Poison"] = "速效药膏",
		["Instant Poison II"] = "速效药膏 II",
		["Instant Poison III"] = "速效药膏 III",
		["Instant Poison IV"] = "速效药膏 IV",
		["Instant Poison V"] = "速效药膏 V",
		["Instant Poison VI"] = "速效药膏 VI",
		["Instant Poison VII"] = "速效药膏 VII",
		["Intensity"] = "强烈",
		["Intercept"] = "拦截",
		["Intercept Stun"] = "拦截昏迷",
		["Intervene"] = "援护",
		["Intimidating Shout"] = "破胆怒吼",
		["Intimidation"] = "胁迫",
		["Invisibility"] = "隐形术",
		["Iron Will"] = "钢铁意志",
		["Jewelcrafting"] = "珠宝加工",
		["Jom Gabbar"] = "沙虫之毒",
		["Judgement"] = "审判",
		["Judgement of Blood"] = "鲜血审判",
		["Judgement of Command"] = "命令审判",
		["Judgement of Justice"] = "公正审判",
		["Judgement of Light"] = "圣光审判",
		["Judgement of Reckoning"] = "清算审判",
		["Judgement of Righteousness"] = "正义审判",
		["Judgement of Wisdom"] = "智慧审判",
		["Judgement of the Crusader"] = "十字军审判",
		["Kick"] = "脚踢",
		["Kick - Silenced"] = "脚踢 - 沉默",
		["Kidney Shot"] = "肾击",
		["Kill Command"] = "杀戮命令",
		["Killer Instinct"] = "杀戮本能",
		["Kiss of the Spider"] = "蜘蛛之吻",
		["Kodo Riding"] = "骑术：科多兽",
		["Lacerate"] = "割伤",
		["Lash of Pain"] = "剧痛鞭笞",
		["Last Stand"] = "破釜沉舟",
		["Lay on Hands"] = "圣疗术",
		["Leader of the Pack"] = "兽群领袖",
		["Leather"] = "皮革",
		["Leatherworking"] = "制皮",
		["Lesser Heal"] = "次级治疗术",
		["Lesser Healing Wave"] = "次级治疗波",
		["Lesser Invisibility"] = "次级隐形术",
		["Lethal Shots"] = "夺命射击",
		["Lethality"] = "致命偷袭",
		["Levitate"] = "漂浮术",
		["Libram"] = "圣物",
		["Life Tap"] = "生命分流",
		["Lifebloom"] = "生命绽放",
		["Light's Grace"] = "光之优雅",
		["Lightning Bolt"] = "闪电箭",
		["Lightning Breath"] = "闪电吐息",
		["Lightning Mastery"] = "闪电掌握",
		["Lightning Reflexes"] = "闪电反射",
		["Lightning Shield"] = "闪电之盾",
		["Lightning Speed"] = "闪电之速",
		["Lightwell"] = "光明之泉",
		["Lightwell Renew"] = "光明之泉回复",
		["Lockpicking"] = "开锁",
		["Long Daze"] = "长时间眩晕",
		["Lust for Battle"] = "战斗欲望",
		["Mace Specialization"] = "锤类武器专精",
		["Mace Stun Effect"] = "锤击昏迷效果",
		["Mage Armor"] = "法师护甲",
		["Magic Absorption"] = "魔法吸收",
		["Magic Attunement"] = "魔法协调",
		["Magma Totem"] = "熔岩图腾",
		["Mail"] = "锁甲",
		["Maim"] = "割碎",
		["Major Dreamless Sleep"] = "特效无梦睡眠",
		["Malediction"] = "邪咒",
		["Malice"] = "恶意",
		["Mana Burn"] = "法力燃烧",
		["Mana Feed"] = "法力喂食",
		["Mana Shield"] = "法力护盾",
		["Mana Spring"] = "法力之泉",
		["Mana Spring Totem"] = "法力之泉图腾",
		["Mana Tap"] = "法力分流",
		["Mana Tide"] = "法力之潮",
		["Mana Tide Totem"] = "法力之潮图腾",
		["Mangle"] = "裂伤",
		["Mangle (Bear)"] = "裂伤（熊）",
		["Mangle (Cat)"] = "裂伤（豹）",
		["Mark of the Wild"] = "野性印记",
		["Martyrdom"] = "殉难",
		["Mass Dispel"] = "群体驱散",
		["Master Conjuror"] = "魔石大师",
		["Master Demonologist"] = "恶魔学识大师",
		["Master Summoner"] = "召唤大师",
		["Master Tactician"] = "战术大师",
		["Master of Deception"] = "欺诈高手",
		["Master of Elements"] = "元素大师",
		["Master of Subtlety"] = "敏锐大师",
		["Maul"] = "重殴",
		["Mechanostrider Piloting"] = "骑术：机械陆行鸟",
		["Meditation"] = "冥想",
		["Melee Specialization"] = "近战专精",
		["Melt Armor"] = "熔化护甲",
		["Mend Pet"] = "治疗宠物",
		["Mental Agility"] = "精神敏锐",
		["Mental Strength"] = "心灵之力",
		["Mind Blast"] = "心灵震爆",
		["Mind Control"] = "精神控制",
		["Mind Flay"] = "精神鞭笞",
		["Mind Mastery"] = "心灵掌握",
		["Mind Soothe"] = "安抚心灵",
		["Mind Vision"] = "心灵视界",
		["Mind-numbing Poison"] = "麻痹药膏",
		["Mind-numbing Poison II"] = "麻痹药膏 II",
		["Mind-numbing Poison III"] = "麻痹药膏 III",
		["Mining"] = "采矿",
		["Misdirection"] = "误导",
		["Misery"] = "悲惨",
		["Mocking Blow"] = "惩戒痛击",
		["Molten Armor"] = "熔岩护甲",
		["Molten Fury"] = "熔岩之怒",
		["Mongoose Bite"] = "猫鼬撕咬",
		["Monster Slaying"] = "怪物杀手",
		["Moonfire"] = "月火术",
		["Moonfury"] = "月怒",
		["Moonglow"] = "月光",
		["Moonkin Aura"] = "枭兽光环",
		["Moonkin Form"] = "枭兽形态",
		["Mortal Shots"] = "致死射击",
		["Mortal Strike"] = "致死打击",
		["Multi-Shot"] = "多重射击",
		["Murder"] = "谋划",
		["Mutilate"] = "毁伤",
		["Natural Armor"] = "自然护甲",
		["Natural Perfection"] = "天然完美",
		["Natural Shapeshifter"] = "自然变形",
		["Naturalist"] = "自然主义",
		["Nature Resistance"] = "自然抗性",
		["Nature Resistance Totem"] = "自然抗性图腾",
		["Nature Weakness"] = "自然虚弱",
		["Nature's Focus"] = "自然集中",
		["Nature's Grace"] = "自然之赐",
		["Nature's Grasp"] = "自然之握",
		["Nature's Guidance"] = "自然指引",
		["Nature's Reach"] = "自然延伸",
		["Nature's Swiftness"] = "自然迅捷",
		["Negative Charge"] = "负能量电荷",
		["Nether Protection"] = "虚空防护",
		["Netherstorm Flag"] = "虚空风暴旗帜",
		["Nightfall"] = "夜幕",
		["Nurturing Instinct"] = "治愈本能",
		["Omen of Clarity"] = "清晰预兆",
		["One-Handed Axes"] = "单手斧",
		["One-Handed Maces"] = "单手锤",
		["One-Handed Swords"] = "单手剑",
		["One-Handed Weapon Specialization"] = "单手武器专精",
		["Opening"] = "打开",
		["Opening - No Text"] = "Opening - No Text",
		["Opportunity"] = "伺机而动",
		["Overpower"] = "压制",
		["Pain Suppression"] = "痛苦压制",
		["Panic"] = "恐慌",
		["Paranoia"] = "多疑",
		["Parasitic Shadowfiend"] = "寄生暗影魔",
		["Parry"] = "招架",
		["Pathfinding"] = "寻路",
		["Perceived Weakness"] = "察觉弱点",
		["Perception"] = "感知",
		["Permafrost"] = "极寒冰霜",
		["Pet Aggression"] = "宠物好斗",
		["Pet Hardiness"] = "宠物耐久",
		["Pet Recovery"] = "宠物恢复",
		["Pet Resistance"] = "宠物抗魔",
		["Phase Shift"] = "相位变换",
		["Pick Lock"] = "开锁",
		["Pick Pocket"] = "搜索",
		["Piercing Howl"] = "刺耳怒吼",
		["Piercing Ice"] = "刺骨寒冰",
		["Plate Mail"] = "板甲",
		["Playing with Fire"] = "玩火自焚",
		["Poison Cleansing Totem"] = "清毒图腾",
		["Poison Spit"] = "毒液喷吐",
		["Poisons"] = "毒药",
		["Polearms"] = "长柄武器",
		["Poleaxe Specialization"] = "长柄专精",
		["Polymorph"] = "变形术",
		["Polymorph: Pig"] = "变形术：猪",
		["Polymorph: Turtle"] = "变形术：龟",
		["Portal: Darnassus"] = "传送门：达纳苏斯",
		["Portal: Exodar"] = "传送门：埃索达",
		["Portal: Ironforge"] = "传送门：铁炉堡",
		["Portal: Orgrimmar"] = "传送门：奥格瑞玛",
		["Portal: Shattrath"] = "传送门：沙塔斯",
		["Portal: Silvermoon"] = "传送门：银月城",
		["Portal: Stormwind"] = "传送门：暴风城",
		["Portal: Thunder Bluff"] = "传送门：雷霆崖",
		["Portal: Undercity"] = "传送门：幽暗城",
		["Positive Charge"] = "正能量电荷",
		["Pounce"] = "突袭",
		["Pounce Bleed"] = "血袭",
		["Power Infusion"] = "能量灌注",
		["Power Word: Fortitude"] = "真言术：韧",
		["Power Word: Shield"] = "真言术：盾",
		["Prayer of Fortitude"] = "坚韧祷言",
		["Prayer of Healing"] = "治疗祷言",
		["Prayer of Mending"] = "愈合祷言",
		["Prayer of Shadow Protection"] = "暗影防护祷言",
		["Prayer of Spirit"] = "精神祷言",
		["Precision"] = "精确",
		["Predatory Instincts"] = "狩猎天性",
		["Predatory Strikes"] = "猛兽攻击",
		["Premeditation"] = "预谋",
		["Preparation"] = "伺机待发",
		["Presence of Mind"] = "气定神闲",
		["Primal Fury"] = "原始狂怒",
		["Prismatic Cloak"] = "多彩屏障",
		["Prospecting"] = "选矿",
		["Prowl"] = "潜行",
		["Psychic Scream"] = "心灵尖啸",
		["Pummel"] = "拳击",
		["Purge"] = "净化术",
		["Purification"] = "净化",
		["Purify"] = "纯净术",
		["Purifying Power"] = "净化之力",
		["Pursuit of Justice"] = "正义追击",
		["Pyroblast"] = "炎爆术",
		["Pyroclasm"] = "火焰冲撞",
		["Pyromaniac"] = "纵火",
		["Quick Recovery"] = "快速恢复",
		["Quick Shots"] = "快速射击",
		["Quickness"] = "迅捷",
		["Rage of the Unraveller"] = "瓦解者之怒",
		["Rain of Fire"] = "火焰之雨",
		["Rake"] = "斜掠",
		["Ram Riding"] = "骑术：羊",
		["Rampage"] = "暴怒",
		["Ranged Weapon Specialization"] = "远程武器专精",
		["Rapid Fire"] = "急速射击",
		["Rapid Killing"] = "疾速杀戮",
		["Raptor Riding"] = "骑术：迅猛龙",
		["Raptor Strike"] = "猛禽一击",
		["Ravage"] = "毁灭",
		["Readiness"] = "准备就绪",
		["Rebirth"] = "复生",
		["Reckless Charge"] = "无畏冲锋",
		["Recklessness"] = "鲁莽",
		["Reckoning"] = "清算",
		["Redemption"] = "救赎",
		["Redoubt"] = "盾牌壁垒",
		["Reflection"] = "反射",
		["Regeneration"] = "再生",
		["Regrowth"] = "愈合",
		["Reincarnation"] = "复生",
		["Reinforced Shield"] = "援护之盾",
		["Rejuvenation"] = "回春术",
		["Relentless Strikes"] = "无情打击",
		["Remorseless"] = "冷酷",
		["Remorseless Attacks"] = "冷酷攻击",
    ["Remote Toy"] = "遥控玩具",
		["Remove Curse"] = "解除诅咒",
		["Remove Insignia"] = "解除徽记",
		["Remove Lesser Curse"] = "解除次级诅咒",
		["Rend"] = "撕裂",
		["Renew"] = "恢复",
		["Repentance"] = "忏悔",
		["Restless Strength"] = "充沛之力",
		["Restorative Totems"] = "恢复图腾",
		["Resurrection"] = "复活术",
		["Retaliation"] = "反击风暴",
		["Retribution Aura"] = "惩罚光环",
		["Revenge"] = "复仇",
		["Revenge Stun"] = "复仇昏迷",
		["Reverberation"] = "回响",
		["Revive Pet"] = "复活宠物",
		["Righteous Defense"] = "正义防御",
		["Righteous Fury"] = "正义之怒",
		["Rip"] = "割裂",
		["Riposte"] = "还击",
		["Ritual of Doom"] = "末日仪式",
		["Ritual of Doom Effect"] = "末日仪式效果",
		["Ritual of Refreshment"] = "召唤餐桌",
		["Ritual of Souls"] = "灵魂仪式",
		["Ritual of Summoning"] = "召唤仪式",
		["Rockbiter Weapon"] = "石化武器",
		["Rough Sharpening Stone"] = "劣质磨刀石",
		["Ruin"] = "毁灭",
		["Rupture"] = "割裂",
		["Ruthlessness"] = "无情",
		["Sacrifice"] = "牺牲",
		["Safe Fall"] = "安全降落",
		["Sanctified Crusader"] = "神圣十字军",
		["Sanctified Judgement"] = "神圣审判",
		["Sanctified Light"] = "神圣光芒",
		["Sanctity Aura"] = "圣洁光环",
		["Sap"] = "闷棍",
		["Savage Fury"] = "野蛮暴怒",
		["Savage Strikes"] = "野蛮打击",
		["Scare Beast"] = "恐吓野兽",
		["Scatter Shot"] = "驱散射击",
		["Scorch"] = "灼烧",
		["Scorpid Poison"] = "蝎毒",
		["Scorpid Sting"] = "毒蝎钉刺",
		["Screech"] = "尖啸",
		["Seal Fate"] = "封印命运",
		["Seal of Blood"] = "鲜血圣印",
		["Seal of Command"] = "命令圣印",
		["Seal of Justice"] = "公正圣印",
		["Seal of Light"] = "光明圣印",
		["Seal of Righteousness"] = "正义圣印",
		["Seal of Vengeance"] = "复仇圣印",
		["Seal of Wisdom"] = "智慧圣印",
		["Seal of the Crusader"] = "十字军圣印",
		["Searing Light"] = "灼热之光",
		["Searing Pain"] = "灼热之痛",
		["Searing Totem"] = "灼热图腾",
		["Second Wind"] = "复苏之风",
		["Seduction"] = "诱惑",
		["Seed of Corruption"] = "腐蚀之种",
		["Seethe"] = "沸腾",
		["Sense Demons"] = "感知恶魔",
		["Sense Undead"] = "感知亡灵",
		["Sentry Totem"] = "岗哨图腾",
		["Serpent Sting"] = "毒蛇钉刺",
		["Serrated Blades"] = "锯齿利刃",
		["Setup"] = "调整",
		["Shackle Undead"] = "束缚亡灵",
		["Shadow Affinity"] = "暗影亲和",
		["Shadow Bolt"] = "暗影箭",
		["Shadow Embrace"] = "暗影之拥",
		["Shadow Focus"] = "暗影集中",
		["Shadow Mastery"] = "暗影掌握",
		["Shadow Power"] = "暗影强化",
		["Shadow Protection"] = "防护暗影",
		["Shadow Reach"] = "暗影延伸",
		["Shadow Resistance"] = "暗影抗性",
		["Shadow Resistance Aura"] = "暗影抗性光环",
		["Shadow Trance"] = "暗影冥思",
		["Shadow Vulnerability"] = "暗影易伤",
		["Shadow Ward"] = "防护暗影结界",
		["Shadow Weakness"] = "暗影虚弱",
		["Shadow Weaving"] = "暗影之波",
		["Shadow Word: Death"] = "暗言术：灭",
		["Shadow Word: Pain"] = "暗言术：痛",
		["Shadow and Flame"] = "暗影烈焰",
		["Shadow of Death"] = "死亡之影",
		["Shadowburn"] = "暗影灼烧",
		["Shadowfiend"] = "暗影恶魔",
		["Shadowform"] = "暗影形态",
		["Shadowfury"] = "暗影之怒",
		["Shadowguard"] = "暗影守卫",
		["Shadowmeld"] = "影遁",
		["Shadowmeld Passive"] = "影遁",
		["Shadowstep"] = "暗影步",
		["Shamanistic Rage"] = "萨满之怒",
		["Sharpened Claws"] = "锋利兽爪",
		["Shatter"] = "碎冰",
		["Shear"] = "剪切",
		["Shell Shield"] = "甲壳护盾",
		["Shield"] = "盾牌",
		["Shield Bash"] = "盾击",
		["Shield Bash - Silenced"] = "盾击 - 沉默",
		["Shield Block"] = "盾牌格挡",
		["Shield Slam"] = "盾牌猛击",
		["Shield Specialization"] = "盾牌专精",
		["Shield Wall"] = "盾墙",
		["Shiv"] = "毒刃",
		["Shoot"] = "射击",
		["Shoot Bow"] = "弓箭射击",
		["Shoot Gun"] = "Shoot Gun",
		["Shred"] = "撕碎",
		["Shredding Attacks"] = "撕碎攻击",
		["Silence"] = "沉默",
		["Silencing Shot"] = "沉默射击",
		["Silent Resolve"] = "无声消退",
		["Silverwing Flag"] = "银翼军旗",
		["Sinister Strike"] = "影袭",
		["Siphon Life"] = "生命虹吸",
		["Skinning"] = "剥皮",
		["Slam"] = "猛击",
		["Slayer's Crest"] = "屠龙者的纹章",
		["Sleep"] = "催眠术",
		["Slice and Dice"] = "切割",
		["Slow"] = "减速术",
		["Slow Fall"] = "缓落术",
		["Smelting"] = "熔炼",
		["Smite"] = "惩击",
		["Snake Trap"] = "毒蛇陷阱",
		["Solid Sharpening Stone"] = "坚固的磨刀石",
		["Sonic Burst"] = "音素爆破",
		["Soothe Animal"] = "安抚动物",
		["Soothing Kiss"] = "安抚之吻",
		["Soul Fire"] = "灵魂之火",
		["Soul Leech"] = "灵魂榨取",
		["Soul Link"] = "灵魂链接",
		["Soul Siphon"] = "灵魂虹吸",
		["Soulshatter"] = "灵魂碎裂",
		["Soulstone Resurrection"] = "灵魂石复活",
		["Spell Haste"] = "法术急速",
		["Spell Lock"] = "法术封锁",
		["Spell Power"] = "法术能量",
		["Spell Reflection"] = "法术反射",
		["Spell Vulnerability"] = "法术易伤",
		["Spell Warding"] = "法术屏障",
		["Spellsteal"] = "法术偷取",
		["Spirit Bond"] = "灵魂联结",
		["Spirit Tap"] = "精神分流",
		["Spirit of Redemption"] = "救赎之魂",
		["Spiritual Attunement"] = "灵魂协调",
		["Spiritual Focus"] = "精神集中",
		["Spiritual Guidance"] = "精神指引",
		["Spiritual Healing"] = "精神治疗",
		["Spiteful Fury"] = "仇恨之怒",
		["Sprint"] = "疾跑",
		["Stance Mastery"] = "姿态掌握",
		["Starfire"] = "星火术",
		["Starfire Stun"] = "星火昏迷",
		["Starlight Wrath"] = "星光之怒",
		["Starshards"] = "星辰碎片",
		["Static Charge"] = "静电充能",
		["Staves"] = "法杖",
		["Steady Shot"] = "稳固射击",
		["Stealth"] = "潜行",
		["Stoneclaw Stun"] = "石爪昏迷",
		["Stoneclaw Totem"] = "石爪图腾",
		["Stoneform"] = "石像形态",
		["Stoneskin"] = "石肤术",
		["Stoneskin Totem"] = "石肤图腾",
		["Stormstrike"] = "风暴打击",
		["Strength of Earth"] = "大地之力",
		["Strength of Earth Totem"] = "大地之力图腾",
		["Strength of the Halaani"] = "哈兰之力",
		["Stuck"] = "卡死",
		["Stun"] = "昏迷",
		["Subtlety"] = "微妙",
		["Suffering"] = "受难",
		["Summon Charger"] = "召唤战马",
		["Summon Dreadsteed"] = "召唤恐惧战马",
		["Summon Felguard"] = "召唤恶魔卫士",
		["Summon Felhunter"] = "召唤地狱猎犬",
		["Summon Felsteed"] = "召唤地狱战马",
		["Summon Imp"] = "召唤小鬼",
		["Summon Succubus"] = "召唤魅魔",
		["Summon Voidwalker"] = "召唤虚空行者",
		["Summon Warhorse"] = "召唤军马",
		["Summon Water Elemental"] = "召唤水元素",
		["Sunder Armor"] = "破甲攻击",
		["Suppression"] = "镇压",
		["Surefooted"] = "稳固",
		["Surge of Light"] = "圣光涌动",
		["Surprise Attacks"] = "突袭",
		["Survivalist"] = "生存专家",
		["Sweeping Strikes"] = "横扫攻击",
		["Swift Flight Form"] = "迅捷飞行形态",
		["Swiftmend"] = "迅捷治愈",
		["Swipe"] = "横扫",
		["Sword Specialization"] = "剑类武器专精",
		["Symbol of Hope"] = "希望符记",
		["Tactical Mastery"] = "战术掌握",
		["Tailoring"] = "裁缝",
		["Tainted Blood"] = "腐坏之血",
		["Tainted Mind"] = "污浊之魂",
		["Tame Beast"] = "驯服野兽",
		["Taunt"] = "嘲讽",
		["Teleport: Darnassus"] = "传送：达纳苏斯",
		["Teleport: Exodar"] = "传送：埃索达",
		["Teleport: Ironforge"] = "传送：铁炉堡",
		["Teleport: Moonglade"] = "传送：月光林地",
		["Teleport: Orgrimmar"] = "传送：奥格瑞玛",
		["Teleport: Shattrath"] = "传送：沙塔斯",
		["Teleport: Silvermoon"] = "传送：银月城",
		["Teleport: Stormwind"] = "传送：暴风城",
		["Teleport: Thunder Bluff"] = "传送：雷霆崖",
		["Teleport: Undercity"] = "传送：幽暗城",
		["Temporal Rift"] = "时光裂隙",
		["The Beast Within"] = "野兽之心",
		["The Human Spirit"] = "人类精魂",
		["Thick Hide"] = "厚皮",
		["Thorns"] = "荆棘术",
		["Thrill of the Hunt"] = "狩猎刺激",
		["Throw"] = "投掷",
		["Throwing Specialization"] = "投掷专精",
		["Thrown"] = "投掷",
		["Thunder Clap"] = "雷霆一击",
		["Thunderfury"] = "雷霆之怒",
		["Thundering Strikes"] = "雷鸣猛击",
		["Thunderstomp"] = "雷霆践踏",
		["Tidal Focus"] = "潮汐集中",
		["Tidal Mastery"] = "潮汐掌握",
		["Tiger Riding"] = "骑术：豹",
		["Tiger's Fury"] = "猛虎之怒",
		["Time's Favor"] = "时之赐福",
		["Torment"] = "折磨",
		["Totem"] = "图腾",
		["Totem of Wrath"] = "天怒图腾",
		["Totemic Call"] = "图腾召唤",
		["Totemic Focus"] = "图腾集中",
		["Touch of Shadow"] = "暗影之触",
		["Touch of Weakness"] = "虚弱之触",
		["Toughness"] = "坚韧",
		["Traces of Silithyst"] = "水晶尘迹",
		["Track Beasts"] = "追踪野兽",
		["Track Demons"] = "追踪恶魔",
		["Track Dragonkin"] = "追踪龙类",
		["Track Elementals"] = "追踪元素生物",
		["Track Giants"] = "追踪巨人",
		["Track Hidden"] = "追踪隐藏生物",
		["Track Humanoids"] = "追踪人型生物",
		["Track Undead"] = "追踪亡灵",
		["Tranquil Air"] = "宁静之风",
		["Tranquil Air Totem"] = "宁静之风图腾",
		["Tranquil Spirit"] = "宁静之魂",
		["Tranquility"] = "宁静",
		["Tranquilizing Shot"] = "宁神射击",
		["Trap Mastery"] = "陷阱掌握",
		["Travel Form"] = "旅行形态",
		["Tree of Life"] = "生命之树",
		["Tremor Totem"] = "战栗图腾",
		["Tribal Leatherworking"] = "部族制皮",
		["Trueshot Aura"] = "强击光环",
		["Turn Undead"] = "超度亡灵",
		["Twin Spire Blessing"] = "双塔的祝福",
		["Two-Handed Axes"] = "双手斧",
		["Two-Handed Axes and Maces"] = "双手斧和锤",
		["Two-Handed Maces"] = "双手锤",
		["Two-Handed Swords"] = "双手剑",
		["Two-Handed Weapon Specialization"] = "双手武器专精",
		["Unarmed"] = "徒手",
		["Unbreakable Will"] = "坚定意志",
		["Unbridled Wrath"] = "怒不可遏",
		["Undead Horsemanship"] = "骑术：骸骨战马",
		["Underwater Breathing"] = "水下呼吸",
		["Unending Breath"] = "魔息术",
		["Unholy Power"] = "邪恶强化",
		["Unleashed Fury"] = "狂怒释放",
		["Unleashed Rage"] = "怒火释放",
		["Unstable Affliction"] = "痛苦无常",
		["Unstable Power"] = "能量无常",
		["Unyielding Faith"] = "不灭信仰",
		["Upset Tummy"] = "Upset Tummy",--
		["Vampiric Embrace"] = "吸血鬼的拥抱",
		["Vampiric Touch"] = "吸血鬼之触",
		["Vanish"] = "消失",
		["Vanished"] = "消失",
		["Vengeance"] = "复仇",
		["Venomous Totem"] = "毒性图腾",
		["Victory Rush"] = "乘胜追击",
		["Vigor"] = "精力",
		["Vile Beam"] = "败德射线",
		["Vile Poisons"] = "剧毒",
		["Vindication"] = "辩护",
		["Viper Sting"] = "蝰蛇钉刺",
		["Volley"] = "乱射",
		["Wand Specialization"] = "魔杖专精",
		["Wands"] = "魔杖",
		["War Stomp"] = "战争践踏",
		["Warp"] = "迁跃",
		["Warsong Flag"] = "战歌军旗",
		["Water Breathing"] = "水下呼吸",
		["Water Shield"] = "水之护盾",
		["Water Tomb"] = "水之墓",
		["Water Walking"] = "水上行走",
		["Waterbolt"] = "水箭",
		["Watery Grave"] = "水之墓穴",
		["Weakened Soul"] = "虚弱灵魂",
		["Weapon Mastery"] = "武器掌握",
		["Weaponsmith"] = "武器锻造",
		["Well Fed"] = "进食充分",
		["Whirlwind"] = "旋风斩",
		["Will of the Forsaken"] = "亡灵意志",
		["Windfury"] = "风怒",
		["Windfury Attack"] = "风怒攻击",
		["Windfury Totem"] = "风怒图腾",
		["Windfury Weapon"] = "风怒武器",
		["Windwall"] = "风墙",
		["Windwall Totem"] = "风墙图腾",
		["Wing Clip"] = "摔绊",
		["Winter's Chill"] = "深冬之寒",
		["Wisp Spirit"] = "精灵之魂",
		["Wolf Riding"] = "骑术：狼",
		["Wound Poison"] = "致伤药膏",
		["Wound Poison II"] = "致伤药膏 II",
		["Wound Poison III"] = "致伤药膏 III",
		["Wound Poison IV"] = "致伤药膏 IV",
		["Wound Poison V"] = "致伤药膏 V",
		["Wrath"] = "愤怒",
		["Wrath of Air Totem"] = "空气之怒图腾",
		["Wrath of Cenarius"] = "塞纳留斯之怒",
		["Wrath of the Astromancer"] = "星术师之怒",
		["Wyvern Sting"] = "翼龙钉刺",
	}
end)

BabbleSpell:RegisterTranslations("zhTW", function()
	return {
		["Abolish Disease"] = "驅除疾病",
		["Abolish Poison"] = "驅毒術",
		["Abolish Poison Effect"] = "驅毒術效果",
		["Activate MG Turret"] = "啟動MG砲塔",
		["Adrenaline Rush"] = "能量刺激",
		["Aftermath"] = "清算",
		["Aggression"] = "侵略",
		["Agonizing Flames"] = "苦惱之焰",
		["Aimed Shot"] = "瞄準射擊",
		["Alchemy"] = "鍊金術",
		["Ambush"] = "伏擊",
		["Amplify Curse"] = "詛咒增幅",
		["Amplify Magic"] = "魔法增效",
		["Ancestral Fortitude"] = "先祖堅韌",
		["Ancestral Healing"] = "先祖治療",
		["Ancestral Knowledge"] = "先祖知識",
		["Ancestral Spirit"] = "先祖之魂",
		["Ancient Hysteria"] = "上古狂亂",
		["Anesthetic Poison"] = "麻醉毒藥",
		["Anger Management"] = "憤怒掌控",
		["Anguish"] = "苦痛",
		["Anticipation"] = "預知",
		["Aquatic Form"] = "水棲形態",
		["Arcane Blast"] = "秘法衝擊",
		["Arcane Brilliance"] = "秘法光輝",
		["Arcane Concentration"] = "秘法專注",
		["Arcane Energy"] = "秘法能量",
		["Arcane Explosion"] = "魔爆術",
		["Arcane Focus"] = "秘法集中",
		["Arcane Fortitude"] = "秘法轉化",
		["Arcane Impact"] = "秘法碰撞",
		["Arcane Instability"] = "秘法增效",
		["Arcane Intellect"] = "秘法智慧",
		["Arcane Meditation"] = "秘法冥想",
		["Arcane Mind"] = "秘法心智",
		["Arcane Missiles"] = "秘法飛彈",
		["Arcane Potency"] = "秘法潛能",
		["Arcane Power"] = "秘法強化",
		["Arcane Resistance"] = "秘法抗性",
		["Arcane Shot"] = "秘法射擊",
		["Arcane Shroud"] = "秘法環繞",
		["Arcane Subtlety"] = "秘法精妙",
		["Arcane Torrent"] = "奧流之術",
		["Arcane Weakness"] = "秘法虛弱",
		["Arctic Reach"] = "極寒延伸",
		["Arctic Winds"] = "極地之風",
		["Armor of Faith"] = "信仰護盾",
		["Armorsmith"] = "護甲鍛造師",
		["Aspect of the Beast"] = "野獸守護",
		["Aspect of the Cheetah"] = "獵豹守護",
		["Aspect of the Hawk"] = "雄鷹守護",
		["Aspect of the Monkey"] = "靈猴守護",
		["Aspect of the Pack"] = "豹群守護",
		["Aspect of the Viper"] = "蝮蛇守護",
		["Aspect of the Wild"] = "野性守護",
		["Astral Recall"] = "星界傳送",
		["Attack"] = "攻擊",
		["Attacking"] = "攻擊",
		["Auto Shot"] = "自動射擊",
		["Avenger's Shield"] = "復仇之盾",
		["Avenging Wrath"] = "復仇之怒",
		["Avoidance"] = "躲避",
		["Axe Specialization"] = "斧專精",
		["Backlash"] = "反衝",
		["Backstab"] = "背刺",
		["Badge of the Swarmguard"] = "蟲群守衛徽章",
		["Balance of Power"] = "平衡之力",
		["Bane"] = "災禍",
		["Banish"] = "放逐術",
		["Banshee Curse"] = "女妖詛咒",
		["Barkskin"] = "樹皮術",
		["Barrage"] = "彈幕",
		["Bash"] = "重擊",
		["Basic Campfire"] = "基礎營火",
		["Battle Rush"] = "戰鬥猛攻",
		["Battle Shout"] = "戰鬥怒吼",
		["Battle Stance"] = "戰鬥姿態",
		["Battle Stance Passive"] = "戰鬥姿態被動",
		["Bear Form"] = "熊形態",
		["Beast Lore"] = "野獸知識",
		["Beast Slaying"] = "野獸殺手",
		["Beast Training"] = "訓練野獸",
		["Benediction"] = "祈福",
		["Berserker Rage"] = "狂暴之怒",
		["Berserker Stance"] = "狂暴姿態",
		["Berserker Stance Passive"] = "狂暴姿態(被動)",
		["Berserking"] = "狂暴",
		["Bestial Discipline"] = "野獸戒律",
		["Bestial Swiftness"] = "野獸迅捷",
		["Bestial Wrath"] = "狂野怒火",
		["Binding Heal"] = "束縛治療",
		["Bite"] = "撕咬",
		["Black Arrow"] = "黑箭",
		["Blackout"] = "昏厥",
		["Blacksmithing"] = "鍛造",
		["Blade Flurry"] = "劍刃亂舞",
		["Blade Turning"] = "劍刃轉向",
		["Blade Twisting"] = "旋轉劍刃",
		["Blast Wave"] = "衝擊波",
		["Blazing Speed"] = "熾烈迅捷",
		["Blessed Recovery"] = "祝福復元",
		["Blessed Resilience"] = "祝福韌性",
		["Blessing of Auchindoun"] = "奧齊頓的祝福",
		["Blessing of Freedom"] = "自由祝福",
		["Blessing of Kings"] = "王者祝福",
		["Blessing of Light"] = "光明祝福",
		["Blessing of Might"] = "力量祝福",
		["Blessing of Protection"] = "保護祝福",
		["Blessing of Sacrifice"] = "犧牲祝福",
		["Blessing of Salvation"] = "拯救祝福",
		["Blessing of Sanctuary"] = "庇護祝福",
		["Blessing of Wisdom"] = "智慧祝福",
		["Blind"] = "致盲",
		["Blinding Powder"] = "致盲粉",
		["Blink"] = "閃現術",
		["Blizzard"] = "暴風雪",
		["Block"] = "格擋",
		["Blood Craze"] = "血之狂熱",
		["Blood Frenzy"] = "血之狂暴",
		["Blood Fury"] = "血性狂暴",
		["Blood Pact"] = "血之契印",
		["Bloodboil"] = "血液沸騰",
		["Bloodlust"] = "嗜血術",
		["Bloodrage"] = "血性狂暴",
		["Bloodthirst"] = "嗜血",
		["Boar Charge"] = "野豬衝鋒",
		["Booming Voice"] = "震耳嗓音",
		["Bow Specialization"] = "弓箭專精",
		["Bows"] = "弓",
		["Bright Campfire"] = "明亮篝火",
		["Brittle Armor"] = "脆弱護甲",
		["Brutal Impact"] = "野蠻衝撞",
		["Burning Adrenaline"] = "燃燒刺激",
		["Burning Soul"] = "燃燒之魂",
		["Burning Wish"] = "燃燒之願",
		["Call Pet"] = "召喚寵物",
		["Call of Flame"] = "烈焰呼喚",
		["Call of Thunder"] = "雷霆呼喚",
		["Call of the Nexus"] = "奈薩斯的精神感召",
		["Camouflage"] = "偽裝",
		["Cannibalize"] = "食屍",
		["Cat Form"] = "獵豹形態",
		["Cataclysm"] = "災變",
		["Celestial Focus"] = "星空專注",
		["Chain Heal"] = "治療鍊",
		["Chain Lightning"] = "閃電鏈",
		["Challenging Roar"] = "挑戰咆哮",
		["Challenging Shout"] = "挑戰怒吼",
		["Charge"] = "衝鋒",
		["Charge Rage Bonus Effect"] = "衝鋒怒氣加成效果",
		["Charge Stun"] = "衝鋒昏迷",
		["Chastise"] = "譴責",
		["Cheap Shot"] = "偷襲",
		["Chilled"] = "冰凍",
		["Circle of Healing"] = "治療之環",
		["Claw"] = "爪擊",
		["Cleanse"] = "淨化術",
		["Clearcasting"] = "節能施法",
		["Cleave"] = "順劈斬",
		["Clever Traps"] = "靈巧陷阱",
		["Cloak of Shadows"] = "暗影披風",
		["Closing"] = "關閉",
		["Cloth"] = "布甲",
		["Coarse Sharpening Stone"] = "粗製磨刀石",
		["Cobra Reflexes"] = "毒蛇反射",
		["Cold Blood"] = "冷血",
		["Cold Snap"] = "急速冷卻",
		["Combat Endurance"] = "作戰持久",
		["Combustion"] = "燃燒",
		["Command"] = "命令",
		["Commanding Presence"] = "命令風采",
		["Commanding Shout"] = "命令之吼",
		["Concentration Aura"] = "專注光環",
		["Concussion"] = "震盪",
		["Concussion Blow"] = "震盪猛擊",
		["Concussive Barrage"] = "震盪狙擊",
		["Concussive Shot"] = "震盪射擊",
		["Cone of Cold"] = "冰錐術",
		["Conflagrate"] = "燃燒",
		["Conflagration"] = "燃燒",
		["Conjure Food"] = "造食術",
		["Conjure Mana Agate"] = "製造法力瑪瑙",
		["Conjure Mana Citrine"] = "製造法力黃水晶",
		["Conjure Mana Emerald"] = "製造法力綠寶石",
		["Conjure Mana Jade"] = "製造法力翡翠",
		["Conjure Mana Ruby"] = "製造法力紅寶石",
		["Conjure Water"] = "造水術",
		["Consecration"] = "奉獻",
		["Consume Magic"] = "吞噬魔法",
		["Consume Shadows"] = "吞噬暗影",
		["Contagion"] = "傳染",
		["Convection"] = "傳導",
		["Conviction"] = "定罪",
		["Cooking"] = "烹飪",
		["Corruption"] = "腐蝕術",
		["Counterattack"] = "反擊",
		["Counterspell"] = "法術反制",
		["Counterspell - Silenced"] = "法術反制 - 沉默",
		["Cower"] = "畏縮",
		["Create Firestone"] = "製造火焰石",
		["Create Firestone (Greater)"] = "製造強效火焰石",
		["Create Firestone (Lesser)"] = "製造次級火焰石",
		["Create Firestone (Major)"] = "製造極效火焰石",
		["Create Healthstone"] = "製造治療石",
		["Create Healthstone (Greater)"] = "製造治療石(強效)",
		["Create Healthstone (Lesser)"] = "製造治療石(次級)",
		["Create Healthstone (Major)"] = "製造治療石(極效)",
		["Create Healthstone (Minor)"] = "製造治療石(初級)",
		["Create Soulstone"] = "製造靈魂石",
		["Create Soulstone (Greater)"] = "製造靈魂石 (強效)",
		["Create Soulstone (Lesser)"] = "製造靈魂石 (次級)",
		["Create Soulstone (Major)"] = "製造靈魂石 (極效)",
		["Create Soulstone (Minor)"] = "製造靈魂石 (初級)",
		["Create Spellstone"] = "製造法術石",
		["Create Spellstone (Greater)"] = "製造強效法術石",
		["Create Spellstone (Major)"] = "製造極效法術石",
		["Create Spellstone (Master)"] = "製造極強效法術石",
		["Creeping Paralysis"] = "慢性麻痹",
		["Cripple"] = "殘廢術",
		["Crippling Poison"] = "致殘毒藥",
		["Crippling Poison II"] = "致殘毒藥 II",
		["Critical Mass"] = "火焰重擊",
		["Crossbows"] = "弩",
		["Cruelty"] = "殘忍",
		["Crusade"] = "十字軍",
		["Crusader Aura"] = "十字軍光環",
		["Crusader Strike"] = "十字軍聖擊",
		["Cultivation"] = "栽培",
		["Cure Disease"] = "祛病術",
		["Cure Poison"] = "消毒術",
		["Curse of Agony"] = "痛苦詛咒",
		["Curse of Doom"] = "厄運詛咒",
		["Curse of Doom Effect"] = "厄運詛咒效果",
		["Curse of Exhaustion"] = "疲勞詛咒",
		["Curse of Idiocy"] = "癡呆詛咒",
		["Curse of Recklessness"] = "魯莽詛咒",
		["Curse of Shadow"] = "暗影詛咒",
		["Curse of Tongues"] = "語言詛咒",
		["Curse of Weakness"] = "虛弱詛咒",
		["Curse of the Elements"] = "元素詛咒",
		["Cyclone"] = "颶風術",
		["Dagger Specialization"] = "匕首專精",
		["Daggers"] = "匕首",
		["Dampen Magic"] = "魔法抑制",
		["Dark Barrage"] = "黑暗侵襲",
		["Dark Pact"] = "黑暗契約",
		["Darkness"] = "黑暗",
		["Dash"] = "突進",
		["Dawnstone Crab"] = "黎明石蟹",
		["Dazed"] = "暈眩",
		["Deadly Interrupt Effect"] = "致命中斷效果",
		["Deadly Poison"] = "致命毒藥",
		["Deadly Poison II"] = "致命毒藥 II",
		["Deadly Poison III"] = "致命毒藥 III",
		["Deadly Poison IV"] = "致命毒藥 IV",
		["Deadly Poison V"] = "致命毒藥 V",
		["Deadly Poison VI"] = "致命毒藥 VI",
		["Deadly Poison VII"] = "致命毒藥 VII",
		["Deadly Throw"] = "擲殺",
		["Death Coil"] = "死亡纏繞",
		["Death Wish"] = "死亡之願",
		["Deep Wound"] = "重傷",
		["Deep Wounds"] = "重傷",
		["Defense"] = "防禦",
		["Defensive Stance"] = "防禦姿態",
		["Defensive Stance Passive"] = "防禦姿態被動",
		["Defiance"] = "挑釁",
		["Deflection"] = "偏斜",
		["Delusions of Jin'do"] = "金度的欺騙",
		["Demon Armor"] = "魔甲術",
		["Demon Skin"] = "惡魔皮膚",
		["Demonic Aegis"] = "惡魔庇護",
		["Demonic Embrace"] = "惡魔之擁",
		["Demonic Frenzy"] = "惡魔狂怒",
		["Demonic Knowledge"] = "惡魔知識",
		["Demonic Resilience"] = "惡魔韌性",
		["Demonic Sacrifice"] = "惡魔犧牲",
		["Demonic Tactics"] = "惡魔策略",
		["Demoralizing Roar"] = "挫志咆哮",
		["Demoralizing Shout"] = "挫志怒吼",
		["Dense Sharpening Stone"] = "緻密磨刀石",
		["Desperate Prayer"] = "絕望禱言",
		["Destructive Reach"] = "毀滅延伸",
		["Detect"] = "偵測",
		["Detect Greater Invisibility"] = "偵測強效隱形",
		["Detect Invisibility"] = "偵測隱形",
		["Detect Lesser Invisibility"] = "偵測次級隱形術",
		["Detect Magic"] = "偵測魔法",
		["Detect Traps"] = "偵測陷阱",
		["Deterrence"] = "威懾",
		["Devastate"] = "挫敗",
		["Devastation"] = "破壞",
		["Devotion Aura"] = "虔誠光環",
		["Devour Magic"] = "吞噬魔法",
		["Devour Magic Effect"] = "吞噬魔法效果",
		["Devouring Plague"] = "噬靈瘟疫",
		["Diplomacy"] = "外交",
		["Dire Bear Form"] = "巨熊形態",
		["Dirty Deeds"] = "陰險動作",
		["Dirty Tricks"] = "卑鄙技倆",
		["Disarm"] = "繳械",
		["Disarm Trap"] = "解除陷阱",
		["Disease Cleansing Totem"] = "祛病圖騰",
		["Disenchant"] = "分解",
		["Disengage"] = "逃脫",
		["Dismiss Pet"] = "解散野獸",
		["Dispel Magic"] = "驅散魔法",
		["Distract"] = "擾亂",
		["Distracting Shot"] = "擾亂射擊",
		["Dive"] = "俯衝",
		["Divine Favor"] = "神恩術",
		["Divine Fury"] = "神聖之怒",
		["Divine Illumination"] = "神聖啟發",
		["Divine Intellect"] = "神聖智慧",
		["Divine Intervention"] = "神聖干涉",
		["Divine Protection"] = "聖佑術",
		["Divine Shield"] = "聖盾術",
		["Divine Spirit"] = "神聖之靈",
		["Divine Strength"] = "神聖之力",
		["Divine Wrath"] = "神聖之怒",
		["Dodge"] = "閃躲",
		["Doomfire"] = "毀滅之火",
		["Dragon's Breath"] = "龍之吐息",
		["Dragonscale Leatherworking"] = "龍鱗製皮",
		["Drain Life"] = "吸取生命",
		["Drain Mana"] = "吸取法力",
		["Drain Soul"] = "吸取靈魂",
		["Dreamless Sleep"] = "無夢睡眠",
		["Drink"] = "喝飲料",
		["Dual Wield"] = "雙武器",
		["Dual Wield Specialization"] = "雙武器專精",
		["Duel"] = "決鬥",
		["Dust Cloud"] = "塵霧之雲",
		["Eagle Eye"] = "鷹眼術",
		["Earth Elemental Totem"] = "土元素圖騰",
		["Earth Shield"] = "大地之盾",
		["Earth Shock"] = "地震術",
		["Earthbind"] = "地縛術",
		["Earthbind Totem"] = "地縛圖騰",
		["Earthstrike"] = "大地之擊",
		["Efficiency"] = "效率",
		["Elemental Devastation"] = "元素破壞",
		["Elemental Focus"] = "元素集中",
		["Elemental Fury"] = "元素之怒",
		["Elemental Leatherworking"] = "元素製皮",
		["Elemental Mastery"] = "精通元素",
		["Elemental Precision"] = "元素準確",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Elemental Weapons"] = "元素武器",
		["Elune's Grace"] = "伊露恩的賜福",
		["Elusiveness"] = "飄忽不定",
		["Emberstorm"] = "餘燼風暴",
		["Empowered Arcane Missiles"] = "強力秘法飛彈",
		["Empowered Corruption"] = "強力腐蝕術",
		["Empowered Fireball"] = "強力火球術",
		["Empowered Frostbolt"] = "強力寒冰箭",
		["Empowered Healing"] = "強力治療術",
		["Empowered Rejuvenation"] = "強力回春術",
		["Empowered Touch"] = "強力之觸",
		["Enamored Water Spirit"] = "被迷惑的水之靈",
		["Enchanting"] = "附魔",
		["Endurance"] = "耐久",
		["Endurance Training"] = "耐久訓練",
		["Engineering"] = "工程學",
		["Engineering Specialization"] = "工程學專精",
		["Enrage"] = "狂怒",
		["Enriched Manna Biscuit"] = "可口的魔法點心",
		["Enslave Demon"] = "奴役惡魔",
		["Entangling Roots"] = "糾纏根鬚",
		["Entrapment"] = "誘捕",
		["Envenom"] = "毒化",
		["Escape Artist"] = "逃命專家",
		["Evasion"] = "閃避",
		["Eviscerate"] = "剔骨",
		["Evocation"] = "喚醒",
		["Execute"] = "斬殺",
		["Exorcism"] = "驅邪術",
		["Expansive Mind"] = "開闊思維",
		["Explosive Trap"] = "爆炸陷阱",
		["Explosive Trap Effect"] = "爆炸陷阱效果",
		["Expose Armor"] = "破甲",
		["Expose Weakness"] = "弱點識破",
		["Extract Gas"] = "提煉氣體雲",
		["Eye for an Eye"] = "以眼還眼",
		["Eye of Kilrogg"] = "基爾羅格之眼",
		["Eye of the Storm"] = "暴風之眼",
		["Eyes of the Beast"] = "野獸之眼",
		["Fade"] = "漸隱術",
		["Faerie Fire"] = "精靈之火",
		["Faerie Fire (Feral)"] = "精靈之火(野性)",
		["Fanaticism"] = "狂熱",
		["Far Sight"] = "視界術",
		["Fatal Attraction"] = "致命的吸引力",
		["Fear"] = "恐懼術",
		["Fear Ward"] = "防護恐懼結界",
		["Feed Pet"] = "餵養寵物",
		["Feed Pet Effect"] = "餵養寵物效果",
		["Feedback"] = "回饋",
		["Feign Death"] = "假死",
		["Feint"] = "佯攻",
		["Fel Armor"] = "獄甲術",
		["Fel Concentration"] = "惡魔專注",
		["Fel Domination"] = "惡魔支配",
		["Fel Energy"] = "惡魔能量",
		["Fel Intellect"] = "惡魔智力",
		["Fel Rage"] = "惡魔之怒",
		["Fel Stamina"] = "惡魔耐力",
		["Felfire"] = "惡魔烈焰",
		["Feline Grace"] = "豹之優雅",
		["Feral Aggression"] = "野性侵略",
		["Feral Charge"] = "野性衝鋒",
		["Feral Instinct"] = "野性本能",
		["Feral Swiftness"] = "野性迅捷",
		["Ferocious Bite"] = "兇猛撕咬",
		["Ferocious Inspiration"] = "兇性鼓舞",
		["Ferocity"] = "兇暴",
		["Fetish"] = "神像",
		["Find Fish"] = "尋找魚類",
		["Find Herbs"] = "尋找草藥",
		["Find Minerals"] = "尋找礦物",
		["Find Treasure"] = "尋找財寶",
		["Find Weakness"] = "找尋弱點",
		["Fire Blast"] = "火焰衝擊",
		["Fire Breath"] = "火焰之息",
		["Fire Elemental Totem"] = "火元素圖騰",
		["Fire Nova Totem"] = "火焰新星圖騰",
		["Fire Power"] = "火焰強化",
		["Fire Resistance"] = "火焰抗性",
		["Fire Resistance Aura"] = "火焰抗性光環",
		["Fire Resistance Totem"] = "抗火圖騰",
		["Fire Shield"] = "火焰之盾",
		["Fire Vulnerability"] = "火焰易傷",
		["Fire Ward"] = "防護火焰結界",
		["Fire Weakness"] = "火焰虛弱",
		["Fireball"] = "火球術",
		["Firebolt"] = "火焰箭",
		["First Aid"] = "急救",
		["Fishing"] = "釣魚",
		["Fishing Poles"] = "魚竿",
		["Fist Weapon Specialization"] = "拳套專精",
		["Fist Weapons"] = "拳套",
		["Flame Shock"] = "烈焰震擊",
		["Flame Throwing"] = "烈焰投擲",
		["Flamestrike"] = "烈焰風暴",
		["Flamethrower"] = "火焰噴射器",
		["Flametongue Attack"] = "火舌攻擊",
		["Flametongue Totem"] = "火舌圖騰",
		["Flametongue Weapon"] = "火舌武器",
		["Flare"] = "照明彈",
		["Flash Heal"] = "快速治療",
		["Flash of Light"] = "聖光閃現",
		["Flight Form"] = "飛行形態",
		["Flurry"] = "亂舞",
		["Focused Casting"] = "專注施法",
		["Focused Mind"] = "精神專注",
		["Focused Power"] = "能量專注",
		["Focused Rage"] = "專注之怒",
		["Focused Starlight"] = "專注星光",
		["Food"] = "進食",
		["Forbearance"] = "自律",
		["Force of Nature"] = "自然之力",
		["Force of Will"] = "意志之力",
		["Freezing Trap"] = "冰凍陷阱",
		["Freezing Trap Effect"] = "冰凍陷阱效果",
		["Frenzied Regeneration"] = "狂暴恢復",
		["Frenzy"] = "狂亂",
		["Frenzy Effect"] = "狂亂效果",
		["Frost Armor"] = "霜甲術",
		["Frost Blast"] = "冰霜衝擊",
		["Frost Channeling"] = "冰霜導能",
		["Frost Nova"] = "冰霜新星",
		["Frost Resistance"] = "冰霜抗性",
		["Frost Resistance Aura"] = "冰霜抗性光環",
		["Frost Resistance Totem"] = "抗寒圖騰",
		["Frost Shock"] = "冰霜震擊",
		["Frost Trap"] = "冰霜陷阱",
		["Frost Trap Aura"] = "冰霜陷阱光環",
		["Frost Ward"] = "防護冰霜結界",
		["Frost Warding"] = "冰霜結界",
		["Frost Weakness"] = "冰霜虛弱",
		["Frostbite"] = "霜寒刺骨",
		["Frostbolt"] = "寒冰箭",
		["Frostbrand Attack"] = "冰封攻擊",
		["Frostbrand Weapon"] = "冰封武器",
		["Frozen Core"] = "冰霜之心",
		["Furious Howl"] = "狂怒之嚎",
		["Furor"] = "激怒",
		["Fury of the Crashing Waves"] = "浪潮之怒",
		["Garrote"] = "絞喉",
		["Garrote - Silence"] = "絞喉 - 沉默",
		["Ghost Wolf"] = "鬼魂之狼",
		["Ghostly Strike"] = "鬼魅攻擊",
		["Gift of Life"] = "生命賜福",
		["Gift of Nature"] = "自然賜福",
		["Gift of the Naaru"] = "那魯的祝福",
		["Gift of the Wild"] = "野性賜福",
		["Gouge"] = "鑿擊",
		["Grace of Air"] = "風之優雅",
		["Grace of Air Totem"] = "風之優雅圖騰",
		["Great Stamina"] = "強效耐力",
		["Greater Blessing of Kings"] = "強效王者祝福",
		["Greater Blessing of Light"] = "強效光明祝福",
		["Greater Blessing of Might"] = "強效力量祝福",
		["Greater Blessing of Salvation"] = "強效拯救祝福",
		["Greater Blessing of Sanctuary"] = "強效庇護祝福",
		["Greater Blessing of Wisdom"] = "強效智慧祝福",
		["Greater Dreamless Sleep"] = "強效昏睡",
		["Greater Heal"] = "強效治療術",
		["Grievous Throw"] = "嚴重擲傷",
		["Grim Reach"] = "無情延伸",
		["Grounding Totem"] = "根基圖騰",
		["Grounding Totem Effect"] = "根基圖騰效果",
		["Grovel"] = "匍匐",
		["Growl"] = "低吼",
		["Guardian's Favor"] = "守護者的恩眷",
		["Gun Specialization"] = "槍械專精",
		["Guns"] = "槍械",
		["Hammer of Justice"] = "制裁之錘",
		["Hammer of Wrath"] = "憤怒之錘",
		["Hamstring"] = "斷筋",
		["Harass"] = "侵擾",
		["Hardiness"] = "堅韌",
		["Haste"] = "加速",
		["Hawk Eye"] = "鷹眼",
		["Heal"] = "治療術",
		["Healing Focus"] = "專注治療",
		["Healing Light"] = "治療之光",
		["Healing Stream"] = "治療之泉",
		["Healing Stream Totem"] = "治療之泉圖騰",
		["Healing Touch"] = "治療之觸",
		["Healing Wave"] = "治療波",
		["Healing Way"] = "治療之路",
		["Health Funnel"] = "生命通道",
		["Heart of the Wild"] = "野性之心",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Hellfire"] = "地獄烈焰",
		["Hellfire Effect"] = "地獄烈焰效果",
		["Hellfire Superiority"] = "地獄火優勢",
		["Hemorrhage"] = "出血",
		["Herb Gathering"] = "採集草藥",
		["Herbalism"] = "草藥學",
		["Heroic Strike"] = "英勇打擊",
		["Heroism"] = "英勇氣概",
		["Hex of Weakness"] = "虛弱妖術",
		["Hibernate"] = "休眠",
		["Holy Fire"] = "神聖之火",
		["Holy Light"] = "聖光術",
		["Holy Nova"] = "神聖新星",
		["Holy Power"] = "神聖強化",
		["Holy Reach"] = "神聖延伸",
		["Holy Shield"] = "神聖之盾",
		["Holy Shock"] = "神聖震擊",
		["Holy Specialization"] = "神聖專精",
		["Holy Vengeance"] = "神聖復仇",
		["Holy Wrath"] = "神聖憤怒",
		["Honorless Target"] = "無榮譽目標",
		["Horse Riding"] = "騎術:馬",
		["Howl of Terror"] = "恐懼嚎叫",
		["Humanoid Slaying"] = "人型生物殺手",
		["Hunter's Mark"] = "獵人印記",
		["Hurricane"] = "颶風",
		["Hypothermia"] = "體溫過低",
		["Ice Armor"] = "冰甲術",
		["Ice Barrier"] = "寒冰護體",
		["Ice Block"] = "寒冰屏障",
		["Ice Floes"] = "浮冰",
		["Ice Lance"] = "冰霜長矛",
		["Ice Shards"] = "寒冰裂片",
		["Icy Veins"] = "冰寒脈動",
		["Ignite"] = "點燃",
		["Ignite Mana"] = "點燃法力",
		["Illumination"] = "啟發",
		["Immolate"] = "獻祭",
		["Immolation Trap"] = "獻祭陷阱",
		["Immolation Trap Effect"] = "獻祭陷阱效果",
		["Impact"] = "衝擊",
		["Impale"] = "刺穿",
		["Impaling Spine"] = "尖刺脊椎",
		["Improved Ambush"] = "強化伏擊",
		["Improved Arcane Missiles"] = "強化秘法飛彈",
		["Improved Arcane Shot"] = "強化秘法射擊",
		["Improved Aspect of the Hawk"] = "強化雄鷹守護",
		["Improved Aspect of the Monkey"] = "強化靈猴守護",
		["Improved Backstab"] = "強化背刺",
		["Improved Barrage"] = "強化彈幕",
		["Improved Berserker Rage"] = "強化狂暴之怒",
		["Improved Blessing of Might"] = "強化力量祝福",
		["Improved Blessing of Wisdom"] = "強化智慧祝福",
		["Improved Blink"] = "強化閃現術",
		["Improved Blizzard"] = "強化暴風雪",
		["Improved Bloodrage"] = "強化血性狂暴",
		["Improved Chain Heal"] = "強化治療鍊",
		["Improved Chain Lightning"] = "強化閃電鏈",
		["Improved Challenging Shout"] = "強化挑戰怒吼",
		["Improved Charge"] = "強化衝鋒",
		["Improved Cleave"] = "強化順劈斬",
		["Improved Concentration Aura"] = "強化專注光環",
		["Improved Concussive Shot"] = "強化震盪射擊",
		["Improved Cone of Cold"] = "強化冰錐術",
		["Improved Corruption"] = "強化腐蝕術",
		["Improved Counterspell"] = "強化法術反制",
		["Improved Curse of Agony"] = "強化痛苦詛咒",
		["Improved Curse of Weakness"] = "強化虛弱詛咒",
		["Improved Demoralizing Shout"] = "強化挫志怒吼",
		["Improved Devotion Aura"] = "強化虔誠光環",
		["Improved Disarm"] = "強化繳械",
		["Improved Drain Life"] = "強化吸取生命",
		["Improved Drain Soul"] = "強化吸取靈魂",
		["Improved Enrage"] = "強化狂怒",
		["Improved Enslave Demon"] = "強化奴役惡魔",
		["Improved Eviscerate"] = "強化剔骨",
		["Improved Execute"] = "強化斬殺",
		["Improved Expose Armor"] = "強化破甲",
		["Improved Eyes of the Beast"] = "強化野獸之眼",
		["Improved Fade"] = "強化漸隱術",
		["Improved Feign Death"] = "強化假死",
		["Improved Fire Blast"] = "強化火焰衝擊",
		["Improved Fire Totems"] = "強化火焰圖騰",
		["Improved Fire Ward"] = "強化防護火焰結界",
		["Improved Fireball"] = "強化火球術",
		["Improved Firebolt"] = "強化火焰箭",
		["Improved Flamestrike"] = "強化烈焰風暴",
		["Improved Flash of Light"] = "強化聖光閃現",
		["Improved Frost Nova"] = "強化冰霜新星",
		["Improved Frostbolt"] = "強化寒冰箭",
		["Improved Ghost Wolf"] = "強化鬼魂之狼",
		["Improved Gouge"] = "強化鑿擊",
		["Improved Hammer of Justice"] = "強化制裁之錘",
		["Improved Hamstring"] = "強化斷筋",
		["Improved Healing"] = "強化治療術",
		["Improved Healing Touch"] = "強化治療之觸",
		["Improved Healing Wave"] = "強化治療波",
		["Improved Health Funnel"] = "強化生命通道",
		["Improved Healthstone"] = "強化治療石",
		["Improved Heroic Strike"] = "強化英勇打擊",
		["Improved Holy Shield"] = "強化神聖之盾",
		["Improved Howl of Terror"] = "強化恐懼嚎叫",
		["Improved Hunter's Mark"] = "強化獵人印記",
		["Improved Immolate"] = "強化獻祭",
		["Improved Imp"] = "強化小鬼",
		["Improved Inner Fire"] = "強化心靈之火",
		["Improved Intercept"] = "強化攔截",
		["Improved Intimidating Shout"] = "強化破膽怒吼",
		["Improved Judgement"] = "強化審判",
		["Improved Kick"] = "強化腳踢",
		["Improved Kidney Shot"] = "強化腎擊",
		["Improved Lash of Pain"] = "強化劇痛鞭笞",
		["Improved Lay on Hands"] = "強化聖療術",
		["Improved Leader of the Pack"] = "強化獸群領袖",
		["Improved Life Tap"] = "強化生命分流",
		["Improved Lightning Bolt"] = "強化閃電箭",
		["Improved Lightning Shield"] = "強化閃電之盾",
		["Improved Magma Totem"] = "強化熔岩圖騰",
		["Improved Mana Burn"] = "強化法力燃燒",
		["Improved Mana Shield"] = "強化法力護盾",
		["Improved Mana Spring Totem"] = "強化法力之泉圖騰",
		["Improved Mark of the Wild"] = "強化野性印記",
		["Improved Mend Pet"] = "強化治療寵物",
		["Improved Mind Blast"] = "強化心靈震爆",
		["Improved Moonfire"] = "強化月火術",
		["Improved Mortal Strike"] = "強化致死打擊",
		["Improved Nature's Grasp"] = "強化自然之握",
		["Improved Overpower"] = "強化壓制",
		["Improved Power Word: Fortitude"] = "強化真言術:韌",
		["Improved Power Word: Shield"] = "強化真言術:盾",
		["Improved Prayer of Healing"] = "強化治療禱言",
		["Improved Psychic Scream"] = "強化心靈尖嘯",
		["Improved Regrowth"] = "強化癒合",
		["Improved Reincarnation"] = "強化復生",
		["Improved Rejuvenation"] = "強化回春術",
		["Improved Rend"] = "強化撕裂",
		["Improved Renew"] = "強化恢復",
		["Improved Retribution Aura"] = "強化懲罰光環",
		["Improved Revenge"] = "強化復仇",
		["Improved Revive Pet"] = "強化復活寵物",
		["Improved Righteous Fury"] = "強化正義之怒",
		["Improved Rupture"] = "強化割裂",
		["Improved Scorch"] = "強化灼燒",
		["Improved Scorpid Sting"] = "強化毒蠍釘刺",
		["Improved Seal of Righteousness"] = "強化正義聖印",
		["Improved Seal of the Crusader"] = "強化十字軍聖印",
		["Improved Searing Pain"] = "強化灼熱之痛",
		["Improved Serpent Sting"] = "強化毒蛇釘刺",
		["Improved Shadow Bolt"] = "強化暗影箭",
		["Improved Shadow Word: Pain"] = "強化暗言術:痛",
		["Improved Shield Bash"] = "強化盾擊",
		["Improved Shield Block"] = "強化盾牌格擋",
		["Improved Shield Wall"] = "強化盾牆",
		["Improved Sinister Strike"] = "強化邪惡攻擊",
		["Improved Slam"] = "強化猛擊",
		["Improved Slice and Dice"] = "強化切割",
		["Improved Sprint"] = "強化疾跑",
		["Improved Stings"] = "強化釘刺",
		["Improved Succubus"] = "強化魅魔",
		["Improved Sunder Armor"] = "強化破甲攻擊",
		["Improved Taunt"] = "強化嘲諷",
		["Improved Thunder Clap"] = "強化雷霆一擊",
		["Improved Tranquility"] = "強化寧靜",
		["Improved Vampiric Embrace"] = "強化吸血鬼的擁抱",
		["Improved Vanish"] = "強化消失",
		["Improved Voidwalker"] = "強化虛無行者",
		["Improved Weapon Totems"] = "強化武器系圖騰",
		["Improved Whirlwind"] = "強化旋風斬",
		["Improved Wing Clip"] = "強化摔絆",
		["Incinerate"] = "燒盡",
		["Incineration"] = "焚化",
		["Inferno"] = "地獄火",
		["Initiative"] = "先發制人",
		["Inner Fire"] = "心靈之火",
		["Inner Focus"] = "心靈專注",
		["Innervate"] = "啟動",
		["Insect Swarm"] = "蟲群",
		["Insidious Whisper"] = "陰險之語",
		["Insignifigance"] = "攻擊無效",
		["Inspiration"] = "靈感",
		["Instant Poison"] = "速效毒藥",
		["Instant Poison II"] = "速效毒藥 II",
		["Instant Poison III"] = "速效毒藥 III",
		["Instant Poison IV"] = "速效毒藥 IV",
		["Instant Poison V"] = "速效毒藥 V",
		["Instant Poison VI"] = "速效毒藥 VI",
		["Instant Poison VII"] = "速效毒藥 VII",
		["Intensity"] = "激化",
		["Intercept"] = "攔截",
		["Intercept Stun"] = "攔截昏迷",
		["Intervene"] = "阻擾",
		["Intimidating Shout"] = "破膽怒吼",
		["Intimidation"] = "脅迫",
		["Invisibility"] = "隱形術",
		["Iron Will"] = "鋼鐵意志",
		["Jewelcrafting"] = "珠寶設計",
		["Jom Gabbar"] = "姜姆·蓋伯",
		["Judgement"] = "審判",
		["Judgement of Blood"] = "血之審判",
		["Judgement of Command"] = "命令審判",
		["Judgement of Justice"] = "公正審判",
		["Judgement of Light"] = "光明審判",
		["Judgement of Reckoning"] = "懲罰審判",
		["Judgement of Righteousness"] = "正義審判",
		["Judgement of Wisdom"] = "智慧審判",
		["Judgement of the Crusader"] = "十字軍審判",
		["Kick"] = "腳踢",
		["Kick - Silenced"] = "腳踢 - 沉默",
		["Kidney Shot"] = "腎擊",
		["Kill Command"] = "擊殺命令",
		["Killer Instinct"] = "殺戮本能",
		["Kiss of the Spider"] = "蜘蛛之吻",
		["Kodo Riding"] = "騎術:科多獸",
		["Lacerate"] = "割裂",
		["Lash of Pain"] = "劇痛鞭笞",
		["Last Stand"] = "破釜沉舟",
		["Lay on Hands"] = "聖療術",
		["Leader of the Pack"] = "獸群領袖",
		["Leather"] = "皮革",
		["Leatherworking"] = "製皮",
		["Lesser Heal"] = "次級治療術",
		["Lesser Healing Wave"] = "次級治療波",
		["Lesser Invisibility"] = "次級隱形術",
		["Lethal Shots"] = "奪命射擊",
		["Lethality"] = "致命偷襲",
		["Levitate"] = "漂浮術",
		["Libram"] = "聖契",
		["Life Tap"] = "生命分流",
		["Lifebloom"] = "生命之花",
		["Light's Grace"] = "光明賜福",
		["Lightning Bolt"] = "閃電箭",
		["Lightning Breath"] = "閃電吐息",
		["Lightning Mastery"] = "精通閃電",
		["Lightning Reflexes"] = "閃電反射",
		["Lightning Shield"] = "閃電之盾",
		["Lightning Speed"] = "閃電速度",
		["Lightwell"] = "光束泉",
		["Lightwell Renew"] = "光束泉恢復",
		["Lockpicking"] = "開鎖",
		["Long Daze"] = "長時間暈眩",
		["Lust for Battle"] = "戰鬥慾望",
		["Mace Specialization"] = "錘類武器專精",
		["Mace Stun Effect"] = "錘擊昏迷效果",
		["Mage Armor"] = "魔甲術",
		["Magic Absorption"] = "魔法吸收",
		["Magic Attunement"] = "魔法調和",
		["Magma Totem"] = "熔岩圖騰",
		["Mail"] = "鎖甲",
		["Maim"] = "傷殘術",
		["Major Dreamless Sleep"] = "極效昏睡",
		["Malediction"] = "憎惡",
		["Malice"] = "惡意",
		["Mana Burn"] = "法力燃燒",
		["Mana Feed"] = "法力餵食",
		["Mana Shield"] = "法力護盾",
		["Mana Spring"] = "法力之泉",
		["Mana Spring Totem"] = "法力之泉圖騰",
		["Mana Tap"] = "法力吸取",
		["Mana Tide"] = "法力之潮",
		["Mana Tide Totem"] = "法力之潮圖騰",
		["Mangle"] = "割碎",
		["Mangle (Bear)"] = "割碎(熊形態)",
		["Mangle (Cat)"] = "割碎(獵豹形態)",
		["Mark of the Wild"] = "野性印記",
		["Martyrdom"] = "殉難",
		["Mass Dispel"] = "群體驅魔",
		["Master Conjuror"] = "魔石專精",
		["Master Demonologist"] = "惡魔學識大師",
		["Master Summoner"] = "召喚大師",
		["Master Tactician"] = "戰術大師",
		["Master of Deception"] = "欺詐大師",
		["Master of Elements"] = "元素大師",
		["Master of Subtlety"] = "敏銳大師",
		["Maul"] = "槌擊",
		["Mechanostrider Piloting"] = "騎術:機械陸行鳥",
		["Meditation"] = "冥想",
		["Melee Specialization"] = "近戰專精",
		["Melt Armor"] = "熔化護甲",
		["Mend Pet"] = "治療寵物",
		["Mental Agility"] = "精神敏銳",
		["Mental Strength"] = "心靈之力",
		["Mind Blast"] = "心靈震爆",
		["Mind Control"] = "精神控制",
		["Mind Flay"] = "精神鞭笞",
		["Mind Mastery"] = "精通心靈",
		["Mind Soothe"] = "安撫心靈",
		["Mind Vision"] = "心靈幻象",
		["Mind-numbing Poison"] = "麻痹毒藥",
		["Mind-numbing Poison II"] = "麻痹毒藥 II",
		["Mind-numbing Poison III"] = "麻痹毒藥 III",
		["Mining"] = "採礦",
		["Misdirection"] = "誤導",
		["Misery"] = "苦難",
		["Mocking Blow"] = "懲戒痛擊",
		["Molten Armor"] = "熔火護甲",
		["Molten Fury"] = "熔岩之怒",
		["Mongoose Bite"] = "貓鼬撕咬",
		["Monster Slaying"] = "怪物殺手",
		["Moonfire"] = "月火術",
		["Moonfury"] = "月怒",
		["Moonglow"] = "月光",
		["Moonkin Aura"] = "梟獸光環",
		["Moonkin Form"] = "梟獸形態",
		["Mortal Shots"] = "致死射擊",
		["Mortal Strike"] = "致死打擊",
		["Multi-Shot"] = "多重射擊",
		["Murder"] = "謀殺",
		["Mutilate"] = "截肢",
		["Natural Armor"] = "自然護甲",
		["Natural Perfection"] = "自然完美",
		["Natural Shapeshifter"] = "自然變形",
		["Naturalist"] = "強化治療之觸",
		["Nature Resistance"] = "自然抗性",
		["Nature Resistance Totem"] = "自然抗性圖騰",
		["Nature Weakness"] = "自然虛弱",
		["Nature's Focus"] = "自然集中",
		["Nature's Grace"] = "自然之賜",
		["Nature's Grasp"] = "自然之握",
		["Nature's Guidance"] = "自然引導",
		["Nature's Reach"] = "自然延伸",
		["Nature's Swiftness"] = "自然迅捷",
		["Negative Charge"] = "負級效應",
		["Nether Protection"] = "虛空保護",
		["Netherstorm Flag"] = "虛空風暴旗幟",
		["Nightfall"] = "夜幕",
		["Nurturing Instinct"] = "培育天性",
		["Omen of Clarity"] = "清晰預兆",
		["One-Handed Axes"] = "單手斧",
		["One-Handed Maces"] = "單手錘",
		["One-Handed Swords"] = "單手劍",
		["One-Handed Weapon Specialization"] = "單手武器專精",
		["Opening"] = "開啟",
		["Opening - No Text"] = "開啟 - 無文字",
		["Opportunity"] = "伺機而動",
		["Overpower"] = "壓制",
		["Pain Suppression"] = "痛苦鎮壓",
		["Panic"] = "恐慌",
		["Paranoia"] = "多疑",
		["Parasitic Shadowfiend"] = "寄生暗影惡魔",
		["Parry"] = "招架",
		["Pathfinding"] = "尋路",
		["Perceived Weakness"] = "察覺弱點",
		["Perception"] = "感知",
		["Permafrost"] = "極寒冰霜",
		["Pet Aggression"] = "寵物好鬥",
		["Pet Hardiness"] = "寵物耐久",
		["Pet Recovery"] = "寵物恢復",
		["Pet Resistance"] = "寵物抗性",
		["Phase Shift"] = "相位變換",
		["Pick Lock"] = "開鎖",
		["Pick Pocket"] = "偷竊",
		["Piercing Howl"] = "刺耳怒吼",
		["Piercing Ice"] = "刺骨寒冰",
		["Plate Mail"] = "鎧甲",
		["Playing with Fire"] = "玩火",
		["Poison Cleansing Totem"] = "清毒圖騰",
		["Poison Spit"] = "毒液噴射",
		["Poisons"] = "毒藥",
		["Polearms"] = "長柄武器",
		["Poleaxe Specialization"] = "長柄和斧專精",
		["Polymorph"] = "變形術",
		["Polymorph: Pig"] = "變豬術",
		["Polymorph: Turtle"] = "變龜術",
		["Portal: Darnassus"] = "傳送門:達納蘇斯",
		["Portal: Exodar"] = "傳送門:艾克索達",
		["Portal: Ironforge"] = "傳送門:鐵爐堡",
		["Portal: Orgrimmar"] = "傳送門:奧格瑪",
		["Portal: Shattrath"] = "傳送門:撒塔斯",
		["Portal: Silvermoon"] = "傳送門:銀月城",
		["Portal: Stormwind"] = "傳送門:暴風城",
		["Portal: Thunder Bluff"] = "傳送門:雷霆崖",
		["Portal: Undercity"] = "傳送門:幽暗城",
		["Positive Charge"] = "正級效應",
		["Pounce"] = "突襲",
		["Pounce Bleed"] = "血襲",
		["Power Infusion"] = "注入能量",
		["Power Word: Fortitude"] = "真言術:韌",
		["Power Word: Shield"] = "真言術:盾",
		["Prayer of Fortitude"] = "堅韌禱言",
		["Prayer of Healing"] = "治療禱言",
		["Prayer of Mending"] = "癒合禱言",
		["Prayer of Shadow Protection"] = "暗影防護禱言",
		["Prayer of Spirit"] = "精神禱言",
		["Precision"] = "精準",
		["Predatory Instincts"] = "猛獸天性",
		["Predatory Strikes"] = "猛獸攻擊",
		["Premeditation"] = "預謀",
		["Preparation"] = "準備",
		["Presence of Mind"] = "氣定神閒",
		["Primal Fury"] = "原始狂怒",
		["Prismatic Cloak"] = "稜彩庇護",
		["Prospecting"] = "勘探",
		["Prowl"] = "潛行",
		["Psychic Scream"] = "心靈尖嘯",
		["Pummel"] = "拳擊",
		["Purge"] = "淨魔術",
		["Purification"] = "淨化",
		["Purify"] = "純淨術",
		["Purifying Power"] = "淨化能量",
		["Pursuit of Justice"] = "正義追擊",
		["Pyroblast"] = "炎爆術",
		["Pyroclasm"] = "火焰衝撞",
		["Pyromaniac"] = "火焰狂熱",
		["Quick Recovery"] = "快速恢復",
		["Quick Shots"] = "快速射擊",
		["Quickness"] = "迅捷",
		["Rage of the Unraveller"] = "破壞者之怒",
		["Rain of Fire"] = "火焰之雨",
		["Rake"] = "掃擊",
		["Ram Riding"] = "騎術:羊",
		["Rampage"] = "暴怒",
		["Ranged Weapon Specialization"] = "遠程武器專精",
		["Rapid Fire"] = "急速射擊",
		["Rapid Killing"] = "急速殺戮",
		["Raptor Riding"] = "騎術:迅猛龍",
		["Raptor Strike"] = "猛禽一擊",
		["Ravage"] = "劫掠",
		["Readiness"] = "準備就緒",
		["Rebirth"] = "復生",
		["Reckless Charge"] = "無畏衝鋒",
		["Recklessness"] = "魯莽",
		["Reckoning"] = "清算",
		["Redemption"] = "救贖",
		["Redoubt"] = "盾牌壁壘",
		["Reflection"] = "反射",
		["Regeneration"] = "再生",
		["Regrowth"] = "癒合",
		["Reincarnation"] = "復生效果",
		["Reinforced Shield"] = "強化盾牌",
		["Rejuvenation"] = "回春術",
		["Relentless Strikes"] = "無情打擊",
		["Remorseless"] = "冷酷",
		["Remorseless Attacks"] = "冷酷攻擊",
		["Remote Toy"] = "遙控玩具",
		["Remove Curse"] = "解除詛咒",
		["Remove Insignia"] = "解除徽記",
		["Remove Lesser Curse"] = "解除次級詛咒",
		["Rend"] = "撕裂",
		["Renew"] = "恢復",
		["Repentance"] = "懺悔",
		["Restless Strength"] = "充沛之力",
		["Restorative Totems"] = "強化恢復系圖騰",
		["Resurrection"] = "復活術",
		["Retaliation"] = "反擊風暴",
		["Retribution Aura"] = "懲罰光環",
		["Revenge"] = "復仇",
		["Revenge Stun"] = "復仇昏迷",
		["Reverberation"] = "迴響",
		["Revive Pet"] = "復活寵物",
		["Righteous Defense"] = "正義防禦",
		["Righteous Fury"] = "正義之怒",
		["Rip"] = "撕扯",
		["Riposte"] = "還擊",
		["Ritual of Doom"] = "末日儀式",
		["Ritual of Doom Effect"] = "末日儀式效果",
		["Ritual of Refreshment"] = "餐點儀式",
		["Ritual of Souls"] = "靈魂儀式",
		["Ritual of Summoning"] = "召喚儀式",
		["Rockbiter Weapon"] = "石化武器",
		["Rough Sharpening Stone"] = "劣質磨刀石",
		["Ruin"] = "毀滅",
		["Rupture"] = "割裂",
		["Ruthlessness"] = "無情",
		["Sacrifice"] = "犧牲",
		["Safe Fall"] = "安全降落",
		["Sanctified Crusader"] = "聖化十字軍",
		["Sanctified Judgement"] = "聖化審判",
		["Sanctified Light"] = "聖化之光",
		["Sanctity Aura"] = "聖潔光環",
		["Sap"] = "悶棍",
		["Savage Fury"] = "野蠻暴怒",
		["Savage Strikes"] = "猛烈強擊",
		["Scare Beast"] = "恐嚇野獸",
		["Scatter Shot"] = "驅散射擊",
		["Scorch"] = "灼燒",
		["Scorpid Poison"] = "蠍毒",
		["Scorpid Sting"] = "毒蠍釘刺",
		["Screech"] = "尖嘯",
		["Seal Fate"] = "封印命運",
		["Seal of Blood"] = "血之聖印",
		["Seal of Command"] = "命令聖印",
		["Seal of Justice"] = "公正聖印",
		["Seal of Light"] = "光明聖印",
		["Seal of Righteousness"] = "正義聖印",
		["Seal of Vengeance"] = "復仇聖印",
		["Seal of Wisdom"] = "智慧聖印",
		["Seal of the Crusader"] = "十字軍聖印",
		["Searing Light"] = "灼熱之光",
		["Searing Pain"] = "灼熱之痛",
		["Searing Totem"] = "灼熱圖騰",
		["Second Wind"] = "復甦之風",
		["Seduction"] = "誘惑",
		["Seed of Corruption"] = "腐蝕種子",
		["Seethe"] = "激動",
		["Sense Demons"] = "感知惡魔",
		["Sense Undead"] = "感知不死生物",
		["Sentry Totem"] = "崗哨圖騰",
		["Serpent Sting"] = "毒蛇釘刺",
		["Serrated Blades"] = "鋸刃",
		["Setup"] = "算計",
		["Shackle Undead"] = "束縛不死生物",
		["Shadow Affinity"] = "暗影親和",
		["Shadow Bolt"] = "暗影箭",
		["Shadow Embrace"] = "暗影之擁",
		["Shadow Focus"] = "暗影集中",
		["Shadow Mastery"] = "精通暗影",
		["Shadow Power"] = "暗影強化",
		["Shadow Protection"] = "暗影防護",
		["Shadow Reach"] = "暗影延伸",
		["Shadow Resistance"] = "暗影抗性",
		["Shadow Resistance Aura"] = "暗影抗性光環",
		["Shadow Trance"] = "暗影冥思",
		["Shadow Vulnerability"] = "暗影易傷",
		["Shadow Ward"] = "防護暗影結界",
		["Shadow Weakness"] = "暗影虛弱",
		["Shadow Weaving"] = "暗影交織",
		["Shadow Word: Death"] = "暗言術:死",
		["Shadow Word: Pain"] = "暗言術:痛",
		["Shadow and Flame"] = "暗影與火焰",
		["Shadow of Death"] = "死亡之影",
		["Shadowburn"] = "暗影灼燒",
		["Shadowfiend"] = "暗影惡魔",
		["Shadowform"] = "暗影形態",
		["Shadowfury"] = "暗影之怒",
		["Shadowguard"] = "暗影守衛",
		["Shadowmeld"] = "影遁",
		["Shadowmeld Passive"] = "影遁",
		["Shadowstep"] = "暗影閃現",
		["Shamanistic Rage"] = "薩滿之怒",
		["Sharpened Claws"] = "鋒利獸爪",
		["Shatter"] = "碎冰",
		["Shear"] = "銳減",
		["Shell Shield"] = "甲殼護盾",
		["Shield"] = "盾牌",
		["Shield Bash"] = "盾擊",
		["Shield Bash - Silenced"] = "盾擊 - 沉默",
		["Shield Block"] = "盾牌格擋",
		["Shield Slam"] = "盾牌猛擊",
		["Shield Specialization"] = "盾牌專精",
		["Shield Wall"] = "盾牆",
		["Shiv"] = "毒襲",
		["Shoot"] = "射擊",
		["Shoot Bow"] = "弓射擊",
		["Shoot Gun"] = "火槍射擊",
		["Shred"] = "撕碎",
		["Shredding Attacks"] = "撕碎攻擊",
		["Silence"] = "沉默",
		["Silencing Shot"] = "沉默射擊",
		["Silent Resolve"] = "無聲消退",
		["Silverwing Flag"] = "銀翼旗幟",
		["Sinister Strike"] = "邪惡攻擊",
		["Siphon Life"] = "生命虹吸",
		["Skinning"] = "剝皮",
		["Slam"] = "猛擊",
		["Slayer's Crest"] = "屠殺紋飾",
		["Sleep"] = "催眠術",
		["Slice and Dice"] = "切割",
		["Slow"] = "減速術",
		["Slow Fall"] = "緩落術",
		["Smelting"] = "熔煉",
		["Smite"] = "懲擊",
		["Snake Trap"] = "毒蛇陷阱",
		["Solid Sharpening Stone"] = "堅固的磨刀石",
		["Sonic Burst"] = "音爆",
		["Soothe Animal"] = "安撫動物",
		["Soothing Kiss"] = "安撫之吻",
		["Soul Fire"] = "靈魂之火",
		["Soul Leech"] = "靈魂汲取",
		["Soul Link"] = "靈魂鏈結",
		["Soul Siphon"] = "靈魂虹吸",
		["Soulshatter"] = "靈魂粉碎",
		["Soulstone Resurrection"] = "靈魂石復活",
		["Spell Haste"] = "施法加速",
		["Spell Lock"] = "法術封鎖",
		["Spell Power"] = "法術能量",
		["Spell Reflection"] = "法術反射",
		["Spell Vulnerability"] = "法術易傷",
		["Spell Warding"] = "抗法結界",
		["Spellsteal"] = "法術竊取",
		["Spirit Bond"] = "靈魂聯結",
		["Spirit Tap"] = "精神分流",
		["Spirit of Redemption"] = "救贖之靈",
		["Spiritual Attunement"] = "精神調和",
		["Spiritual Focus"] = "精神集中",
		["Spiritual Guidance"] = "精神導引",
		["Spiritual Healing"] = "精神治療",
		["Spiteful Fury"] = "惡意的憤怒",
		["Sprint"] = "疾跑",
		["Stance Mastery"] = "精通姿態",
		["Starfire"] = "星火術",
		["Starfire Stun"] = "星火昏迷",
		["Starlight Wrath"] = "強化憤怒",
		["Starshards"] = "星辰裂片",
		["Static Charge"] = "靜電衝鋒",
		["Staves"] = "法杖",
		["Steady Shot"] = "穩固射擊",
		["Stealth"] = "潛行",
		["Stoneclaw Stun"] = "石爪昏迷",
		["Stoneclaw Totem"] = "石爪圖騰",
		["Stoneform"] = "石像形態",
		["Stoneskin"] = "石甲術",
		["Stoneskin Totem"] = "石甲圖騰",
		["Stormstrike"] = "風暴打擊",
		["Strength of Earth"] = "大地之力",
		["Strength of Earth Totem"] = "大地之力圖騰",
		["Strength of the Halaani"] = "哈剌尼之力",
		["Stuck"] = "卡死",
		["Stun"] = "擊昏",
		["Subtlety"] = "微妙",
		["Suffering"] = "受難",
		["Summon Charger"] = "召喚戰馬",
		["Summon Dreadsteed"] = "召喚恐懼戰馬",
		["Summon Felguard"] = "召喚惡魔守衛",
		["Summon Felhunter"] = "召喚惡魔獵犬",
		["Summon Felsteed"] = "召喚惡魔戰馬",
		["Summon Imp"] = "召喚小鬼",
		["Summon Succubus"] = "召喚魅魔",
		["Summon Voidwalker"] = "召喚虛無行者",
		["Summon Warhorse"] = "召喚戰馬",
		["Summon Water Elemental"] = "召喚水元素",
		["Sunder Armor"] = "破甲攻擊",
		["Suppression"] = "鎮壓",
		["Surefooted"] = "穩固",
		["Surge of Light"] = "光之澎湃",
		["Surprise Attacks"] = "出奇攻擊",
		["Survivalist"] = "生存專家",
		["Sweeping Strikes"] = "橫掃攻擊",
		["Swift Flight Form"] = "迅捷飛行形態",
		["Swiftmend"] = "迅癒",
		["Swipe"] = "揮擊",
		["Sword Specialization"] = "劍類武器專精",
		["Symbol of Hope"] = "希望符記",
		["Tactical Mastery"] = "精通戰術",
		["Tailoring"] = "裁縫",
		["Tainted Blood"] = "腐壞之血",
		["Tainted Mind"] = "污濁之魂",
		["Tame Beast"] = "馴服野獸",
		["Taunt"] = "嘲諷",
		["Teleport: Darnassus"] = "傳送:達納蘇斯",
		["Teleport: Exodar"] = "傳送:艾克索達",
		["Teleport: Ironforge"] = "傳送:鐵爐堡",
		["Teleport: Moonglade"] = "傳送:月光林地",
		["Teleport: Orgrimmar"] = "傳送:奧格瑪",
		["Teleport: Shattrath"] = "傳送:撒塔斯",
		["Teleport: Silvermoon"] = "傳送:銀月城",
		["Teleport: Stormwind"] = "傳送:暴風城",
		["Teleport: Thunder Bluff"] = "傳送:雷霆崖",
		["Teleport: Undercity"] = "傳送:幽暗城",
		["Temporal Rift"] = "時光裂縫",
		["The Beast Within"] = "獸心",
		["The Human Spirit"] = "人類精魂",
		["Thick Hide"] = "厚皮",
		["Thorns"] = "荊棘術",
		["Thrill of the Hunt"] = "追獵回饋",
		["Throw"] = "投擲",
		["Throwing Specialization"] = "投擲專精",
		["Thrown"] = "投擲武器",
		["Thunder Clap"] = "雷霆一擊",
		["Thunderfury"] = "雷霆之怒",
		["Thundering Strikes"] = "雷鳴猛擊",
		["Thunderstomp"] = "雷霆踐踏",
		["Tidal Focus"] = "潮汐集中",
		["Tidal Mastery"] = "精通潮汐",
		["Tiger Riding"] = "騎術:豹",
		["Tiger's Fury"] = "猛虎之怒",
		["Time's Favor"] = "時間的恩惠",
		["Torment"] = "折磨",
		["Totem"] = "圖騰",
		["Totem of Wrath"] = "憤怒圖騰",
		["Totemic Call"] = "圖騰的呼喚",
		["Totemic Focus"] = "圖騰集中",
		["Touch of Shadow"] = "暗影之觸",
		["Touch of Weakness"] = "虛弱之觸",
		["Toughness"] = "堅韌",
		["Traces of Silithyst"] = "希利蘇斯的痕跡",
		["Track Beasts"] = "追蹤野獸",
		["Track Demons"] = "追蹤惡魔",
		["Track Dragonkin"] = "追蹤龍類",
		["Track Elementals"] = "追蹤元素生物",
		["Track Giants"] = "追蹤巨人",
		["Track Hidden"] = "追蹤隱藏生物",
		["Track Humanoids"] = "追蹤人型生物",
		["Track Undead"] = "追蹤不死生物",
		["Tranquil Air"] = "寧靜之風",
		["Tranquil Air Totem"] = "寧靜之風圖騰",
		["Tranquil Spirit"] = "寧靜之魂",
		["Tranquility"] = "寧靜",
		["Tranquilizing Shot"] = "寧神射擊",
		["Trap Mastery"] = "精通陷阱",
		["Travel Form"] = "旅行形態",
		["Tree of Life"] = "生命之樹",
		["Tremor Totem"] = "戰慄圖騰",
		["Tribal Leatherworking"] = "部族製皮",
		["Trueshot Aura"] = "強擊光環",
		["Turn Undead"] = "超渡不死生物",
		["Twin Spire Blessing"] = "雙塔祝福",
		["Two-Handed Axes"] = "雙手斧",
		["Two-Handed Axes and Maces"] = "雙手斧和錘",
		["Two-Handed Maces"] = "雙手錘",
		["Two-Handed Swords"] = "雙手劍",
		["Two-Handed Weapon Specialization"] = "雙手武器專精",
		["Unarmed"] = "徒手戰鬥",
		["Unbreakable Will"] = "堅定意志",
		["Unbridled Wrath"] = "怒不可遏",
		["Undead Horsemanship"] = "騎術:骸骨戰馬",
		["Underwater Breathing"] = "水下呼吸",
		["Unending Breath"] = "魔息術",
		["Unholy Power"] = "邪惡強化",
		["Unleashed Fury"] = "狂怒釋放",
		["Unleashed Rage"] = "怒不可抑",
		["Unstable Affliction"] = "痛苦動盪",
		["Unstable Power"] = "能量無常",
		["Unyielding Faith"] = "不滅信仰",
		["Upset Tummy"] = "腸胃不適",
		["Vampiric Embrace"] = "吸血鬼的擁抱",
		["Vampiric Touch"] = "吸血之觸",
		["Vanish"] = "消失",
		["Vanished"] = "消失",
		["Vengeance"] = "復仇",
		["Venomous Totem"] = "毒性圖騰",
		["Victory Rush"] = "勝利衝擊",
		["Vigor"] = "精力",
		["Vile Beam"] = "卑鄙波動",
		["Vile Poisons"] = "惡性毒藥",
		["Vindication"] = "辯護",
		["Viper Sting"] = "蝮蛇釘刺",
		["Volley"] = "亂射",
		["Wand Specialization"] = "魔杖專精",
		["Wands"] = "魔杖",
		["War Stomp"] = "戰爭踐踏",
		["Warp"] = "扭曲傳送",
		["Warsong Flag"] = "戰歌旗幟",
		["Water Breathing"] = "水下呼吸",
		["Water Shield"] = "水之盾",
		["Water Tomb"] = "水之墳",
		["Water Walking"] = "水上行走",
		["Waterbolt"] = "水箭",
		["Watery Grave"] = "水之墓",
		["Weakened Soul"] = "虛弱靈魂",
		["Weapon Mastery"] = "精通武器",
		["Weaponsmith"] = "武器鑄造",
		["Well Fed"] = "充分進食",
		["Whirlwind"] = "旋風斬",
		["Will of the Forsaken"] = "亡靈意志",
		["Windfury"] = "風怒",
		["Windfury Attack"] = "風怒攻擊",
		["Windfury Totem"] = "風怒圖騰",
		["Windfury Weapon"] = "風怒武器",
		["Windwall"] = "風牆",
		["Windwall Totem"] = "風牆圖騰",
		["Wing Clip"] = "摔絆",
		["Winter's Chill"] = "深冬之寒",
		["Wisp Spirit"] = "幽光之魂",
		["Wolf Riding"] = "騎術:狼",
		["Wound Poison"] = "致傷毒藥",
		["Wound Poison II"] = "致傷毒藥 II",
		["Wound Poison III"] = "致傷毒藥 III",
		["Wound Poison IV"] = "致傷毒藥 IV",
		["Wound Poison V"] = "致傷毒藥 V",
		["Wrath"] = "憤怒",
		["Wrath of Air Totem"] = "風懲圖騰",
		["Wrath of Cenarius"] = "塞納留斯之怒",
		["Wrath of the Astromancer"] = "星術師之怒",
		["Wyvern Sting"] = "翼龍釘刺",
	}
end)

BabbleSpell:RegisterTranslations("koKR", function()
	return {
		["Abolish Disease"] = "질병 해제",
		["Abolish Poison"] = "독 해제",
		["Abolish Poison Effect"] = "독 해제 효과",
		["Activate MG Turret"] = "기관포",
		["Adrenaline Rush"] = "아드레날린 촉진",
		["Aftermath"] = "재앙의 여파",
		["Aggression"] = "공격성",
		["Agonizing Flames"] = "고뇌의 불꽃",
		["Aimed Shot"] = "조준 사격",
		["Alchemy"] = "연금술",
		["Ambush"] = "매복",
		["Amplify Curse"] = "저주 증폭",
		["Amplify Magic"] = "마법 증폭",
		["Ancestral Fortitude"] = "선인의 인내력",
		["Ancestral Healing"] = "선인의 치유력",
		["Ancestral Knowledge"] = "선인의 지혜",
		["Ancestral Spirit"] = "고대의 영혼",
		["Ancient Hysteria"] = "고대의 격분",
		["Anesthetic Poison"] = "정신 마취 독",
		["Anger Management"] = "분노 제어",
		["Anguish"] = "고뇌",
		["Anticipation"] = "직감",
		["Aquatic Form"] = "바다표범 변신",
		["Arcane Blast"] = "비전 작렬",
		["Arcane Brilliance"] = "신비한 총명함",
		["Arcane Concentration"] = "신비한 정신집중",
		["Arcane Energy"] = "비전 에너지",
		["Arcane Explosion"] = "신비한 폭발",
		["Arcane Focus"] = "신비한 집중",
		["Arcane Fortitude"] = "신비한 인내력",
		["Arcane Impact"] = "신비한 충돌",
		["Arcane Instability"] = "신비한 불안정성",
		["Arcane Intellect"] = "신비한 지능",
		["Arcane Meditation"] = "신비한 명상",
		["Arcane Mind"] = "신비한 정신",
		["Arcane Missiles"] = "신비한 화살",
		["Arcane Potency"] = "신비한 잠재력",
		["Arcane Power"] = "신비의 마법 강화",
		["Arcane Resistance"] = "비전 저항력",
		["Arcane Shot"] = "신비한 사격",
		["Arcane Shroud"] = "신비의 장막",
		["Arcane Subtlety"] = "신비한 미묘함",
		["Arcane Torrent"] = "비전 격류",
		["Arcane Weakness"] = "비전 약점",
		["Arctic Reach"] = "혹한의 손길",
		["Arctic Winds"] = "북극의 바람",
		["Armor of Faith"] = "신념의 갑옷",
		["Armorsmith"] = "방어구제작",
		["Aspect of the Beast"] = "야수의 상",
		["Aspect of the Cheetah"] = "치타의 상",
		["Aspect of the Hawk"] = "매의 상",
		["Aspect of the Monkey"] = "원숭이의 상",
		["Aspect of the Pack"] = "치타 무리의 상",
		["Aspect of the Viper"] = "독사의 상",
		["Aspect of the Wild"] = "야생의 상",
		["Astral Recall"] = "영혼의 귀환",
		["Attack"] = "공격",
		["Attacking"] = "파괴 중",
		["Auto Shot"] = "자동 사격",
		["Avenger's Shield"] = "응징의 방패",
		["Avenging Wrath"] = "응징의 격노",
		["Avoidance"] = "마력 회피",
		["Axe Specialization"] = "도끼류 전문화",
		["Backlash"] = "반발력",
		["Backstab"] = "기습",
		["Badge of the Swarmguard"] = "전투감시병의 휘장",
		["Balance of Power"] = "힘의 균형",
		["Bane"] = "파멸",
		["Banish"] = "추방",
		["Banshee Curse"] = "밴시의 저주",
		["Barkskin"] = "나무 껍질",
		["Barrage"] = "탄막",
		["Bash"] = "강타",
		["Basic Campfire"] = "작은 모닥불",
		["Battle Rush"] = "전투 돌격",
		["Battle Shout"] = "전투의 외침",
		["Battle Stance"] = "전투 태세",
		["Battle Stance Passive"] = "전투 태세",
		["Bear Form"] = "곰 변신",
		["Beast Lore"] = "야수 연구",
		["Beast Slaying"] = "야수 사냥 전문화",
		["Beast Training"] = "야수 조련",
		["Benediction"] = "축복의 기도",
		["Berserker Rage"] = "광전사의 격노",
		["Berserker Stance"] = "광폭 태세",
		["Berserker Stance Passive"] = "광폭 태세 지속효과",
		["Berserking"] = "광폭화",
		["Bestial Discipline"] = "야수 훈련",
		["Bestial Swiftness"] = "야수의 신속함",
		["Bestial Wrath"] = "야수의 격노",
		["Binding Heal"] = "결속의 치유",
		["Bite"] = "물기",
		["Black Arrow"] = "검은 화살",
		["Blackout"] = "의식 상실",
		["Blacksmithing"] = "대장기술",
		["Blade Flurry"] = "폭풍의 칼날",
		["Blade Turning"] = "칼날 전환",
		["Blade Twisting"] = "칼날 비틀기",
		["Blast Wave"] = "화염 폭풍",
		["Blazing Speed"] = "타오르는 속도",
		["Blessed Recovery"] = "축복받은 회복력",
		["Blessed Resilience"] = "축복받은 탄력성",
		["Blessing of Auchindoun"] = "아킨둔의 축복",
		["Blessing of Freedom"] = "자유의 축복",
		["Blessing of Kings"] = "왕의 축복",
		["Blessing of Light"] = "빛의 축복",
		["Blessing of Might"] = "힘의 축복",
		["Blessing of Protection"] = "보호의 축복",
		["Blessing of Sacrifice"] = "희생의 축복",
		["Blessing of Salvation"] = "구원의 축복",
		["Blessing of Sanctuary"] = "성역의 축복",
		["Blessing of Wisdom"] = "지혜의 축복",
		["Blind"] = "실명",
		["Blinding Powder"] = "실명 가루",
		["Blink"] = "점멸",
		["Blizzard"] = "눈보라",
		["Block"] = "방어",
		["Blood Craze"] = "피의 광기",
		["Blood Frenzy"] = "피의 광기",
		["Blood Fury"] = "피의 격노",
		["Blood Pact"] = "피의 서약",
		["Bloodboil"] = "끓어오르는 피",
		["Bloodlust"] = "피의 욕망",
		["Bloodrage"] = "피의 분노",
		["Bloodthirst"] = "피의 갈증",
		["Boar Charge"] = "멧돼지 돌진",
		["Booming Voice"] = "우렁찬 음성",
		["Bow Specialization"] = "활류 전문화",
		["Bows"] = "활",
		["Bright Campfire"] = "밝은 모닥불",
		["Brittle Armor"] = "불완전한 갑옷",
		["Brutal Impact"] = "야수의 습격",
		["Burning Adrenaline"] = "불타는 아드레날린",
		["Burning Soul"] = "불타는 영혼",
		["Burning Wish"] = "불타는 소원",
		["Call Pet"] = "야수 부르기",
		["Call of Flame"] = "불꽃의 부름",
		["Call of Thunder"] = "천둥의 부름",
		["Call of the Nexus"] = "연합의 부름",
		["Camouflage"] = "위장술",
		["Cannibalize"] = "시체먹기",
		["Cat Form"] = "표범 변신",
		["Cataclysm"] = "재앙",
		["Celestial Focus"] = "하늘의 정신 집중",
		["Chain Heal"] = "연쇄 치유",
		["Chain Lightning"] = "연쇄 번개",
		["Challenging Roar"] = "도전의 포효",
		["Challenging Shout"] = "도전의 외침",
		["Charge"] = "돌진",
		["Charge Rage Bonus Effect"] = "보너스 분노 충전 효과",
		["Charge Stun"] = "돌진 기절",
		["Chastise"] = "응징",
		["Cheap Shot"] = "비열한 습격",
		["Chilled"] = "빙결",
		["Circle of Healing"] = "치유의 마법진",
		["Claw"] = "할퀴기",
		["Cleanse"] = "정화",
		["Clearcasting"] = "정신 집중",
		["Cleave"] = "회전베기",
		["Clever Traps"] = "덫 개량",
		["Cloak of Shadows"] = "그림자 망토",
		["Closing"] = "닫는 중",
		["Cloth"] = "천",
		["Coarse Sharpening Stone"] = "일반 숫돌",
		["Cobra Reflexes"] = "코브라의 반사신경",
		["Cold Blood"] = "냉혈",
		["Cold Snap"] = "매서운 한파",
		["Combat Endurance"] = "전투 지구력",
		["Combustion"] = "발화",
		["Command"] = "지배",
		["Commanding Presence"] = "위엄 있는 풍채",
		["Commanding Shout"] = "지휘의 외침",
		["Concentration Aura"] = "집중의 오라",
		["Concussion"] = "촉발",
		["Concussion Blow"] = "충격의 일격",
		["Concussive Barrage"] = "집중 포화",
		["Concussive Shot"] = "충격포",
		["Cone of Cold"] = "냉기 돌풍",
		["Conflagrate"] = "점화",
		["Conflagration"] = "거대한 불길",
		["Conjure Food"] = "음식 창조",
		["Conjure Mana Agate"] = "마나 마노 창조",
		["Conjure Mana Citrine"] = "마나 황수정 창조",
		["Conjure Mana Emerald"] = "마나 에메랄드 창조",
		["Conjure Mana Jade"] = "마나 비취 창조",
		["Conjure Mana Ruby"] = "마나 루비 창조",
		["Conjure Water"] = "음료 창조",
		["Consecration"] = "신성화",
		["Consume Magic"] = "마법 삼키기",
		["Consume Shadows"] = "어둠 흡수",
		["Contagion"] = "전염",
		["Convection"] = "기의 흐름",
		["Conviction"] = "자각",
		["Cooking"] = "요리",
		["Corruption"] = "부패",
		["Counterattack"] = "역습",
		["Counterspell"] = "마법 차단",
		["Counterspell - Silenced"] = "마법 차단 - 침묵",
		["Cower"] = "웅크리기",
		["Create Firestone"] = "화염석 창조",
		["Create Firestone (Greater)"] = "화염석 창조 (상급)",
		["Create Firestone (Lesser)"] = "화염석 창조 (하급)",
		["Create Firestone (Major)"] = "화염석 창조 (최상급)",
		["Create Healthstone"] = "생명석 창조",
		["Create Healthstone (Greater)"] = "생명석 창조 (상급)",
		["Create Healthstone (Lesser)"] = "생명석 창조 (하급)",
		["Create Healthstone (Major)"] = "생명석 창조 (최상급)",
		["Create Healthstone (Minor)"] = "생명석 창조 (최하급)",
		["Create Soulstone"] = "영혼석 창조",
		["Create Soulstone (Greater)"] = "영혼석 창조 (상급)",
		["Create Soulstone (Lesser)"] = "영혼석 창조 (하급)",
		["Create Soulstone (Major)"] = "영혼석 창조 (최상급)",
		["Create Soulstone (Minor)"] = "영혼석 창조 (최하급)",
		["Create Spellstone"] = "주문석 창조",
		["Create Spellstone (Greater)"] = "주문석 창조 (상급)",
		["Create Spellstone (Major)"] = "주문석 창조 (최상급)",
		["Create Spellstone (Master)"] = "주문석 창조 (일급)",
		["Creeping Paralysis"] = "섬뜩한 마비",  -- Check
		["Cripple"] = "신경 마비",
		["Crippling Poison"] = "신경 마비 독",
		["Crippling Poison II"] = "신경 마비 독 II",
		["Critical Mass"] = "화염 결집",
		["Crossbows"] = "석궁",
		["Cruelty"] = "무자비함",
		["Crusade"] = "성전",
		["Crusader Aura"] = "성전사의 오라",
		["Crusader Strike"] = "성전사의 일격",
		["Cultivation"] = "재배",
		["Cure Disease"] = "질병 치료",
		["Cure Poison"] = "해독",
		["Curse of Agony"] = "고통의 저주",
		["Curse of Doom"] = "파멸의 저주",
		["Curse of Doom Effect"] = "파멸의 저주 효과",
		["Curse of Exhaustion"] = "피로의 저주",
		["Curse of Idiocy"] = "무지의 저주",
		["Curse of Recklessness"] = "무모함의 저주",
		["Curse of Shadow"] = "어둠의 저주",
		["Curse of Tongues"] = "언어의 저주",
		["Curse of Weakness"] = "무력화 저주",
		["Curse of the Elements"] = "원소의 저주",
		["Cyclone"] = "회오리바람",
		["Dagger Specialization"] = "단검류 전문화",
		["Daggers"] = "단검",
		["Dampen Magic"] = "마법 감쇠",
		["Dark Barrage"] = "암흑의 보호막",
		["Dark Pact"] = "암흑의 계약",
		["Darkness"] = "어둠",
		["Dash"] = "질주",
		["Dawnstone Crab"] = "여명석 게",
		["Dazed"] = "멍해짐",
		["Deadly Interrupt Effect"] = "죽음의 투척 방해 효과",
		["Deadly Poison"] = "맹독",
		["Deadly Poison II"] = "맹독 II",
		["Deadly Poison III"] = "맹독 III",
		["Deadly Poison IV"] = "맹독 IV",
		["Deadly Poison V"] = "맹독 V",
		["Deadly Poison VI"] = "맹독 VI",
		["Deadly Poison VII"] = "맹독 VII",
		["Deadly Throw"] = "죽음의 투척",
		["Death Coil"] = "죽음의 고리",
		["Death Wish"] = "죽음의 소원",
		["Deep Wound"] = "치명상",
		["Deep Wounds"] = "치명상",
		["Defense"] = "방어",
		["Defensive Stance"] = "방어 태세",
		["Defensive Stance Passive"] = "방어 태세 지속효과",
		["Defiance"] = "도전",
		["Deflection"] = "재빠른 손놀림",
		["Delusions of Jin'do"] = "진도의 망상",
		["Demon Armor"] = "악마의 갑옷",
		["Demon Skin"] = "악마의 피부",
		["Demonic Aegis"] = "악마의 보호",
		["Demonic Embrace"] = "악마의 은총",
		["Demonic Frenzy"] = "악마의 광기",
		["Demonic Knowledge"] = "악마의 지식",
		["Demonic Resilience"] = "악마의 탄력성",
		["Demonic Sacrifice"] = "악의 제물",
		["Demonic Tactics"] = "악마의 술책",
		["Demoralizing Roar"] = "위협의 포효",
		["Demoralizing Shout"] = "사기의 외침",
		["Dense Sharpening Stone"] = "강도 높은 숫돌",
		["Desperate Prayer"] = "구원의 기도",
		["Destructive Reach"] = "파괴의 테두리",
		["Detect"] = "감지",
		["Detect Greater Invisibility"] = "상급 투명체 감지",
		["Detect Invisibility"] = "투명체 감지",
		["Detect Lesser Invisibility"] = "하급 투명체 감지",
		["Detect Magic"] = "마법 감지",
		["Detect Traps"] = "함정 감지",
		["Deterrence"] = "공격 저지",
		["Devastate"] = "압도",
		["Devastation"] = "황폐",
		["Devotion Aura"] = "기원의 오라",
		["Devour Magic"] = "마법 삼키기",
		["Devour Magic Effect"] = "마법 삼키기 효과",
		["Devouring Plague"] = "파멸의 역병",
		["Diplomacy"] = "외교",
		["Dire Bear Form"] = "광포한 곰 변신",
		["Dirty Deeds"] = "비열한 행위",
		["Dirty Tricks"] = "비열한 속임수",
		["Disarm"] = "무장 해제",
		["Disarm Trap"] = "함정 해제",
		["Disease Cleansing Totem"] = "질병 정화 토템",
		["Disenchant"] = "마력 추출",
		["Disengage"] = "철수",
		["Dismiss Pet"] = "야수 소환 해제",
		["Dispel Magic"] = "마법 무효화",
		["Distract"] = "혼란",
		["Distracting Shot"] = "견제 사격",
		["Dive"] = "급강하",
		["Divine Favor"] = "신의 은총",
		["Divine Fury"] = "신의 격노",
		["Divine Illumination"] = "신의 계시",
		["Divine Intellect"] = "천상의 지능",
		["Divine Intervention"] = "성스러운 중재",
		["Divine Protection"] = "신의 가호",
		["Divine Shield"] = "천상의 보호막",
		["Divine Spirit"] = "천상의 정신",
		["Divine Strength"] = "천상의 힘",
		["Divine Wrath"] = "신성한 격노",
		["Dodge"] = "회피",
		["Doomfire"] = "파멸의 불",
		["Dragon's Breath"] = "용의 숨결",
		["Dragonscale Leatherworking"] = "용비늘 가죽세공",
		["Drain Life"] = "생명력 흡수",
		["Drain Mana"] = "마나 흡수",
		["Drain Soul"] = "영혼 흡수",
		["Dreamless Sleep"] = "숙면",
		["Drink"] = "음료",
		["Dual Wield"] = "쌍수 무기",
		["Dual Wield Specialization"] = "쌍수 무기 전문화",
		["Duel"] = "주문 7266",
		["Dust Cloud"] = "먼지 구름",
		["Eagle Eye"] = "독수리의 눈",
		["Earth Elemental Totem"] = "대지의 정령 토템",
		["Earth Shield"] = "대지의 보호막",
		["Earth Shock"] = "대지 충격",
		["Earthbind"] = "대지의 속박",
		["Earthbind Totem"] = "속박의 토템",
		["Earthstrike"] = "대지의 격동",
		["Efficiency"] = "사격술",
		["Elemental Devastation"] = "자연의 파괴력",
		["Elemental Focus"] = "정기의 집중",
		["Elemental Fury"] = "자연의 격노",
		["Elemental Leatherworking"] = "원소 가죽세공",
		["Elemental Mastery"] = "정기의 깨달음",
		["Elemental Precision"] = "정기의 정밀함",
		["Elemental Sharpening Stone"] = "원소 숫돌",
		["Elemental Weapons"] = "자연의 무기",
		["Elune's Grace"] = "엘룬의 은총",
		["Elusiveness"] = "약삭빠름",
		["Emberstorm"] = "불보라",
		["Empowered Arcane Missiles"] = "신비한 화살 강화",
		["Empowered Corruption"] = "부패 강화",
		["Empowered Fireball"] = "화염구 강화",
		["Empowered Frostbolt"] = "얼음 화살 강화",
		["Empowered Healing"] = "치유 강화",
		["Empowered Rejuvenation"] = "회복 강화",
		["Empowered Touch"] = "치유의 손길 강화",
		["Enamored Water Spirit"] = "사로잡힌 물의 정령",
		["Enchanting"] = "마법부여",
		["Endurance"] = "인내력",
		["Endurance Training"] = "지구력 훈련",
		["Engineering"] = "기계공학",
		["Engineering Specialization"] = "기계공학 전문화",
		["Enrage"] = "분노",
		["Enriched Manna Biscuit"] = "맛좋은 만나빵",
		["Enslave Demon"] = "악마 지배",
		["Entangling Roots"] = "휘감는 뿌리",
		["Entrapment"] = "올가미",
		["Envenom"] = "독살",
		["Escape Artist"] = "탈출의 명수",
		["Evasion"] = "회피",
		["Eviscerate"] = "절개",
		["Evocation"] = "환기",
		["Execute"] = "마무리 일격",
		["Exorcism"] = "퇴마술",
		["Expansive Mind"] = "영리함",
		["Explosive Trap"] = "폭발의 덫",
		["Explosive Trap Effect"] = "폭발의 덫",
		["Expose Armor"] = "약점 노출",
		["Expose Weakness"] = "결점 노출",
		["Extract Gas"] = "가스 추출",
		["Eye for an Eye"] = "눈에는 눈",
		["Eye of Kilrogg"] = "킬로그의 눈",
		["Eye of the Storm"] = "폭풍의 눈",
		["Eyes of the Beast"] = "야수의 눈",
		["Fade"] = "소실",
		["Faerie Fire"] = "요정의 불꽃",
		["Faerie Fire (Feral)"] = "요정의 불꽃 (야성)",
		["Fanaticism"] = "광신",
		["Far Sight"] = "천리안",
		["Fatal Attraction"] = "치명적인 매력",
		["Fear"] = "공포",
		["Fear Ward"] = "공포의 수호물",
		["Feed Pet"] = "먹이주기",
		["Feed Pet Effect"] = "먹이주기 효과",
		["Feedback"] = "역순환",
		["Feign Death"] = "죽은척하기",
		["Feint"] = "교란",
		["Fel Armor"] = "마의 갑옷",
		["Fel Concentration"] = "마의 정신집중",
		["Fel Domination"] = "마의 지배",
		["Fel Energy"] = "마의 에너지",
		["Fel Intellect"] = "마의 지능",
		["Fel Rage"] = "마의 분노",
		["Fel Stamina"] = "마의 체력",
		["Felfire"] = "지옥불",
		["Feline Grace"] = "살쾡이의 우아함",
		["Feral Aggression"] = "야생의 공격성",
		["Feral Charge"] = "야성의 돌진",
		["Feral Instinct"] = "야생의 본능",
		["Feral Swiftness"] = "야생의 기민함",
		["Ferocious Bite"] = "흉포한 이빨",
		["Ferocious Inspiration"] = "야성의 감응",
		["Ferocity"] = "야수의 본성",
		["Fetish"] = "우상",
		["Find Fish"] = "물고기 찾기",
		["Find Herbs"] = "약초 찾기",
		["Find Minerals"] = "광물 찾기",
		["Find Treasure"] = "보물 찾기",
		["Find Weakness"] = "약점 포착",
		["Fire Blast"] = "화염 작렬",
		["Fire Breath"] = "불의 숨결",
		["Fire Elemental Totem"] = "불의 정령 토템",
		["Fire Nova Totem"] = "불꽃 회오리 토템",
		["Fire Power"] = "화염 마법 강화",
		["Fire Resistance"] = "화염 마법 저항",
		["Fire Resistance Aura"] = "화염 저항의 오라",
		["Fire Resistance Totem"] = "화염 저항 토템",
		["Fire Shield"] = "화염 보호막",
		["Fire Vulnerability"] = "화염 저항력 약화",
		["Fire Ward"] = "화염계 수호",
		["Fire Weakness"] = "화염 약점",
		["Fireball"] = "화염구",
		["Firebolt"] = "불화살",
		["First Aid"] = "응급치료",
		["Fishing"] = "낚시",
		["Fishing Poles"] = "낚싯대",
		["Fist Weapon Specialization"] = "장착 무기류 전문화",
		["Fist Weapons"] = "장착 무기류",
		["Flame Shock"] = "화염 충격",
		["Flame Throwing"] = "화염 발사",
		["Flamestrike"] = "불기둥",
		["Flamethrower"] = "화염방사기",
		["Flametongue Attack"] = "불꽃의 공격",
		["Flametongue Totem"] = "불꽃의 토템",
		["Flametongue Weapon"] = "불꽃의 무기",
		["Flare"] = "섬광",
		["Flash Heal"] = "순간 치유",
		["Flash of Light"] = "빛의 섬광",
		["Flight Form"] = "폭풍까마귀 변신",
		["Flurry"] = "질풍",
		["Focused Casting"] = "집중력",
		["Focused Mind"] = "흐트러짐 없는 마음",
		["Focused Power"] = "집중된 마력",
		["Focused Rage"] = "분노 집중",
		["Focused Starlight"] = "별빛 집중",
		["Food"] = "음식",
		["Forbearance"] = "참을성",
		["Force of Nature"] = "자연의 군대",
		["Force of Will"] = "의지의 힘",
		["Freezing Trap"] = "얼음의 덫",
		["Freezing Trap Effect"] = "얼음의 덫",
		["Frenzied Regeneration"] = "광포한 재생력",
		["Frenzy"] = "광기",
		["Frenzy Effect"] = "광기",
		["Frost Armor"] = "냉기 갑옷",
		["Frost Blast"] = "냉기 작렬",
		["Frost Channeling"] = "냉기계 정신집중",
		["Frost Nova"] = "얼음 회오리",
		["Frost Resistance"] = "냉기 마법 저항",
		["Frost Resistance Aura"] = "냉기 저항의 오라",
		["Frost Resistance Totem"] = "냉기 저항 토템",
		["Frost Shock"] = "냉기 충격",
		["Frost Trap"] = "냉기의 덫",
		["Frost Trap Aura"] = "냉기의 덫",
		["Frost Ward"] = "냉기계 수호",
		["Frost Warding"] = "냉기의 수호",
		["Frost Weakness"] = "냉기 약점",
		["Frostbite"] = "동상",
		["Frostbolt"] = "얼음 화살",
		["Frostbrand Attack"] = "냉기의 무기 공격",
		["Frostbrand Weapon"] = "냉기의 무기",
		["Frozen Core"] = "얼어붙은 핵",
		["Furious Howl"] = "사나운 울음소리",
		["Furor"] = "광란",
		["Fury of the Crashing Waves"] = "몰아치는 파도의 격노",
		["Garrote"] = "목조르기",
		["Garrote - Silence"] = "목조르기 - 침묵",
		["Ghost Wolf"] = "늑대 정령",
		["Ghostly Strike"] = "그림자 일격",
		["Gift of Life"] = "생명의 선물",
		["Gift of Nature"] = "자연의 선물",
		["Gift of the Naaru"] = "나루의 선물",
		["Gift of the Wild"] = "야생의 선물",
		["Gouge"] = "후려치기",
		["Grace of Air"] = "바람의 은총",
		["Grace of Air Totem"] = "은총의 토템",
		["Great Stamina"] = "강인한 체력",
		["Greater Blessing of Kings"] = "상급 왕의 축복",
		["Greater Blessing of Light"] = "상급 빛의 축복",
		["Greater Blessing of Might"] = "상급 힘의 축복",
		["Greater Blessing of Salvation"] = "상급 구원의 축복",
		["Greater Blessing of Sanctuary"] = "상급 성역의 축복",
		["Greater Blessing of Wisdom"] = "상급 지혜의 축복",
		["Greater Dreamless Sleep"] = "상급 숙면",
		["Greater Heal"] = "상급 치유",
		["Grievous Throw"] = "치명상",  -- Check
		["Grim Reach"] = "냉혹의 테두리",
		["Grounding Totem"] = "마법흡수 토템",
		["Grounding Totem Effect"] = "마법흡수 토템 효과",
		["Grovel"] = "주문 7267",
		["Growl"] = "포효",
		["Guardian's Favor"] = "수호신의 은총",
		["Gun Specialization"] = "총기류 전문화",
		["Guns"] = "총",
		["Hammer of Justice"] = "심판의 망치",
		["Hammer of Wrath"] = "천벌의 망치",
		["Hamstring"] = "무력화",
		["Harass"] = "괴롭히기",
		["Hardiness"] = "강인함",
		["Haste"] = "신속",
		["Hawk Eye"] = "매의 눈",
		["Heal"] = "치유",
		["Healing Focus"] = "치유의 집중",
		["Healing Light"] = "치유의 빛",
		["Healing Stream"] = "치유의 물결",
		["Healing Stream Totem"] = "치유의 토템",
		["Healing Touch"] = "치유의 손길",
		["Healing Wave"] = "치유의 물결",
		["Healing Way"] = "치유의 길",
		["Health Funnel"] = "생명력 집중",
		["Heart of the Wild"] = "야생의 정수",
		["Heavy Sharpening Stone"] = "단단한 숫돌",
		["Hellfire"] = "지옥의 불길",
		["Hellfire Effect"] = "지옥의 불길 효과",
		["Hellfire Superiority"] = "지옥불 사기충전",
		["Hemorrhage"] = "과다출혈",
		["Herb Gathering"] = "약초채집",
		["Herbalism"] = "약초 채집",
		["Heroic Strike"] = "영웅의 일격",
		["Heroism"] = "영웅심",
		["Hex of Weakness"] = "무력의 주술",
		["Hibernate"] = "겨울잠",
		["Holy Fire"] = "신성한 불꽃",
		["Holy Light"] = "성스러운 빛",
		["Holy Nova"] = "신성한 폭발",
		["Holy Power"] = "신성 마법 강화",
		["Holy Reach"] = "신성한 테두리",
		["Holy Shield"] = "신성한 방패",
		["Holy Shock"] = "신성 충격",
		["Holy Specialization"] = "신성 마법 전문화",
		["Holy Vengeance"] = "성스러운 복수",	--check
		["Holy Wrath"] = "신의 격노",
		["Honorless Target"] = "명예 점수 없음",
		["Horse Riding"] = "말 타기",
		["Howl of Terror"] = "공포의 울부짖음",
		["Humanoid Slaying"] = "인간형 사냥술",
		["Hunter's Mark"] = "사냥꾼의 징표",
		["Hurricane"] = "허리케인",
		["Hypothermia"] = "저체온증",
		["Ice Armor"] = "얼음 갑옷",
		["Ice Barrier"] = "얼음 보호막",
		["Ice Block"] = "얼음 방패",
		["Ice Floes"] = "빙하",
		["Ice Lance"] = "얼음창",
		["Ice Shards"] = "얼음 파편",
		["Icy Veins"] = "얼음 핏줄",
		["Ignite"] = "작열",
		["Ignite Mana"] = "마나 점화",
		["Illumination"] = "계시",
		["Immolate"] = "제물",
		["Immolation Trap"] = "제물의 덫",
		["Immolation Trap Effect"] = "제물의 덫",
		["Impact"] = "충돌",
		["Impale"] = "꿰뚫기",
		["Impaling Spine"] = "꿰뚫는 돌기",
		["Improved Ambush"] = "매복 연마",
		["Improved Arcane Missiles"] = "신비한 화살 연마",
		["Improved Arcane Shot"] = "신비한 사격 연마",
		["Improved Aspect of the Hawk"] = "매의 상 연마",
		["Improved Aspect of the Monkey"] = "원숭이의 상 연마",
		["Improved Backstab"] = "기습 연마",
		["Improved Barrage"] = "탄막 연마",
		["Improved Berserker Rage"] = "광전사의 격노 연마",
		["Improved Blessing of Might"] = "힘의 축복 연마",
		["Improved Blessing of Wisdom"] = "지혜의 축복 연마",
		["Improved Blink"] = "점멸 연마",
		["Improved Blizzard"] = "눈보라 연마",
		["Improved Bloodrage"] = "피의 분노 연마",
		["Improved Chain Heal"] = "연쇄 치유 연마",
		["Improved Chain Lightning"] = "연쇄 번개 연마",
		["Improved Challenging Shout"] = "도전의 외침 연마",
		["Improved Charge"] = "돌진 연마",
		["Improved Cleave"] = "회전베기 연마",
		["Improved Concentration Aura"] = "집중의 오라 연마",
		["Improved Concussive Shot"] = "충격포 연마",
		["Improved Cone of Cold"] = "냉기 돌풍 연마",
		["Improved Corruption"] = "부패 연마",
		["Improved Counterspell"] = "마법 차단 연마",
		["Improved Curse of Agony"] = "고통의 저주 연마",
		["Improved Curse of Weakness"] = "무력화 저주 연마",
		["Improved Demoralizing Shout"] = "사기의 외침 연마",
		["Improved Devotion Aura"] = "기원의 오라 연마",
		["Improved Disarm"] = "무장 해제 연마",
		["Improved Drain Life"] = "생명력 흡수 연마",
		["Improved Drain Soul"] = "영혼 흡수 연마",
		["Improved Enrage"] = "분노 연마",
		["Improved Enslave Demon"] = "악마 지배 연마",
		["Improved Eviscerate"] = "절개 연마",
		["Improved Execute"] = "마무리 일격 연마",
		["Improved Expose Armor"] = "약점 노출 연마",
		["Improved Eyes of the Beast"] = "야수의 눈 연마",
		["Improved Fade"] = "소실 연마",
		["Improved Feign Death"] = "죽은척하기 연마",
		["Improved Fire Blast"] = "화염 작렬 연마",
		["Improved Fire Totems"] = "불의 토템 연마",
		["Improved Fire Ward"] = "화염계 수호 연마",
		["Improved Fireball"] = "화염구 연마",
		["Improved Firebolt"] = "불화살 연마",
		["Improved Flamestrike"] = "불기둥 연마",
		["Improved Flash of Light"] = "빛의 섬광 연마",
		["Improved Frost Nova"] = "얼음 회오리 연마",
		["Improved Frostbolt"] = "얼음 화살 연마",
		["Improved Ghost Wolf"] = "늑대 정령 연마",
		["Improved Gouge"] = "후려치기 연마",
		["Improved Hammer of Justice"] = "심판의 망치 연마",
		["Improved Hamstring"] = "무력화 연마",
		["Improved Healing"] = "치유 연마",
		["Improved Healing Touch"] = "치유의 손길 연마",
		["Improved Healing Wave"] = "치유의 물결 연마",
		["Improved Health Funnel"] = "생명력 집중 연마",
		["Improved Healthstone"] = "생명석 연마",
		["Improved Heroic Strike"] = "영웅의 일격 연마",
		["Improved Holy Shield"] = "신성한 방패 연마",
		["Improved Howl of Terror"] = "공포의 울부짖음 연마",
		["Improved Hunter's Mark"] = "사냥꾼의 징표 연마",
		["Improved Immolate"] = "제물 연마",
		["Improved Imp"] = "임프 연마",
		["Improved Inner Fire"] = "내면의 열정 연마",
		["Improved Intercept"] = "봉쇄 연마",
		["Improved Intimidating Shout"] = "위협의 외침 연마",
		["Improved Judgement"] = "심판 연마",
		["Improved Kick"] = "발차기 연마",
		["Improved Kidney Shot"] = "급소 가격 연마",
		["Improved Lash of Pain"] = "고통의 채찍 연마",
		["Improved Lay on Hands"] = "신의 축복 연마",
		["Improved Leader of the Pack"] = "무리의 우두머리 연마",
		["Improved Life Tap"] = "생명력 전환 연마",
		["Improved Lightning Bolt"] = "번개 화살 연마",
		["Improved Lightning Shield"] = "번개 보호막 연마",
		["Improved Magma Totem"] = "용암 토템 연마",
		["Improved Mana Burn"] = "마나 연소 연마",
		["Improved Mana Shield"] = "마나 보호막 연마",
		["Improved Mana Spring Totem"] = "회복의 토템",
		["Improved Mark of the Wild"] = "야생의 징표 연마",
		["Improved Mend Pet"] = "동물 치료 연마",
		["Improved Mind Blast"] = "정신 분열 연마",
		["Improved Moonfire"] = "달빛 섬광 연마",
		["Improved Mortal Strike"] = "죽음의 일격 연마",
		["Improved Nature's Grasp"] = "자연의 손아귀 연마",
		["Improved Overpower"] = "제압 연마",
		["Improved Power Word: Fortitude"] = "신의 권능: 인내 연마",
		["Improved Power Word: Shield"] = "신의 권능: 보호막 연마",
		["Improved Prayer of Healing"] = "치유의 기원 연마",
		["Improved Psychic Scream"] = "영혼의 절규 연마",
		["Improved Regrowth"] = "재생 연마",
		["Improved Reincarnation"] = "윤회 연마",
		["Improved Rejuvenation"] = "회복 연마",
		["Improved Rend"] = "분쇄 연마",
		["Improved Renew"] = "소생 연마",
		["Improved Retribution Aura"] = "응보의 오라 연마",
		["Improved Revenge"] = "복수 연마",
		["Improved Revive Pet"] = "야수 되살리기 연마",
		["Improved Righteous Fury"] = "정의의 격노 연마",
		["Improved Rupture"] = "파열 연마",
		["Improved Scorch"] = "불태우기 연마",
		["Improved Scorpid Sting"] = "전갈 쐐기 연마",
		["Improved Seal of Righteousness"] = "정의의 문장 연마",
		["Improved Seal of the Crusader"] = "성전사의 문장 연마",
		["Improved Searing Pain"] = "불타는 고통 연마",
		["Improved Serpent Sting"] = "독사 쐐기 연마",
		["Improved Shadow Bolt"] = "어둠의 화살 연마",
		["Improved Shadow Word: Pain"] = "어둠의 권능: 고통 연마",
		["Improved Shield Bash"] = "방패 가격 연마",
		["Improved Shield Block"] = "방패 막기 연마",
		["Improved Shield Wall"] = "방패의 벽 연마",
		["Improved Sinister Strike"] = "사악한 일격 연마",
		["Improved Slam"] = "격돌 연마",
		["Improved Slice and Dice"] = "난도질 연마",
		["Improved Sprint"] = "전력 질주 연마",
		["Improved Stings"] = "쐐기 연마",
		["Improved Succubus"] = "서큐버스 연마",
		["Improved Sunder Armor"] = "방어구 가르기 연마",
		["Improved Taunt"] = "도발 연마",
		["Improved Thunder Clap"] = "천둥벼락 연마",
		["Improved Tranquility"] = "평온 연마",
		["Improved Vampiric Embrace"] = "흡혈의 선물 연마",
		["Improved Vanish"] = "소멸 연마",
		["Improved Voidwalker"] = "보이드워커 연마",
		["Improved Weapon Totems"] = "무기 토템 연마",
		["Improved Whirlwind"] = "소용돌이 연마",
		["Improved Wing Clip"] = "날개 절단 연마",
		["Incinerate"] = "소각",
		["Incineration"] = "소각",
		["Inferno"] = "불지옥",
		["Initiative"] = "선제 공격",
		["Inner Fire"] = "내면의 열정",
		["Inner Focus"] = "내면의 집중력",
		["Innervate"] = "정신 자극",
		["Insect Swarm"] = "곤충 떼",
		["Insidious Whisper"] = "음흉한 속삭임",
		["Insignifigance"] = "무의미함",
		["Inspiration"] = "신의 계시",
		["Instant Poison"] = "순간 효과 독",
		["Instant Poison II"] = "순간 효과 독 II",
		["Instant Poison III"] = "순간 효과 독 III",
		["Instant Poison IV"] = "순간 효과 독 IV",
		["Instant Poison V"] = "순간 효과 독 V",
		["Instant Poison VI"] = "순간 효과 독 VI",
		["Instant Poison VII"] = "순간 효과 독 VII",
		["Intensity"] = "격렬",
		["Intercept"] = "봉쇄",
		["Intercept Stun"] = "봉쇄 기절",
		["Intervene"] = "가로막기",
		["Intimidating Shout"] = "위협의 외침",
		["Intimidation"] = "위협",
		["Invisibility"] = "투명화",
		["Iron Will"] = "강건한 의지",
		["Jewelcrafting"] = "보석세공",
		["Jom Gabbar"] = "좀 가바르",
		["Judgement"] = "심판",
		["Judgement of Blood"] = "피의 심판",
		["Judgement of Command"] = "지휘의 심판",
		["Judgement of Justice"] = "응징의 심판",
		["Judgement of Light"] = "빛의 심판",
		["Judgement of Reckoning"] = "징벌의 심판",
		["Judgement of Righteousness"] = "정의의 심판",
		["Judgement of Wisdom"] = "지혜의 심판",
		["Judgement of the Crusader"] = "성전사의 심판",
		["Kick"] = "발차기",
		["Kick - Silenced"] = "발차기 침묵",
		["Kidney Shot"] = "급소 가격",
		["Kill Command"] = "살상 명령",
		["Killer Instinct"] = "살수의 본능",
		["Kiss of the Spider"] = "거미의 입맞춤",
		["Kodo Riding"] = "코도 타기",
		["Lacerate"] = "가르기",
		["Lash of Pain"] = "고통의 채찍",
		["Last Stand"] = "최후의 저항",
		["Lay on Hands"] = "신의 축복",
		["Leader of the Pack"] = "무리의 우두머리",
		["Leather"] = "가죽",
		["Leatherworking"] = "가죽세공",
		["Lesser Heal"] = "하급 치유",
		["Lesser Healing Wave"] = "하급 치유의 물결",
		["Lesser Invisibility"] = "하급 투명화",
		["Lethal Shots"] = "정밀한 사격",
		["Lethality"] = "치명상",
		["Levitate"] = "공중 부양",
		["Libram"] = "성서",
		["Life Tap"] = "생명력 전환",
		["Lifebloom"] = "피어나는 생명",
		["Light's Grace"] = "빛의 은총",
		["Lightning Bolt"] = "번개 화살",
		["Lightning Breath"] = "번개 숨결",
		["Lightning Mastery"] = "번개 전문화",
		["Lightning Reflexes"] = "번개같은 반사 신경",
		["Lightning Shield"] = "번개 보호막",
		["Lightning Speed"] = "번개같은 속도",
		["Lightwell"] = "빛샘",
		["Lightwell Renew"] = "빛샘의 소생",
		["Lockpicking"] = "자물쇠 따기",
		["Long Daze"] = "오랜 멍해짐",
		["Lust for Battle"] = "전투의 욕망",
		["Mace Specialization"] = "둔기류 전문화",
		["Mace Stun Effect"] = "철퇴 기절 효과",
		["Mage Armor"] = "마법사 갑옷",
		["Magic Absorption"] = "마법 흡수",
		["Magic Attunement"] = "마법의 조화",
		["Magma Totem"] = "용암 토템",
		["Mail"] = "사슬",
		["Maim"] = "무력화",
		["Major Dreamless Sleep"] = "최상급 숙면",
		["Malediction"] = "재앙의 저주",
		["Malice"] = "원한",
		["Mana Burn"] = "마나 연소",
		["Mana Feed"] = "마나 섭취",
		["Mana Shield"] = "마나 보호막",
		["Mana Spring"] = "마나샘",
		["Mana Spring Totem"] = "마나샘 토템",
		["Mana Tap"] = "마나 추출",
		["Mana Tide"] = "마나 해일",
		["Mana Tide Totem"] = "마나 해일 토템",
		["Mangle"] = "짓이기기",
		["Mangle (Bear)"] = "짓이기기 (곰)",
		["Mangle (Cat)"] = "짓이기기 (표범)",
		["Mark of the Wild"] = "야생의 징표",
		["Martyrdom"] = "헌신",
		["Mass Dispel"] = "대규모 무효화",
		["Master Conjuror"] = "창조의 대가",
		["Master Demonologist"] = "악령술의 대가",
		["Master Summoner"] = "소환의 대가",
		["Master Tactician"] = "전술의 대가",
		["Master of Deception"] = "속임수의 대가",
		["Master of Elements"] = "원소 마법의 대가",
		["Master of Subtlety"] = "잠행의 대가",
		["Maul"] = "후려치기",
		["Mechanostrider Piloting"] = "기계타조 조종",
		["Meditation"] = "명상",
		["Melee Specialization"] = "근접 무기 전문화",
		["Melt Armor"] = "방어구 녹이기",
		["Mend Pet"] = "동물 치료",
		["Mental Agility"] = "마음의 기민함",
		["Mental Strength"] = "정신력",
		["Mind Blast"] = "정신 분열",
		["Mind Control"] = "정신 지배",
		["Mind Flay"] = "정신의 채찍",
		["Mind Mastery"] = "정신 단련",
		["Mind Soothe"] = "평정",
		["Mind Vision"] = "마음의 눈",
		["Mind-numbing Poison"] = "정신 마비 독",
		["Mind-numbing Poison II"] = "정신 마비 독 II",
		["Mind-numbing Poison III"] = "정신 마비 독 III",
		["Mining"] = "채광",
		["Misdirection"] = "눈속임",
		["Misery"] = "불행",
		["Mocking Blow"] = "도발의 일격",
		["Molten Armor"] = "타오르는 갑옷",
		["Molten Fury"] = "타오르는 격노",
		["Mongoose Bite"] = "살쾡이의 이빨",
		["Monster Slaying"] = "몬스터 사냥술",
		["Moonfire"] = "달빛 섬광",
		["Moonfury"] = "달의 분노",
		["Moonglow"] = "달빛",
		["Moonkin Aura"] = "달빛야수 오라",
		["Moonkin Form"] = "달빛야수 변신",
		["Mortal Shots"] = "죽음의 사격",
		["Mortal Strike"] = "죽음의 일격",
		["Multi-Shot"] = "일제 사격",
		["Murder"] = "학살",
		["Mutilate"] = "절단",
		["Natural Armor"] = "무쇠 가죽",
		["Natural Perfection"] = "자연의 완전무결함",
		["Natural Shapeshifter"] = "변신의 대가",
		["Naturalist"] = "자연의 탐구자",
		["Nature Resistance"] = "자연 마법 저항",
		["Nature Resistance Totem"] = "자연 저항 토템",
		["Nature Weakness"] = "자연 약점",
		["Nature's Focus"] = "자연의 정신 집중",
		["Nature's Grace"] = "자연의 은혜",
		["Nature's Grasp"] = "자연의 손아귀",
		["Nature's Guidance"] = "자연의 가르침",
		["Nature's Reach"] = "자연의 테두리",
		["Nature's Swiftness"] = "자연의 신속함",
		["Negative Charge"] = "음전하",
		["Nether Protection"] = "황천의 보호",
		["Netherstorm Flag"] = "황천의 폭풍 깃발",
		["Nightfall"] = "일몰",
		["Nurturing Instinct"] = "회복의 본능",
		["Omen of Clarity"] = "청명의 전조",
		["One-Handed Axes"] = "한손 도끼",
		["One-Handed Maces"] = "한손 철퇴",
		["One-Handed Swords"] = "한손 검",
		["One-Handed Weapon Specialization"] = "한손 무기류 전문화",
		["Opening"] = "열기",
		["Opening - No Text"] = "열기",
		["Opportunity"] = "기회 포착",
		["Overpower"] = "제압",
		["Pain Suppression"] = "고통 억제",
		["Panic"] = "공황",
		["Paranoia"] = "망상",
		["Parasitic Shadowfiend"] = "어둠의 흡혈마귀",
		["Parry"] = "무기 막기",
		["Pathfinding"] = "길 찾기",
		["Perceived Weakness"] = "간파된 약점",
		["Perception"] = "직관력",
		["Permafrost"] = "영구 결빙",
		["Pet Aggression"] = "야수의 공격성",
		["Pet Hardiness"] = "야수의 강인함",
		["Pet Recovery"] = "야수의 회복력",
		["Pet Resistance"] = "야수의 저항력",
		["Phase Shift"] = "위상 변화",
		["Pick Lock"] = "자물쇠 따기",
		["Pick Pocket"] = "훔치기",
		["Piercing Howl"] = "날카로운 고함",
		["Piercing Ice"] = "사무치는 냉기",
		["Plate Mail"] = "판금 갑옷",
		["Playing with Fire"] = "불장난",
		["Poison Cleansing Totem"] = "독 정화 토템",
		["Poison Spit"] = "독액", -- 독화살
		["Poisons"] = "독 조제",
		["Polearms"] = "장창류",
		["Poleaxe Specialization"] = "도끼류 및 장창류 전문화",
		["Polymorph"] = "변이",
		["Polymorph: Pig"] = "변이: 돼지",
		["Polymorph: Turtle"] = "변이: 거북이",
		["Portal: Darnassus"] = "차원의 문: 다르나서스",
		["Portal: Exodar"] = "차원의 문: 엑소다르",
		["Portal: Ironforge"] = "차원의 문: 아이언포지",
		["Portal: Orgrimmar"] = "차원의 문: 오그리마",
		["Portal: Shattrath"] = "차원의 문: 샤트라스",
		["Portal: Silvermoon"] = "차원의 문: 실버문",
		["Portal: Stormwind"] = "차원의 문: 스톰윈드",
		["Portal: Thunder Bluff"] = "차원의 문: 썬더 블러프",
		["Portal: Undercity"] = "차원의 문: 언더시티",
		["Positive Charge"] = "양전하",
		["Pounce"] = "암습",
		["Pounce Bleed"] = "암습 피해",
		["Power Infusion"] = "마력 주입",
		["Power Word: Fortitude"] = "신의 권능: 인내",
		["Power Word: Shield"] = "신의 권능: 보호막",
		["Prayer of Fortitude"] = "인내의 기원",
		["Prayer of Healing"] = "치유의 기원",
		["Prayer of Mending"] = "회복의 기원",
		["Prayer of Shadow Protection"] = "암흑 보호의 기원",
		["Prayer of Spirit"] = "정신력의 기원",
		["Precision"] = "정밀함",
		["Predatory Instincts"] = "포식자의 본능",
		["Predatory Strikes"] = "야생의 포식자",
		["Premeditation"] = "사전계획",
		["Preparation"] = "마음가짐",
		["Presence of Mind"] = "냉정",
		["Primal Fury"] = "야수의 분노",
		["Prismatic Cloak"] = "굴절의 망토",
		["Prospecting"] = "보석 추출",
		["Prowl"] = "숨기",
		["Psychic Scream"] = "영혼의 절규",
		["Pummel"] = "자루 공격",
		["Purge"] = "정화",
		["Purification"] = "심신의 정화",
		["Purify"] = "순화",
		["Purifying Power"] = "정화의 힘",
		["Pursuit of Justice"] = "심판의 추격",
		["Pyroblast"] = "불덩이 작렬",
		["Pyroclasm"] = "화염 파열",
		["Pyromaniac"] = "광기의 화염술사",
		["Quick Recovery"] = "신속한 회복력",
		["Quick Shots"] = "신속 사격",
		["Quickness"] = "민첩",
		["Rage of the Unraveller"] = "해결사의 분노",
		["Rain of Fire"] = "불의 비",
		["Rake"] = "갈퀴 발톱",
		["Ram Riding"] = "산양 타기",
		["Rampage"] = "광란",
		["Ranged Weapon Specialization"] = "원거리 무기 전문화",
		["Rapid Fire"] = "속사",
		["Rapid Killing"] = "신속한 사냥",
		["Raptor Riding"] = "랩터 타기",
		["Raptor Strike"] = "랩터의 일격",
		["Ravage"] = "찢어발기기",
		["Readiness"] = "만반의 준비",
		["Rebirth"] = "환생",
		["Reckless Charge"] = "무모한 돌진",
		["Recklessness"] = "무모한 희생",
		["Reckoning"] = "징벌",
		["Redemption"] = "구원",
		["Redoubt"] = "보루",
		["Reflection"] = "반사",
		["Regeneration"] = "재생력",
		["Regrowth"] = "재생",
		["Reincarnation"] = "윤회",
		["Reinforced Shield"] = "강화된 방패",
		["Rejuvenation"] = "회복",
		["Relentless Strikes"] = "가혹한 일격",
		["Remorseless"] = "냉혹함",
		["Remorseless Attacks"] = "냉혹함",
		["Remote Toy"] = "원격조종 장난감",
		["Remove Curse"] = "저주 해제",
		["Remove Insignia"] = "계급장 제거",
		["Remove Lesser Curse"] = "하급 저주 해제",
		["Rend"] = "분쇄",
		["Renew"] = "소생",
		["Repentance"] = "참회",
		["Restless Strength"] = "불안정한 힘",
		["Restorative Totems"] = "회복의 토템",
		["Resurrection"] = "부활",
		["Retaliation"] = "보복",
		["Retribution Aura"] = "응보의 오라",
		["Revenge"] = "복수",
		["Revenge Stun"] = "복수 기절",
		["Reverberation"] = "산울림",
		["Revive Pet"] = "야수 되살리기",
		["Righteous Defense"] = "정의의 방어",
		["Righteous Fury"] = "정의의 격노",
		["Rip"] = "도려내기",
		["Riposte"] = "반격",
		["Ritual of Doom"] = "파멸의 의식",
		["Ritual of Doom Effect"] = "파멸의 의식",
		["Ritual of Refreshment"] = "원기 회복의 의식",
		["Ritual of Souls"] = "영혼의 의식",
		["Ritual of Summoning"] = "소환 의식",
		["Rockbiter Weapon"] = "대지의 무기",
		["Rough Sharpening Stone"] = "조잡한 숫돌",
		["Ruin"] = "붕괴",
		["Rupture"] = "파열",
		["Ruthlessness"] = "무정함",
		["Sacrifice"] = "희생",
		["Safe Fall"] = "낙법",
		["Sanctified Crusader"] = "신성한 성전사",
		["Sanctified Judgement"] = "신성한 심판",
		["Sanctified Light"] = "축복받은 빛",
		["Sanctity Aura"] = "고결의 오라",
		["Sap"] = "기절시키기",
		["Savage Fury"] = "맹렬한 격노",
		["Savage Strikes"] = "야생의 일격",
		["Scare Beast"] = "야수 겁주기",
		["Scatter Shot"] = "산탄 사격",
		["Scorch"] = "불태우기",
		["Scorpid Poison"] = "전갈독",
		["Scorpid Sting"] = "전갈 쐐기",
		["Screech"] = "날카로운 울음소리",
		["Seal Fate"] = "운명의 낙인",
		["Seal of Blood"] = "피의 문장",
		["Seal of Command"] = "지휘의 문장",
		["Seal of Justice"] = "응징의 문장",
		["Seal of Light"] = "빛의 문장",
		["Seal of Righteousness"] = "정의의 문장",
		["Seal of Vengeance"] = "복수의 문장",
		["Seal of Wisdom"] = "지혜의 문장",
		["Seal of the Crusader"] = "성전사의 문장",
		["Searing Light"] = "타오르는 빛",
		["Searing Pain"] = "불타는 고통",
		["Searing Totem"] = "불타는 토템",
		["Second Wind"] = "재기의 바람",
		["Seduction"] = "유혹",
		["Seed of Corruption"] = "부패의 씨앗",
		["Seethe"] = "노여움",
		["Sense Demons"] = "악마 감지",
		["Sense Undead"] = "언데드 감지",
		["Sentry Totem"] = "감시의 토템",
		["Serpent Sting"] = "독사 쐐기",
		["Serrated Blades"] = "톱니 칼날",
		["Setup"] = "사전 준비",
		["Shackle Undead"] = "언데드 속박",
		["Shadow Affinity"] = "암흑 마법 친화",
		["Shadow Bolt"] = "어둠의 화살",
		["Shadow Embrace"] = "어둠의 선물",
		["Shadow Focus"] = "암흑 마법 집중",
		["Shadow Mastery"] = "암흑 마법 전문화",
		["Shadow Power"] = "어둠의 힘",
		["Shadow Protection"] = "어둠의 보호",
		["Shadow Reach"] = "어둠의 테두리",
		["Shadow Resistance"] = "암흑 마법 저항",
		["Shadow Resistance Aura"] = "암흑 저항의 오라",
		["Shadow Trance"] = "어둠의 무아지경",
		["Shadow Vulnerability"] = "암흑 저항력 약화",
		["Shadow Ward"] = "암흑계 수호",
		["Shadow Weakness"] = "암흑 약점",
		["Shadow Weaving"] = "어둠의 매듭",
		["Shadow Word: Death"] = "어둠의 권능: 죽음",
		["Shadow Word: Pain"] = "어둠의 권능: 고통",
		["Shadow and Flame"] = "어둠과 불길",
		["Shadow of Death"] = "죽음의 어둠",
		["Shadowburn"] = "어둠의 연소",
		["Shadowfiend"] = "어둠의 마귀",
		["Shadowform"] = "어둠의 형상",
		["Shadowfury"] = "어둠의 격노",
		["Shadowguard"] = "어둠의 수호",
		["Shadowmeld"] = "그림자 숨기",
		["Shadowmeld Passive"] = "그림자 숨기",
		["Shadowstep"] = "그림자 밟기",
		["Shamanistic Rage"] = "주술의 분노",
		["Sharpened Claws"] = "날카로운 발톱",
		["Shatter"] = "산산조각",
		["Shear"] = "베어내기",
		["Shell Shield"] = "껍질 방패",
		["Shield"] = "방패",
		["Shield Bash"] = "방패 가격",
		["Shield Bash - Silenced"] = "방패 가격 - 침묵",
		["Shield Block"] = "방패 막기",
		["Shield Slam"] = "방패 밀쳐내기",
		["Shield Specialization"] = "방패 전문화",
		["Shield Wall"] = "방패의 벽",
		["Shiv"] = "독칼",
		["Shoot"] = "마법봉 발사",
		["Shoot Bow"] = "활 발사",
		["Shoot Gun"] = "총 발사",
		["Shred"] = "칼날 발톱",
		["Shredding Attacks"] = "죽음의 발톱",
		["Silence"] = "침묵",
		["Silencing Shot"] = "침묵의 사격",
		["Silent Resolve"] = "무언의 결심",
		["Silverwing Flag"] = "은빛날개 깃발",
		["Sinister Strike"] = "사악한 일격",
		["Siphon Life"] = "생명력 착취",
		["Skinning"] = "무두질",
		["Slam"] = "격돌",
		["Slayer's Crest"] = "학살자의 문장",
		["Sleep"] = "수면",
		["Slice and Dice"] = "난도질",
		["Slow"] = "감속",
		["Slow Fall"] = "저속 낙하",
		["Smelting"] = "제련술",
		["Smite"] = "성스러운 일격",
		["Snake Trap"] = "뱀 덫",
		["Solid Sharpening Stone"] = "견고한 숫돌",
		["Sonic Burst"] = "음파 폭발",
		["Soothe Animal"] = "동물 달래기",
		["Soothing Kiss"] = "유혹의 입맞춤",
		["Soul Fire"] = "영혼의 불꽃",
		["Soul Leech"] = "영혼 갈취",
		["Soul Link"] = "영혼의 고리",
		["Soul Siphon"] = "영혼 착취",
		["Soulshatter"] = "영혼 붕괴",
		["Soulstone Resurrection"] = "영혼석 부활",
		["Spell Haste"] = "주문 가속",
		["Spell Lock"] = "주문 잠금",
		["Spell Power"] = "주문 강화",
		["Spell Reflection"] = "주문 반사",
		["Spell Vulnerability"] = "주문 저항 약화",
		["Spell Warding"] = "주문 수호",
		["Spellsteal"] = "마법 훔치기",
		["Spirit Bond"] = "정신의 결속",
		["Spirit Tap"] = "정신력 누출",
		["Spirit of Redemption"] = "구원의 영혼",
		["Spiritual Attunement"] = "영혼의 조화",
		["Spiritual Focus"] = "영적인 집중력",
		["Spiritual Guidance"] = "영혼의 길잡이",
		["Spiritual Healing"] = "영혼의 치유",
		["Spiteful Fury"] = "악의의 격노",
		["Sprint"] = "전력 질주",
		["Stance Mastery"] = "태세 숙련",
		["Starfire"] = "별빛 섬광",
		["Starfire Stun"] = "별빛 섬광 기절",
		["Starlight Wrath"] = "별빛 천벌",
		["Starshards"] = "별조각",
		["Static Charge"] = "전기 충전",
		["Staves"] = "지팡이",
		["Steady Shot"] = "고정 사격",
		["Stealth"] = "은신",
		["Stoneclaw Stun"] = "돌발톱 기절",
		["Stoneclaw Totem"] = "돌발톱 토템",
		["Stoneform"] = "석화",
		["Stoneskin"] = "돌가죽",
		["Stoneskin Totem"] = "돌가죽 토템",
		["Stormstrike"] = "폭풍의 일격",
		["Strength of Earth"] = "대지력",
		["Strength of Earth Totem"] = "대지력 토템",
		["Strength of the Halaani"] = "할라아니의 힘",
		["Stuck"] = "고립 상태 벗어나기",
		["Stun"] = "기절",
		["Subtlety"] = "영혼의 길잡이",
		["Suffering"] = "고통",
		["Summon Charger"] = "군마 소환",
		["Summon Dreadsteed"] = "공포마 소환",
		["Summon Felguard"] = "지옥수호병 소환",
		["Summon Felhunter"] = "지옥사냥개 소환",
		["Summon Felsteed"] = "지옥마 소환",
		["Summon Imp"] = "임프 소환",
		["Summon Succubus"] = "서큐버스 소환",
		["Summon Voidwalker"] = "보이드워커 소환",
		["Summon Warhorse"] = "군마 소환",
		["Summon Water Elemental"] = "물의 정령 소환",
		["Sunder Armor"] = "방어구 가르기",
		["Suppression"] = "억제",
		["Surefooted"] = "침착함",
		["Surge of Light"] = "빛의 쇄도",
		["Surprise Attacks"] = "급습",
		["Survivalist"] = "생존의 대가",
		["Sweeping Strikes"] = "휩쓸기 일격",
		["Swift Flight Form"] = "빠른 폭풍까마귀 변신",
		["Swiftmend"] = "신속한 치유",
		["Swipe"] = "휘둘러치기",
		["Sword Specialization"] = "도검류 전문화",
		["Symbol of Hope"] = "희망의 상징",
		["Tactical Mastery"] = "전술 숙련",
		["Tailoring"] = "재봉술",
		["Tainted Blood"] = "얼룩진 피",
		["Tainted Mind"] = "부패한 정신",
		["Tame Beast"] = "야수 길들이기",
		["Taunt"] = "도발",
		["Teleport: Darnassus"] = "순간이동: 다르나서스",
		["Teleport: Exodar"] = "순간이동: 엑소다르",
		["Teleport: Ironforge"] = "순간이동: 아이언포지",
		["Teleport: Moonglade"] = "순간이동: 달의 숲",
		["Teleport: Orgrimmar"] = "순간이동: 오그리마",
		["Teleport: Shattrath"] = "순간이동: 샤트라스",
		["Teleport: Silvermoon"] = "순간이동: 실버문",
		["Teleport: Stormwind"] = "순간이동: 스톰윈드",
		["Teleport: Thunder Bluff"] = "순간이동: 썬더 블러프",
		["Teleport: Undercity"] = "순간이동: 언더시티",
		["Temporal Rift"] = "시간의 균열",
		["The Beast Within"] = "내면의 야수",
		["The Human Spirit"] = "인간의 정신력",
		["Thick Hide"] = "두꺼운 가죽",
		["Thorns"] = "가시",
		["Thrill of the Hunt"] = "사냥의 전율",
		["Throw"] = "투척",
		["Throwing Specialization"] = "투척술 전문화",
		["Thrown"] = "투척",
		["Thunder Clap"] = "천둥벼락",
		["Thunderfury"] = "우레폭풍",
		["Thundering Strikes"] = "우레의 일격",
		["Thunderstomp"] = "천둥 발구르기",
		["Tidal Focus"] = "해일의 집중",
		["Tidal Mastery"] = "해일의 깨달음",
		["Tiger Riding"] = "호랑이 타기",
		["Tiger's Fury"] = "맹공격",
		["Time's Favor"] = "시간의 선물",
		["Torment"] = "고문",
		["Totem"] = "토템",
		["Totem of Wrath"] = "격노의 토템",
		["Totemic Call"] = "토템의 부름",
		["Totemic Focus"] = "토템 집중",
		["Touch of Shadow"] = "어둠의 손길",
		["Touch of Weakness"] = "무력의 손길",
		["Toughness"] = "강인함",
		["Traces of Silithyst"] = "실리시스트의 자취",
		["Track Beasts"] = "야수 추적",
		["Track Demons"] = "악마 추적",
		["Track Dragonkin"] = "용족 추적",
		["Track Elementals"] = "정령 추적",
		["Track Giants"] = "거인 추적",
		["Track Hidden"] = "은신 추적",
		["Track Humanoids"] = "인간형 추적",
		["Track Undead"] = "언데드 추적",
		["Tranquil Air"] = "평온의 토템",
		["Tranquil Air Totem"] = "평온의 토템",
		["Tranquil Spirit"] = "평온한 정신",
		["Tranquility"] = "평온",
		["Tranquilizing Shot"] = "평정의 사격",
		["Trap Mastery"] = "덫 숙련",
		["Travel Form"] = "치타 변신",
		["Tree of Life"] = "생명의 나무",
		["Tremor Totem"] = "진동의 토템",
		["Tribal Leatherworking"] = "전통 가죽세공",
		["Trueshot Aura"] = "정조준 오라",
		["Turn Undead"] = "언데드 퇴치",
		["Twin Spire Blessing"] = "쌍둥이 첨탑의 축복",
		["Two-Handed Axes"] = "양손 도끼",
		["Two-Handed Axes and Maces"] = "양손 도끼류 및 둔기류",
		["Two-Handed Maces"] = "양손 철퇴",
		["Two-Handed Swords"] = "양손 검",
		["Two-Handed Weapon Specialization"] = "양손 무기류 전문화",
		["Unarmed"] = "맨손",
		["Unbreakable Will"] = "굳은 의지",
		["Unbridled Wrath"] = "분노 해방",
		["Undead Horsemanship"] = "언데드 승마술",
		["Underwater Breathing"] = "수중 호흡",
		["Unending Breath"] = "영원의 숨결",
		["Unholy Power"] = "부정의 힘",
		["Unleashed Fury"] = "격노 폭발",
		["Unleashed Rage"] = "해방된 분노",
		["Unstable Affliction"] = "불안정한 고통",
		["Unstable Power"] = "불안정한 마력",
		["Unyielding Faith"] = "굳은 신념",
		["Upset Tummy"] = "뒤틀린 뱃속",
		["Vampiric Embrace"] = "흡혈의 선물",
		["Vampiric Touch"] = "흡혈의 손길",
		["Vanish"] = "소멸",
		["Vanished"] = "소멸",
		["Vengeance"] = "복수",
		["Venomous Totem"] = "맹독의 토템",
		["Victory Rush"] = "승리의 돌진",
		["Vigor"] = "강한 체력",
		["Vile Beam"] = "타락의 광선",
		["Vile Poisons"] = "치명적인 독",
		["Vindication"] = "비호",
		["Viper Sting"] = "살무사 쐐기",
		["Volley"] = "연발 사격",
		["Wand Specialization"] = "마법봉류 전문화",
		["Wands"] = "마법봉",
		["War Stomp"] = "전투 발구르기",
		["Warp"] = "공간이동",
		["Warsong Flag"] = "전쟁노래 깃발",
		["Water Breathing"] = "수중 호흡",
		["Water Shield"] = "물의 보호막",
		["Water Tomb"] = "수중 무덤",
		["Water Walking"] = "수면 걷기",
		["Waterbolt"] = "물화살",
		["Watery Grave"] = "수중 무덤",
		["Weakened Soul"] = "약화된 영혼",
		["Weapon Mastery"] = "무기 전문화",
		["Weaponsmith"] = "무기제작",
		["Well Fed"] = "포만감",	--check
		["Whirlwind"] = "소용돌이",
		["Will of the Forsaken"] = "포세이큰의 의지",
		["Windfury"] = "질풍",
		["Windfury Attack"] = "질풍의 공격",
		["Windfury Totem"] = "질풍의 토템",
		["Windfury Weapon"] = "질풍의 무기",
		["Windwall"] = "바람막이",
		["Windwall Totem"] = "바람막이 토템",
		["Wing Clip"] = "날개 절단",
		["Winter's Chill"] = "혹한의 추위",
		["Wisp Spirit"] = "위습의 영혼",
		["Wolf Riding"] = "늑대 타기",
		["Wound Poison"] = "상처 감염 독",
		["Wound Poison II"] = "상처 감염 독 II",
		["Wound Poison III"] = "상처 감염 독 III",
		["Wound Poison IV"] = "상처 감염 독 IV",
		["Wound Poison V"] = "상처 감염 독 V",
		["Wrath"] = "천벌",
		["Wrath of Air Totem"] = "천벌의 토템",
		["Wrath of Cenarius"] = "세나리우스의 천벌",
		["Wrath of the Astromancer"] = "점성술사의 격노",
		["Wyvern Sting"] = "비룡 쐐기",
	}
end)

BabbleSpell:RegisterTranslations("esES", function()
	return {
		["Abolish Disease"] = "Suprimir enfermedad",
		["Abolish Poison"] = "Suprimir veneno",
		["Abolish Poison Effect"] = "Suprimir efecto de veneno",
		["Activate MG Turret"] = "Activar torreta MJ",
		["Adrenaline Rush"] = "Subidón de adrenalina",
		["Aftermath"] = "Secuelas",
		["Aggression"] = "Agresión",
		["Agonizing Flames"] = "Llamas agonizantes",
		["Aimed Shot"] = "Disparo de puntería",
		["Alchemy"] = "Alquimia",
		["Ambush"] = "Emboscada",
		["Amplify Curse"] = "Amplificar maldición",
		["Amplify Magic"] = "Amplificar magia",
		["Ancestral Fortitude"] = "Entereza ancestral",
		["Ancestral Healing"] = "Sanación ancestral",
		["Ancestral Knowledge"] = "Conocimiento ancestral",
		["Ancestral Spirit"] = "Espíritu ancestral",
		["Ancient Hysteria"] = "Histeria ancestral",
		["Anesthetic Poison"] = "Veneno anestésico",
		["Anger Management"] = "Control de inquina",
		["Anguish"] = "Angustia",
		["Anticipation"] = "Anticipación",
		["Aquatic Form"] = "Forma acuática",
		["Arcane Blast"] = "Deflagración Arcana",
		["Arcane Brilliance"] = "Luminosidad Arcana",
		["Arcane Concentration"] = "Concentración Arcana",
		["Arcane Energy"] = "Energía Arcana",
		["Arcane Explosion"] = "Deflagración arcana",
		["Arcane Focus"] = "Enfoque Arcano",
		["Arcane Fortitude"] = "Entereza Arcana",
		["Arcane Impact"] = "Impacto Arcano",
		["Arcane Instability"] = "Inestabilidad Arcana",
		["Arcane Intellect"] = "Intelecto arcano",
		["Arcane Meditation"] = "Meditación Arcana",
		["Arcane Mind"] = "Mente Arcana",
		["Arcane Missiles"] = "Misiles Arcanos",
		["Arcane Potency"] = "Potencia Arcana",
		["Arcane Power"] = "Poder Arcano",
		["Arcane Resistance"] = "Resistencia a lo Arcano",
		["Arcane Shot"] = "Disparo Arcano",
		["Arcane Shroud"] = "Sudario Arcano",
		["Arcane Subtlety"] = "Sutileza Arcana",
		["Arcane Torrent"] = "Torrente Arcano",
		["Arcane Weakness"] = "Debilidad Arcana",
		["Arctic Reach"] = "Alcance ártico",
		["Arctic Winds"] = "Vientos árticos",
		["Armor of Faith"] = "Armadura de fe",
		["Armorsmith"] = "Forjador de armaduras",
		["Aspect of the Beast"] = "Aspecto de la bestia",
		["Aspect of the Cheetah"] = "Aspecto del guepardo",
		["Aspect of the Hawk"] = "Aspecto del Halcón",
		["Aspect of the Monkey"] = "Aspecto del mono",
		["Aspect of the Pack"] = "Aspecto de la manada",
		["Aspect of the Viper"] = "Aspecto de la víbora",
		["Aspect of the Wild"] = "Aspecto salvaje",
		["Astral Recall"] = "Regreso astral",
		["Attack"] = "Ataque",
		["Attacking"] = "Atacando",
		["Auto Shot"] = "Disparo automático",
		["Avenger's Shield"] = "Escudo de vengador",
		["Avenging Wrath"] = "Cólera vengativa",
		["Avoidance"] = "Eludir",
		["Axe Specialization"] = "Especialización en hachas",
		["Backlash"] = "Contragolpe",
		["Backstab"] = "Puñalada",
		["Badge of the Swarmguard"] = "Distintivo del Guardaenjambres",
		["Balance of Power"] = "Equilibrio de poder",
		["Bane"] = "Aterrar",
		["Banish"] = "Desterrar",
		["Banshee Curse"] = "Maldición de alma en pena",
		["Barkskin"] = "Piel de corteza",
		["Barrage"] = "Tromba",
		["Bash"] = "Azote",
		["Basic Campfire"] = "Hoguera básica",
		["Battle Rush"] = "Carrera de batalla",
		["Battle Shout"] = "Grito de batalla",
		["Battle Stance"] = "Actitud de batalla",
		["Battle Stance Passive"] = "Actitud de batalla Pasivo",
		["Bear Form"] = "Forma de oso",
		["Beast Lore"] = "Tradición de las bestias",
		["Beast Slaying"] = "Matanza de bestias",
		["Beast Training"] = "Adiestramiento de bestias",
		["Benediction"] = "Oración",
		["Berserker Rage"] = "Ira rabiosa",
		["Berserker Stance"] = "Actitud rabiosa",
		["Berserker Stance Passive"] = "Actitud rabiosa pasiva",
		["Berserking"] = "Rabiar",
		["Bestial Discipline"] = "Disciplina de las bestias",
		["Bestial Swiftness"] = "Presteza de las bestias",
		["Bestial Wrath"] = "Cólera de las bestias",
		["Binding Heal"] = "Sanación conjunta",
		["Bite"] = "Mordedura",
		["Black Arrow"] = "Flecha negra",
		["Blackout"] = "Desmayo",
		["Blacksmithing"] = "Herrería",
		["Blade Flurry"] = "Aluvión de acero",
		["Blade Turning"] = "Giro de hojas",
		["Blade Twisting"] = "Malabares cortantes",
		["Blast Wave"] = "Ola explosiva",
		["Blazing Speed"] = "Velocidad llameante",
		["Blessed Recovery"] = "Recuperación bendita",
		["Blessed Resilience"] = "Temple bendito",
		["Blessing of Auchindoun"] = "Bendición de Auchindoun",
		["Blessing of Freedom"] = "Bendición de libertad",
		["Blessing of Kings"] = "Bendición de los Reyes",
		["Blessing of Light"] = "Bendición de Luz",
		["Blessing of Might"] = "Bendición de poderío",
		["Blessing of Protection"] = "Bendición de protección",
		["Blessing of Sacrifice"] = "Bendición de sacrificio",
		["Blessing of Salvation"] = "Bendición de salvación",
		["Blessing of Sanctuary"] = "Bendición de salvaguardia",
		["Blessing of Wisdom"] = "Bendición de sabiduría",
		["Blind"] = "Ceguera",
		["Blinding Powder"] = "Partículas cegadoras",
		["Blink"] = "Traslación",
		["Blizzard"] = "Ventisca",
		["Block"] = "Bloqueo",
		["Blood Craze"] = "Manía sangrienta",
		["Blood Frenzy"] = "Frenesí sangriento",
		["Blood Fury"] = "Furia sangrienta",
		["Blood Pact"] = "Pacto de sangre",
		["Bloodlust"] = "Ansia de sangre",
		["Bloodrage"] = "Ira sangrienta",
		["Bloodthirst"] = "Sed de sangre",
		["Boar Charge"] = "Carga de jabalí",
		["Booming Voice"] = "Voz retumbante",
		["Bow Specialization"] = "Especialización en arcos",
		["Bows"] = "Arcos",
		["Bright Campfire"] = "Hoguera brillante",
		["Brittle Armor"] = "Armadura quebradiza",
		["Brutal Impact"] = "Impacto brutal",
		["Burning Adrenaline"] = "Adrenalina ardiente",
		["Burning Soul"] = "Alma ardiente",
		["Burning Wish"] = "Deseo ardiente",
		["Call Pet"] = "llamar a mascota",
		["Call of Flame"] = "Llamada de las llamas",
		["Call of Thunder"] = "Llamada del trueno",
		["Call of the Nexus"] = "Llamada del Nexo",
		["Camouflage"] = "Camuflaje",
		["Cannibalize"] = "Canibalizar",
		["Cat Form"] = "Forma felina",
		["Cataclysm"] = "Cataclismo",
		["Celestial Focus"] = "Fuego estelar mejorado",
		["Chain Heal"] = "Sanación en cadena",
		["Chain Lightning"] = "Cadena de relámpagos",
		["Challenging Roar"] = "Rugido desafiante",
		["Challenging Shout"] = "Grito desafiante",
		["Charge"] = "Cargar",
		["Charge Rage Bonus Effect"] = "Efecto de bonus de cargar ira",
		["Charge Stun"] = "Carga aturdidora",
		["Chastise"] = "Castigar",
		["Cheap Shot"] = "Golpe bajo",
		["Chilled"] = "Gélido",
		["Circle of Healing"] = "Círculo de sanación",
		["Claw"] = "Zarpa",
		["Cleanse"] = "Limpiar",
		["Clearcasting"] = "Lanzamiento libre",
		["Cleave"] = "Rajar",
		["Clever Traps"] = "Trampas inteligentes",
		["Cloak of Shadows"] = "Capa de las Sombras",
		["Closing"] = "Cerrando",
		["Cloth"] = "Paño",
		["Coarse Sharpening Stone"] = "Piedra de afilar burda",
		["Cobra Reflexes"] = "Reflejos de cobra",
		["Cold Blood"] = "Sangre fría",
		["Cold Snap"] = "Mordedura de frío",
		["Combat Endurance"] = "Robustez en combate",
		["Combustion"] = "Combustión",
		["Command"] = "Ordenar",
		["Commanding Presence"] = "Grito de batalla mejorado",
		["Commanding Shout"] = "Grito de orden",
		["Concentration Aura"] = "Aura de concentración",
		["Concussion"] = "Conmoción",
		["Concussion Blow"] = "Arremetida de conmoción",
		["Concussive Barrage"] = "Tromba de conmoción",
		["Concussive Shot"] = "Disparo de conmoción",
		["Cone of Cold"] = "Cono de frío",
		["Conflagrate"] = "Conflagrar",
		["Conflagration"] = "Conflagración",
		["Conjure Food"] = "Crear comida",
		["Conjure Mana Agate"] = "Crear ágata de maná",
		["Conjure Mana Citrine"] = "Crear citrino de maná",
		["Conjure Mana Emerald"] = "Crear esmeralda de maná",
		["Conjure Mana Jade"] = "Crear jade de maná",
		["Conjure Mana Ruby"] = "Crear rubí de maná",
		["Conjure Water"] = "Crear agua",
		["Consecration"] = "Consagración",
		["Consume Magic"] = "Consumir magia",
		["Consume Shadows"] = "Consumir Sombras",
		["Contagion"] = "Contagio",
		["Convection"] = "Convección",
		["Conviction"] = "Convicción",
		["Cooking"] = "Cocina",
		["Corruption"] = "Corrupción",
		["Counterattack"] = "Contraataque",
		["Counterspell"] = "Contrahechizo",
		["Counterspell - Silenced"] = "Contrahechizo: silenciado",
		["Cower"] = "Agazapar",
		["Create Firestone"] = "Crear piedra de fuego",
		["Create Firestone (Greater)"] = "Crear piedra de fuego (superior)",
		["Create Firestone (Lesser)"] = "Crear piedra de fuego (inferior)",
		["Create Firestone (Major)"] = "Crear piedra de fuego (sublime)",
		["Create Healthstone"] = "Crear piedra de salud",
		["Create Healthstone (Greater)"] = "Crear piedra de salud (superior)",
		["Create Healthstone (Lesser)"] = "Crear piedra de salud (inferior)",
		["Create Healthstone (Major)"] = "Crear piedra de salud (sublime)",
		["Create Healthstone (Minor)"] = "Crear piedra de salud (menor)",
		["Create Soulstone"] = "Crear piedra de alma",
		["Create Soulstone (Greater)"] = "Crear piedra de alma (superior)",
		["Create Soulstone (Lesser)"] = "Crear piedra de alma (inferior)",
		["Create Soulstone (Major)"] = "Crear piedra de alma (sublime)",
		["Create Soulstone (Minor)"] = "Crear piedra de alma (menor)",
		["Create Spellstone"] = "Crear piedra de hechizo",
		["Create Spellstone (Greater)"] = "Crear piedra de hechizo (superior)",
		["Create Spellstone (Major)"] = "Crear piedra de hechizo (sublime)",
		["Create Spellstone (Master)"] = "Crear piedra de hechizo (maestra)",
		["Creeping Paralysis"] = "Parálisis progresiva",
		["Cripple"] = "Entorpecer",
		["Crippling Poison"] = "Veneno entorpecedor",
		["Crippling Poison II"] = "Veneno entorpecedor II",
		["Critical Mass"] = "Masa crítica",
		["Crossbows"] = "Ballestas",
		["Cruelty"] = "Crueldad",
		["Crusade"] = "Cruzada",
		["Crusader Aura"] = "Aura del Cruzado",
		["Crusader Strike"] = "Golpe de cruzado",
		["Cultivation"] = "Cultivo",
		["Cure Disease"] = "Curar enfermedad",
		["Cure Poison"] = "Curar envenenamiento",
		["Curse of Agony"] = "Maldición de agonía",
		["Curse of Doom"] = "Maldición del Apocalipsis",
		["Curse of Doom Effect"] = "Efecto de Maldición del Apocalipsis",
		["Curse of Exhaustion"] = "Maldición de agotamiento",
		["Curse of Idiocy"] = "Maldición de imbecilidad",
		["Curse of Recklessness"] = "Maldición de temeridad",
		["Curse of Shadow"] = "Maldición de las Sombras",
		["Curse of Tongues"] = "Maldición de las lenguas",
		["Curse of Weakness"] = "Maldición de debilidad",
		["Curse of the Elements"] = "Maldición de los Elementos",
		["Cyclone"] = "Ciclón",
		["Dagger Specialization"] = "Especialización en dagas",
		["Daggers"] = "Dagas",
		["Dampen Magic"] = "Atenuar magia",
		["Dark Barrage"] = "Tromba oscura",
		["Dark Pact"] = "Pacto oscuro",
		["Darkness"] = "Oscuridad",
		["Dash"] = "Carrerilla",
		["Dawnstone Crab"] = "Cangrejo de piedra del alba",
		["Dazed"] = "Atontado",
		["Deadly Interrupt Effect"] = "Efecto de interrupción mortal",
		["Deadly Poison"] = "Veneno mortal",
		["Deadly Poison II"] = "Veneno mortal II",
		["Deadly Poison III"] = "Veneno mortal III",
		["Deadly Poison IV"] = "Veneno mortal IV",
		["Deadly Poison V"] = "Veneno mortal V",
		["Deadly Poison VI"] = "Veneno mortal VI",
		["Deadly Poison VII"] = "Veneno mortal VI",
		["Deadly Throw"] = "Lanzamiento mortal",
		["Death Coil"] = "Espiral de la muerte",
		["Death Wish"] = "Deseo de la Muerte",
		["Deep Wound"] = "Herida profunda",
		["Deep Wounds"] = "Heridas profundas",
		["Defense"] = "Defensa",
		["Defensive Stance"] = "Actitud defensiva",
		["Defensive Stance Passive"] = "Actitud defensiva pasiva",
		["Defiance"] = "Desafío",
		["Deflection"] = "Desvío",
		["Delusions of Jin'do"] = "Ilusiones de Jin'do",
		["Demon Armor"] = "Armadura demoníaca",
		["Demon Skin"] = "Piel de demonio",
		["Demonic Aegis"] = "Égida demoníaca",
		["Demonic Embrace"] = "Abrazo demoníaco",
		["Demonic Frenzy"] = "Frenesí demoníaco",
		["Demonic Knowledge"] = "Conocimiento demoníaco",
		["Demonic Resilience"] = "Temple demoníaco",
		["Demonic Sacrifice"] = "Sacrificio demoníaco",
		["Demonic Tactics"] = "Tácticas demoníacas",
		["Demoralizing Roar"] = "Rugido desmoralizador",
		["Demoralizing Shout"] = "Grito desmoralizador",
		["Dense Sharpening Stone"] = "Piedra de afilar densa",
		["Desperate Prayer"] = "Rezo desesperado",
		["Destructive Reach"] = "Alcance destructivo",
		["Detect"] = "Detectar",
		["Detect Greater Invisibility"] = "Detectar invisibilidad superior",
		["Detect Invisibility"] = "Detectar Invisibilidad",
		["Detect Lesser Invisibility"] = "Detectar invisibilidad inferior",
		["Detect Magic"] = "Detectar magia",
		["Detect Traps"] = "Detectar trampas",
		["Deterrence"] = "Disuasión",
		["Devastate"] = "Devastar",
		["Devastation"] = "Devastación",
		["Devotion Aura"] = "Aura de devoción",
		["Devour Magic"] = "Devorar magia",
		["Devour Magic Effect"] = "Efecto de Devorar magia",
		["Devouring Plague"] = "Peste devoradora",
		["Diplomacy"] = "Diplomacia",
		["Dire Bear Form"] = "Forma de oso temible",
		["Dirty Deeds"] = "Actos reprobables",
		["Dirty Tricks"] = "Zapar mejorado",
		["Disarm"] = "Desarmar",
		["Disarm Trap"] = "Desactivar trampa",
		["Disease Cleansing Totem"] = "Tótem de limpieza de enfermedades",
		["Disenchant"] = "Desencantar",
		["Disengage"] = "Separación",
		["Dismiss Pet"] = "Retirar mascota",
		["Dispel Magic"] = "Disipar magia",
		["Distract"] = "Distraer",
		["Distracting Shot"] = "Disparo de distracción",
		["Dive"] = "En picado",
		["Divine Favor"] = "Favor divino",
		["Divine Fury"] = "Furia divina",
		["Divine Illumination"] = "Iluminación divina",
		["Divine Intellect"] = "Intelecto divino",
		["Divine Intervention"] = "Intervención divina",
		["Divine Protection"] = "Protección divina",
		["Divine Shield"] = "Escudo divino",
		["Divine Spirit"] = "Espíritu divino",
		["Divine Strength"] = "Fortaleza divina",
		["Divine Wrath"] = "Cólera divina",
		["Dodge"] = "Esquivar",
		["Doomfire"] = "Fuego apocalíptico",
		["Dragon's Breath"] = "Aliento de dragón",
		["Dragonscale Leatherworking"] = "Peletería de escamas de dragón",
		["Drain Life"] = "Drenar vida",
		["Drain Mana"] = "Drenar maná",
		["Drain Soul"] = "Drenar alma",
		["Dreamless Sleep"] = "Letargo sin sueños",
		["Drink"] = "Beber",
		["Dual Wield"] = "Doble empuñadura",
		["Dual Wield Specialization"] = "Especialización en doble empuñadura",
		["Duel"] = "Duelo",
		["Dust Cloud"] = "Nube de polvo",
		["Eagle Eye"] = "Ojo de águila",
		["Earth Elemental Totem"] = "Tótem Elemental de Tierra",
		["Earth Shield"] = "Escudo de tierra",
		["Earth Shock"] = "Choque de tierra",
		["Earthbind"] = "Nexo terrestre",
		["Earthbind Totem"] = "Tótem Nexo terrestre",
		["Earthstrike"] = "Golpe de tierra",
		["Efficiency"] = "Eficacia",
		["Elemental Devastation"] = "Devastación elemental",
		["Elemental Focus"] = "Enfoque elemental",
		["Elemental Fury"] = "Furia elemental",
		["Elemental Leatherworking"] = "Peletería elemental",
		["Elemental Mastery"] = "Maestría elemental",
		["Elemental Precision"] = "Precisión elemental",
		["Elemental Sharpening Stone"] = "Piedra de afilar elemental",
		["Elemental Weapons"] = "Armas elementales",
		["Elune's Grace"] = "Gracia de Elune",
		["Elusiveness"] = "Elusión",
		["Emberstorm"] = "Tormenta de brasales",
		["Empowered Arcane Missiles"] = "Misiles Arcanos empoderados",
		["Empowered Corruption"] = "Corrupción potenciada",
		["Empowered Fireball"] = "Bola de Fuego empoderada",
		["Empowered Frostbolt"] = "Descarga de Escarcha empoderada",
		["Empowered Healing"] = "Sanación empoderada",
		["Empowered Rejuvenation"] = "Rejuvenecimiento empoderado",
		["Empowered Touch"] = "Toque empoderado",
		["Enamored Water Spirit"] = "Espíritu de agua enamorado",
		["Enchanting"] = "Encantamiento",
		["Endurance"] = "Robustez",
		["Endurance Training"] = "Adiestramiento en robustez",
		["Engineering"] = "Ingeniería",
		["Engineering Specialization"] = "Especialización de ingeniería",
		["Enrage"] = "Enfurecer",
		["Enriched Manna Biscuit"] = "Galleta enriquecida con maná",
		["Enslave Demon"] = "Esclavizar demonio",
		["Entangling Roots"] = "Raíces enredadoras",
		["Entrapment"] = "Incitación",
		["Envenom"] = "Emponzoñar",
		["Escape Artist"] = "Artista del escape",
		["Evasion"] = "Evasión",
		["Eviscerate"] = "Eviscerar",
		["Evocation"] = "Evocación",
		["Execute"] = "Ejecutar",
		["Exorcism"] = "Exorcismo",
		["Expansive Mind"] = "Mente expansiva",
		["Explosive Trap"] = "Trampa explosiva",
		["Explosive Trap Effect"] = "Efecto de Trampa explosiva",
		["Expose Armor"] = "Exponer armadura",
		["Expose Weakness"] = "Exponer debilidad",
		["Extract Gas"] = "Extraer gas",
		["Eye for an Eye"] = "Ojo por ojo",
		["Eye of Kilrogg"] = "Ojo de Kilrogg",
		["Eye of the Storm"] = "Ojo de la tormenta",
		["Eyes of the Beast"] = "Ojos de la bestia",
		["Fade"] = "Desvanecerse",
		["Faerie Fire"] = "Fuego feérico",
		["Faerie Fire (Feral)"] = "Fuego feérico (feral)",
		["Fanaticism"] = "Fanatismo",
		["Far Sight"] = "Vista lejana",
		["Fatal Attraction"] = "Atracción fatal",
		["Fear"] = "Miedo",
		["Fear Ward"] = "Resguardo de miedo",
		["Feed Pet"] = "Alimentar mascota",
		["Feed Pet Effect"] = "Efecto de Alimentar mascota",
		["Feedback"] = "Rebote",
		["Feign Death"] = "Fingir muerte",
		["Feint"] = "Amago",
		["Fel Armor"] = "Armadura vil",
		["Fel Concentration"] = "Concentración vil",
		["Fel Domination"] = "Dominio vil",
		["Fel Energy"] = "Energía vil",
		["Fel Intellect"] = "Intelecto vil",
		["Fel Rage"] = "Ira vil",
		["Fel Stamina"] = "Aguante vil",
		["Felfire"] = "Fuego vil",
		["Feline Grace"] = "Gracia felina",
		["Feral Aggression"] = "Agresión feral",
		["Feral Charge"] = "Carga feral",
		["Feral Instinct"] = "Instinto feral",
		["Feral Swiftness"] = "Presteza feral",
		["Ferocious Bite"] = "Mordedura feroz",
		["Ferocious Inspiration"] = "Inspiración feroz",
		["Ferocity"] = "Ferocidad",
		["Fetish"] = "Fetiche",
		["Find Herbs"] = "Buscar hierbas",
		["Find Minerals"] = "Buscar minerales",
		["Find Treasure"] = "Encontrar tesoro",
		["Find Weakness"] = "Descubrir debilidad",
		["Fire Blast"] = "Explosión de Fuego",
		["Fire Breath"] = "Aliento de Fuego",
		["Fire Elemental Totem"] = "Tótem Elemental de Fuego",
		["Fire Nova Totem"] = "Tótem Nova de Fuego",
		["Fire Power"] = "Poder de Fuego",
		["Fire Resistance"] = "Resistencia al Fuego",
		["Fire Resistance Aura"] = "Aura de resistencia al Fuego",
		["Fire Resistance Totem"] = "Tótem de resistencia al Fuego",
		["Fire Shield"] = "Escudo de Fuego",
		["Fire Vulnerability"] = "Vulnerabilidad de Fuego",
		["Fire Ward"] = "Resguardo contra el Fuego",
		["Fire Weakness"] = "Debilidad de Fuego",
		["Fireball"] = "Bola de Fuego",
		["Firebolt"] = "Descarga de Fuego",
		["First Aid"] = "Primeros auxilios",
		["Fishing"] = "Pesca",
		["Fishing Poles"] = "Cañas de pescar",
		["Fist Weapon Specialization"] = "Especialización en armas de puño",
		["Fist Weapons"] = "Armas de puño",
		["Flame Shock"] = "Choque de llamas",
		["Flame Throwing"] = "Lanzar llamas",
		["Flamestrike"] = "Fogonazo",
		["Flamethrower"] = "Lanzallamas",
		["Flametongue Attack"] = "Ataque de Lengua de Fuego",
		["Flametongue Totem"] = "Tótem Lengua de fuego",
		["Flametongue Weapon"] = "Arma Lengua de fuego",
		["Flare"] = "Bengala",
		["Flash Heal"] = "Sanación relámpago",
		["Flash of Light"] = "Destello de Luz",
		["Flight Form"] = "Forma voladora",
		["Flurry"] = "Aluvión",
		["Focused Casting"] = "Lanzamiento enfocado",
		["Focused Mind"] = "Mente centrada",
		["Focused Power"] = "Poder enfocado",
		["Focused Rage"] = "Ira enfocada",
		["Focused Starlight"] = "Luz de las estrellas enfocada",
		["Food"] = "Comida",
		["Forbearance"] = "Paciencia",
		["Force of Nature"] = "Fuerza de la Naturaleza",
		["Force of Will"] = "Fuerza de voluntad",
		["Freezing Trap"] = "Trampa congelante",
		["Freezing Trap Effect"] = "Efecto de Trampa congelante",
		["Frenzied Regeneration"] = "Regeneración frenética",
		["Frenzy"] = "Frenesí",
		["Frenzy Effect"] = "Efecto de frenesí",
		["Frost Armor"] = "Armadura de Escarcha",
		["Frost Blast"] = "Explosión de Escarcha",
		["Frost Channeling"] = "Canalización de Escarcha",
		["Frost Nova"] = "Nova de Escarcha",
		["Frost Resistance"] = "Resistencia a la Escarcha",
		["Frost Resistance Aura"] = "Aura de resistencia a la Escarcha",
		["Frost Resistance Totem"] = "Tótem de resistencia a la Escarcha",
		["Frost Shock"] = "Choque de Escarcha",
		["Frost Trap"] = "Trampa de Escarcha",
		["Frost Trap Aura"] = "Aura de Trampa de Escarcha",
		["Frost Ward"] = "Resguardo contra la Escarcha",
		["Frost Warding"] = "Amparo de Escarcha",
		["Frost Weakness"] = "Debilidad a la Escarcha",
		["Frostbite"] = "Mordedura de Escarcha",
		["Frostbolt"] = "Descarga de Escarcha",
		["Frostbrand Attack"] = "Ataque Estigma de Escarcha",
		["Frostbrand Weapon"] = "Arma Estigma de Escarcha",
		["Frozen Core"] = "Núcleo helado",
		["Furious Howl"] = "Aullido furioso",
		["Furor"] = "Furor",
		["Fury of the Crashing Waves"] = "Furia de las olas batientes",
		["Garrote"] = "Garrote",
		["Garrote - Silence"] = "Garrote - Silencio",
		["Ghost Wolf"] = "Lobo fantasmal",
		["Ghostly Strike"] = "Golpe fantasmal",
		["Gift of Life"] = "Ofrenda de vida",
		["Gift of Nature"] = "Ofrenda de la Naturaleza",
		["Gift of the Naaru"] = "Ofrenda de los Naaru",
		["Gift of the Wild"] = "Don de lo Salvaje",
		["Gouge"] = "Gubia",
		["Grace of Air"] = "Gracia del aire",
		["Grace of Air Totem"] = "Tótem Gracia del aire",
		["Great Stamina"] = "Gran aguante",
		["Greater Blessing of Kings"] = "Bendición de reyes superior",
		["Greater Blessing of Light"] = "Bendición de Luz superior",
		["Greater Blessing of Might"] = "Bendición de poderío superior",
		["Greater Blessing of Salvation"] = "Bendición de salvación superior",
		["Greater Blessing of Sanctuary"] = "Bendición de salvaguardia superior",
		["Greater Blessing of Wisdom"] = "Bendición de sabiduría superior",
		["Greater Dreamless Sleep"] = "Letargo sin sueños superior",
		["Greater Heal"] = "Sanación superior",
		["Grievous Throw"] = "Lanzamiento doloroso",
		["Grim Reach"] = "Alcance macabro",
		["Grounding Totem"] = "Tótem derribador",
		["Grounding Totem Effect"] = "Efecto de tótem derribador",
		["Grovel"] = "Humillación",
		["Growl"] = "Bramido",
		["Guardian's Favor"] = "Favor del Guardián",
		["Gun Specialization"] = "Especialización en armas de fuego",
		["Guns"] = "Armas de fuego",
		["Hammer of Justice"] = "Martillo de justicia",
		["Hammer of Wrath"] = "Martillo de cólera",
		["Hamstring"] = "Seccionar",
		["Harass"] = "Hostigar",
		["Hardiness"] = "Firmeza",
		["Haste"] = "Celeridad",
		["Hawk Eye"] = "Ojo de halcón",
		["Heal"] = "Sanar",
		["Healing Focus"] = "Enfoque de sanación",
		["Healing Light"] = "Luz de sanación",
		["Healing Stream"] = "Corriente de sanación",
		["Healing Stream Totem"] = "Tótem Corriente de sanación",
		["Healing Touch"] = "Toque de sanación",
		["Healing Wave"] = "Ola de sanación",
		["Healing Way"] = "Forma de sanación",
		["Health Funnel"] = "Cauce de salud",
		["Heart of the Wild"] = "Corazón de fiera",
		["Heavy Sharpening Stone"] = "Piedra de afilar pesada",
		["Hellfire"] = "Llamas infernales",
		["Hellfire Effect"] = "Efecto de Llamas infernales",
		["Hellfire Superiority"] = "Superioridad de Llamas infernales",
		["Hemorrhage"] = "Hemorragia",
		["Herb Gathering"] = "Recolectar hierbas",
		["Herbalism"] = "Herboristería",
		["Heroic Strike"] = "Golpe heroico",
		["Heroism"] = "Heroísmo",
		["Hex of Weakness"] = "Maleficio de debilidad",
		["Hibernate"] = "Hivernar",
		["Holy Fire"] = "Fuego Sagrado",
		["Holy Light"] = "Luz Sagrada",
		["Holy Nova"] = "Nova Sagrada",
		["Holy Power"] = "Poder Sagrado",
		["Holy Reach"] = "Alcance Sagrado",
		["Holy Shield"] = "Escudo Sagrado",
		["Holy Shock"] = "Choque Sagrado",
		["Holy Specialization"] = "Especialización Sagrada",
		["Holy Vengeance"] = "Venganza Sagrada",
		["Holy Wrath"] = "Cólera sagrada",
		["Honorless Target"] = "Objetivo sin honor",
		["Horse Riding"] = "Equitación",
		["Howl of Terror"] = "Aullido de terror",
		["Humanoid Slaying"] = "Matanza de humanoides",
		["Hunter's Mark"] = "Marca del cazador",
		["Hurricane"] = "Huracán",
		["Hypothermia"] = "Hipotermia",
		["Ice Armor"] = "Armadura de hielo",
		["Ice Barrier"] = "Barrera de hielo",
		["Ice Block"] = "Bloque de hielo",
		["Ice Floes"] = "Témpanos de hielo",
		["Ice Lance"] = "Lanza de hielo",
		["Ice Shards"] = "Fragmentos de hielo",
		["Ignite"] = "Ignición",
		["Ignite Mana"] = "Ignición de maná",
		["Illumination"] = "Iluminación",
		["Immolate"] = "Inmolar",
		["Immolation Trap"] = "Trampa de inmolación",
		["Immolation Trap Effect"] = "Efecto de Trampa de inmolación",
		["Impact"] = "Impacto",
		["Impale"] = "Empalar",
		["Impaling Spine"] = "Gran lanza",
		["Improved Ambush"] = "Emboscada mejorada",
		["Improved Arcane Missiles"] = "Misiles Arcanos mejorados",
		["Improved Arcane Shot"] = "Disparo Arcano mejorado",
		["Improved Aspect of the Hawk"] = "Aspecto del Halcón mejorado",
		["Improved Aspect of the Monkey"] = "Aspecto del mono mejorado",
		["Improved Backstab"] = "Puñalada mejorada",
		["Improved Barrage"] = "Tromba mejorada",
		["Improved Berserker Rage"] = "Ira rabiosa mejorada",
		["Improved Blessing of Might"] = "Bendición de poderío mejorada",
		["Improved Blessing of Wisdom"] = "Bendición de sabiduría mejorada",
		["Improved Blink"] = "Traslación mejorada",
		["Improved Blizzard"] = "Ventisca mejorada",
		["Improved Bloodrage"] = "Ira sangrienta mejorada",
		["Improved Chain Heal"] = "Sanación en cadena mejorada",
		["Improved Chain Lightning"] = "Cadena de relámpagos mejorada",
		["Improved Challenging Shout"] = "Grito desafiante mejorado",
		["Improved Charge"] = "Cargar mejorado",
		["Improved Cleave"] = "Rajar mejorado",
		["Improved Concentration Aura"] = "Aura de concentración mejorada",
		["Improved Concussive Shot"] = "Disparo de conmoción mejorado",
		["Improved Cone of Cold"] = "Cono de frío mejorado",
		["Improved Corruption"] = "Corrupción empoderada",
		["Improved Counterspell"] = "Contrahechizo mejorado",
		["Improved Curse of Agony"] = "Maldición de agonía mejorada",
		["Improved Curse of Weakness"] = "Maldición de debilidad mejorada",
		["Improved Demoralizing Shout"] = "Grito desmoralizador mejorado",
		["Improved Devotion Aura"] = "Aura de devoción mejorada",
		["Improved Disarm"] = "Desarmar mejorado",
		["Improved Drain Life"] = "Drenar vida mejorado",
		["Improved Drain Soul"] = "Drenar alma mejorado",
		["Improved Enrage"] = "Enfurecer mejorado",
		["Improved Enslave Demon"] = "Esclavizar demonio mejorado",
		["Improved Eviscerate"] = "Eviscerar mejorado",
		["Improved Execute"] = "Ejecutar mejorado",
		["Improved Expose Armor"] = "Exponer armadura mejorado",
		["Improved Eyes of the Beast"] = "Ojos de la bestia mejorado",
		["Improved Fade"] = "Desvanecer mejorado",
		["Improved Feign Death"] = "Fingir muerte mejorado",
		["Improved Fire Blast"] = "Explosión de Fuego mejorada",
		["Improved Fire Totems"] = "Tótems de Fuego mejorados",
		["Improved Fire Ward"] = "Resguardo contra el Fuego mejorado",
		["Improved Fireball"] = "Bola de Fuego mejorada",
		["Improved Firebolt"] = "Descarga de Fuego mejorada",
		["Improved Flamestrike"] = "Fogonazo mejorado",
		["Improved Flash of Light"] = "Destello de Luz mejorado",
		["Improved Frost Nova"] = "Nova de Escarcha mejorada",
		["Improved Frostbolt"] = "Descarga de Escarcha mejorada",
		["Improved Ghost Wolf"] = "Lobo fantasmal mejorado",
		["Improved Gouge"] = "Gubia mejorada",
		["Improved Hammer of Justice"] = "Martillo de justicia mejorado",
		["Improved Hamstring"] = "Seccionar mejorado",
		["Improved Healing"] = "Sanación mejorada",
		["Improved Healing Touch"] = "Toque de sanación mejorado",
		["Improved Healing Wave"] = "Ola de sanación mejorada",
		["Improved Health Funnel"] = "Cauce de salud mejorado",
		["Improved Healthstone"] = "Piedra de salud mejorada",
		["Improved Heroic Strike"] = "Golpe heroico mejorado",
		["Improved Holy Shield"] = "Escudo Sagrado mejorado",
		["Improved Howl of Terror"] = "Aullido de terror mejorado",
		["Improved Hunter's Mark"] = "Marca del cazador mejorada",
		["Improved Immolate"] = "Inmolar mejorado",
		["Improved Imp"] = "Diablillo mejorado",
		["Improved Inner Fire"] = "Fuego interno mejorado",
		["Improved Intercept"] = "Intercepción mejorada",
		["Improved Intimidating Shout"] = "Grito intimidador mejorado",
		["Improved Judgement"] = "Sentencia mejorada",
		["Improved Kick"] = "Patada mejorada",
		["Improved Kidney Shot"] = "Golpe en los riñones mejorado",
		["Improved Lash of Pain"] = "Latigazo doloroso mejorado",
		["Improved Lay on Hands"] = "Imposición de manos mejorada",
		["Improved Leader of the Pack"] = "Líder de la manada mejorado",
		["Improved Life Tap"] = "Transfusión de vida mejorada",
		["Improved Lightning Bolt"] = "Descarga de relámpagos mejorado",
		["Improved Lightning Shield"] = "Escudo de relámpagos mejorado",
		["Improved Magma Totem"] = "Tótem de magma mejorado",
		["Improved Mana Burn"] = "Quemadura de maná mejorado",
		["Improved Mana Shield"] = "Escudo de maná mejorado",
		["Improved Mana Spring Totem"] = "Tótem Fuente de maná mejorado",
		["Improved Mark of the Wild"] = "Marca de lo salvaje mejorada",
		["Improved Mend Pet"] = "Aliviar mascota mejorado",
		["Improved Mind Blast"] = "Explosión mental mejorada",
		["Improved Moonfire"] = "Fuego lunar mejorado",
		["Improved Mortal Strike"] = "Golpe mortal mejorado",
		["Improved Nature's Grasp"] = "Trabazón con la Naturaleza mejorada",
		["Improved Overpower"] = "Abrumar mejorado",
		["Improved Power Word: Fortitude"] = "Palabra de poder mejorada: entereza",
		["Improved Power Word: Shield"] = "Palabra de poder mejorada: escudo",
		["Improved Prayer of Healing"] = "Rezo de sanación mejorado",
		["Improved Psychic Scream"] = "Alarido psíquico mejorado",
		["Improved Regrowth"] = "Recrecimiento mejorado",
		["Improved Reincarnation"] = "Reencarnación mejorada",
		["Improved Rejuvenation"] = "Rejuvenecimiento mejorado",
		["Improved Rend"] = "Desgarrar mejorado",
		["Improved Renew"] = "Renovar mejorado",
		["Improved Retribution Aura"] = "Aura de sanción mejorada",
		["Improved Revenge"] = "Revancha mejorada",
		["Improved Revive Pet"] = "Revivir mascota mejorado",
		["Improved Righteous Fury"] = "Furia justa mejorada",
		["Improved Rupture"] = "Ruptura mejorada",
		["Improved Scorch"] = "Agostar mejorado",
		["Improved Scorpid Sting"] = "Picadura de escórpido mejorada",
		["Improved Seal of Righteousness"] = "Sello de rectitud mejorado",
		["Improved Seal of the Crusader"] = "Sello del cruzado mejorado",
		["Improved Searing Pain"] = "Dolor abrasador mejorado",
		["Improved Serpent Sting"] = "Picadura de serpiente mejorado",
		["Improved Shadow Bolt"] = "Descarga de las Sombras mejorada",
		["Improved Shadow Word: Pain"] = "Palabra de las Sombras: dolor mejorada",
		["Improved Shield Bash"] = "Azote de escudo mejorado",
		["Improved Shield Block"] = "Bloquear con escudo mejorado",
		["Improved Shield Wall"] = "Muro de escudo mejorado",
		["Improved Sinister Strike"] = "Golpe siniestro mejorado",
		["Improved Slam"] = "Embate mejorado",
		["Improved Slice and Dice"] = "Hacer picadillo mejorado",
		["Improved Sprint"] = "Sprint mejorado",
		["Improved Stings"] = "Picaduras mejoradas",
		["Improved Succubus"] = "Súcubo mejorado",
		["Improved Sunder Armor"] = "Hender armadura mejorado",
		["Improved Taunt"] = "Provocar mejorado",
		["Improved Thunder Clap"] = "Atronar mejorado",
		["Improved Tranquility"] = "Tranquilidad mejorada",
		["Improved Vampiric Embrace"] = "Abrazo vampírico mejorado",
		["Improved Vanish"] = "Esfumarse mejorado",
		["Improved Voidwalker"] = "Abisario mejorado",
		["Improved Weapon Totems"] = "Tótems de armas mejorados",
		["Improved Whirlwind"] = "Torbellino mejorado",
		["Improved Wing Clip"] = "Cortar alas mejorado",
		["Incinerate"] = "Incinerar",
		["Incineration"] = "Incineración",
		["Inferno"] = "Inferno",
		["Initiative"] = "Iniciativa",
		["Inner Fire"] = "Fuego interno",
		["Inner Focus"] = "Enfoque interno",
		["Innervate"] = "Enervar",
		["Insect Swarm"] = "Enjambre de insectos",
		["Insidious Whisper"] = "Silbido insidioso",
		["Insignifigance"] = "Insignificancia",
		["Inspiration"] = "Inspiración",
		["Instant Poison"] = "Veneno instantáneo",
		["Instant Poison II"] = "Veneno instantáneo II",
		["Instant Poison III"] = "Veneno instantáneo III",
		["Instant Poison IV"] = "Veneno instantáneo IV",
		["Instant Poison V"] = "Veneno instantáneo V",
		["Instant Poison VI"] = "Veneno instantáneo VI",
		["Instant Poison VII"] = "Veneno instantáneo VII",
		["Intensity"] = "Intensidad",
		["Intercept"] = "Interceptar",
		["Intercept Stun"] = "Aturdimiento de intercepción",
		["Intervene"] = "Intervenir",
		["Intimidating Shout"] = "Grito intimidador",
		["Intimidation"] = "Intimidación",
		["Invisibility"] = "Invisibilidad",
		["Iron Will"] = "Voluntad de hierro",
		["Jewelcrafting"] = "Joyería",
		["Jom Gabbar"] = "Jom Gabbar",
		["Judgement"] = "Sentencia",
		["Judgement of Blood"] = "Sentencia de sangre",
		["Judgement of Command"] = "Sentencia de orden",
		["Judgement of Justice"] = "Sentencia de justicia",
		["Judgement of Light"] = "Sentencia de Luz",
		["Judgement of Reckoning"] = "Sentencia de expiación",
		["Judgement of Righteousness"] = "Sentencia de rectitud",
		["Judgement of Wisdom"] = "Sentencia de sabiduría",
		["Judgement of the Crusader"] = "Sentencia del cruzado",
		["Kick"] = "Patada",
		["Kick - Silenced"] = "Patada: silenciado",
		["Kidney Shot"] = "Golpe en los riñones",
		["Kill Command"] = "Matar",
		["Killer Instinct"] = "Instinto asesino",
		["Kiss of the Spider"] = "Beso de la araña",
		["Kodo Riding"] = "Montar kodo",
		["Lacerate"] = "Lacerar",
		["Lash of Pain"] = "Latigazo doloroso",
		["Last Stand"] = "Última carga",
		["Lay on Hands"] = "Imposición de manos",
		["Leader of the Pack"] = "Líder de la manada",
		["Leather"] = "Cuero",
		["Leatherworking"] = "Peletería",
		["Lesser Heal"] = "Sanación inferior",
		["Lesser Healing Wave"] = "Ola de sanación inferior",
		["Lesser Invisibility"] = "Invisibilidad inferior",
		["Lethal Shots"] = "Disparos letales",
		["Lethality"] = "Letalidad",
		["Levitate"] = "Levitar",
		["Libram"] = "Tratado",
		["Life Tap"] = "Transfusión de vida",
		["Lifebloom"] = "Flor de vida",
		["Light's Grace"] = "Gracia de Luz",
		["Lightning Bolt"] = "Descarga de relámpagos",
		["Lightning Breath"] = "Aliento de relámpagos",
		["Lightning Mastery"] = "Maestría en relámpagos",
		["Lightning Reflexes"] = "Reflejos de relámpago",
		["Lightning Shield"] = "Escudo de relámpagos",
		["Lightning Speed"] = "Velocidad de relámpago",
		["Lightwell"] = "Pozo de luz",
		["Lightwell Renew"] = "Renovar Pozo de Luz",
		["Lockpicking"] = "Forzar cerraduras",
		["Long Daze"] = "Atontamiento largo",
		["Lust for Battle"] = "Deseo de batalla",
		["Mace Specialization"] = "Especialización con mazas",
		["Mace Stun Effect"] = "Efecto aturdidor de mazas",
		["Mage Armor"] = "Armadura de mago",
		["Magic Absorption"] = "Amortiguación mágica",
		["Magic Attunement"] = "Armonización mágica",
		["Magma Totem"] = "Tótem de magma",
		["Mail"] = "Malla",
		["Maim"] = "Amputar",
		["Major Dreamless Sleep"] = "Letargo sin sueños sublime",
		["Malediction"] = "Imprecación",
		["Malice"] = "Maldad",
		["Mana Burn"] = "Quemadura de maná",
		["Mana Feed"] = "Alimentar maná",
		["Mana Shield"] = "Escudo de maná",
		["Mana Spring"] = "Fuente de maná",
		["Mana Spring Totem"] = "Tótem Fuente de maná",
		["Mana Tap"] = "Transfusión de maná",
		["Mana Tide"] = "Marea de maná",
		["Mana Tide Totem"] = "Tótem Marea de maná",
		["Mangle"] = "Destrozar",
		["Mangle (Bear)"] = "Destrozar (oso)",
		["Mangle (Cat)"] = "Destrozar (felino)",
		["Mark of the Wild"] = "Marca de lo Salvaje",
		["Martyrdom"] = "Martirio",
		["Mass Dispel"] = "Disipación en masa",
		["Master Conjuror"] = "Maestro conjurador",
		["Master Demonologist"] = "Maestro demonólogo",
		["Master Summoner"] = "Maestro invocador",
		["Master Tactician"] = "Maestro táctico",
		["Master of Deception"] = "Maestro del engaño",
		["Master of Elements"] = "Maestro de los elementos",
		["Master of Subtlety"] = "Maestro de la sutileza",
		["Maul"] = "Magullar",
		["Mechanostrider Piloting"] = "Pilotaje de mecazancudo",
		["Meditation"] = "Meditación",
		["Melee Specialization"] = "Especialización cuerpo a cuerpo",
		["Melt Armor"] = "Fundir armadura",
		["Mend Pet"] = "Aliviar mascota",
		["Mental Agility"] = "Agilidad mental",
		["Mental Strength"] = "Fortaleza mental",
		["Mind Blast"] = "Explosión mental",
		["Mind Control"] = "Control mental",
		["Mind Flay"] = "Tortura mental",
		["Mind Mastery"] = "Maestría mental",
		["Mind Soothe"] = "Calma mental",
		["Mind Vision"] = "Visión mental",
		["Mind-numbing Poison"] = "Veneno de aturdimiento mental",
		["Mind-numbing Poison II"] = "Veneno de aturdimiento mental II",
		["Mind-numbing Poison III"] = "Veneno de aturdimiento mental III",
		["Mining"] = "Minería",
		["Misdirection"] = "Redirección",
		["Misery"] = "Infortunio",
		["Mocking Blow"] = "Falsa arremetida",
		["Molten Armor"] = "Armadura de arrabio",
		["Molten Fury"] = "Furia de arrabio",
		["Mongoose Bite"] = "Mordedura de mangosta",
		["Monster Slaying"] = "Matanza de monstruos",
		["Moonfire"] = "Fuego lunar",
		["Moonfury"] = "Furia de luna",
		["Moonglow"] = "Resplandor lunar",
		["Moonkin Aura"] = "Aura lechúcico lunar",
		["Moonkin Form"] = "Forma de lechúcico lunar",
		["Mortal Shots"] = "Disparos mortales",
		["Mortal Strike"] = "Golpe mortal",
		["Multi-Shot"] = "Multidisparo",
		["Murder"] = "Asesinar",
		["Mutilate"] = "Mutilar",
		["Natural Armor"] = "Armadura natural",
		["Natural Perfection"] = "Perfección natural",
		["Natural Shapeshifter"] = "Cambio de forma natural",
		["Naturalist"] = "Naturalista",
		["Nature Resistance"] = "Resistencia a la Naturaleza",
		["Nature Resistance Totem"] = "Tótem de resistencia a la Naturaleza",
		["Nature Weakness"] = "Debilidad natural",
		["Nature's Focus"] = "Enfoque de la Naturaleza",
		["Nature's Grace"] = "Gracia de la Naturaleza",
		["Nature's Grasp"] = "Trabazón con la Naturaleza",
		["Nature's Guidance"] = "Guía de la Naturaleza",
		["Nature's Reach"] = "Alcance de la Naturaleza",
		["Nature's Swiftness"] = "Presteza de la Naturaleza",
		["Negative Charge"] = "Carga negativa",
		["Nether Protection"] = "Protección abisal",
		["Netherstorm Flag"] = "Bandera de Tormenta Abisal",
		["Nightfall"] = "Ocaso",
		["Nurturing Instinct"] = "Instinto de nutrición",
		["Omen of Clarity"] = "Augurio de claridad",
		["One-Handed Axes"] = "Hachas",
		["One-Handed Maces"] = "Mazas",
		["One-Handed Swords"] = "Espadas",
		["One-Handed Weapon Specialization"] = "Especialización en armas de una mano",
		["Opening"] = "Apertura",
		["Opening - No Text"] = "Apertura - Sin texto",
		["Opportunity"] = "Oportunidad",
		["Overpower"] = "Abrumar",
		["Pain Suppression"] = "Supresión de dolor",
		["Paranoia"] = "Paranoia",
		["Panic"] = "Pánico",
		["Parasitic Shadowfiend"] = "Maligno de las Sombras parasitario",
		["Parry"] = "Parar",
		["Pathfinding"] = "Encontrar camino",
		["Perceived Weakness"] = "Debilidad percibida",
		["Perception"] = "Percepción",
		["Permafrost"] = "Escarcha permanente",
		["Pet Aggression"] = "Agresión de mascota",
		["Pet Hardiness"] = "Firmeza de mascota",
		["Pet Recovery"] = "Recuperación de mascota",
		["Pet Resistance"] = "Resistencia de mascota",
		["Phase Shift"] = "Cambio de fase",
		["Pick Lock"] = "Forzar cerradura",
		["Pick Pocket"] = "Robar",
		["Piercing Howl"] = "Aullido penetrante",
		["Piercing Ice"] = "Hielo penetrante",
		["Plate Mail"] = "Malla de placas",
		["Playing with Fire"] = "Jugando con Fuego",
		["Poison Cleansing Totem"] = "Tótem contraveneno",
		["Poison Spit"] = "Flema de veneno",
		["Poisons"] = "Venenos",
		["Polearms"] = "Armas de asta",
		["Poleaxe Specialization"] = "Especialización en hachas y armas de asta",
		["Polymorph"] = "Polimorfia",
		["Polymorph: Pig"] = "Polimorfia: cerdo",
		["Polymorph: Turtle"] = "Polimorfia: tortuga",
		["Portal: Darnassus"] = "Portal: Darnassus",
		["Portal: Exodar"] = "Portal: El Exodar",
		["Portal: Ironforge"] = "Portal: Forjaz",
		["Portal: Orgrimmar"] = "Portal: Orgrimmar",
		["Portal: Shattrath"] = "Portal: Shattrath",
		["Portal: Silvermoon"] = "Portal: Lunargenta",
		["Portal: Stormwind"] = "Portal: Ventormenta",
		["Portal: Thunder Bluff"] = "Portal: Cima del Trueno",
		["Portal: Undercity"] = "Portal: Entrañas",
		["Positive Charge"] = "Carga positiva",
		["Pounce"] = "Abalanzarse",
		["Pounce Bleed"] = "Abalanzarse al desgarre",
		["Power Infusion"] = "Infusión de poder",
		["Power Word: Fortitude"] = "Palabra de poder: entereza",
		["Power Word: Shield"] = "Palabra de poder: escudo",
		["Prayer of Fortitude"] = "Rezo de entereza",
		["Prayer of Healing"] = "Rezo de sanación",
		["Prayer of Mending"] = "Rezo de alivio",
		["Prayer of Shadow Protection"] = "Rezo de Protección contra las Sombras",
		["Prayer of Spirit"] = "Rezo de espíritu",
		["Precision"] = "Precisión",
		["Predatory Instincts"] = "Instintos depredadores",
		["Predatory Strikes"] = "Golpes depredadores",
		["Premeditation"] = "Premeditación",
		["Preparation"] = "Preparación",
		["Presence of Mind"] = "Presencia mental",
		["Primal Fury"] = "Furia primigenia",
		["Prismatic Cloak"] = "Capa centelleante",
		["Prospecting"] = "Prospectar",
		["Prowl"] = "Acechar",
		["Psychic Scream"] = "Alarido psíquico",
		["Pummel"] = "Zurrar",
		["Purge"] = "Purgar",
		["Purification"] = "Purificación",
		["Purify"] = "Purificar",
		["Purifying Power"] = "Poder purificador",
		["Pursuit of Justice"] = "Búsqueda de justicia",
		["Pyroblast"] = "Piroexplosión",
		["Pyroclasm"] = "Piroclasma",
		["Pyromaniac"] = "Pirómano",
		["Quick Recovery"] = "Recuperación presurosa",
		["Quick Shots"] = "Disparos presurosos",
		["Quickness"] = "Presura",
		["Rage of the Unraveller"] = "Ira del Desenredador",
		["Rain of Fire"] = "Lluvia de fuego",
		["Rake"] = "Arañazo",
		["Ram Riding"] = "Montar carnero",
		["Rampage"] = "Desenfreno",
		["Ranged Weapon Specialization"] = "Especialización en armas a distancia",
		["Rapid Fire"] = "Fuego rápido",
		["Rapid Killing"] = "Matanza rápida",
		["Raptor Riding"] = "Cabalgar raptor",
		["Raptor Strike"] = "Golpe de raptor",
		["Ravage"] = "Devastar",
		["Readiness"] = "Disposición",
		["Rebirth"] = "Renacer",
		["Reckless Charge"] = "Carga imprudente",
		["Recklessness"] = "Temeridad",
		["Reckoning"] = "Expiación",
		["Redemption"] = "Redención",
		["Redoubt"] = "Baluarte",
		["Reflection"] = "Reflejo",
		["Regeneration"] = "Regeneración",
		["Regrowth"] = "Recrecimiento",
		["Reincarnation"] = "Reencarnación",
		["Reinforced Shield"] = "Escudo reforzado",
		["Rejuvenation"] = "Rejuvenecimiento",
		["Relentless Strikes"] = "Golpes despiadados",
		["Remorseless"] = "Sin remordimientos",
		["Remorseless Attacks"] = "Ataques sin remordimientos",
		["Remote Toy"] = "Remote Toy",
		["Remove Curse"] = "Eliminar maldición",
		["Remove Insignia"] = "Quitar insignia",
		["Remove Lesser Curse"] = "Eliminar maldición inferior",
		["Rend"] = "Desgarrar",
		["Renew"] = "Renovar",
		["Repentance"] = "Arrepentimiento",
		["Restless Strength"] = "Fuerza agitada",
		["Restorative Totems"] = "Tótems restauradores",
		["Resurrection"] = "Resurrección",
		["Retaliation"] = "Represalias",
		["Retribution Aura"] = "Aura de sanción",
		["Revenge"] = "Revancha",
		["Revenge Stun"] = "Aturdimiento de revancha",
		["Reverberation"] = "Reverberación",
		["Revive Pet"] = "Revivir mascota",
		["Righteous Defense"] = "Defensa justa",
		["Righteous Fury"] = "Furia justa",
		["Rip"] = "Destripar",
		["Riposte"] = "Contestación",
		["Ritual of Doom"] = "Ritual del Apocalipsis",
		["Ritual of Doom Effect"] = "Efecto de ritual de condena",
		["Ritual of Refreshment"] = "Ritual de refrigerio",
		["Ritual of Souls"] = "Ritual de almas",
		["Ritual of Summoning"] = "Ritual de invocación",
		["Rockbiter Weapon"] = "Arma Muerdepiedras",
		["Rough Sharpening Stone"] = "Piedra de afilar férrea",
		["Ruin"] = "Ruina",
		["Rupture"] = "Ruptura",
		["Ruthlessness"] = "Crueldad",
		["Sacrifice"] = "Sacrificio",
		["Safe Fall"] = "Caída segura",
		["Sanctified Crusader"] = "Cruzado santificado", -- check
		["Sanctified Judgement"] = "Sentencia santificada",
		["Sanctified Light"] = "Luz santificada",
		["Sanctity Aura"] = "Aura de santidad",
		["Sap"] = "Porrazo",
		["Savage Fury"] = "Furia cruel",
		["Savage Strikes"] = "Golpes crueles",
		["Scare Beast"] = "Asustar bestia",
		["Scatter Shot"] = "Disparo disperso",
		["Scorch"] = "Agostar",
		["Scorpid Poison"] = "Veneno de escórpido",
		["Scorpid Sting"] = "Picadura de escórpido",
		["Screech"] = "Chirrido",
		["Seal Fate"] = "Sellar destino",
		["Seal of Blood"] = "Sello de sangre",
		["Seal of Command"] = "Sello de orden",
		["Seal of Justice"] = "Sello de justicia",
		["Seal of Light"] = "Sello de Luz",
		["Seal of Righteousness"] = "Sello de rectitud",
		["Seal of Vengeance"] = "Sello de venganza",
		["Seal of Wisdom"] = "Sello de sabiduría",
		["Seal of the Crusader"] = "Sello del cruzado",
		["Searing Light"] = "Luz abrasadora",
		["Searing Pain"] = "Dolor abrasador",
		["Searing Totem"] = "Tótem abrasador",
		["Second Wind"] = "Segundo aliento",
		["Seduction"] = "Seducción",
		["Seed of Corruption"] = "Semilla de corrupción",
		["Seethe"] = "Rugido desafiante",
		["Sense Demons"] = "Captar demonios",
		["Sense Undead"] = "Captar no-muertos",
		["Sentry Totem"] = "Tótem avizor",
		["Serpent Sting"] = "Picadura de serpiente",
		["Serrated Blades"] = "Espadas dentadas",
		["Setup"] = "Establecer",
		["Shackle Undead"] = "Encadenar no-muerto",
		["Shadow Affinity"] = "Afinidad de las Sombras",
		["Shadow Bolt"] = "Descarga de las Sombras",
		["Shadow Embrace"] = "Abrazo de las Sombras",
		["Shadow Focus"] = "Enfoque de las Sombras",
		["Shadow Mastery"] = "Maestría de las Sombras",
		["Shadow Power"] = "Poder de las Sombras",
		["Shadow Protection"] = "Protección contra las Sombras",
		["Shadow Reach"] = "Alcance de las Sombras",
		["Shadow Resistance"] = "Resistencia a las Sombras",
		["Shadow Resistance Aura"] = "Aura de resistencia a las Sombras",
		["Shadow Trance"] = "Trance de las Sombras",
		["Shadow Vulnerability"] = "Vulnerabilidad a las Sombras",
		["Shadow Ward"] = "Resguardo contra las Sombras",
		["Shadow Weakness"] = "Debilidad a las Sombras",
		["Shadow Weaving"] = "Tejido de las Sombras",
		["Shadow Word: Death"] = "Palabra de las Sombras: muerte",
		["Shadow Word: Pain"] = "Palabra de las Sombras: dolor",
		["Shadow and Flame"] = "Sombras y llamas",
		["Shadow of Death"] = "Sombra de muerte",
		["Shadowburn"] = "Quemadura de las Sombras",
		["Shadowfiend"] = "Maligno de las Sombras",
		["Shadowform"] = "Forma de las Sombras",
		["Shadowfury"] = "Furia de las Sombras",
		["Shadowguard"] = "Guardia de las Sombras",
		["Shadowmeld"] = "Fusión de las Sombras",
		["Shadowmeld Passive"] = "Fusión de las Sombras Pasivo",
		["Shadowstep"] = "Paso de las Sombras",
		["Shamanistic Rage"] = "Ira del chamán",
		["Sharpened Claws"] = "Garras afiladas",
		["Shatter"] = "Trizar",
		["Shear"] = "Cortar",
		["Shell Shield"] = "Escudo de caparazón",
		["Shield"] = "Escudo",
		["Shield Bash"] = "Azote de escudo",
		["Shield Bash - Silenced"] = "Azote de escudo: silenciado",
		["Shield Block"] = "Bloquear con escudo",
		["Shield Slam"] = "Embate con escudo",
		["Shield Specialization"] = "Especialización en escudos",
		["Shield Wall"] = "Muro de escudo",
		["Shiv"] = "Puyazo",
		["Shoot"] = "Disparar",
		["Shoot Bow"] = "Disparar arco",
		["Shoot Gun"] = "Disparar arma de fuego",
		["Shred"] = "Triturar",
		["Shredding Attacks"] = "Ataques trituradores",
		["Silence"] = "Silencio",
		["Silencing Shot"] = "Disparo silenciador",
		["Silent Resolve"] = "Resolución silenciosa",
		["Silverwing Flag"] = "Bandera Ala de Plata",
		["Sinister Strike"] = "Golpe siniestro",
		["Siphon Life"] = "Succionar vida",
		["Skinning"] = "Desuello",
		["Slam"] = "Embate",
		["Slayer's Crest"] = "Blasón de destripador",
		["Sleep"] = "Dormir",
		["Slice and Dice"] = "Hacer picadillo",
		["Slow"] = "Ralentizar",
		["Slow Fall"] = "Caída lenta",
		["Smelting"] = "Fundición",
		["Smite"] = "Mamporro",
		["Snake Trap"] = "Trampa con culebras",
		["Solid Sharpening Stone"] = "Piedra de afilar sólida",
		["Sonic Burst"] = "Ráfaga sónica",
		["Soothe Animal"] = "Calmar animal",
		["Soothing Kiss"] = "Beso calmante",
		["Soul Fire"] = "Fuego de alma",
		["Soul Leech"] = "Succión de alma",
		["Soul Link"] = "Enlace de alma",
		["Soul Siphon"] = "Succión de alma",
		["Soulshatter"] = "Despedazar alma",
		["Soulstone Resurrection"] = "Resurrección con piedra de alma",
		["Spell Haste"] = "Celeridad de hechizos",
		["Spell Lock"] = "Bloqueo de hechizo",
		["Spell Power"] = "Poder de hechizo",
		["Spell Reflection"] = "Reflejo de hechizos",
		["Spell Vulnerability"] = "Vulnerabilidad a los hechizos",
		["Spell Warding"] = "Amparo de hechizos",
		["Spellsteal"] = "Robar hechizo",
		["Spirit Bond"] = "Vínculo de espíritu",
		["Spirit Tap"] = "Transfusión de espíritu",
		["Spirit of Redemption"] = "Espíritu redentor",
		["Spiritual Attunement"] = "Armonización espiritual",
		["Spiritual Focus"] = "Enfoque espiritual",
		["Spiritual Guidance"] = "Guía espiritual",
		["Spiritual Healing"] = "Sanación espiritual",
		["Spiteful Fury"] = "Furia llena de maldad",
		["Sprint"] = "Sprint",
		["Stance Mastery"] = "Maestría en actitudes",
		["Starfire"] = "Fuego estelar",
		["Starfire Stun"] = "Aturdimiento de fuego estelar",
		["Starlight Wrath"] = "Cólera de la luz de las estrellas",
		["Starshards"] = "Fragmentos estelares",
		["Static Charge"] = "Carga estática",
		["Staves"] = "Bastones",
		["Steady Shot"] = "Tiro firme",
		["Stealth"] = "Sigilo",
		["Stoneclaw Stun"] = "Aturdimiento con Garra de piedra",
		["Stoneclaw Totem"] = "Tótem Garra de piedra",
		["Stoneform"] = "Forma de piedra",
		["Stoneskin"] = "Piel de piedra",
		["Stoneskin Totem"] = "Tótem Piel de piedra",
		["Stormstrike"] = "Golpe de tormenta",
		["Strength of Earth"] = "Fortaleza de la tierra",
		["Strength of Earth Totem"] = "Tótem Fortaleza de la tierra",
		["Strength of the Halaani"] = "Fuerza de los Halaani",
		["Stuck"] = "Aprisionar",
		["Stun"] = "Aturdir",
		["Subtlety"] = "Sutileza",
		["Suffering"] = "Sufrimiento",
		["Summon Charger"] = "Invocar a garañón",
		["Summon Dreadsteed"] = "Invocar a corcel nefasto",
		["Summon Felguard"] = "Invocar a guardia maldito",
		["Summon Felhunter"] = "Invocar a manáfago",
		["Summon Felsteed"] = "Invocar a corcel vil",
		["Summon Imp"] = "Invocar a diablillo",
		["Summon Succubus"] = "Invocar a súcubo",
		["Summon Voidwalker"] = "Invocar a abisario",
		["Summon Warhorse"] = "Invocar a caballo de guerra",
		["Summon Water Elemental"] = "Invocar a elemental de agua",
		["Sunder Armor"] = "Hender armadura",
		["Suppression"] = "Supresión",
		["Surefooted"] = "Pies de plomo",
		["Surge of Light"] = "Oleada de Luz",
		["Surprise Attacks"] = "Ataques por sorpresa",
		["Survivalist"] = "Superviviente",
		["Sweeping Strikes"] = "Golpes de barrido",
		["Swift Flight Form"] = "Forma de Vuelo presto",
		["Swiftmend"] = "Alivio presto",
		["Swipe"] = "Flagelo",
		["Sword Specialization"] = "Especialización en espada",
		["Symbol of Hope"] = "Símbolo de esperanza",
		["Tactical Mastery"] = "Maestría táctica",
		["Tailoring"] = "Sastrería",
		["Tainted Blood"] = "Sangre mácula",
		["Tainted Mind"] = "Mente mácula",
		["Tame Beast"] = "Domesticar bestia",
		["Taunt"] = "Provocar",
		["Teleport: Darnassus"] = "Teletransporte a: Darnassus",
		["Teleport: Exodar"] = "Teletransporte a: Exodar",
		["Teleport: Ironforge"] = "Teletransporte a: Forjaz",
		["Teleport: Moonglade"] = "Teletransporte a: Claro de la Luna",
		["Teleport: Orgrimmar"] = "Teletransporte a: Orgrimmar",
		["Teleport: Shattrath"] = "Teletransporte a: Shattrath",
		["Teleport: Silvermoon"] = "Teletransporte a: Lunargenta",
		["Teleport: Stormwind"] = "Teletransporte a: Ventormenta",
		["Teleport: Thunder Bluff"] = "Teletransporte a: Cima del Trueno",
		["Teleport: Undercity"] = "Teletransporte a: Entrañas",
		["Temporal Rift"] = "Falla temporal",
		["The Beast Within"] = "Bestia interna",
		["The Human Spirit"] = "El espirítu humano",
		["Thick Hide"] = "Pellejo grueso",
		["Thorns"] = "Espinas",
		["Thrill of the Hunt"] = "Emoción de la caza",
		["Throw"] = "Lanzar",
		["Throwing Specialization"] = "Especialización en lanzamiento",
		["Thrown"] = "Arrojadizas",
		["Thunder Clap"] = "Atronar",
		["Thunderfury"] = "Furiatrueno",
		["Thundering Strikes"] = "Golpes de trueno",
		["Thunderstomp"] = "Pisotón de trueno",
		["Tidal Focus"] = "Enfoque de las mareas",
		["Tidal Mastery"] = "Dominio de las mareas",
		["Tiger Riding"] = "Montar tigre",
		["Tiger's Fury"] = "Furia de tigre",
		["Time's Favor"] = "Favor del tiempo",
		["Torment"] = "Tormento",
		["Totem"] = "Tótem",
		["Totem of Wrath"] = "Tótem de cólera",
		["Totemic Call"] = "Llamada totémica",
		["Totemic Focus"] = "Enfoque totémico",
		["Touch of Shadow"] = "Toque de las Sombras",
		["Touch of Weakness"] = "Toque de debilidad",
		["Toughness"] = "Consistencia",
		["Traces of Silithyst"] = "Rastros de silitista",
		["Track Beasts"] = "Rastrear bestias",
		["Track Demons"] = "Rastrear demonios",
		["Track Dragonkin"] = "Rastrear dragonante",
		["Track Elementals"] = "Rastrear elementales",
		["Track Giants"] = "Rastrear gigantes",
		["Track Hidden"] = "Rastrear lo Oculto",
		["Track Humanoids"] = "Rastrear humanoides",
		["Track Undead"] = "Rastrear no-muertos",
		["Tranquil Air"] = "Aire sosegado",
		["Tranquil Air Totem"] = "Tótem de Aire sosegado",
		["Tranquil Spirit"] = "Espíritu sosegado",
		["Tranquility"] = "Tranquilidad",
		["Tranquilizing Shot"] = "Disparo tranquilizante",
		["Trap Mastery"] = "Maestría en trampas",
		["Travel Form"] = "Forma de viaje",
		["Tree of Life"] = "Árbol de vida",
		["Tremor Totem"] = "Tótem de tremor",
		["Tribal Leatherworking"] = "Peletería tribal",
		["Trueshot Aura"] = "Aura de disparo certero",
		["Turn Undead"] = "Ahuyentar a no-muerto",
		["Twin Spire Blessing"] = "Bendición de Agujas Gemelas",
		["Two-Handed Axes"] = "Hachas de dos manos",
		["Two-Handed Axes and Maces"] = "Hachas y mazas de dos manos",
		["Two-Handed Maces"] = "Mazas de dos manos",
		["Two-Handed Swords"] = "Espadas de dos manos",
		["Two-Handed Weapon Specialization"] = "Especialización en armas de dos manos",
		["Unarmed"] = "Sin armas",
		["Unbreakable Will"] = "Voluntad inquebrantable",
		["Unbridled Wrath"] = "Cólera desbocada",
		["Undead Horsemanship"] = "Adiestrador de caballos no-muerto",
		["Underwater Breathing"] = "Respiración subacuática",
		["Unending Breath"] = "Aliento inagotable",
		["Unholy Power"] = "Poder profano",
		["Unleashed Fury"] = "Furia desatada",
		["Unleashed Rage"] = "Ira desatada",
		["Unstable Affliction"] = "Aflicción inestable",
		["Unstable Power"] = "Poder inestable",
		["Unyielding Faith"] = "Fe implacable",
		["Upset Tummy"] = "Dolor de barriga",
		["Vampiric Embrace"] = "Abrazo vampírico",
		["Vampiric Touch"] = "Toque vampírico",
		["Vanish"] = "Esfumarse",
		["Vanished"] = "Esfumado",
		["Vengeance"] = "Venganza",
		["Venomous Totem"] = "Tótem venenoso",
		["Victory Rush"] = "Ataque de la victoria",
		["Vigor"] = "Vigor",
		["Vile Beam"] = "Haz inmundo",
		["Vile Poisons"] = "Venenos inmundos",
		["Vindication"] = "Vindicación",
		["Viper Sting"] = "Picadura de víbora",
		["Volley"] = "Salva",
		["Wand Specialization"] = "Especialización en varitas",
		["Wands"] = "Varitas",
		["War Stomp"] = "Pisotón de guerra",
		["Warp"] = " Distorsión",
		["Warsong Flag"] = "Bandera de Grito de Guerra",
		["Water Breathing"] = "Respiración acuática",
		["Water Shield"] = "Escudo de agua",
		["Water Tomb"] = "Tumba de agua",
		["Water Walking"] = "Caminar sobre el agua",
		["Waterbolt"] = "Descarga de agua",
		["Watery Grave"] = "Sepultura de agua",
		["Weakened Soul"] = "Alma debilitada",
		["Weapon Mastery"] = "Maestría en armas",
		["Weaponsmith"] = "Forjador de armas",
		["Well Fed"] = "Bien alimentado",
		["Whirlwind"] = "Torbellino",
		["Will of the Forsaken"] = "Voluntad de los Renegados",
		["Windfury"] = "Viento Furioso",
		["Windfury Attack"] = "Ataque Viento Furioso",
		["Windfury Totem"] = "Tótem Viento Furioso",
		["Windfury Weapon"] = "Arma Viento Furioso",
		["Windwall"] = "Muro de viento",
		["Windwall Totem"] = "Tótem Muro de viento",
		["Wing Clip"] = "Cortar alas",
		["Winter's Chill"] = "Escalofrío invernal",
		["Wisp Spirit"] = "Espíritu de fuego fatuo",
		["Wolf Riding"] = "Montar lobo",
		["Wound Poison"] = "Veneno hiriente",
		["Wound Poison II"] = "Veneno hiriente II",
		["Wound Poison III"] = "Veneno hiriente III",
		["Wound Poison IV"] = "Veneno hiriente IV",
		["Wound Poison V"] = "Veneno hiriente V",
		["Wrath"] = "Cólera",
		["Wrath of Air Totem"] = "Tótem cólera de aire",
		["Wrath of Cenarius"] = "Cólera de Cenarius",
		["Wrath of the Astromancer"] = "Cólera de la astromántica",
		["Wyvern Sting"] = "Picadura de dracoleón",
	}
end)

local spellIcons = {
	["Abolish Disease"] = "Spell_Nature_NullifyDisease",
	["Abolish Poison"] = "Spell_Nature_NullifyPoison_02",
	["Abolish Poison Effect"] = "Spell_Nature_NullifyPoison_02",
	["Activate MG Turret"] = "INV_Weapon_Rifle_10",
	["Adrenaline Rush"] = "Spell_Shadow_ShadowWordDominate",
	["Aftermath"] = "Spell_Fire_Fire",
	["Aggression"] = "Ability_Racial_Avatar",
	["Agonizing Flames"] = "Spell_Fire_BlueImmolation",
	["Aimed Shot"] = "INV_Spear_07",
	["Alchemy"] = "Trade_Alchemy",
	["Ambush"] = "Ability_Rogue_Ambush",
	["Amplify Curse"] = "Spell_Shadow_Contagion",
	["Amplify Magic"] = "Spell_Holy_FlashHeal",
	["Ancestral Fortitude"] = "Spell_Nature_UndyingStrength",
	["Ancestral Healing"] = "Spell_Nature_UndyingStrength",
	["Ancestral Knowledge"] = "Spell_Shadow_GrimWard",
	["Ancestral Spirit"] = "Spell_Nature_Regenerate",
	["Ancient Hysteria"] = "Spell_Shadow_UnholyFrenzy",
	["Anesthetic Poison"] = "Spell_Nature_SlowPoison",
	["Anger Management"] = "Spell_Holy_BlessingOfStamina",
	["Anguish"] = "Spell_Shadow_GatherShadows",
	["Anticipation"] = "Spell_Nature_MirrorImage",
	["Aquatic Form"] = "Ability_Druid_AquaticForm",
	["Arcane Blast"] = "Spell_Arcane_Blast",
	["Arcane Brilliance"] = "Spell_Holy_ArcaneIntellect",
	["Arcane Concentration"] = "Spell_Shadow_ManaBurn",
	["Arcane Energy"] = "Spell_Holy_MindVision",
	["Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Arcane Focus"] = "Spell_Holy_Devotion",
	["Arcane Fortitude"] = "Spell_Arcane_ArcaneResilience",
	["Arcane Impact"] = "Spell_Nature_WispSplode",
	["Arcane Instability"] = "Spell_Shadow_Teleport",
	["Arcane Intellect"] = "Spell_Holy_MagicalSentry",
	["Arcane Meditation"] = "Spell_Shadow_SiphonMana",
	["Arcane Mind"] = "Spell_Shadow_Charm",
	["Arcane Missiles"] = "Spell_Nature_StarFall",
	["Arcane Potency"] = "Spell_Arcane_ArcanePotency",
	["Arcane Power"] = "Spell_Nature_Lightning",
	["Arcane Resistance"] = "Spell_Nature_StarFall",
	["Arcane Shot"] = "Ability_ImpalingBolt",
	["Arcane Shroud"] = "Spell_Magic_LesserInvisibilty",
	["Arcane Subtlety"] = "Spell_Holy_DispelMagic",
	["Arcane Torrent"] = "Spell_Shadow_Teleport",
	["Arcane Weakness"] = "Spell_Shadow_SoulLeech_2",
	["Arctic Reach"] = "Spell_Shadow_DarkRitual",
	["Arctic Winds"] = "Spell_Frost_ArcticWinds",
	["Armor of Faith"] = "Spell_Holy_BlessingOfProtection",
	["Armorsmith"] = "Trade_BlackSmithing",
	["Aspect of the Beast"] = "Ability_Mount_PinkTiger",
	["Aspect of the Cheetah"] = "Ability_Mount_JungleTiger",
	["Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Aspect of the Pack"] = "Ability_Mount_WhiteTiger",
	["Aspect of the Viper"] = "Ability_Hunter_AspectoftheViper",
	["Aspect of the Wild"] = "Spell_Nature_ProtectionformNature",
	["Astral Recall"] = "Spell_Nature_AstralRecal",
	["Attack"] = "Temp",
	["Attacking"] = "Temp",
	["Auto Shot"] = "Ability_Whirlwind",
	["Avenger's Shield"] = "Spell_Holy_AvengersShield",
	["Avenging Wrath"] = "Spell_Holy_AvengineWrath",
	["Avoidance"] = "Spell_Magic_LesserInvisibilty",
	["Axe Specialization"] = "INV_Axe_06",
	["Backlash"] = "Spell_Fire_PlayingWithFire",
	["Backstab"] = "Ability_BackStab",
	["Badge of the Swarmguard"] = "INV_Misc_AhnQirajTrinket_04",
	["Balance of Power"] = "Ability_Druid_BalanceofPower",
	["Bane"] = "Spell_Shadow_DeathPact",
	["Banish"] = "Spell_Shadow_Cripple",
	["Banshee Curse"] = "Spell_Nature_Drowsy",
	["Barkskin"] = "Spell_Nature_StoneClawTotem",
	["Barrage"] = "Ability_UpgradeMoonGlaive",
	["Bash"] = "Ability_Druid_Bash",
	["Basic Campfire"] = "Spell_Fire_Fire",
	["Battle Rush"] = "Ability_Whirlwind",
	["Battle Shout"] = "Ability_Warrior_BattleShout",
	["Battle Stance"] = "Ability_Warrior_OffensiveStance",
	["Battle Stance Passive"] = "Ability_Warrior_OffensiveStance",
	["Bear Form"] = "Ability_Racial_BearForm",
	["Beast Lore"] = "Ability_Physical_Taunt",
	["Beast Slaying"] = "INV_Misc_Pelt_Bear_Ruin_02",
	["Beast Training"] = "Ability_Hunter_BeastCall02",
	["Benediction"] = "Spell_Frost_WindWalkOn",
	["Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Berserker Stance"] = "Ability_Racial_Avatar",
	["Berserker Stance Passive"] = "Ability_Racial_Avatar",
	["Berserking"] = "Racial_Troll_Berserk",
	["Bestial Discipline"] = "Spell_Nature_AbolishMagic",
	["Bestial Swiftness"] = "Ability_Druid_Dash",
	["Bestial Wrath"] = "Ability_Druid_FerociousBite",
	["Binding Heal"] = "Spell_Holy_BlindingHeal",
	["Bite"] = "Ability_Racial_Cannibalize",
	["Black Arrow"] = "Ability_TheBlackArrow",
	["Blackout"] = "Spell_Shadow_GatherShadows",
	["Blacksmithing"] = "Trade_BlackSmithing",
	["Blade Flurry"] = "Ability_Warrior_PunishingBlow",
	["Blade Turning"] = "Ability_Warrior_Challange",
	["Blade Twisting"] = "Ability_Rogue_BladeTwisting",
	["Blast Wave"] = "Spell_Holy_Excorcism_02",
	["Blazing Speed"] = "Spell_Fire_BurningSpeed",
	["Blessed Recovery"] = "Spell_Holy_BlessedRecovery",
	["Blessed Resilience"] = "Spell_Holy_BlessedResillience",
	["Blessing of Auchindoun"] = "INV_Battery_02",
	["Blessing of Freedom"] = "Spell_Holy_SealOfValor",
	["Blessing of Kings"] = "Spell_Magic_MageArmor",
	["Blessing of Light"] = "Spell_Holy_PrayerOfHealing02",
	["Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Blessing of Protection"] = "Spell_Holy_SealOfProtection",
	["Blessing of Sacrifice"] = "Spell_Holy_SealOfSacrifice",
	["Blessing of Salvation"] = "Spell_Holy_SealOfSalvation",
	["Blessing of Sanctuary"] = "Spell_Nature_LightningShield",
	["Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Blind"] = "Spell_Shadow_MindSteal",
	["Blinding Powder"] = "INV_Misc_Ammo_Gunpowder_02",
	["Blink"] = "Spell_Arcane_Blink",
	["Blizzard"] = "Spell_Frost_IceStorm",
	["Block"] = "Ability_Defend",
	["Blood Craze"] = "Spell_Shadow_SummonImp",
	["Blood Frenzy"] = "Ability_Warrior_BloodFrenzy",
	["Blood Fury"] = "Racial_Orc_BerserkerStrength",
	["Blood Pact"] = "Spell_Shadow_BloodBoil",
--	["Bloodboil"] = true,
	["Bloodlust"] = "Spell_Nature_BloodLust",
	["Bloodrage"] = "Ability_Racial_BloodRage",
	["Bloodthirst"] = "Spell_Nature_BloodLust",
	["Boar Charge"] = "Spell_Shadow_VampiricAura",
	["Booming Voice"] = "Spell_Nature_Purge",
	["Bow Specialization"] = "INV_Weapon_Bow_12",
	["Bows"] = "INV_Weapon_Bow_05",
	["Bright Campfire"] = "Spell_Fire_Fire",
	["Brittle Armor"] = "Spell_Shadow_GrimWard",
	["Brutal Impact"] = "Ability_Druid_Bash",
	["Burning Adrenaline"] = "INV_Gauntlets_03",
	["Burning Soul"] = "Spell_Fire_Fire",
	["Burning Wish"] = "Spell_Shadow_PsychicScream",
	["Call Pet"] = "Ability_Hunter_BeastCall",
	["Call of Flame"] = "Spell_Fire_Immolation",
	["Call of Thunder"] = "Spell_Nature_CallStorm",
	["Call of the Nexus"] = "Spell_Holy_MindVision",
	["Camouflage"] = "Ability_Stealth",
	["Cannibalize"] = "Ability_Racial_Cannibalize",
	["Cat Form"] = "Ability_Druid_CatForm",
	["Cataclysm"] = "Spell_Fire_WindsofWoe",
	["Celestial Focus"] = "Spell_Arcane_StarFire",
	["Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Challenging Roar"] = "Ability_Druid_ChallangingRoar",
	["Challenging Shout"] = "Ability_BullRush",
	["Charge"] = "Ability_Warrior_Charge",
	["Charge Rage Bonus Effect"] = "Ability_Warrior_Charge",
	["Charge Stun"] = "Spell_Frost_Stun",
	["Chastise"] = "Spell_Holy_Chastise",
	["Cheap Shot"] = "Ability_CheapShot",
	["Chilled"] = "Spell_Frost_IceStorm",
	["Circle of Healing"] = "Spell_Holy_CircleOfRenewal",
	["Claw"] = "Ability_Druid_Rake",
	["Cleanse"] = "Spell_Holy_Renew",
	["Clearcasting"] = "Spell_Shadow_ManaBurn",
	["Cleave"] = "Ability_Warrior_Cleave",
	["Clever Traps"] = "Spell_Nature_TimeStop",
	["Cloak of Shadows"] = "Spell_Shadow_NetherCloak",
	["Closing"] = "Temp",
	["Cloth"] = "INV_Chest_Cloth_21",
	["Coarse Sharpening Stone"] = "INV_Stone_SharpeningStone_02",
	["Cobra Reflexes"] = "Spell_Nature_GuardianWard",
	["Cold Blood"] = "Spell_Ice_Lament",
	["Cold Snap"] = "Spell_Frost_WizardMark",
	["Combat Endurance"] = "Spell_Nature_AncestralGuardian",
	["Combustion"] = "Spell_Fire_SealOfFire",
	["Command"] = "Ability_Warrior_WarCry",
	["Commanding Presence"] = "Ability_Warrior_BattleShout",
	["Commanding Shout"] = "Ability_Warrior_RallyingCry",
	["Concentration Aura"] = "Spell_Holy_MindSooth",
	["Concussion"] = "Spell_Fire_Fireball",
	["Concussion Blow"] = "Ability_ThunderBolt",
	["Concussive Barrage"] = "Spell_Arcane_StarFire",
	["Concussive Shot"] = "Spell_Frost_Stun",
	["Cone of Cold"] = "Spell_Frost_Glacier",
	["Conflagrate"] = "Spell_Fire_Fireball",
	["Conflagration"] = "Spell_Fire_Incinerate",
	["Conjure Food"] = "INV_Misc_Food_10",
	["Conjure Mana Agate"] = "INV_Misc_Gem_Emerald_01",
	["Conjure Mana Citrine"] = "INV_Misc_Gem_Opal_01",
	["Conjure Mana Emerald"] = "INV_Misc_Gem_Stone_01",
	["Conjure Mana Jade"] = "INV_Misc_Gem_Emerald_02",
	["Conjure Mana Ruby"] = "INV_Misc_Gem_Ruby_01",
	["Conjure Water"] = "INV_Drink_06",
	["Consecration"] = "Spell_Holy_InnerFire",
	["Consume Magic"] = "Spell_Arcane_StudentOfMagic",
	["Consume Shadows"] = "Spell_Shadow_AntiShadow",
	["Contagion"] = "Spell_Shadow_PainfulAfflictions",
	["Convection"] = "Spell_Nature_WispSplode",
	["Conviction"] = "Spell_Holy_RetributionAura",
	["Cooking"] = "INV_Misc_Food_15",
	["Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Counterattack"] = "Ability_Warrior_Challange",
	["Counterspell"] = "Spell_Frost_IceShock",
	["Counterspell - Silenced"] = "Spell_Frost_IceShock",
	["Cower"] = "Ability_Druid_Cower",
	["Create Firestone"] = "INV_Ammo_FireTar",
	["Create Firestone (Greater)"] = "INV_Ammo_FireTar",
	["Create Firestone (Lesser)"] = "INV_Ammo_FireTar",
	["Create Firestone (Major)"] = "INV_Ammo_FireTar",
	["Create Healthstone"] = "INV_Stone_04",
	["Create Healthstone (Greater)"] = "INV_Stone_04",
	["Create Healthstone (Lesser)"] = "INV_Stone_04",
	["Create Healthstone (Major)"] = "INV_Stone_04",
	["Create Healthstone (Minor)"] = "INV_Stone_04",
	["Create Soulstone"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Greater)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Lesser)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Major)"] = "Spell_Shadow_SoulGem",
	["Create Soulstone (Minor)"] = "Spell_Shadow_SoulGem",
	["Create Spellstone"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Greater)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Major)"] = "INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Master)"] = "INV_Misc_Gem_Sapphire_01",
	["Creeping Paralysis"] = "Spell_Nature_TimeStop",
	["Cripple"] = "Spell_Shadow_Cripple",
	["Crippling Poison"] = "Ability_PoisonSting",
	["Crippling Poison II"] = "Ability_PoisonSting",
	["Critical Mass"] = "Spell_Nature_WispHeal",
	["Crossbows"] = "INV_Weapon_Crossbow_01",
	["Cruelty"] = "Ability_Rogue_Eviscerate",
	["Crusade"] = "Spell_Holy_Crusade",
	["Crusader Aura"] = "Spell_Holy_CrusaderAura",
	["Crusader Strike"] = "Spell_Holy_CrusaderStrike",
	["Cultivation"] = "INV_Misc_Flower_01",
	["Cure Disease"] = "Spell_Holy_NullifyDisease",
	["Cure Poison"] = "Spell_Nature_NullifyPoison",
	["Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Curse of Doom"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Doom Effect"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Curse of Idiocy"] = "Spell_Shadow_MindRot",
	["Curse of Recklessness"] = "Spell_Shadow_UnholyStrength",
	["Curse of Shadow"] = "Spell_Shadow_CurseOfAchimonde",
	["Curse of Tongues"] = "Spell_Shadow_CurseOfTounges",
	["Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Curse of the Elements"] = "Spell_Shadow_ChillTouch",
	["Cyclone"] = "Spell_Nature_EarthBind",
	["Dagger Specialization"] = "INV_Weapon_ShortBlade_05",
	["Daggers"] = "Ability_SteelMelee",
	["Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Dark Barrage"] = "Spell_Shadow_PainSpike",
	["Dark Pact"] = "Spell_Shadow_DarkRitual",
	["Darkness"] = "Spell_Shadow_Twilight",
	["Dash"] = "Ability_Druid_Dash",
	["Dawnstone Crab"] = "Ability_Hunter_Pet_Crab",
	["Dazed"] = "Spell_Frost_Stun",
	["Deadly Interrupt Effect"] = "INV_ThrowingKnife_06",
	["Deadly Poison"] = "Ability_Rogue_DualWeild",
	["Deadly Poison II"] = "Ability_Rogue_DualWeild",
	["Deadly Poison III"] = "Ability_Rogue_DualWeild",
	["Deadly Poison IV"] = "Ability_Rogue_DualWeild",
	["Deadly Poison V"] = "Ability_Rogue_DualWeild",
	["Deadly Poison VI"] = "Ability_Rogue_DualWeild",
	["Deadly Poison VII"] = "Ability_Rogue_DualWeild",
	["Deadly Throw"] = "INV_ThrowingKnife_06",
	["Death Coil"] = "Spell_Shadow_DeathCoil",
	["Death Wish"] = "Spell_Shadow_DeathPact",
	["Deep Wound"] = "Ability_BackStab", --Debuff
	["Deep Wounds"] = "Ability_BackStab", -- Talent
	["Defense"] = "Ability_Racial_ShadowMeld",
	["Defensive Stance"] = "Ability_Warrior_DefensiveStance",
	["Defensive Stance Passive"] = "Ability_Warrior_DefensiveStance",
	["Defiance"] = "Ability_Warrior_InnerRage",
	["Deflection"] = "Ability_Parry",
	["Delusions of Jin'do"] = "Spell_Shadow_UnholyFrenzy",
	["Demon Armor"] = "Spell_Shadow_RagingScream",
	["Demon Skin"] = "Spell_Shadow_RagingScream",
	["Demonic Aegis"] = "Spell_Shadow_RagingScream",
	["Demonic Embrace"] = "Spell_Shadow_Metamorphosis",
	["Demonic Frenzy"] = "Spell_Shadow_DeathPact",
	["Demonic Knowledge"] = "Spell_Shadow_ImprovedVampiricEmbrace",
	["Demonic Resilience"] = "Spell_Shadow_DemonicFortitude",
	["Demonic Sacrifice"] = "Spell_Shadow_PsychicScream",
	["Demonic Tactics"] = "Spell_Shadow_DemonicTactics",
	["Demoralizing Roar"] = "Ability_Druid_DemoralizingRoar",
	["Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Dense Sharpening Stone"] = "INV_Stone_SharpeningStone_05",
	["Desperate Prayer"] = "Spell_Holy_Restoration",
	["Destructive Reach"] = "Spell_Shadow_CorpseExplode",
	["Detect"] = "Ability_Hibernation",
	["Detect Greater Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Lesser Invisibility"] = "Spell_Shadow_DetectLesserInvisibility",
	["Detect Magic"] = "Spell_Holy_Dizzy",
	["Detect Traps"] = "Ability_Spy",
	["Deterrence"] = "Ability_Whirlwind",
	["Devastate"] = "INV_Sword_11",
	["Devastation"] = "Spell_Fire_FlameShock",
	["Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Devour Magic"] = "Spell_Nature_Purge",
	["Devour Magic Effect"] = "Spell_Nature_Purge",
	["Devouring Plague"] = "Spell_Shadow_BlackPlague",
	["Diplomacy"] = "INV_Misc_Note_02",
	["Dire Bear Form"] = "Ability_Racial_BearForm",
	["Dirty Deeds"] = "Spell_Shadow_SummonSuccubus",
	["Dirty Tricks"] = "Ability_Sap",
	["Disarm"] = "Ability_Warrior_Disarm",
	["Disarm Trap"] = "Spell_Shadow_GrimWard",
	["Disease Cleansing Totem"] = "Spell_Nature_DiseaseCleansingTotem",
	["Disenchant"] = "Spell_Holy_RemoveCurse",
	["Disengage"] = "Ability_Rogue_Feint",
	["Dismiss Pet"] = "Spell_Nature_SpiritWolf",
	["Dispel Magic"] = "Spell_Holy_DispelMagic",
	["Distract"] = "Ability_Rogue_Distract",
	["Distracting Shot"] = "Spell_Arcane_Blink",
	["Dive"] = "Spell_Shadow_BurningSpirit",
	["Divine Favor"] = "Spell_Holy_Heal",
	["Divine Fury"] = "Spell_Holy_SealOfWrath",
	["Divine Illumination"] = "Spell_Holy_DivineIllumination",
	["Divine Intellect"] = "Spell_Nature_Sleep",
	["Divine Intervention"] = "Spell_Nature_TimeStop",
	["Divine Protection"] = "Spell_Holy_Restoration",
	["Divine Shield"] = "Spell_Holy_DivineIntervention",
	["Divine Spirit"] = "Spell_Holy_DivineSpirit",
	["Divine Strength"] = "Ability_GolemThunderClap",
	["Divine Wrath"] = "Spell_Holy_SearingLight",
	["Dodge"] = "Spell_Nature_Invisibilty",
	["Doomfire"] = "Spell_Fire_Incinerate",
	["Dragon's Breath"] = "INV_Misc_Head_Dragon_01",
	["Dragonscale Leatherworking"] = "INV_Misc_MonsterScales_03",
	["Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Drain Soul"] = "Spell_Shadow_Haunting",
	["Dreamless Sleep"] = "Spell_Nature_Sleep",
	["Drink"] = "INV_Drink_07",
	["Dual Wield"] = "Ability_DualWield",
	["Dual Wield Specialization"] = "Ability_DualWield",
	["Duel"] = "Temp",
	["Dust Cloud"] = "Ability_Hibernation",
	["Eagle Eye"] = "Ability_Hunter_EagleEye",
	["Earth Elemental Totem"] = "Spell_Nature_EarthElemental_Totem",
	["Earth Shield"] = "Spell_Nature_SkinofEarth",
	["Earth Shock"] = "Spell_Nature_EarthShock",
	["Earthbind"] = "Spell_Nature_StrengthOfEarthTotem02",
	["Earthbind Totem"] = "Spell_Nature_StrengthOfEarthTotem02",
	["Earthstrike"] = "Spell_Nature_AbolishMagic",
	["Efficiency"] = "Spell_Frost_WizardMark",
	["Elemental Devastation"] = "Spell_Fire_ElementalDevastation",
	["Elemental Focus"] = "Spell_Shadow_ManaBurn",
	["Elemental Fury"] = "Spell_Fire_Volcano",
	["Elemental Leatherworking"] = "Trade_LeatherWorking",
	["Elemental Mastery"] = "Spell_Nature_WispHeal",
	["Elemental Precision"] = "Spell_Nature_ElementalPrecision_1", -- Shaman and Mage Talents with different icons
	["Elemental Sharpening Stone"] = "INV_Stone_02",
	["Elemental Weapons"] = "Spell_Fire_FlameTounge",
	["Elune's Grace"] = "Spell_Holy_ElunesGrace",
	["Elusiveness"] = "Spell_Magic_LesserInvisibilty",
	["Emberstorm"] = "Spell_Fire_SelfDestruct",
	["Empowered Arcane Missiles"] = "Spell_Nature_StarFall",
	["Empowered Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Empowered Fireball"] = "Spell_Fire_FlameBolt",
	["Empowered Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Empowered Healing"] = "Spell_Holy_GreaterHeal",
	["Empowered Rejuvenation"] = "Ability_Druid_EmpoweredRejuvination",
	["Empowered Touch"] = "Ability_Druid_EmpoweredTouch",
	["Enamored Water Spirit"] = "INV_Wand_01",
	["Enchanting"] = "Trade_Engraving",
	["Endurance"] = "Spell_Nature_UnyeildingStamina",
	["Endurance Training"] = "Spell_Nature_Reincarnation",
	["Engineering"] = "Trade_Engineering",
	["Engineering Specialization"] = "INV_Misc_Gear_01",
	["Enrage"] = "Ability_Druid_Enrage",
	["Enriched Manna Biscuit"] = "INV_Misc_Fork&Knife",
	["Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Entrapment"] = "Spell_Nature_StrangleVines",
	["Envenom"] = "Ability_Rogue_Disembowel",
	["Escape Artist"] = "Ability_Rogue_Trip",
	["Evasion"] = "Spell_Shadow_ShadowWard",
	["Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Evocation"] = "Spell_Nature_Purge",
	["Execute"] = "INV_Sword_48",
	["Exorcism"] = "Spell_Holy_Excorcism_02",
	["Expansive Mind"] = "INV_Enchant_EssenceEternalLarge",
	["Explosive Trap"] = "Spell_Fire_SelfDestruct",
	["Explosive Trap Effect"] = "Spell_Fire_SelfDestruct",
	["Expose Armor"] = "Ability_Warrior_Riposte",
	["Expose Weakness"] = "Ability_Hunter_SniperShot",
	["Extract Gas"] = "Spell_Nature_AbolishMagic",
	["Eye for an Eye"] = "Spell_Holy_EyeforanEye",
	["Eye of Kilrogg"] = "Spell_Shadow_EvilEye",
	["Eye of the Storm"] = "Spell_Shadow_SoulLeech_2",
	["Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Fade"] = "Spell_Magic_LesserInvisibilty",
	["Faerie Fire"] = "Spell_Nature_FaerieFire",
	["Faerie Fire (Feral)"] = "Spell_Nature_FaerieFire",
	["Fanaticism"] = "Spell_Holy_Fanaticism",
	["Far Sight"] = "Spell_Nature_FarSight",
	["Fatal Attraction"] = "Spell_Shadow_Shadowfury",
	["Fear"] = "Spell_Shadow_Possession",
	["Fear Ward"] = "Spell_Holy_Excorcism",
	["Feed Pet"] = "Ability_Hunter_BeastTraining",
	["Feed Pet Effect"] = "Ability_Hunter_BeastTraining",
	["Feedback"] = "Spell_Shadow_RitualOfSacrifice",
	["Feign Death"] = "Ability_Rogue_FeignDeath",
	["Feint"] = "Ability_Rogue_Feint",
	["Fel Armor"] = "Spell_Shadow_FelArmour",
	["Fel Concentration"] = "Spell_Shadow_FingerOfDeath",
	["Fel Domination"] = "Spell_Nature_RemoveCurse",
	["Fel Energy"] = "Spell_Shadow_PsychicScream",
	["Fel Intellect"] = "Spell_Holy_MagicalSentry",
	["Fel Rage"] = "Spell_Fire_ElementalDevastation",
	["Fel Stamina"] = "Spell_Shadow_AntiShadow",
	["Felfire"] = "Spell_Fire_Fireball",
	["Feline Grace"] = "INV_Feather_01",
	["Feral Aggression"] = "Ability_Druid_DemoralizingRoar",
	["Feral Charge"] = "Ability_Hunter_Pet_Bear",
	["Feral Instinct"] = "Ability_Ambush",
	["Feral Swiftness"] = "Spell_Nature_SpiritWolf",
	["Ferocious Bite"] = "Ability_Druid_FerociousBite",
	["Ferocious Inspiration"] = "Ability_Hunter_FerociousInspiration",
	["Ferocity"] = "INV_Misc_MonsterClaw_04",
	["Fetish"] = "INV_Misc_Horn_01",
	["Find Fish"] = "INV_Misc_Fish_02",
	["Find Herbs"] = "INV_Misc_Flower_02",
	["Find Minerals"] = "Spell_Nature_Earthquake",
	["Find Treasure"] = "Racial_Dwarf_FindTreasure",
	["Find Weakness"] = "Ability_Rogue_FindWeakness",
	["Fire Blast"] = "Spell_Fire_Fireball",
	["Fire Breath"] = "Spell_Fire_Burnout",
	["Fire Elemental Totem"] = "Spell_Fire_Elemental_Totem",
	["Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Fire Power"] = "Spell_Fire_Immolation",
	["Fire Resistance"] = "Spell_Fire_FireArmor",
	["Fire Resistance Aura"] = "Spell_Fire_SealOfFire",
	["Fire Resistance Totem"] = "Spell_FireResistanceTotem_01",
	["Fire Shield"] = "Spell_Fire_FireArmor",
	["Fire Vulnerability"] = "Spell_Fire_SoulBurn",
	["Fire Ward"] = "Spell_Fire_FireArmor",
	["Fire Weakness"] = "INV_Misc_QirajiCrystal_02",
	["Fireball"] = "Spell_Fire_FlameBolt",
	["Firebolt"] = "Spell_Fire_FireBolt",
	["First Aid"] = "Spell_Holy_SealOfSacrifice",
	["Fishing"] = "Trade_Fishing",
	["Fishing Poles"] = "Trade_Fishing",
	["Fist Weapon Specialization"] = "INV_Gauntlets_04",
	["Fist Weapons"] = "INV_Gauntlets_04",
	["Flame Shock"] = "Spell_Fire_FlameShock",
	["Flame Throwing"] = "Spell_Fire_Flare",
	["Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Flamethrower"] = "Spell_Fire_Incinerate",
	["Flametongue Attack"] = "Spell_Fire_FlameTounge",
	["Flametongue Totem"] = "Spell_Nature_GuardianWard",
	["Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Flare"] = "Spell_Fire_Flare",
	["Flash Heal"] = "Spell_Holy_FlashHeal",
	["Flash of Light"] = "Spell_Holy_FlashHeal",
	["Flight Form"] = "Ability_Druid_FlightForm",
	["Flurry"] = "Ability_GhoulFrenzy",
	["Focused Casting"] = "Spell_Arcane_Blink",
	["Focused Mind"] = "Spell_Nature_FocusedMind",
	["Focused Power"] = "Spell_Shadow_FocusedPower",
	["Focused Rage"] = "Ability_Warrior_FocusedRage",
	["Focused Starlight"] = "INV_Staff_01",
	["Food"] = "INV_Misc_Fork&Knife",
	["Forbearance"] = "Spell_Holy_RemoveCurse",
	["Force of Nature"] = "Ability_Druid_ForceofNature",
	["Force of Will"] = "Spell_Nature_SlowingTotem",
	["Freezing Trap"] = "Spell_Frost_ChainsOfIce",
	["Freezing Trap Effect"] = "Spell_Frost_ChainsOfIce",
	["Frenzied Regeneration"] = "Ability_BullRush",
	["Frenzy"] = "INV_Misc_MonsterClaw_03",
	["Frenzy Effect"] = "INV_Misc_MonsterClaw_03",
	["Frost Armor"] = "Spell_Frost_FrostArmor02",
	["Frost Blast"] = "Spell_Frost_FrostBolt02",
	["Frost Channeling"] = "Spell_Frost_Stun",
	["Frost Nova"] = "Spell_Frost_FrostNova",
	["Frost Resistance"] = "Spell_Frost_FrostWard",
	["Frost Resistance Aura"] = "Spell_Frost_WizardMark",
	["Frost Resistance Totem"] = "Spell_FrostResistanceTotem_01",
	["Frost Shock"] = "Spell_Frost_FrostShock",
	["Frost Trap"] = "Spell_Frost_FreezingBreath",
	["Frost Trap Aura"] = "Spell_Frost_FrostNova",
	["Frost Ward"] = "Spell_Frost_FrostWard",
	["Frost Warding"] = "Spell_Frost_FrostWard",
	["Frost Weakness"] = "INV_Misc_QirajiCrystal_04",
	["Frostbite"] = "Spell_Frost_FrostArmor",
	["Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Frostbrand Attack"] = "Spell_Frost_FrostBrand",
	["Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Frozen Core"] = "Spell_Frost_FrozenCore",
	["Furious Howl"] = "Ability_Hunter_Pet_Wolf",
	["Furor"] = "Spell_Holy_BlessingOfStamina",
	["Fury of the Crashing Waves"] = "Spell_Nature_UnrelentingStorm",
	["Garrote"] = "Ability_Rogue_Garrote",
	["Garrote - Silence"] = "Ability_Rogue_Garrote",
	["Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Ghostly Strike"] = "Spell_Shadow_Curse",
	["Gift of Life"] = "INV_Misc_Gem_Pearl_05",
	["Gift of Nature"] = "Spell_Nature_ProtectionformNature",
	["Gift of the Naaru"] = "Spell_Holy_HolyProtection",
	["Gift of the Wild"] = "Spell_Nature_Regeneration",
	["Gouge"] = "Ability_Gouge",
	["Grace of Air"] = "Spell_Nature_InvisibilityTotem",
	["Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Great Stamina"] = "Spell_Nature_UnyeildingStamina",
	["Greater Blessing of Kings"] = "Spell_Magic_GreaterBlessingofKings",
	["Greater Blessing of Light"] = "Spell_Holy_GreaterBlessingofLight",
	["Greater Blessing of Might"] = "Spell_Holy_GreaterBlessingofKings",
	["Greater Blessing of Salvation"] = "Spell_Holy_GreaterBlessingofSalvation",
	["Greater Blessing of Sanctuary"] = "Spell_Holy_GreaterBlessingofSanctuary",
	["Greater Blessing of Wisdom"] = "Spell_Holy_GreaterBlessingofWisdom",
	["Greater Dreamless Sleep"] = "Spell_Nature_Sleep",
	["Greater Heal"] = "Spell_Holy_GreaterHeal",
	["Grievous Throw"] = "Ability_BackStab",
	["Grim Reach"] = "Spell_Shadow_CallofBone",
	["Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Grounding Totem Effect"] = "Spell_Nature_GroundingTotem",
	["Grovel"] = "Temp",
	["Growl"] = "Ability_Physical_Taunt",
	["Guardian's Favor"] = "Spell_Holy_SealOfProtection",
	["Gun Specialization"] = "INV_Musket_03",
	["Guns"] = "INV_Weapon_Rifle_01",
	["Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Hammer of Wrath"] = "Ability_ThunderClap",
	["Hamstring"] = "Ability_ShockWave",
	["Harass"] = "Ability_Hunter_Harass",
	["Hardiness"] = "INV_Helmet_23",
	["Haste"] = "INV_Potion_108", -- there are a lot of icons for Haste
	["Hawk Eye"] = "Ability_TownWatch",
	["Heal"] = "Spell_Holy_Heal",
	["Healing Focus"] = "Spell_Holy_HealingFocus",
	["Healing Light"] = "Spell_Holy_HolyBolt",
	["Healing Stream"] = "INV_Spear_04",
	["Healing Stream Totem"] = "INV_Spear_04",
	["Healing Touch"] = "Spell_Nature_HealingTouch",
	["Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Healing Way"] = "Spell_Nature_HealingWay",
	["Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Heart of the Wild"] = "Spell_Holy_BlessingOfAgility",
	["Heavy Sharpening Stone"] = "INV_Stone_SharpeningStone_03",
	["Hellfire"] = "Spell_Fire_Incinerate",
	["Hellfire Effect"] = "Spell_Fire_Incinerate",
	["Hellfire Superiority"] = "INV_BannerPVP_02", -- Horde and Alliance have different icons
	["Hemorrhage"] = "Spell_Shadow_LifeDrain",
	["Herb Gathering"] = "Spell_Nature_NatureTouchGrow",
	["Herbalism"] = "Spell_Nature_NatureTouchGrow",
	["Heroic Strike"] = "Ability_Rogue_Ambush",
	["Heroism"] = "Ability_Shaman_Heroism",
	["Hex of Weakness"] = "Spell_Shadow_FingerOfDeath",
	["Hibernate"] = "Spell_Nature_Sleep",
	["Holy Fire"] = "Spell_Holy_SearingLight",
	["Holy Light"] = "Spell_Holy_HolyBolt",
	["Holy Nova"] = "Spell_Holy_HolyNova",
	["Holy Power"] = "Spell_Holy_Power",
	["Holy Reach"] = "Spell_Holy_Purify",
	["Holy Shield"] = "Spell_Holy_BlessingOfProtection",
	["Holy Shock"] = "Spell_Holy_SearingLight",
	["Holy Specialization"] = "Spell_Holy_SealOfSalvation",
--	["Holy Vengeance"] = true,
	["Holy Wrath"] = "Spell_Holy_Excorcism",
	["Honorless Target"] = "Spell_Magic_LesserInvisibilty",
	["Horse Riding"] = "Spell_Nature_Swiftness",
	["Howl of Terror"] = "Spell_Shadow_DeathScream",
	["Humanoid Slaying"] = "Spell_Holy_PrayerOfHealing",
	["Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Hurricane"] = "Spell_Nature_Cyclone",
	["Hypothermia"] = "Spell_Fire_BlueImmolation",
	["Ice Armor"] = "Spell_Frost_FrostArmor02",
	["Ice Barrier"] = "Spell_Ice_Lament",
	["Ice Block"] = "Spell_Frost_Frost",
	["Ice Floes"] = "Spell_Frost_IceFloes",
	["Ice Lance"] = "Spell_Frost_FrostBlast",
	["Ice Shards"] = "Spell_Frost_IceShard",
	["Icy Veins"] = "Spell_Frost_ColdHearted",
	["Ignite"] = "Spell_Fire_Incinerate",
	["Ignite Mana"] = "Spell_Fire_Incinerate",
	["Illumination"] = "Spell_Holy_GreaterHeal",
	["Immolate"] = "Spell_Fire_Immolation",
	["Immolation Trap"] = "Spell_Fire_FlameShock",
	["Immolation Trap Effect"] = "Spell_Fire_FlameShock",
	["Impact"] = "Spell_Fire_MeteorStorm",
	["Impale"] = "Ability_SearingArrow",
	["Impaling Spine"] = "Spell_Frost_IceShard",
	["Improved Ambush"] = "Ability_Rogue_Ambush",
	["Improved Arcane Missiles"] = "Spell_Nature_StarFall",
	["Improved Arcane Shot"] = "Ability_ImpalingBolt",
	["Improved Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Improved Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Improved Backstab"] = "Ability_BackStab",
	["Improved Barrage"] = "Ability_UpgradeMoonGlaive",
	["Improved Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Improved Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Improved Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Improved Blink"] = "Spell_Arcane_Blink",
	["Improved Blizzard"] = "Spell_Frost_IceStorm",
	["Improved Bloodrage"] = "Ability_Racial_BloodRage",
	["Improved Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Improved Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Improved Challenging Shout"] = "Ability_Warrior_Challange",
	["Improved Charge"] = "Ability_Warrior_Charge",
	["Improved Cleave"] = "Ability_Warrior_Cleave",
	["Improved Concentration Aura"] = "Spell_Holy_MindSooth",
	["Improved Concussive Shot"] = "Spell_Frost_Stun",
	["Improved Cone of Cold"] = "Spell_Frost_Glacier",
	["Improved Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Improved Counterspell"] = "Spell_Frost_IceShock",
	["Improved Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Improved Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Improved Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Improved Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Improved Disarm"] = "Ability_Warrior_Disarm",
	["Improved Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Improved Drain Soul"] = "Spell_Shadow_Haunting",
	["Improved Enrage"] = "Ability_Druid_Enrage",
	["Improved Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Improved Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Improved Execute"] = "INV_Sword_48",
	["Improved Expose Armor"] = "Ability_Warrior_Riposte",
	["Improved Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Improved Fade"] = "Spell_Magic_LesserInvisibilty",
	["Improved Feign Death"] = "Ability_Rogue_FeignDeath",
	["Improved Fire Blast"] = "Spell_Fire_Fireball",
	["Improved Fire Totems"] = "Spell_Fire_SealOfFire",
	["Improved Fire Ward"] = "Spell_Fire_FireArmor",
	["Improved Fireball"] = "Spell_Fire_FlameBolt",
	["Improved Firebolt"] = "Spell_Fire_FireBolt",
	["Improved Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Improved Flash of Light"] = "Spell_Holy_FlashHeal",
	["Improved Frost Nova"] = "Spell_Frost_FreezingBreath",
	["Improved Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Improved Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Improved Gouge"] = "Ability_Gouge",
	["Improved Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Improved Hamstring"] = "Ability_ShockWave",
	["Improved Healing"] = "Spell_Holy_Heal02",
	["Improved Healing Touch"] = "Spell_Nature_HealingTouch",
	["Improved Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Improved Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Improved Healthstone"] = "INV_Stone_04",
	["Improved Heroic Strike"] = "Ability_Rogue_Ambush",
	["Improved Holy Shield"] = "Spell_Holy_BlessingOfProtection",
	["Improved Howl of Terror"] = "Spell_Shadow_DeathScream",
	["Improved Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Improved Immolate"] = "Spell_Fire_Immolation",
	["Improved Imp"] = "Spell_Shadow_SummonImp",
	["Improved Inner Fire"] = "Spell_Holy_InnerFire",
	["Improved Intercept"] = "Ability_Rogue_Sprint",
	["Improved Intimidating Shout"] = "Ability_GolemThunderClap",
	["Improved Judgement"] = "Spell_Holy_RighteousFury",
	["Improved Kick"] = "Ability_Kick",
	["Improved Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Improved Lash of Pain"] = "Spell_Shadow_Curse",
	["Improved Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Improved Leader of the Pack"] = "Spell_Nature_UnyeildingStamina",
	["Improved Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Improved Lightning Bolt"] = "Spell_Nature_Lightning",
	["Improved Lightning Shield"] = "Spell_Nature_LightningShield",
	["Improved Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Improved Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Improved Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Improved Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Improved Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Improved Mend Pet"] = "Ability_Hunter_MendPet",
	["Improved Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Improved Moonfire"] = "Spell_Nature_StarFall",
	["Improved Mortal Strike"] = "Ability_Warrior_SavageBlow",
	["Improved Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Improved Overpower"] = "INV_Sword_05",
	["Improved Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Improved Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Improved Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Improved Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Improved Regrowth"] = "Spell_Nature_ResistNature",
	["Improved Reincarnation"] = "Spell_Nature_Reincarnation",
	["Improved Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Improved Rend"] = "Ability_Gouge",
	["Improved Renew"] = "Spell_Holy_Renew",
	["Improved Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Improved Revenge"] = "Ability_Warrior_Revenge",
	["Improved Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Improved Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Improved Rupture"] = "Ability_Rogue_Rupture",
	["Improved Scorch"] = "Spell_Fire_SoulBurn",
	["Improved Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Improved Seal of Righteousness"] = "Ability_ThunderBolt",
	["Improved Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Improved Searing Pain"] = "Spell_Fire_SoulBurn",
	["Improved Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Improved Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Improved Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Improved Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Improved Shield Block"] = "Ability_Defend",
	["Improved Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Improved Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Improved Slam"] = "Ability_Warrior_DecisiveStrike",
	["Improved Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Improved Sprint"] = "Ability_Rogue_Sprint",
	["Improved Stings"] = "Ability_Hunter_Quickshot",
	["Improved Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Improved Sunder Armor"] = "Ability_Warrior_Sunder",
	["Improved Taunt"] = "Spell_Nature_Reincarnation",
	["Improved Thunder Clap"] = "Ability_ThunderClap",
	["Improved Tranquility"] = "Spell_Nature_Tranquility",
	["Improved Vampiric Embrace"] = "Spell_Shadow_ImprovedVampiricEmbrace",
	["Improved Vanish"] = "Ability_Vanish",
	["Improved Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Improved Weapon Totems"] = "Spell_Fire_EnchantWeapon",
	["Improved Whirlwind"] = "Ability_Whirlwind",
	["Improved Wing Clip"] = "Ability_Rogue_Trip",
	["Incinerate"] = "Spell_Fire_Burnout",
	["Incineration"] = "Spell_Fire_FlameShock",
	["Inferno"] = "Spell_Shadow_SummonInfernal",
	["Initiative"] = "Spell_Shadow_Fumble",
	["Inner Fire"] = "Spell_Holy_InnerFire",
	["Inner Focus"] = "Spell_Frost_WindWalkOn",
	["Innervate"] = "Spell_Nature_Lightning",
	["Insect Swarm"] = "Spell_Nature_InsectSwarm",
	["Insidious Whisper"] = "Spell_Shadow_ManaFeed",
	["Insignifigance"] = "Ability_Hibernation",
	["Inspiration"] = "Spell_Holy_LayOnHands",
	["Instant Poison"] = "Ability_Poisons",
	["Instant Poison II"] = "Ability_Poisons",
	["Instant Poison III"] = "Ability_Poisons",
	["Instant Poison IV"] = "Ability_Poisons",
	["Instant Poison V"] = "Ability_Poisons",
	["Instant Poison VI"] = "Ability_Poisons",
	["Instant Poison VII"] = "Ability_Poisons",
	["Intensity"] = "Spell_Fire_LavaSpawn",
	["Intercept"] = "Ability_Rogue_Sprint",
	["Intercept Stun"] = "Spell_Frost_Stun",
	["Intervene"] = "Ability_Warrior_VictoryRush",
	["Intimidating Shout"] = "Ability_GolemThunderClap",
	["Intimidation"] = "Ability_Devour",
	["Invisibility"] = "Ability_Mage_Invisibility",
	["Iron Will"] = "Spell_Magic_MageArmor",
	["Jewelcrafting"] = "INV_Misc_Gem_02",
	["Jom Gabbar"] = "INV_Misc_EngGizmos_19",
	["Judgement"] = "Spell_Holy_RighteousFury",
	["Judgement of Blood"] = "Spell_Shadow_LifeDrain",
	["Judgement of Command"] = "Ability_Warrior_InnerRage",
	["Judgement of Justice"] = "Spell_Holy_SealOfWrath",
	["Judgement of Light"] = "Spell_Holy_HealingAura",
	["Judgement of Reckoning"] = "Ability_Warrior_InnerRage",
	["Judgement of Righteousness"] = "Ability_ThunderBolt",
	["Judgement of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Judgement of the Crusader"] = "Spell_Holy_HolySmite",
	["Kick"] = "Ability_Kick",
	["Kick - Silenced"] = "Ability_Kick",
	["Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Kill Command"] = "Ability_Hunter_KillCommand",
	["Killer Instinct"] = "Spell_Holy_BlessingOfStamina",
	["Kiss of the Spider"] = "INV_Trinket_Naxxramas04",
	["Kodo Riding"] = "Spell_Nature_Swiftness",
	["Lacerate"] = "Ability_Druid_Lacerate",
	["Lash of Pain"] = "Spell_Shadow_Curse",
	["Last Stand"] = "Spell_Holy_AshesToAshes",
	["Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Leader of the Pack"] = "Spell_Nature_UnyeildingStamina",
	["Leather"] = "INV_Chest_Leather_09",
	["Leatherworking"] = "INV_Misc_ArmorKit_17",
	["Lesser Heal"] = "Spell_Holy_LesserHeal",
	["Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Lesser Invisibility"] = "Spell_Magic_LesserInvisibilty",
	["Lethal Shots"] = "Ability_SearingArrow",
	["Lethality"] = "Ability_CriticalStrike",
	["Levitate"] = "Spell_Holy_LayOnHands",
	["Libram"] = "INV_Misc_Book_11",
	["Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Lifebloom"] = "INV_Misc_Herb_Felblossom",
	["Light's Grace"] = "Spell_Holy_LightsGrace",
	["Lightning Bolt"] = "Spell_Nature_Lightning",
	["Lightning Breath"] = "Spell_Nature_Lightning",
	["Lightning Mastery"] = "Spell_Lightning_LightningBolt01",
	["Lightning Reflexes"] = "Spell_Nature_Invisibilty",
	["Lightning Shield"] = "Spell_Nature_LightningShield",
	["Lightning Speed"] = "Spell_Nature_UnrelentingStorm",
	["Lightwell"] = "Spell_Holy_SummonLightwell",
	["Lightwell Renew"] = "Spell_Holy_SummonLightwell",
	["Lockpicking"] = "Spell_Nature_MoonKey",
	["Long Daze"] = "Spell_Frost_Stun",
	["Lust for Battle"] = "Spell_Shadow_DeathPact",
	["Mace Specialization"] = "INV_Mace_01",
	["Mace Stun Effect"] = "Spell_Frost_Stun",
	["Mage Armor"] = "Spell_MageArmor",
	["Magic Absorption"] = "Spell_Nature_AstralRecalGroup",
	["Magic Attunement"] = "Spell_Nature_AbolishMagic",
	["Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Mail"] = "INV_Chest_Chain_05",
	["Maim"] = "Ability_Druid_Mangle",
	["Major Dreamless Sleep"] = "Spell_Nature_Sleep",
	["Malediction"] = "Spell_Shadow_CurseOfAchimonde",
	["Malice"] = "Ability_Racial_BloodRage",
	["Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Mana Feed"] = "Spell_Shadow_ManaFeed",
	["Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Mana Spring"] = "Spell_Nature_ManaRegenTotem",
	["Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Mana Tap"] = "Spell_Arcane_ManaTap",
	["Mana Tide"] = "Spell_Frost_SummonWaterElemental",
	["Mana Tide Totem"] = "Spell_Frost_SummonWaterElemental",
	["Mangle"] = "Ability_Druid_Mangle",
	["Mangle (Bear)"] = "Ability_Druid_Mangle2",
	["Mangle (Cat)"] = "Ability_Druid_Mangle2",
	["Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Martyrdom"] = "Spell_Nature_Tranquility",
	["Mass Dispel"] = "Spell_Arcane_MassDispel",
	["Master Conjuror"] = "INV_Ammo_FireTar",
	["Master Demonologist"] = "Spell_Shadow_ShadowPact",
	["Master Summoner"] = "Spell_Shadow_ImpPhaseShift",
	["Master Tactician"] = "Ability_Hunter_MasterTactitian",
	["Master of Deception"] = "Spell_Shadow_Charm",
	["Master of Elements"] = "Spell_Fire_MasterOfElements",
	["Master of Subtlety"] = "Ability_Rogue_MasterOfSubtlety",
	["Maul"] = "Ability_Druid_Maul",
	["Mechanostrider Piloting"] = "Spell_Nature_Swiftness",
	["Meditation"] = "Spell_Nature_Sleep",
	["Melee Specialization"] = "INV_Axe_02",
	["Melt Armor"] = "Spell_Fire_Immolation",
	["Mend Pet"] = "Ability_Hunter_MendPet",
	["Mental Agility"] = "Ability_Hibernation",
	["Mental Strength"] = "Spell_Nature_EnchantArmor",
	["Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Mind Control"] = "Spell_Shadow_ShadowWordDominate",
	["Mind Flay"] = "Spell_Shadow_SiphonMana",
	["Mind Mastery"] = "Spell_Arcane_MindMastery",
	["Mind Soothe"] = "Spell_Holy_MindSooth",
	["Mind Vision"] = "Spell_Holy_MindVision",
	["Mind-numbing Poison"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison II"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison III"] = "Spell_Nature_NullifyDisease",
	["Mining"] = "Spell_Fire_FlameBlades",
	["Misdirection"] = "Ability_Hunter_Misdirection",
	["Misery"] = "Spell_Shadow_Misery",
	["Mocking Blow"] = "Ability_Warrior_PunishingBlow",
	["Molten Armor"] = "Ability_Mage_MoltenArmor",
	["Molten Fury"] = "Spell_Fire_MoltenBlood",
	["Mongoose Bite"] = "Ability_Hunter_SwiftStrike",
	["Monster Slaying"] = "INV_Misc_Head_Dragon_Black",
	["Moonfire"] = "Spell_Nature_StarFall",
	["Moonfury"] = "Spell_Nature_MoonGlow",
	["Moonglow"] = "Spell_Nature_Sentinal",
	["Moonkin Aura"] = "Spell_Nature_MoonGlow",
	["Moonkin Form"] = "Spell_Nature_ForceOfNature",
	["Mortal Shots"] = "Ability_PierceDamage",
	["Mortal Strike"] = "Ability_Warrior_SavageBlow",
	["Multi-Shot"] = "Ability_UpgradeMoonGlaive",
	["Murder"] = "Spell_Shadow_DeathScream",
	["Mutilate"] = "Ability_Rogue_ShadowStrikes",
	["Natural Armor"] = "Spell_Nature_SpiritArmor",
	["Natural Perfection"] = "Ability_Druid_NaturalPerfection",
	["Natural Shapeshifter"] = "Spell_Nature_WispSplode",
	["Naturalist"] = "Spell_Nature_HealingTouch",
	["Nature Resistance"] = "Spell_Nature_ResistNature",
	["Nature Resistance Totem"] = "Spell_Nature_NatureResistanceTotem",
	["Nature Weakness"] = "INV_Misc_QirajiCrystal_03",
	["Nature's Focus"] = "Spell_Nature_HealingWaveGreater",
	["Nature's Grace"] = "Spell_Nature_NaturesBlessing",
	["Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Nature's Guidance"] = "Spell_Frost_Stun",
	["Nature's Reach"] = "Spell_Nature_NatureTouchGrow",
	["Nature's Swiftness"] = "Spell_Nature_RavenForm",
	["Negative Charge"] = "Spell_ChargeNegative",
	["Nether Protection"] = "Spell_Shadow_NetherProtection",
	["Netherstorm Flag"] = "INV_Misc_Summerfest_BrazierGreen",
	["Nightfall"] = "Spell_Shadow_Twilight",
	["Nurturing Instinct"] = "Ability_Druid_HealingInstincts",
	["Omen of Clarity"] = "Spell_Nature_CrystalBall",
	["One-Handed Axes"] = "INV_Axe_01",
	["One-Handed Maces"] = "INV_Mace_01",
	["One-Handed Swords"] = "Ability_MeleeDamage",
	["One-Handed Weapon Specialization"] = "INV_Sword_20",
	["Opening"] = "Temp",
	["Opening - No Text"] = "Temp",
	["Opportunity"] = "Ability_Warrior_WarCry",
	["Overpower"] = "Ability_MeleeDamage",
	["Pain Suppression"] = "Spell_Holy_PainSupression",
	["Panic"] = "INV_Misc_Drum_06",
	["Paranoia"] = "Spell_Shadow_AuraOfDarkness",
	["Parasitic Shadowfiend"] = "Spell_Shadow_SoulLeech_3",
	["Parry"] = "Ability_Parry",
	["Pathfinding"] = "Ability_Mount_JungleTiger",
	["Perceived Weakness"] = "Spell_Holy_ArcaneIntellect",
	["Perception"] = "Spell_Nature_Sleep",
	["Permafrost"] = "Spell_Frost_Wisp",
	["Pet Aggression"] = "Ability_Druid_Maul",
	["Pet Hardiness"] = "Ability_BullRush",
	["Pet Recovery"] = "Ability_Hibernation",
	["Pet Resistance"] = "Spell_Holy_BlessingOfAgility",
	["Phase Shift"] = "Spell_Shadow_ImpPhaseShift",
	["Pick Lock"] = "Spell_Nature_MoonKey",
	["Pick Pocket"] = "INV_Misc_Bag_11",
	["Piercing Howl"] = "Spell_Shadow_DeathScream",
	["Piercing Ice"] = "Spell_Frost_Frostbolt",
	["Plate Mail"] = "INV_Chest_Plate01",
	["Playing with Fire"] = "Spell_Fire_PlayingWithFire",
	["Poison Cleansing Totem"] = "Spell_Nature_PoisonCleansingTotem",
	["Poison Spit"] = "Spell_Nature_CorrosiveBreath",
	["Poisons"] = "Trade_BrewPoison",
	["Polearms"] = "INV_Spear_06",
	["Poleaxe Specialization"] = "INV_Weapon_Halbard_01",
	["Polymorph"] = "Spell_Nature_Polymorph",
	["Polymorph: Pig"] = "Spell_Magic_PolymorphPig",
	["Polymorph: Turtle"] = "Ability_Hunter_Pet_Turtle",
	["Portal: Darnassus"] = "Spell_Arcane_PortalDarnassus",
	["Portal: Exodar"] = "Spell_Arcane_PortalExodar",
	["Portal: Ironforge"] = "Spell_Arcane_PortalIronForge",
	["Portal: Orgrimmar"] = "Spell_Arcane_PortalOrgrimmar",
	["Portal: Shattrath"] = "Spell_Arcane_PortalShattrath",
	["Portal: Silvermoon"] = "Spell_Arcane_PortalSilvermoon",
	["Portal: Stormwind"] = "Spell_Arcane_PortalStormWind",
	["Portal: Thunder Bluff"] = "Spell_Arcane_PortalThunderBluff",
	["Portal: Undercity"] = "Spell_Arcane_PortalUnderCity",
	["Positive Charge"] = "Spell_ChargePositive",
	["Pounce"] = "Ability_Druid_SupriseAttack",
	["Pounce Bleed"] = "Ability_Druid_SupriseAttack",
	["Power Infusion"] = "Spell_Holy_PowerInfusion",
	["Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Prayer of Fortitude"] = "Spell_Holy_PrayerOfFortitude",
	["Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Prayer of Mending"] = "Spell_Holy_PrayerOfMendingtga",
	["Prayer of Shadow Protection"] = "Spell_Holy_PrayerofShadowProtection",
	["Prayer of Spirit"] = "Spell_Holy_PrayerofSpirit",
	["Precision"] = "Ability_Marksmanship",
	["Predatory Instincts"] = "Ability_Druid_PredatoryInstincts",
	["Predatory Strikes"] = "Ability_Hunter_Pet_Cat",
	["Premeditation"] = "Spell_Shadow_Possession",
	["Preparation"] = "Spell_Shadow_AntiShadow",
	["Presence of Mind"] = "Spell_Nature_EnchantArmor",
	["Primal Fury"] = "Ability_Racial_Cannibalize",
	["Prismatic Cloak"] = "Spell_Arcane_PrismaticCloak",
	["Prospecting"] = "INV_Misc_Gem_Bloodstone_01",
	["Prowl"] = "Ability_Druid_SupriseAttack",
	["Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Pummel"] = "INV_Gauntlets_04",
	["Purge"] = "Spell_Nature_Purge",
	["Purification"] = "Spell_Frost_WizardMark",
	["Purify"] = "Spell_Holy_Purify",
	["Purifying Power"] = "Spell_Holy_PurifyingPower",
	["Pursuit of Justice"] = "Spell_Holy_PersuitofJustice",
	["Pyroblast"] = "Spell_Fire_Fireball02",
	["Pyroclasm"] = "Spell_Fire_Volcano",
	["Pyromaniac"] = "Spell_Fire_Burnout",
	["Quick Recovery"] = "Ability_Rogue_QuickRecovery",
	["Quick Shots"] = "Ability_Warrior_InnerRage",
	["Quickness"] = "Ability_Racial_ShadowMeld",
	["Rage of the Unraveller"] = "Racial_Orc_BerserkerStrength",
	["Rain of Fire"] = "Spell_Shadow_RainOfFire",
	["Rake"] = "Ability_Druid_Disembowel",
	["Ram Riding"] = "Spell_Nature_Swiftness",
	["Rampage"] = "Ability_Warrior_Rampage",
	["Ranged Weapon Specialization"] = "INV_Weapon_Rifle_06",
	["Rapid Fire"] = "Ability_Hunter_RunningShot",
	["Rapid Killing"] = "Ability_Hunter_RapidKilling",
	["Raptor Riding"] = "Spell_Nature_Swiftness",
	["Raptor Strike"] = "Ability_MeleeDamage",
	["Ravage"] = "Ability_Druid_Ravage",
	["Readiness"] = "Ability_Hunter_Readiness",
	["Rebirth"] = "Spell_Nature_Reincarnation",
	["Reckless Charge"] = "Spell_Nature_AstralRecal",
	["Recklessness"] = "Ability_CriticalStrike",
	["Reckoning"] = "Spell_Holy_BlessingOfStrength",
	["Redemption"] = "Spell_Holy_Resurrection",
	["Redoubt"] = "Ability_Defend",
	["Reflection"] = "Spell_Frost_WindWalkOn",
	["Regeneration"] = "Spell_Nature_Regenerate",
	["Regrowth"] = "Spell_Nature_ResistNature",
	["Reincarnation"] = "Spell_Nature_Reincarnation",
	["Reinforced Shield"] = "INV_Shield_06",
	["Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Relentless Strikes"] = "Ability_Warrior_DecisiveStrike",
	["Remorseless"] = "Ability_FiegnDead",
	["Remorseless Attacks"] = "Ability_FiegnDead",
	["Remote Toy"] = "INV_Misc_Urn_01",
	["Remove Curse"] = "Spell_Holy_RemoveCurse",
	["Remove Insignia"] = "Temp",
	["Remove Lesser Curse"] = "Spell_Nature_RemoveCurse",
	["Rend"] = "Ability_Gouge",
	["Renew"] = "Spell_Holy_Renew",
	["Repentance"] = "Spell_Holy_PrayerOfHealing",
	["Restless Strength"] = "Ability_CriticalStrike",
	["Restorative Totems"] = "Spell_Nature_ManaRegenTotem",
	["Resurrection"] = "Spell_Holy_Resurrection",
	["Retaliation"] = "Ability_Warrior_Challange",
	["Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Revenge"] = "Ability_Warrior_Revenge",
	["Revenge Stun"] = "Ability_Warrior_Revenge",
	["Reverberation"] = "Spell_Frost_FrostWard",
	["Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Righteous Defense"] = "INV_Shoulder_37",
	["Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Rip"] = "Ability_GhoulFrenzy",
	["Riposte"] = "Ability_Warrior_Challange",
	["Ritual of Doom"] = "Spell_Shadow_AntiMagicShell",
	["Ritual of Doom Effect"] = "Spell_Arcane_PortalDarnassus",
	["Ritual of Refreshment"] = "Spell_Arcane_MassDispel",
	["Ritual of Souls"] = "Spell_Shadow_Shadesofdarkness",
	["Ritual of Summoning"] = "Spell_Shadow_Twilight",
	["Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Rough Sharpening Stone"] = "INV_Stone_SharpeningStone_01",
	["Ruin"] = "Spell_Shadow_ShadowWordPain",
	["Rupture"] = "Ability_Rogue_Rupture",
	["Ruthlessness"] = "Ability_Druid_Disembowel",
	["Sacrifice"] = "Spell_Shadow_SacrificialShield",
	["Safe Fall"] = "INV_Feather_01",
	["Sanctified Crusader"] = "Spell_Holy_HolySmite",
	["Sanctified Judgement"] = "Spell_Holy_RighteousFury",
	["Sanctified Light"] = "Spell_Holy_HealingAura",
	["Sanctity Aura"] = "Spell_Holy_MindVision",
	["Sap"] = "Ability_Sap",
	["Savage Fury"] = "Ability_Druid_Ravage",
	["Savage Strikes"] = "Ability_Racial_BloodRage",
	["Scare Beast"] = "Ability_Druid_Cower",
	["Scatter Shot"] = "Ability_GolemStormBolt",
	["Scorch"] = "Spell_Fire_SoulBurn",
	["Scorpid Poison"] = "Ability_PoisonSting",
	["Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Screech"] = "Ability_Hunter_Pet_Bat",
	["Seal Fate"] = "Spell_Shadow_ChillTouch",
	["Seal of Blood"] = "Spell_Holy_SealOfBlood",
	["Seal of Command"] = "Ability_Warrior_InnerRage",
	["Seal of Justice"] = "Spell_Holy_SealOfWrath",
	["Seal of Light"] = "Spell_Holy_HealingAura",
	["Seal of Righteousness"] = "Ability_ThunderBolt",
	["Seal of Vengeance"] = "Spell_Holy_SealOfVengeance",
	["Seal of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Searing Light"] = "Spell_Holy_SearingLightPriest",
	["Searing Pain"] = "Spell_Fire_SoulBurn",
	["Searing Totem"] = "Spell_Fire_SearingTotem",
	["Second Wind"] = "Ability_Hunter_Harass",
	["Seduction"] = "Spell_Shadow_MindSteal",
	["Seed of Corruption"] = "Spell_Shadow_SeedOfDestruction",
	["Seethe"] = "Ability_Druid_ChallangingRoar",
	["Sense Demons"] = "Spell_Shadow_Metamorphosis",
	["Sense Undead"] = "Spell_Holy_SenseUndead",
	["Sentry Totem"] = "Spell_Nature_RemoveCurse",
	["Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Serrated Blades"] = "INV_Sword_17",
	["Setup"] = "Spell_Nature_MirrorImage",
	["Shackle Undead"] = "Spell_Nature_Slow",
	["Shadow Affinity"] = "Spell_Shadow_ShadowWard",
	["Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Shadow Embrace"] = "Spell_Shadow_ShadowEmbrace",
	["Shadow Focus"] = "Spell_Shadow_BurningSpirit",
	["Shadow Mastery"] = "Spell_Shadow_ShadeTrueSight",
	["Shadow Power"] = "Spell_Shadow_ShadowPower",
	["Shadow Protection"] = "Spell_Shadow_AntiShadow",
	["Shadow Reach"] = "Spell_Shadow_ChillTouch",
	["Shadow Resistance"] = "Spell_Shadow_AntiShadow",
	["Shadow Resistance Aura"] = "Spell_Shadow_SealOfKings",
	["Shadow Trance"] = "Spell_Shadow_Twilight",
	["Shadow Vulnerability"] = "Spell_Shadow_ShadowBolt",
	["Shadow Ward"] = "Spell_Shadow_AntiShadow",
	["Shadow Weakness"] = "INV_Misc_QirajiCrystal_05",
	["Shadow Weaving"] = "Spell_Shadow_BlackPlague",
	["Shadow Word: Death"] = "Spell_Shadow_DemonicFortitude",
	["Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Shadow and Flame"] = "Spell_Shadow_ShadowandFlame",
	["Shadow of Death"] ="Spell_Arcane_PrismaticCloak",
	["Shadowburn"] = "Spell_Shadow_ScourgeBuild",
	["Shadowfiend"] = "Spell_Shadow_Shadowfiend",
	["Shadowform"] = "Spell_Shadow_Shadowform",
	["Shadowfury"] = "Spell_Shadow_Shadowfury",
	["Shadowguard"] = "Spell_Nature_LightningShield",
	["Shadowmeld"] = "Ability_Ambush",
	["Shadowmeld Passive"] = "Ability_Ambush",
	["Shadowstep"] = "Ability_Rogue_Shadowstep",
	["Shamanistic Rage"] = "Spell_Nature_ShamanRage",
	["Sharpened Claws"] = "INV_Misc_MonsterClaw_04",
	["Shatter"] = "Spell_Frost_FrostShock",
	["Shear"] = "Spell_Shadow_FocusedPower",
	["Shell Shield"] = "Ability_Hunter_Pet_Turtle",
	["Shield"] = "INV_Shield_04",
	["Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Shield Bash - Silenced"] = "Ability_Warrior_ShieldBash",
	["Shield Block"] = "Ability_Defend",
	["Shield Slam"] = "INV_Shield_05",
	["Shield Specialization"] = "INV_Shield_06",
	["Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Shiv"] = "INV_ThrowingKnife_04",
	["Shoot"] = "Ability_ShootWand",
	["Shoot Bow"] = "Ability_Marksmanship",
	["Shoot Gun"] = "Ability_Marksmanship",
	["Shred"] = "Spell_Shadow_VampiricAura",
	["Shredding Attacks"] = "Spell_Shadow_VampiricAura",
	["Silence"] = "Spell_Shadow_ImpPhaseShift",
	["Silencing Shot"] = "Ability_TheBlackArrow",
	["Silent Resolve"] = "Spell_Nature_ManaRegenTotem",
	["Silverwing Flag"] = "INV_BannerPVP_02",
	["Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Siphon Life"] = "Spell_Shadow_Requiem",
	["Skinning"] = "INV_Misc_Pelt_Wolf_01",
	["Slam"] = "Ability_Warrior_DecisiveStrike",
	["Slayer's Crest"] = "INV_Trinket_Naxxramas03",
	["Sleep"] = "Spell_Nature_Sleep",
	["Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Slow"] = "Spell_Nature_Slow",
	["Slow Fall"] = "Spell_Magic_FeatherFall",
	["Smelting"] = "Spell_Fire_FlameBlades",
	["Smite"] = "Spell_Holy_HolySmite",
	["Snake Trap"] = "Ability_Hunter_SnakeTrap",
	["Solid Sharpening Stone"] = "INV_Stone_SharpeningStone_04",
	["Sonic Burst"] = "Spell_Shadow_Teleport",
	["Soothe Animal"] = "Ability_Hunter_BeastSoothe",
	["Soothing Kiss"] = "Spell_Shadow_SoothingKiss",
	["Soul Fire"] = "Spell_Fire_Fireball02",
	["Soul Leech"] = "Spell_Shadow_SoulLeech_3",
	["Soul Link"] = "Spell_Shadow_GatherShadows",
	["Soul Siphon"] = "Spell_Shadow_LifeDrain02",
	["Soulshatter"] = "Spell_Arcane_Arcane01",
	["Soulstone Resurrection"] = "INV_Misc_Orb_04",
	["Spell Haste"] = "Spell_Holy_SearingLight",
	["Spell Lock"] = "Spell_Shadow_MindRot",
	["Spell Power"] = "Spell_Arcane_ArcaneTorrent",
	["Spell Reflection"] = "Ability_Warrior_ShieldReflection",
	["Spell Vulnerability"] = "Spell_Holy_ElunesGrace",
	["Spell Warding"] = "Spell_Holy_SpellWarding",
	["Spellsteal"] = "Spell_Arcane_Arcane02",
	["Spirit Bond"] = "Ability_Druid_DemoralizingRoar",
	["Spirit Tap"] = "Spell_Shadow_Requiem",
	["Spirit of Redemption"] = "INV_Enchant_EssenceEternalLarge",
	["Spiritual Attunement"] = "Spell_Holy_ReviveChampion",
	["Spiritual Focus"] = "Spell_Arcane_Blink",
	["Spiritual Guidance"] = "Spell_Holy_SpiritualGuidence",
	["Spiritual Healing"] = "Spell_Nature_MoonGlow",
	["Spiteful Fury"] = "Ability_Warrior_Rampage",
	["Sprint"] = "Ability_Rogue_Sprint",
	["Stance Mastery"] = "Spell_Nature_EnchantArmor",
	["Starfire"] = "Spell_Arcane_StarFire",
	["Starfire Stun"] = "Spell_Arcane_StarFire",
	["Starlight Wrath"] = "Spell_Nature_AbolishMagic",
	["Starshards"] = "Spell_Arcane_StarFire",
	["Static Charge"] = "Spell_Nature_WispSplode",
	["Staves"] = "INV_Staff_08",
	["Steady Shot"] = "Ability_Hunter_SteadyShot",
	["Stealth"] = "Ability_Stealth",
	["Stoneclaw Stun"] = "Spell_Nature_StoneClawTotem",
	["Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Stoneform"] = "Spell_Shadow_UnholyStrength",
	["Stoneskin"] = "Spell_Nature_StoneSkinTotem",
	["Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Stormstrike"] = "Spell_Holy_SealOfMight",
	["Strength of Earth"] = "Spell_Nature_EarthBindTotem",
	["Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Strength of the Halaani"] = "INV_Trinket_Naxxramas01",
	["Stuck"] = "Spell_Shadow_Teleport",
	["Stun"] = "Spell_Frost_Stun",
	["Subtlety"] = "Ability_EyeOfTheOwl",
	["Suffering"] = "Spell_Shadow_BlackPlague",
	["Summon Charger"] = "Ability_Mount_Charger",
	["Summon Dreadsteed"] = "Ability_Mount_Dreadsteed",
	["Summon Felguard"] = "Spell_Shadow_SummonFelGuard",
	["Summon Felhunter"] = "Spell_Shadow_SummonFelHunter",
	["Summon Felsteed"] = "Spell_Nature_Swiftness",
	["Summon Imp"] = "Spell_Shadow_SummonImp",
	["Summon Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Summon Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Summon Warhorse"] = "Spell_Nature_Swiftness",
	["Summon Water Elemental"] = "Spell_Frost_SummonWaterElemental_2",
	["Sunder Armor"] = "Ability_Warrior_Sunder",
	["Suppression"] = "Spell_Shadow_UnsummonBuilding",
	["Surefooted"] = "Ability_Kick",
	["Surge of Light"] = "Spell_Holy_SurgeOfLight",
	["Surprise Attacks"] = "Ability_Rogue_SurpriseAttack",
	["Survivalist"] = "Spell_Shadow_Twilight",
	["Sweeping Strikes"] = "Ability_Rogue_SliceDice",
	["Swift Flight Form"] = "Ability_Druid_FlightForm",
	["Swiftmend"] = "INV_Relics_IdolofRejuvenation",
	["Swipe"] = "INV_Misc_MonsterClaw_03",
	["Sword Specialization"] = "INV_Sword_27",
	["Symbol of Hope"] = "Spell_Holy_SymbolOfHope",
	["Tactical Mastery"] = "Spell_Nature_EnchantArmor",
	["Tailoring"] = "Trade_Tailoring",
	["Tainted Blood"] = "Spell_Shadow_LifeDrain",
	["Tainted Mind"] = "Spell_Shadow_ShadowPact",
	["Tame Beast"] = "Ability_Hunter_BeastTaming",
	["Taunt"] = "Spell_Nature_Reincarnation",
	["Teleport: Darnassus"] = "Spell_Arcane_TeleportDarnassus",
	["Teleport: Exodar"] = "Spell_Arcane_TeleportExodar",
	["Teleport: Ironforge"] = "Spell_Arcane_TeleportIronForge",
	["Teleport: Moonglade"] = "Spell_Arcane_TeleportMoonglade",
	["Teleport: Orgrimmar"] = "Spell_Arcane_TeleportOrgrimmar",
	["Teleport: Shattrath"] = "Spell_Arcane_TeleportShattrath",
	["Teleport: Silvermoon"] = "Spell_Arcane_TeleportSilvermoon",
	["Teleport: Stormwind"] = "Spell_Arcane_TeleportStormWind",
	["Teleport: Thunder Bluff"] = "Spell_Arcane_TeleportThunderBluff",
	["Teleport: Undercity"] = "Spell_Arcane_TeleportUnderCity",
	["Temporal Rift"] = "Spell_Nature_TimeStop",
	["The Beast Within"] = "Ability_Hunter_BeastWithin",
	["The Human Spirit"] = "INV_Enchant_ShardBrilliantSmall",
	["Thick Hide"] = "INV_Misc_Pelt_Bear_03",
	["Thorns"] = "Spell_Nature_Thorns",
	["Thrill of the Hunt"] = "Ability_Hunter_ThrilloftheHunt",
	["Throw"] = "Ability_Throw",
	["Throwing Specialization"] = "INV_ThrowingAxe_03",
	["Thrown"] = "INV_ThrowingKnife_02",
	["Thunder Clap"] = "Spell_Nature_ThunderClap",
	["Thunderfury"] = "Spell_Nature_Cyclone",
	["Thundering Strikes"] = "Ability_ThunderBolt",
	["Thunderstomp"] = "Ability_Hunter_Pet_Gorilla",
	["Tidal Focus"] = "Spell_Frost_ManaRecharge",
	["Tidal Mastery"] = "Spell_Nature_Tranquility",
	["Tiger Riding"] = "Spell_Nature_Swiftness",
	["Tiger's Fury"] = "Ability_Mount_JungleTiger",
	["Time's Favor"] = "Ability_Rogue_FleetFooted",
	["Torment"] = "Spell_Shadow_GatherShadows",
	["Totem"] = "Spell_Nature_StoneClawTotem",
	["Totem of Wrath"] = "Spell_Fire_TotemOfWrath",
	["Totemic Call"] = "Spell_unused",
	["Totemic Focus"] = "Spell_Nature_MoonGlow",
	["Touch of Shadow"] = "Spell_Shadow_PsychicScream",
	["Touch of Weakness"] = "Spell_Shadow_DeadofNight",
	["Toughness"] = "Spell_Holy_Devotion",
	["Traces of Silithyst"] = "Spell_Nature_TimeStop",
	["Track Beasts"] = "Ability_Tracking",
	["Track Demons"] = "Spell_Shadow_SummonFelHunter",
	["Track Dragonkin"] = "INV_Misc_Head_Dragon_01",
	["Track Elementals"] = "Spell_Frost_SummonWaterElemental",
	["Track Giants"] = "Ability_Racial_Avatar",
	["Track Hidden"] = "Ability_Stealth",
	["Track Humanoids"] = "Spell_Holy_PrayerOfHealing",
	["Track Undead"] = "Spell_Shadow_DarkSummoning",
	["Tranquil Air"] = "Spell_Nature_Brilliance",
	["Tranquil Air Totem"] = "Spell_Nature_Brilliance",
	["Tranquil Spirit"] = "Spell_Holy_ElunesGrace",
	["Tranquility"] = "Spell_Nature_Tranquility",
	["Tranquilizing Shot"] = "Spell_Nature_Drowsy",
	["Trap Mastery"] = "Ability_Ensnare",
	["Travel Form"] = "Ability_Druid_TravelForm",
	["Tree of Life"] = "Ability_Druid_TreeofLife",
	["Tremor Totem"] = "Spell_Nature_TremorTotem",
	["Tribal Leatherworking"] = "Spell_Nature_NullWard",
	["Trueshot Aura"] = "Ability_TrueShot",
	["Turn Undead"] = "Spell_Holy_TurnUndead",
	["Twin Spire Blessing"] = "Spell_Nature_ElementalPrecision_1",
	["Two-Handed Axes"] = "INV_Axe_04",
	["Two-Handed Axes and Maces"] = "INV_Axe_10",
	["Two-Handed Maces"] = "INV_Mace_04",
	["Two-Handed Swords"] = "Ability_MeleeDamage",
	["Two-Handed Weapon Specialization"] = "INV_Axe_09",
	["Unarmed"] = "Ability_GolemThunderClap",
	["Unbreakable Will"] = "Spell_Magic_MageArmor",
	["Unbridled Wrath"] = "Spell_Nature_StoneClawTotem",
	["Undead Horsemanship"] = "Spell_Nature_Swiftness",
	["Underwater Breathing"] = "Spell_Shadow_DemonBreath",
	["Unending Breath"] = "Spell_Shadow_DemonBreath",
	["Unholy Power"] = "Spell_Shadow_ShadowWordDominate",
	["Unleashed Fury"] = "Ability_BullRush",
	["Unleashed Rage"] = "Spell_Nature_UnleashedRage",
	["Unstable Affliction"] = "Spell_Shadow_UnstableAffliction_3",
	["Unstable Power"] = "Spell_Lightning_LightningBolt01",
	["Unyielding Faith"] = "Spell_Holy_UnyieldingFaith",
	["Upset Tummy"] = "Ability_Hunter_Pet_Boar",
	["Vampiric Embrace"] = "Spell_Shadow_UnsummonBuilding",
	["Vampiric Touch"] = "Spell_Holy_Stoicism",
	["Vanish"] = "Ability_Vanish",
	["Vanished"] = "Ability_Vanish",
	["Vengeance"] = "Spell_Nature_Purge",
	["Venomous Totem"] = "Spell_Totem_WardOfDraining",
	["Victory Rush"] = "Ability_Warrior_Devastate",
	["Vigor"] = "Spell_Nature_EarthBindTotem",
	["Vile Beam"] = "Spell_Shadow_ShadowBolt",
	["Vile Poisons"] = "Ability_Rogue_FeignDeath",
	["Vindication"] = "Spell_Holy_Vindication",
	["Viper Sting"] = "Ability_Hunter_AimedShot",
	["Volley"] = "Ability_Marksmanship",
	["Wand Specialization"] = "INV_Wand_01",
	["Wands"] = "Ability_ShootWand",
	["War Stomp"] = "Ability_WarStomp",
	["Warp"] = "Spell_Arcane_Arcane04",
	["Warsong Flag"] = "INV_BannerPVP_01",
	["Water Breathing"] = "Spell_Shadow_DemonBreath",
	["Water Shield"] = "Ability_Shaman_WaterShield",
	["Water Tomb"] = "Spell_Frost_ManaRecharge",
	["Water Walking"] = "Spell_Frost_WindWalkOn",
	["Waterbolt"] = "Spell_Frost_FrostBolt",
	["Watery Grave"] = "Spell_Shadow_DemonBreath",
	["Weakened Soul"] = "Spell_Holy_AshesToAshes",
	["Weapon Mastery"] = "Ability_Warrior_WeaponMastery", -- Shaman and Warrior Talents with different icons
	["Weaponsmith"] = "INV_Sword_25",
--	["Well Fed"] = true,
	["Whirlwind"] = "Ability_Whirlwind",
	["Will of the Forsaken"] = "Spell_Shadow_RaiseDead",
	["Windfury"] = "Spell_Nature_Cyclone",
	["Windfury Attack"] = "Spell_Nature_Cyclone",
	["Windfury Totem"] = "Spell_Nature_Windfury",
	["Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Windwall"] = "Spell_Nature_EarthBind",
	["Windwall Totem"] = "Spell_Nature_EarthBind",
	["Wing Clip"] = "Ability_Rogue_Trip",
	["Winter's Chill"] = "Spell_Frost_ChillingBlast",
	["Wisp Spirit"] = "Spell_Nature_WispSplode",
	["Wolf Riding"] = "Spell_Nature_Swiftness",
	["Wound Poison"] = "INV_Misc_Herb_16",
	["Wound Poison II"] = "INV_Misc_Herb_16",
	["Wound Poison III"] = "INV_Misc_Herb_16",
	["Wound Poison IV"] = "INV_Misc_Herb_16",
	["Wound Poison V"] = "INV_Misc_Herb_16",
	["Wrath"] = "Spell_Nature_AbolishMagic",
	["Wrath of Air Totem"] = "Spell_Nature_SlowingTotem",
	["Wrath of Cenarius"] = "Ability_Druid_TwilightsWrath",
	["Wrath of the Astromancer"] = "Spell_Arcane_Arcane02",
	["Wyvern Sting"] = "INV_Spear_02",
}

BabbleSpell:Debug()
BabbleSpell:SetStrictness(true)

function BabbleSpell:GetSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	local icon = spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
	if not icon then
		return nil
	end
	return "Interface\\Icons\\" .. icon
end

function BabbleSpell:GetShortSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	return spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
end

AceLibrary:Register(BabbleSpell, MAJOR_VERSION, MINOR_VERSION)
BabbleSpell = nil
