ShardAce = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "Metrognome-2.0")

function ShardAce:OnInitialize()
	--self.Class = AceLibrary("Babble-Class-2.2")
	self.Spell = AceLibrary("Babble-Spell-2.2")
	self.Deformat = AceLibrary("Deformat-2.0")
	self.Locale = AceLibrary("AceLocale-2.2"):new("ShardAce")
	self.Local = {
		HealthstoneID = {
			[5512] = 1,
			[19004] = 1,
			[19005] = 1,
			[5511] = 1,
			[19006] = 1,
			[19007] = 1,
			[5509] = 1,
			[19008] = 1,
			[19009] = 1,
			[5510] = 1,
			[19010] = 1,
			[19011] = 1,
			[9421] = 1,
			[19012] = 1,
			[19013] = 1,
			[22103] = 1, --Master Healthstones
			[22104] = 1,
			[22105] = 1,
		},		
		SoulstoneID = {
			[5232] = 1,
			[16892] = 1,
			[16893] = 1,
			[16895] = 1,
			[16896] = 1,
			[22116] = 1, --Master Soulstone
		},
		SpellstoneID = {
			[5522] = 1,
			[13602] = 1,
			[13603] = 1,
			[22646] = 1, --Master Spellstone
		},
		FirestoneID = {
			[1254] = 1,
			[13699] = 1,
			[13700] = 1,
			[13701] = 1,
			[22128] = 1, --Master Firestone
		},
		SoulshardID = 6265,
		InfernalStoneID = 5565,
		DemonicFigurineID = 16583,
	}
	self:RegisterDB("ShardAceDB")
	self.Locals = ShardAceLocals
	self.Flags = {}
	self.Timers = {}
	self:RegisterDefaults('profile', {
		shardBag = 0,
		SummonMsg1 = self.Locals.SummonMsg1,
		SummonMsg2 = self.Locals.SummonMsg2,
		SoulstoneMsg = self.Locals.SoulMsg,
		SoulwellMsg = self.Locals.SoulwellMsg,
		ShowMsgSum1 = true,
		ShowMsgSum2 = nil,
		ShowMsgSS = true,
		ShowMsgSoulwell = true,
		Threshold = 5,
		AutoSort = true,
		ReverseSort = nil,
		playSound = true,
		hsTrade = true,
		Relic = true,
		ButtonPosition = "farleft",
		ButtonFormation = "leftcurve",
		SummonerPosition = "left",
		SummonMsg1Chan = "default",
		SummonMsg2Chan = "default",
		SoulstoneMsgChan = "default",
		SoulwellChan = "default",
		maxShard = -1,
		scale = 1,
		HSAlert = nil,
		Binding = nil,
	})
	self:RegisterChatCommand(self.Locals.Commands, self.Locals.Options)
	SABindFrame = CreateFrame("Frame", nil, UIParent)
	SABindFrame:SetFrameStrata("DIALOG")
	SABindFrame:SetScript("OnKeyDown", function() ShardAce:KeyPressed(arg1) end)
	SABindFrame:EnableKeyboard(true)
	SABindFrame:Hide()
end

function ShardAce:OnEnable()
	self:RegisterEvent("BAG_UPDATE")
	self:RegisterMetro("ShardAceBagUpdate", ShardAce.ScanInv, 0.5, ShardAce)
	self:RegisterMetro("ShardAceTimer", ShardAce.Timer, 1, ShardAce)
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	_, self.Class = UnitClass("player")
	if(self.Class == "WARLOCK")then
		self:RegisterEvent("LEARNED_SPELL_IN_TAB", "ScanBook")
		self:RegisterEvent("SPELLS_CHANGED", "ScanBook")
		self:ScanBook()
		self:RegisterEvent("UNIT_SPELLCAST_SENT")
		self:RegisterEvent("UNIT_SPELLCAST_START")
		self:RegisterEvent("UNIT_SPELLCAST_STOP")
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
		self:RegisterEvent("UNIT_SPELLCAST_FAILED")
		self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
		self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
		
		self.Timers.SoulTimer = self.db.profile.SoulTime
		if self.Timers.SoulTimer then
			if self.Timers.SoulTimer < time() then
				self.Timers.SoulTimer = nil
				self.db.profile.SoulTime = nil
			end
		end
		self.Timers.FelDomTimer = self.db.profile.FelDomTimer
		if self.Timers.FelDomTimer then
			if self.Timers.FelDomTimer < time() then
				self.Timers.FelDomTimer = nil
				self.db.profile.FelDomTimer = nil
			end
		end
		ShardAceCount:SetFrameStrata("MEDIUM")
		ShardAceSoul:SetFrameStrata("MEDIUM")
		ShardAceFire:SetFrameStrata("MEDIUM")
		ShardAceSpell:SetFrameStrata("MEDIUM")
	end
	ShardAceHealth:SetFrameStrata("MEDIUM")
	self:ScanInv()
	self:RegisterEvent("BANKFRAME_OPENED")
	self:RegisterEvent("BANKFRAME_CLOSED")
	if self.Timers.FelDomTimer then
		local _,_,running,_,_ = self:MetroStatus("ShardAceTimer")
		if not running then
			self:StartMetro("ShardAceTimer")
		end
		self:Timer()
	end
	if self.Timers.SoulTimer then
		local _,_,running,_,_ = self:MetroStatus("ShardAceTimer")
		if not running then
			self:StartMetro("ShardAceTimer")
		end
		self:Timer()
	end
	if self.db.profile.Relic then
		self:DoButtons()
	else
		ShardAceSpell:Hide()
		ShardAceFire:Hide()
	end
	self:MoveButtons()
	self:setScale(self:getScale())
end

function ShardAce:OnDisable()
	ShardAceCount:Hide()
	ShardAceSoul:Hide()
	ShardAceFire:Hide()
	ShardAceSpell:Hide()
	ShardAceHealth:Hide()
	
	self:UnregisterMetro("ShardAceBagUpdate")
	self:UnregisterMetro("ShardAceTimer")
end

function ShardAce:PostClick(frame, button)
	if self:getBindingState() then
		if IsShiftKeyDown() and frame:GetName() == "ShardAceHealth" and button == "RightButton" then
			button = "MiddleButton"
		end
		self.bindframe = frame:GetName()
		self.bindbutton = button
		SABindFrame:Show()
		self:Print("Setting Keybinding for: %s, %s", self.bindframe, self.bindbutton)
	end
end

function ShardAce:KeyPressed(key)
	if key == "ESCAPE" then
		SABindFrame:Hide()
		self:Print("Binding aborted")
		return
	end
	if key == "CTRL" or key == "SHIFT" or key == "ALT" then
		return
	end
	if IsControlKeyDown() then
		key = "CTRL-"..key
	elseif IsShiftKeyDown() then
		key = "SHIFT-"..key
	elseif IsAltKeyDown() then
		key = "ALT-"..key
	end
	SetBindingClick(key, self.bindframe, self.bindbutton)
	self:Print("Key: %s, has been bound to: %s, %s", key, self.bindframe, self.bindbutton)
	self.bindframe = nil
	self.bindbutton = nil
	SABindFrame:Hide()
	SaveBindings(GetCurrentBindingSet())
end

function ShardAce:HSTrade()
	if ShardAce.Items.Healthstone then
	-- Sari added: copied ShardTrackerNCS code to initiate healthstone trade with added TradeDistanceCheck (and TimexTimer)
		if UnitExists("NPC") then
			if UnitIsPlayer("NPC") and UnitIsFriend("player","NPC") then
				PickupContainerItem(ShardAce.Items.Healthstone[1],ShardAce.Items.Healthstone[2])
				if CursorHasItem() then
					ClickTradeButton(1)
				end
			end
		elseif UnitExists("target") then
			if UnitIsPlayer("target") and UnitIsFriend("player","target") then
				if not UnitCanCooperate("player", "target") then
					-- add message "can't cooperate"
					DEFAULT_CHAT_FRAME:AddMessage(UnitName("target")..' cannot cooperate.', 1.0, 1.0, 0.5);
				elseif not CheckInteractDistance("target",2) then
					-- add message "unit too far away"
					DEFAULT_CHAT_FRAME:AddMessage(UnitName("target")..' is too far away.', 1.0, 1.0, 0.5);
				else
					-- pickup the healthstone and drop it on the target
					PickupContainerItem(ShardAce.Items.Healthstone[1],ShardAce.Items.Healthstone[2])
					if CursorHasItem() then
						DropItemOnUnit("target")
					end
				end
			end
		end
	end
end

function ShardAce:COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellId, spellName, spellSchool, auraType)

if event == "SPELL_AURA_APPLIED" and destName == UnitName("Player") then
--self:Print(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellId, spellName, spellSchool, auraType)
	--local spell = self.Deformat(str, AURAADDEDSELFHELPFUL)
	if spellName == self.Spell["Shadow Trance"] or spellName == self.Spell["Backlash"] then
		if self:getSoundState() then
			PlaySoundFile("Interface\\AddOns\\ShardAce\\Sounds\\ShadowTrance.mp3")
		end
	end
	end
end

function ShardAce:UNIT_SPELLCAST_SENT(unit, spell, rank, target)
	--self:Print("spell sent")
	if unit == "player" then
		if self.Flags.SSTarget then
			self.Flags.SSTarget = nil
		end
		if self.Flags.HSUsed then
			self.Flags.HSUsed = nil
		end
		if self.Flags.SSTarget then
			self.Flags.SSTarget = nil
		end
		if self.Flags.PortTarget then
			self.Flags.PortTarget = nil
		end
		if self.Flags.Soulwell then
			self.Flags.Soulwell = nil
		end
		if spell == self.Spell["Soulstone Resurrection"] then
			self.Flags.SSTarget = target
		elseif spell == ShardAceHealth:GetAttribute("item1") then
			self.Flags.HSUsed = true
		elseif spell == self.Spell["Ritual of Summoning"] then
			self.Flags.PortTarget = UnitName("target")
		elseif spell == self.Spell["Ritual of Souls"] then
			self.Flags.Soulwell = true
		end
	end
end

function ShardAce:UNIT_SPELLCAST_START(unit)
	--self:Print("spell start")
	if unit == "player" then
		if self.Flags.PortTarget then
			if self:getPreSummonMessageState() then
				ShardAce:SendMsg(format(self:FixMsgString(self:getPreSummonMessage()), self.Flags.PortTarget), self:getPreSummonMessageChannel())
			end
		end
	end
end

function ShardAce:UNIT_SPELLCAST_CHANNEL_START(unit)
	--self:Print("spell channel start")
	if unit == "player" then
		if self.Flags.PortTarget then
			if self:getSummonMessageState() then
				ShardAce:SendMsg(format(self:FixMsgString(self:getSummonMessage()), self.Flags.PortTarget), self:getSummonMessageChannel())
			end
			self.Flags.PortTarget = nil
		elseif self.Flags.Soulwell then
			if self:getSoulwellMessageState() then
				ShardAce:SendMsg(self:getSoulwellMessage(), self:getSoulwellChannel())
			end
			self.Flags.Soulwell = nil
		end
	end
end

function ShardAce:UNIT_SPELLCAST_STOP(unit)
	--self:Print("spell stop")
	if unit == "player" then
		if self.Flags.SSTarget then
			self.Flags.SSTarget = nil
		end
	end
end

function ShardAce:UNIT_SPELLCAST_SUCCEEDED(unit, spell, rank)
	--self:Print("spell success")
	if unit == "player" then
		if spell == self.Spell["Soulstone Resurrection"] then
			if self:getSoulstoneMessageState() then
				ShardAce:SendMsg(format(self:FixMsgString(self:getSoulstoneMessage()), self.Flags.SSTarget or "someone"), self:getSoulstoneMessageChannel())
			end
			self.Timers.SoulTimer = time() + 1800
			self.db.profile.SoulTime = self.Timers.SoulTimer
			self.Flags.SSTarget = nil
			local _,_,running,_,_ = self:MetroStatus("ShardAceTimer")
			if not running then
				self:StartMetro("ShardAceTimer")
			end
			self:Timer()
		elseif spell == ShardAceHealth:GetAttribute("item1") then
			self.Flags.HSUsed = nil
			self.Timers.HSTimer = time() + 120
			local _,_,running,_,_ = self:MetroStatus("ShardAceTimer")
			if not running then
				self:StartMetro("ShardAceTimer")
			end
			self:Timer()
		elseif spell == self.Spell["Fel Domination"] then
			self.Timers.FelDomTimer = time() + 900
			self.db.profile.FelDomTimer = self.Timers.FelDomTimer
			local _,_,running,_,_ = self:MetroStatus("ShardAceTimer")
			if not running then
				self:StartMetro("ShardAceTimer")
			end
			self:Timer()
		elseif spell == self.Spell["Shadow Ward"] then
			self.Timers.ShadowWardTimer = time() + 30
			local _,_,running,_,_ = self:MetroStatus("ShardAceTimer")
			if not running then
				self:StartMetro("ShardAceTimer")
			end
			self:Timer()
		end
	end
end

function ShardAce:UNIT_SPELLCAST_FAILED(unit)
	--self:Print("spell fail")
	if unit == "player" then
		if self.Flags.SSTarget then
			self.Flags.SSTarget = nil
		end
		if self.Flags.HSUsed then
			self.Flags.HSUsed = nil
		end
		if self.Flags.SSTarget then
			self.Flags.SSTarget = nil
		end
		if self.Flags.PortTarget then
			self.Flags.PortTarget = nil
		end
		if self.Flags.Soulwell then
			self.Flags.Soulwell = nil
		end
	end
end

function ShardAce:Timer()
	if self.Timers.SoulTimer then
		local timeleft = self.Timers.SoulTimer - time()
		if(timeleft > 60)then
			ShardAceSoul_Text:SetText((floor(timeleft / 60)) +1)
		else
			ShardAceSoul_Text:SetText(timeleft)
		end
		ShardAceSoul_Text:Show()
		
		if(timeleft < 1)then
			self.Timers.SoulTimer = nil
			ShardAceSoul_Text:Hide()
			if self:getSoundState() then
				PlaySoundFile("Interface\\AddOns\\ShardAce\\Sounds\\Soulstone.mp3")
			end
			self.db.profile.SoulTime = nil
			DEFAULT_CHAT_FRAME:AddMessage("|cffffff00** Soulstone Cooldown over, ready to use **|r")
			UIErrorsFrame:AddMessage("** Soulstone Cooldown over, ready to use **", 0.92, 0.75, 0.05, 1.0, 12)
		end
	end
	if self.Timers.HSTimer then
		local timeleft = self.Timers.HSTimer - time()
		if(timeleft > 60)then
			ShardAceHealth_Text:SetText((floor(timeleft / 60)) +1)
		else
			ShardAceHealth_Text:SetText(timeleft)
		end
		ShardAceHealth_Text:Show()
		
		if(timeleft < 1)then
			self.Timers.HSTimer = nil
			ShardAceHealth_Text:Hide()
		end
	end
	if self.Timers.FelDomTimer then
		local timeleft = self.Timers.FelDomTimer - time()
		if timeleft >= 1 then
			SAFelDomBack:SetDesaturated(true)
		else
			SAFelDomBack:SetDesaturated(false)
			self.Timers.FelDomTimer = nil
		end
	end
	if self.Timers.ShadowWardTimer then
		local timeleft = self.Timers.ShadowWardTimer - time()
		if timeleft >= 1 then
			SAShadowwardBack:SetDesaturated(true)
		else
			SAShadowwardBack:SetDesaturated(false)
			self.Timers.ShadowWardTimer = nil
		end
	end
		
		
	if not self.Timers.SoulTimer and not self.Timers.HSTimer and not self.Timers.FelDomTimer and not self.Timers.ShadowWardTimer then
		self:StopMetro("ShardAceTimer")
	end
end

function ShardAce:PLAYER_REGEN_ENABLED()
	if self.needUpdate then
		self:DoButtons()
		self:MakeButtons()
		self:UpdateButtons()
		self.needUpdate = nil
	end
end

function ShardAce:DoButtonsAppear()
	if(self.Class == "WARLOCK")then
		ShardAceCount_Text:SetText(self.Items.ShardCount)
		if self.Items.ShardCount <= self:getThreshold() then
			ShardAceCount_Text:SetTextColor(1, 0, 0)
		else
			ShardAceCount_Text:SetTextColor(0, 1, 0)
		end
		
		if self.Spells.Soulstone then
			ShardAceSoulBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSoulstone")
			if self.Items.Soulstone then
				ShardAceSoulBack:SetDesaturated(false)
			else
				ShardAceSoulBack:SetDesaturated(true)
			end
		end
		
		if self:getRelicState() then
			if self.Spells.Spellstone then
				ShardAceSpellBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSpellstone")
				if self.Items.Spellstone then
					ShardAceSpellBack:SetDesaturated(false)
					if self.Items.Spellstone == "equip" then
						ShardAceSpellGlow:Show()
					else
						ShardAceSpellGlow:Hide()
					end
				else
					ShardAceSpellGlow:Hide()
					ShardAceSpellBack:SetDesaturated(true)
				end
			end
			
			if self.Spells.Firestone then
				ShardAceFireBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saFirestone")
				if self.Items.Firestone then
					ShardAceFireBack:SetDesaturated(false)
					if self.Items.Firestone == "equip" then
						ShardAceFireGlow:Show()
					else
						ShardAceFireGlow:Hide()
					end
				else
					ShardAceFireGlow:Hide()
					ShardAceFireBack:SetDesaturated(true)
				end
			end
		end
	end
	
	if self.Spells.Healthstone or self.Items.Healthstone then
		ShardAceHealthBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saHealthstone")
		if self.Items.Healthstone then
			ShardAceHealthBack:SetDesaturated(false)
		else
			ShardAceHealthBack:SetDesaturated(true)
		end
	end
end

function ShardAce:DoButtons()
	if not self.Items or not self.Spells then
		return
	end
	local locked = InCombatLockdown()
	if locked then
		self:DoButtonsAppear()
		self.needUpdate = true
		return
	end
	if(self.Class == "WARLOCK")then
		ShardAceCount_Text:SetText(self.Items.ShardCount)
		if self.Items.ShardCount <= self:getThreshold() then
			ShardAceCount_Text:SetTextColor(1, 0, 0)
		else
			ShardAceCount_Text:SetTextColor(0, 1, 0)
		end
		ShardAceCount:SetAttribute("type1", "macro")
		ShardAceCount:SetAttribute("macro1", ATTRIBUTE_NOOP)
		ShardAceCount:SetAttribute("macrotext1", "/script ShardAce:SortShards(ShardAce:getShardBag(), ShardAce:getReverseSortState())")
		ShardAceCount:Show()
		
		if self.Spells.Soulstone then
			ShardAceSoulBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSoulstone")
			if self.Items.Soulstone then
				local iLink, name 
				iLink = GetContainerItemLink(self.Items.Soulstone[1], self.Items.Soulstone[2])
				if iLink then
					name = (GetItemInfo(iLink))
					ShardAceSoul:SetAttribute("type1", "item")
					ShardAceSoul:SetAttribute("item1", name)
				end
				ShardAceSoulBack:SetDesaturated(false)
			else
				ShardAceSoulBack:SetDesaturated(true)
			end
			ShardAceSoul:Show()
		end
		
		if self:getRelicState() then
			if self.Spells.Spellstone then
				ShardAceSpellBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSpellstone")
				if self.Items.Spellstone then
					local iLink, name
					ShardAceSpell:SetAttribute("type1", "item")
					ShardAceSpellBack:SetDesaturated(false)
					if self.Items.Spellstone == "equip" then
						iLink = GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot"))
						if iLink then
							name = (GetItemInfo(iLink))
							ShardAceSpell:SetAttribute("item1", name)
							ShardAceSpell:SetAttribute("slot1", (GetInventorySlotInfo("RangedSlot")))
							ShardAceSpell:SetAttribute("bag1", "")
						end
					else
						iLink = GetContainerItemLink(self.Items.Spellstone[1], self.Items.Spellstone[2])
						if iLink then
							name = (GetItemInfo(iLink))
							ShardAceSpell:SetAttribute("item1", name)
							ShardAceSpell:SetAttribute("slot1", self.Items.Spellstone[2])
							ShardAceSpell:SetAttribute("bag1", self.Items.Spellstone[1])
						end
					end
					if self.Items.Spellstone == "equip" then
						ShardAceSpellGlow:Show()
					else
						ShardAceSpellGlow:Hide()
					end
				else
					ShardAceSpellGlow:Hide()
					ShardAceSpellBack:SetDesaturated(true)
				end
				ShardAceSpell:Show()
			end
			
			if self.Spells.Firestone then
				ShardAceFireBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saFirestone")
				if self.Items.Firestone then
					ShardAceFire:SetAttribute("type1", "item")
					ShardAceFireBack:SetDesaturated(false)
					local name
					if self.Items.Firestone == "equip" then
						iLink = GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot"))
						if iLink then
							name = (GetItemInfo(iLink))
							ShardAceFire:SetAttribute("item1", name)
							ShardAceFire:SetAttribute("slot1", (GetInventorySlotInfo("RangedSlot")))
							ShardAceFire:SetAttribute("bag1", "")
						end
					else
						iLink = GetContainerItemLink(self.Items.Firestone[1], self.Items.Firestone[2])
						if iLink then
							name = (GetItemInfo(iLink))
							ShardAceFire:SetAttribute("item1", name)
							ShardAceFire:SetAttribute("slot1", self.Items.Firestone[2])
							ShardAceFire:SetAttribute("bag1", self.Items.Firestone[1])
						end
					end
					
					if self.Items.Firestone == "equip" then
						ShardAceFireGlow:Show()
					else
						ShardAceFireGlow:Hide()
					end
				else
					ShardAceFireGlow:Hide()
					ShardAceFireBack:SetDesaturated(true)
				end
				ShardAceFire:Show()
			end
		end
	end
	
	if self.Spells.Healthstone or self.Items.Healthstone then
		ShardAceHealthBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saHealthstone")
		ShardAceHealth:SetAttribute("type3", "macro")
		ShardAceHealth:SetAttribute("macrotext3", "/script ShardAce:HSTrade()")
		ShardAceHealth:SetAttribute("shift-type2", "macro")
		ShardAceHealth:SetAttribute("shift-macrotext2", "/script ShardAce:HSTrade()")
		if self.Items.Healthstone then
			local iLink, name 
			iLink = GetContainerItemLink(self.Items.Healthstone[1], self.Items.Healthstone[2])
			if iLink then
				name = (GetItemInfo(iLink))
				ShardAceHealth:SetAttribute("type1", "item")
				ShardAceHealth:SetAttribute("item1", name)
			end
			ShardAceHealthBack:SetDesaturated(false)
		else
			ShardAceHealthBack:SetDesaturated(true)
		end
		ShardAceHealth:Show()
	end
end

function ShardAce:MakeButtons()
	local locked = InCombatLockdown()
	if locked then
		self.needUpdate = true
		return
	end
	local btn
	if not self.Buttons then
		self.Buttons = {}
	end
	if not self.Buttons.Header then
		self.Buttons.Header = CreateFrame("Frame", "SAHeader", MinimapCluster, "SecureStateHeaderTemplate")
		ShardAceCount:SetAttribute("newstate2", "0,1")
		ShardAceCount:SetAttribute("state", "0")
		self.Buttons.Header:SetAttribute("addchild", ShardAceCount)
	end
--[[	if not self.Buttons.Reset then
		btn = CreateFrame("Button", "SAReset", nil, "ShardAceButtonTemplate")
		btn:SetPoint("CENTER", ShardAceCount, "CENTER", 0, 24)
		btn:SetAttribute("newstate", "0")
		btn:SetAttribute("showstates", "1")
		btn:SetAttribute("state", "0")
		self.Buttons.Header:SetAttribute("addchild", btn)
		self.Buttons.Reset = btn
	end]]
	if not self.Buttons.FelDomination then
		if self.Spells.FelDomination then
			btn = CreateFrame("Button", "SAFelDom", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -26, 26)
			--btn:SetAttribute("newstate", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAFelDomBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saFelDomination")
			self.Buttons.FelDomination = btn
		end
	end
	if not self.Buttons.Imp then
		if self.Spells.Imp then
			btn = CreateFrame("Button", "SAImp", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -52, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAImpBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saImp")
			self.Buttons.Imp = btn
		end
	end
	if not self.Buttons.Voidwalker then
		if self.Spells.Voidwalker then
			btn = CreateFrame("Button", "SAVoid", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -78, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAVoidBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saVoidwalker")
			self.Buttons.Voidwalker = btn
		end
	end
	if not self.Buttons.Succubus then
		if self.Spells.Succubus then
			btn = CreateFrame("Button", "SASucc", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SASuccBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSuccubus")
			self.Buttons.Succubus = btn
		end
	end
	if not self.Buttons.Felhunter then
		if self.Spells.Felhunter then
			btn = CreateFrame("Button", "SAFelh", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -130, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAFelhBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saFelhunter")
			self.Buttons.Felhunter = btn
		end
	end
	if not self.Buttons.Infernal then
		if self.Spells.Infernal then
			btn = CreateFrame("Button", "SAInf", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -156, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAInfBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saInfernal")
			self.Buttons.Infernal = btn
		end
	end
	if not self.Buttons.Doomguard then
		if self.Spells.Doomguard then
			btn = CreateFrame("Button", "SADoom", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -182, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SADoomBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saDoomguard")
			self.Buttons.Doomguard = btn
		end
	end
	if not self.Buttons.Felguard then
		if self.Spells.Felguard then
			btn = CreateFrame("Button", "SAGuard", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -182, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAGuardBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saFelguard")
			self.Buttons.Felguard = btn
		end
	end
	--Felguard goes here -208
	if not self.Buttons.Enslave then
		if self.Spells.Enslave then
			btn = CreateFrame("Button", "SAEnsl", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -234, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAEnslBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saEnslave")
			self.Buttons.Enslave = btn
		end
	end
	if not self.Buttons.Sacrifice then
		if self.Spells.Sacrifice then
			btn = CreateFrame("Button", "SASac", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -260, 26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SASacBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSacrifice")
			self.Buttons.Sacrifice = btn
		end
	end
	
	
	if not self.Buttons.DetectInvis then
		if self.Spells.DetectInvis then
			btn = CreateFrame("Button", "SAInvis", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -26, 0)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAInvisBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saDetectInvis")
			self.Buttons.DetectInvis = btn
		end
	end
	if not self.Buttons.Breath then
		if self.Spells.Breath then
			btn = CreateFrame("Button", "SABreath", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -52, 0)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SABreathBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saUnendingBreath")
			self.Buttons.Breath = btn
		end
	end
	if not self.Buttons.Tracking then
		if self.Spells.Tracking then
			btn = CreateFrame("Button", "SATrack", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -78, 0)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SATrackBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSenseDemons")
			self.Buttons.Tracking = btn
		end
	end
	if not self.Buttons.DemonBuff then
		if self.Spells.DemonSkin or self.Spells.DemonArmor then
			btn = CreateFrame("Button", "SADBuff", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, 0)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SADBuffBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saDemonArmor")
			self.Buttons.DemonBuff = btn
		end
	end
	
	
	if not self.Buttons.Mount then
		if self.Spells.Mount then
			btn = CreateFrame("Button", "SAMount", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -26, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAMountBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saMount")
			self.Buttons.Mount = btn
		end
	end
	if not self.Buttons.Port then
		if self.Spells.Port then
			btn = CreateFrame("Button", "SAPort", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -52, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAPortBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSummon")
			self.Buttons.Port = btn
		end
	end
	if not self.Buttons.Eye then
		if self.Spells.Eye then
			btn = CreateFrame("Button", "SAEye", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -78, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAEyeBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saEyeKilrogg")
			self.Buttons.Eye = btn
		end
	end
	if not self.Buttons.Banish then
		if self.Spells.Banish then
			btn = CreateFrame("Button", "SABanish", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SABanishBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saBanish")
			self.Buttons.Banish = btn
		end
	end
	
	if not self.Buttons.Soullink then
		if self.Spells.Soullink then
			btn = CreateFrame("Button", "SASoullink", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SASoullinkBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSoulLink")
			self.Buttons.Soullink = btn
		end
	end
	if not self.Buttons.Soulwell then
		if self.Spells.Soulwell then
			btn = CreateFrame("Button", "SASoulwell", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SASoulwellBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saSoulWell")
			self.Buttons.Soulwell = btn
		end
	end
	if not self.Buttons.Felarmor then
		if self.Spells.Felarmor then
			btn = CreateFrame("Button", "SAFelarmor", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAFelarmorBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saFelArmor")
			self.Buttons.Felarmor = btn
		end
	end
	if not self.Buttons.Shadowward then
		if self.Spells.Shadowward then
			btn = CreateFrame("Button", "SAShadowward", nil, "ShardAceButtonTemplate")
			--btn:SetPoint("CENTER", ShardAceCount, "CENTER", -104, -26)
			btn:SetAttribute("newstate1", "0")
			btn:SetAttribute("showstates", "1")
			btn:SetAttribute("state", "0")
			self.Buttons.Header:SetAttribute("addchild", btn)
			SAShadowwardBack:SetTexture("Interface\\AddOns\\ShardAce\\Images\\saShadowWard")
			self.Buttons.Shadowward = btn
		end
	end
	self:setScale(self:getScale())
	self:MoveSummons()
end

function ShardAce:UpdateButtons()
	local locked = InCombatLockdown()
	if locked then
		self.needUpdate = true
		return
	end
	if self.Buttons.FelDomination and self.Spells.FelDomination then
		self.Buttons.FelDomination:SetAttribute("type", "spell")
		self.Buttons.FelDomination:SetAttribute("spell", (GetSpellName(self.Spells.FelDomination, BOOKTYPE_SPELL)))
		self.Buttons.FelDomination:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Enslave and self.Spells.Enslave then
		self.Buttons.Enslave:SetAttribute("type", "spell")
		self.Buttons.Enslave:SetAttribute("spell", (GetSpellName(self.Spells.Enslave, BOOKTYPE_SPELL)))
		self.Buttons.Enslave:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Sacrifice and self.Spells.Sacrifice then
		self.Buttons.Sacrifice:SetAttribute("type", "spell")
		self.Buttons.Sacrifice:SetAttribute("spell", (GetSpellName(self.Spells.Sacrifice, BOOKTYPE_SPELL)))
		self.Buttons.Sacrifice:SetAttribute("ctrl-type*", "")
	end
	
	
	if self.Buttons.Imp and self.Spells.Imp then
		self.Buttons.Imp:SetAttribute("type", "spell")
		self.Buttons.Imp:SetAttribute("spell", (GetSpellName(self.Spells.Imp, BOOKTYPE_SPELL)))
		self.Buttons.Imp:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Voidwalker and self.Spells.Voidwalker then
		self.Buttons.Voidwalker:SetAttribute("type", "spell")
		self.Buttons.Voidwalker:SetAttribute("spell", (GetSpellName(self.Spells.Voidwalker, BOOKTYPE_SPELL)))
		self.Buttons.Voidwalker:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Succubus and self.Spells.Succubus then
		self.Buttons.Succubus:SetAttribute("type", "spell")
		self.Buttons.Succubus:SetAttribute("spell", (GetSpellName(self.Spells.Succubus, BOOKTYPE_SPELL)))
		self.Buttons.Succubus:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Felhunter and self.Spells.Felhunter then
		self.Buttons.Felhunter:SetAttribute("type", "spell")
		self.Buttons.Felhunter:SetAttribute("spell", (GetSpellName(self.Spells.Felhunter, BOOKTYPE_SPELL)))
		self.Buttons.Felhunter:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Infernal and self.Spells.Infernal then
		self.Buttons.Infernal:SetAttribute("type", "spell")
		self.Buttons.Infernal:SetAttribute("spell", (GetSpellName(self.Spells.Infernal, BOOKTYPE_SPELL)))
		self.Buttons.Infernal:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Doomguard and self.Spells.Doomguard then
		self.Buttons.Doomguard:SetAttribute("type", "spell")
		self.Buttons.Doomguard:SetAttribute("spell", (GetSpellName(self.Spells.Doomguard, BOOKTYPE_SPELL)))
		self.Buttons.Doomguard:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Felguard and self.Spells.Felguard then
		self.Buttons.Felguard:SetAttribute("type", "spell")
		self.Buttons.Felguard:SetAttribute("spell", (GetSpellName(self.Spells.Felguard, BOOKTYPE_SPELL)))
		self.Buttons.Felguard:SetAttribute("ctrl-type*", "")
	end
	
	
	if self.Buttons.DetectInvis and self.Spells.DetectInvis then
		self.Buttons.DetectInvis:SetAttribute("type", "spell")
		self.Buttons.DetectInvis:SetAttribute("spell", (GetSpellName(self.Spells.DetectInvis, BOOKTYPE_SPELL)))
		self.Buttons.DetectInvis:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Breath and self.Spells.Breath then
		self.Buttons.Breath:SetAttribute("type", "spell")
		self.Buttons.Breath:SetAttribute("spell", (GetSpellName(self.Spells.Breath, BOOKTYPE_SPELL)))
		self.Buttons.Breath:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Tracking and self.Spells.Tracking then
		self.Buttons.Tracking:SetAttribute("type", "spell")
		self.Buttons.Tracking:SetAttribute("spell", (GetSpellName(self.Spells.Tracking, BOOKTYPE_SPELL)))
		self.Buttons.Tracking:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.DemonBuff and (self.Spells.DemonSkin or self.Spells.DemonArmor) then
		self.Buttons.DemonBuff:SetAttribute("type", "spell")
		if self.Spells.DemonArmor then
			self.Buttons.DemonBuff:SetAttribute("spell", (GetSpellName(self.Spells.DemonArmor, BOOKTYPE_SPELL)))
		else
			self.Buttons.DemonBuff:SetAttribute("spell", (GetSpellName(self.Spells.DemonSkin, BOOKTYPE_SPELL)))
		end
		self.Buttons.DemonBuff:SetAttribute("ctrl-type*", "")
	end
	
	
	if self.Buttons.Mount and self.Spells.Mount then
		self.Buttons.Mount:SetAttribute("type", "spell")
		self.Buttons.Mount:SetAttribute("spell", (GetSpellName(self.Spells.Mount[table.getn(self.Spells.Mount)], BOOKTYPE_SPELL)))
		self.Buttons.Mount:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Port and self.Spells.Port then
		self.Buttons.Port:SetAttribute("type", "spell")
		self.Buttons.Port:SetAttribute("spell", (GetSpellName(self.Spells.Port, BOOKTYPE_SPELL)))
		self.Buttons.Port:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Eye and self.Spells.Eye then
		self.Buttons.Eye:SetAttribute("type", "spell")
		self.Buttons.Eye:SetAttribute("spell", (GetSpellName(self.Spells.Eye, BOOKTYPE_SPELL)))
		self.Buttons.Eye:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Banish and self.Spells.Banish then
		self.Buttons.Banish:SetAttribute("type", "spell")
		self.Buttons.Banish:SetAttribute("spell", (GetSpellName(self.Spells.Banish, BOOKTYPE_SPELL)))
		self.Buttons.Banish:SetAttribute("ctrl-type*", "")
	end
	
	
	if self.Buttons.Soullink and self.Spells.Soullink then
		self.Buttons.Soullink:SetAttribute("type", "spell")
		self.Buttons.Soullink:SetAttribute("spell", (GetSpellName(self.Spells.Soullink, BOOKTYPE_SPELL)))
		self.Buttons.Soullink:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Soulwell and self.Spells.Soulwell then
		self.Buttons.Soulwell:SetAttribute("type", "spell")
		self.Buttons.Soulwell:SetAttribute("spell", (GetSpellName(self.Spells.Soulwell, BOOKTYPE_SPELL)))
		self.Buttons.Soulwell:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Felarmor and self.Spells.Felarmor then
		self.Buttons.Felarmor:SetAttribute("type", "spell")
		self.Buttons.Felarmor:SetAttribute("spell", (GetSpellName(self.Spells.Felarmor, BOOKTYPE_SPELL)))
		self.Buttons.Felarmor:SetAttribute("ctrl-type*", "")
	end
	if self.Buttons.Shadowward and self.Spells.Shadowward then
		self.Buttons.Shadowward:SetAttribute("type", "spell")
		self.Buttons.Shadowward:SetAttribute("spell", (GetSpellName(self.Spells.Shadowward, BOOKTYPE_SPELL)))
		self.Buttons.Shadowward:SetAttribute("ctrl-type*", "")
	end
	
	
	
	if self.Spells.Soulstone then
		ShardAceSoul:SetAttribute("type2", "spell")
		ShardAceSoul:SetAttribute("spell2", (GetSpellName(self.Spells.Soulstone, BOOKTYPE_SPELL)))
		ShardAceSoul:SetAttribute("ctrl-type*", "")
		ShardAceSoul_Text:SetTextColor(0, 1, 1)
	end
	if self.Spells.Spellstone then
		ShardAceSpell:SetAttribute("type2", "spell")
		ShardAceSpell:SetAttribute("spell2", (GetSpellName(self.Spells.Spellstone, BOOKTYPE_SPELL)))
		ShardAceSpell:SetAttribute("ctrl-type*", "")
		ShardAceSpell_Text:SetTextColor(0, 1, 1)
	end
	if self.Spells.Firestone then
		ShardAceFire:SetAttribute("type2", "spell")
		ShardAceFire:SetAttribute("spell2", (GetSpellName(self.Spells.Firestone, BOOKTYPE_SPELL)))
		ShardAceFire:SetAttribute("ctrl-type*", "")
	end
	if self.Spells.Healthstone then
		ShardAceHealth:SetAttribute("type2", "spell")
		ShardAceHealth:SetAttribute("spell2", (GetSpellName(self.Spells.Healthstone, BOOKTYPE_SPELL)))
		ShardAceHealth:SetAttribute("ctrl-type*", "")
		ShardAceHealth_Text:SetTextColor(0, 1, 1)
	end
end

function ShardAce:MoveSummons()
	if(self.Class ~= "WARLOCK")then
		return
	end
	local summonPos = self:getSummonMenuPosition()
	local startx, starty, ioffx, ioffy, goffx, goffy, thisx, thisy
	if summonPos == "left" then
		startx = -28
		starty = 28
		ioffx = -28
		ioffy = 0
		goffx = 0
		goffy = -28
	elseif summonPos == "right" then
		startx = 28
		starty = 28
		ioffx = 28
		ioffy = 0
		goffx = 0
		goffy = -28
	elseif summonPos == "top" then
		startx = 28
		starty = 28
		ioffx = 0
		ioffy = 28
		goffx = -28
		goffy = 0
	elseif summonPos == "bottom" then
		startx = -28
		starty = -28
		ioffx = 0
		ioffy = -28
		goffx = 28
		goffy = 0
	end
	
	thisx, thisy = startx, starty
	if self.Buttons.FelDomination then
		self.Buttons.FelDomination:ClearAllPoints()
		self.Buttons.FelDomination:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	
	if self.Buttons.Enslave  then
		self.Buttons.Enslave:ClearAllPoints()
		self.Buttons.Enslave:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Sacrifice  then
		self.Buttons.Sacrifice:ClearAllPoints()
		self.Buttons.Sacrifice:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Soullink  then
		self.Buttons.Soullink:ClearAllPoints()
		self.Buttons.Soullink:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	
	thisx = startx + goffx
	thisy = starty + goffy
	
	if self.Buttons.Imp then
		self.Buttons.Imp:ClearAllPoints()
		self.Buttons.Imp:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Voidwalker then
		self.Buttons.Voidwalker:ClearAllPoints()
		self.Buttons.Voidwalker:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Succubus then
		self.Buttons.Succubus:ClearAllPoints()
		self.Buttons.Succubus:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Felhunter then
		self.Buttons.Felhunter:ClearAllPoints()
		self.Buttons.Felhunter:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Infernal  then
		self.Buttons.Infernal:ClearAllPoints()
		self.Buttons.Infernal:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Doomguard  then
		self.Buttons.Doomguard:ClearAllPoints()
		self.Buttons.Doomguard:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Felguard  then
		self.Buttons.Felguard:ClearAllPoints()
		self.Buttons.Felguard:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	
	thisx = startx + (2*goffx)
	thisy = starty + (2*goffy)
	
	if self.Buttons.DetectInvis  then
		self.Buttons.DetectInvis:ClearAllPoints()
		self.Buttons.DetectInvis:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Breath  then
		self.Buttons.Breath:ClearAllPoints()
		self.Buttons.Breath:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Tracking  then
		self.Buttons.Tracking:ClearAllPoints()
		self.Buttons.Tracking:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.DemonBuff  then
		self.Buttons.DemonBuff:ClearAllPoints()
		self.Buttons.DemonBuff:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Felarmor  then
		self.Buttons.Felarmor:ClearAllPoints()
		self.Buttons.Felarmor:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Shadowward  then
		self.Buttons.Shadowward:ClearAllPoints()
		self.Buttons.Shadowward:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	
	thisx = startx + (3*goffx)
	thisy = starty + (3*goffy)
	if self.Buttons.Mount  then
		self.Buttons.Mount:ClearAllPoints()
		self.Buttons.Mount:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Port  then
		self.Buttons.Port:ClearAllPoints()
		self.Buttons.Port:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Eye  then
		self.Buttons.Eye:ClearAllPoints()
		self.Buttons.Eye:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Banish  then
		self.Buttons.Banish:ClearAllPoints()
		self.Buttons.Banish:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	if self.Buttons.Soulwell  then
		self.Buttons.Soulwell:ClearAllPoints()
		self.Buttons.Soulwell:SetPoint("CENTER", "ShardAceCount", "CENTER", thisx, thisy)
		thisx = thisx + ioffx
		thisy = thisy + ioffy
	end
	for k,v in pairs(self.Buttons) do
		v:SetFrameStrata("MEDIUM")
	end
end

function ShardAce:MoveButtons()
	local startangle, radius, increment, CountX, CountY
	local Xpoints, Ypoints = {}, {}
	ShardAceCount:ClearAllPoints()
	ShardAceSoul:ClearAllPoints()
	ShardAceSpell:ClearAllPoints()
	ShardAceFire:ClearAllPoints()
	ShardAceHealth:ClearAllPoints()
	
	local buttonPos = self:getMinimapButtonPosition()
	if buttonPos == "wayoutleft" then
		startangle = 270
		radius = 130
		increment = ((math.deg(math.acos(13/radius)))-90)*2
		--increment = -12
		CountX = 0 - radius
		CountY = 0
	elseif buttonPos == "farleft" then
		startangle = 270
		radius = 105
		increment = ((math.deg(math.acos(13/radius)))-90)*2
		--increment = -15
		CountX = 0 - radius
		CountY = 0
	elseif buttonPos == "closeleft" then
		startangle = 270
		radius = 80
		increment = ((math.deg(math.acos(13/radius)))-90)*2
		--increment = -18
		CountX = 0 - radius
		CountY = 0
	elseif buttonPos == "wayoutright" then
		startangle = 90
		radius = 130
		increment = -((math.deg(math.acos(13/radius)))-90)*2
		--increment = 12
		CountX = radius
		CountY = 0
	elseif buttonPos == "farright" then
		startangle = 90
		radius = 105
		increment = -((math.deg(math.acos(13/radius)))-90)*2
		--increment = 15
		CountX = radius
		CountY = 0
	elseif buttonPos == "closeright" then
		startangle = 90
		radius = 80
		increment = -((math.deg(math.acos(13/radius)))-90)*2
		--increment = 18
		CountX = radius
		CountY = 0
	elseif buttonPos == "custom" then
		startangle = 270
		radius = 105
		increment = ((math.deg(math.acos(13/radius)))-90)*2
		--increment = -15
		CountX = self.db.profile.CustomX
		CountY = self.db.profile.CustomY
	end
	
	
	local formation = self:getMinimapButtonFormation()
	if formation == "leftcurve" then
		if increment < 0 then
			for i = 1, 4 do
				Xpoints[i] = radius + (radius*math.sin(math.rad(startangle+(increment*i))))
				Ypoints[i] = radius*math.cos(math.rad(startangle+(increment*i)))
			end
		else
			for i = 1, 4 do
				Xpoints[i] = radius - (radius*math.sin(math.rad(startangle+(increment*i))))
				Ypoints[i] = radius*math.cos(math.rad(startangle+(increment*i)))
			end
		end
		
		ShardAceSoul:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[1], Ypoints[1])
		ShardAceSpell:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		ShardAceFire:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[3], Ypoints[3])
		if self.db.profile.Relic then
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[4], Ypoints[4])
		else
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		end
	elseif formation == "rightcurve" then
		if increment < 0 then
			for i = 1, 4 do
				Xpoints[i] = (radius - (radius*math.sin(math.rad(startangle+(increment*i))))) - 2*radius
				Ypoints[i] = radius*math.cos(math.rad(startangle+(increment*i)))
			end
		else
			for i = 1, 4 do
				Xpoints[i] = (radius*math.sin(math.rad(startangle+(increment*i)))) - radius
				Ypoints[i] = radius*math.cos(math.rad(startangle+(increment*i)))
			end
		end
		
		ShardAceSoul:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[1], Ypoints[1])
		ShardAceSpell:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		ShardAceFire:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[3], Ypoints[3])
		if self.db.profile.Relic then
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[4], Ypoints[4])
		else
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		end
	elseif formation == "horizontal" then
		for i = 1, 4 do
			Xpoints[i] = 26 * i
			Ypoints[i] = 0
		end
		ShardAceSoul:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[1], Ypoints[1])
		ShardAceSpell:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		ShardAceFire:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[3], Ypoints[3])
		if self.db.profile.Relic then
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[4], Ypoints[4])
		else
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		end
	elseif formation == "vertical" then
		for i = 1, 4 do
			Xpoints[i] = 0
			Ypoints[i] = -26*i
		end
		ShardAceSoul:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[1], Ypoints[1])
		ShardAceSpell:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		ShardAceFire:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[3], Ypoints[3])
		if self.db.profile.Relic then
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[4], Ypoints[4])
		else
			ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", Xpoints[2], Ypoints[2])
		end
	elseif formation == "square" or formation == "diamond" or formation == "cluster" then
		ShardAceSoul:SetPoint("CENTER", "ShardAceCount", "CENTER", 0, 26)
		ShardAceSpell:SetPoint("CENTER", "ShardAceCount", "CENTER", -26, 0)
		ShardAceFire:SetPoint("CENTER", "ShardAceCount", "CENTER", 26, 0)
		ShardAceHealth:SetPoint("CENTER", "ShardAceCount", "CENTER", 0, -26)
	end
	
	if buttonPos == "custom" then
		ShardAceCount:SetPoint("CENTER", "UIParent", "BOTTOMLEFT", CountX, CountY)
	else
		ShardAceCount:SetPoint("CENTER", "Minimap", "CENTER", CountX, CountY)
	end
	
	self:MoveSummons()
end

function ShardAce:BAG_UPDATE()
	self:StartMetro("ShardAceBagUpdate")
end

function ShardAce:ScanInv()
	self:StopMetro("ShardAceBagUpdate")
	if not self.Items then
		self.Items = {}
	end
	self.Items.ShardCount = GetItemCount(self.Local.SoulshardID)
	self.Items.Healthstone = nil
	self.Items.Soulstone = nil
	self.Items.Spellstone = nil
	self.Items.Firestone = nil
	self.Items.AQBugMount = nil
	self.Items.InfernalStoneCount = GetItemCount(self.Local.InfernalStoneID)
	self.Items.DemonicFigurineCount = GetItemCount(self.Local.DemonicFigurineID)

	for bag = 4, 0, -1 do
		local size = GetContainerNumSlots(bag)
		if (size > 0) then

			for slot=1, size, 1 do
				local _,_,itemID = string.find(GetContainerItemLink(bag,slot) or "", "item:(%d+):%d+:%d+:%d+")
				itemID = tonumber(itemID)
				if (itemID) then
					--ace:print(type(itemID))
					if self.Local.HealthstoneID[itemID] then
						self.Items.Healthstone = {bag,slot}
					elseif self.Local.SoulstoneID[itemID] then
						self.Items.Soulstone = {bag,slot}
					elseif self.Local.FirestoneID[itemID] then
						self.Items.Firestone = {bag,slot}
					elseif self.Local.SpellstoneID[itemID] then
						self.Items.Spellstone = {bag,slot}
					end
				end
			end
		end
	end
	local relic = GetInventoryItemLink("player",GetInventorySlotInfo("RangedSlot"))
	if relic then
		local _,_,itemID = string.find(relic, "item:(%d+):%d+:%d+:%d+")
		itemID = tonumber(itemID)
		if self.Local.SpellstoneID[itemID] then
			self.Items.Spellstone = "equip"
		elseif self.Local.FirestoneID[itemID] then
			self.Items.Firestone = "equip"
		end
	end
		
	self:DoButtons()
	if(self.Class == "WARLOCK")then
		if self:getAutoSortState() then
			ShardAce:SortShards(self:getShardBag(), self:getReverseSortState())
		end
	end
end

function ShardAce:ScanBook()
	if not self.Spells then
		self.Spells = {}
	end
	self.Spells.FelDomination = nil
	local _, _, _, numSpells = GetSpellTabInfo(1)
	
	local TotalSpells = 0;
	for j = 1, MAX_SKILLLINE_TABS do
		local _, _, _, XnumSpells = GetSpellTabInfo(j);
		TotalSpells = TotalSpells + XnumSpells;
	end
	for i = numSpells + 1, TotalSpells do
		local spellName, subSpellName = GetSpellName(i, "spell")
		local tex = GetSpellTexture(i, "spell")
		if spellName then
			if tex == self.Spell:GetSpellIcon("Create Healthstone") then
				self.Spells.Healthstone = i
			elseif tex == self.Spell:GetSpellIcon("Create Soulstone") then
				self.Spells.Soulstone = i
			elseif tex == self.Spell:GetSpellIcon("Create Spellstone") then
				self.Spells.Spellstone = i
			elseif tex == self.Spell:GetSpellIcon("Create Firestone") then
				self.Spells.Firestone = i
			elseif tex == self.Spell:GetSpellIcon("Detect Lesser Invisibility") then
				self.Spells.DetectInvis = i
			elseif tex == self.Spell:GetSpellIcon("Summon Felsteed") then
				if not self.Spells.Mount then
					self.Spells.Mount = {}
				end
				self.Spells.Mount[1] = i
			elseif tex == self.Spell:GetSpellIcon("Summon Dreadsteed") then
				if not self.Spells.Mount then
					self.Spells.Mount = {}
				end
				self.Spells.Mount[2] = i
			elseif tex == self.Spell:GetSpellIcon("Demon Armor") then
				if spellName == self.Spell["Demon Skin"] then
					self.Spells.DemonSkin = i
				elseif spellName == self.Spell["Demon Armor"] then
					self.Spells.DemonArmor = i
				end
			elseif tex == self.Spell:GetSpellIcon("Ritual of Summoning") then
				self.Spells.Port = i
			elseif tex == self.Spell:GetSpellIcon("Inferno") then
				self.Spells.Infernal = i
			elseif tex == self.Spell:GetSpellIcon("Ritual of Doom") then
				self.Spells.Doomguard = i
			elseif tex == self.Spell:GetSpellIcon("Enslave Demon") then
				if not self.Spells.Enslave then
					self.Spells.Enslave = {}
				end
				self.Spells.Enslave = i
			elseif tex == self.Spell:GetSpellIcon("Fel Domination") then
				self.Spells.FelDomination = i
			elseif tex == self.Spell:GetSpellIcon("Eye of Kilrogg") then
				self.Spells.Eye = i
			elseif tex == self.Spell:GetSpellIcon("Banish") then
				if not self.Spells.Banish then
					self.Spells.Banish = {}
				end
				self.Spells.Banish = i
			elseif tex == self.Spell:GetSpellIcon("Demonic Sacrifice") then
				self.Spells.Sacrifice = i
			elseif tex == self.Spell:GetSpellIcon("Sense Demons") then
				self.Spells.Tracking = i
			elseif tex == self.Spell:GetSpellIcon("Unending Breath") then
				self.Spells.Breath = i
			elseif tex == self.Spell:GetSpellIcon("Summon Imp") then
				self.Spells.Imp = i
			elseif tex == self.Spell:GetSpellIcon("Summon Voidwalker") then
				self.Spells.Voidwalker = i
			elseif tex == self.Spell:GetSpellIcon("Summon Succubus") then
				self.Spells.Succubus = i
			elseif tex == self.Spell:GetSpellIcon("Summon Felhunter") then
				self.Spells.Felhunter = i
			elseif tex == self.Spell:GetSpellIcon("Summon Felguard") then
				self.Spells.Felguard = i
			elseif tex == self.Spell:GetSpellIcon("Soul Link") then
				self.Spells.Soullink = i
			elseif tex == self.Spell:GetSpellIcon("Ritual of Souls") then
				self.Spells.Soulwell = i
			elseif tex == self.Spell:GetSpellIcon("Fel Armor") then
				self.Spells.Felarmor = i
			elseif tex == self.Spell:GetSpellIcon("Shadow Ward") then
				self.Spells.Shadowward = i
			end
		end
	end
	self:DoButtons()
	self:MakeButtons()
	self:UpdateButtons()
end

function ShardAce:SendMsg(msg, chan) -- message(string, message to send), channel(string, channel to send to. SAY, YELL, PARTY, RAID, or custom channel. Can be nil)
	self.Flags.lastMessage = self.Flags.lastMessage or 0
	local delay = GetTime() - self.Flags.lastMessage
	if delay < 0.5 then
		return
	end
	if(msg)then
		if chan then
			chan = strupper(chan)
		end
		if chan == "SAY" or chan == "YELL" then
			SendChatMessage(msg, chan)
		elseif chan == "PARTY" then
			if(UnitExists("party1"))then
				SendChatMessage(msg, chan)
			end
		elseif chan == "RAID" then
			if(UnitExists("raid1"))then
				SendChatMessage(msg, chan)
			end
		elseif chan == "DEFAULT" then
			if(UnitExists("raid1"))then
				SendChatMessage(msg, "RAID")
			elseif(UnitExists("party1"))then
				SendChatMessage(msg, "PARTY")
			end
		elseif chan then
			local  channum
			channum,_ = GetChannelName(chan)
			if channum then
				SendChatMessage(msg, "CHANNEL", nil, channum)
			end
		else		
			if(UnitExists("raid1"))then
				SendChatMessage(msg, "RAID")
			elseif(UnitExists("party1"))then
				SendChatMessage(msg, "PARTY")
			end
		end
	end
	self.Flags.lastMessage = GetTime()
end

function ShardAce:FixMsgString(msg)
	local fixedString,_ = string.gsub(msg, "%%t", "%%s")
	return fixedString
end

function ShardAce:BANKFRAME_OPENED()
	self.Flags.Bank = true
end

function ShardAce:BANKFRAME_CLOSED()
	self.Flags.Bank = nil
end

function ShardAce:SortShards(sbag, Revsort) -- sbag = 0-4, bag to sort into. Revsort: true = sort into sbag from bottom up
	if self.Flags.Bank then
		return
	end
	self.Flags.lastSort = self.Flags.lastSort or 0
	local delay = GetTime() - self.Flags.lastSort
	if delay < 1 then
		return
	end
	
	local sTable = {}
	local eTable = {}
	self:FindShard(sTable, sbag)

	if self:getMaxShards() >= 0 then
		if #sTable > self:getMaxShards() then
			for i = #sTable, self:getMaxShards()+1, -1 do
				PickupContainerItem(sTable[i][1], sTable[i][2])
				if CursorHasItem() then
					DeleteCursorItem()
					sTable[i] = nil
				end
			end
		end
	end
	
	self:FindSpace(eTable, sbag, Revsort)

	local sLength = #sTable
	local eLength = #eTable
	local temp = sLength
	if(eLength > temp)then
		temp = eLength
	end
	
	for i = 1, temp, 1 do
		if #eTable == 0 or #sTable == 0 then
			break
		end
		if(not CursorHasItem())then
			if sTable[#sTable][1] ~= sbag then
				PickupContainerItem(sTable[#sTable][1],sTable[#sTable][2])
				PickupContainerItem(eTable[#eTable][1],eTable[#eTable][2])
				sTable[#sTable] = nil
				eTable[#eTable] = nil
			else
				sTable[#sTable] = nil
			end
		end
	end
	
	self.Flags.lastSort = GetTime()
end

function ShardAce:FindShard(sTable, sbag)
	local shardbag = sbag
	for bag = 0, 4, 1 do
		local bagname = GetBagName(bag) or ""
		local size = GetContainerNumSlots(bag)
		if (size > 0)then
			for slot = 1, size, 1 do
				local _,_,itemID = string.find(GetContainerItemLink(bag,slot) or "", "item:(%d+):%d+:%d+:%d+")
				itemID = tonumber(itemID)
				if (itemID) then
					if itemID == self.Local.SoulshardID then
						tinsert(sTable, {bag, slot})
					end
				end
			end
		end
	end
end

function ShardAce:FindSpace(eTable, sbag, Revsort)
	local shardbag = sbag
	local size = GetContainerNumSlots(shardbag)
	local a, b, c = 1, 1, 1
	
	if(size > 0)then
		if self:getReverseSortState() then
			a = size
			c = -1
		else
			b = size
		end
		for slot = a, b, c do
			local _,_,itemID = string.find(GetContainerItemLink(shardbag,slot) or "", "item:(%d+):%d+:%d+:%d+")
			itemID = tonumber(itemID)
			if (not itemID) then
				tinsert(eTable, {shardbag, slot})
			elseif(itemID ~= self.Local.SoulshardID)then
				tinsert(eTable, {shardbag, slot})
			end
		end
	end
end


-----------------------------------------------------------------------------------------------------------------------
function ShardAce:getThreshold()
	return self.db.profile.Threshold
end

function ShardAce:setThreshold(v)
	self.db.profile.Threshold = v
	if(self.Class == "WARLOCK")then
		ShardAceCount_Text:SetText(self.Items.ShardCount)
		if self.Items.ShardCount <= self.db.profile.Threshold then
			ShardAceCount_Text:SetTextColor(1, 0, 0)
		else
			ShardAceCount_Text:SetTextColor(0, 1, 0)
		end
	end
end

function ShardAce:getHSTradeState()
	return self.db.profile.hsTrade
end

function ShardAce:setHSTradeState()
	self.db.profile.hsTrade = not self.db.profile.hsTrade
end

function ShardAce:getRelicState()
	return self.db.profile.Relic
end

function ShardAce:setRelicState()
	self.db.profile.Relic = not self.db.profile.Relic
	if self.db.profile.Relic then
		self:DoButtons()
	else
		ShardAceSpell:Hide()
		ShardAceFire:Hide()
	end
	self:MoveButtons()
end

function ShardAce:getSoundState()
	return self.db.profile.playSound
end

function ShardAce:setSoundState()
	self.db.profile.playSound = not self.db.profile.playSound
end

function ShardAce:getSoulstoneMessage()
	return self.db.profile.SoulstoneMsg
end

function ShardAce:setSoulstoneMessage(s)
	self.db.profile.SoulstoneMsg = self:FixMsgString(s)
end

function ShardAce:getSummonMessage()
	return self.db.profile.SummonMsg1
end

function ShardAce:setSummonMessage(s)
	self.db.profile.SummonMsg1 = self:FixMsgString(s)
end

function ShardAce:getPreSummonMessage()
	return self.db.profile.SummonMsg2
end

function ShardAce:setPreSummonMessage(s)
	self.db.profile.SummonMsg2 = self:FixMsgString(s)
end

function ShardAce:getShardBag()
	return self.db.profile.shardBag
end

function ShardAce:setShardBag(v)
	self.db.profile.shardBag = v
end

function ShardAce:getAutoSortState()
	return self.db.profile.AutoSort
end

function ShardAce:setAutoSortState()
	self.db.profile.AutoSort = not self.db.profile.AutoSort
end

function ShardAce:getReverseSortState()
	return self.db.profile.ReverseSort
end

function ShardAce:setReverseSortState()
	self.db.profile.ReverseSort = not self.db.profile.ReverseSort
end

function ShardAce:getMinimapButtonPosition()
	return self.db.profile.ButtonPosition
end

function ShardAce:setMinimapButtonPosition(s)
	self.db.profile.ButtonPosition = s
	self:MoveButtons()
end

function ShardAce:getSummonMenuPosition()
	return self.db.profile.SummonerPosition
end

function ShardAce:setSummonMenuPosition(s)
	self.db.profile.SummonerPosition = s
	self:MoveButtons()
end

function ShardAce:getMinimapButtonFormation()
	return self.db.profile.ButtonFormation
end

function ShardAce:setMinimapButtonFormation(s)
	self.db.profile.ButtonFormation = s
	self:MoveButtons()
end

function ShardAce:setCursorPosition()
	self.db.profile.ButtonPosition = "custom"
	local x,y = GetCursorPosition(UIParent)
	self.db.profile.CustomX = x/UIParent:GetEffectiveScale()
	self.db.profile.CustomY = y/UIParent:GetEffectiveScale()
	self:MoveButtons()
end

function ShardAce:getSummonMessageState()
	return self.db.profile.ShowMsgSum1
end

function ShardAce:setSummonMessageState()
	self.db.profile.ShowMsgSum1 = not self.db.profile.ShowMsgSum1
end

function ShardAce:getPreSummonMessageState()
	return self.db.profile.ShowMsgSum2
end

function ShardAce:setPreSummonMessageState()
	self.db.profile.ShowMsgSum2 = not self.db.profile.ShowMsgSum2
end

function ShardAce:getSoulstoneMessageState()
	return self.db.profile.ShowMsgSS
end

function ShardAce:setSoulstoneMessageState()
	self.db.profile.ShowMsgSS = not self.db.profile.ShowMsgSS
end

function ShardAce:getSoulstoneMessageChannel()
	return self.db.profile.SoulstoneMsgChan
end

function ShardAce:setSoulstoneMessageChannel(s)
	self.db.profile.SoulstoneMsgChan = s
end

function ShardAce:getSummonMessageChannel()
	return self.db.profile.SummonMsg1Chan
end

function ShardAce:setSummonMessageChannel(s)
	self.db.profile.SummonMsg1Chan = s
end

function ShardAce:getPreSummonMessageChannel()
	return self.db.profile.SummonMsg2Chan
end

function ShardAce:setPreSummonMessageChannel(s)
	self.db.profile.SummonMsg2Chan = s
end

function ShardAce:setGlobalMessageChannel(s)
	self:setSoulstoneMessageChannel(s)
	self:setSummonMessageChannel(s)
	self:setPreSummonMessageChannel(s)
	self:setSoulwellMessageChannel(s)
end

function ShardAce:getMaxShards()
	return self.db.profile.maxShard
end

function ShardAce:setMaxShards(v)
	self.db.profile.maxShard = v
end

function ShardAce:getScale()
	return self.db.profile.scale
end

function ShardAce:setScale(v)
	self.db.profile.scale = v
	if self.Buttons then
		for k,v in pairs(self.Buttons) do
			if k ~= "Header" then
				v:SetScale(self:getScale())
			end
		end
	end
end

function ShardAce:getBindingState()
	return self.db.profile.Binding
end

function ShardAce:setBindingState()
	self.db.profile.Binding = not self.db.profile.Binding
end


function ShardAce:getSoulwellMessage()
	return self.db.profile.SoulwellMsg
end

function ShardAce:setSoulwellMessage(s)
	self.db.profile.SoulwellMsg = s
end

function ShardAce:getSoulwellMessageState()
	return self.db.profile.ShowMsgSoulwell
end

function ShardAce:setSoulwellMessageState()
	self.db.profile.ShowMsgSoulwell = not self.db.profile.ShowMsgSoulwell
end

function ShardAce:getSoulwellChannel()
	return self.db.profile.SoulwellChan
end

function ShardAce:setSoulwellChannel(s)
	self.db.profile.SoulwellChan = s
end