local Locale = AceLibrary("AceLocale-2.2"):new("ShardAce")

Locale:RegisterTranslations("enUS", function()
	return {
		["Minor"] = "Minor",
		["Lesser"] = "Lesser",
		["Greater"] = "Greater",
		["Major"] = "Major",
		["Master"] = "Master",
		
		["ShardPouch1"] = "Soul Pouch", -- 20 slot bag from gadgetzan
		["ShardPouch2"] = "Felcloth Bag", -- 24 slot from Scholomance 
		["ShardPouch3"] = "Core Felcloth Bag", --Core Felcloth Bag from MC
	}
end)

ShardAceLocals ={}

ShardAceLocals.Commands = {"/shardace","/sa"}
ShardAceLocals.Options = {
	type = 'group',
	args = {
		threshold = { 
			type = 'range', name = "Threshold",
			desc = "Controls when the shard counter will change colour",
			min = 0, max = 20,
			step = 1,
			get = "getThreshold",
			set = "setThreshold",
			},
		--[[hstrade = {
				type = 'toggle', name = "HSTrade",
				desc = "Toggles healthstone trading",
				get = "getHSTradeState",
				set = "setHSTradeState",
			},]]
		relic = {
				type = 'toggle', name = "Relic",
				desc = "Toggles showing of fire/spell stone buttons",
				get = "getRelicState",
				set = "setRelicState",
			},
		sound = {
				type = 'toggle', name = "Sound",
				desc = "Toggles playing sound",
				get = "getSoundState",
				set = "setSoundState",
			},
		setmessage = {
			type = "group", desc = "Options for setting various messages", name="SetMessage",
			args = {
				soulstone = {
					type = 'text', desc = "Set the Soulstone message",
					name = "Soulstone",
					usage = "<message>",
					get = "getSoulstoneMessage",
					set = "setSoulstoneMessage",
				},
				summon = {
					type = 'text', desc = "Set the Summon message",
					name = "Summon",
					usage = "<message>",
					get = "getSummonMessage",
					set = "setSummonMessage",
				},
				presummon = {
					type = 'text', desc = "Set the Pre-Summon message",
					name = "Presummon",
					usage = "<message>",
					get = "getPreSummonMessage",
					set = "setPreSummonMessage",
				},
				soulwell = {
					type = 'text', desc = "Set the Soulwell message",
					name = "Soulwell",
					usage = "<message>",
					get = "getSoulwellMessage",
					set = "setSoulwellMessage",
				},
			},
		},
		shardsort = {
			type = "group", desc = "Options for shard sorting", name="ShardSort",
			args = {
				bag = { 
					type = 'range', name = "Bag",
					desc = "Sets which bag to sort shards into",
					min = 0, max = 4,
					step = 1,
					get = "getShardBag",
					set = "setShardBag",
				},
				auto = {
					type = 'toggle', name = "Auto",
					desc = "Toggles auto sorting",
					get = "getAutoSortState",
					set = "setAutoSortState",
				},
				reverse = {
					type = 'toggle', name = "HSTrade",
					desc = "Toggles sorting direction",
					get = "getReverseSortState",
					set = "setReverseSortState",
				},
			},
		},
		position = {
			type = "group", desc = "Options for button placement", name="Position",
			args = {
				buttons = {
					type = 'text', desc = "Sets position of minimap buttons",
					name = "Buttons",
				    get = "getMinimapButtonPosition",
				    set = "setMinimapButtonPosition",
				    validate = {"wayoutleft", "farleft", "closeleft", "wayoutright", "farright", "closeright"},
				},
				summon = {
					type = 'text', desc = "Sets position of the summoner menu",
					name = "Summon",
				    get = "getSummonMenuPosition",
				    set = "setSummonMenuPosition",
				    validate = {"left", "right", "top", "bottom"},
				},
				formation = {
					type = 'text', desc = "Sets formation of the minimap buttons",
					name = "Formation",
				    get = "getMinimapButtonFormation",
				    set = "setMinimapButtonFormation",
				    validate = {"leftcurve", "rightcurve", "horizontal", "vertical", "cluster"},
				},
				cursor = {
					type = 'execute', desc = "Moves the minimap buttons to the cursor",
					name = "Cursor",
					func = "setCursorPosition",
				},
			},
		},
		togglemessage = {
			type = "group", desc = "Toggle various messages on and off", name="ToggleMessage",
			args = {
				summon = {
					type = 'toggle', name = "Summon",
					desc = "Toggles summoning messages",
					get = "getSummonMessageState",
					set = "setSummonMessageState",
				},
				presummon = {
					type = 'toggle', name = "Presummon",
					desc = "Toggles pre-summoning messages",
					get = "getPreSummonMessageState",
					set = "setPreSummonMessageState",
				},
				soulstone = {
					type = 'toggle', name = "Soulstone",
					desc = "Toggles soulstone messages",
					get = "getSoulstoneMessageState",
					set = "setSoulstoneMessageState",
				},
				soulwell = {
					type = 'toggle', name = "Soulwell",
					desc = "Toggles Soulwell messages",
					get = "getSoulwellMessageState",
					set = "setSoulwellMessageState",
				},
			},
		},
		setchannel = {
			type = "group", desc = "Set channels for various messages", name="SetChannel",
			args = {
				soulstone = {
					type = 'text', desc = "Set the Soulstone message channel",
					name = "Soulstone",
					usage = "<channel name>",
					get = "getSoulstoneMessageChannel",
					set = "setSoulstoneMessageChannel",
				},
				summon = {
					type = 'text', desc = "Set the Summon message channel",
					name = "Summon",
					usage = "<channel name>",
					get = "getSummonMessageChannel",
					set = "setSummonMessageChannel",
				},
				presummon = {
					type = 'text', desc = "Set the Pre-Summon message channel",
					name = "Presummon",
					usage = "<channel name>",
					get = "getPreSummonMessageChannel",
					set = "setPreSummonMessageChannel",
				},
				soulwell = {
					type = 'text', desc = "Set the Soulwell message channel",
					name = "Soulwell",
					usage = "<channel name>",
					get = "getSoulwellChannel",
					set = "setSoulwellChannel",
				},
				all = {
					type = 'text', desc = "Set the channel for all messages",
					name = "All",
					usage = "<channel name>",
					get = false,
					set = "setGlobalMessageChannel",
				},
			},
		},
		maxshards = { 
			type = 'range', name = "MaxShards",
			desc = "Controls when to start deleting shards.",
			min = -1, max = 40,
			step = 1,
			get = "getMaxShards",
			set = "setMaxShards",
		},
		scale = {
			type = 'range', name = "Scale",
			desc = "Set the scale of the right click menu buttons",
			min = 0.6, max = 2,
			get = "getScale",
			set = "setScale",
			isPercent = true,
		},
		binding = {
				type = 'toggle', name = "Binding",
				desc = "Toggles ability to bind on and off",
				get = "getBindingState",
				set = "setBindingState",
			},
	},
}
ShardAceLocals.SummonMsg1 = "Summoning >>%s<< Please Assist"
ShardAceLocals.SummonMsg2 = "Preparing to summon %s"
ShardAceLocals.SoulMsg = "%s has been soulstoned"
ShardAceLocals.SoulwellMsg = "Someone right click this altar or NO STONE FOR YOU!"