ShamanWarning = LibStub("AceAddon-3.0"):NewAddon("Shaman Warning", "AceEvent-3.0", "AceConsole-3.0")

local function getOption(info)
	return (info.arg and ShamanWarning.db.profile[info.arg] or ShamanWarning.db.profile[info[#info]])
end;

local function setOption(info, value)
	local key = info.arg or info[#info]
	ShamanWarning.db.profile[key] = value
	--ShamanWarning:UpdateFrame()
end;

local options = {
	name = "ShamanWarning",
	type = "group",
	childGroups = "tab",
	args = {
		elemental = {
			name = "Element",
			desc = "Elemental",
			type = "group",
			order = 1,
			args = {
				elemental = {
					name = "Elemental Devastation",
					desc = "Toggles on/off Elemental Devastation proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				storm = {
					name = "Eye of the Storm",
					desc = "Toggles on/off Eye of the Storm proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				clearcast = {
					name = "Clearcasting",
					desc = "Toggles on/off clearcasting proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				charged = {
					name = "Charged",
					desc = "Toggles on/off charged proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
			},
		},
		
		enhancement = {
			name = "Enhance",
			desc = "Enhancement",
			type = "group",
			order = 2,
			args = {
				flurry = {
					name = "Flurry",
					desc = "Toggles on/off Flurry proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				invigorated = {
					name = "Invigorated",
					desc  = "Toggles on/off Invigorated proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
			},
		},
		
		restoration = {
			name = "Resto",
			desc = "Restoration",
			type = "group",
			order = 3,
			args = {
				wavetrance = {
					name = "Wave Trance",
					desc = "Toggles on/off Wave Trance proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				earthshield = {
					name = "Earth Shield",
					desc = "Toggles on/off Earth Shield removed warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				manatide = {
					name = "Mana Tide Totem",
					desc = "Toggles on/off Mana Tide Totem warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
			},
		},
		
		misc = {
			name = "Misc",
			desc = "Misc spells",
			type = "group",
			order = 4,
			args = {
				windfury = {
					name = "WindFury",
					desc = "Toggles on/off Windfury proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				water = {
					name = "Water Shield",
					desc = "Toggles on/off Water Shield removed warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				lightning = {
					name = "Lightning Shield",
					desc = "Toggles on/off Lightning Shield removed warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				executioner = {
					name = "Executioner",
					desc = "Toggles on/off Executioner proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
				mongoose = {
					name = "Mongoose",
					desc = "Toggles on/off Mongoose proc warning",
					type = "toggle",
					get = getOption,
					set = setOption,
				},
			},
		},
	},
}

local defaults = {
	profile = {
		elemental = true,
		windfury = true,
		flurry = true,
		storm = true,
		water = true,
		clearcast = true,
		executioner = true,
		mongoose = true,
		invigorated = true,
		charged = true,
		wavetrance = true,
		earthshield = true,
		lightning = true,
		manatide = true,
	},
}

function ShamanWarning:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("ShamanWarningDB", defaults, "Default")
	LibStub("AceConfig-3.0"):RegisterOptionsTable("ShamanWarning", options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("ShamanWarning", "ShamanWarning")
	self:RegisterChatCommand("ShamanWarning", "ChatCommand")
	self:RegisterChatCommand("sw", "ChatCommand")
end;

function ShamanWarning:OnEnable()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED","CombatLogEvent")
end;

function ShamanWarning:ChatCommand(input)
    if not input or input:trim() == "" then
        InterfaceOptionsFrame_OpenToFrame(self.optionsFrame)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(ShamanWarning, "ShamanWarning", "ShamanWarning", input)
    end
end


function ShamanWarning:CombatLogEvent(a, timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellID, spellName)
	if event=="SPELL_AURA_APPLIED" and destFlags==0x511 then
		if spellName=="Flurry" and self.db.profile.flurry then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Flurry.mp3");
		end;
		if (spellName=="Clearcasting" or spellName=="Focused") and self.db.profile.clearcast then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Clearcast.mp3");
		end;
		if spellName=="Elemental Devastation" and self.db.profile.elemental then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Elemental.mp3");
		end;
		if spellName=="Focused Casting" and self.db.profile.storm then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Storm.mp3");
		end;
		if spellName=="Lightning Speed" and self.db.profile.mongoose then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Lightning.mp3");
		end;
		if spellName=="Executioner" and self.db.profile.executioner then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Executioner.mp3");
		end;
		if spellName=="Wave Trance" and self.db.profile.wavetrance then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Power.mp3");
		end;
		if spellName=="Invigorated" and self.db.profile.invigorated then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Power.mp3");
		end;
		if spellName=="Charged" and self.db.profile.charged then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Power.mp3");
		end;
	end;
	if event=="SPELL_AURA_REMOVED" and destFlags==0x511 then
		if spellName=="Water Shield" and self.db.profile.water then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Water.mp3");
		end;
		if spellName=="Earth Shield" and self.db.profile.earthshield then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Earth.mp3");
		end;
		if spellName=="Lightning Shield" and self.db.profile.lightning then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\Light.mp3");
		end;
	end;
	if event=="SPELL_DAMAGE" and sourceFlags==0x511 then
		if spellName=="Windfury Attack" and self.db.profile.windfury then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\WindFury.mp3");
		end;
	end;
	if event=="SPELL_SUMMON" then
		if spellName=="Mana Tide Totem" and self.db.profile.manatide then
			PlaySoundFile("Interface\\AddOns\\ShamanWarning\\Sounds\\ManaTide.mp3");
		end;
	end;
end;
