--Setup

local L = AceLibrary("AceLocale-2.2"):new("ShamanBuffBars")
local waterfall = AceLibrary("Waterfall-1.0")
local tablet = AceLibrary("Tablet-2.0")
ShamanBuffBars = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0");

local ShamanBuffBarsOptions = {				-- options table
	name = L["ShamanBuffBars"],
	desc = L["ShamanBuffBars"],
	type = 'group',
	args = {
		GUI = {
			name = L["GUI"],
			desc = L["GUI"],
			guiHidden = true,
			type = 'execute',
			func = function()
				waterfall:Open('ShamanBuffBars')
			end,
			},
		WeaponConfig = {
			name = L["Weapon Bar"],
			desc = L["Weapon Bar"],
			order = 1,
			type = 'group',
			args = {
					Scale = {
						name = L["Scale"],
						desc = L["Set Scale"],
						order = 4,
						type = 'range',
						min = 0.1,
						max = 2.5,
						step = 0.1,
						isPercent = true,
						get = function() return ShamanBuffBars.db.profile.W_Scale end,
						set = function(v)
							ShamanBuffBars.db.profile.W_Scale = v
							ShamanBuffBars:SetUp()
							--WeaponFrame:Show();
							ShamanBuffBars:W_HIDE_ONCE_BUFFED()
						end,
					},
					Alpha = {
						name = L["Alpha"],
						desc = L["Set Alpha"],
						order = 3,
						type = 'range',
						min = 0.0,
						max = 1.0,
						step = 0.05,
						isPercent = true,
						get = function() return ShamanBuffBars.db.profile.W_Alpha end,
						set = function(v)
							ShamanBuffBars.db.profile.W_Alpha = v
							ShamanBuffBars:SetUp()
							--WeaponFrame:Show();
							ShamanBuffBars:W_HIDE_ONCE_BUFFED()
						end,
					},
					Bar = {
						name = L["Bar Config"],
						desc = L["Set Bar Appearance"],
						order = 1,
						type = 'group',
						args = {
							Direction = {
								name = L["Direction"],
								desc = L["Set Direction"],
								order = 1,
								type = 'text',
								get = function() return ShamanBuffBars.db.profile.W_Direction end,
								set = function(v) 
									ShamanBuffBars.db.profile.W_Direction = v
									ShamanBuffBars:SetUp()
									--WeaponFrame:Show();
									ShamanBuffBars:W_HIDE_ONCE_BUFFED()
								end,
								validate = {["Vertical"] = L["Vertical"], ["Horizontal"] = L["Horizontal"]}
							},
							Order = {
								name = L["Order"],
								desc = L["Set Order"],
								order = 2,
								type = 'text',
								get = function() return ShamanBuffBars.db.profile.W_Reverse end,
								set = function(v) 
									ShamanBuffBars.db.profile.W_Reverse = v
									ShamanBuffBars:SetUp()
									--WeaponFrame:Show();
									ShamanBuffBars:W_HIDE_ONCE_BUFFED()
								end,
								validate = {["Normal"] = L["Normal"], ["Reverse"] = L["Reverse"]}
							},
							HideOnceBuffed = {
								name = L["Hide Once Buffed"],
								desc = L["Hide bar while buffed"],
								order = 3,
								type = 'toggle',
								get = function() return ShamanBuffBars.db.profile.W_HideOnceBuffed end,
								set = function() 
									ShamanBuffBars.db.profile.W_HideOnceBuffed = not ShamanBuffBars.db.profile.W_HideOnceBuffed
									ShamanBuffBars:W_HIDE_ONCE_BUFFED()
								end,
							},
						},
					},
					Buttons = {
						name = L["Buttons"],
						desc = L["Show/Hide specific buttons"],
						order = 2,
						type = 'group',
						args = {
							Rockbiter = {
								name = L["Rockbiter Weapon"],
								desc = (L["Show %s Button"]):format( L["Rockbiter Weapon"]),
								disabled = function() return InCombatLockdown() end,
								order = 1,
								type = 'toggle',
								get = function() return ShamanBuffBars.db.profile.Rockbiter.Show end,
								set = function()
									ShamanBuffBars.db.profile.Rockbiter.Show = not ShamanBuffBars.db.profile.Rockbiter.Show
									ShamanBuffBars:W_SetButtonNum(ShamanBuffBars.db.profile.Rockbiter.Show, L["Rockbiter Weapon"])
								end,
							},
							Flametongue = {
								name = L["Flametongue Weapon"],
								desc = (L["Show %s Button"]):format( L["Flametongue Weapon"]),
								order = 2,
								type = 'toggle',
								disabled = function() return InCombatLockdown() end,
								get = function() return ShamanBuffBars.db.profile.Flametongue.Show end,
								set = function()
									ShamanBuffBars.db.profile.Flametongue.Show = not ShamanBuffBars.db.profile.Flametongue.Show
									ShamanBuffBars:W_SetButtonNum(ShamanBuffBars.db.profile.Flametongue.Show, L["Flametongue Weapon"])
								end,
							},
							Frostbrand = {
								name = L["Frostbrand Weapon"],
								desc = (L["Show %s Button"]):format( L["Frostbrand Weapon"]),
								order = 3,
								type = 'toggle',
								disabled = function() return InCombatLockdown() end,
								get = function() return ShamanBuffBars.db.profile.Frostbrand.Show end,
								set = function()
									ShamanBuffBars.db.profile.Frostbrand.Show = not ShamanBuffBars.db.profile.Frostbrand.Show
									ShamanBuffBars:W_SetButtonNum(ShamanBuffBars.db.profile.Frostbrand.Show, L["Frostbrand Weapon"])
								end,
							},
							Windfury = {
								name = L["Windfury Weapon"],
								desc = (L["Show %s Button"]):format( L["Windfury Weapon"]),
								order = 4,
								type = 'toggle',
								disabled = function() return InCombatLockdown() end,
								get = function() return ShamanBuffBars.db.profile.Windfury.Show end,
								set = function()
									ShamanBuffBars.db.profile.Windfury.Show = not ShamanBuffBars.db.profile.Windfury.Show
									ShamanBuffBars:W_SetButtonNum(ShamanBuffBars.db.profile.Windfury.Show, L["Windfury Weapon"])
								end,
							},
						},
					},
			},
		},
		ShieldConfig = {
			name = L["Shield Bar"],
			desc = L["Shield Bar"],
			order = 2,
			type = 'group',
			args = {
						Scale = {
							name = L["Scale"],
							desc = L["Set Scale"],
							order = 4,
							type = 'range',
							min = 0.1,
							max = 2.5,
							step = 0.1,
							isPercent = true,
							get = function() return ShamanBuffBars.db.profile.S_Scale end,
							set = function(v)
								ShamanBuffBars.db.profile.S_Scale = v
								ShamanBuffBars:S_SetUp()
								ShieldFrame:Show();
							end,
						},
						Alpha = {
							name = L["Alpha"],
							desc = L["Set Alpha"],
							order = 3,
							type = 'range',
							min = 0.0,
							max = 1.0,
							step = 0.05,
							isPercent = true,
							get = function() return ShamanBuffBars.db.profile.S_Alpha end,
							set = function(v)
								ShamanBuffBars.db.profile.S_Alpha = v
								ShamanBuffBars:S_SetUp()
								ShieldFrame:Show();
							end,
						},
						Bar = {
							name = L["Bar Config"],
							desc = L["Set Bar Appearance"],
							order = 1,
							type = 'group',
							args = {
								Direction = {
									name = L["Direction"],
									desc = L["Set Direction"],
									order = 1,
									type = 'text',
									get = function() return ShamanBuffBars.db.profile.S_Direction end,
									set = function(v) 
										ShamanBuffBars.db.profile.S_Direction = v
										ShamanBuffBars:S_SetUp()
										ShieldFrame:Show();
									end,
									validate = {["Vertical"] = L["Vertical"], ["Horizontal"] = L["Horizontal"]}
								},
								Order = {
									name = L["Order"],
									desc = L["Set Order"],
									order = 2,
									type = 'text',
									get = function() return ShamanBuffBars.db.profile.S_Reverse end,
									set = function(v) 
										ShamanBuffBars.db.profile.S_Reverse = v
										ShamanBuffBars:S_SetUp()
										ShieldFrame:Show();
									end,
									validate = {["Normal"] = L["Normal"], ["Reverse"] = L["Reverse"]}
								},
								ShowActive = {
									name = L["Show Active"],
									desc = L["Show which shield is active on bar"],
									order = 3,
									type = 'toggle',
									get = function() return ShamanBuffBars.db.profile.S_ShowActive end,
									set = function(v) 
										ShamanBuffBars.db.profile.S_ShowActive = v
										ShamanBuffBars:S_SetUp()
										ShamanBuffBars:S_UPDATE()
										--ShamanBuffBars:Show();
									end,
								},
							},
						},
						Buttons = {
							name = L["Buttons"],
							desc = L["Show/Hide specific buttons"],
							order = 2,
							type = 'group',
							args = {
								Lightning = {
									name = L["Lightning Shield"],
									desc = (L["Show %s Button"]):format( L["Lightning Shield"]),
									order = 1,
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return ShamanBuffBars.db.profile.Lightning.Show end,
									set = function()
										ShamanBuffBars.db.profile.Lightning.Show = not ShamanBuffBars.db.profile.Lightning.Show
										ShamanBuffBars:S_SetButtonNum(ShamanBuffBars.db.profile.Lightning.Show, L["Lightning Shield"])
									end,
								},
								Water = {
									name = L["Water Shield"],
									desc = (L["Show %s Button"]):format( L["Water Shield"]),
									order = 2,
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return ShamanBuffBars.db.profile.Water.Show end,
									set = function()
										ShamanBuffBars.db.profile.Water.Show = not ShamanBuffBars.db.profile.Water.Show
										ShamanBuffBars:S_SetButtonNum(ShamanBuffBars.db.profile.Water.Show, L["Water Shield"])
									end,
								},
								Earth = {
									name = L["Earth Shield"],
									desc = (L["Show %s Button"]):format( L["Earth Shield"]),
									order = 3,
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return ShamanBuffBars.db.profile.Earth.Show end,
									set = function()
										ShamanBuffBars.db.profile.Earth.Show = not ShamanBuffBars.db.profile.Earth.Show
										ShamanBuffBars:S_SetButtonNum(ShamanBuffBars.db.profile.Earth.Show, L["Earth Shield"])
									end,
								},
							},
						},
			},
		},
		
		Bindings = {
			name = L["Bindings"],
			desc = L["Set Keybindings"],
			order = 3,
			wfHidden = true,
			type = 'group',
			args = {
				Rockbiter = {
					name = L["Rockbiter Weapon"],
					desc = (L["Bind %s to a key"]):format( L["Rockbiter Weapon"]),
					order = 1,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Rockbiter Weapon"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Rockbiter Weapon"], v)
					end,
				},
				Flametongue = {
					name = L["Flametongue Weapon"],
					desc = (L["Bind %s to a key"]):format( L["Flametongue Weapon"]),
					order = 2,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Flametongue Weapon"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Flametongue Weapon"], v)
					end,
				},
				Frostbrand = {
					name = L["Frostbrand Weapon"],
					desc = (L["Bind %s to a key"]):format( L["Frostbrand Weapon"]),
					order = 3,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Frostbrand Weapon"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Frostbrand Weapon"], v)
					end,
				},
				Windfury = {
					name = L["Windfury Weapon"],
					desc = (L["Bind %s to a key"]):format( L["Windfury Weapon"]),
					order = 4,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Windfury Weapon"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Windfury Weapon"], v)
					end,
				},
				Lightning = {
					name = L["Lightning Shield"],
					desc = (L["Bind %s to a key"]):format( L["Lightning Shield"]),
					order = 5,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Lightning Shield"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Lightning Shield"], v)
					end,
				},
				Water = {
					name = L["Water Shield"],
					desc = (L["Bind %s to a key"]):format( L["Water Shield"]),
					order = 6,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Water Shield"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Water Shield"], v)
					end,
				},
				Earth = {
					name = L["Earth Shield"],
					desc = (L["Bind %s to a key"]):format( L["Earth Shield"]),
					order = 7,
					type = 'text',
					validate = 'keybinding',
					disabled = function() return InCombatLockdown() end,
					get = function() return GetBindingKey("SPELL "..L["Earth Shield"]) end,
					set = function(v)
							ShamanBuffBars:SetBinding(L["Earth Shield"], v)
					end,
				},
			},
		},

		Help = {
					name = L["Help"],
					desc = L["Help"],
					order = 4,
					type = 'execute',
					func = function()
						ShamanBuffBars:Print(L["To move a bar, hold ctrl and right-click drag the bar.\nTo change the button order, use the button show/hide feature.\nNote: Bindings not available via waterfall GUI."])
					end,
		},
	},
}


waterfall:Register('ShamanBuffBars', 
 'aceOptions',ShamanBuffBarsOptions,
 'title','ShamanBuffBars Config')

ShamanBuffBars.OnMenuRequest = ShamanBuffBarsOptions
ShamanBuffBars.hasIcon = "Interface\\Icons\\Spell_Nature_ShamanRage"
ShamanBuffBars.defaultPosition = "CENTER"
ShamanBuffBars.hasNoColor = true
ShamanBuffBars.cannotDetachTooltip = true
ShamanBuffBars.hideWithoutStandby = true

function ShamanBuffBars:OnTooltipUpdate()
	local category = tablet:AddCategory()
	tablet:SetHint(L["|cffeda55fClick|r for Waterfall GUI, |cffeda55fRight Click|r for Dewdrop menu.\n\nNote: Bindings not available via GUI."])
end

function ShamanBuffBars:OnClick()
	waterfall:Open('ShamanBuffBars')
end

function ShamanBuffBars:OnInitialize()
	local defaults = {						--Weapon defaults
		W_Scale = 1,
		W_Alpha = 1,
		W_Direction = "Horizontal",
		W_Reverse = "Normal",
		W_HideOnceBuffed = true,		
		Rockbiter = {Show = true, Order = 1},
		Flametongue = {Show = true, Order = 2},
		Frostbrand = {Show = true, Order = 3},
		Windfury = {Show = true, Order = 4},
		W_Number = 4,
		WeaponList = {
			[1] = L["Rockbiter Weapon"],
			[2] = L["Flametongue Weapon"],
			[3] = L["Frostbrand Weapon"],
			[4] = L["Windfury Weapon"],
			[5] = nil,
		},
											--Shield defaults
		S_Scale = 1,
		S_Alpha = 1,
		S_Direct = "Horizontal",
		S_Reverse = "Normal",
		S_ShowActive = "On",
		Lightning = {Show = true, Order = 1},
		Water = {Show = true, Order = 2},
		Earth = {Show = true, Order = 3},
		S_Number = 3,
		ShieldList = {
			[1] = L["Lightning Shield"],
			[2] = L["Water Shield"],
			[3] = L["Earth Shield"],
			[4] = nil,
		},
	}

	self:RegisterDB("ShamanBuffBarsDB")
	self:RegisterDefaults('profile', defaults)
	self:RegisterChatCommand({'/shamanbuffbars', '/sbb'}, ShamanBuffBarsOptions)
	ShamanBuffBars:SetUp()
end

function ShamanBuffBars:SetTooltip()
	if (this:GetAttribute("id")) then
		GameTooltip_SetDefaultAnchor(GameTooltip, this);
		GameTooltip:SetSpell(this:GetAttribute("id"), SpellBookFrame.bookType);
		GameTooltip:Show();
	end
end

function ShamanBuffBars:W_SetButtonNum(value, buff)
	if value == true then
		ShamanBuffBars.db.profile.W_Number = ShamanBuffBars.db.profile.W_Number  + 1
		if not ShamanBuffBars.db.profile.WeaponList then
			ShamanBuffBars.db.profile.WeaponList = { }
		end
		ShamanBuffBars.db.profile.WeaponList[ShamanBuffBars.db.profile.W_Number] = buff
		getglobal("WeaponButton"..ShamanBuffBars.db.profile.W_Number):Show()
	else
		ShamanBuffBars.db.profile.W_Number = ShamanBuffBars.db.profile.W_Number  - 1
		getglobal("WeaponButton"..ShamanBuffBars.db.profile.W_Number + 1):Hide()
		for k, v in pairs(ShamanBuffBars.db.profile.WeaponList) do
			if v == buff then
				for i = k, 5 do
					ShamanBuffBars.db.profile.WeaponList[i] = ShamanBuffBars.db.profile.WeaponList[i+1]
				end
			end
		end
	end
	ShamanBuffBars:W_UPDATE()
end

function ShamanBuffBars:S_SetButtonNum(value, buff)
	if value == true then
		ShamanBuffBars.db.profile.S_Number = ShamanBuffBars.db.profile.S_Number  + 1
		if not ShamanBuffBars.db.profile.ShieldList then
			ShamanBuffBars.db.profile.ShieldList = { }
		end
		ShamanBuffBars.db.profile.ShieldList[ShamanBuffBars.db.profile.S_Number] = buff
		getglobal("ShieldButton"..ShamanBuffBars.db.profile.S_Number):Show()
	else
		ShamanBuffBars.db.profile.S_Number = ShamanBuffBars.db.profile.S_Number  - 1
		getglobal("ShieldButton"..ShamanBuffBars.db.profile.S_Number + 1):Hide()
		for k, v in pairs(ShamanBuffBars.db.profile.ShieldList) do
			if v == buff then
				for i = k, 5 do
					ShamanBuffBars.db.profile.ShieldList[i] = ShamanBuffBars.db.profile.ShieldList[i+1]
				end
			end
		end
	end
	ShamanBuffBars:S_UPDATE()
end

function ShamanBuffBars:SetBinding(buff, bind)
	local clear1, clear2 = GetBindingKey("SPELL "..buff)
	if clear1 then
		SetBinding(clear1)
	end
	if clear2 then
		SetBinding(clear2)
	end	
	SetBinding(bind)
	SetBindingSpell(bind, buff)
	SaveBindings(GetCurrentBindingSet())
end

function ShamanBuffBars:GetSpellID(spell, rank)
	local i = 1;
	local spellID, highestRank;
	while true do
		local spellName, spellRank = GetSpellName(i, SpellBookFrame.bookType);
		if (not spellName) then
			break;
		end
		if (spellName == spell) then
			if (rank) then
				if (spellRank == rank) then
					return i;
				end
			else
				spellID = i;
				highestRank = spellRank;
			end
		end
		i = i + 1;
		if (i > 250) then
			break;
		end
	end			
	return spellID, highestRank;
end

function ShamanBuffBars:OnEnable()
	self:RegisterEvent("SPELLS_CHANGED", "UPDATE")
	self:RegisterEvent("PLAYER_AURAS_CHANGED", "UPDATE")
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	self:RegisterEvent("UNIT_MODEL_CHANGED", "W_HIDE_ONCE_BUFFED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "W_HIDE_ONCE_BUFFED")
end

function ShamanBuffBars:SetUp()
	-- This function cannot be performed in combat.
        if (InCombatLockdown() == nil) then
		if (ShamanBuffBars.db.profile) then
			ShamanBuffBars:W_SetUp()
			ShamanBuffBars:S_SetUp()
		end
	end
end

function ShamanBuffBars:W_SetUp()
	if ShamanBuffBars.db.profile.W_Number > 1 then
		if (ShamanBuffBars.db.profile.W_Direction == "Vertical" and ShamanBuffBars.db.profile.W_Reverse == "Normal") then
			for i = 2, ShamanBuffBars.db.profile.W_Number do
				local button = getglobal("WeaponButton"..i);
				button:ClearAllPoints();
				button:SetPoint("TOP", "WeaponButton"..i - 1, "BOTTOM", 0, 1);
			end
		elseif (ShamanBuffBars.db.profile.W_Direction == "Vertical" and ShamanBuffBars.db.profile.W_Reverse == "Reverse") then
			for i = 2, ShamanBuffBars.db.profile.W_Number do
				local button = getglobal("WeaponButton"..i);
				button:ClearAllPoints();
				button:SetPoint("BOTTOM", "WeaponButton"..i - 1, "TOP", 0, 1);
			end
		elseif (ShamanBuffBars.db.profile.W_Direction == "Horizontal" and ShamanBuffBars.db.profile.W_Reverse == "Normal") then
			for i = 2, ShamanBuffBars.db.profile.W_Number do
				local button = getglobal("WeaponButton"..i);
				button:ClearAllPoints();
				button:SetPoint("LEFT", "WeaponButton"..i - 1, "RIGHT", 1, 0);
			end
		elseif (ShamanBuffBars.db.profile.W_Direction == "Horizontal" and ShamanBuffBars.db.profile.W_Reverse == "Reverse") then
			for i = 2, ShamanBuffBars.db.profile.W_Number do
				local button = getglobal("WeaponButton"..i);
				button:ClearAllPoints();
				button:SetPoint("RIGHT", "WeaponButton"..i - 1, "LEFT", 1, 0);
			end
		else
			for i = 2, ShamanBuffBars.db.profile.W_Number do
				local button = getglobal("WeaponButton"..i);
				button:ClearAllPoints();
				button:SetPoint("LEFT", "WeaponButton"..i - 1, "RIGHT", 1, 0);
			end
		end
	end
	if ShamanBuffBars.db.profile.W_Scale then
		WeaponFrame:SetScale(ShamanBuffBars.db.profile.W_Scale)
	else
		WeaponFrame:SetScale(1)
	end
	if ShamanBuffBars.db.profile.W_Alpha then
		WeaponFrame:SetAlpha(ShamanBuffBars.db.profile.W_Alpha)
	else
		WeaponFrame:SetAlpha(1)
	end
end

function ShamanBuffBars:S_SetUp()
	if ShamanBuffBars.db.profile.S_Number > 1 then
		if (ShamanBuffBars.db.profile.S_Direction == "Vertical" and ShamanBuffBars.db.profile.S_Reverse == "Normal") then
			for i = 2, ShamanBuffBars.db.profile.S_Number do
				local button = getglobal("ShieldButton"..i);
				button:ClearAllPoints();
				button:SetPoint("TOP", "ShieldButton"..i - 1, "BOTTOM", 0, 1);
			end
		elseif (ShamanBuffBars.db.profile.S_Direction == "Vertical" and ShamanBuffBars.db.profile.S_Reverse == "Reverse") then
			for i = 2, ShamanBuffBars.db.profile.S_Number do
				local button = getglobal("ShieldButton"..i);
				button:ClearAllPoints();
				button:SetPoint("BOTTOM", "ShieldButton"..i - 1, "TOP", 0, 1);
			end
		elseif (ShamanBuffBars.db.profile.S_Direction == "Horizontal" and ShamanBuffBars.db.profile.S_Reverse == "Normal") then
			for i = 2, ShamanBuffBars.db.profile.S_Number do
				local button = getglobal("ShieldButton"..i);
				button:ClearAllPoints();
				button:SetPoint("LEFT", "ShieldButton"..i - 1, "RIGHT", 1, 0);
			end
		elseif (ShamanBuffBars.db.profile.S_Direction == "Horizontal" and ShamanBuffBars.db.profile.S_Reverse == "Reverse") then
			for i = 2, ShamanBuffBars.db.profile.S_Number do
				local button = getglobal("ShieldButton"..i);
				button:ClearAllPoints();
				button:SetPoint("RIGHT", "ShieldButton"..i - 1, "LEFT", 1, 0);
			end
		else
			for i = 2, ShamanBuffBars.db.profile.S_Number do
				local button = getglobal("ShieldButton"..i);
				button:ClearAllPoints();
				button:SetPoint("LEFT", "ShieldButton"..i - 1, "RIGHT", 1, 0);
			end
		end
	end
	if ShamanBuffBars.db.profile.S_Scale then
		ShieldFrame:SetScale(ShamanBuffBars.db.profile.S_Scale)
	else
		ShieldFrame:SetScale(1)
	end
	if ShamanBuffBars.db.profile.S_Alpha then
		ShieldFrame:SetAlpha(ShamanBuffBars.db.profile.S_Alpha)
	else
		ShieldFrame:SetAlpha(1)
	end
	if (not ShamanBuffBars.db.profile.S_ShowActive) then
		ShamanBuffBars.db.profile.S_ShowActive = True
	end
end

function ShamanBuffBars:UPDATE()
	ShamanBuffBars:W_UPDATE()
	ShamanBuffBars:S_UPDATE()
end

function ShamanBuffBars:W_UPDATE()
	local i, button, p, l;
	if (ShamanBuffBars.db.profile) then
		i = 0;
		-- This function cannot be performed in combat.
		if (InCombatLockdown() == nil) then
			for key in pairs(ShamanBuffBars.db.profile.WeaponList) do
				if getglobal("WeaponButton"..key) then
					getglobal("WeaponButton"..key):Hide();
				end
			end
			ShamanBuffBars:W_SetUp()
			ShamanBuffBars:W_HIDE_ONCE_BUFFED()
			--WeaponFrame:Show();
		end
		for key, value in pairs(ShamanBuffBars.db.profile.WeaponList) do
			local id = ShamanBuffBars:GetSpellID(value);
			if (id) then
				i = i + 1;
 				button = getglobal("WeaponButton"..i);
				-- This function cannot be performed in combat.
        			if (InCombatLockdown() == nil) then
					if button then
						button:SetAttribute("type", "spell");
						button:SetAttribute("spell", value);
					end
				end

  				local texture = GetSpellTexture(id, BOOKTYPE_SPELL);
				
				if button then
					getglobal("WeaponButton"..i.."Icon"):SetTexture(texture);
					button:SetAttribute("id",id);

					-- This function cannot be performed in combat.
					if (InCombatLockdown() == nil) then
						if ( i > ShamanBuffBars.db.profile.W_Number ) then
							button:SetAlpha(0);
							button:Hide();
						else
							button:Show();
							button:SetAlpha(ShamanBuffBars.db.profile.W_Alpha)
						end
					end
				end
			end
		end
		-- This function cannot be performed in combat.
		if ((i == 0) and (InCombatLockdown() == nil)) then
			WeaponFrame:Hide();
		end
	end
end

function ShamanBuffBars:S_UPDATE()
	local i, button, p, l;
	if (ShamanBuffBars.db.profile) then
		i = 0;
		-- This function cannot be performed in combat.
		if (InCombatLockdown() == nil) then
			for key in pairs(ShamanBuffBars.db.profile.ShieldList) do
				if getglobal("ShieldButton"..key) then
					getglobal("ShieldButton"..key):Hide();
				end
			end
			ShamanBuffBars:S_SetUp()
			ShieldFrame:Show();
		end
		for key, value in pairs(ShamanBuffBars.db.profile.ShieldList) do
			local id = ShamanBuffBars:GetSpellID(value);
			if (id) then
				i = i + 1;
 				button = getglobal("ShieldButton"..i);
				-- This function cannot be performed in combat.
        		if (InCombatLockdown() == nil) then
					if button then
						button:SetAttribute("type", "spell");
						button:SetAttribute("spell", value);
					end
				end

  				local texture = GetSpellTexture(id, BOOKTYPE_SPELL);
				if (ShamanBuffBars.db.profile.S_ShowActive) then
					for z = 0, 7 do
						if (GetPlayerBuffTexture(z) == texture) then
							texture = "Interface\\Icons\\Spell_Nature_WispSplode";
						end
					end
				end
				if button then
					getglobal("ShieldButton"..i.."Icon"):SetTexture(texture);
					button:SetAttribute("id",id);

					-- This function cannot be performed in combat.
					if (InCombatLockdown() == nil) then
						if ( i > ShamanBuffBars.db.profile.S_Number ) then
							button:SetAlpha(0);
							button:Hide();
						else
							button:Show();
							button:SetAlpha(ShamanBuffBars.db.profile.S_Alpha)
						end
					end
				end
			end
		end
		-- This function cannot be performed in combat.
		if ((i == 0) and (InCombatLockdown() == nil)) then
			ShieldFrame:Hide();
		end
	end
end

function ShamanBuffBars:SPELL_UPDATE_COOLDOWN()
	ShamanBuffBars:W_SPELL_UPDATE_COOLDOWN()
	ShamanBuffBars:S_SPELL_UPDATE_COOLDOWN()
end

function ShamanBuffBars:W_SPELL_UPDATE_COOLDOWN()
	for i = 1, ShamanBuffBars.db.profile.W_Number do
		button = getglobal("WeaponButton"..i);
		if (button:GetAttribute("id")) then
			local cooldown = getglobal(button:GetName().."Cooldown");
			local start, duration, enable = GetSpellCooldown(button:GetAttribute("id"), SpellBookFrame.bookType);
			if (start > 0 and duration > 0) then
				cooldown:SetCooldown(start, duration);
			end
		end
	end
end

function ShamanBuffBars:S_SPELL_UPDATE_COOLDOWN()
	for i = 1, ShamanBuffBars.db.profile.S_Number do
		button = getglobal("ShieldButton"..i);
		if (button:GetAttribute("id")) then
			local cooldown = getglobal(button:GetName().."Cooldown");
			local start, duration, enable = GetSpellCooldown(button:GetAttribute("id"), SpellBookFrame.bookType);
			if (start > 0 and duration > 0) then
				cooldown:SetCooldown(start, duration);
			end
		end
	end
end

function ShamanBuffBars:W_HIDE_ONCE_BUFFED()
	if (ShamanBuffBars.db.profile.W_HideOnceBuffed) then
		local hasMainHandEnchant,_,_,hasOffHandEnchant = GetWeaponEnchantInfo();
		local hasWeapon = OffhandHasWeapon();

		if hasWeapon then
			if (hasMainHandEnchant and hasOffHandEnchant) then
				WeaponFrame:Hide();
			else
				WeaponFrame:Show();
			end
		else
			if hasMainHandEnchant then
				WeaponFrame:Hide();
			else
				WeaponFrame:Show();
			end
		end
	end
end